// Copyright (c) .NET Foundation. All rights reserved.
// Licensed under the Apache License, Version 2.0. See License.txt in the project root for license information.

using System.Diagnostics.CodeAnalysis;

[assembly: SuppressMessage("Microsoft.Design", "CA1017:MarkAssembliesWithComVisible")]
[assembly: SuppressMessage("Microsoft.Design", "CA2210:AssembliesShouldHaveValidStrongNames")]
[assembly: SuppressMessage("Microsoft.Design", "CA1014:MarkAssembliesWithClsCompliant")]
[assembly: SuppressMessage("Microsoft.Design", "CA1020:AvoidNamespacesWithFewTypes", Scope = "namespace", Target = "NuGetConsole.Implementation")]
[assembly: SuppressMessage("Microsoft.Design", "CA1020:AvoidNamespacesWithFewTypes", Scope = "namespace", Target = "NuGetConsole.Implementation.Console")]
[assembly: SuppressMessage("Microsoft.Design", "CA1020:AvoidNamespacesWithFewTypes", Scope = "namespace", Target = "NuGetConsole.Implementation.PowerConsole")]
[assembly: SuppressMessage("Usage", "VSTHRD110:Observe result of async calls", Justification = "https://github.com/NuGet/Home/issues/7674", Scope = "member", Target = "~M:NuGetConsole.Implementation.Console.ConsoleDispatcher.Start")]
[assembly: SuppressMessage("Usage", "VSTHRD002:Avoid problematic synchronous waits", Justification = "Dispose method", Scope = "member", Target = "~M:NuGetConsole.ChannelOutputConsole.Dispose(System.Boolean)")]
[assembly: SuppressMessage("Build", "CA2213:'WpfConsole' contains field '_marshaler' that is of IDisposable type 'PrivateMarshaler', but it is never disposed. Change the Dispose method on 'WpfConsole' to call Close or Dispose on this field.", Justification = "The Dispose() method on _marshaler is called when the tool window is closed.", Scope = "member", Target = "~F:NuGetConsole.Implementation.Console.WpfConsole._marshaler")]
[assembly: SuppressMessage("Build", "CA2213:'PowerConsoleWindow' contains field '_activeHostInfo' that is of IDisposable type 'HostInfo', but it is never disposed. Change the Dispose method on 'PowerConsoleWindow' to call Close or Dispose on this field.", Justification = "'_activeHostInfo' field holds reference to the first item in '_hostInfos' collection whose items are disposed.", Scope = "member", Target = "~F:NuGetConsole.Implementation.PowerConsole.PowerConsoleWindow._activeHostInfo")]
[assembly: SuppressMessage("Build", "CA1031:Modify 'CloseChannelAsync' to catch a more specific allowed exception type, or rethrow the exception.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGetConsole.ChannelOutputConsole.CloseChannelAsync~System.Threading.Tasks.Task")]
[assembly: SuppressMessage("Build", "CA1031:Modify 'Dispose' to catch a more specific allowed exception type, or rethrow the exception.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGetConsole.ChannelOutputConsole.Dispose(System.Boolean)")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'T CommonExtensionMethods.GetService<T>(IServiceProvider sp, Type serviceType)', validate parameter 'sp' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGetConsole.CommonExtensionMethods.GetService``1(System.IServiceProvider,System.Type)~``0")]
[assembly: SuppressMessage("Build", "CA1303:Method 'void ConsoleDispatcher.Start()' passes a literal string as parameter 'message' of a call to 'InvalidOperationException.InvalidOperationException(string message)'. Retrieve the following string(s) from a resource table instead: \"Can't start Console dispatcher. Host is null.\".", Justification = "<Pending>", Scope = "member", Target = "~M:NuGetConsole.Implementation.Console.ConsoleDispatcher.Start")]
[assembly: SuppressMessage("Build", "CA1031:Modify 'GetTabExpansionTimeout' to catch a more specific allowed exception type, or rethrow the exception.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGetConsole.Implementation.Console.WpfConsoleKeyProcessor.GetTabExpansionTimeout~System.Int32")]
[assembly: SuppressMessage("Build", "CA1031:Modify 'LoadConsoleEditorAsync' to catch a more specific allowed exception type, or rethrow the exception.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGetConsole.Implementation.PowerConsoleToolWindow.LoadConsoleEditorAsync~System.Threading.Tasks.Task")]
[assembly: SuppressMessage("Build", "CA1303:Method 'void PowerConsoleToolWindow.ProjectsList_Exec(object sender, EventArgs e)' passes a literal string as parameter 'message' of a call to 'ArgumentException.ArgumentException(string message, string paramName)'. Retrieve the following string(s) from a resource table instead: \"Invalid argument\".", Justification = "<Pending>", Scope = "member", Target = "~M:NuGetConsole.Implementation.PowerConsoleToolWindow.ProjectsList_Exec(System.Object,System.EventArgs)")]
[assembly: SuppressMessage("Build", "CA1303:Method 'void PowerConsoleToolWindow.SourcesList_Exec(object sender, EventArgs e)' passes a literal string as parameter 'message' of a call to 'ArgumentException.ArgumentException(string message, string paramName)'. Retrieve the following string(s) from a resource table instead: \"Invalid argument\".", Justification = "<Pending>", Scope = "member", Target = "~M:NuGetConsole.Implementation.PowerConsoleToolWindow.SourcesList_Exec(System.Object,System.EventArgs)")]
[assembly: SuppressMessage("Build", "CA1501:'ConsoleContainer' has an object hierarchy '9' levels deep within the defining module. If possible, eliminate base classes within the hierarchy to decrease its hierarchy level below '6': 'UserControl, ContentControl, Control, FrameworkElement, UIElement, Visual, DependencyObject, DispatcherObject, Object'", Justification = "<Pending>", Scope = "type", Target = "~T:NuGetConsole.ConsoleContainer")]
