// This file was generated by gir (https://github.com/gtk-rs/gir)
// from
// from gir-files (https://github.com/gtk-rs/gir-files.git)
// DO NOT EDIT

use crate::ffi;
use glib::{prelude::*, translate::*};

#[cfg(feature = "v1_6")]
#[cfg_attr(docsrs, doc(cfg(feature = "v1_6")))]
#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "AdwAccentColor")]
pub enum AccentColor {
    #[doc(alias = "ADW_ACCENT_COLOR_BLUE")]
    Blue,
    #[doc(alias = "ADW_ACCENT_COLOR_TEAL")]
    Teal,
    #[doc(alias = "ADW_ACCENT_COLOR_GREEN")]
    Green,
    #[doc(alias = "ADW_ACCENT_COLOR_YELLOW")]
    Yellow,
    #[doc(alias = "ADW_ACCENT_COLOR_ORANGE")]
    Orange,
    #[doc(alias = "ADW_ACCENT_COLOR_RED")]
    Red,
    #[doc(alias = "ADW_ACCENT_COLOR_PINK")]
    Pink,
    #[doc(alias = "ADW_ACCENT_COLOR_PURPLE")]
    Purple,
    #[doc(alias = "ADW_ACCENT_COLOR_SLATE")]
    Slate,
    #[doc(hidden)]
    __Unknown(i32),
}

#[cfg(feature = "v1_6")]
#[cfg_attr(docsrs, doc(cfg(feature = "v1_6")))]
impl AccentColor {
    #[doc(alias = "adw_accent_color_to_rgba")]
    pub fn to_rgba(self) -> gdk::RGBA {
        assert_initialized_main_thread!();
        unsafe {
            let mut rgba = gdk::RGBA::uninitialized();
            ffi::adw_accent_color_to_rgba(self.into_glib(), rgba.to_glib_none_mut().0);
            rgba
        }
    }

    #[doc(alias = "adw_accent_color_to_standalone_rgba")]
    pub fn to_standalone_rgba(self, dark: bool) -> gdk::RGBA {
        assert_initialized_main_thread!();
        unsafe {
            let mut rgba = gdk::RGBA::uninitialized();
            ffi::adw_accent_color_to_standalone_rgba(
                self.into_glib(),
                dark.into_glib(),
                rgba.to_glib_none_mut().0,
            );
            rgba
        }
    }
}

#[cfg(feature = "v1_6")]
#[cfg_attr(docsrs, doc(cfg(feature = "v1_6")))]
#[doc(hidden)]
impl IntoGlib for AccentColor {
    type GlibType = ffi::AdwAccentColor;

    #[inline]
    fn into_glib(self) -> ffi::AdwAccentColor {
        match self {
            Self::Blue => ffi::ADW_ACCENT_COLOR_BLUE,
            Self::Teal => ffi::ADW_ACCENT_COLOR_TEAL,
            Self::Green => ffi::ADW_ACCENT_COLOR_GREEN,
            Self::Yellow => ffi::ADW_ACCENT_COLOR_YELLOW,
            Self::Orange => ffi::ADW_ACCENT_COLOR_ORANGE,
            Self::Red => ffi::ADW_ACCENT_COLOR_RED,
            Self::Pink => ffi::ADW_ACCENT_COLOR_PINK,
            Self::Purple => ffi::ADW_ACCENT_COLOR_PURPLE,
            Self::Slate => ffi::ADW_ACCENT_COLOR_SLATE,
            Self::__Unknown(value) => value,
        }
    }
}

#[cfg(feature = "v1_6")]
#[cfg_attr(docsrs, doc(cfg(feature = "v1_6")))]
#[doc(hidden)]
impl FromGlib<ffi::AdwAccentColor> for AccentColor {
    #[inline]
    unsafe fn from_glib(value: ffi::AdwAccentColor) -> Self {
        skip_assert_initialized!();

        match value {
            ffi::ADW_ACCENT_COLOR_BLUE => Self::Blue,
            ffi::ADW_ACCENT_COLOR_TEAL => Self::Teal,
            ffi::ADW_ACCENT_COLOR_GREEN => Self::Green,
            ffi::ADW_ACCENT_COLOR_YELLOW => Self::Yellow,
            ffi::ADW_ACCENT_COLOR_ORANGE => Self::Orange,
            ffi::ADW_ACCENT_COLOR_RED => Self::Red,
            ffi::ADW_ACCENT_COLOR_PINK => Self::Pink,
            ffi::ADW_ACCENT_COLOR_PURPLE => Self::Purple,
            ffi::ADW_ACCENT_COLOR_SLATE => Self::Slate,
            value => Self::__Unknown(value),
        }
    }
}

#[cfg(feature = "v1_6")]
#[cfg_attr(docsrs, doc(cfg(feature = "v1_6")))]
impl StaticType for AccentColor {
    #[inline]
    #[doc(alias = "adw_accent_color_get_type")]
    fn static_type() -> glib::Type {
        unsafe { from_glib(ffi::adw_accent_color_get_type()) }
    }
}

#[cfg(feature = "v1_6")]
#[cfg_attr(docsrs, doc(cfg(feature = "v1_6")))]
impl glib::HasParamSpec for AccentColor {
    type ParamSpec = glib::ParamSpecEnum;
    type SetValue = Self;
    type BuilderFn = fn(&str, Self) -> glib::ParamSpecEnumBuilder<Self>;

    fn param_spec_builder() -> Self::BuilderFn {
        Self::ParamSpec::builder_with_default
    }
}

#[cfg(feature = "v1_6")]
#[cfg_attr(docsrs, doc(cfg(feature = "v1_6")))]
impl glib::value::ValueType for AccentColor {
    type Type = Self;
}

#[cfg(feature = "v1_6")]
#[cfg_attr(docsrs, doc(cfg(feature = "v1_6")))]
unsafe impl<'a> glib::value::FromValue<'a> for AccentColor {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    #[inline]
    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

#[cfg(feature = "v1_6")]
#[cfg_attr(docsrs, doc(cfg(feature = "v1_6")))]
impl ToValue for AccentColor {
    #[inline]
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    #[inline]
    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[cfg(feature = "v1_6")]
#[cfg_attr(docsrs, doc(cfg(feature = "v1_6")))]
impl From<AccentColor> for glib::Value {
    #[inline]
    fn from(v: AccentColor) -> Self {
        skip_assert_initialized!();
        ToValue::to_value(&v)
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "AdwAnimationState")]
pub enum AnimationState {
    #[doc(alias = "ADW_ANIMATION_IDLE")]
    Idle,
    #[doc(alias = "ADW_ANIMATION_PAUSED")]
    Paused,
    #[doc(alias = "ADW_ANIMATION_PLAYING")]
    Playing,
    #[doc(alias = "ADW_ANIMATION_FINISHED")]
    Finished,
    #[doc(hidden)]
    __Unknown(i32),
}

#[doc(hidden)]
impl IntoGlib for AnimationState {
    type GlibType = ffi::AdwAnimationState;

    #[inline]
    fn into_glib(self) -> ffi::AdwAnimationState {
        match self {
            Self::Idle => ffi::ADW_ANIMATION_IDLE,
            Self::Paused => ffi::ADW_ANIMATION_PAUSED,
            Self::Playing => ffi::ADW_ANIMATION_PLAYING,
            Self::Finished => ffi::ADW_ANIMATION_FINISHED,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::AdwAnimationState> for AnimationState {
    #[inline]
    unsafe fn from_glib(value: ffi::AdwAnimationState) -> Self {
        skip_assert_initialized!();

        match value {
            ffi::ADW_ANIMATION_IDLE => Self::Idle,
            ffi::ADW_ANIMATION_PAUSED => Self::Paused,
            ffi::ADW_ANIMATION_PLAYING => Self::Playing,
            ffi::ADW_ANIMATION_FINISHED => Self::Finished,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for AnimationState {
    #[inline]
    #[doc(alias = "adw_animation_state_get_type")]
    fn static_type() -> glib::Type {
        unsafe { from_glib(ffi::adw_animation_state_get_type()) }
    }
}

impl glib::HasParamSpec for AnimationState {
    type ParamSpec = glib::ParamSpecEnum;
    type SetValue = Self;
    type BuilderFn = fn(&str, Self) -> glib::ParamSpecEnumBuilder<Self>;

    fn param_spec_builder() -> Self::BuilderFn {
        Self::ParamSpec::builder_with_default
    }
}

impl glib::value::ValueType for AnimationState {
    type Type = Self;
}

unsafe impl<'a> glib::value::FromValue<'a> for AnimationState {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    #[inline]
    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for AnimationState {
    #[inline]
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    #[inline]
    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

impl From<AnimationState> for glib::Value {
    #[inline]
    fn from(v: AnimationState) -> Self {
        skip_assert_initialized!();
        ToValue::to_value(&v)
    }
}

#[cfg(feature = "v1_7")]
#[cfg_attr(docsrs, doc(cfg(feature = "v1_7")))]
#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "AdwBannerButtonStyle")]
pub enum BannerButtonStyle {
    #[doc(alias = "ADW_BANNER_BUTTON_DEFAULT")]
    Default,
    #[doc(alias = "ADW_BANNER_BUTTON_SUGGESTED")]
    Suggested,
    #[doc(hidden)]
    __Unknown(i32),
}

#[cfg(feature = "v1_7")]
#[cfg_attr(docsrs, doc(cfg(feature = "v1_7")))]
#[doc(hidden)]
impl IntoGlib for BannerButtonStyle {
    type GlibType = ffi::AdwBannerButtonStyle;

    #[inline]
    fn into_glib(self) -> ffi::AdwBannerButtonStyle {
        match self {
            Self::Default => ffi::ADW_BANNER_BUTTON_DEFAULT,
            Self::Suggested => ffi::ADW_BANNER_BUTTON_SUGGESTED,
            Self::__Unknown(value) => value,
        }
    }
}

#[cfg(feature = "v1_7")]
#[cfg_attr(docsrs, doc(cfg(feature = "v1_7")))]
#[doc(hidden)]
impl FromGlib<ffi::AdwBannerButtonStyle> for BannerButtonStyle {
    #[inline]
    unsafe fn from_glib(value: ffi::AdwBannerButtonStyle) -> Self {
        skip_assert_initialized!();

        match value {
            ffi::ADW_BANNER_BUTTON_DEFAULT => Self::Default,
            ffi::ADW_BANNER_BUTTON_SUGGESTED => Self::Suggested,
            value => Self::__Unknown(value),
        }
    }
}

#[cfg(feature = "v1_7")]
#[cfg_attr(docsrs, doc(cfg(feature = "v1_7")))]
impl StaticType for BannerButtonStyle {
    #[inline]
    #[doc(alias = "adw_banner_button_style_get_type")]
    fn static_type() -> glib::Type {
        unsafe { from_glib(ffi::adw_banner_button_style_get_type()) }
    }
}

#[cfg(feature = "v1_7")]
#[cfg_attr(docsrs, doc(cfg(feature = "v1_7")))]
impl glib::HasParamSpec for BannerButtonStyle {
    type ParamSpec = glib::ParamSpecEnum;
    type SetValue = Self;
    type BuilderFn = fn(&str, Self) -> glib::ParamSpecEnumBuilder<Self>;

    fn param_spec_builder() -> Self::BuilderFn {
        Self::ParamSpec::builder_with_default
    }
}

#[cfg(feature = "v1_7")]
#[cfg_attr(docsrs, doc(cfg(feature = "v1_7")))]
impl glib::value::ValueType for BannerButtonStyle {
    type Type = Self;
}

#[cfg(feature = "v1_7")]
#[cfg_attr(docsrs, doc(cfg(feature = "v1_7")))]
unsafe impl<'a> glib::value::FromValue<'a> for BannerButtonStyle {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    #[inline]
    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

#[cfg(feature = "v1_7")]
#[cfg_attr(docsrs, doc(cfg(feature = "v1_7")))]
impl ToValue for BannerButtonStyle {
    #[inline]
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    #[inline]
    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[cfg(feature = "v1_7")]
#[cfg_attr(docsrs, doc(cfg(feature = "v1_7")))]
impl From<BannerButtonStyle> for glib::Value {
    #[inline]
    fn from(v: BannerButtonStyle) -> Self {
        skip_assert_initialized!();
        ToValue::to_value(&v)
    }
}

#[cfg(feature = "v1_4")]
#[cfg_attr(docsrs, doc(cfg(feature = "v1_4")))]
#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "AdwBreakpointConditionLengthType")]
pub enum BreakpointConditionLengthType {
    #[doc(alias = "ADW_BREAKPOINT_CONDITION_MIN_WIDTH")]
    MinWidth,
    #[doc(alias = "ADW_BREAKPOINT_CONDITION_MAX_WIDTH")]
    MaxWidth,
    #[doc(alias = "ADW_BREAKPOINT_CONDITION_MIN_HEIGHT")]
    MinHeight,
    #[doc(alias = "ADW_BREAKPOINT_CONDITION_MAX_HEIGHT")]
    MaxHeight,
    #[doc(hidden)]
    __Unknown(i32),
}

#[cfg(feature = "v1_4")]
#[cfg_attr(docsrs, doc(cfg(feature = "v1_4")))]
#[doc(hidden)]
impl IntoGlib for BreakpointConditionLengthType {
    type GlibType = ffi::AdwBreakpointConditionLengthType;

    #[inline]
    fn into_glib(self) -> ffi::AdwBreakpointConditionLengthType {
        match self {
            Self::MinWidth => ffi::ADW_BREAKPOINT_CONDITION_MIN_WIDTH,
            Self::MaxWidth => ffi::ADW_BREAKPOINT_CONDITION_MAX_WIDTH,
            Self::MinHeight => ffi::ADW_BREAKPOINT_CONDITION_MIN_HEIGHT,
            Self::MaxHeight => ffi::ADW_BREAKPOINT_CONDITION_MAX_HEIGHT,
            Self::__Unknown(value) => value,
        }
    }
}

#[cfg(feature = "v1_4")]
#[cfg_attr(docsrs, doc(cfg(feature = "v1_4")))]
#[doc(hidden)]
impl FromGlib<ffi::AdwBreakpointConditionLengthType> for BreakpointConditionLengthType {
    #[inline]
    unsafe fn from_glib(value: ffi::AdwBreakpointConditionLengthType) -> Self {
        skip_assert_initialized!();

        match value {
            ffi::ADW_BREAKPOINT_CONDITION_MIN_WIDTH => Self::MinWidth,
            ffi::ADW_BREAKPOINT_CONDITION_MAX_WIDTH => Self::MaxWidth,
            ffi::ADW_BREAKPOINT_CONDITION_MIN_HEIGHT => Self::MinHeight,
            ffi::ADW_BREAKPOINT_CONDITION_MAX_HEIGHT => Self::MaxHeight,
            value => Self::__Unknown(value),
        }
    }
}

#[cfg(feature = "v1_4")]
#[cfg_attr(docsrs, doc(cfg(feature = "v1_4")))]
impl StaticType for BreakpointConditionLengthType {
    #[inline]
    #[doc(alias = "adw_breakpoint_condition_length_type_get_type")]
    fn static_type() -> glib::Type {
        unsafe { from_glib(ffi::adw_breakpoint_condition_length_type_get_type()) }
    }
}

#[cfg(feature = "v1_4")]
#[cfg_attr(docsrs, doc(cfg(feature = "v1_4")))]
impl glib::HasParamSpec for BreakpointConditionLengthType {
    type ParamSpec = glib::ParamSpecEnum;
    type SetValue = Self;
    type BuilderFn = fn(&str, Self) -> glib::ParamSpecEnumBuilder<Self>;

    fn param_spec_builder() -> Self::BuilderFn {
        Self::ParamSpec::builder_with_default
    }
}

#[cfg(feature = "v1_4")]
#[cfg_attr(docsrs, doc(cfg(feature = "v1_4")))]
impl glib::value::ValueType for BreakpointConditionLengthType {
    type Type = Self;
}

#[cfg(feature = "v1_4")]
#[cfg_attr(docsrs, doc(cfg(feature = "v1_4")))]
unsafe impl<'a> glib::value::FromValue<'a> for BreakpointConditionLengthType {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    #[inline]
    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

#[cfg(feature = "v1_4")]
#[cfg_attr(docsrs, doc(cfg(feature = "v1_4")))]
impl ToValue for BreakpointConditionLengthType {
    #[inline]
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    #[inline]
    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[cfg(feature = "v1_4")]
#[cfg_attr(docsrs, doc(cfg(feature = "v1_4")))]
impl From<BreakpointConditionLengthType> for glib::Value {
    #[inline]
    fn from(v: BreakpointConditionLengthType) -> Self {
        skip_assert_initialized!();
        ToValue::to_value(&v)
    }
}

#[cfg(feature = "v1_4")]
#[cfg_attr(docsrs, doc(cfg(feature = "v1_4")))]
#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "AdwBreakpointConditionRatioType")]
pub enum BreakpointConditionRatioType {
    #[doc(alias = "ADW_BREAKPOINT_CONDITION_MIN_ASPECT_RATIO")]
    MinAspectRatio,
    #[doc(alias = "ADW_BREAKPOINT_CONDITION_MAX_ASPECT_RATIO")]
    MaxAspectRatio,
    #[doc(hidden)]
    __Unknown(i32),
}

#[cfg(feature = "v1_4")]
#[cfg_attr(docsrs, doc(cfg(feature = "v1_4")))]
#[doc(hidden)]
impl IntoGlib for BreakpointConditionRatioType {
    type GlibType = ffi::AdwBreakpointConditionRatioType;

    #[inline]
    fn into_glib(self) -> ffi::AdwBreakpointConditionRatioType {
        match self {
            Self::MinAspectRatio => ffi::ADW_BREAKPOINT_CONDITION_MIN_ASPECT_RATIO,
            Self::MaxAspectRatio => ffi::ADW_BREAKPOINT_CONDITION_MAX_ASPECT_RATIO,
            Self::__Unknown(value) => value,
        }
    }
}

#[cfg(feature = "v1_4")]
#[cfg_attr(docsrs, doc(cfg(feature = "v1_4")))]
#[doc(hidden)]
impl FromGlib<ffi::AdwBreakpointConditionRatioType> for BreakpointConditionRatioType {
    #[inline]
    unsafe fn from_glib(value: ffi::AdwBreakpointConditionRatioType) -> Self {
        skip_assert_initialized!();

        match value {
            ffi::ADW_BREAKPOINT_CONDITION_MIN_ASPECT_RATIO => Self::MinAspectRatio,
            ffi::ADW_BREAKPOINT_CONDITION_MAX_ASPECT_RATIO => Self::MaxAspectRatio,
            value => Self::__Unknown(value),
        }
    }
}

#[cfg(feature = "v1_4")]
#[cfg_attr(docsrs, doc(cfg(feature = "v1_4")))]
impl StaticType for BreakpointConditionRatioType {
    #[inline]
    #[doc(alias = "adw_breakpoint_condition_ratio_type_get_type")]
    fn static_type() -> glib::Type {
        unsafe { from_glib(ffi::adw_breakpoint_condition_ratio_type_get_type()) }
    }
}

#[cfg(feature = "v1_4")]
#[cfg_attr(docsrs, doc(cfg(feature = "v1_4")))]
impl glib::HasParamSpec for BreakpointConditionRatioType {
    type ParamSpec = glib::ParamSpecEnum;
    type SetValue = Self;
    type BuilderFn = fn(&str, Self) -> glib::ParamSpecEnumBuilder<Self>;

    fn param_spec_builder() -> Self::BuilderFn {
        Self::ParamSpec::builder_with_default
    }
}

#[cfg(feature = "v1_4")]
#[cfg_attr(docsrs, doc(cfg(feature = "v1_4")))]
impl glib::value::ValueType for BreakpointConditionRatioType {
    type Type = Self;
}

#[cfg(feature = "v1_4")]
#[cfg_attr(docsrs, doc(cfg(feature = "v1_4")))]
unsafe impl<'a> glib::value::FromValue<'a> for BreakpointConditionRatioType {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    #[inline]
    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

#[cfg(feature = "v1_4")]
#[cfg_attr(docsrs, doc(cfg(feature = "v1_4")))]
impl ToValue for BreakpointConditionRatioType {
    #[inline]
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    #[inline]
    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[cfg(feature = "v1_4")]
#[cfg_attr(docsrs, doc(cfg(feature = "v1_4")))]
impl From<BreakpointConditionRatioType> for glib::Value {
    #[inline]
    fn from(v: BreakpointConditionRatioType) -> Self {
        skip_assert_initialized!();
        ToValue::to_value(&v)
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "AdwCenteringPolicy")]
pub enum CenteringPolicy {
    #[doc(alias = "ADW_CENTERING_POLICY_LOOSE")]
    Loose,
    #[doc(alias = "ADW_CENTERING_POLICY_STRICT")]
    Strict,
    #[doc(hidden)]
    __Unknown(i32),
}

#[doc(hidden)]
impl IntoGlib for CenteringPolicy {
    type GlibType = ffi::AdwCenteringPolicy;

    #[inline]
    fn into_glib(self) -> ffi::AdwCenteringPolicy {
        match self {
            Self::Loose => ffi::ADW_CENTERING_POLICY_LOOSE,
            Self::Strict => ffi::ADW_CENTERING_POLICY_STRICT,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::AdwCenteringPolicy> for CenteringPolicy {
    #[inline]
    unsafe fn from_glib(value: ffi::AdwCenteringPolicy) -> Self {
        skip_assert_initialized!();

        match value {
            ffi::ADW_CENTERING_POLICY_LOOSE => Self::Loose,
            ffi::ADW_CENTERING_POLICY_STRICT => Self::Strict,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for CenteringPolicy {
    #[inline]
    #[doc(alias = "adw_centering_policy_get_type")]
    fn static_type() -> glib::Type {
        unsafe { from_glib(ffi::adw_centering_policy_get_type()) }
    }
}

impl glib::HasParamSpec for CenteringPolicy {
    type ParamSpec = glib::ParamSpecEnum;
    type SetValue = Self;
    type BuilderFn = fn(&str, Self) -> glib::ParamSpecEnumBuilder<Self>;

    fn param_spec_builder() -> Self::BuilderFn {
        Self::ParamSpec::builder_with_default
    }
}

impl glib::value::ValueType for CenteringPolicy {
    type Type = Self;
}

unsafe impl<'a> glib::value::FromValue<'a> for CenteringPolicy {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    #[inline]
    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for CenteringPolicy {
    #[inline]
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    #[inline]
    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

impl From<CenteringPolicy> for glib::Value {
    #[inline]
    fn from(v: CenteringPolicy) -> Self {
        skip_assert_initialized!();
        ToValue::to_value(&v)
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "AdwColorScheme")]
pub enum ColorScheme {
    #[doc(alias = "ADW_COLOR_SCHEME_DEFAULT")]
    Default,
    #[doc(alias = "ADW_COLOR_SCHEME_FORCE_LIGHT")]
    ForceLight,
    #[doc(alias = "ADW_COLOR_SCHEME_PREFER_LIGHT")]
    PreferLight,
    #[doc(alias = "ADW_COLOR_SCHEME_PREFER_DARK")]
    PreferDark,
    #[doc(alias = "ADW_COLOR_SCHEME_FORCE_DARK")]
    ForceDark,
    #[doc(hidden)]
    __Unknown(i32),
}

#[doc(hidden)]
impl IntoGlib for ColorScheme {
    type GlibType = ffi::AdwColorScheme;

    #[inline]
    fn into_glib(self) -> ffi::AdwColorScheme {
        match self {
            Self::Default => ffi::ADW_COLOR_SCHEME_DEFAULT,
            Self::ForceLight => ffi::ADW_COLOR_SCHEME_FORCE_LIGHT,
            Self::PreferLight => ffi::ADW_COLOR_SCHEME_PREFER_LIGHT,
            Self::PreferDark => ffi::ADW_COLOR_SCHEME_PREFER_DARK,
            Self::ForceDark => ffi::ADW_COLOR_SCHEME_FORCE_DARK,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::AdwColorScheme> for ColorScheme {
    #[inline]
    unsafe fn from_glib(value: ffi::AdwColorScheme) -> Self {
        skip_assert_initialized!();

        match value {
            ffi::ADW_COLOR_SCHEME_DEFAULT => Self::Default,
            ffi::ADW_COLOR_SCHEME_FORCE_LIGHT => Self::ForceLight,
            ffi::ADW_COLOR_SCHEME_PREFER_LIGHT => Self::PreferLight,
            ffi::ADW_COLOR_SCHEME_PREFER_DARK => Self::PreferDark,
            ffi::ADW_COLOR_SCHEME_FORCE_DARK => Self::ForceDark,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for ColorScheme {
    #[inline]
    #[doc(alias = "adw_color_scheme_get_type")]
    fn static_type() -> glib::Type {
        unsafe { from_glib(ffi::adw_color_scheme_get_type()) }
    }
}

impl glib::HasParamSpec for ColorScheme {
    type ParamSpec = glib::ParamSpecEnum;
    type SetValue = Self;
    type BuilderFn = fn(&str, Self) -> glib::ParamSpecEnumBuilder<Self>;

    fn param_spec_builder() -> Self::BuilderFn {
        Self::ParamSpec::builder_with_default
    }
}

impl glib::value::ValueType for ColorScheme {
    type Type = Self;
}

unsafe impl<'a> glib::value::FromValue<'a> for ColorScheme {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    #[inline]
    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for ColorScheme {
    #[inline]
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    #[inline]
    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

impl From<ColorScheme> for glib::Value {
    #[inline]
    fn from(v: ColorScheme) -> Self {
        skip_assert_initialized!();
        ToValue::to_value(&v)
    }
}

#[cfg(feature = "v1_5")]
#[cfg_attr(docsrs, doc(cfg(feature = "v1_5")))]
#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "AdwDialogPresentationMode")]
pub enum DialogPresentationMode {
    #[doc(alias = "ADW_DIALOG_AUTO")]
    Auto,
    #[doc(alias = "ADW_DIALOG_FLOATING")]
    Floating,
    #[doc(alias = "ADW_DIALOG_BOTTOM_SHEET")]
    BottomSheet,
    #[doc(hidden)]
    __Unknown(i32),
}

#[cfg(feature = "v1_5")]
#[cfg_attr(docsrs, doc(cfg(feature = "v1_5")))]
#[doc(hidden)]
impl IntoGlib for DialogPresentationMode {
    type GlibType = ffi::AdwDialogPresentationMode;

    #[inline]
    fn into_glib(self) -> ffi::AdwDialogPresentationMode {
        match self {
            Self::Auto => ffi::ADW_DIALOG_AUTO,
            Self::Floating => ffi::ADW_DIALOG_FLOATING,
            Self::BottomSheet => ffi::ADW_DIALOG_BOTTOM_SHEET,
            Self::__Unknown(value) => value,
        }
    }
}

#[cfg(feature = "v1_5")]
#[cfg_attr(docsrs, doc(cfg(feature = "v1_5")))]
#[doc(hidden)]
impl FromGlib<ffi::AdwDialogPresentationMode> for DialogPresentationMode {
    #[inline]
    unsafe fn from_glib(value: ffi::AdwDialogPresentationMode) -> Self {
        skip_assert_initialized!();

        match value {
            ffi::ADW_DIALOG_AUTO => Self::Auto,
            ffi::ADW_DIALOG_FLOATING => Self::Floating,
            ffi::ADW_DIALOG_BOTTOM_SHEET => Self::BottomSheet,
            value => Self::__Unknown(value),
        }
    }
}

#[cfg(feature = "v1_5")]
#[cfg_attr(docsrs, doc(cfg(feature = "v1_5")))]
impl StaticType for DialogPresentationMode {
    #[inline]
    #[doc(alias = "adw_dialog_presentation_mode_get_type")]
    fn static_type() -> glib::Type {
        unsafe { from_glib(ffi::adw_dialog_presentation_mode_get_type()) }
    }
}

#[cfg(feature = "v1_5")]
#[cfg_attr(docsrs, doc(cfg(feature = "v1_5")))]
impl glib::HasParamSpec for DialogPresentationMode {
    type ParamSpec = glib::ParamSpecEnum;
    type SetValue = Self;
    type BuilderFn = fn(&str, Self) -> glib::ParamSpecEnumBuilder<Self>;

    fn param_spec_builder() -> Self::BuilderFn {
        Self::ParamSpec::builder_with_default
    }
}

#[cfg(feature = "v1_5")]
#[cfg_attr(docsrs, doc(cfg(feature = "v1_5")))]
impl glib::value::ValueType for DialogPresentationMode {
    type Type = Self;
}

#[cfg(feature = "v1_5")]
#[cfg_attr(docsrs, doc(cfg(feature = "v1_5")))]
unsafe impl<'a> glib::value::FromValue<'a> for DialogPresentationMode {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    #[inline]
    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

#[cfg(feature = "v1_5")]
#[cfg_attr(docsrs, doc(cfg(feature = "v1_5")))]
impl ToValue for DialogPresentationMode {
    #[inline]
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    #[inline]
    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[cfg(feature = "v1_5")]
#[cfg_attr(docsrs, doc(cfg(feature = "v1_5")))]
impl From<DialogPresentationMode> for glib::Value {
    #[inline]
    fn from(v: DialogPresentationMode) -> Self {
        skip_assert_initialized!();
        ToValue::to_value(&v)
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "AdwEasing")]
pub enum Easing {
    #[doc(alias = "ADW_LINEAR")]
    Linear,
    #[doc(alias = "ADW_EASE_IN_QUAD")]
    EaseInQuad,
    #[doc(alias = "ADW_EASE_OUT_QUAD")]
    EaseOutQuad,
    #[doc(alias = "ADW_EASE_IN_OUT_QUAD")]
    EaseInOutQuad,
    #[doc(alias = "ADW_EASE_IN_CUBIC")]
    EaseInCubic,
    #[doc(alias = "ADW_EASE_OUT_CUBIC")]
    EaseOutCubic,
    #[doc(alias = "ADW_EASE_IN_OUT_CUBIC")]
    EaseInOutCubic,
    #[doc(alias = "ADW_EASE_IN_QUART")]
    EaseInQuart,
    #[doc(alias = "ADW_EASE_OUT_QUART")]
    EaseOutQuart,
    #[doc(alias = "ADW_EASE_IN_OUT_QUART")]
    EaseInOutQuart,
    #[doc(alias = "ADW_EASE_IN_QUINT")]
    EaseInQuint,
    #[doc(alias = "ADW_EASE_OUT_QUINT")]
    EaseOutQuint,
    #[doc(alias = "ADW_EASE_IN_OUT_QUINT")]
    EaseInOutQuint,
    #[doc(alias = "ADW_EASE_IN_SINE")]
    EaseInSine,
    #[doc(alias = "ADW_EASE_OUT_SINE")]
    EaseOutSine,
    #[doc(alias = "ADW_EASE_IN_OUT_SINE")]
    EaseInOutSine,
    #[doc(alias = "ADW_EASE_IN_EXPO")]
    EaseInExpo,
    #[doc(alias = "ADW_EASE_OUT_EXPO")]
    EaseOutExpo,
    #[doc(alias = "ADW_EASE_IN_OUT_EXPO")]
    EaseInOutExpo,
    #[doc(alias = "ADW_EASE_IN_CIRC")]
    EaseInCirc,
    #[doc(alias = "ADW_EASE_OUT_CIRC")]
    EaseOutCirc,
    #[doc(alias = "ADW_EASE_IN_OUT_CIRC")]
    EaseInOutCirc,
    #[doc(alias = "ADW_EASE_IN_ELASTIC")]
    EaseInElastic,
    #[doc(alias = "ADW_EASE_OUT_ELASTIC")]
    EaseOutElastic,
    #[doc(alias = "ADW_EASE_IN_OUT_ELASTIC")]
    EaseInOutElastic,
    #[doc(alias = "ADW_EASE_IN_BACK")]
    EaseInBack,
    #[doc(alias = "ADW_EASE_OUT_BACK")]
    EaseOutBack,
    #[doc(alias = "ADW_EASE_IN_OUT_BACK")]
    EaseInOutBack,
    #[doc(alias = "ADW_EASE_IN_BOUNCE")]
    EaseInBounce,
    #[doc(alias = "ADW_EASE_OUT_BOUNCE")]
    EaseOutBounce,
    #[doc(alias = "ADW_EASE_IN_OUT_BOUNCE")]
    EaseInOutBounce,
    #[cfg(feature = "v1_7")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_7")))]
    #[doc(alias = "ADW_EASE")]
    Ease,
    #[cfg(feature = "v1_7")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_7")))]
    #[doc(alias = "ADW_EASE_IN")]
    EaseIn,
    #[cfg(feature = "v1_7")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_7")))]
    #[doc(alias = "ADW_EASE_OUT")]
    EaseOut,
    #[cfg(feature = "v1_7")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_7")))]
    #[doc(alias = "ADW_EASE_IN_OUT")]
    EaseInOut,
    #[doc(hidden)]
    __Unknown(i32),
}

impl Easing {
    #[doc(alias = "adw_easing_ease")]
    pub fn ease(self, value: f64) -> f64 {
        assert_initialized_main_thread!();
        unsafe { ffi::adw_easing_ease(self.into_glib(), value) }
    }
}

#[doc(hidden)]
impl IntoGlib for Easing {
    type GlibType = ffi::AdwEasing;

    fn into_glib(self) -> ffi::AdwEasing {
        match self {
            Self::Linear => ffi::ADW_LINEAR,
            Self::EaseInQuad => ffi::ADW_EASE_IN_QUAD,
            Self::EaseOutQuad => ffi::ADW_EASE_OUT_QUAD,
            Self::EaseInOutQuad => ffi::ADW_EASE_IN_OUT_QUAD,
            Self::EaseInCubic => ffi::ADW_EASE_IN_CUBIC,
            Self::EaseOutCubic => ffi::ADW_EASE_OUT_CUBIC,
            Self::EaseInOutCubic => ffi::ADW_EASE_IN_OUT_CUBIC,
            Self::EaseInQuart => ffi::ADW_EASE_IN_QUART,
            Self::EaseOutQuart => ffi::ADW_EASE_OUT_QUART,
            Self::EaseInOutQuart => ffi::ADW_EASE_IN_OUT_QUART,
            Self::EaseInQuint => ffi::ADW_EASE_IN_QUINT,
            Self::EaseOutQuint => ffi::ADW_EASE_OUT_QUINT,
            Self::EaseInOutQuint => ffi::ADW_EASE_IN_OUT_QUINT,
            Self::EaseInSine => ffi::ADW_EASE_IN_SINE,
            Self::EaseOutSine => ffi::ADW_EASE_OUT_SINE,
            Self::EaseInOutSine => ffi::ADW_EASE_IN_OUT_SINE,
            Self::EaseInExpo => ffi::ADW_EASE_IN_EXPO,
            Self::EaseOutExpo => ffi::ADW_EASE_OUT_EXPO,
            Self::EaseInOutExpo => ffi::ADW_EASE_IN_OUT_EXPO,
            Self::EaseInCirc => ffi::ADW_EASE_IN_CIRC,
            Self::EaseOutCirc => ffi::ADW_EASE_OUT_CIRC,
            Self::EaseInOutCirc => ffi::ADW_EASE_IN_OUT_CIRC,
            Self::EaseInElastic => ffi::ADW_EASE_IN_ELASTIC,
            Self::EaseOutElastic => ffi::ADW_EASE_OUT_ELASTIC,
            Self::EaseInOutElastic => ffi::ADW_EASE_IN_OUT_ELASTIC,
            Self::EaseInBack => ffi::ADW_EASE_IN_BACK,
            Self::EaseOutBack => ffi::ADW_EASE_OUT_BACK,
            Self::EaseInOutBack => ffi::ADW_EASE_IN_OUT_BACK,
            Self::EaseInBounce => ffi::ADW_EASE_IN_BOUNCE,
            Self::EaseOutBounce => ffi::ADW_EASE_OUT_BOUNCE,
            Self::EaseInOutBounce => ffi::ADW_EASE_IN_OUT_BOUNCE,
            #[cfg(feature = "v1_7")]
            Self::Ease => ffi::ADW_EASE,
            #[cfg(feature = "v1_7")]
            Self::EaseIn => ffi::ADW_EASE_IN,
            #[cfg(feature = "v1_7")]
            Self::EaseOut => ffi::ADW_EASE_OUT,
            #[cfg(feature = "v1_7")]
            Self::EaseInOut => ffi::ADW_EASE_IN_OUT,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::AdwEasing> for Easing {
    unsafe fn from_glib(value: ffi::AdwEasing) -> Self {
        skip_assert_initialized!();

        match value {
            ffi::ADW_LINEAR => Self::Linear,
            ffi::ADW_EASE_IN_QUAD => Self::EaseInQuad,
            ffi::ADW_EASE_OUT_QUAD => Self::EaseOutQuad,
            ffi::ADW_EASE_IN_OUT_QUAD => Self::EaseInOutQuad,
            ffi::ADW_EASE_IN_CUBIC => Self::EaseInCubic,
            ffi::ADW_EASE_OUT_CUBIC => Self::EaseOutCubic,
            ffi::ADW_EASE_IN_OUT_CUBIC => Self::EaseInOutCubic,
            ffi::ADW_EASE_IN_QUART => Self::EaseInQuart,
            ffi::ADW_EASE_OUT_QUART => Self::EaseOutQuart,
            ffi::ADW_EASE_IN_OUT_QUART => Self::EaseInOutQuart,
            ffi::ADW_EASE_IN_QUINT => Self::EaseInQuint,
            ffi::ADW_EASE_OUT_QUINT => Self::EaseOutQuint,
            ffi::ADW_EASE_IN_OUT_QUINT => Self::EaseInOutQuint,
            ffi::ADW_EASE_IN_SINE => Self::EaseInSine,
            ffi::ADW_EASE_OUT_SINE => Self::EaseOutSine,
            ffi::ADW_EASE_IN_OUT_SINE => Self::EaseInOutSine,
            ffi::ADW_EASE_IN_EXPO => Self::EaseInExpo,
            ffi::ADW_EASE_OUT_EXPO => Self::EaseOutExpo,
            ffi::ADW_EASE_IN_OUT_EXPO => Self::EaseInOutExpo,
            ffi::ADW_EASE_IN_CIRC => Self::EaseInCirc,
            ffi::ADW_EASE_OUT_CIRC => Self::EaseOutCirc,
            ffi::ADW_EASE_IN_OUT_CIRC => Self::EaseInOutCirc,
            ffi::ADW_EASE_IN_ELASTIC => Self::EaseInElastic,
            ffi::ADW_EASE_OUT_ELASTIC => Self::EaseOutElastic,
            ffi::ADW_EASE_IN_OUT_ELASTIC => Self::EaseInOutElastic,
            ffi::ADW_EASE_IN_BACK => Self::EaseInBack,
            ffi::ADW_EASE_OUT_BACK => Self::EaseOutBack,
            ffi::ADW_EASE_IN_OUT_BACK => Self::EaseInOutBack,
            ffi::ADW_EASE_IN_BOUNCE => Self::EaseInBounce,
            ffi::ADW_EASE_OUT_BOUNCE => Self::EaseOutBounce,
            ffi::ADW_EASE_IN_OUT_BOUNCE => Self::EaseInOutBounce,
            #[cfg(feature = "v1_7")]
            ffi::ADW_EASE => Self::Ease,
            #[cfg(feature = "v1_7")]
            ffi::ADW_EASE_IN => Self::EaseIn,
            #[cfg(feature = "v1_7")]
            ffi::ADW_EASE_OUT => Self::EaseOut,
            #[cfg(feature = "v1_7")]
            ffi::ADW_EASE_IN_OUT => Self::EaseInOut,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for Easing {
    #[inline]
    #[doc(alias = "adw_easing_get_type")]
    fn static_type() -> glib::Type {
        unsafe { from_glib(ffi::adw_easing_get_type()) }
    }
}

impl glib::HasParamSpec for Easing {
    type ParamSpec = glib::ParamSpecEnum;
    type SetValue = Self;
    type BuilderFn = fn(&str, Self) -> glib::ParamSpecEnumBuilder<Self>;

    fn param_spec_builder() -> Self::BuilderFn {
        Self::ParamSpec::builder_with_default
    }
}

impl glib::value::ValueType for Easing {
    type Type = Self;
}

unsafe impl<'a> glib::value::FromValue<'a> for Easing {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    #[inline]
    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for Easing {
    #[inline]
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    #[inline]
    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

impl From<Easing> for glib::Value {
    #[inline]
    fn from(v: Easing) -> Self {
        skip_assert_initialized!();
        ToValue::to_value(&v)
    }
}

#[cfg_attr(feature = "v1_4", deprecated = "Since 1.4")]
#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "AdwFlapFoldPolicy")]
pub enum FlapFoldPolicy {
    #[doc(alias = "ADW_FLAP_FOLD_POLICY_NEVER")]
    Never,
    #[doc(alias = "ADW_FLAP_FOLD_POLICY_ALWAYS")]
    Always,
    #[doc(alias = "ADW_FLAP_FOLD_POLICY_AUTO")]
    Auto,
    #[doc(hidden)]
    __Unknown(i32),
}

#[allow(deprecated)]
#[doc(hidden)]
impl IntoGlib for FlapFoldPolicy {
    type GlibType = ffi::AdwFlapFoldPolicy;

    #[inline]
    fn into_glib(self) -> ffi::AdwFlapFoldPolicy {
        match self {
            Self::Never => ffi::ADW_FLAP_FOLD_POLICY_NEVER,
            Self::Always => ffi::ADW_FLAP_FOLD_POLICY_ALWAYS,
            Self::Auto => ffi::ADW_FLAP_FOLD_POLICY_AUTO,
            Self::__Unknown(value) => value,
        }
    }
}

#[allow(deprecated)]
#[doc(hidden)]
impl FromGlib<ffi::AdwFlapFoldPolicy> for FlapFoldPolicy {
    #[inline]
    unsafe fn from_glib(value: ffi::AdwFlapFoldPolicy) -> Self {
        skip_assert_initialized!();

        match value {
            ffi::ADW_FLAP_FOLD_POLICY_NEVER => Self::Never,
            ffi::ADW_FLAP_FOLD_POLICY_ALWAYS => Self::Always,
            ffi::ADW_FLAP_FOLD_POLICY_AUTO => Self::Auto,
            value => Self::__Unknown(value),
        }
    }
}

#[allow(deprecated)]
impl StaticType for FlapFoldPolicy {
    #[inline]
    #[doc(alias = "adw_flap_fold_policy_get_type")]
    fn static_type() -> glib::Type {
        unsafe { from_glib(ffi::adw_flap_fold_policy_get_type()) }
    }
}

#[allow(deprecated)]
impl glib::HasParamSpec for FlapFoldPolicy {
    type ParamSpec = glib::ParamSpecEnum;
    type SetValue = Self;
    type BuilderFn = fn(&str, Self) -> glib::ParamSpecEnumBuilder<Self>;

    fn param_spec_builder() -> Self::BuilderFn {
        Self::ParamSpec::builder_with_default
    }
}

#[allow(deprecated)]
impl glib::value::ValueType for FlapFoldPolicy {
    type Type = Self;
}

#[allow(deprecated)]
unsafe impl<'a> glib::value::FromValue<'a> for FlapFoldPolicy {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    #[inline]
    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

#[allow(deprecated)]
impl ToValue for FlapFoldPolicy {
    #[inline]
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    #[inline]
    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[allow(deprecated)]
impl From<FlapFoldPolicy> for glib::Value {
    #[inline]
    fn from(v: FlapFoldPolicy) -> Self {
        skip_assert_initialized!();
        ToValue::to_value(&v)
    }
}

#[cfg_attr(feature = "v1_4", deprecated = "Since 1.4")]
#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "AdwFlapTransitionType")]
pub enum FlapTransitionType {
    #[doc(alias = "ADW_FLAP_TRANSITION_TYPE_OVER")]
    Over,
    #[doc(alias = "ADW_FLAP_TRANSITION_TYPE_UNDER")]
    Under,
    #[doc(alias = "ADW_FLAP_TRANSITION_TYPE_SLIDE")]
    Slide,
    #[doc(hidden)]
    __Unknown(i32),
}

#[allow(deprecated)]
#[doc(hidden)]
impl IntoGlib for FlapTransitionType {
    type GlibType = ffi::AdwFlapTransitionType;

    #[inline]
    fn into_glib(self) -> ffi::AdwFlapTransitionType {
        match self {
            Self::Over => ffi::ADW_FLAP_TRANSITION_TYPE_OVER,
            Self::Under => ffi::ADW_FLAP_TRANSITION_TYPE_UNDER,
            Self::Slide => ffi::ADW_FLAP_TRANSITION_TYPE_SLIDE,
            Self::__Unknown(value) => value,
        }
    }
}

#[allow(deprecated)]
#[doc(hidden)]
impl FromGlib<ffi::AdwFlapTransitionType> for FlapTransitionType {
    #[inline]
    unsafe fn from_glib(value: ffi::AdwFlapTransitionType) -> Self {
        skip_assert_initialized!();

        match value {
            ffi::ADW_FLAP_TRANSITION_TYPE_OVER => Self::Over,
            ffi::ADW_FLAP_TRANSITION_TYPE_UNDER => Self::Under,
            ffi::ADW_FLAP_TRANSITION_TYPE_SLIDE => Self::Slide,
            value => Self::__Unknown(value),
        }
    }
}

#[allow(deprecated)]
impl StaticType for FlapTransitionType {
    #[inline]
    #[doc(alias = "adw_flap_transition_type_get_type")]
    fn static_type() -> glib::Type {
        unsafe { from_glib(ffi::adw_flap_transition_type_get_type()) }
    }
}

#[allow(deprecated)]
impl glib::HasParamSpec for FlapTransitionType {
    type ParamSpec = glib::ParamSpecEnum;
    type SetValue = Self;
    type BuilderFn = fn(&str, Self) -> glib::ParamSpecEnumBuilder<Self>;

    fn param_spec_builder() -> Self::BuilderFn {
        Self::ParamSpec::builder_with_default
    }
}

#[allow(deprecated)]
impl glib::value::ValueType for FlapTransitionType {
    type Type = Self;
}

#[allow(deprecated)]
unsafe impl<'a> glib::value::FromValue<'a> for FlapTransitionType {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    #[inline]
    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

#[allow(deprecated)]
impl ToValue for FlapTransitionType {
    #[inline]
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    #[inline]
    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[allow(deprecated)]
impl From<FlapTransitionType> for glib::Value {
    #[inline]
    fn from(v: FlapTransitionType) -> Self {
        skip_assert_initialized!();
        ToValue::to_value(&v)
    }
}

#[cfg_attr(feature = "v1_4", deprecated = "Since 1.4")]
#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "AdwFoldThresholdPolicy")]
pub enum FoldThresholdPolicy {
    #[doc(alias = "ADW_FOLD_THRESHOLD_POLICY_MINIMUM")]
    Minimum,
    #[doc(alias = "ADW_FOLD_THRESHOLD_POLICY_NATURAL")]
    Natural,
    #[doc(hidden)]
    __Unknown(i32),
}

#[allow(deprecated)]
#[doc(hidden)]
impl IntoGlib for FoldThresholdPolicy {
    type GlibType = ffi::AdwFoldThresholdPolicy;

    #[inline]
    fn into_glib(self) -> ffi::AdwFoldThresholdPolicy {
        match self {
            Self::Minimum => ffi::ADW_FOLD_THRESHOLD_POLICY_MINIMUM,
            Self::Natural => ffi::ADW_FOLD_THRESHOLD_POLICY_NATURAL,
            Self::__Unknown(value) => value,
        }
    }
}

#[allow(deprecated)]
#[doc(hidden)]
impl FromGlib<ffi::AdwFoldThresholdPolicy> for FoldThresholdPolicy {
    #[inline]
    unsafe fn from_glib(value: ffi::AdwFoldThresholdPolicy) -> Self {
        skip_assert_initialized!();

        match value {
            ffi::ADW_FOLD_THRESHOLD_POLICY_MINIMUM => Self::Minimum,
            ffi::ADW_FOLD_THRESHOLD_POLICY_NATURAL => Self::Natural,
            value => Self::__Unknown(value),
        }
    }
}

#[allow(deprecated)]
impl StaticType for FoldThresholdPolicy {
    #[inline]
    #[doc(alias = "adw_fold_threshold_policy_get_type")]
    fn static_type() -> glib::Type {
        unsafe { from_glib(ffi::adw_fold_threshold_policy_get_type()) }
    }
}

#[allow(deprecated)]
impl glib::HasParamSpec for FoldThresholdPolicy {
    type ParamSpec = glib::ParamSpecEnum;
    type SetValue = Self;
    type BuilderFn = fn(&str, Self) -> glib::ParamSpecEnumBuilder<Self>;

    fn param_spec_builder() -> Self::BuilderFn {
        Self::ParamSpec::builder_with_default
    }
}

#[allow(deprecated)]
impl glib::value::ValueType for FoldThresholdPolicy {
    type Type = Self;
}

#[allow(deprecated)]
unsafe impl<'a> glib::value::FromValue<'a> for FoldThresholdPolicy {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    #[inline]
    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

#[allow(deprecated)]
impl ToValue for FoldThresholdPolicy {
    #[inline]
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    #[inline]
    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[allow(deprecated)]
impl From<FoldThresholdPolicy> for glib::Value {
    #[inline]
    fn from(v: FoldThresholdPolicy) -> Self {
        skip_assert_initialized!();
        ToValue::to_value(&v)
    }
}

#[cfg(feature = "v1_7")]
#[cfg_attr(docsrs, doc(cfg(feature = "v1_7")))]
#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "AdwInlineViewSwitcherDisplayMode")]
pub enum InlineViewSwitcherDisplayMode {
    #[doc(alias = "ADW_INLINE_VIEW_SWITCHER_LABELS")]
    Labels,
    #[doc(alias = "ADW_INLINE_VIEW_SWITCHER_ICONS")]
    Icons,
    #[doc(alias = "ADW_INLINE_VIEW_SWITCHER_BOTH")]
    Both,
    #[doc(hidden)]
    __Unknown(i32),
}

#[cfg(feature = "v1_7")]
#[cfg_attr(docsrs, doc(cfg(feature = "v1_7")))]
#[doc(hidden)]
impl IntoGlib for InlineViewSwitcherDisplayMode {
    type GlibType = ffi::AdwInlineViewSwitcherDisplayMode;

    #[inline]
    fn into_glib(self) -> ffi::AdwInlineViewSwitcherDisplayMode {
        match self {
            Self::Labels => ffi::ADW_INLINE_VIEW_SWITCHER_LABELS,
            Self::Icons => ffi::ADW_INLINE_VIEW_SWITCHER_ICONS,
            Self::Both => ffi::ADW_INLINE_VIEW_SWITCHER_BOTH,
            Self::__Unknown(value) => value,
        }
    }
}

#[cfg(feature = "v1_7")]
#[cfg_attr(docsrs, doc(cfg(feature = "v1_7")))]
#[doc(hidden)]
impl FromGlib<ffi::AdwInlineViewSwitcherDisplayMode> for InlineViewSwitcherDisplayMode {
    #[inline]
    unsafe fn from_glib(value: ffi::AdwInlineViewSwitcherDisplayMode) -> Self {
        skip_assert_initialized!();

        match value {
            ffi::ADW_INLINE_VIEW_SWITCHER_LABELS => Self::Labels,
            ffi::ADW_INLINE_VIEW_SWITCHER_ICONS => Self::Icons,
            ffi::ADW_INLINE_VIEW_SWITCHER_BOTH => Self::Both,
            value => Self::__Unknown(value),
        }
    }
}

#[cfg(feature = "v1_7")]
#[cfg_attr(docsrs, doc(cfg(feature = "v1_7")))]
impl StaticType for InlineViewSwitcherDisplayMode {
    #[inline]
    #[doc(alias = "adw_inline_view_switcher_display_mode_get_type")]
    fn static_type() -> glib::Type {
        unsafe { from_glib(ffi::adw_inline_view_switcher_display_mode_get_type()) }
    }
}

#[cfg(feature = "v1_7")]
#[cfg_attr(docsrs, doc(cfg(feature = "v1_7")))]
impl glib::HasParamSpec for InlineViewSwitcherDisplayMode {
    type ParamSpec = glib::ParamSpecEnum;
    type SetValue = Self;
    type BuilderFn = fn(&str, Self) -> glib::ParamSpecEnumBuilder<Self>;

    fn param_spec_builder() -> Self::BuilderFn {
        Self::ParamSpec::builder_with_default
    }
}

#[cfg(feature = "v1_7")]
#[cfg_attr(docsrs, doc(cfg(feature = "v1_7")))]
impl glib::value::ValueType for InlineViewSwitcherDisplayMode {
    type Type = Self;
}

#[cfg(feature = "v1_7")]
#[cfg_attr(docsrs, doc(cfg(feature = "v1_7")))]
unsafe impl<'a> glib::value::FromValue<'a> for InlineViewSwitcherDisplayMode {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    #[inline]
    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

#[cfg(feature = "v1_7")]
#[cfg_attr(docsrs, doc(cfg(feature = "v1_7")))]
impl ToValue for InlineViewSwitcherDisplayMode {
    #[inline]
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    #[inline]
    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[cfg(feature = "v1_7")]
#[cfg_attr(docsrs, doc(cfg(feature = "v1_7")))]
impl From<InlineViewSwitcherDisplayMode> for glib::Value {
    #[inline]
    fn from(v: InlineViewSwitcherDisplayMode) -> Self {
        skip_assert_initialized!();
        ToValue::to_value(&v)
    }
}

#[cfg(feature = "v1_7")]
#[cfg_attr(docsrs, doc(cfg(feature = "v1_7")))]
#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "AdwJustifyMode")]
pub enum JustifyMode {
    #[doc(alias = "ADW_JUSTIFY_NONE")]
    None,
    #[doc(alias = "ADW_JUSTIFY_FILL")]
    Fill,
    #[doc(alias = "ADW_JUSTIFY_SPREAD")]
    Spread,
    #[doc(hidden)]
    __Unknown(i32),
}

#[cfg(feature = "v1_7")]
#[cfg_attr(docsrs, doc(cfg(feature = "v1_7")))]
#[doc(hidden)]
impl IntoGlib for JustifyMode {
    type GlibType = ffi::AdwJustifyMode;

    #[inline]
    fn into_glib(self) -> ffi::AdwJustifyMode {
        match self {
            Self::None => ffi::ADW_JUSTIFY_NONE,
            Self::Fill => ffi::ADW_JUSTIFY_FILL,
            Self::Spread => ffi::ADW_JUSTIFY_SPREAD,
            Self::__Unknown(value) => value,
        }
    }
}

#[cfg(feature = "v1_7")]
#[cfg_attr(docsrs, doc(cfg(feature = "v1_7")))]
#[doc(hidden)]
impl FromGlib<ffi::AdwJustifyMode> for JustifyMode {
    #[inline]
    unsafe fn from_glib(value: ffi::AdwJustifyMode) -> Self {
        skip_assert_initialized!();

        match value {
            ffi::ADW_JUSTIFY_NONE => Self::None,
            ffi::ADW_JUSTIFY_FILL => Self::Fill,
            ffi::ADW_JUSTIFY_SPREAD => Self::Spread,
            value => Self::__Unknown(value),
        }
    }
}

#[cfg(feature = "v1_7")]
#[cfg_attr(docsrs, doc(cfg(feature = "v1_7")))]
impl StaticType for JustifyMode {
    #[inline]
    #[doc(alias = "adw_justify_mode_get_type")]
    fn static_type() -> glib::Type {
        unsafe { from_glib(ffi::adw_justify_mode_get_type()) }
    }
}

#[cfg(feature = "v1_7")]
#[cfg_attr(docsrs, doc(cfg(feature = "v1_7")))]
impl glib::HasParamSpec for JustifyMode {
    type ParamSpec = glib::ParamSpecEnum;
    type SetValue = Self;
    type BuilderFn = fn(&str, Self) -> glib::ParamSpecEnumBuilder<Self>;

    fn param_spec_builder() -> Self::BuilderFn {
        Self::ParamSpec::builder_with_default
    }
}

#[cfg(feature = "v1_7")]
#[cfg_attr(docsrs, doc(cfg(feature = "v1_7")))]
impl glib::value::ValueType for JustifyMode {
    type Type = Self;
}

#[cfg(feature = "v1_7")]
#[cfg_attr(docsrs, doc(cfg(feature = "v1_7")))]
unsafe impl<'a> glib::value::FromValue<'a> for JustifyMode {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    #[inline]
    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

#[cfg(feature = "v1_7")]
#[cfg_attr(docsrs, doc(cfg(feature = "v1_7")))]
impl ToValue for JustifyMode {
    #[inline]
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    #[inline]
    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[cfg(feature = "v1_7")]
#[cfg_attr(docsrs, doc(cfg(feature = "v1_7")))]
impl From<JustifyMode> for glib::Value {
    #[inline]
    fn from(v: JustifyMode) -> Self {
        skip_assert_initialized!();
        ToValue::to_value(&v)
    }
}

#[cfg_attr(feature = "v1_4", deprecated = "Since 1.4")]
#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "AdwLeafletTransitionType")]
pub enum LeafletTransitionType {
    #[doc(alias = "ADW_LEAFLET_TRANSITION_TYPE_OVER")]
    Over,
    #[doc(alias = "ADW_LEAFLET_TRANSITION_TYPE_UNDER")]
    Under,
    #[doc(alias = "ADW_LEAFLET_TRANSITION_TYPE_SLIDE")]
    Slide,
    #[doc(hidden)]
    __Unknown(i32),
}

#[allow(deprecated)]
#[doc(hidden)]
impl IntoGlib for LeafletTransitionType {
    type GlibType = ffi::AdwLeafletTransitionType;

    #[inline]
    fn into_glib(self) -> ffi::AdwLeafletTransitionType {
        match self {
            Self::Over => ffi::ADW_LEAFLET_TRANSITION_TYPE_OVER,
            Self::Under => ffi::ADW_LEAFLET_TRANSITION_TYPE_UNDER,
            Self::Slide => ffi::ADW_LEAFLET_TRANSITION_TYPE_SLIDE,
            Self::__Unknown(value) => value,
        }
    }
}

#[allow(deprecated)]
#[doc(hidden)]
impl FromGlib<ffi::AdwLeafletTransitionType> for LeafletTransitionType {
    #[inline]
    unsafe fn from_glib(value: ffi::AdwLeafletTransitionType) -> Self {
        skip_assert_initialized!();

        match value {
            ffi::ADW_LEAFLET_TRANSITION_TYPE_OVER => Self::Over,
            ffi::ADW_LEAFLET_TRANSITION_TYPE_UNDER => Self::Under,
            ffi::ADW_LEAFLET_TRANSITION_TYPE_SLIDE => Self::Slide,
            value => Self::__Unknown(value),
        }
    }
}

#[allow(deprecated)]
impl StaticType for LeafletTransitionType {
    #[inline]
    #[doc(alias = "adw_leaflet_transition_type_get_type")]
    fn static_type() -> glib::Type {
        unsafe { from_glib(ffi::adw_leaflet_transition_type_get_type()) }
    }
}

#[allow(deprecated)]
impl glib::HasParamSpec for LeafletTransitionType {
    type ParamSpec = glib::ParamSpecEnum;
    type SetValue = Self;
    type BuilderFn = fn(&str, Self) -> glib::ParamSpecEnumBuilder<Self>;

    fn param_spec_builder() -> Self::BuilderFn {
        Self::ParamSpec::builder_with_default
    }
}

#[allow(deprecated)]
impl glib::value::ValueType for LeafletTransitionType {
    type Type = Self;
}

#[allow(deprecated)]
unsafe impl<'a> glib::value::FromValue<'a> for LeafletTransitionType {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    #[inline]
    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

#[allow(deprecated)]
impl ToValue for LeafletTransitionType {
    #[inline]
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    #[inline]
    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[allow(deprecated)]
impl From<LeafletTransitionType> for glib::Value {
    #[inline]
    fn from(v: LeafletTransitionType) -> Self {
        skip_assert_initialized!();
        ToValue::to_value(&v)
    }
}

#[cfg(feature = "v1_4")]
#[cfg_attr(docsrs, doc(cfg(feature = "v1_4")))]
#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "AdwLengthUnit")]
pub enum LengthUnit {
    #[doc(alias = "ADW_LENGTH_UNIT_PX")]
    Px,
    #[doc(alias = "ADW_LENGTH_UNIT_PT")]
    Pt,
    #[doc(alias = "ADW_LENGTH_UNIT_SP")]
    Sp,
    #[doc(hidden)]
    __Unknown(i32),
}

#[cfg(feature = "v1_4")]
#[cfg_attr(docsrs, doc(cfg(feature = "v1_4")))]
impl LengthUnit {
    #[doc(alias = "adw_length_unit_from_px")]
    pub fn from_px(self, value: f64, settings: Option<&gtk::Settings>) -> f64 {
        assert_initialized_main_thread!();
        unsafe { ffi::adw_length_unit_from_px(self.into_glib(), value, settings.to_glib_none().0) }
    }

    #[doc(alias = "adw_length_unit_to_px")]
    pub fn to_px(self, value: f64, settings: Option<&gtk::Settings>) -> f64 {
        assert_initialized_main_thread!();
        unsafe { ffi::adw_length_unit_to_px(self.into_glib(), value, settings.to_glib_none().0) }
    }
}

#[cfg(feature = "v1_4")]
#[cfg_attr(docsrs, doc(cfg(feature = "v1_4")))]
#[doc(hidden)]
impl IntoGlib for LengthUnit {
    type GlibType = ffi::AdwLengthUnit;

    #[inline]
    fn into_glib(self) -> ffi::AdwLengthUnit {
        match self {
            Self::Px => ffi::ADW_LENGTH_UNIT_PX,
            Self::Pt => ffi::ADW_LENGTH_UNIT_PT,
            Self::Sp => ffi::ADW_LENGTH_UNIT_SP,
            Self::__Unknown(value) => value,
        }
    }
}

#[cfg(feature = "v1_4")]
#[cfg_attr(docsrs, doc(cfg(feature = "v1_4")))]
#[doc(hidden)]
impl FromGlib<ffi::AdwLengthUnit> for LengthUnit {
    #[inline]
    unsafe fn from_glib(value: ffi::AdwLengthUnit) -> Self {
        skip_assert_initialized!();

        match value {
            ffi::ADW_LENGTH_UNIT_PX => Self::Px,
            ffi::ADW_LENGTH_UNIT_PT => Self::Pt,
            ffi::ADW_LENGTH_UNIT_SP => Self::Sp,
            value => Self::__Unknown(value),
        }
    }
}

#[cfg(feature = "v1_4")]
#[cfg_attr(docsrs, doc(cfg(feature = "v1_4")))]
impl StaticType for LengthUnit {
    #[inline]
    #[doc(alias = "adw_length_unit_get_type")]
    fn static_type() -> glib::Type {
        unsafe { from_glib(ffi::adw_length_unit_get_type()) }
    }
}

#[cfg(feature = "v1_4")]
#[cfg_attr(docsrs, doc(cfg(feature = "v1_4")))]
impl glib::HasParamSpec for LengthUnit {
    type ParamSpec = glib::ParamSpecEnum;
    type SetValue = Self;
    type BuilderFn = fn(&str, Self) -> glib::ParamSpecEnumBuilder<Self>;

    fn param_spec_builder() -> Self::BuilderFn {
        Self::ParamSpec::builder_with_default
    }
}

#[cfg(feature = "v1_4")]
#[cfg_attr(docsrs, doc(cfg(feature = "v1_4")))]
impl glib::value::ValueType for LengthUnit {
    type Type = Self;
}

#[cfg(feature = "v1_4")]
#[cfg_attr(docsrs, doc(cfg(feature = "v1_4")))]
unsafe impl<'a> glib::value::FromValue<'a> for LengthUnit {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    #[inline]
    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

#[cfg(feature = "v1_4")]
#[cfg_attr(docsrs, doc(cfg(feature = "v1_4")))]
impl ToValue for LengthUnit {
    #[inline]
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    #[inline]
    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[cfg(feature = "v1_4")]
#[cfg_attr(docsrs, doc(cfg(feature = "v1_4")))]
impl From<LengthUnit> for glib::Value {
    #[inline]
    fn from(v: LengthUnit) -> Self {
        skip_assert_initialized!();
        ToValue::to_value(&v)
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "AdwNavigationDirection")]
pub enum NavigationDirection {
    #[doc(alias = "ADW_NAVIGATION_DIRECTION_BACK")]
    Back,
    #[doc(alias = "ADW_NAVIGATION_DIRECTION_FORWARD")]
    Forward,
    #[doc(hidden)]
    __Unknown(i32),
}

#[doc(hidden)]
impl IntoGlib for NavigationDirection {
    type GlibType = ffi::AdwNavigationDirection;

    #[inline]
    fn into_glib(self) -> ffi::AdwNavigationDirection {
        match self {
            Self::Back => ffi::ADW_NAVIGATION_DIRECTION_BACK,
            Self::Forward => ffi::ADW_NAVIGATION_DIRECTION_FORWARD,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::AdwNavigationDirection> for NavigationDirection {
    #[inline]
    unsafe fn from_glib(value: ffi::AdwNavigationDirection) -> Self {
        skip_assert_initialized!();

        match value {
            ffi::ADW_NAVIGATION_DIRECTION_BACK => Self::Back,
            ffi::ADW_NAVIGATION_DIRECTION_FORWARD => Self::Forward,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for NavigationDirection {
    #[inline]
    #[doc(alias = "adw_navigation_direction_get_type")]
    fn static_type() -> glib::Type {
        unsafe { from_glib(ffi::adw_navigation_direction_get_type()) }
    }
}

impl glib::HasParamSpec for NavigationDirection {
    type ParamSpec = glib::ParamSpecEnum;
    type SetValue = Self;
    type BuilderFn = fn(&str, Self) -> glib::ParamSpecEnumBuilder<Self>;

    fn param_spec_builder() -> Self::BuilderFn {
        Self::ParamSpec::builder_with_default
    }
}

impl glib::value::ValueType for NavigationDirection {
    type Type = Self;
}

unsafe impl<'a> glib::value::FromValue<'a> for NavigationDirection {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    #[inline]
    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for NavigationDirection {
    #[inline]
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    #[inline]
    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

impl From<NavigationDirection> for glib::Value {
    #[inline]
    fn from(v: NavigationDirection) -> Self {
        skip_assert_initialized!();
        ToValue::to_value(&v)
    }
}

#[cfg(feature = "v1_7")]
#[cfg_attr(docsrs, doc(cfg(feature = "v1_7")))]
#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "AdwPackDirection")]
pub enum PackDirection {
    #[doc(alias = "ADW_PACK_START_TO_END")]
    StartToEnd,
    #[doc(alias = "ADW_PACK_END_TO_START")]
    EndToStart,
    #[doc(hidden)]
    __Unknown(i32),
}

#[cfg(feature = "v1_7")]
#[cfg_attr(docsrs, doc(cfg(feature = "v1_7")))]
#[doc(hidden)]
impl IntoGlib for PackDirection {
    type GlibType = ffi::AdwPackDirection;

    #[inline]
    fn into_glib(self) -> ffi::AdwPackDirection {
        match self {
            Self::StartToEnd => ffi::ADW_PACK_START_TO_END,
            Self::EndToStart => ffi::ADW_PACK_END_TO_START,
            Self::__Unknown(value) => value,
        }
    }
}

#[cfg(feature = "v1_7")]
#[cfg_attr(docsrs, doc(cfg(feature = "v1_7")))]
#[doc(hidden)]
impl FromGlib<ffi::AdwPackDirection> for PackDirection {
    #[inline]
    unsafe fn from_glib(value: ffi::AdwPackDirection) -> Self {
        skip_assert_initialized!();

        match value {
            ffi::ADW_PACK_START_TO_END => Self::StartToEnd,
            ffi::ADW_PACK_END_TO_START => Self::EndToStart,
            value => Self::__Unknown(value),
        }
    }
}

#[cfg(feature = "v1_7")]
#[cfg_attr(docsrs, doc(cfg(feature = "v1_7")))]
impl StaticType for PackDirection {
    #[inline]
    #[doc(alias = "adw_pack_direction_get_type")]
    fn static_type() -> glib::Type {
        unsafe { from_glib(ffi::adw_pack_direction_get_type()) }
    }
}

#[cfg(feature = "v1_7")]
#[cfg_attr(docsrs, doc(cfg(feature = "v1_7")))]
impl glib::HasParamSpec for PackDirection {
    type ParamSpec = glib::ParamSpecEnum;
    type SetValue = Self;
    type BuilderFn = fn(&str, Self) -> glib::ParamSpecEnumBuilder<Self>;

    fn param_spec_builder() -> Self::BuilderFn {
        Self::ParamSpec::builder_with_default
    }
}

#[cfg(feature = "v1_7")]
#[cfg_attr(docsrs, doc(cfg(feature = "v1_7")))]
impl glib::value::ValueType for PackDirection {
    type Type = Self;
}

#[cfg(feature = "v1_7")]
#[cfg_attr(docsrs, doc(cfg(feature = "v1_7")))]
unsafe impl<'a> glib::value::FromValue<'a> for PackDirection {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    #[inline]
    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

#[cfg(feature = "v1_7")]
#[cfg_attr(docsrs, doc(cfg(feature = "v1_7")))]
impl ToValue for PackDirection {
    #[inline]
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    #[inline]
    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[cfg(feature = "v1_7")]
#[cfg_attr(docsrs, doc(cfg(feature = "v1_7")))]
impl From<PackDirection> for glib::Value {
    #[inline]
    fn from(v: PackDirection) -> Self {
        skip_assert_initialized!();
        ToValue::to_value(&v)
    }
}

#[cfg(feature = "v1_2")]
#[cfg_attr(docsrs, doc(cfg(feature = "v1_2")))]
#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "AdwResponseAppearance")]
pub enum ResponseAppearance {
    #[doc(alias = "ADW_RESPONSE_DEFAULT")]
    Default,
    #[doc(alias = "ADW_RESPONSE_SUGGESTED")]
    Suggested,
    #[doc(alias = "ADW_RESPONSE_DESTRUCTIVE")]
    Destructive,
    #[doc(hidden)]
    __Unknown(i32),
}

#[cfg(feature = "v1_2")]
#[cfg_attr(docsrs, doc(cfg(feature = "v1_2")))]
#[doc(hidden)]
impl IntoGlib for ResponseAppearance {
    type GlibType = ffi::AdwResponseAppearance;

    #[inline]
    fn into_glib(self) -> ffi::AdwResponseAppearance {
        match self {
            Self::Default => ffi::ADW_RESPONSE_DEFAULT,
            Self::Suggested => ffi::ADW_RESPONSE_SUGGESTED,
            Self::Destructive => ffi::ADW_RESPONSE_DESTRUCTIVE,
            Self::__Unknown(value) => value,
        }
    }
}

#[cfg(feature = "v1_2")]
#[cfg_attr(docsrs, doc(cfg(feature = "v1_2")))]
#[doc(hidden)]
impl FromGlib<ffi::AdwResponseAppearance> for ResponseAppearance {
    #[inline]
    unsafe fn from_glib(value: ffi::AdwResponseAppearance) -> Self {
        skip_assert_initialized!();

        match value {
            ffi::ADW_RESPONSE_DEFAULT => Self::Default,
            ffi::ADW_RESPONSE_SUGGESTED => Self::Suggested,
            ffi::ADW_RESPONSE_DESTRUCTIVE => Self::Destructive,
            value => Self::__Unknown(value),
        }
    }
}

#[cfg(feature = "v1_2")]
#[cfg_attr(docsrs, doc(cfg(feature = "v1_2")))]
impl StaticType for ResponseAppearance {
    #[inline]
    #[doc(alias = "adw_response_appearance_get_type")]
    fn static_type() -> glib::Type {
        unsafe { from_glib(ffi::adw_response_appearance_get_type()) }
    }
}

#[cfg(feature = "v1_2")]
#[cfg_attr(docsrs, doc(cfg(feature = "v1_2")))]
impl glib::HasParamSpec for ResponseAppearance {
    type ParamSpec = glib::ParamSpecEnum;
    type SetValue = Self;
    type BuilderFn = fn(&str, Self) -> glib::ParamSpecEnumBuilder<Self>;

    fn param_spec_builder() -> Self::BuilderFn {
        Self::ParamSpec::builder_with_default
    }
}

#[cfg(feature = "v1_2")]
#[cfg_attr(docsrs, doc(cfg(feature = "v1_2")))]
impl glib::value::ValueType for ResponseAppearance {
    type Type = Self;
}

#[cfg(feature = "v1_2")]
#[cfg_attr(docsrs, doc(cfg(feature = "v1_2")))]
unsafe impl<'a> glib::value::FromValue<'a> for ResponseAppearance {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    #[inline]
    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

#[cfg(feature = "v1_2")]
#[cfg_attr(docsrs, doc(cfg(feature = "v1_2")))]
impl ToValue for ResponseAppearance {
    #[inline]
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    #[inline]
    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[cfg(feature = "v1_2")]
#[cfg_attr(docsrs, doc(cfg(feature = "v1_2")))]
impl From<ResponseAppearance> for glib::Value {
    #[inline]
    fn from(v: ResponseAppearance) -> Self {
        skip_assert_initialized!();
        ToValue::to_value(&v)
    }
}

#[cfg_attr(feature = "v1_4", deprecated = "Since 1.4")]
#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "AdwSqueezerTransitionType")]
pub enum SqueezerTransitionType {
    #[doc(alias = "ADW_SQUEEZER_TRANSITION_TYPE_NONE")]
    None,
    #[doc(alias = "ADW_SQUEEZER_TRANSITION_TYPE_CROSSFADE")]
    Crossfade,
    #[doc(hidden)]
    __Unknown(i32),
}

#[allow(deprecated)]
#[doc(hidden)]
impl IntoGlib for SqueezerTransitionType {
    type GlibType = ffi::AdwSqueezerTransitionType;

    #[inline]
    fn into_glib(self) -> ffi::AdwSqueezerTransitionType {
        match self {
            Self::None => ffi::ADW_SQUEEZER_TRANSITION_TYPE_NONE,
            Self::Crossfade => ffi::ADW_SQUEEZER_TRANSITION_TYPE_CROSSFADE,
            Self::__Unknown(value) => value,
        }
    }
}

#[allow(deprecated)]
#[doc(hidden)]
impl FromGlib<ffi::AdwSqueezerTransitionType> for SqueezerTransitionType {
    #[inline]
    unsafe fn from_glib(value: ffi::AdwSqueezerTransitionType) -> Self {
        skip_assert_initialized!();

        match value {
            ffi::ADW_SQUEEZER_TRANSITION_TYPE_NONE => Self::None,
            ffi::ADW_SQUEEZER_TRANSITION_TYPE_CROSSFADE => Self::Crossfade,
            value => Self::__Unknown(value),
        }
    }
}

#[allow(deprecated)]
impl StaticType for SqueezerTransitionType {
    #[inline]
    #[doc(alias = "adw_squeezer_transition_type_get_type")]
    fn static_type() -> glib::Type {
        unsafe { from_glib(ffi::adw_squeezer_transition_type_get_type()) }
    }
}

#[allow(deprecated)]
impl glib::HasParamSpec for SqueezerTransitionType {
    type ParamSpec = glib::ParamSpecEnum;
    type SetValue = Self;
    type BuilderFn = fn(&str, Self) -> glib::ParamSpecEnumBuilder<Self>;

    fn param_spec_builder() -> Self::BuilderFn {
        Self::ParamSpec::builder_with_default
    }
}

#[allow(deprecated)]
impl glib::value::ValueType for SqueezerTransitionType {
    type Type = Self;
}

#[allow(deprecated)]
unsafe impl<'a> glib::value::FromValue<'a> for SqueezerTransitionType {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    #[inline]
    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

#[allow(deprecated)]
impl ToValue for SqueezerTransitionType {
    #[inline]
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    #[inline]
    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[allow(deprecated)]
impl From<SqueezerTransitionType> for glib::Value {
    #[inline]
    fn from(v: SqueezerTransitionType) -> Self {
        skip_assert_initialized!();
        ToValue::to_value(&v)
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "AdwToastPriority")]
pub enum ToastPriority {
    #[doc(alias = "ADW_TOAST_PRIORITY_NORMAL")]
    Normal,
    #[doc(alias = "ADW_TOAST_PRIORITY_HIGH")]
    High,
    #[doc(hidden)]
    __Unknown(i32),
}

#[doc(hidden)]
impl IntoGlib for ToastPriority {
    type GlibType = ffi::AdwToastPriority;

    #[inline]
    fn into_glib(self) -> ffi::AdwToastPriority {
        match self {
            Self::Normal => ffi::ADW_TOAST_PRIORITY_NORMAL,
            Self::High => ffi::ADW_TOAST_PRIORITY_HIGH,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::AdwToastPriority> for ToastPriority {
    #[inline]
    unsafe fn from_glib(value: ffi::AdwToastPriority) -> Self {
        skip_assert_initialized!();

        match value {
            ffi::ADW_TOAST_PRIORITY_NORMAL => Self::Normal,
            ffi::ADW_TOAST_PRIORITY_HIGH => Self::High,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for ToastPriority {
    #[inline]
    #[doc(alias = "adw_toast_priority_get_type")]
    fn static_type() -> glib::Type {
        unsafe { from_glib(ffi::adw_toast_priority_get_type()) }
    }
}

impl glib::HasParamSpec for ToastPriority {
    type ParamSpec = glib::ParamSpecEnum;
    type SetValue = Self;
    type BuilderFn = fn(&str, Self) -> glib::ParamSpecEnumBuilder<Self>;

    fn param_spec_builder() -> Self::BuilderFn {
        Self::ParamSpec::builder_with_default
    }
}

impl glib::value::ValueType for ToastPriority {
    type Type = Self;
}

unsafe impl<'a> glib::value::FromValue<'a> for ToastPriority {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    #[inline]
    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for ToastPriority {
    #[inline]
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    #[inline]
    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

impl From<ToastPriority> for glib::Value {
    #[inline]
    fn from(v: ToastPriority) -> Self {
        skip_assert_initialized!();
        ToValue::to_value(&v)
    }
}

#[cfg(feature = "v1_4")]
#[cfg_attr(docsrs, doc(cfg(feature = "v1_4")))]
#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "AdwToolbarStyle")]
pub enum ToolbarStyle {
    #[doc(alias = "ADW_TOOLBAR_FLAT")]
    Flat,
    #[doc(alias = "ADW_TOOLBAR_RAISED")]
    Raised,
    #[doc(alias = "ADW_TOOLBAR_RAISED_BORDER")]
    RaisedBorder,
    #[doc(hidden)]
    __Unknown(i32),
}

#[cfg(feature = "v1_4")]
#[cfg_attr(docsrs, doc(cfg(feature = "v1_4")))]
#[doc(hidden)]
impl IntoGlib for ToolbarStyle {
    type GlibType = ffi::AdwToolbarStyle;

    #[inline]
    fn into_glib(self) -> ffi::AdwToolbarStyle {
        match self {
            Self::Flat => ffi::ADW_TOOLBAR_FLAT,
            Self::Raised => ffi::ADW_TOOLBAR_RAISED,
            Self::RaisedBorder => ffi::ADW_TOOLBAR_RAISED_BORDER,
            Self::__Unknown(value) => value,
        }
    }
}

#[cfg(feature = "v1_4")]
#[cfg_attr(docsrs, doc(cfg(feature = "v1_4")))]
#[doc(hidden)]
impl FromGlib<ffi::AdwToolbarStyle> for ToolbarStyle {
    #[inline]
    unsafe fn from_glib(value: ffi::AdwToolbarStyle) -> Self {
        skip_assert_initialized!();

        match value {
            ffi::ADW_TOOLBAR_FLAT => Self::Flat,
            ffi::ADW_TOOLBAR_RAISED => Self::Raised,
            ffi::ADW_TOOLBAR_RAISED_BORDER => Self::RaisedBorder,
            value => Self::__Unknown(value),
        }
    }
}

#[cfg(feature = "v1_4")]
#[cfg_attr(docsrs, doc(cfg(feature = "v1_4")))]
impl StaticType for ToolbarStyle {
    #[inline]
    #[doc(alias = "adw_toolbar_style_get_type")]
    fn static_type() -> glib::Type {
        unsafe { from_glib(ffi::adw_toolbar_style_get_type()) }
    }
}

#[cfg(feature = "v1_4")]
#[cfg_attr(docsrs, doc(cfg(feature = "v1_4")))]
impl glib::HasParamSpec for ToolbarStyle {
    type ParamSpec = glib::ParamSpecEnum;
    type SetValue = Self;
    type BuilderFn = fn(&str, Self) -> glib::ParamSpecEnumBuilder<Self>;

    fn param_spec_builder() -> Self::BuilderFn {
        Self::ParamSpec::builder_with_default
    }
}

#[cfg(feature = "v1_4")]
#[cfg_attr(docsrs, doc(cfg(feature = "v1_4")))]
impl glib::value::ValueType for ToolbarStyle {
    type Type = Self;
}

#[cfg(feature = "v1_4")]
#[cfg_attr(docsrs, doc(cfg(feature = "v1_4")))]
unsafe impl<'a> glib::value::FromValue<'a> for ToolbarStyle {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    #[inline]
    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

#[cfg(feature = "v1_4")]
#[cfg_attr(docsrs, doc(cfg(feature = "v1_4")))]
impl ToValue for ToolbarStyle {
    #[inline]
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    #[inline]
    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[cfg(feature = "v1_4")]
#[cfg_attr(docsrs, doc(cfg(feature = "v1_4")))]
impl From<ToolbarStyle> for glib::Value {
    #[inline]
    fn from(v: ToolbarStyle) -> Self {
        skip_assert_initialized!();
        ToValue::to_value(&v)
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "AdwViewSwitcherPolicy")]
pub enum ViewSwitcherPolicy {
    #[doc(alias = "ADW_VIEW_SWITCHER_POLICY_NARROW")]
    Narrow,
    #[doc(alias = "ADW_VIEW_SWITCHER_POLICY_WIDE")]
    Wide,
    #[doc(hidden)]
    __Unknown(i32),
}

#[doc(hidden)]
impl IntoGlib for ViewSwitcherPolicy {
    type GlibType = ffi::AdwViewSwitcherPolicy;

    #[inline]
    fn into_glib(self) -> ffi::AdwViewSwitcherPolicy {
        match self {
            Self::Narrow => ffi::ADW_VIEW_SWITCHER_POLICY_NARROW,
            Self::Wide => ffi::ADW_VIEW_SWITCHER_POLICY_WIDE,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::AdwViewSwitcherPolicy> for ViewSwitcherPolicy {
    #[inline]
    unsafe fn from_glib(value: ffi::AdwViewSwitcherPolicy) -> Self {
        skip_assert_initialized!();

        match value {
            ffi::ADW_VIEW_SWITCHER_POLICY_NARROW => Self::Narrow,
            ffi::ADW_VIEW_SWITCHER_POLICY_WIDE => Self::Wide,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for ViewSwitcherPolicy {
    #[inline]
    #[doc(alias = "adw_view_switcher_policy_get_type")]
    fn static_type() -> glib::Type {
        unsafe { from_glib(ffi::adw_view_switcher_policy_get_type()) }
    }
}

impl glib::HasParamSpec for ViewSwitcherPolicy {
    type ParamSpec = glib::ParamSpecEnum;
    type SetValue = Self;
    type BuilderFn = fn(&str, Self) -> glib::ParamSpecEnumBuilder<Self>;

    fn param_spec_builder() -> Self::BuilderFn {
        Self::ParamSpec::builder_with_default
    }
}

impl glib::value::ValueType for ViewSwitcherPolicy {
    type Type = Self;
}

unsafe impl<'a> glib::value::FromValue<'a> for ViewSwitcherPolicy {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    #[inline]
    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for ViewSwitcherPolicy {
    #[inline]
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    #[inline]
    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

impl From<ViewSwitcherPolicy> for glib::Value {
    #[inline]
    fn from(v: ViewSwitcherPolicy) -> Self {
        skip_assert_initialized!();
        ToValue::to_value(&v)
    }
}

#[cfg(feature = "v1_7")]
#[cfg_attr(docsrs, doc(cfg(feature = "v1_7")))]
#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "AdwWrapPolicy")]
pub enum WrapPolicy {
    #[doc(alias = "ADW_WRAP_MINIMUM")]
    Minimum,
    #[doc(alias = "ADW_WRAP_NATURAL")]
    Natural,
    #[doc(hidden)]
    __Unknown(i32),
}

#[cfg(feature = "v1_7")]
#[cfg_attr(docsrs, doc(cfg(feature = "v1_7")))]
#[doc(hidden)]
impl IntoGlib for WrapPolicy {
    type GlibType = ffi::AdwWrapPolicy;

    #[inline]
    fn into_glib(self) -> ffi::AdwWrapPolicy {
        match self {
            Self::Minimum => ffi::ADW_WRAP_MINIMUM,
            Self::Natural => ffi::ADW_WRAP_NATURAL,
            Self::__Unknown(value) => value,
        }
    }
}

#[cfg(feature = "v1_7")]
#[cfg_attr(docsrs, doc(cfg(feature = "v1_7")))]
#[doc(hidden)]
impl FromGlib<ffi::AdwWrapPolicy> for WrapPolicy {
    #[inline]
    unsafe fn from_glib(value: ffi::AdwWrapPolicy) -> Self {
        skip_assert_initialized!();

        match value {
            ffi::ADW_WRAP_MINIMUM => Self::Minimum,
            ffi::ADW_WRAP_NATURAL => Self::Natural,
            value => Self::__Unknown(value),
        }
    }
}

#[cfg(feature = "v1_7")]
#[cfg_attr(docsrs, doc(cfg(feature = "v1_7")))]
impl StaticType for WrapPolicy {
    #[inline]
    #[doc(alias = "adw_wrap_policy_get_type")]
    fn static_type() -> glib::Type {
        unsafe { from_glib(ffi::adw_wrap_policy_get_type()) }
    }
}

#[cfg(feature = "v1_7")]
#[cfg_attr(docsrs, doc(cfg(feature = "v1_7")))]
impl glib::HasParamSpec for WrapPolicy {
    type ParamSpec = glib::ParamSpecEnum;
    type SetValue = Self;
    type BuilderFn = fn(&str, Self) -> glib::ParamSpecEnumBuilder<Self>;

    fn param_spec_builder() -> Self::BuilderFn {
        Self::ParamSpec::builder_with_default
    }
}

#[cfg(feature = "v1_7")]
#[cfg_attr(docsrs, doc(cfg(feature = "v1_7")))]
impl glib::value::ValueType for WrapPolicy {
    type Type = Self;
}

#[cfg(feature = "v1_7")]
#[cfg_attr(docsrs, doc(cfg(feature = "v1_7")))]
unsafe impl<'a> glib::value::FromValue<'a> for WrapPolicy {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    #[inline]
    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

#[cfg(feature = "v1_7")]
#[cfg_attr(docsrs, doc(cfg(feature = "v1_7")))]
impl ToValue for WrapPolicy {
    #[inline]
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    #[inline]
    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[cfg(feature = "v1_7")]
#[cfg_attr(docsrs, doc(cfg(feature = "v1_7")))]
impl From<WrapPolicy> for glib::Value {
    #[inline]
    fn from(v: WrapPolicy) -> Self {
        skip_assert_initialized!();
        ToValue::to_value(&v)
    }
}
