/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.atlas.lib;

import org.apache.jena.atlas.lib.Cache;
import org.apache.jena.atlas.lib.CacheSet;
import org.apache.jena.atlas.lib.cache.Cache0;
import org.apache.jena.atlas.lib.cache.Cache1;
import org.apache.jena.atlas.lib.cache.CacheGuava;
import org.apache.jena.atlas.lib.cache.CacheSetImpl;
import org.apache.jena.atlas.lib.cache.CacheSetSync;
import org.apache.jena.atlas.lib.cache.CacheSimple;

public class CacheFactory {
    public static <Key, Value> Cache<Key, Value> createCache(int maxSize) {
        return new CacheGuava(maxSize);
    }

    public static <Key, Value> Cache<Key, Value> createNullCache() {
        return new Cache0();
    }

    public static <Key, Value> Cache<Key, Value> createSimpleCache(int size) {
        return new CacheSimple(size);
    }

    public static <Key, Value> Cache<Key, Value> createOneSlotCache() {
        return new Cache1();
    }

    public static <Obj> CacheSet<Obj> createCacheSet(int size) {
        Cache c = CacheFactory.createCache(size);
        return new CacheSetImpl(c);
    }

    public static <Obj> CacheSet<Obj> createSync(CacheSet<Obj> cache) {
        if (cache instanceof CacheSetSync) {
            return cache;
        }
        return new CacheSetSync<Obj>(cache);
    }
}

