/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.n3;

import org.apache.jena.n3.N3JenaWriterCommon;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;

public class N3JenaWriterTriples
extends N3JenaWriterCommon {
    public static final int colWidth = 8;

    @Override
    protected void writeModel(Model model) {
        this.alwaysAllocateBNodeLabel = true;
        StmtIterator sIter = model.listStatements();
        while (sIter.hasNext()) {
            Statement stmt = sIter.nextStatement();
            String subjStr = this.formatResource(stmt.getSubject());
            this.out.print(subjStr);
            this.padCol(subjStr);
            this.out.print(this.minGapStr);
            String predStr = this.formatProperty(stmt.getPredicate());
            this.out.print(predStr);
            this.padCol(predStr);
            this.out.print(this.minGapStr);
            this.out.print(this.formatNode(stmt.getObject()));
            this.out.println(" .");
        }
        sIter.close();
    }

    private void padCol(String tmp) {
        if (tmp.length() < 8) {
            this.out.print(N3JenaWriterTriples.pad(8 - tmp.length()));
        }
    }
}

