/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.reasoner.transitiveReasoner;

import java.util.HashSet;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.reasoner.FGraph;
import org.apache.jena.reasoner.Finder;
import org.apache.jena.reasoner.FinderUtil;
import org.apache.jena.reasoner.TriplePattern;
import org.apache.jena.reasoner.transitiveReasoner.TransitiveGraphCache;
import org.apache.jena.reasoner.transitiveReasoner.TransitiveReasoner;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.apache.jena.vocabulary.RDFS;

public class TransitiveEngine {
    protected TransitiveGraphCache subClassCache;
    protected TransitiveGraphCache subPropertyCache;
    protected Finder data;
    protected boolean isPrepared = false;
    protected HashSet<Node> subClassAliases;
    protected HashSet<Node> subPropertyAliases;
    private static final int NOT_RELEVANT = 1;
    private static final int SUBCLASS = 2;
    private static final int SUBPROPERTY = 4;
    private static final int UPDATE_MASK = 7;
    private static final int REBUILD_SUBCLASS = 8;
    private static final int REBUILD_SUBPROPERTY = 16;
    public static Node directSubPropertyOf = TransitiveReasoner.directSubPropertyOf;
    public static Node directSubClassOf = TransitiveReasoner.directSubClassOf;
    public static Node subPropertyOf = RDFS.subPropertyOf.asNode();
    public static Node subClassOf = RDFS.subClassOf.asNode();

    public TransitiveEngine(TransitiveGraphCache subClassCache, TransitiveGraphCache subPropertyCache) {
        this.subClassCache = subClassCache;
        this.subPropertyCache = subPropertyCache;
    }

    public TransitiveEngine(TransitiveEngine tengine) {
        this.subClassCache = tengine.getSubClassCache().deepCopy();
        this.subPropertyCache = tengine.getSubPropertyCache().deepCopy();
    }

    public Finder insert(Finder baseData, FGraph newData) {
        Graph newDataG = newData.getGraph();
        this.data = baseData != null ? FinderUtil.cascade(baseData, newData) : newData;
        if (TransitiveEngine.checkOccuranceUtility(subPropertyOf, newDataG, this.subPropertyCache) || TransitiveEngine.checkOccuranceUtility(subClassOf, newDataG, this.subPropertyCache)) {
            this.subClassCache = new TransitiveGraphCache(directSubClassOf, subClassOf);
            this.subPropertyCache = new TransitiveGraphCache(directSubPropertyOf, subPropertyOf);
            TransitiveEngine.cacheSubPropUtility(this.data, this.subPropertyCache);
            TransitiveEngine.cacheSubClassUtility(this.data, this.subPropertyCache, this.subClassCache);
        }
        return this.data;
    }

    public TransitiveGraphCache getSubClassCache() {
        return this.subClassCache;
    }

    public TransitiveGraphCache getSubPropertyCache() {
        return this.subPropertyCache;
    }

    public void setCaching(boolean cacheSP, boolean cacheSC) {
        this.subPropertyCache.setCaching(cacheSP);
        this.subClassCache.setCaching(cacheSC);
    }

    private void prepare() {
        if (this.isPrepared) {
            return;
        }
        this.subClassAliases = new HashSet();
        this.subClassAliases.add(subClassOf);
        this.subClassAliases.add(directSubClassOf);
        this.subPropertyAliases = new HashSet();
        this.subPropertyAliases.add(subPropertyOf);
        this.subPropertyAliases.add(directSubPropertyOf);
        ExtendedIterator<Triple> subProps = this.subPropertyCache.find(new TriplePattern(null, subPropertyOf, subPropertyOf));
        while (subProps.hasNext()) {
            Triple spT = (Triple)subProps.next();
            Node spAlias = spT.getSubject();
            this.subPropertyAliases.add(spAlias);
            ExtendedIterator<Triple> subClasses = this.subPropertyCache.find(new TriplePattern(null, spAlias, subClassOf));
            while (subClasses.hasNext()) {
                this.subClassAliases.add(((Triple)subClasses.next()).getObject());
            }
        }
        this.isPrepared = true;
    }

    private int triage(Triple t) {
        Node predicate;
        if (!this.isPrepared) {
            this.prepare();
        }
        if (this.subClassAliases.contains(predicate = t.getPredicate())) {
            return 2;
        }
        if (this.subPropertyAliases.contains(predicate)) {
            Node target = t.getObject();
            if (this.subClassAliases.contains(target)) {
                return 12;
            }
            if (this.subPropertyAliases.contains(target)) {
                return 24;
            }
            return 4;
        }
        return 1;
    }

    public Finder getFinder(TriplePattern pattern, Finder continuation) {
        Node predicate;
        if (!this.isPrepared) {
            this.prepare();
        }
        if ((predicate = pattern.getPredicate()).isVariable()) {
            return FinderUtil.cascade(this.subPropertyCache, this.subClassCache, continuation);
        }
        if (this.subPropertyAliases.contains(predicate)) {
            return this.subPropertyCache;
        }
        if (this.subClassAliases.contains(predicate)) {
            return this.subClassCache;
        }
        return continuation;
    }

    public synchronized boolean add(Triple t) {
        int triageClass = this.triage(t);
        switch (triageClass & 7) {
            case 2: {
                this.subClassCache.addRelation(t);
                break;
            }
            case 4: {
                this.subPropertyCache.addRelation(t);
                break;
            }
            case 1: {
                return false;
            }
        }
        if ((triageClass & 0x10) != 0) {
            TransitiveEngine.cacheSubPropUtility(this.data, this.subPropertyCache);
            this.isPrepared = false;
        }
        if ((triageClass & 8) != 0) {
            TransitiveEngine.cacheSubClassUtility(this.data, this.subPropertyCache, this.subClassCache);
            this.isPrepared = false;
        }
        return true;
    }

    public synchronized boolean delete(Triple t) {
        int triageClass = this.triage(t);
        switch (triageClass & 7) {
            case 2: {
                this.subClassCache.removeRelation(t);
                break;
            }
            case 4: {
                this.subPropertyCache.removeRelation(t);
                break;
            }
            case 1: {
                return false;
            }
        }
        if ((triageClass & 0x10) != 0) {
            this.subPropertyCache.clear();
            TransitiveEngine.cacheSubPropUtility(this.data, this.subPropertyCache);
            this.isPrepared = false;
        }
        if ((triageClass & 8) != 0) {
            this.subClassCache.clear();
            TransitiveEngine.cacheSubClassUtility(this.data, this.subPropertyCache, this.subClassCache);
            this.isPrepared = false;
        }
        return true;
    }

    public boolean checkOccurance(Node prop, Graph graph) {
        return TransitiveEngine.checkOccuranceUtility(prop, graph, this.subPropertyCache);
    }

    public static boolean cacheSubClassUtility(Finder graph, TransitiveGraphCache spCache, TransitiveGraphCache scCache) {
        if (graph == null) {
            return false;
        }
        scCache.cacheAll(graph, TransitiveReasoner.subClassOf);
        boolean foundAny = false;
        ExtendedIterator<Triple> subClasses = spCache.find(new TriplePattern(null, TransitiveReasoner.subPropertyOf, TransitiveReasoner.subClassOf));
        while (subClasses.hasNext()) {
            foundAny = true;
            Triple t = (Triple)subClasses.next();
            Node subClass = t.getSubject();
            if (subClass.equals(TransitiveReasoner.subClassOf)) continue;
            scCache.cacheAll(graph, subClass);
        }
        return foundAny;
    }

    private static boolean checkOccuranceUtility(Node prop, Graph graph, TransitiveGraphCache spCache) {
        boolean foundOne = false;
        ExtendedIterator<Triple> uses = graph.find(null, prop, null);
        foundOne = uses.hasNext();
        uses.close();
        if (foundOne) {
            return foundOne;
        }
        ExtendedIterator<Triple> propVariants = spCache.find(new TriplePattern(null, TransitiveReasoner.subPropertyOf, prop));
        while (propVariants.hasNext() && !foundOne) {
            Triple t = (Triple)propVariants.next();
            Node propVariant = t.getSubject();
            uses = graph.find(null, propVariant, null);
            foundOne = uses.hasNext();
            uses.close();
        }
        propVariants.close();
        return foundOne;
    }

    public static boolean cacheSubPropUtility(Finder graph, TransitiveGraphCache spCache) {
        if (graph == null) {
            return false;
        }
        spCache.cacheAll(graph, TransitiveReasoner.subPropertyOf);
        boolean foundAny = false;
        boolean foundMore = false;
        HashSet<Node> cached = new HashSet<Node>();
        do {
            ExtendedIterator<Triple> subProps = spCache.find(new TriplePattern(null, TransitiveReasoner.subPropertyOf, TransitiveReasoner.subPropertyOf));
            while (subProps.hasNext()) {
                foundMore = false;
                Triple t = (Triple)subProps.next();
                Node subProp = t.getSubject();
                if (subProp.equals(TransitiveReasoner.subPropertyOf) || cached.contains(subProp)) continue;
                foundAny = true;
                cached.add(subProp);
                spCache.cacheAll(graph, subProp);
                foundMore = true;
            }
        } while (foundMore);
        return foundAny;
    }
}

