/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.type;

import java.util.regex.Pattern;
import org.odftoolkit.odfdom.type.OdfDataType;

public class SafeCURIE
implements OdfDataType {
    private String mCURIE;
    private static final Pattern safeCURIEPattern = Pattern.compile("^\\[(([\\i-[:]][\\c-[:]]*)?:)?.+\\]$");

    public SafeCURIE(String curie) throws IllegalArgumentException {
        if (!SafeCURIE.isValid(curie)) {
            throw new IllegalArgumentException("parameter is invalid for datatype SafeCURIE");
        }
        this.mCURIE = curie;
    }

    public String toString() {
        return this.mCURIE;
    }

    public static SafeCURIE valueOf(String stringValue) throws IllegalArgumentException {
        return new SafeCURIE(stringValue);
    }

    public static boolean isValid(String stringValue) {
        return stringValue != null && safeCURIEPattern.matcher(stringValue).matches() && stringValue.length() >= 3;
    }
}

