/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfvalidator;

import java.util.HashMap;
import java.util.Map;
import org.odftoolkit.odfvalidator.ForeignContentListener;
import org.odftoolkit.odfvalidator.ManifestListener;
import org.odftoolkit.odfvalidator.MetaInformationListener;
import org.odftoolkit.odfvalidator.OdfValidatorMode;
import org.odftoolkit.odfvalidator.OdfVersion;
import org.xml.sax.Attributes;

public class ODFValidationResult
implements ManifestListener,
MetaInformationListener,
ForeignContentListener {
    private String m_aGenerator = null;
    private String m_aMediaType = "";
    private HashMap<String, Long> m_aForeignElementMap = null;
    private HashMap<String, Long> m_aForeignAttributeMap = null;
    private Status m_aStrictValid = Status.UNKNOWN;
    private Status m_aValid = Status.UNKNOWN;
    private Status m_aConforming = Status.UNKNOWN;
    private Status m_aExtendedConforming = Status.UNKNOWN;
    private OdfVersion m_aVersion = null;
    private OdfValidatorMode m_eMode = null;

    ODFValidationResult(OdfVersion aVersion, OdfValidatorMode eMode) {
        this.m_aVersion = aVersion;
        this.m_eMode = eMode;
    }

    @Override
    public void setGenerator(String aGenerator) {
        this.m_aGenerator = aGenerator;
    }

    @Override
    public void setMediaType(String aMediaType) {
        this.m_aMediaType = aMediaType;
    }

    @Override
    public void foreignElementDetected(String aUri, String aLocalName, String aQName, Attributes aAtts) {
        Long aCount;
        if (this.m_aForeignElementMap == null) {
            this.m_aForeignElementMap = new HashMap();
        }
        if ((aCount = this.m_aForeignElementMap.get(aUri)) == null) {
            aCount = 0L;
        }
        this.m_aForeignElementMap.put(aUri, aCount + 1L);
    }

    @Override
    public void foreignAttributeDetected(String aUri, String aLocalName, String aQName, String aValue) {
        Long aCount;
        if (this.m_aForeignAttributeMap == null) {
            this.m_aForeignAttributeMap = new HashMap();
        }
        if ((aCount = this.m_aForeignAttributeMap.get(aUri)) == null) {
            aCount = 0L;
        }
        this.m_aForeignAttributeMap.put(aUri, aCount + 1L);
    }

    public String getGenerator() {
        return this.m_aGenerator;
    }

    public String getMediaType() {
        return this.m_aMediaType;
    }

    public boolean hasForeignElements() {
        return this.m_aForeignElementMap != null;
    }

    public Map<String, Long> getForeignElements() {
        return this.m_aForeignElementMap;
    }

    public boolean hasForeignAttributes() {
        return this.m_aForeignAttributeMap != null;
    }

    public Map<String, Long> getForeignAttributes() {
        return this.m_aForeignAttributeMap;
    }

    public static enum Status {
        NON_CONFORMING,
        CONFORMING,
        UNKNOWN,
        NOT_APPLICABLE;

    }
}

