/* This file is generated by venus-protocol.  See vn_protocol_driver.h. */

/*
 * Copyright 2020 Google LLC
 * SPDX-License-Identifier: MIT
 */

#ifndef VN_PROTOCOL_DRIVER_SAMPLER_YCBCR_CONVERSION_H
#define VN_PROTOCOL_DRIVER_SAMPLER_YCBCR_CONVERSION_H

#include "vn_ring.h"
#include "vn_protocol_driver_structs.h"

/* struct VkSamplerYcbcrConversionCreateInfo chain */

static inline size_t
vn_sizeof_VkSamplerYcbcrConversionCreateInfo_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkSamplerYcbcrConversionCreateInfo_self(const VkSamplerYcbcrConversionCreateInfo *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkFormat(&val->format);
    size += vn_sizeof_VkSamplerYcbcrModelConversion(&val->ycbcrModel);
    size += vn_sizeof_VkSamplerYcbcrRange(&val->ycbcrRange);
    size += vn_sizeof_VkComponentMapping(&val->components);
    size += vn_sizeof_VkChromaLocation(&val->xChromaOffset);
    size += vn_sizeof_VkChromaLocation(&val->yChromaOffset);
    size += vn_sizeof_VkFilter(&val->chromaFilter);
    size += vn_sizeof_VkBool32(&val->forceExplicitReconstruction);
    return size;
}

static inline size_t
vn_sizeof_VkSamplerYcbcrConversionCreateInfo(const VkSamplerYcbcrConversionCreateInfo *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkSamplerYcbcrConversionCreateInfo_pnext(val->pNext);
    size += vn_sizeof_VkSamplerYcbcrConversionCreateInfo_self(val);

    return size;
}

static inline void
vn_encode_VkSamplerYcbcrConversionCreateInfo_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkSamplerYcbcrConversionCreateInfo_self(struct vn_cs_encoder *enc, const VkSamplerYcbcrConversionCreateInfo *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkFormat(enc, &val->format);
    vn_encode_VkSamplerYcbcrModelConversion(enc, &val->ycbcrModel);
    vn_encode_VkSamplerYcbcrRange(enc, &val->ycbcrRange);
    vn_encode_VkComponentMapping(enc, &val->components);
    vn_encode_VkChromaLocation(enc, &val->xChromaOffset);
    vn_encode_VkChromaLocation(enc, &val->yChromaOffset);
    vn_encode_VkFilter(enc, &val->chromaFilter);
    vn_encode_VkBool32(enc, &val->forceExplicitReconstruction);
}

static inline void
vn_encode_VkSamplerYcbcrConversionCreateInfo(struct vn_cs_encoder *enc, const VkSamplerYcbcrConversionCreateInfo *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_SAMPLER_YCBCR_CONVERSION_CREATE_INFO);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_SAMPLER_YCBCR_CONVERSION_CREATE_INFO });
    vn_encode_VkSamplerYcbcrConversionCreateInfo_pnext(enc, val->pNext);
    vn_encode_VkSamplerYcbcrConversionCreateInfo_self(enc, val);
}

static inline size_t vn_sizeof_vkCreateSamplerYcbcrConversion(VkDevice device, const VkSamplerYcbcrConversionCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkSamplerYcbcrConversion* pYcbcrConversion)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCreateSamplerYcbcrConversion_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkDevice(&device);
    cmd_size += vn_sizeof_simple_pointer(pCreateInfo);
    if (pCreateInfo)
        cmd_size += vn_sizeof_VkSamplerYcbcrConversionCreateInfo(pCreateInfo);
    cmd_size += vn_sizeof_simple_pointer(pAllocator);
    if (pAllocator)
        assert(false);
    cmd_size += vn_sizeof_simple_pointer(pYcbcrConversion);
    if (pYcbcrConversion)
        cmd_size += vn_sizeof_VkSamplerYcbcrConversion(pYcbcrConversion);

    return cmd_size;
}

static inline void vn_encode_vkCreateSamplerYcbcrConversion(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkDevice device, const VkSamplerYcbcrConversionCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkSamplerYcbcrConversion* pYcbcrConversion)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCreateSamplerYcbcrConversion_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkDevice(enc, &device);
    if (vn_encode_simple_pointer(enc, pCreateInfo))
        vn_encode_VkSamplerYcbcrConversionCreateInfo(enc, pCreateInfo);
    if (vn_encode_simple_pointer(enc, pAllocator))
        assert(false);
    if (vn_encode_simple_pointer(enc, pYcbcrConversion))
        vn_encode_VkSamplerYcbcrConversion(enc, pYcbcrConversion);
}

static inline size_t vn_sizeof_vkCreateSamplerYcbcrConversion_reply(VkDevice device, const VkSamplerYcbcrConversionCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkSamplerYcbcrConversion* pYcbcrConversion)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCreateSamplerYcbcrConversion_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    VkResult ret;
    cmd_size += vn_sizeof_VkResult(&ret);
    /* skip device */
    /* skip pCreateInfo */
    /* skip pAllocator */
    cmd_size += vn_sizeof_simple_pointer(pYcbcrConversion);
    if (pYcbcrConversion)
        cmd_size += vn_sizeof_VkSamplerYcbcrConversion(pYcbcrConversion);

    return cmd_size;
}

static inline VkResult vn_decode_vkCreateSamplerYcbcrConversion_reply(struct vn_cs_decoder *dec, VkDevice device, const VkSamplerYcbcrConversionCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkSamplerYcbcrConversion* pYcbcrConversion)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkCreateSamplerYcbcrConversion_EXT);

    VkResult ret;
    vn_decode_VkResult(dec, &ret);
    /* skip device */
    /* skip pCreateInfo */
    /* skip pAllocator */
    if (vn_decode_simple_pointer(dec)) {
        vn_decode_VkSamplerYcbcrConversion(dec, pYcbcrConversion);
    } else {
        pYcbcrConversion = NULL;
    }

    return ret;
}

static inline size_t vn_sizeof_vkDestroySamplerYcbcrConversion(VkDevice device, VkSamplerYcbcrConversion ycbcrConversion, const VkAllocationCallbacks* pAllocator)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkDestroySamplerYcbcrConversion_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkDevice(&device);
    cmd_size += vn_sizeof_VkSamplerYcbcrConversion(&ycbcrConversion);
    cmd_size += vn_sizeof_simple_pointer(pAllocator);
    if (pAllocator)
        assert(false);

    return cmd_size;
}

static inline void vn_encode_vkDestroySamplerYcbcrConversion(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkDevice device, VkSamplerYcbcrConversion ycbcrConversion, const VkAllocationCallbacks* pAllocator)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkDestroySamplerYcbcrConversion_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkDevice(enc, &device);
    vn_encode_VkSamplerYcbcrConversion(enc, &ycbcrConversion);
    if (vn_encode_simple_pointer(enc, pAllocator))
        assert(false);
}

static inline size_t vn_sizeof_vkDestroySamplerYcbcrConversion_reply(VkDevice device, VkSamplerYcbcrConversion ycbcrConversion, const VkAllocationCallbacks* pAllocator)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkDestroySamplerYcbcrConversion_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    /* skip device */
    /* skip ycbcrConversion */
    /* skip pAllocator */

    return cmd_size;
}

static inline void vn_decode_vkDestroySamplerYcbcrConversion_reply(struct vn_cs_decoder *dec, VkDevice device, VkSamplerYcbcrConversion ycbcrConversion, const VkAllocationCallbacks* pAllocator)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkDestroySamplerYcbcrConversion_EXT);

    /* skip device */
    /* skip ycbcrConversion */
    /* skip pAllocator */
}

static inline void vn_submit_vkCreateSamplerYcbcrConversion(struct vn_ring *vn_ring, VkCommandFlagsEXT cmd_flags, VkDevice device, const VkSamplerYcbcrConversionCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkSamplerYcbcrConversion* pYcbcrConversion, struct vn_ring_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkCreateSamplerYcbcrConversion(device, pCreateInfo, pAllocator, pYcbcrConversion);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }
    const size_t reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkCreateSamplerYcbcrConversion_reply(device, pCreateInfo, pAllocator, pYcbcrConversion) : 0;

    struct vn_cs_encoder *enc = vn_ring_submit_command_init(vn_ring, submit, cmd_data, cmd_size, reply_size);
    if (cmd_size) {
        vn_encode_vkCreateSamplerYcbcrConversion(enc, cmd_flags, device, pCreateInfo, pAllocator, pYcbcrConversion);
        vn_ring_submit_command(vn_ring, submit);
        if (cmd_data != local_cmd_data)
            free(cmd_data);
    }
}

static inline void vn_submit_vkDestroySamplerYcbcrConversion(struct vn_ring *vn_ring, VkCommandFlagsEXT cmd_flags, VkDevice device, VkSamplerYcbcrConversion ycbcrConversion, const VkAllocationCallbacks* pAllocator, struct vn_ring_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkDestroySamplerYcbcrConversion(device, ycbcrConversion, pAllocator);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }
    const size_t reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkDestroySamplerYcbcrConversion_reply(device, ycbcrConversion, pAllocator) : 0;

    struct vn_cs_encoder *enc = vn_ring_submit_command_init(vn_ring, submit, cmd_data, cmd_size, reply_size);
    if (cmd_size) {
        vn_encode_vkDestroySamplerYcbcrConversion(enc, cmd_flags, device, ycbcrConversion, pAllocator);
        vn_ring_submit_command(vn_ring, submit);
        if (cmd_data != local_cmd_data)
            free(cmd_data);
    }
}

static inline VkResult vn_call_vkCreateSamplerYcbcrConversion(struct vn_ring *vn_ring, VkDevice device, const VkSamplerYcbcrConversionCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkSamplerYcbcrConversion* pYcbcrConversion)
{
    VN_TRACE_FUNC();

    struct vn_ring_submit_command submit;
    vn_submit_vkCreateSamplerYcbcrConversion(vn_ring, VK_COMMAND_GENERATE_REPLY_BIT_EXT, device, pCreateInfo, pAllocator, pYcbcrConversion, &submit);
    struct vn_cs_decoder *dec = vn_ring_get_command_reply(vn_ring, &submit);
    if (dec) {
        const VkResult ret = vn_decode_vkCreateSamplerYcbcrConversion_reply(dec, device, pCreateInfo, pAllocator, pYcbcrConversion);
        vn_ring_free_command_reply(vn_ring, &submit);
        return ret;
    } else {
        return VK_ERROR_OUT_OF_HOST_MEMORY;
    }
}

static inline void vn_async_vkCreateSamplerYcbcrConversion(struct vn_ring *vn_ring, VkDevice device, const VkSamplerYcbcrConversionCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkSamplerYcbcrConversion* pYcbcrConversion)
{
    struct vn_ring_submit_command submit;
    vn_submit_vkCreateSamplerYcbcrConversion(vn_ring, 0, device, pCreateInfo, pAllocator, pYcbcrConversion, &submit);
}

static inline void vn_call_vkDestroySamplerYcbcrConversion(struct vn_ring *vn_ring, VkDevice device, VkSamplerYcbcrConversion ycbcrConversion, const VkAllocationCallbacks* pAllocator)
{
    VN_TRACE_FUNC();

    struct vn_ring_submit_command submit;
    vn_submit_vkDestroySamplerYcbcrConversion(vn_ring, VK_COMMAND_GENERATE_REPLY_BIT_EXT, device, ycbcrConversion, pAllocator, &submit);
    struct vn_cs_decoder *dec = vn_ring_get_command_reply(vn_ring, &submit);
    if (dec) {
        vn_decode_vkDestroySamplerYcbcrConversion_reply(dec, device, ycbcrConversion, pAllocator);
        vn_ring_free_command_reply(vn_ring, &submit);
    }
}

static inline void vn_async_vkDestroySamplerYcbcrConversion(struct vn_ring *vn_ring, VkDevice device, VkSamplerYcbcrConversion ycbcrConversion, const VkAllocationCallbacks* pAllocator)
{
    struct vn_ring_submit_command submit;
    vn_submit_vkDestroySamplerYcbcrConversion(vn_ring, 0, device, ycbcrConversion, pAllocator, &submit);
}

#endif /* VN_PROTOCOL_DRIVER_SAMPLER_YCBCR_CONVERSION_H */
