const tests = [
  [-0x100000001n, -2n, 0x200000002n],
  [-0x100000000n, -2n, 0x200000000n],
  [-0xffffffffn, -2n, 0x1fffffffen],
  [-0xfffffffen, -2n, 0x1fffffffcn],
  [-0x80000001n, -2n, 0x100000002n],
  [-0x80000000n, -2n, 0x100000000n],
  [-0x7fffffffn, -2n, 0xfffffffen],
  [-0x7ffffffen, -2n, 0xfffffffcn],
  [-0x10001n, -2n, 0x20002n],
  [-0x10000n, -2n, 0x20000n],
  [-0xffffn, -2n, 0x1fffen],
  [-0xfffen, -2n, 0x1fffcn],
  [-0x8001n, -2n, 0x10002n],
  [-0x8000n, -2n, 0x10000n],
  [-0x7fffn, -2n, 0xfffen],
  [-0x7ffen, -2n, 0xfffcn],
  [-2n, -2n, 4n],
  [-1n, -2n, 2n],
  [0n, -2n, 0n],
  [1n, -2n, -2n],
  [2n, -2n, -4n],
  [0x7ffen, -2n, -0xfffcn],
  [0x7fffn, -2n, -0xfffen],
  [0x8000n, -2n, -0x10000n],
  [0x8001n, -2n, -0x10002n],
  [0xfffen, -2n, -0x1fffcn],
  [0xffffn, -2n, -0x1fffen],
  [0x10000n, -2n, -0x20000n],
  [0x10001n, -2n, -0x20002n],
  [0x7ffffffen, -2n, -0xfffffffcn],
  [0x7fffffffn, -2n, -0xfffffffen],
  [0x80000000n, -2n, -0x100000000n],
  [0x80000001n, -2n, -0x100000002n],
  [0xfffffffen, -2n, -0x1fffffffcn],
  [0xffffffffn, -2n, -0x1fffffffen],
  [0x100000000n, -2n, -0x200000000n],
  [0x100000001n, -2n, -0x200000002n],
  [-0x7fffffffffffffffn, -1n, 0x7fffffffffffffffn],
  [-0x7ffffffffffffffen, -1n, 0x7ffffffffffffffen],
  [-0x100000001n, -1n, 0x100000001n],
  [-0x100000000n, -1n, 0x100000000n],
  [-0xffffffffn, -1n, 0xffffffffn],
  [-0xfffffffen, -1n, 0xfffffffen],
  [-0x80000001n, -1n, 0x80000001n],
  [-0x80000000n, -1n, 0x80000000n],
  [-0x7fffffffn, -1n, 0x7fffffffn],
  [-0x7ffffffen, -1n, 0x7ffffffen],
  [-0x10001n, -1n, 0x10001n],
  [-0x10000n, -1n, 0x10000n],
  [-0xffffn, -1n, 0xffffn],
  [-0xfffen, -1n, 0xfffen],
  [-0x8001n, -1n, 0x8001n],
  [-0x8000n, -1n, 0x8000n],
  [-0x7fffn, -1n, 0x7fffn],
  [-0x7ffen, -1n, 0x7ffen],
  [-1n, -1n, 1n],
  [0n, -1n, 0n],
  [1n, -1n, -1n],
  [2n, -1n, -2n],
  [0x7ffen, -1n, -0x7ffen],
  [0x7fffn, -1n, -0x7fffn],
  [0x8000n, -1n, -0x8000n],
  [0x8001n, -1n, -0x8001n],
  [0xfffen, -1n, -0xfffen],
  [0xffffn, -1n, -0xffffn],
  [0x10000n, -1n, -0x10000n],
  [0x10001n, -1n, -0x10001n],
  [0x7ffffffen, -1n, -0x7ffffffen],
  [0x7fffffffn, -1n, -0x7fffffffn],
  [0x80000000n, -1n, -0x80000000n],
  [0x80000001n, -1n, -0x80000001n],
  [0xfffffffen, -1n, -0xfffffffen],
  [0xffffffffn, -1n, -0xffffffffn],
  [0x100000000n, -1n, -0x100000000n],
  [0x100000001n, -1n, -0x100000001n],
  [0x7ffffffffffffffen, -1n, -0x7ffffffffffffffen],
  [0x7fffffffffffffffn, -1n, -0x7fffffffffffffffn],
  [-0x8000000000000000n, 0n, 0n],
  [-0x7fffffffffffffffn, 0n, 0n],
  [-0x7ffffffffffffffen, 0n, 0n],
  [-0x100000001n, 0n, 0n],
  [-0x100000000n, 0n, 0n],
  [-0xffffffffn, 0n, 0n],
  [-0xfffffffen, 0n, 0n],
  [-0x80000001n, 0n, 0n],
  [-0x80000000n, 0n, 0n],
  [-0x7fffffffn, 0n, 0n],
  [-0x7ffffffen, 0n, 0n],
  [-0x10001n, 0n, 0n],
  [-0x10000n, 0n, 0n],
  [-0xffffn, 0n, 0n],
  [-0xfffen, 0n, 0n],
  [-0x8001n, 0n, 0n],
  [-0x8000n, 0n, 0n],
  [-0x7fffn, 0n, 0n],
  [-0x7ffen, 0n, 0n],
  [0n, 0n, 0n],
  [1n, 0n, 0n],
  [2n, 0n, 0n],
  [0x7ffen, 0n, 0n],
  [0x7fffn, 0n, 0n],
  [0x8000n, 0n, 0n],
  [0x8001n, 0n, 0n],
  [0xfffen, 0n, 0n],
  [0xffffn, 0n, 0n],
  [0x10000n, 0n, 0n],
  [0x10001n, 0n, 0n],
  [0x7ffffffen, 0n, 0n],
  [0x7fffffffn, 0n, 0n],
  [0x80000000n, 0n, 0n],
  [0x80000001n, 0n, 0n],
  [0xfffffffen, 0n, 0n],
  [0xffffffffn, 0n, 0n],
  [0x100000000n, 0n, 0n],
  [0x100000001n, 0n, 0n],
  [0x7ffffffffffffffen, 0n, 0n],
  [0x7fffffffffffffffn, 0n, 0n],
  [-0x8000000000000000n, 1n, -0x8000000000000000n],
  [-0x7fffffffffffffffn, 1n, -0x7fffffffffffffffn],
  [-0x7ffffffffffffffen, 1n, -0x7ffffffffffffffen],
  [-0x100000001n, 1n, -0x100000001n],
  [-0x100000000n, 1n, -0x100000000n],
  [-0xffffffffn, 1n, -0xffffffffn],
  [-0xfffffffen, 1n, -0xfffffffen],
  [-0x80000001n, 1n, -0x80000001n],
  [-0x80000000n, 1n, -0x80000000n],
  [-0x7fffffffn, 1n, -0x7fffffffn],
  [-0x7ffffffen, 1n, -0x7ffffffen],
  [-0x10001n, 1n, -0x10001n],
  [-0x10000n, 1n, -0x10000n],
  [-0xffffn, 1n, -0xffffn],
  [-0xfffen, 1n, -0xfffen],
  [-0x8001n, 1n, -0x8001n],
  [-0x8000n, 1n, -0x8000n],
  [-0x7fffn, 1n, -0x7fffn],
  [-0x7ffen, 1n, -0x7ffen],
  [1n, 1n, 1n],
  [2n, 1n, 2n],
  [0x7ffen, 1n, 0x7ffen],
  [0x7fffn, 1n, 0x7fffn],
  [0x8000n, 1n, 0x8000n],
  [0x8001n, 1n, 0x8001n],
  [0xfffen, 1n, 0xfffen],
  [0xffffn, 1n, 0xffffn],
  [0x10000n, 1n, 0x10000n],
  [0x10001n, 1n, 0x10001n],
  [0x7ffffffen, 1n, 0x7ffffffen],
  [0x7fffffffn, 1n, 0x7fffffffn],
  [0x80000000n, 1n, 0x80000000n],
  [0x80000001n, 1n, 0x80000001n],
  [0xfffffffen, 1n, 0xfffffffen],
  [0xffffffffn, 1n, 0xffffffffn],
  [0x100000000n, 1n, 0x100000000n],
  [0x100000001n, 1n, 0x100000001n],
  [0x7ffffffffffffffen, 1n, 0x7ffffffffffffffen],
  [0x7fffffffffffffffn, 1n, 0x7fffffffffffffffn],
  [-0x100000001n, 2n, -0x200000002n],
  [-0x100000000n, 2n, -0x200000000n],
  [-0xffffffffn, 2n, -0x1fffffffen],
  [-0xfffffffen, 2n, -0x1fffffffcn],
  [-0x80000001n, 2n, -0x100000002n],
  [-0x80000000n, 2n, -0x100000000n],
  [-0x7fffffffn, 2n, -0xfffffffen],
  [-0x7ffffffen, 2n, -0xfffffffcn],
  [-0x10001n, 2n, -0x20002n],
  [-0x10000n, 2n, -0x20000n],
  [-0xffffn, 2n, -0x1fffen],
  [-0xfffen, 2n, -0x1fffcn],
  [-0x8001n, 2n, -0x10002n],
  [-0x8000n, 2n, -0x10000n],
  [-0x7fffn, 2n, -0xfffen],
  [-0x7ffen, 2n, -0xfffcn],
  [2n, 2n, 4n],
  [0x7ffen, 2n, 0xfffcn],
  [0x7fffn, 2n, 0xfffen],
  [0x8000n, 2n, 0x10000n],
  [0x8001n, 2n, 0x10002n],
  [0xfffen, 2n, 0x1fffcn],
  [0xffffn, 2n, 0x1fffen],
  [0x10000n, 2n, 0x20000n],
  [0x10001n, 2n, 0x20002n],
  [0x7ffffffen, 2n, 0xfffffffcn],
  [0x7fffffffn, 2n, 0xfffffffen],
  [0x80000000n, 2n, 0x100000000n],
  [0x80000001n, 2n, 0x100000002n],
  [0xfffffffen, 2n, 0x1fffffffcn],
  [0xffffffffn, 2n, 0x1fffffffen],
  [0x100000000n, 2n, 0x200000000n],
  [0x100000001n, 2n, 0x200000002n],
  [-0x100000001n, 0x7ffen, -0x7ffe00007ffen],
  [-0x100000000n, 0x7ffen, -0x7ffe00000000n],
  [-0xffffffffn, 0x7ffen, -0x7ffdffff8002n],
  [-0xfffffffen, 0x7ffen, -0x7ffdffff0004n],
  [-0x80000001n, 0x7ffen, -0x3fff00007ffen],
  [-0x80000000n, 0x7ffen, -0x3fff00000000n],
  [-0x7fffffffn, 0x7ffen, -0x3ffeffff8002n],
  [-0x7ffffffen, 0x7ffen, -0x3ffeffff0004n],
  [-0x10001n, 0x7ffen, -0x7ffe7ffen],
  [-0x10000n, 0x7ffen, -0x7ffe0000n],
  [-0xffffn, 0x7ffen, -0x7ffd8002n],
  [-0xfffen, 0x7ffen, -0x7ffd0004n],
  [-0x8001n, 0x7ffen, -0x3fff7ffen],
  [-0x8000n, 0x7ffen, -0x3fff0000n],
  [-0x7fffn, 0x7ffen, -0x3ffe8002n],
  [-0x7ffen, 0x7ffen, -0x3ffe0004n],
  [0x7ffen, 0x7ffen, 0x3ffe0004n],
  [0x7fffn, 0x7ffen, 0x3ffe8002n],
  [0x8000n, 0x7ffen, 0x3fff0000n],
  [0x8001n, 0x7ffen, 0x3fff7ffen],
  [0xfffen, 0x7ffen, 0x7ffd0004n],
  [0xffffn, 0x7ffen, 0x7ffd8002n],
  [0x10000n, 0x7ffen, 0x7ffe0000n],
  [0x10001n, 0x7ffen, 0x7ffe7ffen],
  [0x7ffffffen, 0x7ffen, 0x3ffeffff0004n],
  [0x7fffffffn, 0x7ffen, 0x3ffeffff8002n],
  [0x80000000n, 0x7ffen, 0x3fff00000000n],
  [0x80000001n, 0x7ffen, 0x3fff00007ffen],
  [0xfffffffen, 0x7ffen, 0x7ffdffff0004n],
  [0xffffffffn, 0x7ffen, 0x7ffdffff8002n],
  [0x100000000n, 0x7ffen, 0x7ffe00000000n],
  [0x100000001n, 0x7ffen, 0x7ffe00007ffen],
  [-0x100000001n, 0x7fffn, -0x7fff00007fffn],
  [-0x100000000n, 0x7fffn, -0x7fff00000000n],
  [-0xffffffffn, 0x7fffn, -0x7ffeffff8001n],
  [-0xfffffffen, 0x7fffn, -0x7ffeffff0002n],
  [-0x80000001n, 0x7fffn, -0x3fff80007fffn],
  [-0x80000000n, 0x7fffn, -0x3fff80000000n],
  [-0x7fffffffn, 0x7fffn, -0x3fff7fff8001n],
  [-0x7ffffffen, 0x7fffn, -0x3fff7fff0002n],
  [-0x10001n, 0x7fffn, -0x7fff7fffn],
  [-0x10000n, 0x7fffn, -0x7fff0000n],
  [-0xffffn, 0x7fffn, -0x7ffe8001n],
  [-0xfffen, 0x7fffn, -0x7ffe0002n],
  [-0x8001n, 0x7fffn, -0x3fffffffn],
  [-0x8000n, 0x7fffn, -0x3fff8000n],
  [-0x7fffn, 0x7fffn, -0x3fff0001n],
  [-0x7ffen, 0x7fffn, -0x3ffe8002n],
  [0x7fffn, 0x7fffn, 0x3fff0001n],
  [0x8000n, 0x7fffn, 0x3fff8000n],
  [0x8001n, 0x7fffn, 0x3fffffffn],
  [0xfffen, 0x7fffn, 0x7ffe0002n],
  [0xffffn, 0x7fffn, 0x7ffe8001n],
  [0x10000n, 0x7fffn, 0x7fff0000n],
  [0x10001n, 0x7fffn, 0x7fff7fffn],
  [0x7ffffffen, 0x7fffn, 0x3fff7fff0002n],
  [0x7fffffffn, 0x7fffn, 0x3fff7fff8001n],
  [0x80000000n, 0x7fffn, 0x3fff80000000n],
  [0x80000001n, 0x7fffn, 0x3fff80007fffn],
  [0xfffffffen, 0x7fffn, 0x7ffeffff0002n],
  [0xffffffffn, 0x7fffn, 0x7ffeffff8001n],
  [0x100000000n, 0x7fffn, 0x7fff00000000n],
  [0x100000001n, 0x7fffn, 0x7fff00007fffn],
  [-0x100000001n, 0x8000n, -0x800000008000n],
  [-0x100000000n, 0x8000n, -0x800000000000n],
  [-0xffffffffn, 0x8000n, -0x7fffffff8000n],
  [-0xfffffffen, 0x8000n, -0x7fffffff0000n],
  [-0x80000001n, 0x8000n, -0x400000008000n],
  [-0x80000000n, 0x8000n, -0x400000000000n],
  [-0x7fffffffn, 0x8000n, -0x3fffffff8000n],
  [-0x7ffffffen, 0x8000n, -0x3fffffff0000n],
  [-0x10001n, 0x8000n, -0x80008000n],
  [-0x10000n, 0x8000n, -0x80000000n],
  [-0xffffn, 0x8000n, -0x7fff8000n],
  [-0xfffen, 0x8000n, -0x7fff0000n],
  [-0x8001n, 0x8000n, -0x40008000n],
  [-0x8000n, 0x8000n, -0x40000000n],
  [-0x7fffn, 0x8000n, -0x3fff8000n],
  [-0x7ffen, 0x8000n, -0x3fff0000n],
  [0x8000n, 0x8000n, 0x40000000n],
  [0x8001n, 0x8000n, 0x40008000n],
  [0xfffen, 0x8000n, 0x7fff0000n],
  [0xffffn, 0x8000n, 0x7fff8000n],
  [0x10000n, 0x8000n, 0x80000000n],
  [0x10001n, 0x8000n, 0x80008000n],
  [0x7ffffffen, 0x8000n, 0x3fffffff0000n],
  [0x7fffffffn, 0x8000n, 0x3fffffff8000n],
  [0x80000000n, 0x8000n, 0x400000000000n],
  [0x80000001n, 0x8000n, 0x400000008000n],
  [0xfffffffen, 0x8000n, 0x7fffffff0000n],
  [0xffffffffn, 0x8000n, 0x7fffffff8000n],
  [0x100000000n, 0x8000n, 0x800000000000n],
  [0x100000001n, 0x8000n, 0x800000008000n],
  [-0x100000001n, 0x8001n, -0x800100008001n],
  [-0x100000000n, 0x8001n, -0x800100000000n],
  [-0xffffffffn, 0x8001n, -0x8000ffff7fffn],
  [-0xfffffffen, 0x8001n, -0x8000fffefffen],
  [-0x80000001n, 0x8001n, -0x400080008001n],
  [-0x80000000n, 0x8001n, -0x400080000000n],
  [-0x7fffffffn, 0x8001n, -0x40007fff7fffn],
  [-0x7ffffffen, 0x8001n, -0x40007ffefffen],
  [-0x10001n, 0x8001n, -0x80018001n],
  [-0x10000n, 0x8001n, -0x80010000n],
  [-0xffffn, 0x8001n, -0x80007fffn],
  [-0xfffen, 0x8001n, -0x7ffffffen],
  [-0x8001n, 0x8001n, -0x40010001n],
  [-0x8000n, 0x8001n, -0x40008000n],
  [-0x7fffn, 0x8001n, -0x3fffffffn],
  [-0x7ffen, 0x8001n, -0x3fff7ffen],
  [0x8001n, 0x8001n, 0x40010001n],
  [0xfffen, 0x8001n, 0x7ffffffen],
  [0xffffn, 0x8001n, 0x80007fffn],
  [0x10000n, 0x8001n, 0x80010000n],
  [0x10001n, 0x8001n, 0x80018001n],
  [0x7ffffffen, 0x8001n, 0x40007ffefffen],
  [0x7fffffffn, 0x8001n, 0x40007fff7fffn],
  [0x80000000n, 0x8001n, 0x400080000000n],
  [0x80000001n, 0x8001n, 0x400080008001n],
  [0xfffffffen, 0x8001n, 0x8000fffefffen],
  [0xffffffffn, 0x8001n, 0x8000ffff7fffn],
  [0x100000000n, 0x8001n, 0x800100000000n],
  [0x100000001n, 0x8001n, 0x800100008001n],
  [-0x100000001n, -0x8001n, 0x800100008001n],
  [-0x100000000n, -0x8001n, 0x800100000000n],
  [-0xffffffffn, -0x8001n, 0x8000ffff7fffn],
  [-0xfffffffen, -0x8001n, 0x8000fffefffen],
  [-0x80000001n, -0x8001n, 0x400080008001n],
  [-0x80000000n, -0x8001n, 0x400080000000n],
  [-0x7fffffffn, -0x8001n, 0x40007fff7fffn],
  [-0x7ffffffen, -0x8001n, 0x40007ffefffen],
  [-0x10001n, -0x8001n, 0x80018001n],
  [-0x10000n, -0x8001n, 0x80010000n],
  [-0xffffn, -0x8001n, 0x80007fffn],
  [-0xfffen, -0x8001n, 0x7ffffffen],
  [-0x8001n, -0x8001n, 0x40010001n],
  [-0x8000n, -0x8001n, 0x40008000n],
  [-0x7fffn, -0x8001n, 0x3fffffffn],
  [-0x7ffen, -0x8001n, 0x3fff7ffen],
  [0xfffen, -0x8001n, -0x7ffffffen],
  [0xffffn, -0x8001n, -0x80007fffn],
  [0x10000n, -0x8001n, -0x80010000n],
  [0x10001n, -0x8001n, -0x80018001n],
  [0x7ffffffen, -0x8001n, -0x40007ffefffen],
  [0x7fffffffn, -0x8001n, -0x40007fff7fffn],
  [0x80000000n, -0x8001n, -0x400080000000n],
  [0x80000001n, -0x8001n, -0x400080008001n],
  [0xfffffffen, -0x8001n, -0x8000fffefffen],
  [0xffffffffn, -0x8001n, -0x8000ffff7fffn],
  [0x100000000n, -0x8001n, -0x800100000000n],
  [0x100000001n, -0x8001n, -0x800100008001n],
  [-0x100000001n, -0x8000n, 0x800000008000n],
  [-0x100000000n, -0x8000n, 0x800000000000n],
  [-0xffffffffn, -0x8000n, 0x7fffffff8000n],
  [-0xfffffffen, -0x8000n, 0x7fffffff0000n],
  [-0x80000001n, -0x8000n, 0x400000008000n],
  [-0x80000000n, -0x8000n, 0x400000000000n],
  [-0x7fffffffn, -0x8000n, 0x3fffffff8000n],
  [-0x7ffffffen, -0x8000n, 0x3fffffff0000n],
  [-0x10001n, -0x8000n, 0x80008000n],
  [-0x10000n, -0x8000n, 0x80000000n],
  [-0xffffn, -0x8000n, 0x7fff8000n],
  [-0xfffen, -0x8000n, 0x7fff0000n],
  [-0x8000n, -0x8000n, 0x40000000n],
  [-0x7fffn, -0x8000n, 0x3fff8000n],
  [-0x7ffen, -0x8000n, 0x3fff0000n],
  [0xfffen, -0x8000n, -0x7fff0000n],
  [0xffffn, -0x8000n, -0x7fff8000n],
  [0x10000n, -0x8000n, -0x80000000n],
  [0x10001n, -0x8000n, -0x80008000n],
  [0x7ffffffen, -0x8000n, -0x3fffffff0000n],
  [0x7fffffffn, -0x8000n, -0x3fffffff8000n],
  [0x80000000n, -0x8000n, -0x400000000000n],
  [0x80000001n, -0x8000n, -0x400000008000n],
  [0xfffffffen, -0x8000n, -0x7fffffff0000n],
  [0xffffffffn, -0x8000n, -0x7fffffff8000n],
  [0x100000000n, -0x8000n, -0x800000000000n],
  [0x100000001n, -0x8000n, -0x800000008000n],
  [-0x100000001n, -0x7fffn, 0x7fff00007fffn],
  [-0x100000000n, -0x7fffn, 0x7fff00000000n],
  [-0xffffffffn, -0x7fffn, 0x7ffeffff8001n],
  [-0xfffffffen, -0x7fffn, 0x7ffeffff0002n],
  [-0x80000001n, -0x7fffn, 0x3fff80007fffn],
  [-0x80000000n, -0x7fffn, 0x3fff80000000n],
  [-0x7fffffffn, -0x7fffn, 0x3fff7fff8001n],
  [-0x7ffffffen, -0x7fffn, 0x3fff7fff0002n],
  [-0x10001n, -0x7fffn, 0x7fff7fffn],
  [-0x10000n, -0x7fffn, 0x7fff0000n],
  [-0xffffn, -0x7fffn, 0x7ffe8001n],
  [-0xfffen, -0x7fffn, 0x7ffe0002n],
  [-0x7fffn, -0x7fffn, 0x3fff0001n],
  [-0x7ffen, -0x7fffn, 0x3ffe8002n],
  [0xfffen, -0x7fffn, -0x7ffe0002n],
  [0xffffn, -0x7fffn, -0x7ffe8001n],
  [0x10000n, -0x7fffn, -0x7fff0000n],
  [0x10001n, -0x7fffn, -0x7fff7fffn],
  [0x7ffffffen, -0x7fffn, -0x3fff7fff0002n],
  [0x7fffffffn, -0x7fffn, -0x3fff7fff8001n],
  [0x80000000n, -0x7fffn, -0x3fff80000000n],
  [0x80000001n, -0x7fffn, -0x3fff80007fffn],
  [0xfffffffen, -0x7fffn, -0x7ffeffff0002n],
  [0xffffffffn, -0x7fffn, -0x7ffeffff8001n],
  [0x100000000n, -0x7fffn, -0x7fff00000000n],
  [0x100000001n, -0x7fffn, -0x7fff00007fffn],
  [-0x100000001n, -0x7ffen, 0x7ffe00007ffen],
  [-0x100000000n, -0x7ffen, 0x7ffe00000000n],
  [-0xffffffffn, -0x7ffen, 0x7ffdffff8002n],
  [-0xfffffffen, -0x7ffen, 0x7ffdffff0004n],
  [-0x80000001n, -0x7ffen, 0x3fff00007ffen],
  [-0x80000000n, -0x7ffen, 0x3fff00000000n],
  [-0x7fffffffn, -0x7ffen, 0x3ffeffff8002n],
  [-0x7ffffffen, -0x7ffen, 0x3ffeffff0004n],
  [-0x10001n, -0x7ffen, 0x7ffe7ffen],
  [-0x10000n, -0x7ffen, 0x7ffe0000n],
  [-0xffffn, -0x7ffen, 0x7ffd8002n],
  [-0xfffen, -0x7ffen, 0x7ffd0004n],
  [-0x7ffen, -0x7ffen, 0x3ffe0004n],
  [0xfffen, -0x7ffen, -0x7ffd0004n],
  [0xffffn, -0x7ffen, -0x7ffd8002n],
  [0x10000n, -0x7ffen, -0x7ffe0000n],
  [0x10001n, -0x7ffen, -0x7ffe7ffen],
  [0x7ffffffen, -0x7ffen, -0x3ffeffff0004n],
  [0x7fffffffn, -0x7ffen, -0x3ffeffff8002n],
  [0x80000000n, -0x7ffen, -0x3fff00000000n],
  [0x80000001n, -0x7ffen, -0x3fff00007ffen],
  [0xfffffffen, -0x7ffen, -0x7ffdffff0004n],
  [0xffffffffn, -0x7ffen, -0x7ffdffff8002n],
  [0x100000000n, -0x7ffen, -0x7ffe00000000n],
  [0x100000001n, -0x7ffen, -0x7ffe00007ffen],
  [-0x100000001n, 0xfffen, -0xfffe0000fffen],
  [-0x100000000n, 0xfffen, -0xfffe00000000n],
  [-0xffffffffn, 0xfffen, -0xfffdffff0002n],
  [-0xfffffffen, 0xfffen, -0xfffdfffe0004n],
  [-0x80000001n, 0xfffen, -0x7fff0000fffen],
  [-0x80000000n, 0xfffen, -0x7fff00000000n],
  [-0x7fffffffn, 0xfffen, -0x7ffeffff0002n],
  [-0x7ffffffen, 0xfffen, -0x7ffefffe0004n],
  [-0x10001n, 0xfffen, -0xfffefffen],
  [-0x10000n, 0xfffen, -0xfffe0000n],
  [-0xffffn, 0xfffen, -0xfffd0002n],
  [-0xfffen, 0xfffen, -0xfffc0004n],
  [0xfffen, 0xfffen, 0xfffc0004n],
  [0xffffn, 0xfffen, 0xfffd0002n],
  [0x10000n, 0xfffen, 0xfffe0000n],
  [0x10001n, 0xfffen, 0xfffefffen],
  [0x7ffffffen, 0xfffen, 0x7ffefffe0004n],
  [0x7fffffffn, 0xfffen, 0x7ffeffff0002n],
  [0x80000000n, 0xfffen, 0x7fff00000000n],
  [0x80000001n, 0xfffen, 0x7fff0000fffen],
  [0xfffffffen, 0xfffen, 0xfffdfffe0004n],
  [0xffffffffn, 0xfffen, 0xfffdffff0002n],
  [0x100000000n, 0xfffen, 0xfffe00000000n],
  [0x100000001n, 0xfffen, 0xfffe0000fffen],
  [-0x100000001n, 0xffffn, -0xffff0000ffffn],
  [-0x100000000n, 0xffffn, -0xffff00000000n],
  [-0xffffffffn, 0xffffn, -0xfffeffff0001n],
  [-0xfffffffen, 0xffffn, -0xfffefffe0002n],
  [-0x80000001n, 0xffffn, -0x7fff8000ffffn],
  [-0x80000000n, 0xffffn, -0x7fff80000000n],
  [-0x7fffffffn, 0xffffn, -0x7fff7fff0001n],
  [-0x7ffffffen, 0xffffn, -0x7fff7ffe0002n],
  [-0x10001n, 0xffffn, -0xffffffffn],
  [-0x10000n, 0xffffn, -0xffff0000n],
  [-0xffffn, 0xffffn, -0xfffe0001n],
  [-0xfffen, 0xffffn, -0xfffd0002n],
  [0xffffn, 0xffffn, 0xfffe0001n],
  [0x10000n, 0xffffn, 0xffff0000n],
  [0x10001n, 0xffffn, 0xffffffffn],
  [0x7ffffffen, 0xffffn, 0x7fff7ffe0002n],
  [0x7fffffffn, 0xffffn, 0x7fff7fff0001n],
  [0x80000000n, 0xffffn, 0x7fff80000000n],
  [0x80000001n, 0xffffn, 0x7fff8000ffffn],
  [0xfffffffen, 0xffffn, 0xfffefffe0002n],
  [0xffffffffn, 0xffffn, 0xfffeffff0001n],
  [0x100000000n, 0xffffn, 0xffff00000000n],
  [0x100000001n, 0xffffn, 0xffff0000ffffn],
  [-0x100000001n, 0x10000n, -0x1000000010000n],
  [-0x100000000n, 0x10000n, -0x1000000000000n],
  [-0xffffffffn, 0x10000n, -0xffffffff0000n],
  [-0xfffffffen, 0x10000n, -0xfffffffe0000n],
  [-0x80000001n, 0x10000n, -0x800000010000n],
  [-0x80000000n, 0x10000n, -0x800000000000n],
  [-0x7fffffffn, 0x10000n, -0x7fffffff0000n],
  [-0x7ffffffen, 0x10000n, -0x7ffffffe0000n],
  [-0x10001n, 0x10000n, -0x100010000n],
  [-0x10000n, 0x10000n, -0x100000000n],
  [-0xffffn, 0x10000n, -0xffff0000n],
  [-0xfffen, 0x10000n, -0xfffe0000n],
  [0x10000n, 0x10000n, 0x100000000n],
  [0x10001n, 0x10000n, 0x100010000n],
  [0x7ffffffen, 0x10000n, 0x7ffffffe0000n],
  [0x7fffffffn, 0x10000n, 0x7fffffff0000n],
  [0x80000000n, 0x10000n, 0x800000000000n],
  [0x80000001n, 0x10000n, 0x800000010000n],
  [0xfffffffen, 0x10000n, 0xfffffffe0000n],
  [0xffffffffn, 0x10000n, 0xffffffff0000n],
  [0x100000000n, 0x10000n, 0x1000000000000n],
  [0x100000001n, 0x10000n, 0x1000000010000n],
  [-0x100000001n, 0x10001n, -0x1000100010001n],
  [-0x100000000n, 0x10001n, -0x1000100000000n],
  [-0xffffffffn, 0x10001n, -0x10000fffeffffn],
  [-0xfffffffen, 0x10001n, -0x10000fffdfffen],
  [-0x80000001n, 0x10001n, -0x800080010001n],
  [-0x80000000n, 0x10001n, -0x800080000000n],
  [-0x7fffffffn, 0x10001n, -0x80007ffeffffn],
  [-0x7ffffffen, 0x10001n, -0x80007ffdfffen],
  [-0x10001n, 0x10001n, -0x100020001n],
  [-0x10000n, 0x10001n, -0x100010000n],
  [-0xffffn, 0x10001n, -0xffffffffn],
  [-0xfffen, 0x10001n, -0xfffefffen],
  [0x10001n, 0x10001n, 0x100020001n],
  [0x7ffffffen, 0x10001n, 0x80007ffdfffen],
  [0x7fffffffn, 0x10001n, 0x80007ffeffffn],
  [0x80000000n, 0x10001n, 0x800080000000n],
  [0x80000001n, 0x10001n, 0x800080010001n],
  [0xfffffffen, 0x10001n, 0x10000fffdfffen],
  [0xffffffffn, 0x10001n, 0x10000fffeffffn],
  [0x100000000n, 0x10001n, 0x1000100000000n],
  [0x100000001n, 0x10001n, 0x1000100010001n],
  [-0x100000001n, -0x10001n, 0x1000100010001n],
  [-0x100000000n, -0x10001n, 0x1000100000000n],
  [-0xffffffffn, -0x10001n, 0x10000fffeffffn],
  [-0xfffffffen, -0x10001n, 0x10000fffdfffen],
  [-0x80000001n, -0x10001n, 0x800080010001n],
  [-0x80000000n, -0x10001n, 0x800080000000n],
  [-0x7fffffffn, -0x10001n, 0x80007ffeffffn],
  [-0x7ffffffen, -0x10001n, 0x80007ffdfffen],
  [-0x10001n, -0x10001n, 0x100020001n],
  [-0x10000n, -0x10001n, 0x100010000n],
  [-0xffffn, -0x10001n, 0xffffffffn],
  [-0xfffen, -0x10001n, 0xfffefffen],
  [0x7ffffffen, -0x10001n, -0x80007ffdfffen],
  [0x7fffffffn, -0x10001n, -0x80007ffeffffn],
  [0x80000000n, -0x10001n, -0x800080000000n],
  [0x80000001n, -0x10001n, -0x800080010001n],
  [0xfffffffen, -0x10001n, -0x10000fffdfffen],
  [0xffffffffn, -0x10001n, -0x10000fffeffffn],
  [0x100000000n, -0x10001n, -0x1000100000000n],
  [0x100000001n, -0x10001n, -0x1000100010001n],
  [-0x100000001n, -0x10000n, 0x1000000010000n],
  [-0x100000000n, -0x10000n, 0x1000000000000n],
  [-0xffffffffn, -0x10000n, 0xffffffff0000n],
  [-0xfffffffen, -0x10000n, 0xfffffffe0000n],
  [-0x80000001n, -0x10000n, 0x800000010000n],
  [-0x80000000n, -0x10000n, 0x800000000000n],
  [-0x7fffffffn, -0x10000n, 0x7fffffff0000n],
  [-0x7ffffffen, -0x10000n, 0x7ffffffe0000n],
  [-0x10000n, -0x10000n, 0x100000000n],
  [-0xffffn, -0x10000n, 0xffff0000n],
  [-0xfffen, -0x10000n, 0xfffe0000n],
  [0x7ffffffen, -0x10000n, -0x7ffffffe0000n],
  [0x7fffffffn, -0x10000n, -0x7fffffff0000n],
  [0x80000000n, -0x10000n, -0x800000000000n],
  [0x80000001n, -0x10000n, -0x800000010000n],
  [0xfffffffen, -0x10000n, -0xfffffffe0000n],
  [0xffffffffn, -0x10000n, -0xffffffff0000n],
  [0x100000000n, -0x10000n, -0x1000000000000n],
  [0x100000001n, -0x10000n, -0x1000000010000n],
  [-0x100000001n, -0xffffn, 0xffff0000ffffn],
  [-0x100000000n, -0xffffn, 0xffff00000000n],
  [-0xffffffffn, -0xffffn, 0xfffeffff0001n],
  [-0xfffffffen, -0xffffn, 0xfffefffe0002n],
  [-0x80000001n, -0xffffn, 0x7fff8000ffffn],
  [-0x80000000n, -0xffffn, 0x7fff80000000n],
  [-0x7fffffffn, -0xffffn, 0x7fff7fff0001n],
  [-0x7ffffffen, -0xffffn, 0x7fff7ffe0002n],
  [-0xffffn, -0xffffn, 0xfffe0001n],
  [-0xfffen, -0xffffn, 0xfffd0002n],
  [0x7ffffffen, -0xffffn, -0x7fff7ffe0002n],
  [0x7fffffffn, -0xffffn, -0x7fff7fff0001n],
  [0x80000000n, -0xffffn, -0x7fff80000000n],
  [0x80000001n, -0xffffn, -0x7fff8000ffffn],
  [0xfffffffen, -0xffffn, -0xfffefffe0002n],
  [0xffffffffn, -0xffffn, -0xfffeffff0001n],
  [0x100000000n, -0xffffn, -0xffff00000000n],
  [0x100000001n, -0xffffn, -0xffff0000ffffn],
  [-0x100000001n, -0xfffen, 0xfffe0000fffen],
  [-0x100000000n, -0xfffen, 0xfffe00000000n],
  [-0xffffffffn, -0xfffen, 0xfffdffff0002n],
  [-0xfffffffen, -0xfffen, 0xfffdfffe0004n],
  [-0x80000001n, -0xfffen, 0x7fff0000fffen],
  [-0x80000000n, -0xfffen, 0x7fff00000000n],
  [-0x7fffffffn, -0xfffen, 0x7ffeffff0002n],
  [-0x7ffffffen, -0xfffen, 0x7ffefffe0004n],
  [-0xfffen, -0xfffen, 0xfffc0004n],
  [0x7ffffffen, -0xfffen, -0x7ffefffe0004n],
  [0x7fffffffn, -0xfffen, -0x7ffeffff0002n],
  [0x80000000n, -0xfffen, -0x7fff00000000n],
  [0x80000001n, -0xfffen, -0x7fff0000fffen],
  [0xfffffffen, -0xfffen, -0xfffdfffe0004n],
  [0xffffffffn, -0xfffen, -0xfffdffff0002n],
  [0x100000000n, -0xfffen, -0xfffe00000000n],
  [0x100000001n, -0xfffen, -0xfffe0000fffen],
  [-0x100000001n, 0x7ffffffen, -0x7ffffffe7ffffffen],
  [-0x100000000n, 0x7ffffffen, -0x7ffffffe00000000n],
  [-0xffffffffn, 0x7ffffffen, -0x7ffffffd80000002n],
  [-0xfffffffen, 0x7ffffffen, -0x7ffffffd00000004n],
  [-0x80000001n, 0x7ffffffen, -0x3fffffff7ffffffen],
  [-0x80000000n, 0x7ffffffen, -0x3fffffff00000000n],
  [-0x7fffffffn, 0x7ffffffen, -0x3ffffffe80000002n],
  [-0x7ffffffen, 0x7ffffffen, -0x3ffffffe00000004n],
  [0x7ffffffen, 0x7ffffffen, 0x3ffffffe00000004n],
  [0x7fffffffn, 0x7ffffffen, 0x3ffffffe80000002n],
  [0x80000000n, 0x7ffffffen, 0x3fffffff00000000n],
  [0x80000001n, 0x7ffffffen, 0x3fffffff7ffffffen],
  [0xfffffffen, 0x7ffffffen, 0x7ffffffd00000004n],
  [0xffffffffn, 0x7ffffffen, 0x7ffffffd80000002n],
  [0x100000000n, 0x7ffffffen, 0x7ffffffe00000000n],
  [0x100000001n, 0x7ffffffen, 0x7ffffffe7ffffffen],
  [-0x100000001n, 0x7fffffffn, -0x7fffffff7fffffffn],
  [-0x100000000n, 0x7fffffffn, -0x7fffffff00000000n],
  [-0xffffffffn, 0x7fffffffn, -0x7ffffffe80000001n],
  [-0xfffffffen, 0x7fffffffn, -0x7ffffffe00000002n],
  [-0x80000001n, 0x7fffffffn, -0x3fffffffffffffffn],
  [-0x80000000n, 0x7fffffffn, -0x3fffffff80000000n],
  [-0x7fffffffn, 0x7fffffffn, -0x3fffffff00000001n],
  [-0x7ffffffen, 0x7fffffffn, -0x3ffffffe80000002n],
  [0x7fffffffn, 0x7fffffffn, 0x3fffffff00000001n],
  [0x80000000n, 0x7fffffffn, 0x3fffffff80000000n],
  [0x80000001n, 0x7fffffffn, 0x3fffffffffffffffn],
  [0xfffffffen, 0x7fffffffn, 0x7ffffffe00000002n],
  [0xffffffffn, 0x7fffffffn, 0x7ffffffe80000001n],
  [0x100000000n, 0x7fffffffn, 0x7fffffff00000000n],
  [0x100000001n, 0x7fffffffn, 0x7fffffff7fffffffn],
  [-0x100000000n, 0x80000000n, -0x8000000000000000n],
  [-0xffffffffn, 0x80000000n, -0x7fffffff80000000n],
  [-0xfffffffen, 0x80000000n, -0x7fffffff00000000n],
  [-0x80000001n, 0x80000000n, -0x4000000080000000n],
  [-0x80000000n, 0x80000000n, -0x4000000000000000n],
  [-0x7fffffffn, 0x80000000n, -0x3fffffff80000000n],
  [-0x7ffffffen, 0x80000000n, -0x3fffffff00000000n],
  [0x80000000n, 0x80000000n, 0x4000000000000000n],
  [0x80000001n, 0x80000000n, 0x4000000080000000n],
  [0xfffffffen, 0x80000000n, 0x7fffffff00000000n],
  [0xffffffffn, 0x80000000n, 0x7fffffff80000000n],
  [-0xfffffffen, 0x80000001n, -0x7ffffffffffffffen],
  [-0x80000001n, 0x80000001n, -0x4000000100000001n],
  [-0x80000000n, 0x80000001n, -0x4000000080000000n],
  [-0x7fffffffn, 0x80000001n, -0x3fffffffffffffffn],
  [-0x7ffffffen, 0x80000001n, -0x3fffffff7ffffffen],
  [0x80000001n, 0x80000001n, 0x4000000100000001n],
  [0xfffffffen, 0x80000001n, 0x7ffffffffffffffen],
  [-0xfffffffen, -0x80000001n, 0x7ffffffffffffffen],
  [-0x80000001n, -0x80000001n, 0x4000000100000001n],
  [-0x80000000n, -0x80000001n, 0x4000000080000000n],
  [-0x7fffffffn, -0x80000001n, 0x3fffffffffffffffn],
  [-0x7ffffffen, -0x80000001n, 0x3fffffff7ffffffen],
  [0xfffffffen, -0x80000001n, -0x7ffffffffffffffen],
  [-0xffffffffn, -0x80000000n, 0x7fffffff80000000n],
  [-0xfffffffen, -0x80000000n, 0x7fffffff00000000n],
  [-0x80000000n, -0x80000000n, 0x4000000000000000n],
  [-0x7fffffffn, -0x80000000n, 0x3fffffff80000000n],
  [-0x7ffffffen, -0x80000000n, 0x3fffffff00000000n],
  [0xfffffffen, -0x80000000n, -0x7fffffff00000000n],
  [0xffffffffn, -0x80000000n, -0x7fffffff80000000n],
  [0x100000000n, -0x80000000n, -0x8000000000000000n],
  [-0x100000001n, -0x7fffffffn, 0x7fffffff7fffffffn],
  [-0x100000000n, -0x7fffffffn, 0x7fffffff00000000n],
  [-0xffffffffn, -0x7fffffffn, 0x7ffffffe80000001n],
  [-0xfffffffen, -0x7fffffffn, 0x7ffffffe00000002n],
  [-0x7fffffffn, -0x7fffffffn, 0x3fffffff00000001n],
  [-0x7ffffffen, -0x7fffffffn, 0x3ffffffe80000002n],
  [0xfffffffen, -0x7fffffffn, -0x7ffffffe00000002n],
  [0xffffffffn, -0x7fffffffn, -0x7ffffffe80000001n],
  [0x100000000n, -0x7fffffffn, -0x7fffffff00000000n],
  [0x100000001n, -0x7fffffffn, -0x7fffffff7fffffffn],
  [-0x100000001n, -0x7ffffffen, 0x7ffffffe7ffffffen],
  [-0x100000000n, -0x7ffffffen, 0x7ffffffe00000000n],
  [-0xffffffffn, -0x7ffffffen, 0x7ffffffd80000002n],
  [-0xfffffffen, -0x7ffffffen, 0x7ffffffd00000004n],
  [-0x7ffffffen, -0x7ffffffen, 0x3ffffffe00000004n],
  [0xfffffffen, -0x7ffffffen, -0x7ffffffd00000004n],
  [0xffffffffn, -0x7ffffffen, -0x7ffffffd80000002n],
  [0x100000000n, -0x7ffffffen, -0x7ffffffe00000000n],
  [0x100000001n, -0x7ffffffen, -0x7ffffffe7ffffffen],
];

// Cases not covered above.
tests.push(
  // Int32 overflow:
  //
  //   Math.floor(2 ** (Math.log2(2147483648) / 2))
  // = Math.floor(2 ** 15.5)
  // = 46340
  //
  //   Math.ceil(2 ** (Math.log2(2147483648) / 2))
  // = Math.ceil(2 ** 15.5)
  // = 46341
  [46340n, 46340n, 2147395600n],
  [46341n, 46341n, 2147488281n],
  [46340n, -46340n, -2147395600n],
  [46341n, -46341n, -2147488281n],
  [-46340n, -46340n, 2147395600n],
  [-46341n, -46341n, 2147488281n],

  // Int64 overflow
  [3037000499n, 3037000499n, 9223372030926249001n],
  [3037000499n, -3037000499n, -9223372030926249001n],
  [-3037000499n, -3037000499n, 9223372030926249001n],
);

function f(tests) {
  for (let test of tests) {
    let lhs = test[0], rhs = test[1], expected = test[2];
    assertEq(BigInt.asIntN(64, lhs), lhs);
    assertEq(BigInt.asIntN(64, rhs), rhs);
    assertEq(BigInt.asIntN(64, expected), expected);

    assertEq(lhs * rhs, expected);
    assertEq(rhs * lhs, expected);
  }
}

for (let i = 0; i < 10; ++i) {
  f(tests);
}
