/* BEGIN software license
 *
 * MsXpertSuite - mass spectrometry software suite
 * -----------------------------------------------
 * Copyright (C) 2009--2020 Filippo Rusconi
 *
 * http://www.msxpertsuite.org
 *
 * This file is part of the MsXpertSuite project.
 *
 * The MsXpertSuite project is the successor of the massXpert project. This
 * project now includes various independent modules:
 *
 * - massXpert, model polymer chemistries and simulate mass spectrometric data;
 * - mineXpert, a powerful TIC chromatogram/mass spectrum viewer/miner;
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 *
 * END software license
 */


#pragma once

/////////////////////// StdLib includes


/////////////////////// Qt includes


/////////////////////// pappsomspp includes
#include <pappsomspp/core/trace/datapoint.h>
#include <pappsomspp/core/trace/trace.h>


/////////////////////// Local includes
#include "MsXpS/export-import-config.h"
#include "MassPeakShaperConfig.hpp"

namespace MsXpS
{

namespace libXpertMassCore
{


class DECLSPEC MassPeakShaper
{
  public:
  MassPeakShaper();
  MassPeakShaper(double mz,
                 double intensity,
                 const MassPeakShaperConfig &config);
  MassPeakShaper(const pappso::DataPoint &data_point,
                 const MassPeakShaperConfig &config);
  MassPeakShaper(const MassPeakShaper &);
  virtual ~MassPeakShaper();

  void setPeakCentroid(const pappso::DataPoint &data_point);
  const pappso::DataPoint &getPeakCentroid() const;

  void setConfig(const MassPeakShaperConfig &config);
  const MassPeakShaperConfig &getConfig() const;

  const pappso::Trace &getTrace() const;

  int computePeakShape();
  static pappso::Trace computePeakShape(double mz,
                                        double intensity,
                                        const MassPeakShaperConfig &config);

  int computeGaussianPeakShape();
  static pappso::Trace computeGaussianPeakShape(
    double mz, double intensity, const MassPeakShaperConfig &config);

  int computeLorentzianPeakShape();
  static pappso::Trace computeLorentzianPeakShape(
    double mz, double intensity, const MassPeakShaperConfig &config);

  double intensityAt(double mz, pappso::PrecisionPtr precision_p, bool &ok);

  QString shapetoString();
  bool shapeToFile(const QString &file_name);

  protected:
  pappso::DataPoint m_peakCentroid;
  MassPeakShaperConfig m_config;
  pappso::Trace m_trace;

  void clearTrace();
};

typedef std::shared_ptr<MassPeakShaper> MassPeakShaperSPtr;

} // namespace libXpertMassCore

} // namespace MsXpS
