#!/usr/bin/env python

import openturns as ot

for lx in range(10):
    x = 2**lx
    print("x=", x, "log2=", ot.SpecFunc.Log2(x))

for lx in range(10):
    x = 2**lx - 1
    print("x=", x, "bits=", ot.SpecFunc.BitCount(x))

for x in [0, 1, 2, 3, 4, 10, 100, 1000]:
    print("x=", x, "nextpow2=", ot.SpecFunc.NextPowerOfTwo(x))

for x in [-2.0, -1.0, 0.0, 1.0, 2.0]:
    for n in [0, 1, 2]:
        print("x=", x, "n=", n, "ipow=", ot.SpecFunc.IPow(x, n))

for x in [-4.0, 4.0, 9.0]:
    for n in [1, 2]:
        if x < 0.0 and n % 2 == 0:
            continue
        print("x=", x, "n=", n, "iroot=", ot.SpecFunc.IRoot(x, n))

print("ibeta(2.0, 0.0, 0.95)=", ot.SpecFunc.RegularizedIncompleteBeta(2.0, 0.0, 0.95))
print("ibeta(0.0, 1.0, 0.95)=", ot.SpecFunc.RegularizedIncompleteBeta(0.0, 1.0, 0.95))
print(
    "ibeta(2.0, 0.0, 0.95, tail)=",
    ot.SpecFunc.RegularizedIncompleteBeta(2.0, 0.0, 0.95, True),
)
print(
    "ibeta(0.0, 1.0, 0.95, tail)=",
    ot.SpecFunc.RegularizedIncompleteBeta(0.0, 1.0, 0.95, True),
)

x = [1.0, 2.0**53, -(2.0**53)]
s2 = ot.SpecFunc.AccurateSum(x)
assert s2 == 1.0, "accurate sum(x) not 1"

# Clip01
assert ot.SpecFunc.Clip01(0.2) == 0.2
assert ot.SpecFunc.Clip01(0.2, True) == 0.8
assert ot.SpecFunc.Clip01(-5.0) == 0.0
assert ot.SpecFunc.Clip01(5.0) == 1.0
assert ot.SpecFunc.Clip01(-5.0, True) == 1.0
assert ot.SpecFunc.Clip01(5.0, True) == 0.0
