% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_equal_linter.R
\name{all_equal_linter}
\alias{all_equal_linter}
\title{Warn about invalid usage of \code{all.equal()}}
\usage{
all_equal_linter()
}
\description{
\code{\link[=all.equal]{all.equal()}} returns \code{TRUE} in the absence of differences but return a
character string (not \code{FALSE}) in the presence of differences.
Usage of \code{all.equal()} without wrapping it in \code{isTRUE()} in \code{if} clauses, or
preceded by the negation operator \code{!}, are thus likely to generate unexpected
errors if the compared objects have differences.
An alternative is to use \code{identical()} to compare vector of strings or when
exact equality is expected.
}
\examples{
# lints
lint(
  text = 'if (all.equal(a, b)) message("equal")',
  linters = all_equal_linter()
)

lint(
  text = '!all.equal(a, b)',
  linters = all_equal_linter()
)

lint(
  text = 'isFALSE(all.equal(a, b))',
  linters = all_equal_linter()
)

# okay
lint(
  text = 'if (isTRUE(all.equal(a, b))) message("equal")',
  linters = all_equal_linter()
)

lint(
  text = '!identical(a, b)',
  linters = all_equal_linter()
)

lint(
  text = "!isTRUE(all.equal(a, b))",
  linters = all_equal_linter()
)

}
\seealso{
\link{linters} for a complete list of linters available in lintr.
}
\section{Tags}{
\link[=common_mistakes_linters]{common_mistakes}, \link[=robustness_linters]{robustness}
}
