use jsparagus::stencil::opcode_info;

fn compare(name: &str, orig: &str, copied: &str) {
    if copied != orig {
        panic!(
            "{} is out of sync. \
                It's possible that the bytecode generated by jsparagus is \
                based on older opcodes. Please run \
                update_stencil.py in jsparagus. \
                You can disable this check by setting \
                JS_SMOOSH_DISABLE_OPCODE_CHECK environment variable.",
            name
        );
    }
}

fn main() {
    if std::env::var("JS_SMOOSH_DISABLE_OPCODE_CHECK").is_ok() {
        return;
    }

    compare(
        "Opcodes.h",
        include_str!("../../vm/Opcodes.h"),
        opcode_info::get_opcodes_source(),
    );
}
