/* Copyright 2014. The Regents of the University of California.
 * All rights reserved. Use of this source code is governed by 
 * a BSD-style license which can be found in the LICENSE file.
 *
 * 2013 Martin Uecker <uecker@eecs.berkeley.edu>
 */
 
#include <complex.h>

#include "sens.h"


const complex float sens_coeff[8][5][5] = {
{ // coil0
{ +2.202641e+02+7.959795e+02i,	+7.555631e+02-1.436550e+03i,	+2.545977e+03+6.890254e+02i,	-1.556657e+03+1.514510e+03i,	+2.119276e+02-1.494780e+03i },
{ +1.298826e+03-2.217249e+02i,	+5.104937e+03-1.257278e+03i,	+2.718070e+03+9.347223e+03i,	-4.162577e+03+4.012845e+03i,	-2.934868e+02-1.494939e+02i },
{ -2.586698e+03+3.241368e+02i,	+2.655842e+02-1.423245e+04i,	+3.444878e+04-5.959087e-07i,	+2.655845e+02+1.423245e+04i,	-2.586697e+03-3.241368e+02i },
{ -2.934868e+02+1.494939e+02i,	-4.162577e+03-4.012845e+03i,	+2.718070e+03-9.347224e+03i,	+5.104937e+03+1.257278e+03i,	+1.298826e+03+2.217249e+02i },
{ +2.119276e+02+1.494780e+03i,	-1.556657e+03-1.514511e+03i,	+2.545977e+03-6.890254e+02i,	+7.555631e+02+1.436550e+03i,	+2.202641e+02-7.959794e+02i },
},
{ // coil1
{ -5.140192e+02+3.919716e+02i,	+1.894585e+03-6.871808e+02i,	-1.588401e+03-9.072462e+02i,	+1.612868e+03+3.162505e+03i,	-1.764654e+03-7.521263e+01i },
{ +1.468621e+03+2.462891e+03i,	+9.060663e+02-3.810722e+03i,	+1.295797e+04+1.274518e+03i,	+9.795861e+03+4.041410e+03i,	+5.382768e+03+1.496270e+03i },
{ +6.432245e+03-1.873246e+03i,	-6.606911e+03+1.347433e+03i,	+1.469823e+04-2.828712e+04i,	+6.094570e+03-3.186246e+03i,	+1.553516e+03-6.658626e+03i },
{ +1.552164e+02-2.608411e+03i,	-4.773840e+02+4.141277e+03i,	-1.697275e+04-4.176371e+03i,	+1.530776e+02-6.096529e+03i,	-1.256617e+03-3.806721e+03i },
{ +1.427317e+03-6.593576e+02i,	+3.361672e+03+2.074898e+03i,	-1.207303e+03+5.915274e+03i,	-1.866361e+03+2.202192e+02i,	-2.244576e+03+5.222404e+02i },
},
{ // coil2
{ +1.501215e+03+5.783638e+02i,	-4.342622e+02-3.816680e+03i,	+1.776472e+03+3.912266e+03i,	+7.807321e+03-4.950209e+03i,	-2.595354e+03-2.460056e+03i },
{ +2.369316e+03-2.313158e+03i,	+9.616589e+02-1.347896e+02i,	+1.163739e+04-1.087814e+04i,	+5.465111e+03-1.369369e+04i,	-2.497076e+03-7.660470e+03i },
{ -1.154424e+03-5.152002e+03i,	+5.065459e+03+2.144815e+03i,	-8.206305e+03-2.679990e+04i,	-1.085187e+04-1.832581e+03i,	-1.138738e+04+2.371703e+03i },
{ -1.613378e+03+1.783068e+03i,	+2.226849e+03-2.917332e+03i,	-1.126524e+04+1.535570e+04i,	-1.155414e+03+9.211537e+02i,	+2.441054e+03+3.475593e+03i },
{ +2.149000e+03-1.050538e+03i,	+1.897796e+02-2.738874e+03i,	+9.831870e+03+3.711983e+01i,	+6.797585e+02+1.121489e+03i,	+2.977299e+03-2.676358e+02i },
},
{ // coil3
{ +9.225188e+02-1.609105e+03i,	+3.003085e+02-4.805967e+03i,	+3.010118e+03-5.193128e+03i,	-7.148681e+03-6.014095e+03i,	-5.118819e+03+6.886482e+03i },
{ -7.304860e+01-1.906521e+03i,	+4.666944e+03-8.186537e+03i,	-4.628897e+03-1.670177e+04i,	-9.002204e+03-5.413904e+03i,	-5.991946e+03+3.112899e+03i },
{ -1.707291e+03+1.371777e+03i,	+6.265779e+03-4.096543e+03i,	-1.623247e+04-1.249279e+04i,	-5.735404e+03+1.462694e+04i,	+3.235129e+03+7.745793e+03i },
{ +2.658034e+03-2.003479e+03i,	-5.550209e+03-6.058204e+02i,	+4.231377e+03+1.547026e+04i,	+5.596798e+03-8.212248e+03i,	-2.146848e+02-8.379209e+03i },
{ +7.590588e+02-2.001688e+03i,	+4.298658e+03-8.379312e+02i,	+8.961587e+02-1.114809e+04i,	-1.882075e+03+3.505513e+03i,	-9.920860e+01-1.958216e+01i },
},
{ // coil4
{ +1.038110e+03+1.053870e+03i,	+9.244695e+03+1.892697e+03i,	-3.192582e+03-6.490971e+03i,	-9.345550e+02-5.915621e+02i,	-5.048445e+03-5.094557e+02i },
{ +6.029613e+03+9.528574e+03i,	+1.726803e+04+1.136792e+04i,	+1.704588e+04-6.327428e+03i,	-1.018518e+03-4.875073e+03i,	-1.385726e+03-2.624488e+03i },
{ -5.607942e+03+3.239110e+03i,	-6.596133e+02+1.426120e+04i,	+1.907908e+04+6.801775e+03i,	-9.809665e+03-9.162689e+03i,	+2.646640e+03+3.444627e+03i },
{ +3.773911e+03-3.830415e+03i,	-2.280376e+03-6.118903e+03i,	-9.791950e+03-1.582865e+03i,	+1.482043e+04+8.187234e+03i,	+2.503851e+03-5.622277e+03i },
{ -3.532414e+02+2.797883e+03i,	+1.086923e+03+4.907002e+03i,	+2.711129e+03-4.658596e+02i,	-6.884295e+03+1.658655e+03i,	+2.195509e+03+1.532364e+03i },
},
{ // coil5
{ -2.660406e+03+1.130288e+03i,	-2.684663e+03-4.547482e+03i,	-1.091036e+03+1.039176e+04i,	+3.794462e+03-3.726057e+03i,	-9.599513e+02+2.510410e+03i },
{ +2.453693e+03-1.127183e+04i,	+3.368645e+03-1.562005e+04i,	-6.638387e+03-2.965991e+03i,	+3.831320e+03+2.531652e+03i,	-2.198729e+03-5.958389e+02i },
{ +1.428178e+04+9.163301e+02i,	+1.684055e+04-6.384269e+03i,	+1.658437e+04-1.232798e+04i,	-1.406222e+04+1.113432e+04i,	+3.592359e+03-6.771321e+03i },
{ -1.660563e+03+2.839105e+03i,	-2.896235e+02+1.029472e+03i,	-3.908763e+03+3.005041e+03i,	+4.267630e+03-1.222684e+04i,	+3.162250e+03+3.059668e+03i },
{ +1.229621e+03+1.214108e+03i,	+3.580651e+03+6.040717e+02i,	+7.638826e+02+2.616962e+03i,	+4.679096e+03+3.197829e+03i,	-2.025938e+03+1.366729e+03i },
},
{ // coil6
{ +1.532993e+03+3.085543e+03i,	+1.698160e+02-2.059932e+03i,	+8.620593e+03+5.947357e+03i,	-1.818730e+03-3.486291e+03i,	+2.804918e+03+2.657346e+02i },
{ -5.363040e+03-8.659919e+03i,	-1.811624e+03-1.273996e+04i,	+5.336066e+02+4.722509e+03i,	+5.288265e+03-4.540653e+02i,	-1.550763e+03+3.172655e+03i },
{ +1.484031e+04-8.435797e+03i,	+1.909462e+04-1.153338e+04i,	+2.644743e+04+1.609464e+03i,	-1.835121e+04+1.685986e+04i,	-2.060884e+03-1.164399e+04i },
{ +3.565514e+03+4.812732e+03i,	-5.792477e+02-1.059542e+03i,	-6.948085e+03+1.922669e+03i,	-3.102303e+03-1.536498e+04i,	+8.313277e+03-1.413219e+03i },
{ +3.645370e+03+3.144318e+03i,	+5.896468e+03-1.094847e+03i,	+3.137289e+03+4.010566e+03i,	+5.041110e+03-3.595689e+03i,	+4.239519e+03+4.264271e+03i },
},
{ // coil7
{ +9.757094e+02-4.944947e+02i,	-1.479025e+03-3.433955e+03i,	+6.554174e+03-3.580007e+03i,	-5.973520e+02+2.335976e+03i,	-1.082375e+03-1.958220e+03i },
{ -2.523083e+03+1.680365e+03i,	-4.212411e+03-1.392797e+03i,	+2.731082e+03+4.483586e+03i,	-2.006126e+03-1.093595e+03i,	+1.536401e+03-1.071117e+03i },
{ -9.129410e+03-5.654936e+03i,	-6.060043e+03-2.092658e+04i,	+2.299950e+04-2.185407e+04i,	+9.382429e+03+1.937377e+04i,	-1.130825e+04+2.193837e+03i },
{ +6.269709e+02-2.393860e+03i,	-1.782260e+03-2.694656e+03i,	+2.224400e+03-3.487669e+01i,	-4.697312e+03+2.063353e+03i,	-1.975369e+03-3.797778e+03i },
{ +8.142875e+02-3.201539e+03i,	+4.320247e+01-5.839946e+03i,	+7.607719e+03-2.151906e+03i,	-1.149005e+03+1.656691e+03i,	-3.673436e+01-2.858548e+03i },
} };

const complex float sens64_coeff[64][5][5][5] = {
{// coil0
{
{ +2.355823e+01+1.852871e+01i, +1.606015e+01+2.662717e+01i, -2.237323e+00+5.467895e+00i, -1.626701e+00+6.826878e-01i, -2.869943e-01-3.239194e-02i },
{ -3.002007e+01+4.722337e+01i, -3.453838e+01+4.123982e+01i, -7.412611e+00+4.085485e+00i, -4.808465e-01-1.177731e+00i, +6.645200e-01-7.182419e-02i },
{ -2.235271e+01-1.555125e+01i, -8.564039e+00-8.229277e+00i, +4.687859e+00+3.093128e-01i, +2.568945e+00+5.815071e-02i, -4.432781e-01+1.411744e-01i },
{ +1.128251e+01+9.729708e-01i, +1.071043e+00+5.505503e+00i, -8.235755e-01-1.058254e+00i, +6.586585e-01+1.621976e+00i, -6.476501e-01-5.171457e-01i },
{ -3.691743e+00+1.555109e+00i, -4.482887e+00-1.910469e+00i, +7.802963e-02-1.617222e+00i, +2.245376e-01+1.048186e-01i, -3.255736e-03-1.190094e-01i },
},
{
{ +2.810302e+01+1.581089e+01i, +3.229101e+01+2.367034e+01i, +6.241167e+00+6.065726e+00i, +4.698452e-01+2.568392e+00i, -8.890774e-01-2.903498e-01i },
{ -1.744714e+00+1.014270e+02i, -1.849351e+01+1.272348e+02i, -4.342983e+00+3.229969e+01i, -1.133785e+00+1.833781e+00i, +7.978039e-01-1.000234e+00i },
{ -3.556582e+01+2.356059e+01i, -3.474943e+01+3.265475e+01i, -7.445467e+00+7.059258e+00i, +6.017442e-01-3.082591e+00i, -1.979113e-03+1.127141e-01i },
{ +8.950156e+00-8.874456e+00i, +9.199142e+00+4.508927e-01i, +1.082191e+00-7.496681e-01i, +8.278079e-01+8.476801e-01i, -5.759581e-01+4.095286e-04i },
{ -1.547382e+00+4.310749e+00i, -4.756207e+00+3.172154e+00i, -1.225530e+00-6.732178e-02i, +8.328101e-02-1.138760e-01i, -3.804274e-02-1.037630e-01i },
},
{
{ -9.941063e-01-7.627273e-02i, +4.584855e+00-2.255167e+00i, +4.242671e+00-6.594207e-01i, +1.584306e+00-1.451116e-01i, -6.601509e-01+1.745624e-01i },
{ +1.944025e+01+2.175629e+01i, +2.095955e+01+4.877442e+01i, +1.230183e+01+1.596722e+01i, +2.533812e+00+1.015321e+00i, -2.815886e-01-2.926891e-01i },
{ -2.677317e-01+2.177033e+01i, -1.020341e+01+3.017908e+01i, -8.380240e+00+7.357808e+00i, -1.361805e+00-1.318400e+00i, +3.966868e-03-1.434505e-02i },
{ -4.174802e+00-5.828272e+00i, +1.909035e+00-7.062011e+00i, -6.336424e-01-1.395023e+00i, -6.286271e-01-2.116045e-02i, +1.699361e-01+1.874855e-01i },
{ +1.720115e+00+1.115438e+00i, +1.352861e+00+2.556688e+00i, +2.482142e-01+1.149413e+00i, -7.169268e-02-3.236209e-02i, +1.198369e-02-8.151302e-03i },
},
{
{ -2.279565e+00-1.597006e-01i, -4.820077e+00-2.216802e+00i, -2.537535e+00-6.976147e-01i, -1.649626e-01-5.143931e-01i, -1.124862e-01+1.768555e-01i },
{ +2.703892e+00-5.019342e+00i, +4.830097e+00-4.511849e+00i, +2.896699e+00-1.473475e+00i, +7.610278e-01-7.297921e-02i, -1.844235e-01+1.046074e-01i },
{ +3.296861e+00+2.503622e+00i, +1.987642e+00+1.680302e+00i, +1.150496e+00+2.613750e-01i, +1.731945e-01+5.543019e-01i, -2.606226e-02-7.830241e-02i },
{ -2.749867e+00+6.565269e-01i, -2.574954e+00-2.158229e+00i, -6.783936e-01-7.957487e-01i, -2.639404e-01+1.187218e-01i, +1.169489e-01-4.406251e-02i },
{ +4.303601e-01-2.517984e-01i, +8.720816e-01-7.766818e-03i, +3.992884e-01+1.831142e-01i, -5.947307e-03+2.467566e-02i, +1.691916e-02-1.561237e-03i },
},
{
{ -5.970993e-01+4.959096e-02i, -3.865662e-01+2.346539e-01i, -9.250641e-04+1.370794e-01i, +2.549252e-02-4.583181e-02i, +8.918109e-03+1.953235e-02i },
{ +1.090983e-01-5.160261e-01i, +3.094922e-01+3.227555e-01i, -3.214632e-02+1.606870e-01i, -1.857024e-02-2.757391e-02i, +6.459015e-04+1.185513e-02i },
{ +5.768059e-01+4.253294e-01i, +1.239721e-01+1.051136e+00i, -2.268496e-01+3.857121e-01i, -6.505994e-02+9.126805e-03i, -1.535106e-03-5.924543e-03i },
{ -8.429246e-02+9.864617e-02i, -3.396855e-02+9.803323e-02i, -1.657396e-02+1.136310e-01i, -3.000259e-02-5.982742e-04i, +9.143870e-03-2.139896e-03i },
{ +9.448701e-02-2.447158e-02i, +1.216581e-01+4.772030e-02i, +2.473839e-02+4.748301e-02i, -5.829785e-03+2.080127e-03i, +7.978153e-04+4.324811e-04i },
}
},
{// coil1
{
{ +2.385197e+01+2.642746e+01i, +1.930590e+01+1.838885e+01i, +2.507474e+00+4.349635e+00i, +5.631193e-01+4.818895e-01i, -5.121442e-01-9.501158e-02i },
{ -3.237717e+01+3.511263e+01i, -2.092594e+01+3.586824e+01i, -5.601183e+00+9.289018e+00i, +9.297323e-02+1.123677e+00i, +2.541592e-01-3.509815e-01i },
{ -8.610624e+00-1.653243e+01i, -6.581598e+00-7.905491e+00i, -2.464309e-01-3.189951e+00i, +6.995536e-01-2.256272e-01i, -1.911719e-01-1.026264e-01i },
{ +7.177132e+00+6.765253e+00i, +1.091381e+00+4.411089e+00i, +1.508211e+00-1.848976e+00i, +7.469740e-01+9.825532e-01i, -4.035179e-01-3.455322e-01i },
{ -3.299001e+00-1.483860e+00i, -3.700850e+00-1.712568e+00i, -5.358298e-01-7.157450e-01i, +1.312292e-01+6.146327e-02i, -1.727322e-02-4.200834e-02i },
},
{
{ +5.341547e+01+1.283567e+01i, +3.471382e+01+9.828249e+00i, +5.651398e+00+3.255332e+00i, +1.257962e+00+1.179041e+00i, -1.012650e+00-1.141276e-01i },
{ -3.608642e+00+1.095887e+02i, +1.061413e+01+1.022679e+02i, +7.426286e+00+2.337769e+01i, +6.584866e-01+1.575268e+00i, +4.274051e-01-1.155295e+00i },
{ -3.802571e+01+2.575859e+00i, -2.073445e+01+2.310744e+01i, -1.635183e+00+8.826267e+00i, -9.802866e-01-1.260385e+00i, +4.070259e-01-1.527533e-03i },
{ +1.525615e+01-4.332912e+00i, +7.974647e+00-8.376435e-01i, +2.831879e-01-1.148257e+00i, +3.362815e-01+5.120907e-01i, -4.586066e-01-1.968062e-02i },
{ -5.312905e+00+2.771210e+00i, -4.678797e+00+2.437691e+00i, -6.572716e-01-2.463070e-01i, +1.999573e-01-1.584218e-01i, -1.232127e-02-6.702929e-02i },
},
{
{ +1.219398e+01-1.332469e+01i, +5.810475e+00-3.802096e+00i, +1.658302e+00+9.301548e-01i, +3.995355e-01+1.020377e+00i, -2.977041e-01+1.318151e-01i },
{ +2.781616e+01+4.034521e+01i, +2.972589e+01+3.681420e+01i, +1.135461e+01+2.501358e+00i, +9.403465e-01-8.290226e-01i, -5.431542e-02-4.099356e-01i },
{ -1.619964e+01+1.670780e+01i, -3.411593e+00+2.536501e+01i, +1.345721e+00+6.044260e+00i, -9.014602e-01-1.020613e+00i, +4.580130e-01+1.269802e-03i },
{ +2.309359e+00-9.232351e+00i, +8.995861e-01-5.658281e+00i, -1.838073e+00+1.635053e+00i, -7.931994e-01+4.829694e-01i, +5.181142e-02+1.704118e-01i },
{ -6.831076e-01+3.059381e+00i, +5.939837e-01+1.912238e+00i, +4.098613e-01-2.511110e-01i, +5.071101e-02-1.923188e-01i, +7.774166e-03-5.105620e-02i },
},
{
{ -4.299400e+00-3.802627e+00i, -4.337889e+00+3.049497e-01i, -1.490814e+00+1.259508e+00i, -1.553455e-01+2.141244e-01i, +6.786358e-02+7.899867e-02i },
{ +6.237897e+00-3.942827e+00i, +2.950844e+00-4.780952e+00i, -2.455671e-01-2.999563e+00i, -2.275766e-01+4.366150e-02i, -1.099414e-01+4.333284e-02i },
{ +1.102509e+00+4.634275e+00i, +2.007538e+00+1.330120e+00i, +2.144526e+00-2.326242e+00i, +3.216676e-01+5.589747e-02i, +6.761169e-02-1.253487e-01i },
{ -2.238572e+00-7.896340e-01i, -2.487401e+00-9.949795e-01i, -3.539411e-01+4.891800e-01i, -1.240309e-01+2.542098e-01i, +8.820435e-02-1.429020e-02i },
{ +4.534218e-01+3.641333e-01i, +6.501793e-01-1.528762e-01i, +1.679819e-01-2.071546e-01i, -1.452196e-02-3.464354e-02i, +7.477547e-04-1.587790e-02i },
},
{
{ -6.293721e-01-3.299211e-01i, -2.678528e-01+2.865616e-01i, +8.788246e-02+1.902665e-01i, +1.112593e-02-1.772978e-02i, +2.599968e-02+9.115638e-03i },
{ +4.409342e-01-2.733979e-01i, +3.259049e-01+1.715056e-01i, -1.537559e-01+1.363355e-01i, -6.110496e-02+4.910981e-02i, +7.523296e-03+9.987387e-03i },
{ +1.693678e-01+5.066220e-01i, +2.857842e-01+6.959039e-01i, +1.181406e-02+1.737422e-01i, -5.622053e-02+2.777171e-02i, +2.864604e-03-1.254479e-02i },
{ -4.649362e-02-9.524550e-02i, +2.390397e-02+6.562707e-02i, +4.040518e-02+1.402306e-01i, -2.636843e-02+4.764821e-03i, +7.125942e-03-1.187462e-03i },
{ +7.393658e-02+5.336921e-02i, +9.178045e-02+3.915395e-02i, +1.192168e-02+8.860635e-03i, -6.746802e-03-3.119754e-03i, -1.089890e-03-8.002412e-04i },
}
},
{// coil2
{
{ -3.403434e+00+2.305823e+00i, -9.173691e+00-2.044424e+00i, +3.953760e+00-4.375232e+00i, +2.006047e+00+3.369222e+00i, -3.569105e-01-4.511923e-01i },
{ -9.725736e+00+9.096604e+00i, -3.034262e+01-2.486988e+01i, +1.534449e+01-2.870583e+01i, +5.896712e+00+5.959168e+00i, -2.199273e+00-2.922885e+00i },
{ -1.462313e+01+1.803488e+01i, -3.089485e+01-3.152813e+01i, +1.491602e+01-2.266630e+01i, -1.095131e+00+6.847529e+00i, -1.853819e-01-2.714308e+00i },
{ -9.781010e+00+7.670334e+00i, -6.622701e+00-1.363642e+01i, +8.735390e+00-3.109019e-01i, -2.348500e+00+2.667053e+00i, +1.218745e+00-1.008132e+00i },
{ -1.035051e+00+2.140254e-01i, -1.497293e-01-1.816075e+00i, +1.025944e+00-9.201358e-02i, -5.616722e-01+1.157484e-01i, +1.029341e-01-1.249652e-01i },
},
{
{ +2.869098e+00+6.592072e-01i, +1.159315e+01-5.645511e+00i, +7.428229e+00+9.434171e-01i, -1.435680e+00+3.497872e+00i, +5.635483e-01-8.096975e-01i },
{ +4.703547e+00-1.443229e+01i, +4.206048e+01-2.838601e+01i, +2.919562e+01+7.142639e-02i, -4.473191e+00+3.966155e+00i, +3.641058e-01-2.848915e+00i },
{ -3.855065e+00-1.714039e+01i, +3.759167e+01-3.142441e+01i, +2.275507e+01+1.016559e+01i, -7.831704e+00+2.908892e+00i, +1.953096e+00-6.581367e-01i },
{ -7.756438e+00-4.766596e+00i, +1.106559e+01-1.145837e+01i, +5.932114e+00+8.599508e+00i, -3.111799e+00-1.293584e+00i, +2.051531e+00+1.686476e-01i },
{ -6.567480e-01-7.626402e-01i, +1.306720e+00-1.140145e+00i, -4.001230e-02+9.299629e-01i, -9.565089e-01-4.132185e-01i, +1.356172e-01+5.341575e-03i },
},
{
{ +6.855156e+00+2.816421e+00i, +1.454817e+00+5.780614e+00i, +6.040018e-01+1.289875e+00i, +7.052189e-01-8.275602e-01i, +4.228933e-01+1.243618e-01i },
{ +2.546489e+01+8.401590e+00i, +8.472530e+00+2.949411e+01i, -8.858128e+00+1.039709e+00i, -1.183058e+00-3.295759e+00i, +2.330525e-01-1.109967e+00i },
{ +2.336399e+01+1.338775e+00i, +8.773703e+00+3.080132e+01i, -1.322342e+01+6.324916e+00i, -2.780136e-01-2.238187e+00i, -3.978814e-01+2.150966e-01i },
{ +5.451294e+00-2.853596e+00i, +4.457461e+00+7.990840e+00i, -5.604748e+00+2.378420e+00i, +9.851373e-01-2.738413e+00i, +2.656846e-01+6.944483e-01i },
{ +6.833313e-01-5.189475e-01i, +6.691288e-01+9.173263e-01i, -1.164178e+00+5.845664e-01i, -3.124786e-01-4.460576e-01i, -1.207910e-02+7.812045e-02i },
},
{
{ -1.838945e+00+1.935486e+00i, -5.051211e+00-2.148578e+00i, +1.645568e+00-4.063464e-01i, +1.707058e-01+5.261207e-02i, +1.622506e-01-3.722946e-02i },
{ -4.842945e+00+9.406182e+00i, -1.538813e+01-9.061817e+00i, +5.693454e+00-7.489427e+00i, -9.365201e-03+2.189275e+00i, +3.458934e-01-1.269165e+00i },
{ -3.882134e+00+9.808001e+00i, -1.561062e+01-7.496658e+00i, +4.850759e+00-8.725040e+00i, +4.648783e-01+3.066459e+00i, -1.307966e-01-1.225572e+00i },
{ -5.756843e-01+2.338671e+00i, -3.632082e+00-1.228461e+00i, +8.914917e-01-2.394881e+00i, +5.611225e-01+6.812363e-01i, -7.544452e-02-1.635813e-01i },
{ -4.890777e-02+1.019771e-01i, -2.103800e-01-1.800286e-01i, +5.329032e-02-1.656238e-01i, +1.028541e-02+1.338817e-02i, -8.288778e-03-1.650072e-02i },
},
{
{ +5.587118e-01-4.811784e-01i, +1.651097e+00+5.531245e-02i, -7.263400e-02+7.844478e-01i, -3.237036e-01-1.072347e-01i, +6.086519e-02+4.961727e-02i },
{ +1.264239e+00-1.401070e+00i, +4.860535e+00+4.805208e-01i, +8.663616e-01+3.288491e+00i, -8.416755e-01+4.469077e-02i, +2.204679e-01+3.120945e-02i },
{ +9.091449e-01-1.144321e+00i, +3.789164e+00+2.357970e-01i, +1.156079e+00+2.493849e+00i, -6.110172e-01+7.286378e-02i, +1.637932e-01-1.854398e-02i },
{ +2.216328e-01-2.817686e-01i, +7.964476e-01+8.379297e-02i, +1.464791e-01+4.834903e-01i, -1.515124e-01-2.817963e-02i, +3.532854e-02-4.083352e-03i },
{ +1.400091e-02-3.679913e-02i, +8.882731e-02+2.998342e-03i, +1.557691e-02+6.330919e-02i, -1.926195e-02-4.921175e-03i, +4.162480e-03-7.632396e-04i },
}
},
{// coil3
{
{ +5.605620e+00+1.912405e+00i, -2.688246e+00+1.142681e+01i, -7.448085e+00+6.072540e-01i, +1.905331e+00-8.293635e-01i, -8.814158e-01+1.464969e+00i },
{ +8.918386e+00+5.324855e-01i, -3.545862e+00+3.181981e+01i, -2.437810e+01+9.838087e+00i, +3.464007e+00-7.633417e+00i, +4.687456e-01+2.815293e+00i },
{ +6.289315e+00-8.687450e+00i, +1.378634e+01+2.035749e+01i, -1.834439e+01+1.763603e+01i, -3.187290e+00-8.617926e+00i, +1.371342e+00+2.030694e+00i },
{ -6.505593e-01-4.961855e+00i, +1.067407e+01+9.831616e-01i, -1.143140e+00+8.520220e+00i, -2.492470e+00-1.580094e+00i, +8.328853e-01+5.630521e-01i },
{ -7.780704e-01-5.678068e-01i, +5.541916e-01-8.537685e-01i, +1.882765e-01+4.748169e-01i, -3.093048e-01-2.622543e-01i, +1.032600e-01-2.434528e-02i },
},
{
{ -3.432682e+00+3.075899e+00i, -6.791749e+00+7.768665e-01i, +8.938562e-01-2.569780e+00i, +3.157008e-01+2.044825e+00i, -1.182522e+00+2.061942e-01i },
{ -1.710295e+01+8.861412e+00i, -4.860973e+01-1.150458e+01i, -1.250427e+01-2.452517e+01i, +8.269650e+00+8.195729e-01i, -1.855940e+00+7.002552e-01i },
{ -4.012698e+00+6.732320e+00i, -4.184198e+01+1.215793e+00i, -2.515072e+01-2.214134e+01i, +7.061616e+00-4.320611e+00i, -1.785584e+00+1.786741e+00i },
{ +5.038624e+00+3.076361e-01i, -1.214103e+00+1.241177e+01i, -1.051641e+01+7.248909e-01i, +1.856858e+00-3.183489e+00i, -3.992200e-03+1.379749e+00i },
{ -4.404712e-02-1.412169e+00i, +1.058674e+00+2.463492e-01i, -1.211662e+00+4.294572e-01i, -2.675392e-01-9.494120e-01i, +1.050199e-01+7.297602e-02i },
},
{
{ +2.366583e+00-5.703110e+00i, +8.087670e+00-1.934431e+00i, +8.870035e-01+2.982852e+00i, -2.923669e-01+6.004041e-01i, -5.099764e-01-2.380979e-01i },
{ -1.301697e+01-1.663454e+01i, +1.275642e+01-3.280564e+01i, +1.134640e+01-1.264895e+00i, -1.996112e+00+1.504760e+00i, +5.937809e-02-4.076723e-01i },
{ -1.793770e+01-3.340239e+00i, -4.995670e+00-3.510353e+01i, +1.442949e+01-6.602766e+00i, -1.495451e+00+5.558200e+00i, -2.140656e-01-7.114264e-01i },
{ -2.892725e+00+4.467111e+00i, -7.338062e+00-3.953029e+00i, +3.664102e+00-5.440608e+00i, +2.300210e+00+1.991848e+00i, -3.015265e-01+3.355651e-02i },
{ +3.604283e-01-5.433679e-02i, -5.372115e-01+3.493686e-01i, -9.799627e-01-8.891897e-01i, +1.192539e-01-5.419423e-01i, -9.907045e-03+2.046086e-02i },
},
{
{ +3.779332e+00+1.501180e+00i, -1.974655e+00+3.353281e+00i, -1.308762e+00-1.495532e+00i, +1.525151e+00+9.426407e-01i, -5.474032e-01-9.980388e-02i },
{ +7.536972e+00-3.007684e+00i, +5.010758e+00+1.263414e+01i, -8.574388e+00+1.989594e+00i, +1.419406e+00-3.183966e+00i, -2.335248e-01+7.482648e-01i },
{ +1.153240e+00-5.093497e+00i, +1.116499e+01+5.262027e+00i, -3.705947e+00+9.448317e+00i, -3.061843e+00-2.174341e+00i, +5.606662e-01+3.163803e-01i },
{ -1.786084e+00-5.130727e-01i, +2.216143e+00-2.424175e+00i, +2.606819e+00+2.190622e+00i, -9.395951e-01+8.520539e-01i, +1.499920e-01-1.484614e-01i },
{ +4.748658e-02+1.920642e-01i, -2.473569e-01+3.966807e-02i, -9.794883e-02-2.610688e-01i, +3.268207e-02-6.301905e-02i, -2.888158e-03-1.091955e-02i },
},
{
{ -6.863262e-01+1.188560e-01i, -3.789646e-01-1.543353e+00i, +1.122458e+00-5.102425e-01i, -8.015486e-02+3.852463e-01i, -3.570712e-02-1.315551e-01i },
{ -1.142035e+00+4.427400e-01i, -2.849134e+00-2.795824e+00i, +9.727226e-01-2.941726e+00i, +6.831532e-01+4.497749e-01i, -1.622823e-01-7.718691e-02i },
{ -4.858964e-01+2.764938e-01i, -2.236984e+00-9.819341e-01i, -4.823025e-01-2.091762e+00i, +5.753284e-01-1.572611e-01i, -6.586402e-02+3.715748e-02i },
{ -9.643952e-02+5.572815e-02i, -4.015320e-01-4.519478e-02i, -2.383567e-01-2.737845e-01i, +5.379965e-02-9.406574e-02i, +5.189314e-03+8.550368e-03i },
{ +8.731607e-03+3.091300e-02i, -6.906641e-02+4.336378e-02i, -5.336497e-02-3.196825e-02i, +8.544100e-03-1.452453e-02i, -1.277833e-04+1.069641e-03i },
}
},
{// coil4
{
{ -2.157478e-01+7.843722e-02i, +2.158027e+00+3.456836e-01i, +4.384810e-01-2.469153e-01i, -1.586388e-02-3.478851e-01i, -9.871390e-02+1.501717e-02i },
{ +3.842162e+00+3.666963e+00i, -1.218519e+00+1.148102e+01i, -3.864166e+00+2.791877e+00i, +9.194686e-02+1.024752e-01i, -2.131570e-01+5.570281e-02i },
{ +1.856230e+00+5.488655e+00i, -5.455579e+00+7.229715e+00i, -1.160419e+00+1.039701e+00i, +3.692947e-01+1.122129e+00i, -5.902225e-02-4.088153e-01i },
{ -7.126163e-01+1.231048e+00i, -1.195070e+00-1.144426e+00i, +1.258947e+00-3.510721e-01i, -2.947186e-01+4.140945e-01i, +1.068221e-01-1.931445e-01i },
{ -1.029430e-01+1.425960e-01i, -1.909393e-01+4.160807e-02i, -4.733071e-02+7.068992e-02i, -3.669503e-03+3.247190e-02i, +1.443675e-02-1.603802e-02i },
},
{
{ -2.986665e+00-6.459527e-01i, -1.890181e+00+1.678473e+00i, +1.984078e-01+1.299282e+00i, -2.445787e-01-2.737639e-01i, -1.322228e-02+1.087409e-02i },
{ -1.156512e+01+5.259171e+00i, -2.319497e+01+8.270215e+00i, -8.410024e+00+1.494618e+00i, +3.391051e-01+2.683806e-02i, -6.780789e-02+4.986268e-02i },
{ -8.035677e+00+2.436010e+00i, -1.803080e+01-1.118357e+00i, -3.737400e+00-2.447259e+00i, +3.629207e-01+3.650657e-01i, +1.269244e-01-4.797023e-01i },
{ +3.717721e-02+5.208994e-01i, -3.651485e-02-1.582900e+00i, +1.041617e+00+8.585656e-02i, -8.258001e-01+1.162488e-01i, +2.095726e-01-1.697043e-01i },
{ -5.926212e-01+3.060426e-01i, -5.063045e-01-2.562053e-02i, -1.191151e-02+1.295451e-01i, +1.029724e-02+4.931237e-02i, +4.163158e-02-1.378641e-02i },
},
{
{ +2.464586e-01-1.358780e+00i, +1.333038e+00+1.036676e+00i, -1.174043e+00+7.588560e-01i, -5.290928e-01-9.775746e-02i, +5.097906e-02-7.837021e-02i },
{ -4.309914e+00-8.641219e-01i, -7.188424e+00-1.846045e+00i, -9.124423e-01-2.687199e-01i, +2.601996e-01+9.054061e-01i, -5.663634e-02-1.639002e-01i },
{ -2.913263e+00-2.114232e+00i, -3.921907e+00-5.557762e+00i, +1.589374e+00-2.200231e+00i, +1.902742e-01+2.506939e-01i, +1.357181e-01-2.109363e-01i },
{ +7.370237e-01-7.305151e-02i, +1.189955e+00+1.010238e-01i, -1.223231e-01+7.197558e-01i, -7.058820e-01-3.009856e-01i, +1.607036e-01+2.421457e-03i },
{ -4.525241e-01+6.669010e-02i, -1.685742e-01-1.578712e-01i, +1.268559e-01+7.284775e-02i, +1.106670e-02+2.268060e-02i, +3.381197e-02+4.141167e-03i },
},
{
{ +6.925261e-01+3.300573e-01i, +8.414235e-01+8.483170e-01i, -6.156247e-01-4.061725e-01i, -9.281959e-02-4.464108e-02i, -4.362991e-03-4.506768e-02i },
{ +1.721463e+00+1.897876e+00i, +5.574184e-01+2.643993e+00i, -6.704438e-02+1.004571e-02i, -2.372341e-02+4.419843e-01i, -9.668687e-02-1.285216e-01i },
{ +5.390539e-01+1.632274e+00i, +4.968107e-02+1.518912e+00i, +8.256848e-01+4.033909e-01i, +1.610276e-02+4.113619e-01i, -2.594583e-03-9.343975e-02i },
{ -1.517849e-01+2.194112e-01i, -1.606055e-01+1.197092e-01i, -4.798010e-02+1.404636e-01i, -1.072677e-01-6.939784e-02i, +4.073437e-02-2.048770e-03i },
{ -5.794294e-02+8.797695e-03i, -7.106577e-03-1.071693e-02i, +2.625638e-02+2.506930e-02i, -3.246675e-03+5.588892e-03i, +5.605322e-03+2.491409e-03i },
},
{
{ -2.312750e-01-1.279671e-01i, -2.922333e-01-1.333840e-01i, +8.012712e-03-9.979881e-03i, +3.097853e-02+1.843313e-02i, +1.030054e-03-2.710439e-03i },
{ -6.768651e-01-2.941508e-01i, -9.327285e-01-8.360069e-01i, -8.333361e-02-5.280063e-01i, +2.306036e-02-1.305592e-02i, -2.771912e-03-1.977664e-02i },
{ -4.071324e-01-3.024773e-01i, -4.600044e-01-7.767227e-01i, -4.603283e-02-3.896405e-01i, -2.645133e-02-1.064619e-02i, +3.599624e-03-1.668610e-02i },
{ -2.072687e-02-7.532579e-02i, +2.573126e-02-1.239444e-01i, +1.001824e-02-7.962175e-03i, -1.516424e-02-2.956013e-03i, +4.146429e-03-1.175645e-03i },
{ -5.571307e-03+2.833187e-03i, -3.954418e-03-2.000257e-03i, -1.036591e-03-2.024441e-04i, -1.208784e-03+4.361219e-04i, +2.980089e-04+1.419185e-04i },
}
},
{// coil5
{
{ +5.627298e+00-2.319658e-01i, +5.451195e+00+4.725244e+00i, +2.198400e+00+2.944769e+00i, -7.118429e-01+4.421486e-01i, +1.097514e-01-6.183823e-02i },
{ -2.092578e+00+1.336667e+01i, -1.721669e+01+1.166127e+01i, -8.016964e+00+6.363907e-01i, -4.794767e-01-1.123548e+00i, +9.865941e-02+7.426664e-02i },
{ -1.196156e+01+3.957886e+00i, -1.883933e+01-8.173641e+00i, -3.970006e+00-5.468193e+00i, +2.818542e-01+1.493716e-01i, +2.566095e-02+2.088994e-03i },
{ -3.163270e-01-2.100422e+00i, +2.010498e+00-3.001727e+00i, +1.531082e+00+2.666653e-01i, -1.186036e-01+3.782215e-01i, +1.452413e-02-1.463945e-02i },
{ -2.407511e-01+3.926551e-01i, -7.597666e-01+5.109599e-01i, -5.847693e-01-7.781662e-02i, -1.758328e-02-1.346702e-01i, +7.668109e-03+9.326496e-03i },
},
{
{ -7.005945e+00+4.746756e+00i, -6.162196e+00-4.815452e+00i, +2.065377e+00-9.787791e-01i, -1.225089e+00+2.202903e-01i, +4.897364e-01-1.788376e-01i },
{ -3.298536e+01-2.341832e+01i, -1.435239e+01-4.586462e+01i, +2.204468e+00-9.042686e+00i, -6.529927e-01-1.750170e+00i, +7.278560e-01+8.417848e-01i },
{ -9.806167e+00-3.130775e+01i, +9.446423e+00-3.746255e+01i, +5.038912e+00-3.680653e+00i, -2.965655e-01+1.389146e-01i, +1.326766e-01+5.831417e-01i },
{ +4.558433e+00-1.310400e+00i, +5.653606e+00+1.882880e+00i, +6.350725e-01+2.117109e+00i, -4.162477e-01+6.960168e-02i, -8.970490e-03-7.929359e-02i },
{ -8.990121e-01-2.819930e-01i, -1.186255e+00-6.634634e-01i, -4.042153e-01-5.093642e-01i, +4.269211e-02-9.630066e-02i, +1.326704e-02+1.267193e-02i },
},
{
{ -8.002192e+00-6.909636e+00i, +3.537404e+00-1.308366e+01i, +3.684870e+00+1.333263e-01i, -5.652192e-01-4.911472e-01i, +4.384364e-01+1.666431e-01i },
{ +3.628493e+00-3.082275e+01i, +2.659392e+01-2.061203e+01i, +4.131354e+00+4.498805e+00i, -3.310416e-01-1.116709e+00i, +2.824426e-02+9.427934e-01i },
{ +1.409120e+01-1.054237e+01i, +1.696650e+01+1.236495e+00i, +1.410742e-01+4.022187e+00i, +2.349886e-01+1.543565e-01i, -3.684831e-01+1.884515e-01i },
{ +1.204271e+00+3.716567e+00i, -2.300264e+00+3.360950e+00i, -7.468280e-01-5.375360e-01i, +5.572063e-02+1.371805e-02i, -4.340862e-02-2.051596e-01i },
{ -1.574145e-02-3.554098e-01i, -1.286454e-01-4.774792e-01i, +1.071551e-01-2.094684e-01i, +4.581254e-02+5.677002e-02i, -6.309262e-03-2.719061e-04i },
},
{
{ +1.838519e+00-1.433432e+00i, +3.466756e+00+1.858265e+00i, -1.088819e-01+1.562591e+00i, -7.832015e-02-2.556812e-01i, -9.199694e-03+7.907245e-02i },
{ +5.529809e+00+4.611208e+00i, -1.786498e+00+9.189687e+00i, -3.896473e+00+4.711835e-01i, +2.935280e-01-1.368378e-01i, -2.565714e-01-9.789293e-02i },
{ -8.589846e-01+6.474260e+00i, -7.988256e+00+2.880274e+00i, -1.887052e+00-2.455573e+00i, +4.134971e-01+4.198810e-01i, -1.107944e-01-3.010450e-01i },
{ -1.397678e+00+3.802664e-01i, -1.435173e+00-1.388451e+00i, +5.895678e-01-7.028868e-01i, +3.348207e-02+1.893625e-01i, +2.579908e-02-8.254927e-02i },
{ +1.103054e-01+5.750737e-02i, -3.967279e-02+6.720620e-02i, -1.233437e-02-5.481677e-03i, -1.147639e-03+1.827948e-02i, -4.127775e-03-4.308871e-03i },
},
{
{ -6.058544e-01-1.080865e-01i, -7.119054e-01-7.170821e-01i, -2.545336e-02-3.552243e-01i, +1.690619e-02+3.260862e-03i, +6.373931e-03-1.107458e-02i },
{ -9.689134e-01-1.496909e+00i, +1.584070e-01-2.955295e+00i, +1.056795e+00-8.051099e-01i, +6.489031e-02+1.183660e-01i, +3.079211e-02-3.031088e-02i },
{ +1.048416e-01-1.348823e+00i, +1.581497e+00-1.744959e+00i, +1.140884e+00+1.249015e-03i, -3.449183e-02+1.314055e-01i, +3.145241e-02-1.870899e-02i },
{ +2.144096e-01-1.528390e-01i, +4.420397e-01+6.290129e-02i, +9.555343e-02+1.968731e-01i, -4.507116e-02+6.839404e-03i, +6.589680e-03-1.443118e-03i },
{ +6.380179e-03-6.388619e-03i, -6.677897e-04-4.804202e-03i, -3.233425e-03-7.257214e-03i, +1.015330e-03-2.086258e-03i, +1.221820e-04+2.174905e-04i },
}
},
{// coil6
{
{ -7.588173e+00-4.568666e+00i, +5.178052e+00-3.813914e+00i, +2.478045e+00+8.447182e+00i, -2.103042e+00-7.574825e-01i, +7.728994e-01+6.765252e-01i },
{ -1.725386e+01-7.981859e+00i, +1.613678e+01-3.723935e+01i, +2.137163e+01+3.949069e+00i, -4.098016e+00-2.431972e+00i, +3.686922e+00+4.869144e-01i },
{ -1.189912e+01+1.376617e+01i, -6.326962e+00-4.189747e+01i, +2.740353e+01-3.784064e+00i, -1.340521e+01+4.432820e+00i, +5.565590e+00-5.354796e+00i },
{ +2.321959e+00+1.759567e+01i, -2.011330e+01-9.116474e+00i, +1.490673e+01-7.694004e+00i, -3.952432e+00+1.010297e+01i, +3.712416e-02-5.019773e+00i },
{ +2.452285e+00+1.636122e+00i, -3.484153e+00+7.155821e-01i, +1.117499e+00-3.894820e+00i, +1.302298e+00+1.260467e+00i, -5.639756e-01-3.634944e-01i },
},
{
{ -1.222317e+00-7.558949e+00i, +2.391630e+01-1.884233e+00i, +4.565760e+00+1.027076e+01i, -4.100936e+00+4.329197e-01i, -8.780063e-01+4.760475e-01i },
{ -1.013136e+01-3.483023e+01i, +9.089527e+01-5.902791e+01i, +4.699886e+01+1.721652e+01i, -4.589780e+00-2.644255e+00i, +4.030035e+00+5.267982e+00i },
{ -2.325154e+01-6.755814e+00i, +4.726454e+01-8.885654e+01i, +5.661195e+01+9.052612e+00i, -2.064037e+01-4.059988e-02i, +1.215969e+01-3.478825e+00i },
{ -4.250752e+00+2.382361e+01i, -2.503552e+01-2.777509e+01i, +2.688101e+01-7.943939e+00i, -9.552497e+00+1.324552e+01i, +2.110860e+00-7.873277e+00i },
{ +3.887331e+00+3.648224e+00i, -6.074620e+00+4.833894e-01i, +2.504430e+00-6.241066e+00i, +1.943594e+00+2.461918e+00i, -8.745265e-01-6.844600e-01i },
},
{
{ +2.818071e+00-1.010688e+01i, +1.568608e+01+1.476415e+00i, +1.978928e+00+5.969872e+00i, +1.073745e+00+4.818000e-01i, -1.770739e+00+7.610951e-01i },
{ -7.845513e+00-3.063251e+01i, +6.598685e+01-3.007256e+01i, +1.824116e+01+1.641481e+01i, -1.368087e+00-6.581175e+00i, +2.368722e+00+6.138712e+00i },
{ -2.866791e+01-1.518951e+01i, +4.564369e+01-5.205790e+01i, +2.200469e+01+2.742644e+01i, -1.639217e+01-8.553436e+00i, +1.008916e+01+1.765424e+00i },
{ -1.170624e+01+8.296269e+00i, -3.321378e+00-2.264227e+01i, +1.654207e+01+7.052054e+00i, -9.514467e+00+4.427884e+00i, +3.264199e+00-3.690093e+00i },
{ +1.250425e+00+2.089892e+00i, -2.807684e+00-1.154238e+00i, +2.057572e+00-2.569287e+00i, +4.989607e-01+1.442196e+00i, -3.047774e-01-4.465058e-01i },
},
{
{ +8.637959e-01-3.098943e+00i, +1.341884e+00+3.897656e+00i, -2.290442e+00+2.155311e+00i, +1.165243e+00-1.125944e+00i, -3.965019e-01+4.747601e-01i },
{ -4.038377e+00-5.533266e+00i, +6.885084e+00-2.185455e+00i, -2.700472e+00+3.122900e+00i, -3.397155e-02-3.660563e+00i, +5.637347e-01+1.460603e+00i },
{ -8.724817e+00-1.379404e+00i, +4.677473e+00-6.282824e+00i, -1.802643e+00+7.325674e+00i, -4.046482e+00-3.654889e+00i, +2.195305e+00+8.089048e-01i },
{ -3.484516e+00+1.162812e+00i, +1.345983e+00-3.542670e+00i, +2.490045e+00+3.970511e+00i, -2.514649e+00+1.669221e-01i, +9.493777e-01-4.285963e-01i },
{ -8.589968e-02+3.098654e-01i, -3.405843e-01-6.532078e-01i, +5.599114e-01-3.264288e-01i, -2.580138e-02+2.299813e-01i, -6.218243e-03-8.936563e-02i },
},
{
{ +4.421320e-01-8.689699e-02i, +7.630411e-01-2.539348e-03i, -1.671994e-01+1.550191e-01i, -1.755996e-01-2.782918e-02i, -1.075445e-02+2.332489e-02i },
{ +7.233387e-01-7.234845e-02i, +1.442616e+00-4.406170e-01i, +7.633194e-01+5.978773e-01i, -1.678142e-02+3.427020e-01i, +7.774075e-03+4.976288e-02i },
{ +3.653217e-01-2.570167e-02i, +1.015148e+00-5.406467e-01i, +8.952489e-01+2.580388e-01i, +1.226129e-01+2.585950e-02i, +1.076370e-01+5.491934e-02i },
{ +4.458658e-02-2.842130e-02i, +2.559381e-01-2.781094e-01i, +2.220035e-01+3.923400e-02i, -7.049237e-02-5.716923e-02i, +6.213430e-02-1.546683e-02i },
{ +4.759407e-03+1.305880e-02i, -2.994416e-02-3.353618e-02i, +2.589438e-02-3.202358e-02i, +7.434375e-03+1.064882e-02i, -1.527439e-03-3.589124e-03i },
}
},
{// coil7
{
{ +5.675313e+00+7.969339e+00i, -1.015744e+01+3.899812e+00i, +1.628710e+00-4.500052e+00i, +9.691465e-02+4.047727e+00i, -1.196027e+00-8.238726e-01i },
{ +1.231550e+00+1.993183e+01i, -4.303332e+01+8.017426e-01i, +2.342499e+00-1.961362e+01i, +4.014356e+00+9.351111e+00i, -2.063904e+00-3.952318e+00i },
{ +8.415176e+00+2.228659e+01i, -4.746994e+01-8.437336e+00i, +8.678596e+00-2.473401e+01i, -1.996272e-01+1.195567e+01i, -1.318200e+00-6.530960e+00i },
{ +6.278740e+00+1.421334e+01i, -1.605104e+01-3.371048e+00i, +8.021228e+00-7.992706e+00i, -1.236967e+00+6.384297e+00i, +1.646638e-03-2.975558e+00i },
{ -5.405601e-01+9.698671e-01i, -1.824416e+00-8.637905e-01i, +6.226171e-01-8.046452e-01i, -2.051265e-01+2.252567e-01i, +6.696261e-02-2.834436e-01i },
},
{
{ -7.644186e-01+9.519616e+00i, -1.235962e+01-3.669516e+00i, +5.632668e+00-6.686404e+00i, -1.480450e+00+4.078962e+00i, -7.206613e-01-1.131240e+00i },
{ -3.037516e+01+2.113391e+01i, -6.663343e+01-5.560673e+01i, +1.642476e+01-3.858391e+01i, +1.205498e+00+9.172935e+00i, +1.831852e+00-4.933911e+00i },
{ -3.061666e+01+3.543624e+01i, -8.233803e+01-7.718659e+01i, +3.007220e+01-3.871067e+01i, -1.089954e+01+1.472696e+01i, +4.921439e+00-1.042920e+01i },
{ -5.876528e+00+2.515025e+01i, -2.693468e+01-2.240315e+01i, +2.036032e+01-6.268431e+00i, -7.784676e+00+1.023355e+01i, +2.453048e+00-5.460823e+00i },
{ -1.428510e+00+1.660404e+00i, -2.548018e+00-3.048074e+00i, +2.124602e+00-1.126046e+00i, -6.165733e-01+5.114721e-01i, +2.748512e-01-5.270008e-01i },
},
{
{ -5.166805e+00+8.016083e+00i, -8.770234e+00-1.181322e+01i, +7.471545e+00-3.043307e+00i, -1.677693e+00+2.710415e+00i, +2.565626e-01-1.349072e+00i },
{ -2.806076e+01+1.624544e+01i, -3.617282e+01-5.635771e+01i, +2.043947e+01-1.986333e+01i, -5.021082e+00+5.105342e+00i, +3.753096e+00-3.807640e+00i },
{ -3.239119e+01+2.725427e+01i, -3.667542e+01-6.157080e+01i, +2.948571e+01-8.737280e+00i, -1.426412e+01+7.762702e+00i, +6.651565e+00-6.318054e+00i },
{ -1.158904e+01+1.513392e+01i, -1.025109e+01-1.958842e+01i, +1.663375e+01+3.051353e+00i, -7.773673e+00+5.266588e+00i, +2.921933e+00-3.215844e+00i },
{ -1.216541e+00+8.029661e-01i, -1.040228e+00-2.572462e+00i, +1.450078e+00-4.021821e-01i, -6.095046e-01+1.936857e-01i, +2.773160e-01-2.992795e-01i },
},
{
{ -1.511740e+00+1.793434e+00i, +1.716295e-02-3.898178e+00i, +2.758626e+00+1.343744e+00i, -9.602230e-01+1.283862e+00i, +1.052913e-01-4.634230e-01i },
{ -3.240093e+00+5.902726e+00i, -5.345880e+00-8.169125e+00i, +6.228401e+00-9.872723e-02i, -1.917567e+00+2.823016e+00i, +6.438636e-01-1.347173e+00i },
{ -2.319244e+00+6.954940e+00i, -4.242360e+00-6.283412e+00i, +5.860814e+00+1.579162e+00i, -3.443599e+00+2.072897e+00i, +1.190007e+00-1.502523e+00i },
{ -1.529746e+00+2.478486e+00i, -2.544543e-01-2.810971e+00i, +3.009593e+00+1.677831e+00i, -1.793702e+00+8.373107e-01i, +6.119070e-01-5.750130e-01i },
{ -1.461953e-01+1.173093e-01i, -1.277457e-01-3.242935e-01i, +1.444613e-01-1.729099e-02i, -1.156655e-01-1.751939e-02i, +5.930900e-02-4.004916e-02i },
},
{
{ -1.990839e-02-3.172511e-01i, +6.957063e-02-9.900413e-02i, -2.239647e-03-1.731948e-01i, +4.644290e-03-6.619351e-02i, -2.296686e-02-2.575365e-02i },
{ -4.984140e-04-1.082062e-01i, -9.434427e-01-7.418462e-01i, +3.156745e-01-1.002780e+00i, +1.410043e-01+1.494475e-01i, -4.752488e-02-1.294109e-01i },
{ -1.308736e-01+2.477641e-01i, -1.004267e+00-9.886813e-01i, +5.393822e-01-8.442979e-01i, +1.899979e-02+1.862684e-01i, +2.480817e-02-1.468072e-01i },
{ -2.339567e-01+5.846495e-02i, -2.376043e-01-4.950345e-01i, +2.530325e-01-1.297500e-01i, -8.322643e-02+6.424124e-02i, +3.655021e-02-4.866155e-02i },
{ -1.842637e-02+6.618457e-03i, -2.810088e-02-2.285284e-02i, +7.253043e-03-1.138229e-02i, +1.364644e-03-2.374568e-04i, +3.275791e-03-7.470838e-04i },
}
},
{// coil8
{
{ +6.700411e+00-9.155078e+00i, +6.266583e+00-3.985974e+00i, -4.891774e+00-8.807813e+00i, +2.004043e+00-2.669987e+00i, -7.746332e-01+1.056343e-02i },
{ +9.478639e-01-2.260667e+01i, +6.999785e+00-2.318596e+01i, -1.287780e+00-1.432201e+01i, +4.098954e+00+7.658002e-01i, +1.172519e-02+1.450874e+00i },
{ -1.183618e+01-2.645882e+01i, +5.469888e+00-3.029613e+01i, +7.534018e+00-2.390920e+00i, +3.257413e+00+2.127667e+00i, +8.036762e-01+1.127234e-01i },
{ -5.626582e+00-1.123368e+01i, +7.848750e+00-1.657708e+01i, +1.010205e+01+6.625085e-01i, -3.440380e-01+1.934945e+00i, +1.496818e-01-2.781402e-01i },
{ -8.517717e-01-5.039524e-01i, +1.177844e-01-2.159507e+00i, +1.381831e+00-5.452800e-01i, +2.867903e-01+4.566515e-01i, +7.007401e-02-5.678593e-02i },
},
{
{ -7.769861e+00-1.993031e+01i, +1.062922e+01-1.439235e+01i, -1.856030e+00+1.204620e+01i, -4.771451e+00-4.064725e+00i, +9.442210e-01-1.647471e-01i },
{ -2.370362e+01-7.549444e+00i, -2.514845e+01-3.320380e+00i, -3.060419e+01+1.265944e+01i, -7.080984e+00-6.543353e+00i, +1.557736e+00+1.254456e+00i },
{ -3.380795e+01+2.169108e+01i, -5.833170e+01+9.983523e+00i, -2.727835e+01-2.429720e+00i, +4.184165e-01-6.637598e+00i, +1.267634e+00+1.431029e-01i },
{ -1.213593e+01+1.078721e+01i, -2.008905e+01-5.760493e-01i, -5.341484e+00-6.125828e+00i, -6.903362e-01-1.841878e+00i, +6.574556e-02-1.937547e-02i },
{ -1.570393e+00+1.832128e+00i, -3.437014e+00+2.673651e-01i, -3.756102e-01-1.172930e+00i, +5.378309e-01+1.834395e-01i, +1.024834e-01+1.230217e-03i },
},
{
{ -1.712129e+00+1.169615e-01i, +6.871231e+00-8.441519e+00i, +1.131629e+01+2.732433e+00i, -4.522346e+00+3.391670e+00i, +8.161012e-01-1.377047e+00i },
{ +1.956336e+00+3.021441e+00i, +1.234154e+01+5.289299e+00i, +1.182561e+01+2.637466e+01i, -6.719875e+00+9.344442e+00i, +2.626384e-01-1.087330e+00i },
{ +1.482158e+01+7.201687e+00i, +1.071142e+01+2.541179e+01i, +1.543379e-01+1.824170e+01i, -1.283232e+00+8.118081e-01i, +4.017215e-01+3.757933e-01i },
{ +1.108528e+01+1.723393e+00i, +8.986409e+00+1.560521e+01i, -6.078394e+00+7.689949e+00i, -2.112859e+00-2.181033e+00i, +1.832656e-01+6.110256e-01i },
{ +6.686279e-01+4.435582e-01i, +6.680448e-01+2.383473e+00i, -3.237884e-01+1.261010e+00i, +1.890343e-02+4.555148e-02i, +8.777805e-02+9.795664e-02i },
},
{
{ +1.480154e+00-9.540930e-01i, -2.155083e+00-1.071815e-02i, -8.667063e-01-6.357912e+00i, +6.211056e-01+2.197937e-01i, -2.149406e-01-2.270539e-01i },
{ -5.803765e+00-7.672238e-01i, -5.747657e+00-8.578823e+00i, +5.633741e+00-8.585676e+00i, +2.416108e+00+2.190934e+00i, -4.209089e-01-4.508742e-01i },
{ -8.630520e+00-7.274144e+00i, +8.017477e-01-1.656535e+01i, +8.718319e+00-5.735209e+00i, +1.750776e+00+1.053479e+00i, +2.161636e-01-1.486432e-01i },
{ -2.691354e+00-5.844797e+00i, +3.921434e+00-7.409177e+00i, +2.854159e+00-2.332361e-01i, -2.260122e-01-1.848071e-01i, +2.546281e-01+7.227807e-02i },
{ -3.932713e-01-4.050000e-01i, +4.673885e-01-5.428337e-01i, +4.276664e-01+1.604637e-01i, -2.454788e-02+4.919889e-02i, +4.365536e-02+1.466115e-02i },
},
{
{ +2.923563e-02+1.990475e-01i, +1.958971e-01+1.111576e+00i, -1.379893e-01+1.162300e+00i, -8.331671e-02+6.427087e-02i, +2.302829e-02+2.339097e-02i },
{ +2.581126e+00+3.147966e+00i, -3.404402e-01+5.888065e+00i, -2.334792e+00+1.916605e+00i, -5.315965e-01-2.461536e-01i, -9.772927e-02+3.698542e-03i },
{ +2.401464e+00+4.696931e+00i, -2.108375e+00+6.504066e+00i, -3.265298e+00+1.210481e+00i, -5.698740e-01-2.047517e-01i, -1.131917e-01-1.632725e-02i },
{ +3.940336e-01+1.812221e+00i, -1.240258e+00+2.114631e+00i, -1.184739e+00+3.664550e-01i, -1.697215e-01-6.017600e-02i, -2.282340e-02-7.794634e-03i },
{ +5.233066e-02+2.100195e-01i, -1.375352e-01+2.444272e-01i, -1.306400e-01+3.337029e-02i, -2.263262e-02-8.665782e-03i, -2.135281e-03-2.165657e-03i },
}
},
{// coil9
{
{ -5.416249e+00-3.872969e+00i, +4.729969e-01+9.323182e-01i, -2.135535e+00+1.307801e+00i, +7.319615e-01-2.302198e-01i, +1.754041e-01+3.302697e-01i },
{ -2.528892e-01+1.137372e+01i, -2.817844e+00+2.007716e+01i, -6.196521e+00+5.819070e+00i, -2.029404e-01-3.077952e+00i, +6.559981e-01+1.606452e-01i },
{ +8.619316e+00+1.213019e+01i, +4.578815e+00+2.571152e+01i, -7.484074e+00+1.063610e+01i, -4.861455e+00-3.521746e+00i, +9.326385e-01-7.709699e-01i },
{ +2.527915e+00+1.490095e+00i, +3.201354e+00+6.839338e+00i, -2.080276e+00+7.188286e+00i, -3.693268e+00+8.550919e-01i, -5.858493e-02-6.971036e-01i },
{ +9.440880e-01+1.464099e-01i, +1.404264e+00+9.545960e-01i, +8.529417e-01+1.282857e+00i, -8.397618e-02+6.183413e-01i, -6.340396e-02-1.277555e-02i },
},
{
{ -7.062933e+00+9.495364e+00i, -3.210279e+00+2.411380e+00i, +2.159719e+00+2.421445e+00i, -9.611746e-01+5.419106e-01i, +1.043741e+00-7.844274e-01i },
{ +1.965274e+01+1.017132e+01i, +3.957970e+01+2.922840e+01i, +2.176596e+01+2.289211e+01i, -3.788340e+00+3.591973e+00i, -1.259233e-01-1.462060e+00i },
{ +1.711727e+01-6.957561e+00i, +5.125674e+01+1.813202e+00i, +3.414655e+01+1.381380e+01i, -1.404859e+00+7.832920e+00i, -8.071797e-01-7.691113e-01i },
{ -1.248673e+00-3.689193e+00i, +6.492576e+00-1.340690e+01i, +1.346908e+01-3.941801e+00i, +1.925050e+00+4.506066e+00i, -5.836477e-01-4.569336e-01i },
{ +3.563270e-01+2.315241e-02i, +4.827649e-02-1.436858e+00i, +1.708206e+00-1.347025e+00i, +7.952434e-01+5.862732e-01i, -1.395346e-01+9.888519e-03i },
},
{
{ +2.572545e+00+3.636816e+00i, -3.785612e+00+4.179776e+00i, +3.057986e+00-2.907388e+00i, -2.681136e-02+1.058531e+00i, -3.997927e-01-6.342912e-01i },
{ +1.338082e+00-3.392300e+00i, +9.847703e+00-7.416999e+00i, +1.692957e+01-9.538404e+00i, +3.831804e+00+2.741798e+00i, -1.142923e+00+3.259898e-01i },
{ -2.574704e+00-2.191146e+00i, -4.451780e+00-1.374045e+01i, +4.489091e+00-2.139859e+01i, +7.218478e+00-2.042490e+00i, -6.860530e-01+1.211186e+00i },
{ -1.376179e+00+2.027202e+00i, -1.133024e+01-4.521760e-01i, -6.958274e+00-9.359145e+00i, +2.413004e+00-2.544559e+00i, -2.107927e-01+2.716206e-01i },
{ +2.292108e-01+6.598033e-01i, -1.311173e+00+7.456492e-01i, -9.976862e-01-7.222263e-01i, +2.530776e-01-2.418907e-01i, -6.385650e-02+2.923976e-02i },
},
{
{ +4.316298e-01-1.122311e+00i, -1.328008e+00+2.974879e+00i, -2.125037e+00-4.897174e-01i, +5.756918e-01-4.735606e-01i, -1.609197e-01+2.963596e-01i },
{ -5.175350e-01+1.588428e+00i, -2.932420e+00+4.310925e+00i, -5.155233e+00-3.422896e-01i, +2.605545e-01-1.937586e+00i, +2.171139e-01+5.411048e-01i },
{ +3.627837e+00+1.045155e+00i, +4.281393e-01+9.490888e+00i, -8.420901e+00+4.377642e+00i, -1.514273e+00-2.609751e+00i, +3.291718e-01+4.597430e-01i },
{ +2.293681e+00-6.719687e-01i, +3.388062e+00+5.653506e+00i, -2.758532e+00+4.840049e+00i, -1.224192e+00-4.920914e-01i, +9.468974e-02+1.408100e-01i },
{ +2.325552e-01-1.094776e-01i, +6.984444e-01+2.492067e-01i, +1.527930e-01+5.430193e-01i, -9.564260e-02+6.169278e-02i, +2.869691e-03+8.429127e-03i },
},
{
{ +5.945368e-01-4.733652e-03i, +9.804595e-01+3.922071e-01i, +6.387299e-02+6.333607e-01i, -2.084307e-01-1.662231e-02i, +3.892883e-02-2.848359e-02i },
{ -2.074456e-02-1.559404e+00i, +2.805841e+00-2.399116e+00i, +2.421271e+00+7.127057e-01i, -1.693611e-01+4.897725e-01i, +4.921520e-02-6.920443e-02i },
{ -1.530956e+00-1.607613e+00i, +1.095035e+00-4.245416e+00i, +2.915412e+00-9.933557e-01i, +3.712164e-01+4.936830e-01i, +3.774674e-02-2.356221e-02i },
{ -8.119979e-01-3.236985e-01i, -2.997782e-01-1.801984e+00i, +8.722731e-01-1.026575e+00i, +3.002262e-01+3.435482e-02i, +2.495508e-02-3.848549e-03i },
{ -1.234651e-01+9.267196e-03i, -1.769059e-01-2.305784e-01i, +2.870451e-02-2.042088e-01i, +3.712675e-02-2.148562e-02i, +2.522737e-03-3.330145e-03i },
}
},
{// coil10
{
{ -1.802945e+01+1.975055e+01i, +4.414084e+01+3.139564e+01i, +3.646344e+00-1.987196e+01i, -3.372386e+00+1.214207e+01i, +5.101727e+00-5.995551e+00i },
{ -1.835963e+01+2.460720e+01i, +3.695671e+01+4.331342e+01i, +1.309292e+01-1.417958e+01i, -3.735613e+00+3.642673e+00i, +2.758328e+00-3.862954e+00i },
{ -8.576454e+00+6.295983e+00i, +1.004586e+01+6.603206e+00i, +7.317631e-01-9.519339e+00i, -2.527543e+00+4.031720e+00i, +1.359270e+00-9.537898e-01i },
{ -8.819096e-01+1.411464e+00i, +1.268419e+00+6.607549e-01i, -1.280522e-01-3.077078e+00i, -9.419870e-02+7.823697e-01i, +3.261185e-01-5.193725e-01i },
{ -3.239356e-01+3.806333e-01i, -3.060085e-01+3.418099e-01i, -4.868929e-01-2.249197e-01i, -1.845042e-01+4.208601e-01i, -1.914998e-03+9.984978e-03i },
},
{
{ -3.671183e+01+4.872704e+01i, +8.122275e+01+1.048585e+02i, +3.173565e+01-2.990541e+01i, -1.437259e+01+1.426759e+01i, +1.024932e+01-6.362087e+00i },
{ -4.007410e+01+5.461233e+01i, +4.179521e+01+1.327292e+02i, +4.487498e+01+1.995529e+00i, -8.611286e+00-3.006193e+00i, +4.945981e+00-2.243016e+00i },
{ -1.610526e+01+3.645283e+00i, +7.216903e+00+2.945396e+01i, +1.087899e+01-1.905697e+00i, -5.695059e+00-5.917838e-01i, +1.999470e+00+8.339787e-01i },
{ -4.133997e-01+2.773362e-02i, +6.248810e+00+2.920329e+00i, +1.807382e+00-1.571152e+00i, -1.263949e+00+2.566950e-01i, +8.223289e-01-3.060967e-01i },
{ -1.394486e+00-3.631947e-01i, -8.838341e-01-3.031137e-01i, -5.875072e-01-4.545065e-01i, -5.236483e-01+4.502461e-01i, +2.529524e-02+2.569904e-02i },
},
{
{ -3.057928e+01+1.114126e+01i, +2.581942e+01+7.561547e+01i, +3.367722e+01-1.678300e+01i, -1.460687e+01-4.023032e-01i, +6.854067e+00+1.533694e-01i },
{ -3.124578e+01+2.029350e+01i, +1.409029e+01+8.463227e+01i, +3.456873e+01-4.523779e+00i, -1.267320e+01-4.337931e+00i, +4.374924e+00+1.509871e+00i },
{ -1.094342e+01+1.232862e+00i, +3.963480e+00+2.192946e+01i, +1.067922e+01-2.606632e+00i, -4.513657e+00+1.063097e-01i, +1.782009e+00+1.141720e+00i },
{ -1.178613e+00+7.408190e-02i, +2.153915e+00+2.617190e+00i, +2.036901e+00-4.582733e-01i, -5.991650e-01-3.117393e-01i, +6.411613e-01-8.692661e-02i },
{ -1.059021e+00-3.873461e-01i, -6.339856e-01-3.557569e-01i, -1.591239e-01-8.333451e-02i, -3.639632e-01+2.400447e-01i, +1.285254e-02-4.536383e-03i },
},
{
{ -4.880844e+00-7.838602e+00i, -5.741040e+00+8.048596e+00i, +6.035720e+00+8.294353e-01i, -1.454566e+00-1.433244e+00i, +1.020260e+00+6.621193e-01i },
{ -5.932289e+00-4.766819e+00i, +2.739308e-01+8.825248e+00i, +6.845219e+00-2.958118e+00i, -2.564547e+00-1.049443e+00i, +1.022024e+00+4.101588e-01i },
{ -2.567315e+00-6.117436e-01i, +9.962007e-01+1.655532e+00i, +1.301375e+00-3.658269e+00i, -1.142899e+00+8.491015e-01i, +5.299364e-01-4.389608e-02i },
{ -4.996621e-01+4.521135e-01i, -6.405935e-01+2.404765e-01i, -1.556955e-01-4.901403e-01i, +1.976150e-02+1.452616e-01i, +1.424083e-01-1.076159e-01i },
{ -8.868301e-02+5.127619e-02i, +2.569104e-02+5.524420e-03i, -1.387410e-02+1.006155e-02i, -7.197505e-02+6.409776e-02i, -3.281913e-03-1.713211e-02i },
},
{
{ +1.420353e-01+9.495258e-01i, +6.813078e-01+6.675912e-01i, +5.703435e-02-2.315179e-01i, -1.929989e-01+6.402960e-02i, +4.516352e-02+1.099457e-02i },
{ -3.324849e-01+1.445100e+00i, +7.241524e-01+1.418900e+00i, -1.530933e-01+9.752238e-02i, -2.202131e-01+2.323384e-01i, +6.965194e-02-2.524670e-02i },
{ -4.098002e-01+4.693519e-01i, +2.899836e-01+6.419555e-01i, -1.260279e-01+1.288811e-01i, -1.166254e-01+1.992147e-01i, +4.967536e-02-3.695358e-02i },
{ -2.013686e-02+5.552615e-02i, +2.008059e-01+2.172141e-02i, +2.368456e-02+4.869304e-02i, -1.499712e-02+5.651697e-02i, +1.368754e-02-1.725572e-02i },
{ -1.142060e-02-7.048833e-03i, +2.066261e-02-1.692072e-02i, +7.103598e-03+3.939020e-04i, -3.026694e-03+4.581022e-03i, -3.929283e-04-2.821722e-03i },
}
},
{// coil11
{
{ -4.877758e+00-1.904081e+01i, -3.229832e+01+2.925838e+01i, +2.454016e+01+1.659640e+01i, -6.431598e+00-1.358181e+01i, +3.177787e-01+7.632496e+00i },
{ -1.773429e+01-8.934076e+00i, -1.118564e+01+2.737618e+01i, +1.163124e+01+1.364555e-01i, -4.586879e+00+1.902538e+00i, +5.319562e+00+1.396938e+00i },
{ -5.225618e+00+1.866202e-01i, +6.132289e+00+4.464594e+00i, +8.372362e-01-4.881252e+00i, +1.567086e+00+1.813133e+00i, +8.435739e-01-2.255890e+00i },
{ -1.693887e-01+1.463179e+00i, +1.989596e+00+8.871583e-01i, -2.502819e+00-2.050261e+00i, -5.599886e-03+7.884936e-01i, -2.731313e-01-1.485316e-01i },
{ +5.980377e-01+1.179188e-02i, +4.295568e-03-5.187221e-01i, -7.569540e-01+7.913882e-01i, +6.266592e-01-4.934703e-02i, -1.131198e-01-1.277005e-01i },
},
{
{ -1.825755e+01-3.130025e+01i, -9.082171e+01+5.689869e+01i, +3.032003e+01+5.028389e+01i, -4.267659e+00-2.579160e+01i, -2.840057e+00+1.283610e+01i },
{ -3.939281e+01-2.303181e+01i, -6.751540e+01+5.677713e+01i, +1.405184e+01+2.671984e+01i, -4.235076e+00-2.979594e+00i, +6.479537e+00+4.936979e+00i },
{ -1.252823e+01-4.658543e+00i, -6.090178e+00+1.046430e+01i, +6.259178e+00+1.979625e+00i, +2.487722e+00-6.710323e-01i, +1.188209e+00-2.928425e+00i },
{ -2.147575e+00+2.117151e+00i, +2.442712e+00+2.193248e+00i, +5.380154e-01-2.958710e+00i, -1.003424e+00+1.379432e+00i, -4.284148e-01-3.165030e-01i },
{ +8.252296e-01+2.587724e-01i, +1.061430e-01-1.852892e+00i, -1.028526e+00+2.012528e-01i, +1.123358e+00+1.641450e-01i, -1.468009e-01-2.874243e-01i },
},
{
{ -1.857159e+00-1.586324e+01i, -5.490789e+01+1.650510e+01i, +1.145258e+01+3.488419e+01i, +5.096571e+00-1.497594e+01i, -4.129402e+00+6.107190e+00i },
{ -2.191334e+01-1.664297e+01i, -4.879784e+01+4.121041e+01i, +1.559111e+01+1.841178e+01i, -3.606299e+00-9.998520e+00i, +1.819865e+00+5.190320e+00i },
{ -9.631377e+00-3.113013e+00i, -5.595782e+00+1.912750e+01i, +6.149088e+00+1.496029e+00i, -3.922342e+00-1.223810e+00i, +1.429467e+00-3.285006e-02i },
{ -2.883624e+00+9.169986e-01i, +1.649986e+00+3.010593e+00i, +2.823204e+00-2.461370e+00i, -9.106740e-01+1.310748e+00i, +9.154930e-02-2.485762e-01i },
{ +3.089311e-01+7.127248e-01i, +2.376136e-01-9.511098e-01i, -9.965119e-01-9.148322e-01i, +3.525331e-01+2.092816e-01i, -4.665745e-02-1.867822e-01i },
},
{
{ +5.711299e+00-4.251388e+00i, -7.695365e+00-4.153989e+00i, +5.985203e-01+7.798053e+00i, +2.581780e+00-1.855753e+00i, -1.084799e+00+9.289701e-01i },
{ +2.608712e-01-5.569336e+00i, -5.833979e+00+5.609921e+00i, +6.837297e+00+1.586922e+00i, -1.783972e-01-3.314135e+00i, +2.281896e-01+1.346397e+00i },
{ -9.720359e-01-1.278463e+00i, +4.163130e-01+4.232729e+00i, +1.215732e+00-2.231854e+00i, -1.562310e+00-3.363451e-01i, +5.423279e-01+2.112521e-01i },
{ -7.851666e-01+4.820508e-02i, +3.385841e-01+1.109178e+00i, +3.599791e-01-3.657307e-01i, -1.058570e-01+3.814240e-01i, +8.681017e-02-8.968818e-02i },
{ +5.987382e-02+2.577848e-01i, +1.963107e-01-5.437284e-02i, -2.827754e-01-3.507979e-01i, -1.616700e-02+3.464039e-02i, -5.618938e-03-3.660450e-02i },
},
{
{ -6.016247e-01-3.226253e-01i, -1.263334e+00+8.455114e-01i, +2.585640e-01+6.826305e-01i, +1.607203e-02-3.628991e-01i, -5.183225e-02+1.111554e-01i },
{ -1.056527e+00-1.658553e-01i, -7.644000e-01+1.267359e+00i, +1.783527e-01+3.457047e-02i, -4.546984e-01-2.216899e-01i, +7.568357e-02+1.089721e-01i },
{ -3.199983e-01+2.868607e-02i, +9.743734e-02-6.967071e-02i, -2.380131e-01-2.160702e-01i, -2.518792e-01+1.767036e-01i, +5.626833e-02-2.165929e-02i },
{ -6.867956e-02+8.683318e-03i, -1.719986e-02-6.694677e-02i, +1.206220e-02+3.972895e-03i, +1.896192e-02+7.015133e-02i, -9.958254e-04-1.808856e-02i },
{ +1.136723e-02+1.525135e-02i, +1.593958e-02-2.538769e-02i, -1.595308e-02-2.453844e-02i, +5.911150e-03+4.844942e-03i, -1.776626e-03-3.247056e-03i },
}
},
{// coil12
{
{ +2.298240e+01-3.022550e+01i, -3.257663e+01-2.392343e+01i, +6.212553e+00+1.951822e+01i, +1.373345e+00-1.175939e+01i, -2.210625e+00+5.436308e+00i },
{ +2.692592e+01-2.707829e+00i, -2.277286e+00-4.461032e+01i, -1.758292e+01+5.431757e+00i, +6.819072e+00-3.064058e+00i, -4.461157e+00+7.256405e-01i },
{ +1.592840e+00+5.259146e+00i, +9.707740e+00-1.062355e+01i, -9.662973e+00-6.643835e+00i, +5.078152e-01+2.848803e+00i, -3.779426e-01-1.576081e+00i },
{ -1.933372e+00+1.093317e+00i, +3.648517e+00+3.103117e+00i, +1.306309e+00-2.421534e-02i, -1.469193e+00+3.227141e-01i, +6.247277e-01-4.130460e-02i },
{ -1.328921e+00-3.164792e-01i, -3.015098e-02+7.229710e-01i, +7.508239e-01-2.675294e-01i, -2.652751e-01-8.820233e-02i, +1.450854e-01+1.897034e-02i },
},
{
{ +7.754637e+01-3.086586e+01i, +1.241095e+01-9.304877e+01i, -1.132265e+01+7.826447e+00i, +4.482340e+00-7.736549e+00i, -4.822227e+00+5.231210e+00i },
{ +6.687451e+01+3.240646e+01i, +9.359825e+01-6.428896e+01i, -1.661299e+01-2.607172e+01i, +3.817863e+00+3.668754e+00i, -4.873762e+00-2.000175e+00i },
{ -6.093464e+00+1.846477e+01i, +2.481889e+01+4.163461e+00i, -3.291311e+00-1.903248e+01i, -3.066720e+00+4.988570e+00i, +1.049602e+00-2.308198e+00i },
{ -3.868890e-01-1.796677e+00i, +2.034703e+00+2.909315e-01i, +1.726286e+00-2.232085e+00i, -1.558769e+00-8.853394e-02i, +6.870821e-01+2.905602e-01i },
{ -1.930573e+00+2.454528e-01i, -1.282172e+00+2.995859e+00i, +8.305038e-01+2.394219e-01i, -2.947828e-01-2.117119e-01i, +1.785538e-01+8.183411e-02i },
},
{
{ +5.468947e+01+1.021189e+01i, +2.853665e+01-6.082544e+01i, -1.951802e+01+2.035491e+00i, +8.225058e+00+5.544267e-01i, -4.287238e+00+3.905988e-01i },
{ +2.983815e+01+3.941013e+01i, +7.146695e+01-2.930538e+01i, -1.600696e+01-1.892092e+01i, +2.353042e+00+8.079954e+00i, -2.314554e+00-3.543161e+00i },
{ -8.003483e+00+6.717611e+00i, +1.594926e+01+5.743060e+00i, +2.148569e+00-1.022281e+01i, -2.170036e+00+3.782934e+00i, +1.282350e+00-1.375886e+00i },
{ +1.399508e+00-3.049878e+00i, -8.910974e-01+1.391821e-02i, +7.637105e-01-1.208789e+00i, -1.124783e-01-8.264885e-01i, +2.146148e-01+3.813558e-01i },
{ -6.224154e-01-3.217413e-01i, -9.596943e-01+1.875607e+00i, +2.160845e-01+5.222991e-01i, -1.472316e-01-1.440500e-01i, +6.626511e-02+9.801276e-02i },
},
{
{ +5.022367e+00+3.642795e+00i, -3.063514e+00-7.194491e+00i, -4.068101e+00+3.731139e+00i, +2.949110e+00-8.162608e-01i, -1.196211e+00+2.208132e-02i },
{ +1.576495e-01+4.064213e+00i, +2.281621e+00-9.959316e+00i, -6.855486e+00-1.532383e+00i, +1.277487e+00+8.593011e-01i, -7.969486e-01-7.728932e-01i },
{ -1.466881e+00-7.850106e-01i, +3.120106e+00-6.606345e-01i, -2.991964e-01-2.296494e-01i, -3.503838e-01+6.530272e-01i, +1.674028e-01-2.779897e-01i },
{ -1.620539e-01-4.621168e-01i, -7.378773e-02+1.478947e+00i, +6.044828e-01+5.779682e-01i, +9.709807e-02-3.027359e-01i, +4.542579e-02+9.763636e-02i },
{ -9.578160e-03-2.785970e-01i, -2.451715e-02+8.145078e-02i, +3.229212e-02+4.644491e-02i, -5.512552e-02-3.071728e-02i, +7.575777e-03+2.834840e-02i },
},
{
{ +1.575831e+00-6.791803e-02i, +5.550761e-01-1.019442e+00i, -5.771780e-02+6.024261e-01i, +3.573134e-01-1.894918e-02i, -1.315391e-01+1.805019e-02i },
{ +1.931326e+00+8.946406e-01i, +1.949350e+00-5.430294e-01i, +2.608923e-01+2.567692e-01i, +3.199365e-01+1.806193e-01i, -9.587300e-02-5.161967e-02i },
{ +3.859484e-01+8.135603e-01i, +7.950826e-01+4.338861e-01i, +2.232842e-01-9.720212e-02i, +3.892371e-02+1.058889e-01i, +1.251228e-02-2.637490e-02i },
{ -2.967205e-02+3.775177e-02i, -2.390563e-02+3.532192e-02i, +1.075771e-02-1.109063e-01i, +2.867441e-03-2.824235e-02i, +4.983292e-03+5.830345e-03i },
{ +2.782728e-03+4.183989e-03i, +8.244917e-03+1.773288e-02i, +3.380927e-03-9.166469e-03i, -7.000796e-03-9.737806e-04i, +1.322845e-03+2.166731e-03i },
}
},
{// coil13
{
{ -4.503497e+00+1.875008e-01i, -3.987189e+00+9.014068e+00i, +4.825608e+00+1.813802e+00i, -3.280771e-01-2.187028e+00i, +1.279217e-01+3.543887e-01i },
{ -1.503856e+01+6.328311e-01i, -1.734921e+01+8.493690e+00i, -3.453597e+00+4.663489e+00i, +9.008508e-01-6.720750e-01i, -3.909791e-01-2.734891e-02i },
{ -4.861712e+00-6.691425e+00i, -8.171711e+00+4.372743e-01i, -1.126523e+00+1.656065e+00i, -1.001732e-01+4.422579e-01i, +1.432895e-01-7.265973e-02i },
{ +1.566997e+00+7.079913e-01i, +4.649276e-01-1.587693e-01i, +1.196692e+00+1.298605e+00i, -3.319167e-01+9.587745e-02i, +1.897924e-01-8.622433e-02i },
{ -1.039208e+00-1.960659e-01i, -5.238845e-01-3.894888e-01i, +7.745552e-02-1.414494e-01i, -1.212986e-01+6.584385e-02i, +3.642748e-02-1.055857e-02i },
},
{
{ +9.154390e+00-2.353345e+01i, -2.130027e+01-3.057737e+01i, -9.044035e+00+6.898988e+00i, +2.550457e+00-9.801415e-01i, -7.536413e-01+5.706869e-01i },
{ +5.716909e+00-6.061320e+00i, -1.012312e+01-2.726978e+01i, -1.862037e+01-4.175243e+00i, +5.767770e-01+2.006714e+00i, -7.461870e-01-4.355966e-01i },
{ -2.389885e+00+1.347002e+00i, -5.271194e+00-4.258932e-01i, -4.794191e+00-5.107514e+00i, -7.482742e-01+9.747863e-01i, +2.697162e-01-1.188482e-01i },
{ +1.689088e+00+8.496243e-01i, +8.491212e-01-3.489448e-01i, +8.638453e-01-2.494165e-01i, -3.471296e-01-1.597197e-01i, +1.096271e-01-9.394120e-03i },
{ -1.016278e+00+4.240152e-01i, -5.138729e-01+8.322691e-01i, +2.771817e-01+1.055615e-02i, -1.139464e-01+7.354349e-02i, +4.006362e-02-4.447946e-03i },
},
{
{ +1.914692e+01+1.681697e+00i, +1.532178e+01-2.902148e+01i, -9.266972e+00-6.665454e+00i, +5.295098e-01+2.624781e+00i, -5.728394e-01-6.263905e-01i },
{ +9.724102e+00+1.414193e+01i, +2.937889e+01-6.563891e+00i, -9.390640e-01-1.067542e+01i, -2.008207e+00+3.285432e+00i, +2.684910e-01-1.031402e+00i },
{ -3.414839e+00+5.296469e+00i, +2.309778e+00+7.926900e+00i, +2.933142e+00-3.351538e+00i, -7.538676e-01-4.199286e-01i, +3.982652e-01+8.498515e-02i },
{ +2.463782e-01-8.182613e-01i, -6.139522e-01-2.785584e-01i, -6.934565e-01-4.154742e-01i, -3.929143e-02-6.522815e-01i, -5.411900e-02+1.767679e-01i },
{ -1.273396e-01-7.357904e-02i, -2.030309e-01+8.183068e-01i, +2.409960e-01+3.313552e-01i, +2.944608e-02-1.177722e-02i, +8.464516e-03+2.224541e-02i },
},
{
{ -2.032636e+00+5.858443e+00i, +4.122198e+00+4.246657e+00i, +9.002650e-01-2.270946e+00i, -5.933546e-01+7.777977e-02i, +8.891886e-02-1.592583e-01i },
{ -7.108132e+00+1.687550e+00i, -1.373341e+00+6.607432e+00i, +2.584561e+00+4.530314e-01i, -6.513768e-01-2.782961e-01i, +2.356821e-01-5.559232e-02i },
{ -1.927278e+00-2.935295e+00i, -2.518417e+00+1.216201e-01i, +1.182798e+00+2.145315e+00i, +1.436035e-01-4.113143e-01i, +4.606818e-02+1.538184e-01i },
{ +3.469746e-01-3.871583e-01i, +1.752132e-01-2.980655e-01i, -2.226218e-01+4.418849e-01i, +1.159047e-01-1.701332e-01i, -2.936215e-02+6.524173e-02i },
{ +3.069464e-02-2.009898e-01i, -8.837610e-02-5.937122e-02i, -2.512498e-03+9.396666e-02i, +2.312934e-02-3.302829e-03i, -2.726614e-03+8.617183e-03i },
},
{
{ +5.298062e-01-1.064102e+00i, -6.006480e-01-1.213942e+00i, -3.448814e-01+1.107504e-01i, +1.048945e-01+3.027947e-02i, -2.301242e-02+1.488224e-02i },
{ +1.528790e+00-1.046634e+00i, +3.121485e-01-2.105916e+00i, -3.161633e-01-3.803180e-01i, +7.861942e-02+1.433618e-02i, -3.135614e-02+2.985968e-03i },
{ +8.458626e-01+1.418329e-01i, +6.147783e-01-6.650413e-01i, -1.212392e-01-2.707823e-01i, +1.939870e-04-1.597615e-02i, -1.528361e-02-8.554896e-04i },
{ +7.601475e-03+1.217805e-01i, +7.316224e-02+3.950908e-02i, -5.797976e-02-4.368609e-02i, -4.300417e-03-1.870350e-02i, -2.940372e-03+2.069379e-03i },
{ +1.198960e-02+4.628330e-03i, +1.437729e-02+7.262832e-03i, +3.091319e-03-6.105117e-03i, +6.364407e-04-1.637144e-03i, -2.506001e-04+1.939089e-04i },
}
},
{// coil14
{
{ -1.033016e+00-4.746225e-01i, -2.371926e+00-1.989682e-01i, -2.062428e-01-5.024281e-01i, -4.540842e-01-7.300977e-01i, -2.502661e-01+2.249715e-02i },
{ -5.707002e-01-1.798093e-01i, -3.137902e+00-1.139731e+00i, -3.089269e+00-2.414956e-01i, -3.161420e-01+1.543944e+00i, +2.355600e-01+3.570859e-02i },
{ -1.927752e-01-5.677503e-01i, -1.432103e+00+1.497890e-01i, -1.200319e+00+1.009312e+00i, +3.186926e-01-2.887351e-01i, +2.991581e-01-1.335380e-01i },
{ -8.970987e-01-3.260021e-01i, +6.023902e-01-2.147345e-01i, +1.216481e-01+8.844933e-01i, -7.433298e-01-1.825019e-01i, +1.094218e-01+6.761815e-02i },
{ -6.358942e-02+1.039565e-03i, +9.901800e-02-2.405431e-01i, +3.513369e-01+1.079653e-01i, +1.270987e-01+7.367276e-02i, +4.710108e-02-2.336663e-02i },
},
{
{ +2.280733e+00-1.508986e+00i, +5.374285e+00-6.286820e+00i, +3.203624e+00-4.285060e+00i, -6.553703e-01-1.603361e+00i, -3.646489e-01+4.788291e-02i },
{ +3.216266e+00+2.467016e+00i, +1.097902e+01-6.703795e+00i, +9.064879e-01-9.815319e+00i, -2.546573e+00+1.056717e+00i, +4.641813e-01+3.368711e-01i },
{ +1.749308e+00+2.778554e+00i, +2.024681e+00+1.022409e+00i, -6.995444e-01-2.318800e+00i, +2.332448e-01-8.843753e-02i, +3.936741e-01-8.519069e-03i },
{ -2.201475e-01-2.405292e-01i, +9.451251e-02+2.762334e-01i, -3.349755e-01+5.532051e-02i, -4.509140e-01-5.612934e-01i, +1.525767e-02+1.596009e-01i },
{ +7.496763e-03+1.418180e-01i, -1.041351e-03+7.221724e-02i, +1.081645e-01+2.763025e-01i, +1.650586e-01+9.452838e-02i, +5.835536e-02-6.081249e-03i },
},
{
{ +7.912545e-01+9.296336e-01i, +5.862453e+00+1.219319e+00i, +4.117695e+00-1.256712e+00i, -9.805614e-02-1.051917e+00i, -2.789706e-02+7.144926e-02i },
{ -6.099756e-01+1.800154e+00i, +9.410113e+00+4.122600e+00i, +6.737055e+00-1.492405e+00i, -1.752099e+00-1.014008e+00i, +3.805525e-01+4.169943e-01i },
{ -1.190710e+00+2.837861e-01i, +1.719535e+00+1.143072e+00i, +3.037603e+00+2.963322e-01i, +9.988451e-02-2.933111e-01i, +1.557752e-01+1.654893e-01i },
{ -2.473776e-02-4.297963e-01i, -2.524289e-01+1.566179e-01i, -2.075140e-01-3.008287e-01i, +9.667502e-02-5.021392e-01i, -6.756271e-02+1.435987e-01i },
{ +5.141426e-02+7.247458e-02i, +1.522414e-01+2.329065e-01i, -1.032152e-01+2.834818e-01i, +2.174630e-02+4.113800e-02i, +2.921913e-02+1.543248e-02i },
},
{
{ -6.507428e-01-1.365940e-01i, -1.625209e+00+8.905765e-01i, -7.967606e-02+5.490357e-01i, +2.295209e-01-2.845802e-01i, -2.311303e-02+1.003720e-03i },
{ -6.383516e-01-1.067482e+00i, -2.924406e+00+8.412667e-01i, -8.944942e-01+2.132742e+00i, -1.241025e-01-4.124984e-01i, -7.421407e-02+1.064758e-01i },
{ -1.075018e-01-1.138716e+00i, -7.439145e-01-7.322327e-01i, +2.398723e-02+1.503459e+00i, +8.153295e-02-1.860666e-02i, -4.495158e-02+7.967570e-02i },
{ -2.459747e-02-3.203548e-01i, -1.908414e-02-2.683973e-01i, +2.239916e-02+6.880534e-02i, +6.037500e-02-1.081301e-01i, -1.446573e-02+4.093957e-02i },
{ -2.354831e-02-7.289145e-03i, +5.177579e-02+4.308225e-02i, -1.795405e-02+9.206475e-02i, -1.128325e-02+1.381172e-02i, +7.359990e-03+6.169899e-03i },
},
{
{ +3.020096e-01-1.289089e-02i, +4.868622e-01-3.966743e-01i, +1.677436e-01-1.996618e-01i, +2.666326e-02-1.696944e-04i, -6.448448e-03-1.164844e-02i },
{ +4.705830e-01+1.337417e-01i, +7.828176e-01-6.481831e-01i, +2.492543e-01-4.316311e-01i, +4.076483e-02-1.589662e-03i, -1.456244e-02-1.400837e-02i },
{ +2.293830e-01+2.074234e-01i, +3.057454e-01-1.412092e-01i, +8.787750e-02-1.953977e-01i, +5.743555e-02-1.226113e-02i, -1.027680e-02-3.132153e-03i },
{ +4.250260e-02+2.901488e-02i, -1.637535e-03+2.063725e-02i, -2.979182e-02-4.200428e-02i, +1.143728e-02-2.736739e-02i, -3.142098e-03+2.905867e-03i },
{ -2.511037e-03+4.028112e-03i, -4.982910e-03+1.084794e-02i, -9.433499e-03+6.924241e-03i, -2.147672e-03+3.695285e-04i, +3.389512e-04+5.700166e-04i },
}
},
{// coil15
{
{ -1.935695e-01+7.660341e-01i, -1.375872e+00+2.266538e+00i, -1.149775e+00+1.560550e+00i, -2.498694e-01+1.368298e-01i, +4.415871e-02+2.636233e-01i },
{ -3.561357e-01+1.405103e-01i, -3.198419e+00+3.341316e+00i, -6.514725e-01+2.552321e+00i, +4.319109e-01-2.106579e-01i, +4.393594e-02+7.991422e-02i },
{ -3.127677e-01-4.868277e-01i, -2.337106e+00-4.820826e-01i, -1.741098e-01-2.451157e-01i, -1.931437e-01+8.175500e-02i, -6.949127e-02-3.423975e-02i },
{ -9.606102e-02+4.084976e-01i, -7.863317e-01-4.463354e-01i, +2.507976e-01-4.945311e-01i, +8.130120e-02+3.970459e-01i, +8.399613e-03-8.426304e-02i },
{ +6.601568e-04+6.408890e-02i, -2.167859e-01+9.295933e-03i, -2.953296e-02-2.347947e-01i, +4.160269e-02-3.747986e-02i, -2.790421e-02-1.596892e-02i },
},
{
{ -1.876740e+00+7.798628e-01i, -2.469108e+00+1.116550e+00i, -5.638424e-01-1.323341e-01i, -5.803704e-01-2.952629e-01i, -1.843091e-01+3.580009e-01i },
{ -3.767431e+00+2.033926e+00i, -7.923326e+00+6.711823e+00i, -1.754910e+00+3.805610e+00i, +4.245954e-01-1.342493e-01i, +1.143118e-01+2.150431e-01i },
{ -4.263364e-01+8.977361e-01i, -1.821800e+00+4.009706e+00i, -1.677506e-01+2.519353e+00i, -1.690323e-01-6.721463e-01i, +8.839060e-02+2.520398e-02i },
{ +4.648522e-02+3.807574e-01i, +8.773929e-01+1.835522e-01i, +4.071971e-01+4.506474e-01i, -4.614650e-01+1.730659e-01i, +1.338179e-01-7.032897e-02i },
{ +1.144947e-02+5.267894e-02i, -1.284086e-01-7.385546e-02i, +2.894197e-02-9.495553e-02i, +3.987446e-02-3.726741e-03i, -1.562123e-02-3.452205e-02i },
},
{
{ +9.421569e-01-5.187635e-01i, -2.276249e+00-1.289444e+00i, -4.885497e-01+1.182674e+00i, +7.056075e-01-5.182929e-01i, -4.793756e-01+2.191788e-02i },
{ -1.045292e+00-6.312718e-01i, -6.406878e+00+8.842602e-01i, -1.001723e+00+2.162173e+00i, +7.875856e-01+1.036723e-01i, -3.238684e-01+1.627362e-01i },
{ -8.502373e-01-3.186870e-02i, -2.551949e+00+1.804965e+00i, +1.519044e-01+1.493136e+00i, +3.886018e-01-5.481808e-01i, +5.948494e-02+1.002578e-01i },
{ -3.874810e-01+9.833160e-02i, +9.200487e-01+2.242819e-01i, +4.157402e-01+5.886781e-01i, -5.721329e-01-1.521732e-01i, +1.417014e-01-3.091932e-02i },
{ -5.558626e-02-1.888160e-02i, +7.105206e-02-2.410229e-01i, +1.794387e-01+4.879032e-02i, +1.679184e-02+9.353864e-02i, +9.078217e-03-2.234698e-02i },
},
{
{ +4.433501e-01+3.601564e-01i, -4.121999e-01-3.926090e-01i, -8.928584e-01+2.212785e-01i, +1.985133e-01-9.810349e-02i, -1.467053e-01-6.357900e-02i },
{ +8.725932e-01+2.390497e-01i, -5.441626e-01-6.349086e-01i, -7.850036e-01+5.222866e-01i, +1.851231e-01+2.980916e-01i, -1.841252e-01-1.352787e-02i },
{ +2.549579e-01-1.992979e-01i, -9.719160e-01-1.175049e+00i, +5.337493e-02-2.811560e-01i, +3.003703e-01+5.667483e-02i, -4.060797e-02+1.313371e-02i },
{ -2.747255e-01+1.041215e-01i, -4.410358e-01-9.559245e-02i, -9.926796e-03-1.283211e-01i, -9.319259e-02-6.670631e-02i, +2.501212e-02-1.117301e-02i },
{ +1.787841e-03+1.718724e-02i, +4.653827e-02-5.311432e-02i, +7.960393e-02+2.474074e-03i, +7.436406e-03+3.458996e-02i, +3.256488e-03-4.552486e-03i },
},
{
{ -3.229249e-02-2.011592e-02i, +7.455570e-02-9.495862e-02i, +6.046002e-02-1.486050e-01i, -3.240021e-03-1.590643e-02i, -3.823105e-03+7.951604e-04i },
{ +4.795730e-03+5.996754e-02i, +2.342432e-01+5.182752e-02i, +6.798528e-02-7.326384e-02i, +1.321436e-02+3.399473e-03i, +1.637745e-03-3.675182e-03i },
{ +1.066070e-01+3.917690e-02i, +2.254262e-01+8.628593e-02i, +5.719395e-02+6.690268e-02i, +1.546606e-02-1.725757e-02i, -2.593512e-05-4.518184e-03i },
{ +1.994321e-02+1.275985e-03i, +3.443569e-02+4.034236e-02i, +1.574287e-03+4.677916e-02i, -1.794027e-02-5.535958e-03i, +7.695148e-04-3.353053e-04i },
{ +6.687908e-03+1.101221e-03i, +1.511302e-02+4.144963e-03i, +8.212320e-03+7.292273e-03i, -9.176278e-05+2.749778e-03i, +2.789422e-04-3.572812e-04i },
}
},
{// coil16
{
{ -2.726920e+00-3.338393e+00i, -1.301441e+01-9.023552e-01i, -1.564721e+01-6.640415e+00i, -1.120842e+01-5.582562e+00i, -1.426232e+00+3.175206e-01i },
{ -6.591111e+00+1.323469e+01i, +2.767289e+00+5.450666e+01i, +1.056210e+01+5.180158e+01i, +2.760006e+00+1.498493e+01i, +1.384320e+00+2.386013e+00i },
{ +3.708197e+00+6.965260e+00i, +2.678163e+01+1.452119e+01i, +3.323948e+01-5.238058e+00i, +1.300466e+01-8.571836e+00i, +1.095019e+00-6.818488e-01i },
{ +2.429559e+00-5.542629e+00i, -3.838859e+00-6.269393e+00i, -1.382269e+01-7.749288e+00i, -5.194160e+00-3.413368e+00i, -8.586495e-01+2.206773e-01i },
{ -6.308544e-01+6.886245e-01i, +2.631604e+00+3.375563e+00i, +3.692208e+00+3.862413e+00i, +1.503199e+00+9.131507e-01i, +2.387127e-01+9.937737e-02i },
},
{
{ +3.388273e+00+2.949940e+00i, -6.184510e+00+2.711986e+01i, -1.712644e+01+4.709653e+01i, -1.896905e+00+2.124771e+01i, +1.816282e+00+3.347316e+00i },
{ +1.839351e+01+2.210419e+01i, +6.804827e+01+8.225106e+01i, +7.939064e+01+5.756664e+01i, +2.426471e+01-8.504108e+00i, +3.131243e+00-2.793244e+00i },
{ +6.456897e+00+4.427791e+00i, +3.277675e+01+1.285005e+00i, +2.504641e+01-1.946575e+01i, -1.051966e+01-1.147329e+01i, -3.201818e+00-1.191668e+00i },
{ -1.591430e+00-2.053012e+00i, -8.469946e+00-2.386263e+00i, -6.316302e+00+3.286789e+00i, +5.032398e-01+6.898279e+00i, -6.379275e-02+1.201208e+00i },
{ +2.091348e-02+6.204628e-01i, +3.079568e+00+1.170491e+00i, +2.042881e+00-1.758649e+00i, -3.073413e-01-2.090878e+00i, -1.306120e-01-2.919509e-01i },
},
{
{ +7.674104e+00+5.109919e+00i, +2.093093e+01+2.343438e+01i, +2.850048e+01+2.990204e+01i, +1.809549e+01+1.281749e+01i, +3.785267e+00+1.703074e+00i },
{ +1.560105e+01-6.792150e+00i, +3.902553e+01+1.899651e+00i, +2.750053e+01-2.411618e+01i, +2.532156e+00-2.967010e+01i, -3.858580e-01-3.872351e+00i },
{ +2.138275e+00-2.100259e+00i, +4.479501e+00-1.024482e-02i, -1.332912e+01+6.550792e+00i, -1.917507e+01+9.419020e+00i, -3.302981e+00+1.621953e+00i },
{ +2.500267e+00+9.098470e-01i, +2.325889e+00-2.891899e+00i, +1.259418e+01-1.534190e+00i, +1.018319e+01+4.469934e+00i, +1.061360e+00+2.771174e-01i },
{ -6.456201e-01+5.271786e-02i, -3.046796e+00+7.855788e-01i, -6.061512e+00-1.808088e+00i, -3.283435e+00-1.716827e+00i, -5.454167e-01-1.808451e-01i },
},
{
{ +2.609965e+00-2.661408e+00i, +8.042891e+00-2.989872e+00i, +1.269700e+01-4.327577e+00i, +5.524098e+00-2.229169e+00i, +7.795683e-01-1.453837e-01i },
{ -4.871869e+00-5.088474e+00i, -1.032964e+01-8.227604e+00i, -1.168355e+01-1.182298e+01i, -5.613437e+00-6.151376e+00i, -7.719824e-01-3.233188e-01i },
{ -4.605609e-01+2.767192e+00i, -2.090513e+00+7.376563e+00i, -3.329953e+00+9.278412e+00i, -1.282005e+00+5.989531e+00i, -1.634261e-01+7.984588e-01i },
{ +2.048453e+00-9.259279e-01i, +1.712615e+00-3.130215e+00i, +3.300233e+00-4.871378e+00i, +2.988397e+00-1.470341e+00i, +2.111879e-01-3.200920e-01i },
{ -4.874349e-01+3.029085e-01i, -1.609888e+00+1.620463e+00i, -2.571719e+00+1.405624e+00i, -1.194126e+00+3.254536e-01i, -1.829860e-01+7.330053e-02i },
},
{
{ +3.903718e-01-2.703879e-01i, +7.411673e-01-5.458668e-01i, +2.371829e-01-9.134975e-02i, +2.223801e-01+3.393482e-02i, +5.923599e-02+1.410907e-02i },
{ +1.028828e-01+1.038281e-01i, -1.603558e-02+1.023954e-01i, -8.374756e-01+4.999561e-01i, -5.464315e-01-1.118950e-01i, -3.620460e-02-2.078162e-02i },
{ +2.322003e-01+4.227144e-01i, +6.593263e-01+8.494350e-01i, +7.472433e-01+1.429497e+00i, +7.087078e-03+7.073624e-01i, -3.346967e-03+3.056094e-02i },
{ +3.983733e-02-9.265572e-03i, +1.276334e-01-3.132878e-01i, +4.878210e-01-4.501348e-01i, +2.549958e-01-9.741864e-02i, -1.356709e-03-3.069766e-02i },
{ -2.041757e-02+5.100183e-02i, -6.584146e-02+1.743860e-01i, -1.522259e-01+1.750228e-01i, -8.786421e-02+6.483361e-02i, -1.104089e-02+1.405046e-02i },
}
},
{// coil17
{
{ -1.618464e+00+4.448175e+00i, -1.539476e-01+9.584402e+00i, -1.263544e+01+5.611364e+00i, -1.253572e+01-1.616095e+00i, -3.284785e+00-7.268863e-01i },
{ +1.141177e+01-5.400655e+00i, +3.789316e+01-1.825785e+01i, +3.410525e+01+9.195588e-01i, +7.909086e+00+1.635080e+01i, +8.515640e-01+3.313987e+00i },
{ -3.283305e+00-5.555148e+00i, +2.367442e-01-2.842645e+01i, +6.638736e+00-3.478316e+01i, +7.820432e+00-1.253274e+01i, +2.705252e+00-1.786663e+00i },
{ -4.159531e+00+3.546861e+00i, -6.502956e+00+7.211745e+00i, -1.150464e+01+7.127793e+00i, -7.900099e+00+2.507067e-01i, -7.265883e-01-3.511288e-01i },
{ +8.152852e-01-8.310638e-01i, +3.210209e+00-3.093864e+00i, +5.325472e+00-1.711697e+00i, +2.479738e+00+2.762156e-01i, +3.930578e-01+4.471071e-03i },
},
{
{ +4.952700e+00-5.250333e+00i, +2.202267e+01-2.334981e+00i, +2.716138e+01+1.697866e+01i, +2.635462e+00+1.285691e+01i, -2.502431e+00+1.868251e+00i },
{ +5.856348e+00-2.582953e+01i, +4.497914e+01-8.262419e+01i, +5.302624e+01-7.773402e+01i, +1.854437e+01-1.337348e+01i, +4.241721e+00+6.651089e-01i },
{ +1.061695e+00-1.030806e+00i, -1.096086e+01-2.604526e+01i, -3.512027e+01-3.749484e+01i, -1.673064e+01-1.401818e+01i, -5.490171e-01-3.603800e+00i },
{ +3.428051e+00+1.877534e+00i, +3.577015e+00+1.060473e+01i, -3.772569e-01+1.799709e+01i, -2.300040e+00+9.043240e+00i, -9.637408e-01+1.350388e+00i },
{ -2.280917e-01-1.349353e+00i, +1.483389e-01-4.694368e+00i, +8.499232e-01-5.524189e+00i, +1.160269e+00-2.517775e+00i, +4.640862e-01-3.837539e-01i },
},
{
{ -2.737626e+00-9.550541e+00i, +1.493819e+01-2.441443e+01i, +2.653434e+01-1.551554e+01i, +1.241494e+01+3.022240e+00i, +1.645606e+00+9.706850e-01i },
{ -1.149042e+01-6.907618e+00i, -1.263326e+01-3.931667e+01i, -1.527051e+01-4.288515e+01i, -9.274117e+00-1.655133e+01i, +1.804919e+00-3.280423e+00i },
{ -2.641046e-01-4.065132e-01i, -5.328074e+00-3.703959e+00i, -8.245844e+00+1.419167e+01i, -1.210555e+01+1.407031e+01i, -2.759975e+00-4.999754e-01i },
{ -1.917677e-01-1.881326e+00i, -2.878780e+00-3.625557e+00i, +9.795789e+00-5.494069e+00i, +9.464381e+00+1.850611e+00i, +3.439683e-01+1.306752e+00i },
{ +3.934615e-01+1.153909e-01i, -5.726201e-01+2.157591e+00i, -4.414568e+00+9.769500e-01i, -2.286400e+00-1.458391e+00i, -3.671244e-02-3.257905e-01i },
},
{
{ -5.507642e+00+8.543062e-01i, -4.980777e+00-4.527087e+00i, -3.902793e-01-1.012336e+01i, +2.037225e+00-2.671492e+00i, +7.063541e-01-2.310547e-01i },
{ -8.217196e-01+5.967659e+00i, -5.859566e+00+1.105020e+01i, -1.217867e+01+7.131872e+00i, -6.537685e+00+1.154314e-01i, -1.428307e-01-8.458046e-01i },
{ -4.572248e-02-1.135657e+00i, +5.094019e+00-7.436750e-01i, +1.008100e+01+6.431664e+00i, +2.144245e+00+5.814523e+00i, -3.541181e-01+3.457140e-01i },
{ -1.969020e+00+9.768891e-01i, -4.922594e+00-1.562717e+00i, -7.457896e-01-6.521524e+00i, +2.281181e+00-2.609226e+00i, +2.358516e-01+3.226528e-02i },
{ +7.926899e-01-3.545427e-02i, +1.325231e+00+1.712668e+00i, -6.963980e-01+2.334929e+00i, -9.522616e-01+3.882532e-01i, -8.893155e-02-1.458889e-02i },
},
{
{ -9.051841e-02+4.405785e-02i, -2.324854e-01-4.736644e-01i, +4.020863e-01-7.121545e-01i, +3.907987e-01-1.285684e-01i, +5.342086e-02-6.371558e-03i },
{ +9.483881e-01-1.449479e-01i, +7.588446e-01+1.029249e-01i, -5.145648e-01-2.627039e-01i, -3.872351e-01-3.760338e-01i, -1.244444e-02-8.632129e-02i },
{ +6.547934e-01-6.536072e-01i, +1.316641e+00-5.396248e-01i, +4.625741e-01+3.314334e-01i, -1.283349e-01+3.390667e-01i, -5.576919e-02+2.513146e-02i },
{ +1.132992e-01-5.266043e-02i, -5.842222e-02-1.515055e-01i, -9.444590e-02-2.473379e-01i, +9.216078e-02-9.427965e-02i, +8.598080e-03+1.369637e-02i },
{ +6.998464e-02-8.220492e-02i, +1.667997e-01+4.639593e-02i, +1.079015e-02+2.053382e-01i, -6.517449e-02+6.542654e-02i, -7.206303e-03+3.961580e-03i },
}
},
{// coil18
{
{ -2.075056e+00-1.020984e+00i, +9.319256e+00-6.559040e+00i, +1.654616e+00-3.386301e+00i, -1.215817e+00-4.952973e+00i, +1.022739e+00-1.773054e+00i },
{ -2.664542e+01+1.518738e+01i, -3.324526e+01-3.989749e+01i, +9.335751e+00-1.973034e+01i, -8.529449e+00+1.024147e+01i, -1.905982e+00-3.177145e+00i },
{ -6.864643e-02+2.024893e+01i, -4.976843e+01-1.613550e-01i, -1.234889e+01-2.909890e+01i, +1.194022e+01+6.058128e+00i, -2.316061e+00+1.529918e+00i },
{ +7.438649e+00-2.063488e+00i, +2.294324e+00+1.589586e+01i, -1.503865e+01+1.300397e+00i, +1.190023e+00-8.351091e+00i, +1.035056e+00+1.475890e+00i },
{ -1.655533e+00-4.094116e-01i, +1.251396e+00-1.787760e+00i, +5.127165e-01+2.395343e+00i, -1.383635e+00+7.258677e-01i, +2.112658e-01-9.290053e-02i },
},
{
{ -6.335087e+00-2.992193e+00i, -1.528762e+01-2.685392e+01i, +5.106902e+00-6.707567e+00i, -2.644005e+00+3.339580e+00i, -1.313941e+00-3.612888e+00i },
{ -2.112293e+01+1.897631e+01i, -1.171701e+02-2.968130e+01i, -4.749199e+01-6.339120e+01i, +1.421595e+01+7.000515e+00i, -6.286390e+00+2.904926e+00i },
{ +3.382282e+00+4.864834e+00i, -6.202867e+01+4.801022e+01i, -7.960365e+01-4.139051e+00i, +1.017041e+01-1.993307e+01i, +2.670128e+00+6.599051e+00i },
{ -1.796521e+00-1.116230e+01i, +2.690327e+01+9.898188e+00i, -6.304273e+00+3.166570e+01i, -1.272806e+01-8.147367e+00i, +3.560951e+00-6.330502e-02i },
{ -3.317173e+00+3.502129e-01i, -9.136244e-01-5.827706e+00i, +4.121771e+00+6.299463e-01i, -5.305306e-01+2.308099e+00i, +1.978833e-01-1.942989e-01i },
},
{
{ -1.799132e+00+5.741807e+00i, -1.961924e+01+9.422054e-01i, -1.447884e+00-1.570701e+01i, +2.498198e+00+1.059013e+00i, -1.700244e+00-6.587168e-01i },
{ -7.089043e-02+2.421189e+00i, -3.563757e+01+3.124533e+01i, -5.259380e+01-2.393363e+00i, +5.199891e+00-1.021356e+01i, -5.758030e-01+5.317476e+00i },
{ -8.057323e+00-2.227655e+00i, +1.335936e+01+1.989392e+01i, -1.641624e+01+3.920969e+01i, -9.381613e+00-1.039859e+01i, +5.605114e+00+1.767926e+00i },
{ -1.014860e+01+1.702756e+00i, +8.011415e+00-1.671828e+01i, +1.835428e+01+9.289630e+00i, -7.496999e+00+3.442495e+00i, +1.526975e+00-2.090732e+00i },
{ -1.342824e+00+1.577184e+00i, -3.711515e+00-2.194389e+00i, +1.675338e+00-2.166989e+00i, +7.114775e-01+1.138925e+00i, -5.714637e-02-9.129432e-02i },
},
{
{ +2.579424e+00+8.966346e-01i, +6.061413e-01+5.059441e+00i, -2.202760e+00-5.149069e+00i, +8.858935e-01-1.093174e+00i, -2.471261e-01+4.825934e-01i },
{ -2.252123e-01-6.150201e+00i, +1.312577e+01+5.736299e+00i, -5.135804e+00+1.141635e+01i, -3.479796e+00-3.739286e+00i, +1.277465e+00+1.180698e+00i },
{ -3.966599e+00+4.866176e-01i, +9.260595e+00-8.100980e+00i, +1.035998e+01+8.585089e+00i, -4.227764e+00+1.578322e+00i, +1.378075e+00-6.969442e-01i },
{ -5.318594e-02+3.797727e+00i, -4.808508e+00-3.527597e+00i, +3.541540e+00-4.446234e+00i, +3.709370e-01+1.597715e+00i, -2.036971e-01-5.921541e-01i },
{ +4.291536e-01+3.284621e-01i, -7.631871e-01+9.323252e-01i, -6.301095e-01-3.200329e-01i, +1.616401e-01-5.063289e-02i, -4.815217e-02+2.205629e-02i },
},
{
{ +8.634433e-02-5.328553e-01i, -1.100671e+00+4.268692e-01i, -6.758025e-01+4.832759e-02i, +3.715347e-01+8.449773e-02i, -5.223377e-02+8.207634e-02i },
{ -9.908019e-01-1.406235e+00i, -2.882273e-01+8.552380e-02i, -8.203924e-01+6.130502e-01i, +1.026680e-01-6.436914e-01i, +1.483502e-01+1.671411e-01i },
{ -1.493133e+00-4.671059e-01i, -1.621464e-01-1.190784e+00i, +2.608798e-01+3.638260e-01i, -5.035927e-01-1.590624e-01i, +1.725486e-01-5.386279e-02i },
{ -1.443003e-01+5.219221e-02i, -2.370945e-01-1.958943e-01i, +1.871332e-01-2.008528e-02i, -5.293675e-02+1.839547e-01i, -1.164887e-02-4.336818e-02i },
{ +1.936958e-02-8.543311e-02i, +9.006636e-02+1.687881e-02i, +6.840635e-03+1.950315e-02i, +1.517365e-02-9.974385e-03i, -3.834972e-04+5.847374e-03i },
}
},
{// coil19
{
{ +2.771871e+00+1.179838e-01i, +1.153655e+01+4.431984e-01i, -1.104279e+00+3.971015e+00i, -7.775005e+00-5.576255e+00i, -8.373812e-01-2.513271e+00i },
{ -2.029170e+01-9.796877e+00i, -3.194654e+00-5.369934e+01i, +2.102245e+01-1.452502e+01i, -2.734174e+00+1.484278e+01i, -2.367446e+00+8.377809e-01i },
{ -7.772473e+00+9.312436e+00i, -3.343827e+01-1.431308e+01i, -1.134590e+01-3.121837e+01i, +1.216427e+01-3.768593e+00i, +9.145136e-01+1.810118e+00i },
{ +5.423249e+00-1.416940e+00i, +6.262462e+00+1.596091e+01i, -1.417360e+01+9.216091e+00i, -4.505188e+00-5.834493e+00i, +4.009140e-01+2.833629e-01i },
{ -2.238102e+00-1.362094e+00i, +1.807705e+00-4.436564e+00i, +3.614047e+00+4.812595e-01i, +5.366887e-01+1.247073e+00i, +1.792181e-01+1.598232e-01i },
},
{
{ -1.238349e+00-9.614911e+00i, +8.256529e+00-2.555886e+01i, +1.816732e+01+2.858229e-01i, -3.333519e+00+9.628838e+00i, -3.971021e+00-2.519815e-01i },
{ -2.746633e+01-1.612301e+01i, -5.558695e+01-9.987814e+01i, -3.809074e+00-8.670570e+01i, +1.927618e+01-1.663051e+00i, +1.406769e+00+4.637473e+00i },
{ -3.417831e+00-1.305193e+00i, -4.884460e+01-1.197298e+01i, -5.606615e+01-2.437216e+01i, -6.303909e+00-1.530080e+01i, +2.613855e+00-2.383729e+00i },
{ +3.950324e+00-5.365625e+00i, +1.079985e+01+7.901450e+00i, +3.264250e+00+1.747745e+01i, -4.476509e+00+6.259880e+00i, -1.780873e+00-2.010757e-01i },
{ -1.990056e+00-2.523744e-01i, -3.194459e+00-3.994245e+00i, -1.315558e-02-5.396191e+00i, +2.160923e+00-1.502133e+00i, +4.193176e-01+2.084886e-01i },
},
{
{ -7.422747e+00+4.173712e+00i, -1.406152e+01-1.713918e+01i, +1.124995e+01-2.003560e+01i, +9.217427e+00+7.692107e+00i, -1.544363e+00+1.934859e+00i },
{ -4.922884e+00-8.443289e-01i, -3.855231e+01-4.232732e+00i, -4.829528e+01-3.230246e+01i, +4.636418e+00-2.080275e+01i, +4.420259e+00+1.749016e+00i },
{ -5.027252e+00-2.355195e+00i, -2.919148e+00+7.672251e+00i, -1.723651e+01+2.886616e+01i, -1.914180e+01+2.414787e+00i, +2.228244e-01-4.417350e+00i },
{ +4.396191e-01+2.707847e+00i, -4.350151e+00-3.895934e+00i, +1.622423e+01-5.272763e+00i, +6.157222e+00+9.248293e+00i, -2.444787e+00+1.474223e-01i },
{ +8.367240e-01-3.823431e-01i, -2.246663e+00+2.652560e+00i, -5.146322e+00-2.258488e+00i, +1.897047e-01-2.795149e+00i, +2.340912e-01+7.532373e-02i },
},
{
{ +1.266137e+00+6.534050e+00i, -4.969991e+00+4.399991e+00i, -1.691384e+00-7.875984e+00i, +2.779882e+00-8.796107e-01i, +1.869513e-02+4.079083e-01i },
{ +5.674297e+00-2.647056e+00i, +8.816093e+00+1.436550e+01i, -1.201767e+01+1.145929e+01i, -4.951425e+00-4.523461e+00i, +1.087215e+00-5.028576e-02i },
{ -2.296362e+00-7.860522e-01i, +9.017138e+00-2.951664e+00i, +1.084851e+01+1.059085e+01i, -3.085700e+00+5.508464e+00i, -3.695222e-01-9.064893e-01i },
{ +1.800616e+00+2.759845e+00i, -4.515603e+00-5.602940e-02i, +1.981217e+00-6.930964e+00i, +3.471640e+00+6.214982e-01i, -5.775744e-01+1.998960e-01i },
{ +4.530297e-01-7.906243e-01i, +8.069885e-01+1.356453e+00i, -1.490852e+00+1.097281e+00i, -5.339950e-01-5.213862e-01i, +3.190328e-02+1.791312e-02i },
},
{
{ +5.125680e-01-2.726564e-01i, -7.977765e-01-4.226098e-02i, -2.707308e-01-7.064387e-01i, +5.246028e-01+3.851300e-02i, -2.965115e-02+9.024514e-02i },
{ -1.389121e-01-1.996996e+00i, +6.313080e-01-1.157873e+00i, -4.642004e-01-1.625431e-02i, -5.784668e-02-6.024709e-01i, +1.525690e-01+3.129295e-02i },
{ -1.225014e+00-9.178432e-01i, -1.363269e-01-2.604720e+00i, +1.080127e+00-5.679890e-01i, -1.797640e-01+2.518946e-01i, +4.621025e-03-1.113806e-01i },
{ -2.089000e-02+1.001843e-01i, -8.937427e-01-1.943996e-01i, -2.045949e-01-8.413385e-01i, +2.632671e-01-2.606865e-02i, -5.297577e-02+9.696438e-03i },
{ -2.610244e-03-1.028943e-01i, +1.249104e-01+9.813468e-02i, -1.032266e-01+1.646050e-01i, -6.930969e-02-3.084014e-02i, +2.879557e-03+9.509376e-04i },
}
},
{// coil20
{
{ +8.656757e-01+3.629375e-01i, +2.512157e+00+2.271783e+00i, +3.205089e+00+3.586266e+00i, +9.486358e-01+2.297410e+00i, +3.711828e-01+5.083945e-02i },
{ +3.536420e-01-1.285550e+00i, +5.718112e+00-3.863490e+00i, +6.361875e+00-3.990541e+00i, +2.092646e+00-1.908817e+00i, +2.072212e-01-4.901226e-01i },
{ -1.663374e+00+1.591569e-02i, -2.714459e-01-1.430382e+00i, -2.106417e+00-1.643351e+00i, -1.785237e+00-9.987780e-01i, -1.947774e-01+1.516652e-02i },
{ -2.912198e-01+1.361597e-01i, +1.729386e-01+8.159331e-01i, +1.132146e-01+1.459719e+00i, +2.034407e-01+4.124347e-01i, +7.901685e-02+1.531320e-01i },
{ -7.974475e-02-9.594333e-02i, +1.808054e-01-1.997242e-01i, -8.008153e-02-2.101573e-01i, -1.916687e-01-2.228520e-01i, +1.425712e-03-1.207160e-02i },
},
{
{ +2.123814e+00+1.768124e+00i, +4.241936e+00-8.330106e-01i, -5.922048e-01+4.394221e-01i, -2.022319e+00+1.578900e+00i, +2.803455e-01+6.150860e-02i },
{ +7.808547e+00-8.312356e-01i, +1.916845e+01-1.039389e+01i, +8.964522e+00-5.500608e+00i, +1.107730e-01+1.597140e+00i, +2.153157e-01-3.800613e-01i },
{ +3.233864e+00-1.144412e+00i, +4.871082e+00-8.040350e+00i, +1.385898e+00-6.984156e+00i, +3.100979e-01+3.301437e-01i, -1.908801e-01-2.510065e-02i },
{ +2.833477e-01+1.950697e-01i, -2.227417e+00+2.605037e-01i, -1.532355e+00-8.576194e-01i, +8.076630e-01-1.595580e-01i, -7.147340e-02+1.022174e-01i },
{ +1.510604e-01-9.203044e-02i, +2.142472e-01+9.965774e-02i, -2.101374e-01-7.088155e-02i, -1.704711e-01-2.098941e-01i, -2.106691e-02+1.370054e-02i },
},
{
{ -3.653443e-02-5.971486e-01i, +2.491588e+00-2.075458e+00i, +3.714775e+00-2.089658e+00i, +1.516155e-01-1.047130e+00i, +1.780313e-01+1.879325e-01i },
{ +2.466694e+00+9.722862e-01i, +8.988209e+00-2.878799e+00i, +2.176933e+00-4.943515e+00i, -2.021335e+00-8.292482e-01i, +2.748139e-01-1.960627e-02i },
{ +2.126605e+00+2.153873e-02i, +5.742329e+00-5.499286e-01i, +7.027508e-01+5.290573e-01i, -6.147283e-01+1.503567e+00i, +2.253348e-02+3.391373e-02i },
{ +5.829777e-01-5.690653e-01i, +3.761466e-01-9.741518e-01i, +6.466247e-01-9.091826e-01i, +1.019291e+00-4.338451e-02i, -7.663748e-02+2.143019e-02i },
{ +1.595408e-01-5.726871e-02i, -1.681112e-01+2.543347e-01i, -6.034017e-01+4.536435e-02i, -1.723995e-01-1.300117e-01i, -3.052341e-02+2.050928e-02i },
},
{
{ -1.364176e-01-8.040619e-02i, -3.307714e-01+1.033281e+00i, +1.540061e+00+1.788103e+00i, +6.388648e-01+1.749488e-01i, +3.320427e-02+1.139352e-01i },
{ -7.840012e-01-2.303540e-01i, -1.093664e+00+7.632849e-01i, +6.242726e-01-6.748552e-01i, +1.899626e-01-1.262511e+00i, +9.847168e-02+3.171800e-02i },
{ -1.127276e+00+4.539073e-03i, -9.733533e-01+1.599621e+00i, -1.577169e+00+1.074775e+00i, -9.103087e-01-1.557254e-01i, -7.180270e-03+3.460763e-02i },
{ -5.275159e-02-5.070448e-03i, +5.617290e-01+2.955485e-01i, +4.552307e-01+6.080691e-01i, +1.708717e-01+2.588589e-01i, -2.876965e-03+3.351165e-02i },
{ -9.516470e-03-4.716639e-02i, -8.490588e-02-8.135369e-02i, -1.583647e-01-1.550571e-01i, -3.653839e-02-9.308849e-02i, -4.284744e-03-1.867187e-04i },
},
{
{ +8.159935e-02-4.454693e-02i, -1.356570e-01-4.539974e-01i, -3.780757e-01-1.710386e-01i, -1.361244e-01+2.758152e-02i, -1.311396e-02-1.470624e-03i },
{ +4.016341e-01-1.497774e-01i, +1.817250e-01-4.710454e-01i, -1.692042e-02+6.761078e-02i, +1.892513e-02+1.293727e-01i, -8.392356e-03+1.188729e-02i },
{ +2.667890e-01-2.082564e-01i, +2.442846e-01-3.806804e-01i, +2.140321e-01-1.976110e-01i, +8.747331e-02-1.064329e-02i, +1.116395e-03+6.304330e-03i },
{ +1.618342e-02-2.834900e-02i, -5.365679e-02-6.312138e-02i, -4.764567e-02-9.106386e-02i, +1.030672e-02-1.444390e-02i, -1.997161e-03+1.647522e-03i },
{ +8.034958e-03-5.935992e-04i, +5.123198e-03+6.741548e-03i, +1.625631e-03-4.047665e-03i, +3.938810e-03-5.983943e-03i, +5.253110e-05+1.612753e-04i },
}
},
{// coil21
{
{ -2.455891e-01-6.483735e-01i, -6.357326e-01-1.193838e+00i, +9.253339e-01+1.152204e-01i, +1.285219e-01+4.638782e-01i, +2.224448e-02+3.356510e-01i },
{ +9.883025e-01-1.689618e-01i, -3.934219e-01-2.872961e-01i, +7.153944e-01-1.060935e+00i, +1.561131e+00-9.866201e-01i, +2.628884e-02-2.917387e-03i },
{ +1.079864e+00-1.245624e-01i, +8.382039e-01-1.749275e-01i, -3.711108e-01-1.009059e+00i, -3.050822e-01-8.039353e-01i, -2.577719e-01-2.377807e-02i },
{ +2.460446e-01-5.414924e-02i, +3.628311e-01-7.326186e-02i, -7.340400e-02-2.744089e-02i, +1.156223e-01+2.195252e-01i, -3.090681e-02+8.133560e-02i },
{ -8.666214e-03-1.395727e-01i, +6.840421e-02+6.903178e-03i, -1.039574e-01-5.309790e-02i, -3.594892e-02-1.694130e-01i, -3.129582e-03-4.718686e-03i },
},
{
{ +9.834248e-01-1.723325e-02i, +4.474953e+00+1.286935e+00i, +1.452813e+00+2.691586e+00i, -1.001634e+00+1.307273e+00i, -5.525262e-02+3.004239e-01i },
{ +8.113861e-02-3.520996e+00i, +4.468376e+00-7.269423e+00i, +4.490956e+00-2.673651e+00i, +1.461539e+00+4.904495e-02i, +1.128154e-01-1.037717e-01i },
{ -2.146330e+00-1.492379e+00i, -2.818602e+00-6.498390e+00i, -2.001581e+00-3.275941e+00i, -9.231600e-01-2.336461e-01i, -2.315021e-01-1.699747e-01i },
{ -2.742177e-01+7.219745e-01i, -4.645938e-01+5.121596e-01i, -1.138258e-02+9.437751e-01i, +2.445513e-01+7.764289e-01i, -1.101254e-02+5.303685e-02i },
{ +4.812281e-02-1.848329e-01i, +9.616621e-02-3.568307e-01i, -7.308543e-02-5.034639e-01i, -3.120303e-05-3.128451e-01i, -5.897582e-03-2.261516e-02i },
},
{
{ +1.074233e+00+7.014440e-01i, +1.166231e+00+1.280064e+00i, +1.335053e-01+2.116276e+00i, +4.294954e-01+3.127206e-01i, -1.820175e-01+4.552408e-02i },
{ +2.985053e+00-2.152315e+00i, +5.433152e+00-4.416308e+00i, +1.379020e+00-2.421958e+00i, +4.990793e-01-4.153286e-01i, -5.005933e-02-7.708545e-02i },
{ +3.664531e-01-2.529350e+00i, +5.567906e-01-5.213966e+00i, -1.680392e+00-1.728995e+00i, -5.712339e-01+3.028650e-01i, -6.994854e-02-1.002600e-01i },
{ -3.953318e-01+2.516040e-01i, -8.243582e-01+1.058955e-01i, +7.910657e-02+2.755303e-01i, +3.396760e-01+3.927609e-01i, -8.248266e-03-2.584504e-02i },
{ +1.795107e-01-3.401026e-02i, +1.546628e-02-8.411763e-02i, -1.900461e-01-3.054729e-01i, -2.089559e-02-1.490481e-01i, -1.641205e-02-1.208024e-02i },
},
{
{ -3.810731e-02-2.337518e-02i, -1.396900e-01-9.310781e-01i, +4.994084e-01-9.267393e-02i, +4.109247e-01-2.025705e-02i, -6.084903e-02-2.107749e-03i },
{ +7.025986e-01+1.162051e+00i, -1.312488e-01+6.250914e-01i, -2.549967e-01-9.092543e-01i, +2.515907e-01-2.706553e-01i, -4.399306e-02-3.351227e-02i },
{ +1.027012e+00+2.649224e-01i, +9.898847e-01+9.134350e-01i, -2.498606e-01+9.540054e-02i, -8.054950e-02+7.277034e-03i, -3.273817e-02-2.266023e-02i },
{ -4.166373e-02-1.364655e-01i, +3.860303e-02-1.162097e-01i, +1.539362e-01-9.397306e-02i, +6.598926e-02+4.848768e-02i, -1.195571e-02-9.302548e-03i },
{ +6.758681e-02+5.108357e-02i, -2.434068e-03+1.215507e-01i, -6.977475e-02-2.684176e-03i, -7.849935e-03-1.471873e-02i, -6.614188e-03-4.817143e-04i },
},
{
{ +2.070528e-02-3.753949e-02i, +4.960085e-02-4.965264e-02i, -9.436779e-02+8.856135e-02i, -8.426961e-02+1.620826e-02i, -5.510244e-03+1.452695e-03i },
{ -2.216664e-01-1.450900e-01i, -3.458182e-01-1.928276e-01i, -1.157206e-01+1.564692e-01i, -6.162959e-02+9.899150e-02i, +6.009080e-05+2.095216e-03i },
{ -1.731122e-01-2.430834e-02i, -2.487714e-01-1.671326e-02i, -4.988194e-03+1.080130e-01i, +9.658130e-03+5.907130e-02i, +1.855080e-03-1.499925e-03i },
{ -3.132742e-02+4.938758e-03i, -3.151736e-02-2.040494e-02i, +2.348607e-02-1.154183e-02i, +8.898966e-03+7.056615e-03i, -1.219912e-04-1.598457e-03i },
{ -1.113935e-03+9.735454e-03i, -1.174140e-02+1.231090e-02i, -5.823942e-03-2.237777e-04i, +1.147875e-03-4.537229e-04i, -3.932051e-04-1.055464e-04i },
}
},
{// coil22
{
{ +7.361782e+00+4.287299e+00i, +1.912373e+01-1.217236e+01i, +7.725934e+00-1.845234e+01i, -2.025383e+00-6.848325e+00i, -7.689370e-01-8.036263e-02i },
{ +1.089984e+01-4.221615e+00i, +2.584336e+01-2.535328e+01i, +7.519221e+00-2.718998e+01i, -5.291283e+00-5.737211e+00i, -6.134962e-01-4.602127e-02i },
{ +3.081059e+00+1.033440e-01i, +1.719727e+01-5.311186e+00i, +4.727322e+00-1.777905e+01i, -5.745934e+00-2.218582e+00i, -9.470131e-02+3.872723e-01i },
{ -2.362158e+00+1.369540e+00i, +1.691209e+00+1.828627e+00i, -2.269299e+00-2.422712e+00i, -1.222656e+00+8.106212e-01i, +1.218455e-01+2.155055e-01i },
{ +5.864874e-02+3.355533e-02i, +1.001899e+00+1.309561e-01i, +3.448279e-01+1.228387e-01i, +1.363025e-01-8.503734e-02i, +9.125721e-03-2.997708e-03i },
},
{
{ -8.250462e+00-1.469127e+01i, -4.060872e+01-3.603412e+01i, -3.741372e+01-4.890347e+00i, -7.602707e+00+8.007030e+00i, -8.510597e-01+1.259298e+00i },
{ -1.680495e+01-1.442241e+01i, -3.003199e+01-4.059898e+01i, -2.804383e+01-1.273830e+01i, -3.122530e+00+1.151991e+01i, +1.363589e+00+1.122686e-01i },
{ +2.218292e+00+3.250657e+00i, +5.747771e+00-2.032584e+01i, -7.665424e+00-1.038992e+01i, -1.206568e+00+7.465305e+00i, +3.389968e-01-1.221944e+00i },
{ +3.927135e+00+4.535322e+00i, -1.087134e+00-2.711315e+00i, -1.632871e+00-1.044263e+00i, +2.253184e+00+2.651834e+00i, -3.709358e-01-3.235077e-01i },
{ +1.445748e+00-1.066902e-01i, +8.117304e-01-1.142404e+00i, -2.859139e-01-1.065184e+00i, +2.124530e-01-5.397002e-01i, -8.430988e-02-7.357897e-02i },
},
{
{ -1.556575e+01+5.588909e+00i, -2.147212e+01+2.465166e+01i, +8.593666e+00+2.338132e+01i, +1.086528e+01+3.482392e+00i, +2.011772e-01+2.121086e-01i },
{ -8.800405e+00+1.394636e+01i, -5.878415e+00+1.743317e+01i, +6.368984e+00+1.203886e+00i, +8.188782e+00-4.331557e+00i, +1.082898e+00-8.309211e-01i },
{ +6.314818e+00+1.068475e+00i, -1.244616e+00-1.181501e+00i, -1.554504e+00+2.213679e+00i, +7.342877e-01-1.216789e+00i, -3.701629e-01-1.000491e+00i },
{ +3.351350e+00-2.960949e+00i, -4.355289e+00-1.551072e+00i, +1.592465e+00+5.047345e-01i, +1.575271e+00+3.238066e-01i, -5.528610e-01-5.822629e-02i },
{ +5.412048e-01-6.649002e-01i, -1.003051e+00-1.269741e-01i, -1.043362e+00-7.793617e-02i, -9.924988e-02-2.091577e-01i, -6.974259e-02-1.292633e-03i },
},
{
{ +4.865606e+00+3.289227e+00i, +1.332208e+01-3.452679e+00i, +5.357206e+00-1.183093e+01i, -9.318975e-01-5.024006e+00i, -3.825009e-01-2.560173e-01i },
{ +7.006274e+00-1.485377e+00i, +5.576849e+00-7.325296e+00i, -6.805505e+00-8.579631e+00i, -4.963325e+00-2.627025e+00i, -3.175281e-01+1.891874e-01i },
{ +3.353439e-01-3.553743e+00i, -1.265301e+00+9.165955e-01i, -7.566113e-01+9.547281e-01i, -1.776186e+00+3.776474e-02i, -5.808487e-02+2.583213e-01i },
{ -1.403081e+00-9.100458e-01i, -1.234712e+00+1.246600e+00i, +7.385510e-01-6.939724e-01i, -1.567971e-01-1.520894e-01i, -4.145242e-02+9.755264e-02i },
{ -1.980336e-01+1.003518e-01i, -8.554700e-02+7.310818e-01i, +1.157353e-01+4.681618e-01i, +6.287297e-02+9.338203e-02i, +1.352989e-02+1.165730e-02i },
},
{
{ -1.690056e+00-1.144594e+00i, -4.880290e+00+2.832887e-01i, -3.199896e+00+3.095442e+00i, -2.574673e-01+1.449796e+00i, +3.854059e-02+1.534483e-01i },
{ -2.991590e+00-6.912184e-02i, -4.314209e+00+3.684507e+00i, +2.099156e-02+5.389335e+00i, +1.084139e+00+1.608314e+00i, +2.022283e-01+9.895335e-02i },
{ -7.791316e-01+6.947041e-01i, +6.996503e-02+1.535193e+00i, +1.814030e+00+8.870970e-01i, +8.399040e-01+5.682412e-02i, +9.006436e-02-4.487909e-02i },
{ +2.395241e-01+1.727729e-01i, +1.234073e-01-1.078288e-01i, -1.286384e-02-4.081432e-01i, +1.877014e-03-1.038164e-01i, -9.979906e-03-1.366848e-02i },
{ +7.000838e-02+1.320218e-02i, +8.379184e-02-1.185329e-02i, +2.718708e-02-2.928300e-02i, +6.205434e-03-8.972998e-03i, -4.842661e-04-2.602661e-03i },
}
},
{// coil23
{
{ +1.667126e+01-6.824870e-01i, +1.365916e+01-1.716726e+01i, +1.427136e+00-1.315553e+01i, -1.766625e+00-4.187163e+00i, -6.688868e-01+6.940372e-01i },
{ +1.667562e+01-2.859697e+00i, +2.533774e+01-7.696656e+00i, +1.566521e+01-9.131306e+00i, -2.663381e-01-6.080555e+00i, -7.744565e-01+2.960777e-01i },
{ +4.650197e+00+1.158417e+00i, +5.442357e+00+9.508289e+00i, +1.557184e+01+2.929004e+00i, +1.235289e+00-3.047025e+00i, -5.380309e-01+9.021124e-02i },
{ -8.594985e-01-2.429995e+00i, -6.641755e+00+1.617680e+00i, +3.016820e+00+1.308033e+00i, +1.469419e+00-1.828246e-01i, -1.673588e-01-3.003288e-02i },
{ +5.382861e-01-6.917933e-01i, -4.028271e-01+1.460207e-01i, -2.002479e-01-1.201151e-01i, +1.237021e-01-1.039632e-01i, -9.504786e-02+1.860066e-02i },
},
{
{ -2.044186e+01-3.057387e+01i, -3.925684e+01-2.702413e+01i, -1.967688e+01-1.735276e+00i, -2.967253e+00+5.043877e+00i, +7.012185e-01+5.482452e-01i },
{ -1.807658e+01-3.039653e+01i, -7.622424e+00-3.699896e+01i, -4.565422e+00-2.091980e+01i, -6.549376e+00+3.519128e+00i, +1.074640e+00+3.587286e-01i },
{ -7.315628e+00+1.215029e+00i, +2.110065e+01+3.737853e+00i, +1.247018e+01-1.230379e+01i, -6.796271e+00-1.418831e+00i, +1.236224e+00+1.664744e-01i },
{ -6.499907e+00+3.151700e+00i, +2.192379e+00+3.665667e+00i, +5.259826e+00-1.752206e+00i, -2.053964e+00-5.865789e-01i, +6.093693e-01-4.345830e-01i },
{ -1.555222e-01+6.671290e-01i, +1.071902e+00+7.150900e-01i, +9.904923e-01-4.472760e-01i, -1.189030e-01+3.552423e-02i, -4.935959e-02-4.475706e-02i },
},
{
{ -2.282767e+01+1.489187e+01i, -6.547448e+00+1.869454e+01i, +5.320919e+00+3.829594e+00i, +3.839113e+00+1.353947e+00i, +2.678738e-01-1.411163e+00i },
{ -2.243903e+01+1.775616e+01i, -1.176645e+01+1.185226e+01i, +2.284427e+00-4.212933e-01i, +4.367909e+00+3.171213e+00i, +5.111992e-02-8.163123e-01i },
{ +1.717033e-01+1.251064e+01i, +3.725029e+00-1.256293e+00i, -5.682380e+00-3.087805e+00i, -6.076791e-01+2.313061e+00i, +7.549812e-01-2.947878e-01i },
{ +2.009539e+00+4.105056e+00i, +4.155685e+00-4.286137e+00i, -2.128018e+00+6.607723e-02i, -2.175189e+00+1.453783e+00i, +4.338168e-01-5.936351e-01i },
{ +4.454609e-01+8.257331e-01i, +1.229398e+00-9.900188e-01i, +8.075613e-01-7.057708e-01i, -4.971060e-02+3.394322e-01i, -6.951666e-03-7.208762e-02i },
},
{
{ +1.017356e+01+2.676612e+00i, +6.675687e+00-8.431076e+00i, -5.029791e+00-5.735898e+00i, -1.188951e+00-7.015235e-01i, -6.207533e-01-3.020530e-01i },
{ +1.167324e+01+1.940361e+00i, +6.493773e+00-3.767968e+00i, +1.490126e+00-2.758120e+00i, +2.930314e-01-1.583937e+00i, -7.756295e-01+1.002607e-01i },
{ +5.066726e+00-1.590879e+00i, -1.764630e+00-3.042873e+00i, +1.817109e+00-1.544686e-01i, +1.566300e+00-9.531474e-01i, -1.930820e-01+4.389111e-02i },
{ +8.241098e-01-1.146908e+00i, -2.456377e+00-1.622113e+00i, -7.257487e-01+1.155611e+00i, +2.609881e-01+3.247363e-01i, -6.563500e-03-1.305934e-01i },
{ +4.381916e-02-9.741738e-02i, -1.576205e-01-4.096951e-01i, +1.680129e-01-8.915607e-02i, +9.417471e-02+8.622529e-02i, -4.846554e-03-1.755884e-02i },
},
{
{ -3.194926e+00-1.137538e+00i, -4.085903e+00+2.485762e+00i, -1.608369e-01+3.155169e+00i, +5.891941e-01+5.906958e-01i, +6.457861e-02+6.183178e-02i },
{ -3.927338e+00-1.895086e+00i, -4.594100e+00+1.502640e+00i, -7.569921e-01+2.290348e+00i, +2.045398e-01+5.032809e-01i, +7.395945e-02+1.153032e-01i },
{ -1.663607e+00-2.920862e-01i, -1.272882e+00+5.213243e-01i, -5.262940e-01+2.211761e-01i, -2.783921e-01+5.032843e-02i, +2.176886e-02+4.428358e-02i },
{ -2.336166e-01+3.700229e-01i, +1.508658e-01+3.877012e-01i, +9.002602e-02+6.622106e-03i, -9.950884e-02-2.348482e-02i, +2.031028e-04-9.624261e-03i },
{ -7.205967e-03+6.716533e-02i, +5.478103e-02+3.618157e-02i, +4.068371e-02-2.504486e-02i, -4.415535e-03-5.883208e-03i, -1.117260e-03-2.315535e-03i },
}
},
{// coil24
{
{ -1.789215e+01+3.290399e+00i, +3.150884e+01+4.991675e+01i, +4.834897e+01-2.133316e+01i, -2.078631e+01-1.500935e+01i, +1.755174e+00+7.191913e+00i },
{ +6.210831e+00+2.085809e+01i, +5.675308e+01+4.182179e+00i, +4.987373e+00-2.734097e+01i, -8.716626e+00+1.136496e+01i, +7.088970e+00-8.718520e-02i },
{ +7.872266e+00-4.908626e+00i, -8.394543e+00-1.292272e+01i, -5.513920e+00+6.951218e+00i, +7.436392e+00-4.344674e+00i, -1.867393e+00-3.135971e+00i },
{ -1.154907e+00-1.547619e+00i, -2.381505e+00+3.432772e+00i, +2.754601e+00-9.690642e-01i, -3.099819e+00-6.912830e-01i, -7.607338e-01+1.168416e+00i },
{ +5.385289e-01+9.394287e-02i, -7.669390e-01-4.487758e-01i, -1.828464e-01+5.622144e-01i, +1.646576e+00-1.672246e-01i, +8.329434e-02-3.064033e-01i },
},
{
{ -8.728371e+00-3.427529e-01i, +3.560579e+01+8.310188e+01i, +9.153523e+01+4.746237e+00i, -1.601007e+01-3.377211e+01i, -2.975347e+00+1.216674e+01i },
{ +8.122768e+00+3.950065e+01i, +1.123878e+02+4.849314e+01i, +4.173275e+01-4.419477e+01i, -2.168043e+01+9.307131e+00i, +1.155140e+01+4.123463e+00i },
{ +1.395838e+01+8.708226e+00i, +1.513118e+01-1.363596e+01i, -6.930398e+00+5.027622e+00i, +7.685009e+00+6.161761e-02i, +2.589966e-01-5.609733e+00i },
{ -1.548328e+00-2.484943e+00i, -4.942902e-01-2.199754e+00i, +4.941328e+00-9.331039e-01i, -4.394489e+00-8.435562e-01i, -1.240103e+00+9.554956e-01i },
{ +7.618253e-01+1.158365e+00i, -1.363412e+00-9.695961e-01i, -1.348657e+00+1.088174e+00i, +2.438774e+00+6.613464e-01i, +1.924108e-01-5.107519e-01i },
},
{
{ +4.851364e+00-9.086785e+00i, -9.462036e+00+3.713425e+01i, +4.419043e+01+2.716071e+01i, +2.438241e+00-2.526166e+01i, -5.352795e+00+6.184200e+00i },
{ +2.575220e+00+2.060070e+01i, +6.508630e+01+3.735917e+01i, +3.287326e+01-3.003122e+01i, -1.970357e+01-7.177132e-01i, +4.807583e+00+5.239740e+00i },
{ +1.432397e+01+1.092459e+01i, +2.147602e+01-1.602672e+01i, -1.065259e+01-7.794772e+00i, +3.232744e+00+6.577100e+00i, +1.875785e+00-2.682483e+00i },
{ +7.428342e-01-1.579688e+00i, -2.725441e+00-2.090574e+00i, +1.871887e-02+1.733500e+00i, -8.001947e-01-1.264377e+00i, -7.438678e-01-1.498810e-01i },
{ +5.429606e-01+1.038249e+00i, +2.162407e-01-9.580666e-01i, -9.802648e-01+5.098845e-01i, +1.006886e+00+1.116623e+00i, +1.179340e-01-2.271185e-01i },
},
{
{ -2.564415e+00-4.391205e+00i, -9.548915e+00+7.289068e+00i, +6.339674e+00+6.835320e+00i, +1.527409e+00-5.693933e+00i, -1.048215e+00+8.530222e-01i },
{ -5.339200e+00+2.866817e+00i, +7.350995e+00+9.569687e+00i, +6.955887e+00-5.297368e+00i, -4.786441e+00-1.394669e+00i, +4.229944e-01+1.147617e+00i },
{ +2.816389e+00+2.053814e+00i, +2.301098e+00-5.925969e+00i, -3.390008e+00-3.223149e+00i, +7.608804e-01+1.993853e+00i, +2.506151e-01-2.624449e-01i },
{ +4.785630e-01-6.094767e-01i, -2.285380e+00+1.977031e-01i, -7.650569e-01+7.663518e-01i, +2.779834e-01-5.630482e-01i, -1.874036e-01-7.257733e-02i },
{ +1.349497e-01+2.465148e-01i, +4.496027e-01-2.073974e-01i, -4.143396e-02-2.026886e-03i, +9.134787e-02+2.971041e-01i, +1.274093e-02-1.573876e-02i },
},
{
{ +4.111819e-01-3.954474e-01i, -3.112972e-01+6.364375e-02i, +2.122925e-01+3.973386e-01i, +2.185712e-02-1.565254e-01i, -3.773257e-02+1.020389e-01i },
{ +2.667912e-01-4.505409e-02i, +3.704931e-01-7.466184e-02i, -1.810218e-02+1.944226e-02i, -1.188937e-01+2.175873e-01i, +6.832499e-02+4.325469e-02i },
{ +4.022198e-01+1.721222e-01i, -1.419761e-01-3.485719e-01i, -2.127855e-01+5.505946e-01i, +3.037903e-01+1.802041e-01i, -1.715752e-02-5.248045e-02i },
{ +2.659478e-02-8.343571e-02i, -1.306439e-01+6.210537e-02i, +1.739586e-01+1.655426e-01i, +4.978821e-02-8.881025e-02i, -2.570684e-02+2.904693e-03i },
{ -1.298195e-02+2.306592e-02i, +2.135825e-02-1.315588e-02i, -5.765498e-03-9.062431e-03i, -1.145770e-03+1.982556e-02i, +7.861439e-04-4.549866e-04i },
}
},
{// coil25
{
{ +6.542907e+00+8.732269e+00i, +2.768288e+01-2.659936e+01i, -1.064501e+01-3.998852e+01i, -1.615326e+01+1.172883e-01i, -1.039034e+00+1.612145e+00i },
{ +8.605532e+00-9.348665e+00i, -1.567741e+01-3.554629e+01i, -3.556456e+01+1.037737e+00i, +2.286816e+00+1.803510e+01i, +3.878030e+00-4.231072e-01i },
{ -5.161053e+00+2.158513e-01i, -6.134947e+00+1.200043e+01i, +1.052959e+01+8.202517e+00i, +4.509093e+00-7.203161e+00i, -9.162837e-01-2.530967e+00i },
{ +1.443184e+00+2.272591e+00i, +1.651704e+00-3.172340e+00i, -3.487517e+00-5.025450e+00i, -4.883083e+00+2.799562e+00i, -4.931257e-01+8.745913e-01i },
{ -2.024276e-01-3.983216e-01i, -1.517943e+00+2.130709e+00i, +2.073630e+00+2.127704e+00i, +2.500330e+00-6.596955e-01i, +1.537179e-01-3.876981e-01i },
},
{
{ +1.413351e+00+4.183971e+00i, +4.543874e+01-3.157939e+01i, +1.204206e+01-7.378549e+01i, -2.764599e+01-1.242237e+01i, -2.178309e+00+4.459005e+00i },
{ +1.725032e+01-1.687148e+01i, -3.647213e+00-8.321481e+01i, -6.067043e+01-3.351006e+01i, -5.894619e+00+3.002451e+01i, +8.031819e+00+7.855107e-01i },
{ -1.665608e+00-9.011916e+00i, -1.574128e+01+1.259421e-01i, +4.183637e+00+1.523428e+01i, +1.173857e+01-9.111052e+00i, -5.371006e-01-5.445708e+00i },
{ +6.448579e-02+3.323205e+00i, +2.740165e+00-1.414755e+00i, -3.452652e+00-5.678912e+00i, -9.042511e+00+1.838649e+00i, -1.211372e+00+1.337160e+00i },
{ +3.574425e-01-1.171119e+00i, -2.030327e+00+1.859568e+00i, +2.882765e+00+4.494661e+00i, +4.241736e+00-7.620144e-02i, +4.131565e-01-5.891252e-01i },
},
{
{ -4.437572e+00-4.736500e-01i, +2.942522e+01+3.448938e-01i, +3.065165e+01-3.773578e+01i, -1.321689e+01-1.575342e+01i, -1.444391e+00+2.503554e+00i },
{ +1.102283e+01-1.092645e+01i, +8.219318e-02-6.255496e+01i, -4.043113e+01-3.366574e+01i, -1.156078e+01+1.809617e+01i, +3.992040e+00+1.293441e+00i },
{ -1.520570e+00-1.097627e+01i, -2.611933e+01-5.527346e+00i, -5.382302e+00+1.815178e+01i, +1.126556e+01+2.142788e-01i, +3.138158e-01-2.957305e+00i },
{ -2.102967e+00+2.078221e+00i, +3.486859e+00+2.464023e+00i, +3.952188e+00-4.344909e+00i, -4.384956e+00-2.266370e+00i, -7.307529e-01+5.047190e-01i },
{ +2.402674e-01-7.841489e-01i, -2.122575e+00-1.954661e-01i, +8.639328e-02+3.014427e+00i, +1.992983e+00+8.950469e-01i, +2.827612e-01-2.441560e-01i },
},
{
{ -1.196909e+00+3.281734e+00i, +9.040326e+00+5.461725e+00i, +8.466513e+00-5.085650e+00i, -1.659263e+00-3.540964e+00i, -3.027836e-01+8.072326e-02i },
{ +4.028930e+00+2.002744e+00i, +4.053321e+00-1.123394e+01i, -7.929199e+00-7.662148e+00i, -3.741349e+00+3.836227e+00i, +3.125861e-01+2.648656e-01i },
{ +5.054903e-02-1.820160e+00i, -7.594571e+00+1.835198e-01i, -1.932015e+00+5.740869e+00i, +2.835092e+00+1.593792e+00i, +1.621584e-01-2.960659e-01i },
{ -7.810716e-01+4.331877e-01i, +7.504040e-01+1.511824e+00i, +1.791662e+00-9.825562e-01i, -4.621009e-01-1.040814e+00i, -9.186492e-02+3.880327e-02i },
{ +2.961327e-02-8.607891e-02i, -6.754507e-01-1.025305e-01i, -3.581247e-01+6.324228e-01i, +2.278884e-01+3.434836e-01i, +5.215151e-02-1.913594e-02i },
},
{
{ -3.503974e-01-2.262376e-01i, -8.404452e-02+3.755685e-02i, +2.286997e-01-3.059630e-01i, -1.710296e-03-1.274699e-01i, +1.095798e-02+6.277374e-03i },
{ -3.336499e-01-2.861581e-02i, -3.248587e-01+1.090108e-01i, -2.976856e-01-1.265138e-01i, +3.877493e-02+8.108449e-02i, +4.941192e-02-8.772078e-03i },
{ +1.556933e-01-8.300818e-02i, +2.842593e-01+2.928933e-01i, +3.838609e-01+8.438488e-02i, +1.809691e-01-2.363494e-01i, -2.468407e-03-3.315205e-02i },
{ +4.026917e-02-9.795542e-02i, +1.479169e-01-1.587078e-01i, -9.467705e-03-1.868290e-01i, -1.481852e-01-8.113635e-02i, -1.035112e-02+1.156816e-02i },
{ -2.251790e-03+5.866304e-03i, -2.899203e-02+4.466188e-02i, +1.434363e-02+9.676206e-02i, +2.995603e-02+3.612765e-02i, +5.675741e-03-1.276807e-03i },
}
},
{// coil26
{
{ -9.697777e+00+8.312670e+00i, -8.127844e+00-1.293296e+01i, +1.730905e+01-3.154884e+00i, +5.801861e-01+1.281849e+01i, -3.124078e+00+1.063262e-01i },
{ +6.766615e+00+1.711970e+01i, -4.888419e+01+2.989004e+01i, -3.928672e+01-3.099573e+01i, +1.767226e+01-1.360216e+01i, +1.065329e+00+4.810960e+00i },
{ +1.080163e+01-6.557936e+00i, +4.854525e+00+2.974037e+01i, -3.354418e+01+2.946858e+01i, -1.639857e+01-8.704517e+00i, +1.913185e+00-2.796735e+00i },
{ +2.286579e+00+7.097100e+00i, -4.505598e+00-6.742342e+00i, +1.914210e+01-3.002373e+00i, +2.275751e+00+1.286226e+01i, -2.532945e+00-1.396896e+00i },
{ +3.602328e+00+7.109120e-01i, -4.579118e+00+5.713616e+00i, -7.210188e+00-5.240415e+00i, +1.924116e+00-3.428413e+00i, +1.029055e-01+2.058420e-01i },
},
{
{ -1.643722e+01-1.759109e+00i, -1.041886e+01-3.628636e+01i, +2.044544e+01-8.389361e+00i, -5.733815e+00+1.289497e+01i, -5.166962e+00-1.420855e+00i },
{ -2.181726e+01+2.285531e+01i, -1.323929e+02-1.450318e+01i, -7.425612e+01-7.729505e+01i, +2.513605e+01-1.065722e+01i, +2.250871e-01+7.905529e+00i },
{ +3.372147e+00-2.344023e+00i, -3.671249e+01+4.520038e+01i, -7.796529e+01+3.826170e+01i, -2.089142e+01-1.877806e+01i, +5.514579e+00-3.511010e+00i },
{ -2.103567e-01+5.416964e+00i, +5.566074e+00-1.038668e+01i, +3.202332e+01+1.056964e+01i, -3.403592e+00+1.863706e+01i, -2.983675e+00-2.950475e+00i },
{ +3.760191e+00+2.148825e+00i, -1.002149e+01+5.458858e+00i, -8.899697e+00-1.031931e+01i, +4.301647e+00-4.290169e+00i, +2.522776e-01+4.445129e-01i },
},
{
{ -1.270313e+01-9.451988e+00i, -2.162040e+00-2.783895e+01i, +1.066458e+01-2.421565e+00i, -9.212410e+00+3.910580e+00i, -2.969443e+00-2.536421e+00i },
{ -2.351103e+01+2.221747e+01i, -9.289639e+01-2.348003e+01i, -2.770258e+01-5.096227e+01i, +1.651060e+01+6.062888e+00i, -2.547261e+00+4.096403e+00i },
{ +3.998447e+00+7.079575e+00i, -2.370852e+01+3.566351e+01i, -4.397126e+01+1.484522e+01i, -4.209136e+00-1.574816e+01i, +4.505329e+00-3.629328e-01i },
{ -7.557215e+00-3.414517e+00i, +1.508921e+01-1.246533e+01i, +1.934239e+01+1.605825e+01i, -8.599430e+00+7.613959e+00i, -2.267184e-01-2.164219e+00i },
{ +1.773055e-01+2.701226e+00i, -6.932597e+00+1.667478e-01i, -1.759291e+00-6.503398e+00i, +3.009084e+00-1.094392e+00i, +1.913108e-01+2.596411e-01i },
},
{
{ -1.712214e+00-3.077339e+00i, +6.647009e+00-4.306125e+00i, +4.815520e+00+5.380759e+00i, -3.675387e+00+2.190634e+00i, -4.779051e-01-7.277125e-01i },
{ -2.109435e+00+6.860612e+00i, -1.181952e+01-3.108449e+00i, +6.072551e+00-9.399798e+00i, +5.897839e+00+4.402350e+00i, -1.232251e+00+7.247472e-01i },
{ +6.901377e+00+4.029209e+00i, -2.295366e+00+1.258266e+01i, -8.565081e+00-2.203796e+00i, +1.883602e+00-4.972090e+00i, +6.541675e-01+4.420997e-01i },
{ -7.131491e-01-1.537014e+00i, +4.825546e+00-1.596303e+00i, +1.809040e+00+4.603219e+00i, -2.726255e+00+6.555816e-01i, +1.712328e-01-3.819838e-01i },
{ -1.360813e-01+8.526427e-01i, -1.390349e+00-2.243986e-01i, +2.276790e-01-1.349850e+00i, +6.797063e-01-3.670816e-02i, +4.138084e-02+5.033856e-02i },
},
{
{ -2.938043e-01-5.228409e-01i, -2.948355e-01-7.902343e-01i, -1.925918e-01-2.489626e-03i, -2.077321e-01-3.641273e-02i, -2.037048e-03-6.090099e-02i },
{ -3.802027e-01-5.638702e-01i, -1.421327e+00-8.971257e-01i, -1.642965e-01-8.803923e-01i, +2.982704e-01+1.704278e-01i, -1.196754e-01+2.282261e-02i },
{ -2.290152e-01-8.968569e-01i, -2.659279e-01-6.507115e-01i, -3.755094e-01-6.027774e-01i, +1.279971e-01-3.237570e-01i, +2.502903e-02+4.388053e-02i },
{ -4.320780e-01-2.346684e-01i, -8.972096e-02-5.516024e-01i, +7.373562e-02+1.163716e-01i, -1.846724e-01+5.881162e-02i, +1.659613e-02-2.581469e-02i },
{ +1.905336e-02+6.793600e-02i, -7.391453e-02+4.717018e-02i, +2.546805e-02-6.344629e-02i, +5.876751e-02+4.242800e-03i, +2.630183e-03+5.809171e-03i },
}
},
{// coil27
{
{ -8.966802e+00-7.061181e-01i, +3.810114e+00-9.146997e+00i, +2.560013e+00+4.853753e+00i, -4.593249e+00-1.346778e+00i, +1.257054e+00-8.522916e-01i },
{ -5.141083e+00+1.430270e+01i, -3.908314e+01-2.365784e+01i, +7.407442e+00-2.975229e+01i, +3.134609e+00+1.302134e+01i, -3.977836e+00-3.951380e+00i },
{ +1.666634e+01+6.395762e+00i, -3.123734e+01+2.197133e+01i, -2.484188e+01-3.250869e+01i, +1.700537e+01-6.192656e-01i, -5.732915e+00+2.855041e+00i },
{ +4.023137e-01-4.976732e+00i, +8.289190e+00+1.081386e+01i, -1.255648e+01+6.698172e+00i, +2.854359e-02-7.551673e+00i, +1.186924e+00+2.397249e+00i },
{ -1.706153e+00+4.143945e-01i, +1.594538e-01-3.470829e+00i, +2.398918e+00+6.480135e-01i, -9.956057e-01+7.586235e-01i, +2.164374e-01-3.498399e-01i },
},
{
{ -9.722360e+00-1.180966e+01i, +1.179204e+01-1.084935e+01i, +1.341486e-01+1.015311e+01i, -2.375512e+00-6.852431e+00i, +3.494506e+00+3.200637e-01i },
{ -2.630427e+01-4.548531e+00i, -2.353720e+01-9.702432e+01i, +4.621575e+01-4.283622e+01i, -5.413473e+00+1.848619e+01i, -2.332342e+00-8.962239e+00i },
{ +8.477192e+00+7.180931e+00i, -5.898536e+01-2.322452e+01i, -1.302723e+01-7.750913e+01i, +2.563464e+01+7.895155e+00i, -1.001639e+01+2.025893e+00i },
{ +3.961472e+00-8.214352e+00i, +5.550072e+00+2.470833e+01i, -3.044377e+01+6.291970e+00i, +3.343809e+00-1.431837e+01i, +1.310975e+00+4.977399e+00i },
{ -2.949080e+00-1.344196e+00i, +4.376714e+00-6.273290e+00i, +4.471680e+00+3.465980e+00i, -2.518945e+00+9.052983e-01i, +5.333683e-01-4.904277e-01i },
},
{
{ -1.375504e+00-1.066026e+01i, +1.562530e+01-3.646444e+00i, -2.336599e+00+5.636699e+00i, +9.862099e-01-5.367084e+00i, +2.685801e+00+1.010622e+00i },
{ -2.573104e+01-7.482385e+00i, +3.644475e+00-7.392436e+01i, +3.979344e+01-1.334274e+01i, -1.041617e+01+9.721560e+00i, +1.775229e+00-7.029906e+00i },
{ -4.938310e+00+9.749639e+00i, -3.839004e+01-2.801782e+01i, +8.112406e+00-4.093526e+01i, +9.584785e+00+1.122038e+01i, -5.447492e+00-1.458498e+00i },
{ +3.543049e+00-6.140654e+00i, +3.049754e+00+1.552352e+01i, -1.641948e+01+3.091794e+00i, +3.440673e+00-7.311592e+00i, +2.888650e-01+3.057569e+00i },
{ -2.150415e+00-1.498856e+00i, +3.598853e+00-4.056583e+00i, +2.656792e+00+2.570791e+00i, -1.718766e+00+2.195355e-01i, +3.987230e-01-2.381824e-01i },
},
{
{ +4.690667e-01-1.859052e+00i, +5.709732e+00+2.822349e+00i, -2.246203e+00+2.738592e+00i, -1.175353e+00-1.358679e+00i, +5.280439e-01+1.825497e-01i },
{ -5.350863e+00+2.786243e+00i, -9.721978e-01-9.250168e+00i, +6.987872e+00+1.100749e+00i, -3.295869e+00+3.575106e+00i, +4.250135e-01-1.704687e+00i },
{ +3.597151e-01+7.350941e+00i, -1.156232e+01+1.703486e-01i, +2.095711e+00-6.856939e+00i, +2.130910e+00+3.574262e+00i, -1.212895e+00-8.033188e-01i },
{ +1.477836e+00-3.969034e-01i, +2.120623e-01+3.788635e+00i, -2.645324e+00-1.223827e-01i, +1.008042e+00-1.168240e+00i, -1.080002e-01+5.091328e-01i },
{ -4.754014e-01-8.191554e-02i, +2.616270e-01-6.674782e-01i, +3.439563e-01+3.008507e-01i, -2.514981e-01+6.561860e-03i, +7.089787e-02-3.462702e-02i },
},
{
{ +6.696607e-02-4.012343e-01i, +4.203445e-01-1.198887e-01i, +1.909744e-01+2.395862e-01i, +6.163134e-02-7.244996e-02i, +5.812790e-02+1.232883e-02i },
{ +1.398493e-01-2.816651e-01i, +1.573107e-01-1.381913e+00i, +1.205120e+00-5.453314e-01i, +8.023791e-03+2.393403e-01i, +2.342698e-02-1.723744e-01i },
{ +7.313488e-01-3.227795e-01i, +5.924131e-02-4.343269e-01i, +4.737475e-01-8.380901e-01i, +2.439398e-01+2.179549e-01i, -1.197742e-01-7.666570e-02i },
{ +1.376510e-01-4.397192e-01i, +3.966326e-01-4.617983e-02i, -9.679882e-02+6.678700e-04i, +5.346785e-02-9.350207e-02i, -1.225683e-02+4.339150e-02i },
{ -4.617754e-02-2.078991e-04i, +1.252806e-03-6.500810e-02i, +2.229201e-02+1.958468e-02i, -2.297871e-02+7.341266e-03i, +4.447017e-03-2.349537e-03i },
}
},
{// coil28
{
{ -1.361972e+01+3.183483e+00i, -1.374171e+00+3.077550e+01i, +1.946272e+01+1.516279e-01i, -3.037061e+00-8.814260e+00i, -7.003078e-01+1.459685e+00i },
{ -1.077969e+01+1.792120e+01i, +1.287043e+01+1.943219e+01i, +5.670538e+00-6.689598e+00i, -3.610259e+00+1.455206e+00i, +6.312451e-01-9.127671e-02i },
{ +1.825871e+00+8.387224e+00i, +7.762005e+00-5.429820e-01i, +3.935832e-01-1.409407e+00i, +1.065681e+00-2.660740e-01i, -2.777889e-01-5.415497e-01i },
{ +8.094847e-01+1.832330e-01i, +1.180622e+00-1.934409e+00i, -6.162328e-01+8.166794e-01i, -1.005366e+00-1.979112e-01i, +1.194218e-02+2.398527e-01i },
{ +1.155731e-01-1.794275e-01i, -3.228127e-01-8.005532e-01i, +4.589486e-01+5.254332e-01i, +3.896705e-01+9.810817e-02i, +2.036965e-02-8.370935e-02i },
},
{
{ -8.895365e+00-1.676661e+01i, -5.707697e+01+2.542109e+00i, -1.329909e+01+2.734582e+01i, +7.837839e+00-9.416678e-01i, -1.303486e+00+8.800092e-02i },
{ -2.057319e+01-1.011923e+01i, -4.908767e+01+4.029631e+00i, -1.251659e+01+1.597304e+01i, +5.167287e+00+1.320835e+00i, -4.930725e-01-1.292707e+00i },
{ -2.409244e+00+9.730706e-01i, -6.781414e+00-1.340716e-01i, -2.850725e+00+3.332734e-01i, +3.385691e+00-4.878651e-01i, -1.350190e+00-6.682535e-01i },
{ +4.235128e-01+6.715777e-01i, -3.071560e-01+2.468788e+00i, -1.815068e+00+2.465005e-01i, +3.187111e-01-1.134022e+00i, -2.491189e-01+5.318832e-01i },
{ +4.990864e-01+7.468614e-02i, +8.043944e-01-6.561819e-01i, +8.147992e-02+1.879424e-01i, +6.045851e-02-2.361169e-02i, +2.276426e-02-6.332128e-02i },
},
{
{ +4.433149e+00+2.753436e+00i, +3.706398e+00-2.266184e+01i, -1.743864e+01-1.631253e+01i, -4.117407e+00+7.048657e+00i, +1.794271e+00-6.439058e-01i },
{ +5.991450e+00-4.041966e+00i, -1.071752e+00-3.509599e+01i, -2.165854e+01-1.129257e+01i, -7.273840e-01+8.747463e+00i, +1.799213e+00-2.638305e+00i },
{ +3.792671e+00-1.182449e+00i, +2.710873e-01-1.492536e+01i, -6.544063e+00-2.091220e+00i, +2.180769e+00+3.255939e+00i, -7.533013e-01-1.410915e+00i },
{ +3.797048e-02-1.297766e+00i, -2.242116e+00-1.508987e-01i, -2.016761e+00+3.417945e-01i, +1.265754e+00-5.374913e-01i, -3.110206e-01+3.123320e-01i },
{ +9.438495e-02-1.196862e-01i, +5.635572e-01+3.159327e-01i, +5.333040e-02+4.081885e-01i, -9.546515e-02-2.755371e-01i, -3.430696e-03-9.331451e-03i },
},
{
{ -6.642371e+00+2.203997e+00i, +7.430927e+00+1.318499e+01i, +1.026113e+01-6.177389e+00i, -3.651843e+00-2.010870e+00i, +1.038629e+00+7.441818e-01i },
{ -6.006657e+00+5.469338e+00i, +1.286645e+01+9.768490e+00i, +5.452323e+00-8.817066e+00i, -4.821367e+00+4.925143e-01i, +1.642365e+00-2.735054e-02i },
{ -1.706464e+00+4.932019e+00i, +7.197270e+00+6.554410e-01i, -3.144884e-01-2.804629e+00i, -1.333125e+00+1.801072e+00i, +4.366623e-01-5.468350e-01i },
{ +4.273213e-01+2.843414e-01i, +9.336108e-01-1.522391e+00i, -5.825738e-01-2.133811e-01i, +2.851803e-01+2.796858e-01i, -3.717147e-02-4.911575e-02i },
{ -3.069146e-02-1.148646e-01i, -1.666640e-01-6.505701e-02i, -1.286237e-01+2.496077e-01i, +2.555740e-02-3.859377e-02i, -5.476071e-03-1.124215e-02i },
},
{
{ +2.994103e-01-2.201279e+00i, -3.296450e+00-1.518945e+00i, -1.181898e+00+1.209149e+00i, +1.808878e-01+4.202943e-02i, -3.551877e-02+1.025093e-01i },
{ -9.105030e-01-2.983361e+00i, -4.180439e+00-6.015037e-01i, -4.237386e-01+1.221332e+00i, +1.457386e-01-1.911972e-01i, +3.531530e-02+1.293723e-01i },
{ -9.607210e-01-7.558273e-01i, -1.107103e+00+4.337751e-01i, +1.006392e-01-6.642199e-02i, -6.565125e-02-8.982763e-02i, +5.341972e-02+2.218214e-02i },
{ -9.404263e-02+1.345825e-01i, +1.153886e-01+1.808996e-01i, -8.018929e-02-9.303296e-02i, -1.418595e-02+7.409327e-03i, +9.742203e-03-5.911051e-03i },
{ +1.290915e-02+8.256159e-03i, +2.153650e-02-1.181729e-02i, -1.776130e-02-5.134830e-03i, -3.235580e-03-1.479256e-03i, +4.594686e-05-1.750777e-03i },
}
},
{// coil29
{
{ +1.704134e+01-7.213960e-01i, +6.092620e+00-2.286185e+01i, -6.483714e+00-3.204356e+00i, +7.550223e-01-6.744480e-02i, -1.313512e+00+4.548820e-01i },
{ +2.034035e+01+1.495621e+00i, +1.407146e+01-2.408387e+01i, -7.397111e+00-8.953259e+00i, -1.851457e+00+1.724852e+00i, +9.476212e-02+7.583516e-01i },
{ +6.375120e+00-4.307145e-01i, +3.190554e+00-8.580759e+00i, -2.910668e+00-4.476684e-01i, -1.849154e-02-5.083640e-01i, +5.010764e-02+1.741030e-01i },
{ +3.244808e-02-1.091661e+00i, +6.017252e-01-1.042853e+00i, -2.280914e-01+8.293217e-01i, -5.308995e-01-5.845189e-01i, -7.304668e-02+2.680199e-01i },
{ +3.029311e-02-5.988091e-03i, +5.057190e-02-2.475061e-01i, +3.090887e-02+4.616670e-01i, +1.559300e-01+1.469890e-01i, +5.435196e-02-3.313093e-02i },
},
{
{ +3.310335e+00+2.097482e+01i, +3.450684e+01+2.550455e+01i, +1.967469e+01-2.144501e+00i, -1.815343e+00-4.117115e+00i, -1.155587e+00+5.117800e-01i },
{ +3.366495e+00+2.383130e+01i, +3.273717e+01+2.963208e+01i, +2.091411e+01-2.193077e+00i, -1.912826e+00-3.631864e+00i, -2.119912e-01+1.423128e+00i },
{ +5.230957e-01+4.351577e+00i, +1.595649e+00+1.666931e+00i, +1.477444e+00+3.305264e-01i, +1.427743e+00-2.278805e+00i, -5.381421e-01+1.050737e-01i },
{ +7.014037e-01-3.177139e-01i, +1.671814e-01-1.267960e-01i, -8.138437e-01+2.197561e-01i, +1.164104e-01-6.140519e-01i, -3.894814e-01+3.137173e-01i },
{ -1.008109e-01+9.125885e-02i, -2.392640e-01-1.438145e-01i, -3.958105e-01+1.326106e-01i, +2.284136e-01+1.005775e-01i, +7.983907e-02-2.052120e-02i },
},
{
{ -7.539376e+00-7.910652e-01i, -1.203500e+01+2.064726e+01i, +7.083292e+00+1.529933e+01i, +3.716529e+00-3.183692e+00i, -1.088457e+00+2.886578e-01i },
{ -6.371091e+00-1.123845e+00i, -1.491755e+01+1.564603e+01i, +8.432193e-01+1.639919e+01i, +3.629084e+00-2.118186e+00i, -1.125701e+00+2.438852e-01i },
{ -1.226633e-01-3.424364e+00i, -5.120850e+00-3.074957e+00i, -3.286330e+00+6.532203e+00i, +2.994310e+00+1.231995e+00i, -6.342280e-01-4.242618e-01i },
{ +1.621706e-01-1.855038e-01i, -5.323541e-01+4.201501e-01i, -3.712889e-01-6.872915e-02i, +1.039542e+00-3.126940e-01i, -2.921604e-01+5.092463e-02i },
{ -1.052457e-02+3.648550e-02i, +2.773397e-02+3.141044e-01i, -5.981365e-01+5.712729e-02i, -7.082329e-02+1.963474e-02i, +3.295812e-02+1.683623e-02i },
},
{
{ +5.520826e+00-1.898286e+00i, -2.084512e+00-1.098466e+01i, -5.073786e+00+5.500358e-01i, +2.085786e+00+9.343473e-01i, -4.469974e-01-3.666904e-01i },
{ +6.396822e+00+1.191186e+00i, +3.757272e+00-1.244806e+01i, -8.245362e+00-3.731623e+00i, +3.560068e-01+1.421096e+00i, -3.019153e-01-7.341937e-01i },
{ +2.884091e+00+1.370087e+00i, +4.365146e+00-3.901904e+00i, -3.640262e+00-4.380161e-01i, -1.233667e-01+1.743713e+00i, -3.511328e-02-4.222154e-01i },
{ +8.993840e-02-1.529541e-01i, +3.204599e-01-5.812477e-01i, -3.377029e-02-8.408895e-02i, +3.032406e-01+8.089961e-02i, -3.353261e-02-3.409882e-02i },
{ -3.281431e-02+1.324859e-02i, +2.433737e-02+1.618260e-01i, -1.885526e-01+7.488251e-02i, -8.433449e-02+9.325242e-03i, +3.968880e-03+8.053084e-03i },
},
{
{ -9.790522e-01+1.468227e+00i, +1.210353e+00+2.532949e+00i, +1.131566e+00+2.958733e-01i, -3.426737e-02-5.040005e-02i, +2.728717e-02-3.958577e-02i },
{ -1.905056e+00+1.844373e+00i, +1.085926e+00+3.636285e+00i, +1.398398e+00+3.136788e-01i, -1.515042e-01+2.891648e-02i, +8.225782e-02-4.381790e-02i },
{ -9.092610e-01+6.700537e-01i, +5.386294e-02+1.298898e+00i, +3.512858e-01+4.884160e-02i, -1.227899e-02+1.005739e-01i, +4.515728e-02-3.012147e-02i },
{ -2.918322e-02+5.077587e-02i, -1.482350e-02+4.944920e-02i, +1.762142e-02-5.959804e-02i, +4.088538e-02-9.141708e-03i, +2.602736e-04-5.259372e-03i },
{ -8.916251e-03+2.156504e-03i, -1.607238e-02+1.496162e-02i, -1.912440e-02+5.633116e-04i, -5.518510e-03-2.695477e-03i, +2.603838e-04+6.999059e-04i },
}
},
{// coil30
{
{ -1.149613e+01-2.237514e+00i, -9.226242e+00-2.502486e+01i, +1.193784e+01-1.874612e+01i, +1.012790e+01+1.572096e+00i, +8.232825e-01+8.683922e-01i },
{ -7.484642e+00+6.855307e+00i, -3.031741e+01-1.007705e+01i, -3.028017e+01-2.904985e+01i, -4.429600e+00-1.554100e+01i, +1.630998e+00-2.285951e+00i },
{ +4.602618e-01+1.016089e+00i, +4.009912e+00+1.076320e+01i, -1.393628e+01+2.017044e+01i, -1.371983e+01+4.401381e+00i, -9.994996e-01-6.501182e-01i },
{ -1.126240e+00-7.699059e-01i, +5.159571e+00-2.578084e+00i, +9.028933e+00+2.708575e+00i, +3.186312e+00+3.123086e+00i, +3.968825e-01+6.651284e-01i },
{ +3.328571e-01-7.963457e-01i, +2.120027e-01-2.746989e-01i, -1.451349e+00-2.572358e-01i, -9.221064e-01-8.792825e-01i, -2.289938e-02-1.916075e-01i },
},
{
{ -2.202063e+00-7.205636e+00i, +1.721861e+01-9.362895e+00i, +1.893994e+01+1.344204e+01i, -2.320298e+00+1.330331e+01i, -1.216031e+00+1.526833e+00i },
{ +4.211174e+00-7.992134e+00i, +3.623183e+01-4.839433e+01i, +5.134527e+01-4.414651e+01i, +2.068805e+01-1.668845e+00i, +3.021570e+00+7.177714e-01i },
{ +2.475176e+00-2.415001e+00i, +8.973483e-01-2.251367e+01i, -1.099729e+01-3.993947e+01i, -2.435145e+00-1.616552e+01i, +3.113158e-01-1.769320e+00i },
{ -1.144739e+00+2.555575e+00i, -5.483949e+00+6.956036e+00i, -9.730225e+00+7.076646e+00i, -3.900620e+00+2.323965e+00i, -5.528691e-01+6.020346e-01i },
{ +1.747231e+00-6.926646e-01i, +2.915863e+00-6.163130e-01i, +1.928961e+00-1.023727e+00i, +8.049836e-01-8.081863e-01i, +1.661632e-01-1.030860e-01i },
},
{
{ -2.721926e+00+2.368972e+00i, -1.588190e+00+1.072876e+01i, -9.020000e+00+5.427148e+00i, -9.209208e+00-3.066432e+00i, -6.358222e-01-8.101552e-01i },
{ +1.105507e+01+6.979340e+00i, +4.339945e+01+1.867043e+01i, +2.826575e+01+2.726551e+01i, -3.660651e+00+1.386104e+01i, -2.383920e-01+1.478683e+00i },
{ +6.608297e+00-7.567466e+00i, +2.855870e+01-1.916759e+01i, +3.134520e+01-1.299084e+01i, +1.051613e+01+1.118408e+00i, +1.150003e+00+5.774493e-01i },
{ -4.138106e+00-7.525518e-01i, -9.981355e+00-4.533699e+00i, -7.805009e+00-8.537878e+00i, -8.068821e-01-3.935249e+00i, -1.409678e-01-1.810738e-01i },
{ +1.768316e+00+7.219427e-01i, +2.602310e+00+2.524244e+00i, +1.104504e+00+2.560971e+00i, +1.732850e-01+8.575880e-01i, +1.808857e-02+1.220811e-01i },
},
{
{ -2.473074e+00-3.735938e+00i, +9.911968e-01-6.944571e+00i, +5.714560e+00-7.254020e+00i, +3.588583e+00-3.421146e+00i, +6.440055e-01-2.730388e-01i },
{ -6.511363e+00+3.261826e+00i, -1.349829e+01+1.930014e+00i, -1.563207e+01-4.392628e+00i, -6.690504e+00-4.739923e+00i, -2.749032e-01-5.438617e-01i },
{ +2.160037e+00+9.517126e-01i, +4.419482e+00+9.119849e+00i, -1.584233e+00+1.345975e+01i, -2.599059e+00+4.356386e+00i, -1.375823e-01+5.580091e-01i },
{ -7.320452e-01-2.587198e+00i, +2.510434e+00-4.274755e+00i, +4.070534e+00-2.182208e+00i, +1.707124e+00-6.172814e-01i, +2.356208e-01+2.775940e-02i },
{ -5.299538e-02+7.512111e-01i, -9.983633e-01+1.405359e+00i, -1.546234e+00+9.273692e-01i, -6.179582e-01+1.693984e-01i, -6.632976e-02+1.521931e-02i },
},
{
{ +1.281931e+00+1.168312e-01i, +2.649009e+00+1.889658e+00i, +1.319548e+00+2.421523e+00i, +5.979359e-03+7.867239e-01i, -2.813975e-02+8.033919e-02i },
{ +9.464490e-01-9.924040e-01i, +3.865401e+00-2.368878e+00i, +4.006311e+00-1.116580e+00i, +1.114336e+00+2.095711e-01i, +9.501087e-02+4.848700e-02i },
{ +4.077320e-02+1.107979e-01i, -3.870904e-01-1.054703e+00i, +9.764725e-03-1.812662e+00i, +3.347217e-01-4.774545e-01i, +2.219577e-02-2.095283e-02i },
{ +1.922986e-01+3.012296e-02i, +1.269672e-01+2.323254e-01i, -1.306606e-01+3.286262e-02i, -5.514288e-03-7.575409e-02i, -2.448857e-03+5.981067e-03i },
{ -6.808974e-02+1.592602e-02i, -1.745985e-01-8.986820e-02i, -1.138397e-01-1.292760e-01i, -2.114766e-02-3.729421e-02i, -2.202570e-03-3.493391e-03i },
}
},
{// coil31
{
{ -6.181376e+00-6.442107e+00i, +1.418801e+01-1.337653e+01i, +1.244113e+01+3.031799e+00i, -3.368592e+00+2.629352e+00i, +1.077795e+00-1.911195e+00i },
{ -8.722454e+00-6.232338e-01i, -2.315337e+00-3.382303e+01i, +2.398277e+01-2.600135e+01i, +3.799372e+00+5.867695e+00i, -2.015617e+00-8.231159e-01i },
{ +8.370867e-01+2.273607e+00i, -1.712024e+01+3.771991e+00i, -1.246434e+01-2.171780e+01i, +7.890578e+00-4.989812e+00i, -9.114668e-01+2.371071e+00i },
{ +2.403637e+00-2.086815e+00i, +1.589964e+00+9.108582e+00i, -9.755024e+00+4.223414e+00i, -1.062665e+00-4.062881e+00i, +4.040267e-01+7.009681e-01i },
{ +4.378331e-02-3.851837e-01i, +1.335735e+00-3.303258e-01i, +7.976391e-01+8.021798e-01i, -1.515664e-01+3.572964e-01i, +4.978838e-02+8.564318e-02i },
},
{
{ +4.873144e+00-6.745986e+00i, +1.458176e+01-6.109730e+00i, -3.261788e+00+2.766232e+00i, -2.831890e+00-3.674640e+00i, +2.322161e+00-8.027715e-01i },
{ +8.582943e+00-4.477063e+00i, +3.975443e+01-1.233077e+01i, +2.759942e+01+1.773582e+01i, -9.819885e+00+9.514932e+00i, -5.677419e-01-2.784512e+00i },
{ +1.374833e+00+1.574195e+00i, +8.907182e+00-1.055537e+01i, +3.236713e+01-9.093836e+00i, +9.267535e+00+1.113896e+01i, -2.404191e+00+1.803630e-01i },
{ -8.555548e-01+2.390497e+00i, -1.045749e+01-2.766412e+00i, -2.723795e+00-1.371191e+01i, +4.917150e+00-3.067556e+00i, -5.543228e-01+5.750723e-01i },
{ +1.069525e+00+7.831300e-01i, +7.335810e-02+2.576392e+00i, -1.001997e+00+1.590721e+00i, -3.626209e-01+3.425810e-01i, -3.335831e-02+1.301832e-01i },
},
{
{ -4.712717e+00-2.797312e+00i, -5.153175e+00-4.227438e+00i, +6.597943e-01-8.457498e+00i, +1.851682e+00-3.108181e+00i, +1.192284e+00+1.096477e+00i },
{ +3.768921e-01+9.051467e+00i, -9.095976e+00+2.175773e+01i, -1.767294e+01+1.089097e+01i, -5.877405e+00-5.172504e+00i, +1.429656e+00-5.541516e-01i },
{ +8.713878e+00-2.147722e+00i, +1.717572e+01+2.009698e+01i, +2.883811e+00+2.397555e+01i, -4.614714e+00+3.307688e+00i, -6.323113e-01-7.588776e-01i },
{ -1.808058e+00-4.687870e+00i, +5.706738e+00-7.990753e+00i, +7.384630e+00-1.002079e+00i, +1.371606e+00+1.566846e+00i, -5.272130e-01+1.634573e-01i },
{ -1.129508e-03+1.202879e+00i, -1.706143e+00+1.366960e+00i, -1.084946e+00+3.923833e-03i, +8.245736e-03-8.960466e-02i, -1.437459e-02+5.979729e-02i },
},
{
{ -6.863934e-01-4.118520e+00i, +5.232568e+00-3.228896e-01i, +4.422941e+00+3.333133e+00i, -1.025777e+00+1.010959e+00i, +7.806787e-02+2.699102e-01i },
{ -5.964965e+00-5.703554e-01i, -5.718188e+00-1.006590e+01i, +4.968691e+00-8.616808e+00i, +2.904890e+00-2.700007e-01i, +1.700048e-01+2.970984e-01i },
{ +2.040468e+00+2.624236e+00i, -7.941904e+00+5.782761e+00i, -9.246861e+00-4.435450e+00i, +6.305560e-01-3.288195e+00i, -4.853013e-02+1.743955e-01i },
{ +1.754810e+00-2.223654e+00i, +4.013915e+00+2.767018e+00i, -1.524315e+00+3.715739e+00i, -8.405511e-01-1.921527e-01i, -4.474942e-02+1.349142e-01i },
{ -5.210897e-01+1.120280e-01i, -5.533782e-01-7.355798e-01i, +1.778974e-01-6.110799e-01i, +1.517855e-01-7.845603e-02i, +1.703236e-02+1.051377e-02i },
},
{
{ +7.586148e-01+3.252085e-01i, -4.270792e-01+1.889989e+00i, -1.671259e+00+9.692253e-01i, -3.539012e-01-1.787046e-01i, +2.378331e-02+8.302947e-03i },
{ +7.941902e-01-2.127820e-01i, +2.625183e+00+1.721769e+00i, +9.854403e-01+2.980274e+00i, -4.424893e-01+6.282016e-01i, -1.587720e-03-1.694055e-02i },
{ -5.398071e-02+1.032850e-01i, +9.141960e-01-5.850917e-01i, +1.764302e+00+5.473795e-02i, +2.681396e-01+4.742079e-01i, -3.555273e-02-7.840147e-03i },
{ +7.258233e-02+8.593415e-02i, -1.363792e-01+2.308910e-02i, +2.809489e-02-2.514399e-01i, +1.226312e-01-7.590987e-04i, -1.506789e-02+9.909196e-03i },
{ -3.900044e-02-1.928071e-02i, +2.852484e-02-1.086830e-01i, +8.770593e-02-5.354119e-02i, +2.216529e-02+3.476893e-03i, +9.950862e-04+1.212877e-03i },
}
},
{// coil32
{
{ +2.711881e+01+8.883787e+00i, +1.565095e+01-9.778954e+00i, -3.822884e+00-6.189623e+00i, -8.663177e-02-7.068205e-02i, -7.761822e-01+1.398605e-01i },
{ -1.165321e+01+4.196893e+01i, +1.639801e+01+4.070692e+01i, +1.217315e+01+6.071260e+00i, +1.200375e+00+6.663787e-01i, +2.559357e-01-7.620985e-01i },
{ -1.684039e+01-8.379351e+00i, -1.725387e+01+8.368245e+00i, -6.623831e-01+7.418287e+00i, +1.236990e-01+3.310647e-01i, +3.001194e-01-7.329732e-02i },
{ +7.515197e+00+6.942161e-01i, +3.309343e+00-5.930458e+00i, -2.869964e-01-4.547329e+00i, +1.078491e-01+2.310370e-01i, -2.559829e-01-1.321063e-01i },
{ -3.155388e+00+1.590817e-01i, -2.564965e+00+2.518868e+00i, +1.653206e-01+1.205371e+00i, +1.668864e-01+1.413687e-01i, +1.395447e-02-1.814796e-02i },
},
{
{ +4.552943e+01+5.082224e+01i, +3.644152e+01+2.289165e+01i, +7.232246e-01-1.870245e+00i, +5.395131e-01+4.065685e-01i, -1.344949e+00-8.617038e-02i },
{ -6.080050e+01+8.961455e+01i, -2.322175e+01+1.051284e+02i, +8.651577e+00+2.191383e+01i, +1.642780e+00+1.809178e+00i, +5.156480e-01-1.580450e+00i },
{ -2.504355e+01-2.319225e+01i, -3.676255e+01+7.585498e+00i, -6.921639e+00+1.098551e+01i, -6.231992e-01-3.685570e-02i, +4.419513e-01+2.537972e-02i },
{ +1.325721e+01+8.596334e+00i, +1.018882e+01+2.370129e-01i, +8.142400e-01-3.025769e+00i, -1.402411e-01+1.066115e-01i, -2.678165e-01-3.821775e-02i },
{ -6.652255e+00-3.371721e+00i, -6.147513e+00+8.093807e-01i, -5.609272e-01+1.453800e+00i, +1.563725e-01+9.090662e-03i, +6.327012e-02+3.810182e-03i },
},
{
{ +2.113259e+01+2.898579e+01i, +2.128130e+01+1.516039e+01i, +4.757833e+00-2.172050e-01i, +5.353402e-01+6.915259e-02i, -6.967584e-01-5.537443e-03i },
{ -4.034258e+01+3.612418e+01i, -2.280916e+01+5.340222e+01i, +4.476326e+00+1.085088e+01i, +1.597775e+00-2.490950e-02i, +9.906003e-02-5.608847e-01i },
{ -4.126872e+00-1.779281e+01i, -1.713518e+01-4.277667e+00i, -6.380977e+00+9.443436e-01i, -7.360601e-01-3.897576e-01i, +1.319095e-01+1.659795e-01i },
{ +6.813272e+00+9.559161e+00i, +8.517053e+00+3.670784e+00i, +1.952803e+00-1.936884e-01i, -5.634484e-01+2.647794e-01i, +2.079576e-02-2.158652e-02i },
{ -4.363114e+00-3.173152e+00i, -4.306513e+00-8.233268e-01i, -6.991372e-01+6.513677e-01i, -1.832157e-02-6.210697e-02i, +6.546921e-02-7.979274e-04i },
},
{
{ +3.190073e+00+1.181329e+00i, +3.823653e+00-1.310728e+00i, +4.978714e-01-5.262063e-01i, -1.264347e-01+1.598763e-02i, -9.974922e-02+6.477185e-02i },
{ -2.571511e+00+9.512414e-01i, +1.301908e-01+5.390606e+00i, +9.697336e-01+1.717031e+00i, +2.713895e-01-2.528355e-02i, -5.109967e-02+5.678558e-02i },
{ +1.838314e+00-3.337933e+00i, -1.959475e+00-2.908582e+00i, -1.291520e+00-1.309707e+00i, +1.176757e-02+1.034085e-01i, +9.726027e-03+3.552814e-02i },
{ +9.906830e-01+1.833438e+00i, +1.506379e+00-5.808145e-01i, +5.023801e-01-8.145071e-01i, -2.333771e-01+1.098847e-01i, +3.165109e-02-3.974510e-02i },
{ -7.075174e-01-3.942579e-01i, -7.041039e-01+8.781938e-02i, -8.103395e-02+2.180127e-01i, -1.357278e-03-3.451243e-03i, +1.782437e-02-7.875923e-03i },
},
{
{ +6.083199e-02+3.859420e-01i, +2.795817e-01+7.670309e-02i, -1.536161e-03-1.782465e-01i, -4.908339e-02-3.049353e-02i, +1.721814e-03+6.419825e-03i },
{ -1.030068e+00+6.538064e-01i, -7.183127e-01+1.249043e+00i, -2.630150e-01+2.386963e-01i, -4.021285e-02-5.876109e-02i, +1.579449e-03+3.130066e-03i },
{ -5.329799e-01-2.429433e-01i, -9.040582e-01+2.372651e-01i, -3.772006e-01+2.448495e-01i, -6.843887e-03+2.544362e-02i, +2.817060e-03+3.997009e-03i },
{ +2.334231e-02+6.044551e-02i, +5.801078e-02-6.394689e-03i, +3.307028e-03+4.590463e-02i, -3.014772e-02+2.184470e-02i, +2.075577e-03-1.341866e-03i },
{ -5.622721e-02-3.470007e-02i, -6.137530e-02+2.458508e-02i, -1.233035e-02+3.019547e-02i, -4.457652e-04-3.029048e-03i, +1.393386e-03-1.008826e-03i },
}
},
{// coil33
{
{ +1.626340e+01+2.562980e+01i, +2.505341e+01-7.230628e+00i, -7.234642e+00-5.321447e+00i, +1.457803e+00+1.952784e+00i, -1.613270e+00-5.062364e-01i },
{ -2.092639e+01+2.762470e+01i, +1.965093e+01+4.406636e+01i, +1.489142e+01-1.686639e+00i, -1.383931e+00-1.001749e-01i, +5.638674e-01-1.065589e+00i },
{ -8.123610e+00-8.325977e+00i, -1.523890e+01+1.110110e+01i, +4.004427e+00+8.044918e+00i, +1.380020e+00-1.786254e+00i, +5.413815e-02+3.477998e-01i },
{ +4.112968e+00+6.763738e-01i, +1.165317e+00-4.315610e+00i, -2.480111e+00-2.516421e+00i, +4.523271e-01+9.512030e-01i, -3.163440e-01-1.103544e-01i },
{ -7.023358e-01-4.530070e-01i, -1.679122e+00+1.620047e+00i, +5.463965e-01+5.326048e-01i, +1.085311e-01-2.486930e-01i, -5.554635e-03+4.704899e-02i },
},
{
{ +1.814859e+01+6.397851e+01i, +4.319289e+01+1.865197e+01i, -4.107067e+00-4.494205e+00i, +2.839649e+00+2.939565e+00i, -2.529682e+00-1.129356e+00i },
{ -5.071041e+01+4.497882e+01i, -4.628357e+00+8.737790e+01i, +1.803640e+01+1.341820e+01i, +1.446041e-01+7.420807e-01i, +9.211456e-01-1.740460e+00i },
{ -3.439312e+00-1.542802e+01i, -2.298016e+01+6.710779e+00i, -1.584975e+00+1.564303e+01i, +1.649538e+00-1.965775e+00i, +7.589459e-04+4.315801e-01i },
{ +2.851192e+00+6.048988e+00i, +6.671274e+00-1.160141e+00i, -2.071566e+00-2.359049e+00i, -1.614368e-01+1.305164e+00i, -1.863026e-01-2.230716e-01i },
{ -1.027541e+00-3.144588e+00i, -3.395770e+00+1.849031e-01i, +4.324507e-01+7.996410e-01i, +1.034377e-01-4.569675e-01i, +5.623888e-03+1.035206e-01i },
},
{
{ -1.913672e+00+3.311721e+01i, +2.400745e+01+1.785300e+01i, +2.959296e+00-6.351391e+00i, -2.768846e-01+1.397154e+00i, -6.627979e-01-6.678023e-01i },
{ -3.059002e+01+5.623693e+00i, -1.621091e+01+4.260406e+01i, +1.252215e+01+7.725339e+00i, +4.913801e-01-1.981007e+00i, +6.502253e-01-2.526904e-01i },
{ +8.549233e+00-9.698527e+00i, -1.044450e+01-5.506458e+00i, -4.680893e+00+6.836492e+00i, +5.910803e-01-9.680231e-01i, -2.271057e-01+3.262999e-01i },
{ -4.284837e-01+7.513934e+00i, +6.188131e+00+1.573385e+00i, +4.397723e-02-1.084739e+00i, -7.602712e-01+1.047943e+00i, +9.917213e-02-2.570581e-01i },
{ -6.532390e-01-2.481421e+00i, -2.328342e+00-9.891669e-01i, -1.265711e-02+4.232607e-01i, +2.768824e-02-2.144727e-01i, +1.324730e-02+5.444220e-02i },
},
{
{ -2.874836e+00+3.115180e+00i, +4.669125e+00+3.359652e+00i, +1.211578e+00-1.941535e+00i, -7.101535e-01+2.669764e-01i, +1.113725e-01-1.200190e-01i },
{ -4.147654e+00-4.360085e+00i, -4.113061e+00+6.600675e+00i, +3.107121e+00+1.703199e+00i, -1.667587e-01-6.812141e-01i, +1.630145e-01+2.193053e-01i },
{ +3.722049e+00-2.230020e+00i, -3.338700e+00-3.628493e+00i, -1.387582e+00+2.021754e-02i, +3.833570e-01+2.164841e-02i, -1.083576e-01+9.810513e-02i },
{ -1.369577e-03+1.881427e+00i, +1.098968e+00-4.571121e-01i, -7.801583e-02-8.797367e-01i, -2.089229e-01+2.954757e-01i, +3.457570e-02-1.001456e-01i },
{ -8.248788e-02-3.505561e-01i, -4.486839e-01-1.167300e-01i, -1.577493e-02+1.341289e-01i, +1.901206e-02-1.610433e-02i, +4.620671e-03+5.596166e-03i },
},
{
{ -1.176981e-01+4.796605e-01i, +4.449607e-01+3.274176e-02i, -1.050453e-01-4.024228e-01i, -1.028940e-01+2.980450e-02i, +1.141171e-02-1.542487e-02i },
{ -7.232718e-01+4.023314e-04i, -6.699088e-01+7.643717e-01i, +4.335076e-03+1.761607e-01i, -3.775828e-02-6.522734e-02i, +1.501891e-02+1.637905e-02i },
{ -8.733366e-02-2.639771e-01i, -5.725044e-01-1.392618e-01i, -2.002486e-01+2.566841e-01i, +3.618747e-02+7.983882e-03i, -9.425959e-03+4.651166e-03i },
{ -5.810361e-02+9.605335e-02i, +9.671643e-02+2.690231e-02i, +8.729553e-03+1.902916e-02i, -2.839170e-02+2.829142e-02i, +3.556992e-03-9.578203e-03i },
{ -1.427219e-02-4.945404e-02i, -4.772667e-02-8.087674e-03i, -5.676120e-03+2.557799e-02i, +7.925653e-04-1.672842e-03i, +2.835279e-04+7.483934e-04i },
}
},
{// coil34
{
{ -3.871869e+00-1.303919e+01i, -3.254509e+01+2.859533e+01i, +1.904224e+01+3.233330e+01i, +7.077125e+00-1.182485e+01i, -2.291300e+00+2.558595e+00i },
{ -2.130480e+01-1.085497e+01i, -3.130701e+01+5.571183e+01i, +3.325363e+01+2.014412e+01i, -3.413264e+00-1.678152e+01i, -1.074183e+00+5.353675e+00i },
{ -9.699944e+00-6.212755e+00i, -8.344141e+00+1.689804e+01i, +1.043078e+01-1.169850e+00i, -4.840447e+00-3.617432e+00i, +1.292153e+00+2.392383e+00i },
{ -3.019650e+00+4.153770e-01i, +1.193651e+00+3.829939e+00i, +3.432738e+00-1.081746e+00i, -7.713295e-01-5.297675e-01i, +3.647228e-01-9.873871e-02i },
{ -2.547337e-01+8.309101e-01i, +6.790183e-02-1.972042e-01i, -2.218676e-01-5.879122e-01i, -2.022306e-01+3.247324e-01i, +2.549283e-02+1.870121e-02i },
},
{
{ -2.748002e+01+1.553932e+01i, +2.268732e+01+9.507417e+01i, +5.207932e+01-1.892641e+00i, -1.453210e+01-9.627293e+00i, +4.958700e+00+4.412135e+00i },
{ -2.793355e+01+3.900586e+01i, +2.498993e+01+9.426109e+01i, +2.700882e+01+2.190971e-01i, -1.042669e+01-2.274988e+00i, +3.679883e+00+1.521729e+00i },
{ -4.686534e+00+1.335663e+01i, +1.010686e+01+1.593547e+01i, -4.192534e+00-2.987580e+00i, -3.268918e+00+2.195457e+00i, +1.063250e+00+8.397483e-01i },
{ +2.756183e+00+1.973349e+00i, +6.248574e+00-1.430924e+00i, -1.931399e+00-6.522643e-01i, +5.652189e-02+1.709167e-01i, +2.907141e-01+2.532433e-02i },
{ +3.772923e-01-4.567858e-01i, -1.265671e+00-7.745814e-01i, -6.650134e-01+3.617946e-01i, -1.074165e-01-1.649840e-01i, -1.143831e-01+9.375468e-02i },
},
{
{ -5.211673e+00+2.505890e+01i, +4.774042e+01+1.972173e+01i, +1.237267e+00-2.887686e+01i, -1.173645e+01+1.072889e+01i, +5.585119e+00-9.984241e-01i },
{ +1.912997e+01+3.012374e+01i, +3.564637e+01-3.042239e+00i, -8.650024e+00-1.284635e+00i, +7.260616e+00+4.961716e+00i, -5.349227e-01-4.181769e+00i },
{ +1.294428e+01+3.904684e+00i, +5.151449e+00-9.740261e+00i, -1.076757e+00+4.252535e+00i, +2.661738e+00-3.054838e+00i, -2.024133e+00+7.002676e-01i },
{ +2.454506e+00-2.715401e+00i, -2.100446e+00-2.809722e+00i, -1.650964e+00+3.233612e+00i, +9.859114e-01-2.541747e-01i, +2.321962e-01+5.540661e-01i },
{ -1.994811e-01-1.257039e+00i, -1.133690e+00+2.668223e-01i, +5.804778e-01+5.990270e-01i, -2.553492e-01-7.709762e-01i, -1.207202e-01+1.349834e-01i },
},
{
{ +3.977823e+00+2.821058e+00i, +1.982889e+00-1.113335e+01i, -1.079251e+01+7.940438e-01i, +2.777183e+00+5.356685e+00i, +3.510672e-01-1.458223e+00i },
{ +8.752441e+00-4.409058e+00i, -7.682613e+00-1.322989e+01i, -3.598180e+00+9.167888e+00i, +5.816415e+00-2.471266e+00i, -2.076795e+00-7.249103e-01i },
{ +1.345451e+00-5.120782e+00i, -5.965451e+00-2.348351e+00i, +3.559083e+00+2.151217e+00i, -7.581119e-01-3.395461e+00i, -8.127255e-01+1.177140e+00i },
{ -9.713169e-01-8.475242e-01i, -1.596097e+00+1.136549e+00i, +1.051128e+00+7.373767e-01i, -6.095052e-02-2.660155e-01i, +2.506735e-01+2.518076e-01i },
{ -2.311130e-01-1.626124e-01i, +4.850167e-02+3.483602e-01i, +4.139647e-01-1.522280e-01i, -2.280292e-01-2.570705e-01i, -1.134796e-02+4.506647e-02i },
},
{
{ +8.139048e-01+1.325599e+00i, +1.314154e+00-4.488452e-01i, -4.131453e-01-1.455716e-01i, +3.142979e-01+2.998030e-01i, -5.523368e-02-1.775079e-01i },
{ +1.225834e+00+9.045957e-01i, -5.302633e-02+1.747438e-01i, +2.118888e-01+1.211910e+00i, +6.316334e-01-2.237052e-01i, -2.257285e-01+1.007245e-02i },
{ +1.762078e-01+5.650283e-02i, -3.823712e-01+7.110126e-01i, +3.928131e-01+5.231167e-01i, -4.295871e-02-1.998807e-01i, -2.153713e-03+1.566357e-01i },
{ +6.383529e-02-1.735135e-02i, +1.211827e-01+9.392734e-02i, +3.166898e-02+3.484106e-02i, -4.440505e-02+1.778487e-02i, +4.374678e-02+1.500979e-02i },
{ +4.675237e-03-3.658055e-02i, +2.038690e-02-8.428367e-03i, +1.478674e-02-2.651753e-02i, -2.539637e-02-1.432452e-02i, +8.158013e-04+4.060549e-03i },
}
},
{// coil35
{
{ -1.132045e+01-2.367890e+01i, -4.216886e+01+3.837092e+01i, +2.463507e+01+2.498691e+01i, -8.867269e-01-1.290367e+01i, +4.427240e-01+4.129186e+00i },
{ -1.823092e+01-2.466998e+01i, -6.644514e+01+2.973947e+01i, +1.522583e+01+3.813236e+01i, +5.230862e+00-1.369529e+01i, -2.213110e+00+4.437495e+00i },
{ -2.761286e+00-1.595739e+01i, -2.456413e+01-3.489699e-01i, +1.173346e+00+1.351161e+01i, +5.157929e+00-5.348263e+00i, -1.409713e+00+1.591136e+00i },
{ +1.567453e+00-2.556257e+00i, -1.159499e+00+6.112626e-01i, -1.942276e+00+3.363375e+00i, +6.476181e-01-1.293556e+00i, -2.035965e-01+2.504227e-01i },
{ -1.120902e+00-6.055956e-01i, +3.335755e-02-3.524315e-02i, +3.329641e-01+6.211962e-01i, -1.529145e-01+1.408613e-01i, +7.626323e-02+6.042921e-02i },
},
{
{ -4.130765e+01+2.425739e+01i, +8.297468e+00+9.208611e+01i, +2.861436e+01+1.939384e+00i, -1.062910e+01-1.129459e+00i, +4.398194e+00+9.312162e-01i },
{ -5.032162e+01+2.010890e+01i, -3.520167e+01+9.281590e+01i, +2.224976e+01+1.833751e+01i, -6.972879e+00-6.973503e+00i, +1.410562e+00+3.070141e+00i },
{ -1.574853e+01+9.660605e-02i, -1.595839e+01+1.560675e+01i, +5.051561e+00-7.616239e-01i, -1.262065e-01-2.908157e+00i, -9.184606e-01+1.221403e+00i },
{ +8.193421e-02+2.373993e+00i, +2.461642e+00+5.141973e+00i, +3.671420e-01-2.855800e+00i, +1.043637e+00-8.330349e-01i, -5.496460e-01+2.966385e-02i },
{ -9.849726e-01-3.423573e-01i, -2.226550e-01-6.372499e-01i, -6.528175e-01-4.439243e-01i, -2.150475e-01+2.311697e-01i, +4.978560e-02+6.752007e-02i },
},
{
{ +1.220546e+00+3.573225e+01i, +3.778202e+01+1.098409e+01i, -3.746351e+00-9.830849e+00i, +3.697997e+00+6.409879e+00i, -1.154971e-01-3.023140e+00i },
{ +5.618615e+00+3.804533e+01i, +3.459542e+01+1.462498e+01i, -6.790780e+00-5.691525e+00i, +1.772901e+00+2.144718e+00i, -9.496546e-01-1.638919e+00i },
{ +6.158803e+00+1.370388e+01i, +1.585536e+01-2.491124e+00i, -5.978257e+00-8.548040e-01i, +7.876441e-01+4.140908e+00i, -1.205874e+00-5.817716e-01i },
{ +2.301871e+00+2.903724e+00i, +3.099354e+00-1.441654e+00i, -1.654490e+00-3.718598e+00i, +1.874655e+00+9.820464e-01i, -6.143184e-01-1.956194e-01i },
{ +2.818608e-01-1.636118e-03i, -4.210858e-01-1.478815e-01i, -1.560783e+00-1.700535e-01i, -6.938079e-02+1.046860e-01i, -2.450731e-02+1.428901e-02i },
},
{
{ +8.289140e+00+8.150496e-01i, -2.971335e-01-1.251099e+01i, -5.078479e+00+3.831937e+00i, +4.344507e+00-1.356558e-01i, -1.554536e+00-3.879425e-01i },
{ +1.162386e+01-8.836484e-02i, -6.418678e-01-1.511822e+01i, -7.340299e+00+4.328977e+00i, +4.582188e+00-2.003857e+00i, -1.787706e+00-1.282109e-01i },
{ +5.881825e+00-1.029522e+00i, -4.906867e-01-7.094335e+00i, -5.032193e+00+4.519763e+00i, +1.956468e+00-2.544200e-02i, -8.771248e-01-7.055086e-02i },
{ +1.022831e+00-3.866629e-01i, -1.601324e-01-1.266455e+00i, -8.141664e-01+8.487028e-01i, +8.729942e-01+2.085908e-01i, -2.178739e-01-2.424442e-02i },
{ +1.180789e-01-9.487838e-02i, -1.290799e-01+9.410734e-02i, -3.507593e-01+1.615726e-01i, +2.594995e-02-4.512420e-02i, -1.797189e-02-3.131996e-03i },
},
{
{ +2.862714e-01+1.042609e+00i, +2.293266e-01+3.649620e-02i, -4.352887e-01+8.112835e-01i, +3.402947e-01+1.859099e-01i, -1.219361e-01-2.232386e-02i },
{ +6.081316e-01+1.130016e+00i, +4.932392e-02+1.708346e-01i, -1.777173e-01+1.110320e+00i, +3.501180e-01+1.574573e-02i, -1.680760e-01+3.534517e-02i },
{ +1.797312e-01+4.536610e-01i, -2.698740e-01-9.222045e-02i, -4.385778e-02+3.184936e-01i, +1.225984e-01-1.784248e-02i, -1.007305e-01+3.464159e-02i },
{ -5.001992e-03+1.211080e-01i, +2.673427e-03+1.988751e-02i, +3.585424e-02-9.164459e-02i, +5.550153e-02-1.861487e-02i, -2.523334e-02+5.615438e-03i },
{ +2.159517e-03+3.108262e-03i, -2.874367e-03+5.237315e-03i, -1.658865e-02-1.898300e-02i, -2.555761e-03-1.157109e-02i, -2.900458e-03+6.255091e-04i },
}
},
{// coil36
{
{ -5.088356e+00-1.375839e+00i, +3.281334e+00-1.970865e+00i, +8.523615e+00+3.010845e+00i, +1.887453e-01+6.131080e+00i, +2.822119e-01+1.257372e-01i },
{ +1.313954e+00+1.037838e+00i, +9.706934e+00-1.608932e+01i, +1.967676e+01-1.364151e+01i, +8.520294e+00+2.650882e+00i, +2.683746e-01+9.622771e-01i },
{ +7.057874e+00-1.084641e+01i, +9.880318e+00-2.704625e+01i, +5.843512e+00-2.512819e+01i, +7.010389e+00-5.784531e+00i, +1.224114e+00+8.139530e-01i },
{ -2.344930e+00-2.562981e+00i, -3.848333e+00-6.202756e+00i, -6.166162e+00-7.376148e+00i, -3.670594e-01-4.820905e+00i, +4.401116e-01-1.134422e-01i },
{ -2.294437e-01+5.806525e-01i, -6.360793e-01+7.726247e-01i, -1.288101e+00+6.631018e-01i, -7.064292e-01+9.417757e-03i, +3.527915e-03+6.096646e-02i },
},
{
{ +3.886539e+00+1.381254e+01i, -1.610315e+01+5.674885e-02i, -6.065647e+00-1.392623e+01i, +8.888414e+00-2.674132e+00i, +1.432344e+00+3.333877e-01i },
{ +4.129513e+00-3.941702e+00i, -3.523281e+01-2.204902e+01i, -4.210201e+01-3.698719e+01i, -3.907926e+00-1.634642e+01i, +1.429780e-01-1.830343e+00i },
{ -1.175288e+01-1.530284e+01i, -3.860701e+01-1.976892e+01i, -4.390694e+01-8.001887e+00i, -1.097366e+01-2.357700e+00i, -1.384435e+00-5.136932e-01i },
{ +4.998975e-01+1.372380e+00i, -4.610556e+00+1.208977e+01i, -1.032038e+01+1.002197e+01i, -1.884207e+00+5.437068e-01i, -6.440874e-01+3.774373e-01i },
{ +5.950320e-01-1.341893e+00i, +1.973788e+00+1.214537e-01i, -7.212365e-02+2.077321e+00i, -6.841813e-01+5.650508e-01i, -5.213689e-02+1.815210e-01i },
},
{
{ +9.625207e+00+4.002094e+00i, -4.528733e+00+2.057213e+01i, -1.301367e+01+5.438478e+00i, -2.828742e+00-7.947015e+00i, +4.349347e-01+1.027562e-01i },
{ +2.165206e+00-2.988400e+00i, +1.644525e+00+2.065920e+01i, -2.248432e+01+2.907853e+01i, -1.432272e+01+4.650315e+00i, -1.236335e+00-4.716039e-01i },
{ -5.319454e+00+1.954612e+00i, +1.568052e+00+8.395224e+00i, +1.079258e+01+2.380470e+01i, +2.434651e+00+1.450147e+01i, -1.534598e+00+8.925492e-01i },
{ +2.377177e+00-9.931746e-01i, +5.486583e+00+3.739379e-01i, +9.181686e+00-1.641677e+00i, +5.505468e+00+6.607540e-01i, -3.628833e-01+5.578086e-01i },
{ -4.510082e-01-9.822716e-01i, +2.224285e-02-1.139243e+00i, +9.496504e-02-9.559378e-02i, +8.766401e-02+6.012209e-02i, -3.494441e-02+1.134229e-01i },
},
{
{ -1.564827e-01-3.541666e+00i, +6.815814e+00-2.369467e+00i, +7.183671e+00+3.794035e+00i, -8.723118e-01+1.416063e+00i, -5.399007e-02+2.612147e-01i },
{ -7.313919e-01-2.032526e+00i, +4.818274e+00-1.004315e+01i, +1.205448e+01-4.713946e+00i, +4.438429e+00+1.914152e+00i, +1.572006e-01+3.703505e-01i },
{ +2.293054e+00-6.576924e-01i, -2.257077e+00-4.433922e+00i, +1.838649e+00-1.169448e+01i, +4.620819e+00-3.490799e+00i, +6.277965e-02+1.502130e-01i },
{ -2.321415e-01-8.382187e-01i, -2.704437e+00-5.761082e-01i, -3.370955e+00-4.157492e+00i, +1.011445e-01-2.101961e+00i, -1.009521e-01+3.884682e-02i },
{ +1.141879e-02+2.573505e-01i, -4.715487e-01+4.525267e-01i, -5.806181e-01-5.239815e-03i, -5.984091e-02-1.282845e-01i, -1.400585e-02+1.968067e-02i },
},
{
{ -2.838003e-01+6.002066e-01i, -2.642057e+00-5.104138e-01i, -1.625417e+00-1.597033e+00i, +9.363666e-03-5.238236e-01i, +1.046788e-02-3.891451e-02i },
{ -3.359573e-01+1.259940e+00i, -4.739115e+00+3.861420e+00i, -5.356625e+00+1.013419e+00i, -1.288802e+00-6.663847e-01i, -1.148225e-01-7.480760e-02i },
{ +4.053903e-02+4.349694e-01i, -1.644550e-01+4.810031e+00i, -2.412064e+00+4.289607e+00i, -1.344909e+00+6.144089e-01i, -1.429458e-01+7.484987e-02i },
{ +1.963219e-01-1.018777e-01i, +1.340063e+00+9.423944e-01i, +6.115308e-01+1.574183e+00i, -8.901514e-02+5.336875e-01i, -1.591349e-02+7.408920e-02i },
{ +3.300096e-02-6.384431e-02i, +1.748149e-01-3.205277e-02i, +1.429047e-01+7.084602e-02i, +3.358591e-02+3.328727e-02i, +4.664409e-03+6.528753e-03i },
}
},
{// coil37
{
{ -4.866066e-01+2.385887e+00i, -8.324658e+00+2.816023e-01i, -1.555450e+01-2.168756e+00i, -6.771077e+00+3.320599e+00i, -6.394540e-01+1.022132e+00i },
{ -1.093561e+00+2.359542e+00i, -2.411434e+01+1.796810e+01i, -2.056471e+01+2.173316e+01i, -2.292992e+00+8.320695e+00i, +3.262559e-01+8.879550e-01i },
{ -1.001452e+01-1.376805e+00i, -1.578649e+01+1.804176e+01i, -3.194332e-02+2.324417e+01i, +2.034404e+00+5.518975e+00i, +3.518724e-01+3.521557e-01i },
{ -3.743955e+00+1.503202e+00i, +1.845475e+00+2.057892e+00i, +7.366827e+00+1.685105e+00i, +1.894246e+00+7.898990e-01i, +4.284686e-01-9.067175e-02i },
{ +1.146819e-01+7.119221e-01i, -3.257401e-01-1.095135e-01i, -4.968072e-02-8.216601e-01i, -1.244867e-01-2.544426e-01i, -5.850585e-02-1.272753e-01i },
},
{
{ +7.308684e+00-3.205452e-01i, +1.255592e+01+1.596371e+01i, +1.107174e+01+2.194651e+01i, +8.114596e+00+6.768958e+00i, +1.574846e+00+7.254908e-01i },
{ -5.240437e+00+5.127807e+00i, +5.807793e+00+4.826674e+01i, +2.625696e+01+3.447878e+01i, +1.245450e+01-3.473764e+00i, +1.530360e+00-9.588659e-01i },
{ -8.851748e+00+1.612564e+01i, +1.020471e+01+3.693013e+01i, +1.840057e+01+1.068786e+01i, +4.459518e+00-7.571933e+00i, +2.637890e-01+1.474485e-01i },
{ +2.039544e+00+2.837312e+00i, +8.450495e+00-2.293161e+00i, +4.856471e-01-5.540542e+00i, -1.129651e+00-3.496279e+00i, +5.676774e-01+1.049737e-01i },
{ -2.202559e-01+3.187101e-01i, -8.310146e-01+1.587406e-01i, -1.214366e+00+5.774700e-01i, -7.078196e-01+1.922566e-01i, -8.293960e-02-5.467996e-02i },
},
{
{ +1.188166e+00-8.685039e+00i, +8.330611e+00-1.231174e+01i, +1.096579e+01-1.238398e+01i, +2.409039e+00-1.005798e+01i, +2.783020e-01-1.674845e+00i },
{ -4.509985e+00+4.266737e-01i, +3.559653e+00-3.565311e+00i, +2.929007e+00-7.407225e+00i, -9.579940e+00-6.360347e+00i, -1.601371e+00-1.028198e+00i },
{ +5.334937e+00+4.355040e+00i, +7.516603e+00-2.640819e-01i, -1.268977e+00-2.261451e+00i, -4.403216e+00-3.388976e-01i, -2.746852e-01+1.025058e+00i },
{ +1.783622e+00-3.840829e+00i, +1.306179e+00-2.307354e+00i, -5.496869e+00+2.294626e+00i, -2.514192e+00-8.542089e-01i, +4.807771e-01+3.338615e-01i },
{ -6.104079e-01-4.192233e-02i, +3.442011e-01+3.023028e-01i, +6.438469e-01+1.670447e+00i, -1.050511e-02+7.412359e-01i, +4.938453e-02+5.847694e-02i },
},
{
{ -2.902868e+00+5.969940e-01i, -8.596709e+00+3.844070e-01i, -9.868583e+00+7.639266e-01i, -4.910789e+00+1.013894e+00i, -5.380324e-01+3.356751e-02i },
{ -5.919099e-01+2.195716e+00i, -3.487792e+00+3.810663e+00i, -7.889838e-01+1.040895e+01i, -1.156263e+00+7.865263e+00i, -1.227471e-01+6.309196e-01i },
{ -1.197866e+00-1.943714e+00i, -1.269178e+00-2.058176e+00i, +5.596354e+00+1.661325e+00i, +3.193325e+00+2.237568e+00i, +4.946904e-01+1.580365e-01i },
{ -1.970649e+00-5.114771e-01i, -3.303964e-01+9.100478e-01i, +1.007699e+00+9.423051e-01i, +1.756285e-02-2.626576e-01i, +1.552832e-01-3.277421e-02i },
{ -1.407842e-01+3.723505e-02i, +4.770366e-01-4.417062e-01i, +7.806940e-01-2.446506e-01i, +2.374868e-01+1.905827e-02i, +4.073318e-02-4.705186e-03i },
},
{
{ +5.915480e-01+3.053284e-01i, +2.835045e+00+1.313474e+00i, +3.447075e+00+6.459231e-01i, +1.275478e+00-4.622240e-02i, +1.597739e-01-4.220962e-02i },
{ +9.469588e-01-6.332374e-02i, +3.665124e+00-2.174277e+00i, +3.393925e+00-4.280286e+00i, +1.100067e+00-1.814769e+00i, +8.557100e-02-2.581099e-01i },
{ +3.415882e-01+4.663517e-01i, -3.131990e-01-1.355284e+00i, -1.584678e+00-2.975076e+00i, -6.040297e-01-1.265483e+00i, -1.033432e-01-1.396635e-01i },
{ +2.898158e-01+2.414467e-01i, -1.954212e-02+1.824465e-01i, -7.229232e-01+9.268808e-02i, -3.462130e-01-8.734070e-03i, -3.262481e-02+1.348398e-02i },
{ +5.882893e-03-2.532280e-02i, -6.226680e-02-1.044118e-01i, -8.957718e-02-4.915152e-02i, -2.463368e-02+2.666911e-03i, +5.138622e-05+1.313816e-03i },
}
},
{// coil38
{
{ +9.966666e+00-1.254774e+00i, -8.429956e+00+1.629813e+01i, -9.403707e+00-1.101083e-01i, +4.008803e+00-2.078257e-01i, -5.628985e-01+1.207319e+00i },
{ +4.034246e+01+5.818020e+00i, -9.328100e+00+5.603753e+01i, -1.874601e+01-1.790604e+00i, +8.753262e+00+6.488018e-01i, -3.230794e+00-1.773042e+00i },
{ +3.871772e+01+1.687815e+01i, -2.142251e+01+5.078706e+01i, -9.708214e+00-1.662699e+01i, +9.779435e+00+7.900644e+00i, -6.493744e+00-2.424116e+00i },
{ +1.352389e+01+5.825455e+00i, -1.592578e+01+1.640599e+01i, -5.512608e+00-1.469478e+01i, +8.224973e+00+3.409416e+00i, -3.060022e+00-1.830089e-01i },
{ +2.894619e+00+3.675645e-01i, -8.846845e-01+3.607488e+00i, -1.816665e+00-1.254856e+00i, +7.224405e-01-2.139379e-01i, -4.677163e-01+6.105810e-03i },
},
{
{ -1.353184e+00+1.503735e+00i, +1.054806e+01+1.658729e+01i, -3.745747e+00+1.102449e+01i, -3.523305e+00-7.418205e-01i, +8.350585e-01+5.778707e-01i },
{ +3.735924e+01-7.202234e+00i, +6.849707e+01+9.010668e+01i, -1.301554e+01+5.123254e+01i, +6.601143e-02-1.187912e+01i, +8.436863e-01+3.112705e+00i },
{ +4.327532e+01-2.561561e+01i, +8.361673e+01+8.895413e+01i, -2.456857e+01+4.404193e+01i, +3.002278e+00-1.619679e+01i, -1.838552e+00+6.852167e+00i },
{ +1.066780e+01-1.984020e+01i, +2.485384e+01+2.111803e+01i, -1.486611e+01+7.104522e+00i, +5.365079e+00-6.718445e+00i, -1.017460e+00+3.584262e+00i },
{ +2.720873e+00-2.014106e+00i, +3.189346e+00+3.974028e+00i, -2.867629e+00+5.849118e-01i, +4.481640e-01-1.406364e+00i, -2.998736e-01+3.444882e-01i },
},
{
{ -3.613090e+00+2.351140e+00i, +1.493362e+00-1.259313e+01i, +1.159329e+01+4.514238e+00i, -2.880330e+00+6.139260e+00i, +1.196307e-01-2.005027e+00i },
{ -9.220009e-01-5.302765e+00i, +4.750260e+01-1.123244e+01i, +3.241564e+01+2.925424e+01i, -1.018209e+01+4.491272e-01i, +4.838371e+00-9.054805e-01i },
{ -1.547114e+01-2.009602e+01i, +6.513182e+01-1.771668e+01i, +1.415221e+01+4.184007e+01i, -1.582739e+01-1.000628e+01i, +6.614331e+00+2.659341e+00i },
{ -1.394218e+01-1.401702e+01i, +2.309688e+01-1.381246e+01i, +1.728588e+00+1.607235e+01i, -5.205545e+00-4.081525e+00i, +2.362305e+00+1.710694e+00i },
{ -4.586614e-01-9.003313e-01i, +2.415803e+00-5.229962e-01i, -1.963723e-01+1.195496e+00i, -3.288711e-01-6.164953e-01i, +1.296415e-01+1.466651e-01i },
},
{
{ +8.181157e-01+3.061170e+00i, -7.717450e+00-2.418882e+00i, +1.607397e+00-2.978899e+00i, +1.198900e+00+2.269191e+00i, -5.400851e-01-9.261925e-01i },
{ -2.917506e+00+8.723001e+00i, -1.078077e+01-1.241613e+01i, +1.106331e+01-6.431945e+00i, -1.149318e+00+4.522181e+00i, +6.833762e-01-2.151981e+00i },
{ -9.502449e+00+8.866337e+00i, -8.577913e+00-1.721158e+01i, +1.028882e+01-1.789232e+00i, -3.785819e+00+2.723804e+00i, +1.700685e+00-1.564868e+00i },
{ -5.027603e+00+2.809018e+00i, -2.458787e+00-5.576903e+00i, +2.917533e+00+1.167610e+00i, -1.463828e+00+7.170364e-01i, +6.384324e-01-2.487160e-01i },
{ -1.049952e-01+3.364623e-01i, +2.143521e-02-3.213359e-01i, +3.431533e-01+2.255049e-02i, -1.557304e-02+5.196108e-02i, +4.356535e-02-1.659330e-02i },
},
{
{ +4.795839e-01+7.464610e-01i, +2.127262e-01+4.587955e-01i, +1.635904e-01-2.482100e-01i, -1.683927e-01+8.797478e-02i, -4.918025e-02-9.204494e-02i },
{ +1.178663e+00+1.685882e+00i, +6.174119e-01+7.085835e-01i, +6.634571e-01+4.042004e-01i, -4.462592e-01+4.811909e-01i, +5.017906e-02-2.022150e-01i },
{ +4.150285e-01+8.722172e-01i, +8.655830e-01-1.416954e-01i, +9.226538e-01+8.584847e-01i, -3.790711e-01+1.866997e-01i, +1.728473e-01-1.270851e-01i },
{ -3.469969e-02+2.117045e-02i, +4.665219e-01-1.674039e-01i, +2.559201e-01+3.206661e-01i, -1.517189e-01-7.169727e-02i, +7.714675e-02-1.299599e-02i },
{ +2.117525e-02-2.443856e-02i, +6.988399e-02-1.926673e-02i, +1.151282e-02+1.953170e-02i, -5.760750e-03-1.322018e-02i, +6.666413e-03+7.814271e-04i },
}
},
{// coil39
{
{ +3.545612e-01+3.544388e+00i, -1.081418e+01-1.339217e+00i, -1.738424e+00-1.909418e+00i, +9.315991e-01-1.242181e+00i, +1.114978e+00-2.924581e-01i },
{ +1.654777e+01+2.218400e+01i, -2.926311e+01+2.968962e+01i, -8.840725e+00-6.521663e+00i, +3.409002e-01+4.066837e+00i, -2.505899e+00-3.619211e+00i },
{ +2.072638e+01+8.012712e+00i, -1.856005e+01+3.944197e+01i, -1.191308e+01-9.218490e+00i, +1.016766e+01+5.176774e+00i, -5.088292e+00+4.597490e-01i },
{ +7.485781e+00-6.896638e+00i, +2.303421e+00+1.168388e+01i, -9.193201e+00-3.128026e+00i, +5.185224e+00-3.826630e+00i, -6.894365e-01+1.703617e+00i },
{ +9.127617e-02-1.004215e+00i, +1.999753e+00+1.384149e+00i, -1.324287e+00+1.990715e+00i, -7.160781e-01-5.199609e-01i, +7.152902e-02+1.522291e-01i },
},
{
{ +1.393181e+00+5.164350e+00i, -1.037569e+01+1.030698e+01i, -3.747736e+00-8.304503e-01i, -3.019130e-01+7.338333e-01i, -3.519450e-01-4.910752e-01i },
{ +2.598382e+01+2.039697e+01i, -1.151193e+01+8.820357e+01i, -2.963156e+01+2.005494e+01i, +6.278257e+00-2.533918e+00i, -3.660439e+00+1.916951e+00i },
{ +1.841471e+01+7.221622e-01i, +2.381118e+01+7.488307e+01i, -2.787310e+01+3.279898e+01i, +3.530023e+00-1.337320e+01i, +9.024560e-01+5.414164e+00i },
{ -7.539968e+00-7.199042e+00i, +1.954453e+01-4.090219e+00i, +2.401114e-03+1.626212e+01i, -6.634764e+00-6.212523e+00i, +3.508619e+00+6.735327e-01i },
{ -2.977125e+00+9.815942e-01i, +1.001324e+00-2.853170e+00i, +2.270079e+00+2.675906e+00i, -1.838651e+00+6.654838e-01i, +4.013187e-01-3.133805e-01i },
},
{
{ -5.333705e-01-1.507289e+00i, +4.813638e+00+2.511289e+00i, -1.513453e+00+4.667173e+00i, -1.444468e+00-4.918830e-01i, +2.014035e-01+5.000839e-01i },
{ +3.353583e+00-1.024523e+00i, +2.322520e+01+2.216124e+01i, -9.925461e-02+2.630870e+01i, -3.218546e+00-4.394154e+00i, +2.254242e+00+2.044036e+00i },
{ -3.783877e+00-1.037159e-01i, +2.813776e+01-1.198915e+00i, +9.592914e+00+2.717155e+01i, -1.121666e+01-5.297520e+00i, +5.467731e+00-4.781067e-02i },
{ -9.512777e+00+6.578701e+00i, +3.591393e+00-1.897130e+01i, +1.390792e+01+7.685261e+00i, -8.370471e+00+2.992886e+00i, +2.735968e+00-2.217363e+00i },
{ -1.288368e+00+2.687722e+00i, -2.251580e+00-2.422806e+00i, +2.750720e+00-4.221911e-01i, -5.996122e-01+1.338222e+00i, +1.123013e-01-4.954212e-01i },
},
{
{ -3.073002e+00-1.911500e-01i, +7.264720e-01-4.701344e+00i, +1.090150e+00+2.049003e+00i, -9.121000e-01-7.510543e-02i, +5.455309e-01+2.633232e-02i },
{ -5.725861e+00+2.758085e+00i, +4.350353e-01-1.048136e+01i, +7.686634e+00+2.312641e+00i, -2.930319e+00+1.075238e+00i, +1.336984e+00-8.586236e-01i },
{ -4.196849e+00+4.365700e+00i, -4.559408e+00-1.176036e+01i, +8.786527e+00-1.625697e+00i, -2.722899e+00+3.047284e+00i, +8.978150e-01-1.547792e+00i },
{ -5.711720e-01+3.536614e+00i, -4.716299e+00-3.833952e+00i, +3.468649e+00-2.395449e+00i, -3.740816e-01+2.045234e+00i, +8.186004e-02-8.099014e-01i },
{ +3.963145e-01+5.332131e-01i, -7.550830e-01+1.537496e-01i, +2.216431e-01-5.660173e-01i, +1.352780e-01+2.400290e-01i, -5.363286e-02-1.045252e-01i },
},
{
{ -2.240861e-01+3.871152e-01i, +1.631483e-01-1.717831e-02i, +1.907898e-01+1.930611e-01i, -1.315365e-01+2.909397e-02i, +3.724410e-02+4.255740e-03i },
{ +4.270867e-02+1.017909e+00i, +1.952279e-01+3.510231e-01i, +3.300194e-01+5.306171e-01i, -2.687441e-01+1.126418e-01i, +1.155576e-01-5.301735e-02i },
{ +2.551650e-01+1.118843e+00i, -3.578330e-01+4.662649e-01i, +1.417172e-01+3.237822e-01i, -2.890481e-01+1.155307e-01i, +9.434154e-02-1.381787e-01i },
{ +1.227352e-01+4.979470e-01i, -3.436989e-01+2.184361e-01i, +6.136276e-02+2.697916e-02i, -1.079328e-01+1.132277e-01i, +5.118594e-03-7.970862e-02i },
{ +4.128434e-02+2.402724e-02i, -1.763573e-02+4.564160e-02i, +7.136576e-04-1.777545e-02i, +4.662335e-03+1.264429e-02i, -6.549314e-03-7.676729e-03i },
}
},
{// coil40
{
{ -3.191680e-01+1.803886e+00i, -3.296061e+00-9.932890e-01i, -2.707969e+00-4.401162e+00i, +6.031279e-01-1.305227e+00i, -4.361785e-01-2.051919e-01i },
{ +9.978366e-01+3.363268e+00i, -9.184046e+00+5.069806e+00i, -1.078522e+01-2.391543e-01i, -9.737409e-01+5.776854e-01i, -5.479243e-01+3.704966e-01i },
{ +2.281684e+00+1.139939e+00i, -7.890657e-01+5.374459e+00i, -2.380801e+00+3.198837e+00i, +1.195573e+00+6.461942e-01i, +2.647521e-02+3.094019e-01i },
{ +6.000602e-01-1.401630e-01i, +9.752215e-01+4.558367e-01i, +1.860828e-01-3.763138e-01i, +1.276856e-02-5.753018e-01i, +5.133576e-02-1.834535e-02i },
{ -1.265963e-02+3.675619e-02i, -1.571862e-01+4.003669e-02i, -4.289834e-02+1.581440e-01i, +3.147688e-02+1.710218e-01i, +2.283466e-03-4.315433e-03i },
},
{
{ -1.827740e+00-3.435981e+00i, -5.137246e+00-6.157356e+00i, +1.121335e-01-2.770281e+00i, +1.298818e+00-1.552892e-01i, -3.467314e-01-2.750386e-01i },
{ -8.304629e+00-5.404429e+00i, -2.089341e+01-1.831280e+01i, -9.041507e+00-1.164049e+01i, +5.573727e-01+2.949668e-01i, -4.374094e-01-2.970219e-02i },
{ -4.174845e+00-9.018691e-01i, -1.186296e+01-5.620743e+00i, -6.604515e+00-4.118680e+00i, +6.056638e-01-1.514298e-01i, -1.241262e-01+1.313150e-03i },
{ +4.575366e-01+4.187672e-01i, -2.152487e-01+2.031977e+00i, -9.685366e-01+7.528053e-01i, -3.764096e-01-3.532483e-01i, -1.441022e-02+9.848005e-02i },
{ -2.902889e-02-1.912853e-01i, +4.283440e-03-1.858611e-01i, +1.072204e-01+1.374037e-02i, +1.268134e-01+1.206165e-01i, +3.718632e-02+2.404264e-03i },
},
{
{ +4.375561e-01-5.193238e-01i, +2.693893e-01+5.691330e-01i, -9.823352e-01-3.609110e-01i, -6.584512e-01+2.895990e-01i, -4.751262e-02-3.582752e-01i },
{ +8.001089e-03-6.096832e+00i, +3.247254e+00-9.931540e+00i, +2.667116e+00-2.476307e+00i, +5.744613e-01+1.485553e+00i, -1.315573e-01-7.435052e-02i },
{ -2.905961e+00-4.075770e+00i, +6.541783e-01-9.313154e+00i, +2.001193e+00-3.453413e+00i, +5.373233e-01-6.456077e-01i, +1.918554e-01-4.327389e-02i },
{ -1.458691e+00+1.333639e-01i, -8.983123e-01-4.346847e-01i, -5.151564e-01+5.758097e-01i, -8.738904e-01-2.279932e-01i, +6.099941e-02+8.363806e-03i },
{ -7.035252e-02-1.295506e-01i, +3.063847e-01-3.322994e-01i, +5.558338e-01+4.092070e-02i, +1.403484e-01+1.538346e-01i, +4.231434e-02+9.012690e-03i },
},
{
{ -3.279020e-01+1.064440e+00i, -4.980163e-01+2.375789e-01i, -3.526524e-01-1.706632e+00i, -3.276463e-01-1.121007e-01i, +4.222995e-03-2.051982e-01i },
{ +1.557519e+00+2.006942e+00i, -5.823759e-01+4.145984e+00i, -1.804373e+00+8.324137e-01i, -3.274419e-01+7.299275e-01i, -2.232055e-01-5.832434e-03i },
{ +1.395918e+00+2.459123e-01i, +1.783155e+00+2.355856e+00i, +3.838213e-01+1.292980e+00i, +4.934388e-01+1.008248e-01i, +3.560448e-02+1.212247e-01i },
{ -2.524863e-01-1.413799e-01i, +1.550209e-01-3.307685e-01i, +2.102177e-02-5.495876e-02i, -1.644038e-01-2.803880e-01i, +5.440485e-02-1.706321e-02i },
{ +2.310660e-02+5.703323e-02i, +6.157969e-02+1.054060e-01i, +8.644425e-02+1.724116e-01i, -4.277902e-03+8.447187e-02i, +5.477057e-03+5.370470e-03i },
},
{
{ -9.687993e-02-3.134868e-01i, +1.943940e-01-3.663925e-01i, +4.159311e-01+6.606441e-02i, +7.279604e-02+5.358191e-02i, +2.000190e-02-1.502840e-02i },
{ -5.008651e-01-5.391769e-01i, -4.269612e-01-1.317682e+00i, +3.448017e-01-7.872866e-01i, +9.038630e-02-4.737148e-02i, -2.517126e-03-3.507654e-02i },
{ -3.422174e-01-2.135140e-01i, -4.920914e-01-6.269019e-01i, -1.376568e-01-4.812662e-01i, +3.683064e-03-4.392783e-02i, -9.026079e-03-8.354154e-03i },
{ -5.795344e-02-3.294913e-02i, -5.803101e-02-7.115803e-02i, -3.775600e-02-1.893913e-02i, -1.319228e-02-8.696660e-03i, +2.132094e-03+1.123745e-03i },
{ -6.535597e-03+7.399948e-03i, -2.101794e-02+7.136598e-03i, -1.329267e-02+3.600626e-03i, -3.927888e-03+3.614877e-03i, -6.132381e-06+2.372978e-04i },
}
},
{// coil41
{
{ +6.311678e-01+4.978792e-01i, +2.414821e-01+8.351838e-01i, -5.549541e-01-1.228903e+00i, +5.403873e-01-2.864801e-01i, +9.261987e-02-1.526752e-01i },
{ +8.344197e-01-5.003957e-01i, +4.051359e-02+4.746051e+00i, -4.652748e+00+2.654152e+00i, -1.298388e+00-1.452775e+00i, +1.483876e-01+2.705816e-01i },
{ +1.009644e+00-3.126080e+00i, +4.188746e+00+4.497767e+00i, -2.462262e+00+5.457214e+00i, -6.724321e-01-6.862018e-01i, +1.839369e-01+5.619134e-01i },
{ +6.260631e-01-1.931886e+00i, +2.241037e+00+8.369406e-01i, -5.010051e-01+9.019519e-01i, +1.291248e-01-6.442168e-01i, +1.884128e-02+2.059255e-01i },
{ -5.174247e-02-3.901879e-02i, +2.944082e-02+1.590234e-01i, -2.076918e-01+2.213773e-01i, -9.187280e-02+3.077573e-02i, +3.633285e-04+1.880673e-02i },
},
{
{ -1.534575e+00-3.942585e-02i, -6.405437e+00-4.180458e+00i, -1.235627e+00-3.131812e+00i, +1.225738e+00+2.954714e-01i, +1.144853e-02-1.444922e-01i },
{ -5.438016e+00+4.738221e+00i, -2.338684e+01+1.456762e+00i, -1.138951e+01-4.528502e+00i, +6.969548e-01-6.600769e-01i, -3.211513e-01+1.438609e-01i },
{ -1.965647e-01+4.344962e+00i, -1.315063e+01+9.776527e+00i, -7.932426e+00+2.855382e-01i, +1.577280e+00-1.390975e-01i, -4.060155e-01+4.093913e-01i },
{ +1.999029e+00+4.356027e-02i, -3.461702e-01+3.501325e+00i, -1.527463e+00-8.159722e-01i, +8.339503e-01-7.692640e-01i, -2.143568e-01+1.816578e-01i },
{ -2.403283e-02-2.940595e-03i, -2.398688e-01+4.282802e-01i, -4.503061e-01+2.719187e-01i, -1.187188e-01+7.094990e-02i, -1.551519e-02+2.310253e-02i },
},
{
{ -1.807127e+00-9.836155e-01i, -1.623093e+00-2.481924e+00i, +6.099911e-01-1.223641e+00i, -1.502823e-01-4.198241e-02i, +1.360973e-01+9.589970e-03i },
{ -7.612500e+00-6.358278e-01i, -1.005398e+01-7.453167e+00i, -1.781854e+00-1.520222e+00i, -4.123409e-01+5.684041e-01i, +1.604192e-02-8.083966e-02i },
{ -5.141174e+00+1.699730e+00i, -6.988344e+00-4.045622e+00i, +1.452778e+00-7.937758e-01i, +6.204255e-01+1.166775e+00i, -1.398779e-01-9.587462e-02i },
{ -2.867703e-01+8.619885e-01i, -1.193371e+00-5.990863e-01i, +7.576826e-01-1.499217e+00i, +4.708795e-01+2.218557e-02i, -1.123638e-01-1.118084e-02i },
{ -1.550906e-01-3.771666e-03i, -2.738898e-01+7.293301e-02i, -1.912448e-01+1.067981e-01i, -7.342339e-02+4.913364e-02i, -3.703678e-03+4.226441e-03i },
},
{
{ +3.693131e-01-5.282241e-02i, +8.196784e-01+9.360294e-01i, +2.488171e-01-3.656300e-01i, -1.088222e-02-1.681016e-01i, +2.238050e-02+5.773340e-02i },
{ +9.542393e-01-1.832564e+00i, +2.956071e+00+1.391174e+00i, -1.030838e+00+1.326406e+00i, -3.233823e-01-6.926458e-01i, +3.424650e-02+1.886679e-01i },
{ +2.220869e-01-1.843550e+00i, +3.200692e+00+2.387512e-01i, -5.598259e-02+2.249202e+00i, -4.446452e-01-2.643661e-01i, +5.954055e-02+1.512010e-01i },
{ -6.478417e-02-3.521462e-01i, +7.404022e-01-3.366293e-01i, +3.170449e-01+3.101817e-01i, -4.387138e-02-1.678955e-02i, +1.915590e-02+2.843188e-02i },
{ -3.666896e-02-5.405603e-02i, +1.964480e-03-1.434050e-02i, -5.616108e-02+4.420805e-02i, -2.953989e-02-1.360645e-02i, +3.797692e-03+2.704417e-03i },
},
{
{ -1.614245e-01+4.182473e-03i, -3.981989e-01-1.491969e-01i, -1.278095e-03-1.020074e-01i, +5.146605e-02+7.523997e-02i, -1.078095e-02-2.235036e-03i },
{ -3.051698e-01+2.249696e-01i, -9.924853e-01-2.749953e-02i, -2.165340e-01-5.238103e-01i, +1.935792e-01-1.515979e-02i, -2.983188e-02+1.043239e-02i },
{ -1.916842e-01+2.334761e-01i, -7.590054e-01+1.076730e-01i, -3.423977e-01-4.341684e-01i, +1.112516e-01-8.596382e-02i, -1.920953e-02+1.158712e-02i },
{ -1.733471e-02+8.122396e-02i, -1.611033e-01+9.304757e-02i, -1.077603e-01-5.857000e-02i, +1.710249e-02-1.917795e-02i, -4.461617e-03+3.462699e-03i },
{ +4.941052e-03+2.455225e-03i, -9.337668e-04+1.027741e-02i, -6.277200e-03-2.630685e-03i, +1.663073e-03-2.804228e-03i, -4.378580e-05+5.594690e-04i },
}
},
{// coil42
{
{ -9.090384e-01-1.998475e+00i, +9.648369e+00-9.448418e+00i, +2.361668e+00-3.027587e+01i, -1.290366e+01-6.119915e+00i, +1.242747e-01+1.809148e+00i },
{ +7.001801e-01-1.282846e+01i, -3.021828e+01-4.623580e+01i, -4.398399e+01-1.162175e+01i, -5.401693e+00+1.538134e+01i, +1.767048e+00+3.647942e-01i },
{ -5.354627e+00-1.275376e+01i, -2.521293e+01-9.752183e-01i, -4.516440e+00+1.620076e+01i, +8.771847e+00-1.142379e+00i, +3.301565e-01-4.678450e-01i },
{ -4.370819e+00+5.698029e-01i, +5.330481e+00+5.946307e+00i, +2.708264e+00-1.969244e-01i, -3.242515e+00-3.709711e+00i, +1.343740e-01+3.748891e-01i },
{ -3.422846e-01-3.237939e-01i, -2.100248e-01-1.176501e+00i, +2.797392e-01+1.873970e+00i, +3.482761e-01+8.477936e-01i, +9.613596e-02-3.459290e-02i },
},
{
{ +1.789024e+00-9.686661e-01i, -2.540820e+01-4.458140e+01i, -5.959845e+01-2.012354e+01i, -1.436083e+01+2.303048e+01i, +3.709870e+00+2.470741e+00i },
{ -2.289500e+01-1.854594e+01i, -9.189867e+01-3.223173e+01i, -5.374291e+01+3.110001e+01i, +2.190143e+01+1.490372e+01i, +2.217272e+00-5.842405e+00i },
{ -1.066371e+01+2.582239e-01i, -2.396445e+01+9.279253e+00i, +2.519687e+00-6.781497e-01i, +2.658713e+00-9.628347e+00i, -4.102410e+00-6.866722e-01i },
{ +2.892923e+00+2.127724e+00i, +3.347693e+00+3.663603e+00i, -4.818501e+00-3.286188e+00i, -6.024793e-01+1.159766e+00i, +2.109619e-01+1.358570e+00i },
{ -3.598525e-01-2.329942e-01i, +7.470281e-01-3.221765e-01i, +7.615820e-01-3.075836e-01i, -3.448325e-01-1.398235e+00i, -2.363773e-01-1.814219e-01i },
},
{
{ -2.648736e+00-8.937206e+00i, -3.908041e+01-1.144397e+01i, -2.578043e+01+2.363398e+01i, +1.087628e+01+1.616133e+01i, +3.524321e+00+5.851616e-01i },
{ -1.829002e+01+6.108737e+00i, -2.647663e+01+2.532128e+01i, +8.906404e+00+2.174524e+01i, +1.300381e+01-1.502351e+01i, -1.108258e+00-5.578315e+00i },
{ +3.412481e+00+5.289851e+00i, +5.504238e+00+1.800884e-01i, +5.390152e-01-2.083099e+00i, -1.001070e+01+1.654287e+00i, -4.033156e+00+1.498535e+00i },
{ +1.593970e+00-2.686249e+00i, -4.017001e+00+1.011708e+00i, +3.728682e-01+6.004053e-01i, +6.794835e+00+2.517537e+00i, +6.178309e-01+9.083157e-01i },
{ +9.279909e-01+2.770230e-01i, +1.618482e+00-2.541519e-01i, -2.167565e+00-2.179532e+00i, -2.153175e+00-1.721934e+00i, -4.290720e-01-5.305184e-02i },
},
{
{ -3.506812e+00-3.550389e+00i, -8.837087e+00+6.191204e+00i, +6.413917e+00+8.615635e+00i, +5.679956e+00-1.097941e+00i, +4.408432e-01-3.035371e-02i },
{ +1.830221e+00+3.919409e+00i, +9.170367e+00+4.725944e+00i, +5.513266e+00-7.136851e+00i, -3.504092e+00-7.672291e+00i, -8.242285e-01-3.375944e-01i },
{ +3.257093e+00-3.383958e+00i, +1.509200e+00-5.522492e+00i, -5.297445e+00+2.455364e+00i, -3.671009e+00+3.695886e+00i, -2.386996e-01+9.581177e-01i },
{ -1.867335e+00-8.678449e-01i, -1.113252e+00+2.517576e+00i, +2.805379e+00+1.850787e+00i, +2.653038e+00-3.954625e-01i, +2.728990e-01-9.198975e-03i },
{ +6.472332e-01-3.505623e-02i, +6.809372e-01-6.993677e-01i, -1.262007e+00-6.329011e-01i, -9.389775e-01-1.344183e-01i, -1.233801e-01+5.086339e-02i },
},
{
{ -7.734164e-01+4.152893e-01i, -8.789209e-01+1.429924e+00i, +2.939874e-01+1.076679e+00i, +2.485130e-01+8.048183e-02i, +2.585735e-02+2.198071e-03i },
{ +7.767320e-02+9.251081e-01i, +1.228725e+00+9.059099e-01i, +9.261733e-01-2.893118e-01i, -1.278937e-01-1.830485e-01i, +3.572117e-03+1.216072e-02i },
{ +2.502962e-01-3.481223e-01i, -3.003689e-01-1.135354e+00i, -5.614380e-01-4.452976e-01i, -6.287295e-02+2.858721e-01i, +2.960154e-02+3.034085e-02i },
{ -1.438972e-01+5.863035e-02i, -3.085139e-01+3.485999e-01i, +3.585267e-02+6.166710e-02i, +1.773789e-01-1.065732e-01i, -6.738706e-03-1.325537e-02i },
{ +1.033988e-01-2.931290e-02i, +1.036719e-01-1.447826e-01i, -1.024833e-01-1.102447e-01i, -8.226068e-02+2.964769e-03i, -7.397275e-03+1.160873e-02i },
}
},
{// coil43
{
{ -4.783936e-01+8.140030e-01i, -1.833512e+01+6.764592e+00i, -2.404976e+00+2.460540e+01i, +1.246250e+01-1.851928e+00i, -2.986430e+00-2.265228e+00i },
{ -1.168499e+01+6.629260e+00i, -6.382050e+00+4.489350e+01i, +2.693314e+01+1.193284e+01i, -3.127934e-01-1.339852e+01i, -1.933893e+00+2.013068e+00i },
{ -8.053906e+00+8.403936e+00i, +1.251124e+01+1.114628e+01i, +5.126706e+00-1.080624e+01i, -9.189073e+00-4.868702e-01i, +1.659861e+00+7.999059e-01i },
{ -1.346576e+00+2.067254e+00i, +3.363073e+00-4.142307e+00i, -4.528769e-01-3.047667e-01i, -1.208933e+00+2.815035e+00i, +5.439669e-01-5.401868e-01i },
{ -1.944678e-01+1.072277e+00i, +3.822785e-01-5.734061e-01i, +4.922696e-01-1.269434e+00i, -1.516907e-02+1.741817e-01i, +5.950762e-02-1.072567e-01i },
},
{
{ -6.388459e+00+2.191012e+00i, -1.759184e+00+5.414915e+01i, +3.699324e+01+2.388110e+01i, +1.561868e+00-1.574255e+01i, -3.629414e+00+2.447652e+00i },
{ -6.691364e+00+2.698351e+01i, +2.763921e+01+6.751881e+01i, +3.172961e+01+1.766953e+00i, -1.111334e+01-5.194423e+00i, +1.512411e+00+4.865489e+00i },
{ +1.523338e+00+1.044898e+01i, +9.596952e+00+1.308120e+01i, -7.049945e+00+9.140782e-01i, -1.304191e+00+4.873563e+00i, +2.483421e+00+2.248409e-01i },
{ +6.048753e-01-8.493950e-01i, +3.001205e+00-1.954874e+00i, -2.680691e+00+3.014475e+00i, +8.202752e-01+9.451477e-01i, +3.350683e-01-1.959831e-01i },
{ +3.945669e-01+6.361569e-01i, -4.703527e-01-9.343278e-01i, -5.918212e-01-7.872701e-02i, +5.152369e-01+5.553190e-02i, +5.362156e-02-1.651787e-01i },
},
{
{ -3.687869e+00+8.616680e+00i, +2.814346e+01+2.218252e+01i, +1.691290e+01-1.634536e+01i, -1.235764e+01-2.565576e+00i, +1.710906e+00+2.861496e+00i },
{ +1.274519e+01+7.711897e+00i, +2.398516e+01-4.074193e+00i, +1.015509e+00-4.171230e+00i, -9.075474e-01+7.947376e+00i, +3.434184e+00-1.006275e-01i },
{ +3.989313e-01-5.841828e+00i, -1.445042e+00+5.118250e-02i, +6.027577e+00+9.672647e-01i, +4.911150e+00-4.967779e+00i, +1.603848e-01-6.102594e-01i },
{ -1.584888e+00-1.164880e+00i, +1.819239e+00+1.569284e+00i, -3.004350e+00-4.442600e-01i, -1.697430e+00-1.634320e+00i, +1.634746e-01+5.640367e-01i },
{ -7.854977e-02-7.726884e-01i, -4.252032e-01+2.588854e-01i, +6.122445e-01+1.781222e+00i, +6.119152e-01-3.070576e-01i, +8.858467e-03-7.519029e-02i },
},
{
{ +1.131139e-01+4.197190e+00i, +7.895974e+00-5.115626e+00i, -5.186662e+00-1.063696e+01i, -3.624610e+00+2.363846e+00i, +1.188768e+00-1.864566e-01i },
{ +1.954376e+00-4.611310e+00i, -7.274201e+00-7.487036e+00i, -8.007692e+00+6.322867e+00i, +1.322197e+00+2.724735e+00i, +2.957103e-01-1.128255e+00i },
{ -4.792218e+00-3.105360e+00i, -1.904406e+00+2.951846e+00i, +6.098769e+00+1.778021e+00i, -5.892761e-01-2.170585e+00i, -3.634676e-01+1.249971e-01i },
{ -1.151044e+00+8.697988e-01i, +1.665466e+00-5.054591e-01i, -4.494856e-01-1.788026e+00i, -1.211521e+00+2.339397e-01i, +2.236342e-01+2.229750e-01i },
{ -2.458015e-01-2.150769e-01i, -5.010734e-02+3.501704e-01i, +5.855868e-01+6.205313e-01i, +1.684767e-01-1.217877e-01i, -1.915991e-04-1.856466e-02i },
},
{
{ +6.254992e-01+5.289036e-01i, +1.076144e+00-5.027562e-01i, -6.675717e-01-4.243962e-01i, -3.461754e-01+6.045663e-01i, +8.000962e-02-1.413415e-02i },
{ +6.466292e-01-6.909204e-02i, -1.802204e-01-7.499395e-02i, +2.507110e-01+1.361548e+00i, +7.818702e-01+5.390314e-01i, +4.035844e-03-7.132287e-02i },
{ -3.222195e-01+1.350818e-01i, -3.254181e-02+1.019840e+00i, +1.059755e+00+1.755292e-01i, +3.940545e-01-2.917638e-01i, +6.876154e-03+3.164523e-02i },
{ +6.793270e-02+1.773305e-01i, +2.298105e-01+2.585937e-02i, -1.698076e-01-2.101300e-01i, -4.510955e-02-1.032685e-02i, +3.827909e-02+1.639795e-03i },
{ -4.101021e-03-2.869772e-02i, -3.150858e-02+2.414858e-02i, +2.825828e-02+5.324910e-02i, +2.144784e-02-2.654046e-02i, -3.662011e-03-4.624658e-03i },
}
},
{// coil44
{
{ +1.004953e+01+2.423155e+00i, +3.936988e+01-1.605350e+01i, +1.274167e+01-3.166993e+01i, -1.074805e+01-6.872194e+00i, +8.313638e-02+3.900183e-01i },
{ +1.105564e+01-1.464306e+01i, +1.430429e+01-3.413647e+01i, -1.026359e+01-1.645574e+01i, -8.892202e+00+7.357938e+00i, +1.382328e+00+1.912681e+00i },
{ -5.264776e+00-5.547090e+00i, -9.195253e+00+2.618042e+00i, -1.737458e+00+2.349580e+00i, +5.564754e+00+1.042911e+00i, +5.052757e-01-1.799120e-01i },
{ +2.984342e+00-6.011153e-01i, +3.973650e-01+2.164348e+00i, -3.931785e+00-1.128886e+00i, +4.137647e-01-1.438098e+00i, -8.633946e-01+2.310687e-01i },
{ -3.415105e-01-6.776425e-01i, -3.185691e-01+1.660982e+00i, +4.855865e-01+1.799867e+00i, +8.062703e-01-6.599554e-02i, +1.223425e-01+1.211070e-01i },
},
{
{ +5.179281e+00+1.335684e+01i, +4.840964e+01+4.206899e+01i, +5.066633e+01+1.266580e+01i, +8.349270e+00-1.106217e+01i, -2.479455e-01-1.304583e+00i },
{ +1.751076e+01+1.219938e+01i, +7.989165e+01+2.831101e+01i, +5.527560e+01-1.457422e+01i, -8.877167e+00-1.493949e+01i, -1.195591e+00+2.526217e+00i },
{ -4.967878e+00+1.572995e-01i, +1.068633e+01-1.217432e+00i, +9.900094e+00-5.972435e+00i, -5.596202e+00+2.337244e+00i, +1.024024e+00+7.369936e-01i },
{ +8.979986e-01+1.979430e+00i, +2.587302e-01-5.482730e+00i, +9.444892e-01-3.134396e+00i, +1.032447e+00+2.436346e+00i, -6.897306e-01-6.750296e-01i },
{ -5.341691e-02-6.174790e-01i, -2.164210e+00+9.513086e-02i, -1.014312e+00+8.406760e-01i, +6.771495e-01+3.795684e-01i, +4.315311e-02+1.712700e-01i },
},
{
{ -2.892073e+00-4.245867e+00i, -1.632014e+01+1.376921e+01i, -8.693872e+00+2.481024e+01i, +4.474902e+00+6.252073e+00i, +7.134658e-01-5.942273e-01i },
{ -3.938018e+00+1.285400e-01i, -1.203772e+01+4.637605e+01i, +1.408762e+01+4.071971e+01i, +1.182935e+01-4.371265e+00i, -1.595778e+00+3.284851e-01i },
{ -2.243298e+00+1.031128e+00i, +5.134347e+00+2.133400e+01i, +1.431581e+01+5.871243e+00i, -3.702940e-01-6.287529e+00i, -4.900635e-01+4.725032e-01i },
{ +1.289700e+00+3.485401e+00i, +3.296173e+00-2.164091e+00i, +9.185870e-01-4.487051e+00i, -1.529980e+00+2.199491e+00i, -3.339859e-01-5.040355e-01i },
{ +3.814659e-01+6.672010e-02i, -1.302546e+00+1.509353e-01i, -2.364928e-01-1.873815e-01i, +6.461213e-01+1.139192e-01i, -6.090771e-02+7.536265e-02i },
},
{
{ +1.409064e+00+2.047877e+00i, +8.814912e+00-8.647093e+00i, -4.479699e+00-1.291367e+01i, -4.819714e+00+1.266006e+00i, +7.098097e-01+9.394930e-02i },
{ +6.587915e+00-3.760131e+00i, -6.410954e+00-1.725760e+01i, -1.629636e+01-9.130671e-01i, +1.819565e+00+5.283910e+00i, +1.220465e-01-5.764844e-01i },
{ +9.374146e-01-4.270287e+00i, -8.092360e+00+2.503569e+00i, -1.977241e+00+5.086983e+00i, +3.476783e+00-1.239524e+00i, -4.629173e-01-2.197273e-01i },
{ +1.480446e-01+9.639537e-01i, +1.083718e+00+2.408485e+00i, +2.253591e-01-1.153687e+00i, -6.292395e-01-3.809645e-01i, -1.855252e-01-2.775840e-03i },
{ +2.237057e-01-2.406946e-01i, -4.109885e-01+8.271770e-02i, -9.456980e-02+3.355332e-01i, +2.824895e-01+9.058321e-02i, -2.193534e-02+1.987980e-02i },
},
{
{ -1.698532e+00+1.194219e+00i, +3.175565e-01+4.629664e+00i, +1.878054e+00+1.730886e+00i, +1.518174e-01-7.427996e-02i, +1.302610e-01+4.543693e-02i },
{ -1.908038e-01+2.926710e+00i, +3.986989e+00+3.807426e+00i, +2.380482e+00+2.724886e-01i, -1.043545e-01-6.763476e-02i, +1.018910e-01-7.818455e-02i },
{ +4.444765e-01+5.410120e-01i, +1.175636e+00-1.521249e-01i, +5.563229e-01-7.755584e-02i, -4.672141e-02+1.255726e-01i, -2.631978e-02-4.838009e-02i },
{ -1.089692e-01+5.538189e-02i, -9.251839e-03-8.689742e-02i, +2.549638e-01-1.304224e-01i, +2.774871e-02+3.739410e-02i, -1.369163e-02-4.234473e-03i },
{ +6.028350e-02-2.279688e-02i, -1.493844e-02-1.324465e-01i, -6.254599e-02-5.495808e-02i, +5.749738e-04+1.481994e-02i, -2.619733e-03+2.422136e-04i },
}
},
{// coil45
{
{ -8.697105e+00-6.334814e+00i, -2.349694e+01-1.571951e+01i, -2.843417e+01-1.562217e+01i, -1.263780e+01-2.795057e+00i, -1.229669e+00-8.043716e-01i },
{ -1.270253e+01+5.713757e+00i, -2.636161e+01+1.663099e+01i, -1.859011e+01+2.775520e+01i, -2.367592e+00+1.791948e+01i, +1.842013e-01+1.896382e+00i },
{ +7.602978e-01+2.864195e+00i, +6.530479e+00+7.480956e+00i, +1.387710e+01+3.980302e+00i, +9.840316e+00-1.523509e+00i, +1.808106e+00-3.248594e-01i },
{ -1.485599e+00-5.343537e-01i, -7.456189e-01-1.425957e+00i, -2.052248e+00-1.850675e+00i, -2.975953e+00-2.094074e+00i, -2.802702e-01-4.626035e-01i },
{ +6.068623e-01+4.342805e-01i, +1.254218e+00-3.716962e-01i, +2.190793e+00-1.962273e-01i, +1.033104e+00+4.908751e-01i, +1.118908e-01+7.828125e-02i },
},
{
{ +3.580051e+00-9.182572e+00i, +9.236800e+00-3.585636e+01i, +1.329333e+01-3.751589e+01i, +4.009447e+00-1.349151e+01i, +3.366947e-01-2.343859e+00i },
{ +3.690720e-01-1.056623e+01i, -1.081621e+01-5.108934e+01i, -3.137499e+01-4.611679e+01i, -1.910189e+01-3.788461e+00i, -2.250400e+00+1.926372e-01i },
{ +2.826923e+00-6.490409e-01i, -6.892944e+00-4.710587e+00i, -1.496489e+01+3.943769e+00i, -1.940605e+00+9.562555e+00i, +1.041364e+00+1.575272e+00i },
{ -1.048051e+00-1.854426e-01i, -2.116169e+00+2.223251e+00i, +1.992580e+00+2.126807e+00i, +1.943048e+00-1.159167e+00i, +3.636590e-01-5.986036e-01i },
{ +6.151562e-01+8.227122e-01i, +1.132533e+00+4.019655e-01i, +8.751979e-01+1.587827e-01i, -3.587260e-02+6.046212e-01i, -6.921721e-02+1.251937e-01i },
},
{
{ -2.305177e+00+1.530865e+00i, +5.196357e+00+1.057128e+01i, +1.317652e+01+1.523876e+01i, +7.370564e+00+5.964646e+00i, +1.666022e+00-1.356070e-01i },
{ +5.822596e+00+4.987670e+00i, +3.950969e+01-1.318798e+00i, +4.242342e+01-1.810639e+01i, +7.248965e+00-1.160723e+01i, +6.721586e-02-1.622990e+00i },
{ +7.352646e+00-8.150711e-01i, +1.295487e+01-1.906850e+01i, -2.079822e+00-2.587478e+01i, -7.909679e+00-5.293056e+00i, -9.234017e-01+4.709534e-01i },
{ -5.436780e-01-2.507804e+00i, -6.526529e+00-7.389546e-01i, -6.303144e+00+5.104715e+00i, -3.082198e-01+2.854838e+00i, +2.831930e-01+3.067319e-01i },
{ +1.028409e-01+6.285359e-01i, +1.795031e+00+3.748044e-01i, +1.947924e+00-8.618866e-01i, +1.589621e-01-6.114938e-01i, -4.239239e-02-5.429884e-02i },
},
{
{ -2.388535e-01-2.572399e+00i, -6.778806e+00-5.513218e+00i, -1.410795e+01-1.273460e+00i, -4.721120e+00+2.796355e+00i, +5.324245e-02+1.700873e-01i },
{ -6.450847e+00-4.768324e-01i, -1.076302e+01+1.284889e+01i, -3.455770e-01+2.086965e+01i, +3.642024e+00+5.030475e+00i, +3.088153e-01+4.150242e-02i },
{ -5.197620e-01+3.211948e+00i, +7.070609e+00+4.925382e+00i, +1.120350e+01-8.617868e-01i, +2.333861e+00-3.107517e+00i, -8.216149e-02-1.386374e-01i },
{ +8.685585e-01-1.230986e+00i, -6.141881e-01-3.324201e+00i, -3.053371e+00-1.880672e+00i, -1.341358e+00+5.893220e-02i, -5.206593e-02+1.269497e-01i },
{ -4.039032e-01+3.371181e-01i, +2.922795e-01+1.014747e+00i, +1.172258e+00+6.555381e-01i, +4.310395e-01-5.371796e-02i, +3.891243e-02-1.707447e-02i },
},
{
{ +1.534970e+00+6.048490e-01i, +3.946903e+00-9.507490e-01i, +2.408969e+00-1.998367e+00i, +4.492717e-01-4.482673e-01i, +8.169442e-02-6.663807e-02i },
{ +1.700339e+00-1.704159e+00i, +1.146619e+00-5.387610e+00i, -1.025973e+00-3.815627e+00i, -2.853800e-01-6.665036e-01i, -5.296638e-02-1.156401e-01i },
{ -2.486560e-01-4.273775e-01i, -1.376361e+00-4.969098e-01i, -1.276579e+00-6.613567e-03i, -2.613508e-01+1.160237e-02i, -6.250545e-02+1.686510e-02i },
{ +2.110248e-01+1.019472e-01i, +3.439411e-01+1.544258e-01i, +9.999244e-02+1.975744e-02i, -5.969957e-03+2.719529e-03i, +4.426461e-03+1.298740e-02i },
{ -9.160197e-02-4.773205e-02i, -1.864985e-01+1.294932e-02i, -9.607935e-02+8.357208e-02i, -8.376883e-03+2.265316e-02i, -7.064775e-04+1.391885e-03i },
}
},
{// coil46
{
{ +1.682157e+00-7.043543e+00i, -1.856121e+01-2.096222e+01i, -1.876927e+01-2.454926e+01i, -8.642855e+00-1.692768e+01i, -4.810735e+00-6.654525e-02i },
{ -1.313729e+01+7.374025e+00i, -6.311683e+01+2.325823e+01i, -5.534634e+01+3.981125e+01i, -4.926466e+00+2.385135e+01i, -1.080790e-01+4.830005e+00i },
{ +8.559738e+00+8.926781e+00i, +1.077124e+01+1.083283e+01i, +2.429214e+01+1.410816e+01i, +1.612521e+01-3.478176e+00i, +3.773581e+00-3.914269e+00i },
{ -3.236528e+00+1.656997e+00i, -5.410568e+00-1.179925e+01i, -3.798675e+00-8.621349e+00i, -1.152905e+01-7.527125e-01i, -1.628653e+00-1.754101e+00i },
{ +3.591688e-01+2.709446e+00i, +2.007909e-01+4.043828e+00i, +5.663716e+00+4.126343e+00i, +4.502887e+00+3.312597e+00i, +5.453764e-01+2.087822e-01i },
},
{
{ -1.364347e+01-4.748051e+00i, -2.551178e+01-1.810585e+01i, -5.473866e+00-4.809693e+01i, -4.677511e+00-3.192937e+01i, -6.229021e+00-4.087103e+00i },
{ -4.116830e+01-5.695523e+00i, -1.296286e+02-9.974260e+00i, -1.106877e+02+7.757942e+00i, -2.143132e+01+2.765488e+01i, -2.909870e+00+8.242595e+00i },
{ +4.698684e-01+4.576594e+00i, -1.710742e+01+2.526553e+01i, -6.761005e+00+3.105343e+01i, +2.618568e+01-3.605401e+00i, +7.776855e+00-1.696946e+00i },
{ -5.438638e-01-3.662874e+00i, +8.915290e+00-2.802751e+00i, -9.056208e+00-1.032851e+00i, -1.891017e+01-1.013200e+01i, -1.199625e+00-2.449250e+00i },
{ -1.752057e+00+2.058204e+00i, +1.106081e-01+3.396300e+00i, +6.796110e+00+9.337517e+00i, +4.911912e+00+7.213849e+00i, +9.271688e-01+6.670097e-01i },
},
{
{ +4.373883e+00+7.198906e-02i, +9.690214e+00-2.734679e+01i, +1.297927e+01-3.042356e+01i, +1.177606e+01-1.869751e+01i, -2.207669e+00-6.278796e+00i },
{ -2.424636e+01-6.104233e+00i, -7.373753e+01-4.365204e+01i, -6.260357e+01-2.874068e+01i, -2.515948e+01+1.039865e+01i, -5.674220e+00+1.660193e+00i },
{ -1.051907e+01+1.607479e+01i, -2.660195e+01+2.156065e+01i, -4.092956e-01+2.223113e+01i, +1.728808e+01+1.326960e+01i, +4.003269e+00+1.952795e+00i },
{ +8.792686e-01-2.190418e+00i, +9.566570e+00-5.357623e+00i, +2.159011e+00-1.057073e+01i, -4.746537e+00-1.249475e+01i, +6.968204e-01-1.579467e+00i },
{ -3.123458e+00+8.761222e-01i, -3.401618e+00+2.010125e+00i, -9.725363e-01+7.799789e+00i, -2.171295e-01+5.434645e+00i, +3.214513e-01+5.115584e-01i },
},
{
{ +6.611908e+00+2.230646e+00i, +1.230175e+01-5.819604e+00i, +7.864272e+00-4.838937e+00i, +6.463137e+00-3.121173e+00i, -1.535731e-01-1.576468e+00i },
{ -2.568409e+00-9.848933e-01i, -8.188423e+00-9.207405e+00i, -1.110209e+01-6.443263e+00i, -7.233541e+00-2.673734e-01i, -1.612827e+00-5.286916e-01i },
{ -2.747318e+00+7.181210e+00i, -2.465775e+00+7.594002e+00i, +5.122222e+00+1.008800e+01i, +1.956761e+00+6.815472e+00i, +4.696487e-01+5.629761e-01i },
{ +5.714221e-01+5.495906e-02i, +2.501996e+00-4.382348e+00i, +4.415115e+00-5.344328e+00i, +8.724916e-01-2.743150e+00i, +3.717395e-01-4.064711e-01i },
{ -1.040458e+00+5.203923e-01i, -1.900445e+00+1.045417e+00i, -1.483970e+00+1.890635e+00i, -7.063804e-01+1.139892e+00i, -1.184992e-02+8.213324e-02i },
},
{
{ -2.048599e-01+7.372141e-03i, -1.980677e-02-2.319843e-01i, +6.428229e-01-6.431753e-01i, +4.281256e-01-2.496940e-01i, -6.994405e-02-5.369020e-02i },
{ -5.030061e-01-5.799696e-01i, -1.392082e+00-7.143216e-01i, -1.193493e+00-1.495354e+00i, -1.690434e-01-5.066167e-01i, -6.946541e-02+2.700380e-02i },
{ +1.475852e-01-2.282121e-01i, +9.947553e-03+1.813070e-01i, -9.588341e-01+2.711397e-01i, -1.038876e-01-9.907704e-02i, +4.092491e-02+2.664464e-02i },
{ +1.072517e-01-3.585345e-01i, +2.814036e-01-2.714278e-01i, -1.129608e-01+1.063266e-01i, -1.512907e-01-1.556631e-01i, +2.111337e-02-8.413973e-03i },
{ -8.692605e-02+3.951381e-02i, -7.508799e-02+1.192569e-01i, -4.707997e-02+1.759738e-01i, -3.257935e-02+8.165190e-02i, +4.519329e-03+3.533957e-03i },
}
},
{// coil47
{
{ -2.537516e+00+4.232672e+00i, -1.263066e+01+2.115209e+01i, -1.650566e+01+8.864575e+00i, -7.536891e+00-8.404457e+00i, +1.521926e+00-2.035251e+00i },
{ +1.204739e+01+1.699242e+00i, +4.017089e+01+3.319669e+01i, +3.704404e+01+4.305826e+01i, -4.394031e-02+1.346338e+01i, -2.655221e+00+1.660568e+00i },
{ -1.366691e+00-7.146279e+00i, +3.668937e+00-1.653822e+01i, +1.679481e+01-2.828576e+01i, +1.484043e+01-9.108751e+00i, +1.573467e+00+1.953023e+00i },
{ +1.631229e+00+4.537041e-01i, -3.284698e+00+8.609936e+00i, -1.837337e+01+6.465231e+00i, -8.364128e+00-4.091586e+00i, -4.391283e-01-8.455477e-01i },
{ -5.100713e-01-1.846580e+00i, +4.386515e+00-4.201028e+00i, +8.123077e+00+4.467837e-01i, +2.730783e+00+2.625117e+00i, +1.145534e-01+5.897496e-01i },
},
{
{ +3.986149e-01+1.389721e+01i, -1.233790e+01+2.034208e+01i, -3.302621e+01-4.063167e+00i, -6.012320e+00-1.778968e+01i, +2.719410e+00-3.955450e+00i },
{ +1.394073e+01+2.284582e+01i, +3.066347e+01+8.742821e+01i, +8.481802e+00+9.841545e+01i, -1.629954e+01+2.564674e+01i, -5.878151e+00+1.244791e+00i },
{ -1.456829e+00-1.051810e+00i, +1.998574e+01+1.650216e-02i, +5.213717e+01-2.454606e+00i, +2.806828e+01+2.019616e+00i, +3.131075e+00+3.601136e+00i },
{ -1.177675e+00+7.388387e-01i, -3.715190e+00-1.445266e+00i, -1.817397e+01-5.208634e+00i, -1.053565e+01-1.090287e+01i, +4.272269e-02-2.731102e+00i },
{ -6.671324e-01-1.338797e+00i, +5.228802e+00-2.951554e+00i, +1.079909e+01+5.766084e+00i, +2.666073e+00+6.607955e+00i, -1.966227e-01+1.001412e+00i },
},
{
{ -3.537040e+00+8.045759e-01i, -2.254918e+01-5.186383e+00i, -1.300661e+01-1.988472e+01i, +6.909454e+00-1.765774e+01i, +1.484769e+00-1.044219e+00i },
{ +8.926923e+00+1.485645e+01i, -9.465122e+00+6.427707e+01i, -3.894588e+01+5.508774e+01i, -2.023303e+01+5.202484e+00i, -3.855821e+00+4.180931e-01i },
{ +1.043445e+01-2.932913e+00i, +2.875971e+01+1.171986e+01i, +3.371270e+01+1.903878e+01i, +1.470916e+01+1.094258e+01i, +9.802139e-01+2.349502e+00i },
{ -1.061945e+00+8.828168e-01i, -7.138761e+00-5.627877e+00i, -8.812553e+00-1.514919e+01i, -1.825710e+00-8.559120e+00i, +5.340723e-02-1.796297e+00i },
{ +1.168442e+00+1.431715e-01i, +3.312085e+00+2.816785e+00i, +3.409072e+00+7.148399e+00i, +1.430592e-01+4.546745e+00i, -3.420382e-01+5.728086e-01i },
},
{
{ -2.193137e+00-2.451191e+00i, -9.502819e+00-6.482575e+00i, -1.844927e-01-7.707215e+00i, +3.620775e+00-5.209770e+00i, +2.805892e-01+2.395717e-01i },
{ +2.895574e+00+2.120744e+00i, -2.754873e+00+1.191826e+01i, -9.417203e+00+7.212299e+00i, -4.624851e+00-1.877728e+00i, -5.865344e-01+2.479032e-02i },
{ +4.186531e+00-2.264570e+00i, +8.653898e+00-1.052560e+00i, +7.363352e+00+7.570365e-01i, +2.328947e+00+2.890545e+00i, -1.956846e-01+3.741973e-01i },
{ +6.767368e-02+2.513931e-01i, -3.836316e+00-7.350885e-01i, -3.346022e+00-4.895370e+00i, +4.182180e-01-1.692791e+00i, -1.061828e-01-2.199022e-01i },
{ +6.186514e-01-1.396464e-01i, +1.431419e+00+1.061057e+00i, +5.988054e-01+1.826156e+00i, -8.600772e-02+8.416703e-01i, -8.056925e-02+1.016914e-01i },
},
{
{ +1.145082e-01+3.873829e-01i, -9.629270e-01+8.063893e-02i, -1.468435e+00-2.696220e-01i, -2.731439e-01-1.942966e-01i, -1.359680e-02+4.917998e-02i },
{ -4.118830e-04-4.563093e-03i, +3.293292e-01+1.340297e+00i, -3.600916e-01+2.337681e+00i, -4.506222e-01+5.019438e-01i, +1.690760e-02+3.692651e-02i },
{ -7.408615e-01+1.512432e-02i, -7.032511e-02-6.494967e-01i, +1.295552e+00+4.299844e-02i, +3.215319e-01+3.047988e-01i, +1.335195e-02-1.511821e-02i },
{ -1.866055e-02+3.121020e-01i, -5.069581e-01+2.561779e-01i, -3.344076e-01-2.393951e-01i, -1.509716e-02-8.017589e-02i, -1.694058e-02-1.646170e-02i },
{ +1.019880e-02-9.576785e-02i, +2.073672e-01-5.699936e-02i, +1.877739e-01+9.893727e-02i, +2.770149e-02+6.277736e-02i, -7.652545e-04+4.595156e-03i },
}
},
{// coil48
{
{ -1.606582e+01-5.609698e+00i, -2.691940e+01-6.233093e-01i, -1.306973e+01+7.535213e+00i, +1.522083e+00+2.968617e+00i, +1.313540e-01-1.123307e-01i },
{ -6.450325e+00-2.547876e+01i, -2.124404e+01-2.991712e+01i, -1.452308e+01-1.026198e+01i, -1.039312e+00+2.310659e+00i, +1.494133e-01-4.489412e-01i },
{ +1.077085e+01-4.249410e+00i, +1.750238e+00-8.545924e+00i, +2.149744e-01-5.254086e+00i, -1.152634e+00+2.817079e-01i, +5.791783e-04-4.854691e-02i },
{ -6.670932e-01+1.676017e+00i, -1.822610e+00+2.814225e-01i, -1.557143e+00+1.258111e+00i, -4.578154e-02-1.658911e-01i, +8.407366e-02+1.373859e-01i },
{ +6.771321e-01-1.289675e+00i, +1.309989e+00-9.468021e-01i, -4.211396e-03-5.602562e-02i, -1.410701e-01-1.687397e-01i, -1.251097e-02+5.275644e-02i },
},
{
{ -1.975407e+01+3.382124e+01i, -1.690719e+01+3.325974e+01i, -4.237874e+00+1.209326e+01i, +3.726822e+00-9.420350e-01i, -5.246154e-01-4.087412e-01i },
{ -5.734666e+01+3.212460e+00i, -6.460429e+01-1.734111e+00i, -2.208295e+01-2.875428e+00i, +2.025999e+00+2.844962e+00i, -7.222027e-02-1.301382e+00i },
{ -1.331916e+01-8.715178e+00i, -1.721830e+01-1.143492e+01i, +3.761959e-02-8.343415e+00i, -1.181033e+00+2.401415e+00i, +1.628708e-01-8.770798e-01i },
{ -2.728370e+00+2.575743e+00i, -5.267611e+00+4.384179e+00i, +3.134693e+00+1.845679e+00i, +5.155449e-01+3.913932e-01i, +6.352651e-02-2.471475e-01i },
{ +2.916666e-01-2.117074e+00i, -2.112825e-01-2.802121e+00i, -2.727981e-01-7.342560e-01i, -1.219138e-01+5.804233e-03i, -4.078291e-02+1.427993e-02i },
},
{
{ +1.522180e+01+6.172955e+00i, +5.321019e+00-1.290884e+00i, -1.230339e+00+1.238794e-01i, -4.087400e-02-1.509688e+00i, -7.041332e-01+3.970213e-01i },
{ +1.178200e+00+2.499842e+01i, -2.566938e+00+9.528530e+00i, -4.731280e+00-2.456834e+00i, +1.110161e+00+4.313254e-02i, -4.249378e-01-1.126621e-01i },
{ -5.419981e+00+1.288920e+01i, +8.175545e-01+6.915464e+00i, -5.810442e-01-4.906098e+00i, -9.087903e-01+8.261646e-01i, -9.061027e-02-5.776360e-01i },
{ -7.725866e-01+2.337919e+00i, +2.705114e-01+4.060903e+00i, +3.101926e+00-2.043163e+00i, +2.377909e-02+5.107188e-02i, -1.799639e-01-3.088694e-01i },
{ -1.825744e-01-8.759438e-02i, -1.088193e+00-4.034562e-01i, -2.800943e-01-3.462752e-01i, +9.907915e-02+1.153242e-01i, -4.284434e-02-1.997979e-02i },
},
{
{ -3.522578e+00-6.849957e+00i, -5.700934e+00+1.277895e+00i, +1.482293e+00+2.299693e+00i, +1.148754e-01-1.784073e-01i, +1.153354e-01+2.991042e-01i },
{ +4.971249e+00-7.918545e+00i, -2.813685e+00-4.315850e+00i, -1.195851e+00+1.325500e+00i, +4.773427e-01-5.921331e-02i, +3.597989e-02+4.151886e-01i },
{ +5.200617e+00-1.485307e+00i, +1.513769e+00-2.643202e+00i, -2.846214e+00+9.431934e-02i, +3.260881e-03+2.074713e-01i, -9.917478e-02+1.072453e-01i },
{ +1.163897e+00-1.353314e-01i, +1.041825e+00-2.425580e-01i, -4.804013e-01-8.325692e-01i, -1.380408e-01+1.077335e-01i, -1.019225e-01-1.372714e-02i },
{ +1.908242e-01+1.903172e-01i, +4.022795e-03+1.176683e-01i, -3.829453e-02-4.021990e-02i, +6.514261e-02+2.932298e-02i, -1.207270e-02-3.485091e-03i },
},
{
{ +5.675313e-01+1.828447e+00i, +2.249050e+00+8.276594e-01i, +7.330388e-01-1.286877e+00i, -2.850337e-01-2.849117e-01i, +1.127174e-02-1.238448e-02i },
{ -1.615607e+00+2.275395e+00i, +5.435493e-01+2.907378e+00i, +1.182693e+00+6.971097e-02i, -3.265993e-02-2.554977e-01i, +4.289356e-02-8.831844e-04i },
{ -1.648076e+00+1.680449e-01i, -9.552956e-01+1.016842e+00i, +5.137638e-01+4.656558e-01i, +1.623804e-01-7.139645e-02i, +2.003769e-02-4.787846e-04i },
{ -2.122571e-01-1.192087e-01i, -2.609539e-01+6.832202e-02i, +5.570818e-02+2.612114e-02i, +5.104930e-02+1.651958e-03i, -4.952806e-03-1.783319e-03i },
{ -1.560377e-02-1.327332e-02i, -6.346998e-02-1.293882e-02i, -1.433000e-02+1.730434e-03i, +1.011649e-02+2.329200e-03i, -1.112620e-03-8.275128e-04i },
}
},
{// coil49
{
{ +6.022537e+00+1.186481e+01i, +1.156060e+01+1.557086e+01i, +8.291204e+00+5.093907e+00i, -3.423318e-01-1.277979e+00i, +3.448832e-01+3.052651e-01i },
{ -1.230685e+01+1.079649e+01i, -1.078771e+01+2.227497e+01i, -1.752730e+00+8.917318e+00i, -2.143233e-01-2.050112e+00i, -6.395010e-01+4.644220e-01i },
{ -5.152100e+00-4.372226e+00i, -7.443504e+00+3.830312e+00i, -3.143801e+00+1.522011e+00i, +1.314960e+00-7.212734e-02i, -2.500612e-01-5.839370e-03i },
{ -3.447236e-01-1.749777e+00i, +5.545828e-01-8.603835e-01i, -2.299544e-02+1.965121e+00i, -3.307082e-01+1.195976e-01i, +2.425715e-01+4.133821e-03i },
{ -3.306716e-01-8.550996e-01i, +1.992123e-01-1.161035e+00i, -1.701587e-02+1.557374e-01i, -1.756981e-01+6.154669e-02i, +4.731682e-02+2.831368e-02i },
},
{
{ +1.238810e+01-9.484365e+00i, +1.842915e+01+1.426992e+00i, +8.028169e+00+3.965842e+00i, -4.839752e-01-1.242053e+00i, +3.605594e-01+3.693840e-01i },
{ +2.647461e+01+9.557455e+00i, +1.169260e+01+2.535803e+01i, -3.805193e+00+1.253226e+01i, -1.914978e-02-3.497138e-01i, -8.716219e-01+8.019845e-01i },
{ +9.773937e+00+1.809344e+01i, +2.641083e+00+1.379294e+01i, -3.336405e+00-3.408755e+00i, +1.833173e+00+2.250412e-01i, -9.161886e-01-3.648317e-02i },
{ -3.565110e+00+3.669989e+00i, -5.353052e-01+5.932873e+00i, +2.186789e+00-4.581503e-01i, +7.826925e-01-5.751382e-01i, -1.370684e-01-1.306821e-02i },
{ -4.296713e-01-8.865024e-01i, -1.707080e+00-8.442148e-01i, -9.415004e-01+2.473170e-01i, -4.449251e-02+1.209363e-01i, -3.227902e-03+8.121987e-02i },
},
{
{ -8.782049e+00+2.415919e-01i, -1.742247e+00+3.428254e+00i, +1.438418e+00+2.524097e+00i, +8.566043e-01-1.489103e+00i, -1.774630e-01+2.666501e-01i },
{ +3.712907e+00-2.005622e+01i, -3.096539e+00-8.296146e+00i, -6.117000e+00+4.097246e+00i, +9.074934e-01-7.548332e-02i, +3.445864e-02+2.532304e-01i },
{ +1.889042e+01-6.171257e+00i, +1.266220e+01-1.122100e+01i, -2.812449e+00-4.723623e+00i, -1.931577e-01+1.064316e+00i, -3.318329e-01+5.542809e-02i },
{ +2.202995e+00+3.897850e+00i, +4.434882e+00+4.666277e+00i, +9.876741e-01-2.458603e+00i, +4.167233e-01-6.101800e-01i, -3.086551e-01+1.656121e-01i },
{ +1.681665e-01-9.579421e-01i, -1.242271e+00+8.111206e-02i, -8.352963e-01+3.066984e-01i, +9.472226e-02-2.457368e-02i, -2.449812e-02+7.948144e-02i },
},
{
{ +4.581579e+00+5.367840e+00i, +5.170052e+00-1.733255e-01i, +9.948015e-01-1.316821e+00i, +2.344842e-01-6.873262e-01i, -1.783064e-01+8.402418e-02i },
{ -7.369370e+00+4.152932e+00i, -2.852237e+00+4.442681e+00i, -1.781762e-01+1.710913e+00i, +1.497917e-01-6.821008e-01i, +1.473148e-01-9.091371e-02i },
{ -4.905143e+00-5.387298e+00i, -3.306317e+00-2.649166e+00i, -1.765099e+00+1.622765e+00i, -4.629035e-01+2.772329e-01i, +1.506026e-01+3.173487e-02i },
{ +6.650273e-01-1.139131e+00i, +1.517986e+00-5.524117e-01i, -1.696808e-01-2.716235e-01i, +3.501326e-04-3.832427e-02i, -2.105835e-02+1.045906e-01i },
{ -2.762454e-01-3.337358e-01i, -4.376525e-01+1.224776e-01i, -1.967372e-01+1.314232e-01i, +2.238432e-02-4.178631e-02i, +9.857051e-04+2.023120e-02i },
},
{
{ -3.774409e-01-1.527918e+00i, -1.198094e+00-1.116320e+00i, -7.364746e-01+1.722943e-01i, -3.676254e-02+1.015637e-01i, -1.027741e-02+2.305054e-02i },
{ +1.875814e+00-8.612400e-01i, +1.246150e+00-1.436199e+00i, +1.593157e-01-4.211972e-01i, +1.586974e-02+4.253379e-02i, -3.810853e-03-7.033302e-03i },
{ +1.014278e+00+1.101545e+00i, +9.632495e-01+3.617992e-01i, +3.213703e-01-2.590244e-01i, +8.088782e-03-2.320237e-02i, +5.103992e-04-1.452954e-02i },
{ -2.503977e-04+3.835034e-01i, +9.282283e-02+2.974455e-01i, +1.458305e-02-7.059929e-02i, +1.584155e-02-3.520082e-02i, -2.604674e-03+2.968269e-03i },
{ -2.980916e-03+5.502735e-02i, -1.016149e-02+8.045415e-02i, -6.492301e-04+1.660346e-02i, +4.401560e-03-6.344656e-03i, -1.860675e-04+9.767254e-04i },
}
},
{// coil50
{
{ -1.549777e+01+5.678483e+00i, -1.568748e+01-1.134061e+01i, -2.169891e+00-4.266401e+00i, +7.781128e-01+1.594767e+00i, -4.040219e-01-1.195569e-01i },
{ -2.220094e+01-2.725304e+01i, -3.322943e+00-3.497673e+01i, -2.405415e-01-4.883188e+00i, -1.077500e+00+2.151235e+00i, +6.695522e-01+1.123375e-01i },
{ +9.740113e+00-2.070672e+01i, +1.367032e+01-1.479263e+01i, +4.939701e+00-1.541216e+00i, +1.442423e-01-3.230619e-01i, +2.320502e-01-3.193603e-01i },
{ +6.214723e+00+4.800912e+00i, +4.641322e-01+3.960915e+00i, +1.922349e+00+4.078593e-01i, +5.548091e-01+1.375231e+00i, -2.244144e-01-2.646725e-01i },
{ -4.112719e-01+2.676621e-01i, -1.387103e+00+1.234714e-01i, -6.186906e-01-5.203659e-01i, +1.394892e-02-8.194719e-02i, -3.150951e-02-6.602100e-02i },
},
{
{ +1.947670e+00+1.774302e+01i, -1.568711e+01+1.264177e+00i, -5.201567e-01-5.977502e+00i, +1.515781e+00+3.675530e-01i, -2.837392e-01-5.463208e-01i },
{ -5.526506e+01+2.788483e+01i, -4.063697e+01-1.046883e+01i, -8.288879e-01-7.505522e-01i, -1.398585e+00+2.508435e+00i, +1.443256e+00-3.428820e-01i },
{ -4.534526e+01-1.942272e+01i, -2.581716e+01-2.532935e+01i, -5.067841e+00-2.150098e+00i, -3.271640e+00-2.852757e+00i, +1.088943e+00-1.557959e-01i },
{ +3.695430e+00-9.221777e+00i, +5.057318e+00-8.625395e+00i, +3.149177e+00-1.334377e+00i, +1.041043e-02+2.006178e-01i, +1.602107e-01-9.181677e-02i },
{ -4.937564e-01+1.324225e+00i, +3.125836e-03+2.047272e+00i, -8.582094e-02+7.127882e-01i, -1.326284e-02+2.893879e-02i, +2.553628e-02-5.460969e-02i },
},
{
{ +3.839101e+00-9.925917e+00i, +2.981557e+00-7.062055e+00i, -2.266973e-01-4.386389e+00i, -9.632779e-01+8.889899e-01i, +7.204756e-02-7.340494e-01i },
{ +1.619456e+01+2.115984e+01i, +7.447527e+00+1.786003e+01i, +8.303783e+00+4.894367e+00i, +8.935890e-01+2.864654e+00i, +4.402176e-02-4.949663e-01i },
{ -1.346476e+01+2.720772e+01i, -2.178058e+01+2.129025e+01i, -6.274171e+00+5.857082e+00i, -1.575104e+00+1.356509e-01i, +3.884216e-01-1.761621e-01i },
{ -7.435923e+00-2.358433e+00i, -5.620793e+00-7.077776e+00i, -1.386370e+00-8.750167e-01i, -1.350568e+00-2.582620e-01i, +3.809634e-01-1.151293e-01i },
{ +5.045398e-01+8.077883e-01i, +1.942758e+00+8.340989e-01i, +9.630312e-01+6.361705e-01i, +1.372566e-03+8.654939e-02i, +5.967082e-02-3.166360e-02i },
},
{
{ -7.959676e+00+1.167630e+00i, -4.602192e+00+3.354147e-01i, -2.378524e+00-5.108287e-01i, -5.708746e-01+7.453756e-01i, +1.884888e-02-2.538274e-01i },
{ +1.030107e-01-1.034475e+01i, +2.573762e+00-7.137888e+00i, +2.440191e+00-3.164640e+00i, +6.687236e-01+6.085117e-01i, -1.795614e-01-1.156429e-01i },
{ +8.731782e+00-3.587078e-02i, +6.031769e+00+1.921659e+00i, +3.254106e+00-6.875179e-02i, +9.920425e-01+5.057346e-01i, -3.823726e-02-8.674768e-02i },
{ -2.527096e-01+2.130780e+00i, -1.505456e+00+8.287828e-01i, -2.751471e-01+5.562094e-01i, -2.757302e-01+2.087309e-01i, +7.582220e-02-8.306950e-02i },
{ +2.456051e-01-1.697929e-01i, +5.323110e-01-3.667678e-01i, +3.284385e-01-3.898036e-02i, +8.142088e-03+3.722233e-02i, +1.159474e-02-9.207122e-03i },
},
{
{ +1.779351e+00+3.283884e-01i, +1.486145e+00+7.696539e-01i, +3.601404e-01+1.906974e-01i, +8.567637e-02-2.032341e-02i, -1.095932e-02-4.994402e-03i },
{ +1.926058e-01+3.054348e+00i, -7.767402e-01+2.946271e+00i, -7.041691e-01+3.783548e-01i, -1.237664e-01-3.200033e-02i, -4.543177e-02-1.596360e-02i },
{ -1.707780e+00+1.042011e+00i, -1.871227e+00+5.674489e-01i, -7.741784e-01-7.571015e-02i, -1.699653e-01-4.042272e-02i, -1.124005e-02-2.544642e-02i },
{ -3.778743e-01-3.349923e-01i, -2.139862e-01-4.546494e-01i, -5.521715e-03-9.569206e-02i, -3.508064e-02-2.880244e-02i, +1.207308e-02-1.072825e-02i },
{ -2.790106e-02+5.421473e-05i, +1.796656e-03-6.566652e-03i, +1.386715e-02+1.097510e-03i, +1.701361e-03+5.019979e-04i, +1.943126e-03-4.099799e-04i },
}
},
{// coil51
{
{ +3.557772e+00-1.183762e+01i, +1.487527e+01-8.179625e+00i, +2.594387e+00-1.755862e+00i, -9.261767e-01-1.459248e+00i, +4.018740e-02+4.962718e-03i },
{ +1.692427e+01-1.184424e+01i, +3.063545e+01-1.016931e+00i, +8.061845e+00+4.695768e-01i, -9.228313e-01-1.298892e-01i, -3.217482e-01+6.051365e-01i },
{ +1.198282e+01-5.699071e+00i, +1.695205e+01+4.870143e+00i, +1.200073e+00+6.876558e+00i, -1.346295e+00+5.649525e-01i, +2.150083e-01+1.954078e-01i },
{ +5.157957e+00+9.869925e-01i, +3.239018e+00+4.061586e+00i, -2.196548e+00+2.623142e+00i, -1.144633e+00-3.891767e-01i, +1.482326e-01-7.028739e-02i },
{ -4.294583e-01+1.010237e+00i, -8.099890e-01+1.814896e-01i, +2.548225e-01-2.419972e-01i, +1.043584e-01+1.151886e-01i, +5.032056e-02-1.740382e-02i },
},
{
{ -1.544898e-01-1.008587e+01i, +1.254248e+01-1.816302e+01i, +4.826031e+00+1.552080e+00i, -1.595188e+00-1.569414e-02i, +2.876236e-01+3.959924e-02i },
{ -5.572224e+00-1.915750e+01i, +2.123483e+01-2.892814e+01i, +7.256515e+00-8.077508e+00i, -1.699793e-01-1.942722e+00i, +2.599989e-01+1.034896e+00i },
{ -1.486410e+01-2.237251e+01i, +7.716635e+00-3.173081e+01i, +8.897017e+00-6.606008e+00i, +2.047021e+00-1.995766e-02i, +5.828750e-01+6.730770e-01i },
{ -4.721570e-02-9.891651e+00i, +8.854698e+00-6.541425e+00i, +2.306685e+00+3.165755e+00i, -1.181808e+00-6.002524e-02i, +2.132478e-01+1.832814e-01i },
{ +2.268272e-01+5.613078e-01i, -4.539236e-01+1.125787e+00i, -2.169723e-01+2.137537e-01i, +3.790018e-02-7.080662e-02i, +7.552746e-02+3.656112e-02i },
},
{
{ +2.197271e+00-7.831196e-01i, +5.640203e+00-1.583517e+00i, +3.706883e+00+2.295481e+00i, -1.057565e+00-1.927239e-01i, +4.895123e-01+1.383279e-01i },
{ +1.631241e+00+6.586295e+00i, -2.436752e+00+5.415520e+00i, -7.813252e+00+2.565476e+00i, -2.317364e+00-1.539644e+00i, +3.252771e-01+1.949143e-02i },
{ -1.083867e+01+1.173361e+01i, -2.068967e+01-4.215571e+00i, -5.002238e+00-9.521758e+00i, +1.602136e+00-7.237675e-01i, +1.356161e-02-8.010380e-02i },
{ -6.542878e+00+4.251736e-01i, -3.750693e+00-4.876706e+00i, +1.079601e+00-2.359851e+00i, +1.843176e-01-4.708767e-02i, +7.663787e-02+8.790753e-02i },
{ +1.386980e-01-3.429369e-01i, +1.673619e-01+6.430082e-01i, -2.532761e-01+5.317101e-01i, -1.440580e-01-8.451074e-02i, +4.320293e-02+4.296460e-02i },
},
{
{ -2.430562e+00-1.137873e+00i, -1.322135e-01-2.673917e+00i, +1.784078e+00-9.390427e-01i, -4.924285e-01-1.522947e-01i, +2.157523e-01-4.161413e-02i },
{ +2.258140e+00-6.066314e+00i, +6.779016e+00-9.576544e-01i, +9.380646e-01+4.091611e+00i, -1.485297e+00+2.722830e-01i, +1.696170e-01-5.291845e-02i },
{ +6.885658e+00+1.039962e-01i, +4.578259e+00+5.779912e+00i, -1.537348e+00+2.843940e+00i, -3.290185e-01+2.531411e-01i, -8.107604e-02+6.041364e-02i },
{ +9.829778e-01+1.823591e+00i, -3.757886e-01+1.641997e+00i, -5.327539e-01-3.709096e-01i, +1.797476e-01-8.119494e-02i, -1.473045e-02+2.854956e-02i },
{ +3.699904e-02-2.018578e-01i, +1.689452e-01+6.392521e-02i, -1.348031e-02+1.879522e-01i, -5.773392e-02+7.889729e-03i, +7.215450e-03+1.124421e-02i },
},
{
{ +2.251280e-01+1.031774e+00i, -7.501597e-01+6.532213e-01i, -5.601077e-02+4.586938e-02i, +8.071764e-02+1.338387e-01i, -1.261472e-02-1.641854e-02i },
{ -1.965270e+00+1.315904e+00i, -2.582664e+00-4.847500e-01i, -2.233607e-02-6.588149e-01i, +9.855095e-02+2.800924e-02i, +1.454172e-02-5.838691e-02i },
{ -1.912411e+00-1.316528e-01i, -1.517350e+00-1.462409e+00i, +7.777292e-02-8.446636e-01i, +6.714359e-02-9.079435e-02i, +2.881868e-02-2.505592e-02i },
{ -3.667954e-01-3.167052e-01i, -9.083932e-02-5.287718e-01i, +5.765641e-02-1.833735e-01i, +1.582952e-02-3.162967e-02i, +1.066254e-02+1.959651e-03i },
{ -3.858455e-02-4.412755e-02i, -6.708016e-03-3.691505e-02i, -4.989989e-04+1.587139e-03i, -4.598206e-03-3.513976e-03i, +1.813318e-03+9.683419e-04i },
}
},
{// coil52
{
{ +1.338523e+01-2.980719e+01i, -2.134910e+01-3.554764e+01i, -1.232655e+01+5.653865e+00i, +3.378029e+00+5.848421e-01i, -1.291686e+00+1.242771e-01i },
{ +3.585677e+01+9.881643e+00i, +3.955396e+01-4.251892e+01i, -8.536860e+00-2.027892e+01i, -1.377011e+00+3.282117e+00i, -9.178491e-01-8.850001e-01i },
{ -7.492119e+00+1.242758e+01i, +1.653550e+01+1.144232e+01i, +7.517870e+00-5.762980e+00i, -1.318116e+00-9.111845e-02i, +5.311940e-01-6.238514e-01i },
{ +8.723260e-01-5.617837e+00i, -4.128446e+00-1.958225e+00i, -5.829191e-01+1.769379e+00i, -1.747006e-01+2.494127e-02i, +9.582686e-02+1.260015e-01i },
{ -3.836444e-01+2.229538e+00i, +1.866609e+00+1.416785e+00i, +9.472466e-01-6.130151e-01i, -3.356186e-02-1.274484e-01i, +3.581024e-02-2.495563e-02i },
},
{
{ -2.552070e+01-3.409374e+01i, -2.354356e+01-1.926242e+01i, -8.781528e-01+1.528028e+00i, +2.919362e+00-6.545057e-01i, -5.456776e-01-9.054624e-01i },
{ +3.436372e+01-4.364355e+01i, +2.103455e+01-6.398807e+01i, -5.912727e+00-1.518170e+01i, -1.255245e+00+2.763634e+00i, +1.858441e-01-1.955671e-01i },
{ +9.189426e+00+9.478643e+00i, +2.317429e+01-3.748681e+00i, +4.566247e+00-8.707438e+00i, -1.943265e+00+1.724129e-01i, +6.862169e-01-1.652365e-01i },
{ -4.332333e+00-4.822785e+00i, -4.298525e+00+4.732545e-02i, +1.089343e+00+1.653432e+00i, -1.209951e-01-4.217341e-01i, +1.474762e-01+1.349171e-01i },
{ +1.985981e+00+2.212003e+00i, +2.403942e+00+3.570530e-01i, +1.774690e-01-3.650078e-01i, -3.829823e-02+5.346119e-02i, +1.426810e-02+1.879025e-03i },
},
{
{ -1.940356e+01+1.646938e+01i, +1.256205e+01+3.666159e+00i, -2.370723e+00-8.818044e+00i, -4.632468e-01+2.882456e+00i, -6.739634e-02-2.013180e+00i },
{ -1.751122e+01-2.537080e+01i, -8.849780e+00-8.281815e+00i, -2.135105e-01-3.518535e+00i, -2.263739e+00+2.419269e+00i, +1.419140e+00-7.373965e-01i },
{ +7.971577e+00-7.585777e+00i, -4.920362e-01-1.191238e+01i, -2.173023e+00-2.543362e+00i, -9.925656e-01+3.486886e-01i, +5.935850e-01+2.901646e-01i },
{ -1.903533e+00+1.941705e+00i, +1.506310e+00+1.078785e+00i, +1.418193e+00-7.583936e-01i, -1.773720e-01-7.359747e-01i, +9.264469e-03+6.981438e-02i },
{ +1.301218e+00-6.787832e-01i, -1.345498e-01-5.297085e-01i, -1.983355e-01+6.211221e-01i, +1.058624e-01+8.731265e-02i, -5.480928e-03+4.514249e-02i },
},
{
{ +5.347331e-01+8.563040e+00i, +7.498090e+00-5.990156e-01i, -1.700908e+00-3.370624e+00i, -7.642269e-03+1.141868e+00i, -1.476105e-01-6.469426e-01i },
{ -8.581184e+00+2.527519e+00i, +9.787933e-01+6.567002e+00i, +2.318498e+00-1.461670e+00i, -9.995908e-01+6.614077e-01i, +4.142357e-01-4.324206e-01i },
{ +1.985779e-01-2.671342e+00i, -2.663258e+00-2.422090e-01i, -3.248242e-01+1.597709e+00i, -9.924853e-02+3.100543e-01i, +1.939178e-01+8.659472e-02i },
{ +6.376063e-01+9.460791e-01i, +9.628125e-01-1.498913e-01i, -6.104851e-02-5.078131e-01i, -1.164230e-01-1.829314e-01i, -1.936340e-02+2.901800e-02i },
{ -6.359767e-02-4.211197e-01i, -3.593301e-01+5.221469e-02i, +9.721754e-02+2.839140e-01i, +5.013826e-02-1.105013e-02i, -2.451708e-03+1.859234e-02i },
},
{
{ -1.647987e-01+7.177786e-01i, +8.088616e-01+5.445226e-02i, -2.826291e-02-4.583881e-01i, -4.309195e-02+6.671432e-02i, -1.639213e-02-5.959972e-02i },
{ -8.928099e-01-5.279689e-01i, -2.564272e-01+7.799271e-01i, +5.847312e-01+6.659545e-02i, -3.084645e-02-5.517855e-02i, +4.225760e-02-1.609297e-02i },
{ +1.866279e-01-6.091689e-01i, -4.673214e-01-9.999289e-02i, +5.702798e-02+3.479334e-01i, +6.679784e-02-1.841684e-02i, +1.512159e-02+1.828990e-02i },
{ +4.227575e-02+6.698552e-02i, +5.364456e-02-9.306329e-02i, -6.209309e-02-4.852447e-02i, -7.262517e-03-1.304397e-03i, +7.610628e-05+2.116426e-03i },
{ +4.017551e-03-4.040097e-02i, -2.852866e-02+4.204573e-03i, +9.949365e-03+2.413847e-02i, +2.665831e-03-1.640906e-03i, -4.953668e-04+2.705685e-03i },
}
},
{// coil53
{
{ +8.307780e+00-3.075192e+01i, -4.021068e+01-2.041585e+01i, -5.465803e+00+1.602099e+01i, +4.947190e+00-4.871884e+00i, -1.756705e+00+1.487060e+00i },
{ +2.825365e+01-3.982936e+00i, -1.041123e+01-4.612150e+01i, -2.581811e+01+5.417552e+00i, +5.922345e+00+3.790992e+00i, -2.067410e+00-2.585875e-01i },
{ +1.826451e+00+7.938425e+00i, +1.434980e+01-8.214870e+00i, -4.763573e+00-7.988034e+00i, -2.889752e-01+3.642032e+00i, -7.019669e-02-1.211933e+00i },
{ +2.998456e-01-1.398667e-01i, +4.569303e-01+8.511363e-01i, +3.449206e+00-1.710783e+00i, -8.492536e-01+4.129682e-01i, +1.791459e-01-2.640206e-01i },
{ -9.276758e-01+1.455330e+00i, +6.855170e-02+1.961773e-01i, +1.118720e-01-5.416545e-01i, -5.028558e-02+2.236631e-01i, +3.406987e-02-8.411106e-02i },
},
{
{ -3.442060e+01-3.378841e+01i, -5.305223e+01+6.118550e+00i, +5.102618e+00+8.946213e+00i, -2.353869e+00-5.329298e+00i, +1.130702e-01+1.143080e+00i },
{ +3.825731e-01-3.702277e+01i, -5.143607e+01-2.928398e+01i, -1.809524e+01+1.741736e+01i, +2.846075e+00-5.703726e-01i, -4.964261e-01+1.116110e+00i },
{ +6.683583e+00+2.043468e+00i, -1.157094e+00-4.101982e+00i, -1.090492e+01+6.890246e-01i, +9.929521e-01+1.407797e+00i, +5.551782e-02-4.078567e-01i },
{ +4.632210e-01-1.369101e+00i, -1.387216e+00-5.973327e-01i, +6.083106e-01-4.379846e-01i, -5.373048e-01-1.020789e-03i, +8.766864e-02-7.920592e-02i },
{ +8.202236e-01+1.830565e+00i, +1.522004e+00-2.565219e-02i, -1.283417e-01-3.617654e-01i, +1.814070e-01+3.289784e-01i, +1.313305e-02-1.081982e-01i },
},
{
{ -1.882391e+01+7.902017e+00i, -3.490797e+00+1.034006e+01i, -1.645459e+00-5.988915e-01i, -1.090507e+00+4.268178e+00i, +3.946196e-01-1.499141e+00i },
{ -2.602417e+01-6.339408e+00i, -2.048599e+01+1.549877e+01i, +2.330257e+00+5.083186e+00i, -9.629051e-01+2.448382e+00i, +1.156811e+00-6.161456e-01i },
{ -5.260762e+00-4.798346e+00i, -1.110733e+01+8.970320e+00i, -1.189330e-01+2.910635e+00i, -8.900940e-01-1.573787e+00i, +7.739631e-01+4.043250e-01i },
{ -1.203353e-01-2.048296e+00i, -2.314600e+00-1.782596e-01i, -7.378100e-01+2.333584e+00i, -4.659467e-01-1.011022e+00i, +8.341314e-02+3.217010e-01i },
{ +7.128162e-01-2.756032e-01i, +8.501010e-01-5.887279e-01i, +2.890968e-02+9.079210e-02i, +1.469681e-01+4.341438e-02i, +5.601489e-03-1.289939e-02i },
},
{
{ +3.308908e+00+5.172119e+00i, +3.358328e+00-3.505848e+00i, -4.337698e+00-1.136835e+00i, +1.211188e+00+1.603652e+00i, -3.300433e-01-7.584050e-01i },
{ -2.000497e+00+6.653309e+00i, +6.062697e+00+1.611446e-01i, -4.469600e-01-5.058384e+00i, -6.940036e-01+1.820554e+00i, +2.037354e-01-7.664368e-01i },
{ -2.213009e+00+6.247058e-01i, +2.990387e+00+2.186940e+00i, +4.229856e+00-1.417106e+00i, -9.876745e-01+8.301729e-02i, +4.294405e-01+7.985778e-03i },
{ -4.901663e-01-5.094352e-01i, -2.722456e-01+1.165145e-01i, +7.517792e-01+6.055195e-01i, -2.664151e-01-3.771874e-01i, +8.293691e-02+1.300966e-01i },
{ -1.064933e-01-2.261331e-01i, -3.086396e-03-6.842493e-02i, +1.095802e-01+6.719431e-02i, +7.524118e-03-1.999600e-02i, +6.602624e-03+1.046836e-02i },
},
{
{ -9.263206e-02+3.429188e-01i, +5.660884e-01+1.120369e-01i, -1.667877e-01-1.286787e-01i, -8.562744e-03+1.376429e-01i, -2.492154e-02-5.357571e-02i },
{ -9.332548e-01-1.445545e-01i, -3.035899e-01+8.325622e-01i, -1.216287e-01-1.314243e-01i, -1.813295e-01+1.268652e-01i, +4.372842e-02-3.718194e-02i },
{ -3.248992e-01-3.842323e-01i, -5.497310e-01+4.013928e-01i, -2.099104e-02+1.255740e-01i, -1.082698e-01-1.874726e-02i, +4.675268e-02+1.389104e-02i },
{ -3.289882e-03-6.127898e-02i, -1.105320e-01-2.803579e-02i, -6.531650e-02+5.984995e-02i, -2.757391e-02-3.927955e-02i, +7.301429e-03+1.163366e-02i },
{ +1.365117e-02-1.558135e-02i, +1.505399e-02+2.517641e-03i, +4.046722e-03+2.692024e-03i, +6.234157e-05-5.303859e-03i, +2.043134e-04+1.205476e-03i },
}
},
{// coil54
{
{ +1.289688e+01-5.274610e+00i, +6.645244e+00+2.091583e+01i, -1.051348e+01+4.179564e-01i, +2.501171e+00-1.487390e+00i, -1.944146e+00+7.852259e-01i },
{ +2.101001e+01+4.164907e+01i, -4.427781e+01+5.765804e+01i, -1.487796e+01-8.442305e+00i, +4.922857e+00+3.693409e+00i, -1.850960e+00-2.769171e+00i },
{ -1.776128e+01+3.668324e+01i, -4.497085e+01+5.461673e-01i, +5.983198e+00-6.995041e+00i, -1.703054e+00+4.064764e+00i, +1.365864e+00-2.830886e+00i },
{ -1.004336e+01-1.622293e+00i, +1.856584e+00-1.197345e+01i, +4.977783e+00+2.929663e+00i, -2.834156e+00+4.589955e-01i, +9.886236e-01-2.312669e-01i },
{ +1.682356e-02+1.052073e+00i, -8.087475e-01+1.320637e+00i, -5.465537e-01+4.457799e-01i, -6.160468e-02-1.528179e-01i, +5.184387e-02-2.148322e-02i },
},
{
{ +6.504489e+00+3.015474e+00i, +1.422944e+01+2.038493e+01i, -5.249761e+00+8.042421e+00i, -4.517760e-01-8.040413e-01i, -1.144028e+00+8.265251e-01i },
{ +2.920622e+01+6.182094e+01i, -2.678731e+01+1.273293e+02i, -2.768565e+01+1.946277e+01i, +4.122437e+00+2.966514e-01i, -2.621864e+00-1.423425e+00i },
{ +1.488956e+01+5.888072e+01i, -5.914703e+01+7.703642e+01i, -1.546120e+01-4.435225e+00i, +4.279280e+00+3.558905e+00i, -2.054850e+00-3.387829e+00i },
{ +1.366228e+00+1.107867e+01i, -1.217670e+01-2.374774e+00i, +5.182753e+00-5.448424e+00i, -7.283292e-01+4.338498e+00i, -1.755937e-01-1.577896e+00i },
{ -5.548187e-01+2.518862e+00i, -1.281770e+00+8.858857e-01i, +7.567459e-01+3.332982e-01i, -1.908567e-01+2.535971e-01i, +8.096739e-02-2.304819e-01i },
},
{
{ +2.139630e+00+5.532420e+00i, -1.980544e+00-2.676880e+00i, +4.666092e+00+1.128591e+00i, -1.708713e-01+2.728091e+00i, -2.181463e-01-6.166968e-01i },
{ +4.491385e+00+8.772744e+00i, +2.044278e+01+3.128553e+01i, +2.746800e+00+1.917186e+01i, +2.309829e-02-1.303388e+00i, +6.932580e-02+9.365094e-01i },
{ +2.224030e+01-2.769339e+00i, +1.129097e+01+4.736794e+01i, -1.590398e+01+5.692722e+00i, +4.208513e+00-4.207590e+00i, -2.105728e+00+1.016371e+00i },
{ +1.132707e+01+2.813061e+00i, -6.809186e+00+9.396387e+00i, -3.491513e+00-6.324167e+00i, +2.219321e+00+2.027213e+00i, -1.217607e+00-6.028896e-01i },
{ -6.075956e-01+1.363019e+00i, -6.638210e-01-7.269624e-01i, +1.188564e+00-5.014148e-01i, -6.672353e-03+3.779388e-01i, +7.068910e-03-1.853539e-01i },
},
{
{ +5.813264e-01+4.596455e+00i, -6.448458e+00-7.381120e-01i, +1.521957e-02-2.227857e+00i, +4.036219e-01+1.078040e+00i, -1.140461e-01-4.432572e-01i },
{ -7.858425e+00+4.810462e-01i, +1.093984e+00-1.090876e+01i, +3.916664e+00+9.538904e-01i, -1.181160e+00-6.810653e-02i, +7.064900e-01+1.831605e-01i },
{ -1.862181e+00-8.150732e+00i, +1.037299e+01-1.998961e+00i, -1.469860e+00+2.593161e+00i, -5.724621e-02-2.215981e+00i, +1.025558e-01+9.124616e-01i },
{ +1.836937e+00-1.100115e+00i, -3.789335e-01+2.946894e+00i, -2.153152e+00-9.004564e-01i, +7.519549e-01-2.241624e-01i, -3.203855e-01+1.435209e-01i },
{ -2.095041e-01+1.882535e-01i, -1.942236e-01-3.369004e-01i, +2.446142e-01-1.992786e-01i, +2.178608e-02+9.635793e-02i, -9.155604e-03-3.133662e-02i },
},
{
{ +3.137131e-01+5.432759e-01i, -1.078904e-01+8.437309e-02i, +4.668463e-01-4.884948e-02i, -1.957414e-02+1.183835e-01i, +1.295491e-02-6.439403e-02i },
{ -5.278554e-01+3.619049e-01i, +8.597202e-01-3.372667e-01i, +5.669742e-01+1.035427e+00i, -3.937160e-01+8.069409e-02i, +1.279131e-01+1.220689e-02i },
{ +9.034383e-02-6.316467e-01i, +1.382415e+00+6.356364e-01i, -3.535028e-01+1.137435e+00i, -1.642066e-01-1.613564e-01i, +3.505077e-02+1.089863e-01i },
{ +4.219366e-01-2.584298e-02i, +1.376633e-01+5.982112e-01i, -2.306840e-01+6.290039e-02i, +8.907067e-02-3.096358e-02i, -3.393132e-02+2.203903e-02i },
{ +6.105934e-03+9.392516e-03i, +1.260869e-02-1.707488e-02i, +2.627068e-02-3.646348e-03i, +1.353393e-03+1.239687e-02i, -2.290601e-03-2.227315e-03i },
}
},
{// coil55
{
{ -1.296592e+00-1.311684e+01i, +1.791607e+01-5.416767e-01i, +2.201212e+00+7.827680e+00i, -1.453906e+00-1.586874e+00i, +2.700009e-01+6.736609e-01i },
{ +2.692197e+01+2.809788e+00i, +9.796944e+00+3.470936e+01i, -9.156013e+00+5.293627e+00i, +1.776282e+00-2.408349e+00i, -9.911758e-01+1.502084e-01i },
{ +2.511004e+00+2.271366e+01i, -1.614701e+01+1.276552e+01i, -1.162945e+00-3.754911e+00i, +9.184945e-01+1.483485e+00i, -4.134965e-02-6.901482e-01i },
{ -6.924724e+00-1.893977e+00i, +1.502359e+00-4.900983e+00i, +1.872096e+00+2.249372e+00i, -1.052915e+00+1.557655e-01i, +3.099743e-01+1.389657e-01i },
{ +1.600403e+00+5.006032e-02i, +3.281714e-01+1.670818e+00i, -8.094029e-01+1.012478e-01i, +1.410225e-01-1.872340e-01i, -5.101187e-02+4.352819e-02i },
},
{
{ -7.351840e+00-3.570089e+00i, +1.296266e+01-6.909428e+00i, +4.583835e+00+4.539149e+00i, -1.057835e+00-1.710887e-01i, +1.961287e-01+6.925808e-01i },
{ +2.986998e+01-9.665117e+00i, +2.977147e+01+3.678066e+01i, -5.817572e+00+1.301402e+01i, +7.240319e-01-9.978938e-01i, -1.416541e+00+3.328725e-01i },
{ +3.018021e+01+2.560324e+01i, -8.557087e+00+3.682917e+01i, -6.039099e+00-2.587513e+00i, +1.947578e+00+1.548270e+00i, -9.048892e-01-1.452809e+00i },
{ -6.153655e+00+7.674522e+00i, -7.111515e+00-4.148588e+00i, +3.384686e+00-2.847145e+00i, +9.542489e-02+1.167419e+00i, +1.707819e-01-3.424606e-01i },
{ +1.554512e+00-1.663414e+00i, +1.834793e+00+8.247862e-01i, -3.607497e-01+8.431613e-01i, -2.769990e-02-1.185440e-01i, -4.540497e-02+6.416421e-02i },
},
{
{ -8.301864e-01+4.553426e+00i, -4.048882e+00-7.565877e-01i, -1.549324e-01-2.104451e+00i, +1.454024e+00-3.259076e-01i, -2.297494e-01+4.792258e-01i },
{ -6.066781e-01-9.871445e+00i, +1.455347e+01+2.231778e-01i, +4.127543e+00+3.784294e+00i, +8.126955e-01+2.774115e-01i, -4.094301e-01+4.083784e-01i },
{ +1.739640e+01-5.494489e+00i, +1.189010e+01+1.648688e+01i, -3.510945e+00+4.868614e+00i, -6.112558e-01-3.083799e-01i, -6.004682e-01-4.411329e-01i },
{ +1.661784e+00+5.490595e+00i, -5.807104e+00+2.525669e+00i, -9.459149e-01-2.916378e+00i, +4.630651e-01+3.445998e-01i, -1.725185e-01-2.570078e-01i },
{ -3.914265e-01-1.343794e+00i, +9.790872e-01-1.048770e+00i, +5.623512e-01+3.490879e-01i, -3.241566e-02+7.462995e-02i, +5.596866e-03+2.377755e-02i },
},
{
{ +1.890753e+00+1.359222e+00i, -1.987555e+00+2.394454e+00i, -1.555034e+00-9.928042e-01i, +5.123143e-01-6.591296e-01i, -1.292737e-01+1.467115e-01i },
{ -2.548126e+00+6.687810e-01i, -8.757817e-01-3.053021e+00i, +1.217320e+00-1.547929e+00i, +4.063677e-01+6.638944e-03i, -3.577551e-02+9.265499e-02i },
{ -1.093721e-01-3.196685e+00i, +3.820677e+00-2.412924e-02i, +4.303614e-01+1.905720e+00i, -4.046844e-01-3.081674e-02i, -1.964224e-02+6.616819e-02i },
{ +1.049130e+00+4.944510e-01i, -4.776846e-01+1.646096e+00i, -8.478048e-01-9.376663e-02i, +7.407892e-02-7.924874e-02i, -5.960311e-02+1.378373e-02i },
{ -3.140281e-01-1.109374e-01i, +4.619049e-05-3.925770e-01i, +2.156458e-01-4.604311e-02i, +1.457108e-02+3.625896e-02i, +6.200868e-03-4.170929e-04i },
},
{
{ +3.292230e-01+3.306820e-01i, -2.540279e-01+2.973474e-01i, -2.158637e-01-4.790831e-02i, +1.646800e-02+2.788756e-02i, -1.341358e-02+8.504026e-03i },
{ -4.622767e-01+9.495094e-02i, -5.243593e-01-8.029395e-01i, +1.705706e-01-2.331559e-01i, +3.330449e-02+1.363803e-01i, +2.250111e-03-5.602516e-03i },
{ -4.673364e-02-4.365990e-01i, +2.337384e-01-5.338753e-01i, +1.879870e-01-7.763655e-02i, +1.091980e-02-2.110380e-03i, +3.714237e-03-5.697286e-03i },
{ +1.806448e-01+4.934450e-02i, -2.126463e-03+1.144776e-01i, -4.334255e-02-7.917318e-02i, +2.744579e-02-2.266468e-02i, -4.711613e-03-1.622030e-03i },
{ -3.304311e-02-2.354352e-02i, +7.541933e-03-5.614143e-02i, +2.768606e-02-4.195868e-03i, -5.915863e-04+5.437206e-03i, +3.491413e-04-3.381382e-04i },
}
},
{// coil56
{
{ +1.288415e+01+6.113175e+00i, -1.023956e+01+1.480799e+01i, -5.868789e+00-4.207712e+00i, +2.301516e+00+3.535166e-01i, -6.897592e-01-5.402778e-01i },
{ -3.471106e+01+1.110506e+01i, -3.965828e+01-4.852090e+01i, +9.190955e+00-1.854597e+01i, -1.679254e+00+3.597242e+00i, +9.900492e-01-1.068200e+00i },
{ -2.007693e+01-2.917667e+01i, +1.515410e+01-3.964979e+01i, +5.602503e+00+4.040550e+00i, -4.443582e+00-8.357167e-01i, +1.253004e+00+7.883620e-01i },
{ +1.087906e+01-7.599441e-01i, +4.512945e+00+1.029044e+01i, -3.682755e+00+2.426123e+00i, +1.025631e-02-6.088057e-01i, -1.954514e-01-1.028937e-01i },
{ -3.413821e+00+4.259400e-01i, -1.707999e+00-4.070949e+00i, +1.494778e+00-8.371964e-01i, -3.419217e-01+2.551856e-01i, +2.130567e-01-8.265461e-02i },
},
{
{ -2.471602e+00+1.222727e+01i, -3.241931e+01-3.854267e+00i, -3.692434e+00-1.505309e+01i, +2.438442e+00+1.455375e+00i, -2.805281e-01-9.825646e-01i },
{ -8.047604e+01-5.840982e+01i, -2.412997e+01-1.524022e+02i, +2.468233e+01-2.934691e+01i, -4.764606e+00+1.679582e+00i, +2.251351e+00+9.522440e-01i },
{ -7.961859e+00-8.777962e+01i, +5.889250e+01-7.724940e+01i, +9.363501e+00+2.886292e+00i, -2.410356e+00-3.213117e+00i, +4.797611e-01+2.366278e+00i },
{ +1.892739e+01+8.979110e+00i, -4.339584e+00+1.538508e+01i, -1.920933e+00-4.871780e+00i, +2.196677e+00+1.642025e+00i, -8.531550e-01-1.213086e+00i },
{ -5.968343e+00-5.809723e-01i, -1.818735e+00-8.302183e+00i, +3.442139e+00-7.376605e-01i, -8.448813e-01+8.418020e-01i, +3.569292e-01-2.051789e-01i },
},
{
{ -6.673866e+00+1.326471e+01i, -2.286619e+01-8.646652e+00i, +8.435879e-01-1.258963e+01i, +1.105386e+00+1.338727e+00i, +2.743801e-01-7.914824e-01i },
{ -4.437751e+01-4.217411e+01i, +9.301832e+00-8.240108e+01i, +1.497131e+01-2.321255e+00i, -5.265539e+00-2.567863e-02i, +1.931166e+00+1.350478e+00i },
{ +1.030660e+01-4.487624e+01i, +3.821025e+01-1.712398e+01i, -2.103001e+00+7.442461e+00i, +8.986626e-01-3.545599e+00i, -5.254152e-01+1.744769e+00i },
{ +1.004650e+01+1.162118e+01i, -1.218477e+01+9.733974e+00i, -9.236722e-01-9.022301e+00i, +3.019961e+00+1.467721e+00i, -8.912460e-01-1.062744e+00i },
{ -2.757847e+00-9.995701e-01i, +2.024330e-01-4.547534e+00i, +2.371255e+00+3.278148e-01i, -5.586739e-01+6.436371e-01i, +1.776560e-01-1.215836e-01i },
},
{
{ -7.434398e-02+3.962458e+00i, -2.984613e+00-3.173581e-01i, +1.813029e+00-2.710351e+00i, +2.496676e-01+5.101755e-01i, +7.978031e-02-3.161263e-01i },
{ -6.311152e+00+1.332655e-01i, +2.389045e+00-5.164023e+00i, +3.312353e+00+3.187716e+00i, -1.578560e+00+2.008018e-01i, +5.856613e-01-7.862747e-04i },
{ +9.689236e-01-2.676464e+00i, +2.460031e+00+5.493276e+00i, -3.696675e+00+3.910440e+00i, -2.211955e-01-1.131810e+00i, -3.867543e-02+3.233896e-01i },
{ +1.567234e+00+1.729637e+00i, -2.754561e+00+1.962739e+00i, -7.232517e-01-1.758273e+00i, +6.171749e-01+1.277703e-01i, -2.020478e-01-1.492375e-01i },
{ -3.150519e-01-2.789022e-01i, +2.819315e-01-6.193119e-01i, +3.832386e-01+2.222121e-01i, -1.188325e-01+9.536089e-02i, +2.815725e-02-1.500071e-02i },
},
{
{ -1.185036e-01+1.851214e-01i, -6.021494e-01-3.445753e-01i, -4.413356e-02-2.050315e-01i, -2.859369e-02+1.260667e-01i, -2.068304e-03-3.708997e-02i },
{ -6.569360e-01-1.140318e+00i, +5.456687e-01-2.178109e+00i, +7.927294e-01-1.873597e-01i, -1.085444e-01+3.595874e-02i, +6.023920e-02-1.724560e-02i },
{ +3.103621e-01-1.154828e+00i, +1.276307e+00-9.539932e-01i, +5.223506e-01-1.421320e-01i, +7.136463e-02-1.051374e-01i, +1.499598e-02+2.335925e-02i },
{ +1.691985e-01+3.719008e-02i, -1.667643e-02-3.495070e-02i, +9.869301e-02-2.024794e-01i, +6.764218e-02+2.633591e-02i, -1.244274e-02-1.215187e-02i },
{ -3.791713e-02-2.811642e-02i, +2.197633e-02-6.819749e-02i, +3.877978e-02+8.722326e-03i, -7.391032e-03+6.019262e-03i, +2.956396e-03-1.087016e-03i },
}
},
{// coil57
{
{ +1.684760e+01+9.178698e-02i, +1.032118e+01+6.884453e+00i, -2.769384e-01+2.186553e+00i, -4.459631e-01+6.900797e-01i, +1.339018e-04-2.776984e-01i },
{ -2.059716e+01+2.673188e+01i, -3.040129e+01+1.203706e+01i, -6.797762e+00-3.756296e+00i, -5.488949e-01+6.666183e-02i, +4.511605e-01-1.198889e-01i },
{ -1.941992e+01-1.676086e+01i, -1.096600e+01-1.604468e+01i, +1.397907e+00-8.292542e-01i, -1.921017e-01+6.004011e-01i, +2.410238e-01+2.146889e-01i },
{ +1.006111e+01-4.641715e-01i, +6.505762e+00+3.616240e+00i, +6.653075e-01+2.283516e+00i, -3.208752e-01+2.251103e-01i, -4.151757e-02-1.942878e-01i },
{ -4.272467e+00+8.649933e-01i, -3.281190e+00-1.823218e+00i, +2.190282e-01-7.802799e-01i, -8.162558e-02+1.293225e-01i, +9.947535e-02-5.539459e-02i },
},
{
{ +1.453328e+01+2.169924e+01i, -8.428982e+00+2.321996e+01i, -8.035995e+00+2.880739e+00i, -4.817972e-01+5.048258e-01i, +4.414427e-02-5.398226e-01i },
{ -8.287451e+01+2.596482e+01i, -9.007332e+01-2.223475e+01i, -1.597787e+01-1.503318e+01i, -9.938357e-01+3.464127e-02i, +1.190144e+00+2.290016e-01i },
{ -3.353444e+01-4.529173e+01i, -1.538236e+01-4.405233e+01i, +6.952839e-01-4.772610e+00i, +9.708405e-03+2.254767e-01i, +5.355039e-02+5.234706e-01i },
{ +1.685461e+01+6.545009e+00i, +2.678423e+00+1.095200e+01i, -2.015025e+00-3.381205e-01i, +3.751489e-01+4.030230e-01i, -4.090641e-01-5.999819e-01i },
{ -7.117202e+00-7.133696e-01i, -4.381340e+00-5.663378e+00i, +1.492810e+00-1.737735e+00i, -3.825027e-02+4.302388e-01i, +1.543588e-01-9.239514e-02i },
},
{
{ +4.032036e+00+1.782418e+01i, -1.281364e+01+1.804108e+01i, -7.405502e+00+1.898252e+00i, -6.475534e-01-6.467066e-01i, +7.395238e-02-2.202408e-01i },
{ -4.867135e+01-3.172073e-01i, -4.976398e+01-2.849501e+01i, -5.256077e+00-9.048250e+00i, -1.765199e-01+2.326913e-01i, +5.970945e-01+2.886578e-01i },
{ -2.540642e+00-2.654707e+01i, +6.236248e+00-2.187551e+01i, +3.691625e+00-5.588074e-01i, +5.431615e-01+2.701920e-01i, -3.749645e-01+2.706335e-01i },
{ +8.711446e+00+9.785931e+00i, -3.528039e+00+1.148903e+01i, -3.767300e+00-1.529266e+00i, +5.389888e-01-3.023517e-02i, -3.945675e-01-4.150086e-01i },
{ -3.497161e+00-2.048391e+00i, -1.305574e+00-4.663723e+00i, +1.451714e+00-1.167510e+00i, +4.122955e-02+2.859488e-01i, +7.904825e-02-3.463789e-02i },
},
{
{ +1.871009e+00+2.128881e+00i, -5.587788e-01+2.661573e+00i, -9.447004e-01-1.614308e-01i, -4.021153e-02-2.144752e-01i, -1.041704e-02-1.684570e-02i },
{ -3.103477e+00-2.149941e-01i, -3.348376e+00-2.509171e+00i, +8.735535e-01-1.041575e+00i, +2.303524e-01+3.322488e-02i, -3.781166e-03+5.674168e-03i },
{ +2.746810e+00-2.476457e+00i, +4.140795e+00-2.569284e-02i, +1.625739e+00+1.814289e+00i, +1.738480e-02+2.418852e-01i, -1.145970e-01+6.379412e-03i },
{ +1.060605e+00+1.871607e+00i, -4.890288e-01+2.223010e+00i, -5.999820e-01+8.392745e-02i, +5.818734e-02-8.183057e-03i, -5.381382e-02-5.312129e-02i },
{ -5.010853e-01-5.407572e-01i, -3.925128e-02-8.345355e-01i, +2.700107e-01-1.333469e-01i, -6.388117e-03+4.036446e-02i, +1.334397e-02+3.749039e-06i },
},
{
{ +1.070285e-01+4.702430e-01i, -1.319336e-01+5.577842e-01i, -6.009468e-02+6.508750e-02i, +3.346000e-02+4.970413e-04i, -5.844975e-03+4.760351e-04i },
{ -1.072008e+00+1.972543e-01i, -1.327528e+00-3.432492e-01i, -1.627895e-01-3.738756e-01i, +1.981303e-02-1.414920e-02i, -7.878440e-03-4.923272e-03i },
{ -3.895502e-01-4.867674e-01i, -4.073104e-01-8.257652e-01i, -8.380195e-02-3.567098e-01i, -1.603146e-02-3.641224e-02i, -7.770985e-03-8.744125e-03i },
{ +3.504674e-02+5.710929e-02i, -8.466651e-02-2.599899e-02i, -5.784282e-02-1.019945e-01i, +1.060668e-02-1.355814e-02i, -2.292293e-03-5.757215e-03i },
{ -4.185476e-02-4.169362e-02i, -1.451794e-02-6.588036e-02i, +1.377517e-02-1.447897e-02i, -6.343557e-04+9.004534e-04i, +1.182720e-03+3.326626e-05i },
}
},
{// coil58
{
{ -6.979440e-01-3.842674e+00i, +7.515847e+00-1.225527e+00i, +1.020921e+00+3.923414e+00i, -1.150938e+00-6.978506e-01i, +2.392395e-01+3.139175e-01i },
{ +1.451530e+01-1.066928e+00i, +2.506253e+00+2.872448e+01i, -1.449429e+01+7.313139e+00i, +9.025960e-01-1.758691e+00i, -8.986569e-01+6.920314e-01i },
{ +1.586033e+01+1.419213e+01i, -1.978810e+01+2.534992e+01i, -9.763565e+00-4.756269e+00i, +2.771544e+00+1.865175e+00i, -1.053267e+00-1.104972e+00i },
{ -5.788362e-01+8.055998e+00i, -8.499474e+00-2.568909e+00i, +3.265003e+00-3.305252e+00i, -4.476442e-01+1.753287e+00i, +2.731581e-01-7.985487e-01i },
{ -8.118089e-01-3.139921e-02i, +1.382404e-01-6.491156e-01i, +2.983166e-01+4.944765e-01i, -2.554284e-01+4.224646e-02i, +1.030202e-01-3.412663e-02i },
},
{
{ -2.084460e+00+3.125057e+00i, -8.562584e+00+3.649561e+00i, -3.341858e+00-4.103191e-01i, -1.778015e-01-1.007519e+00i, -1.287393e-02+1.445674e-01i },
{ -2.113737e+01+1.538845e+01i, -5.709460e+01+2.710280e+00i, -1.718986e+01-1.307224e+01i, +2.425320e+00+8.449767e-01i, -6.815272e-01-5.047270e-01i },
{ -1.920247e+01+1.767351e+01i, -5.083569e+01-1.606554e+01i, -2.543697e-01-1.572054e+01i, +5.436897e-03+4.266612e+00i, +6.754440e-01-2.405157e+00i },
{ -7.713234e+00+6.450443e+00i, -4.249619e+00-1.193951e+01i, +7.504613e+00+1.248241e+00i, -3.543067e+00+1.508940e+00i, +1.380589e+00-8.445190e-01i },
{ -2.030045e+00-6.566647e-01i, +5.438312e-01-1.371082e+00i, +3.446542e-01+1.088024e+00i, -4.332051e-01-1.433721e-01i, +2.331032e-01+3.455566e-02i },
},
{
{ -6.121829e+00+1.223838e+00i, -4.465359e+00-5.205458e+00i, -2.597759e-01-1.422613e+00i, -9.188733e-01-2.758005e-01i, +2.559570e-01-6.244236e-02i },
{ -2.253603e+01-6.772955e+00i, -1.633528e+01-2.638461e+01i, +4.656625e+00-4.715597e+00i, -4.728035e-01+2.174373e+00i, +3.206673e-01-3.147674e-01i },
{ -1.237720e+01-7.198719e+00i, -2.758282e+00-2.304519e+01i, +8.460515e+00-2.468748e-01i, -2.543421e+00+1.158238e+00i, +1.220891e+00-6.821930e-01i },
{ -2.194935e+00-1.183114e-01i, +4.605443e+00-2.832750e+00i, +1.303611e+00+4.690285e+00i, -2.782606e+00-9.325756e-01i, +9.646375e-01+2.648547e-02i },
{ -9.296541e-01-7.508331e-01i, +5.573137e-01-5.142014e-01i, -4.139191e-02+5.367131e-01i, -1.053366e-01-2.356415e-01i, +1.223849e-01+9.092069e-02i },
},
{
{ +2.937740e-01-2.270746e+00i, +4.454138e+00+1.157639e-01i, -4.967726e-01+1.557266e+00i, -4.599568e-01-4.477145e-01i, +7.152215e-02+1.672548e-01i },
{ +5.381724e+00-2.029112e+00i, +5.151484e+00+6.637120e+00i, -2.290781e+00+2.451746e+00i, +2.774585e-01-2.007820e-01i, -3.674357e-01+1.782774e-01i },
{ +4.710502e+00+1.757428e+00i, +2.677436e-01+6.595687e+00i, -1.878885e+00+8.000097e-01i, +3.439578e-01-6.355697e-02i, -2.137139e-01-6.616198e-02i },
{ +3.523070e-01+8.623657e-01i, -4.875210e-01+1.051880e+00i, -6.869929e-01+1.568502e-01i, -1.571861e-01-2.794728e-01i, +7.456874e-02+1.470870e-02i },
{ -2.791282e-02-5.128504e-02i, -7.812635e-05+6.227794e-02i, -5.853800e-02+1.237892e-02i, +2.926329e-02-3.144138e-02i, +4.819459e-03+2.082990e-02i },
},
{
{ -2.592343e-01+2.287934e-01i, -9.020952e-01+2.261811e-01i, -3.406750e-01-3.335683e-01i, +1.270947e-01-6.264333e-02i, -2.509429e-02+4.538420e-03i },
{ -1.441107e+00+4.269333e-01i, -2.752869e+00-1.448470e+00i, -5.557132e-02-1.788755e+00i, +2.776930e-01+8.207826e-02i, -6.500190e-02-7.015707e-02i },
{ -1.307285e+00-1.107603e-01i, -1.403316e+00-2.115245e+00i, +5.698683e-01-1.189101e+00i, +6.747527e-02+1.926424e-01i, -7.194214e-03-7.869510e-02i },
{ -2.646452e-01-1.578694e-01i, +5.486842e-02-5.119070e-01i, +2.283452e-01-1.468698e-02i, -4.641403e-02+4.572077e-02i, +1.595327e-02-1.106641e-02i },
{ -2.623362e-02-1.085229e-02i, +2.124615e-03-2.529823e-02i, +8.708039e-03+5.255380e-03i, -3.868091e-03+1.449947e-03i, +1.327097e-03+4.032133e-04i },
}
},
{// coil59
{
{ +3.315460e+00-8.561558e+00i, +1.247811e+01+7.351277e+00i, -5.379145e+00+2.625491e+00i, +1.468073e+00-2.856058e+00i, -6.416828e-01+1.287118e+00i },
{ +2.048314e+01+1.243346e+01i, -2.185496e+01+4.098396e+01i, -1.680324e+01-7.882820e+00i, +4.849470e+00+1.323911e+00i, -2.547166e+00-8.963022e-01i },
{ +5.072104e-01+2.822952e+01i, -4.120152e+01+6.178708e+00i, +1.787036e+00-8.808834e+00i, -8.258576e-01+5.730779e+00i, +8.965561e-01-2.909869e+00i },
{ -8.793171e+00+3.870254e+00i, -8.768574e-01-1.306439e+01i, +7.082942e+00+3.515723e+00i, -3.617728e+00+3.801799e-01i, +1.762404e+00-3.905097e-01i },
{ -6.432749e-01-1.324708e-01i, +4.157201e-01+3.405944e-01i, -3.649860e-01+9.934024e-01i, -3.116086e-01-1.631003e-01i, +1.160470e-01+5.941857e-02i },
},
{
{ +4.902361e+00-3.926063e+00i, -2.863386e-01+1.543619e+01i, -1.183076e+01-1.921770e+00i, +3.146481e+00-2.744042e+00i, -1.728132e+00+9.243733e-01i },
{ +4.617883e+00+4.631131e+01i, -9.306602e+01+4.851738e+01i, -2.791235e+01-2.693852e+01i, +5.928008e+00+6.529808e+00i, -3.159318e+00-4.085460e+00i },
{ -2.997451e+01+6.453356e+01i, -1.017322e+02-1.253139e+01i, +5.030015e+00-2.192013e+01i, -4.109669e+00+7.951867e+00i, +3.997790e+00-5.312277e+00i },
{ -2.149634e+01+7.615295e+00i, -1.738049e+00-2.382113e+01i, +9.872787e+00+7.581673e+00i, -7.033692e+00-1.660431e+00i, +3.613111e+00+3.698039e-02i },
{ -1.289572e+00-8.441549e-01i, +1.030449e+00+7.617359e-01i, -8.952665e-01+1.853361e+00i, -3.880726e-01-4.799404e-01i, +2.025811e-01+2.228451e-01i },
},
{
{ +6.116284e+00-9.453583e-01i, -6.201522e+00+1.109300e+01i, -7.156744e+00-5.083078e+00i, +2.565137e+00-3.584851e-01i, -1.699445e+00-5.621529e-02i },
{ +4.092031e-01+3.096173e+01i, -5.894901e+01+1.295793e+01i, -5.561855e+00-1.703432e+01i, +1.500897e+00+7.618298e+00i, -1.406188e+00-3.921250e+00i },
{ -2.199060e+01+3.415973e+01i, -4.454021e+01-2.189295e+01i, +1.161216e+01-6.945382e+00i, -6.030991e+00+3.423283e+00i, +3.833582e+00-3.030656e+00i },
{ -1.263957e+01+6.111090e-01i, +6.568175e+00-1.215480e+01i, +3.200527e+00+8.388993e+00i, -5.061144e+00-3.178002e+00i, +2.474133e+00+7.113519e-01i },
{ -4.491321e-01-1.088992e+00i, +1.186076e+00+8.909827e-01i, -1.032209e+00+1.233268e+00i, -1.204137e-01-5.671275e-01i, +1.190489e-01+2.477604e-01i },
},
{
{ +2.469357e+00-1.270007e+00i, +3.117495e-01+1.973395e+00i, -1.066346e+00-1.796881e+00i, +9.424678e-01+1.275244e-01i, -5.088153e-01+3.064287e-02i },
{ +4.304940e+00+3.611745e+00i, -4.927766e+00+2.201247e+00i, +1.387287e+00-2.607574e+00i, +5.142376e-01+2.069717e+00i, -5.006859e-01-8.450280e-01i },
{ -1.769994e+00+3.341366e+00i, -2.092603e-01-4.204514e+00i, +4.329062e+00+2.198062e+00i, -1.923449e+00+9.449067e-01i, +7.518190e-01-5.494353e-01i },
{ -2.062504e+00-1.370924e+00i, +3.523983e+00-2.050535e+00i, +4.776090e-01+2.817532e+00i, -1.138529e+00-8.058952e-01i, +5.097350e-01+2.513857e-01i },
{ -1.257449e-02-2.996161e-01i, +2.954849e-01+2.894978e-01i, -3.424029e-01+2.450683e-01i, +2.130676e-03-1.696315e-01i, +1.794403e-02+7.211517e-02i },
},
{
{ -8.391441e-02-5.450597e-02i, -3.317047e-01+4.382036e-01i, -2.832681e-01-8.239166e-02i, +1.227321e-01-2.104961e-02i, -5.854677e-02+1.671667e-02i },
{ -3.910509e-01+5.156376e-01i, -1.773618e+00+1.118351e-01i, -2.695977e-01-9.669650e-01i, +1.698546e-01+9.356618e-02i, -8.680206e-02-8.199337e-02i },
{ -7.323885e-01+6.335393e-01i, -1.361040e+00-7.554213e-01i, +7.839972e-02-6.660258e-01i, -8.284936e-02+5.043107e-02i, +3.820214e-02-7.934659e-02i },
{ -3.379227e-01+8.171392e-02i, -1.060403e-01-2.484590e-01i, -1.871274e-02+5.287976e-02i, -7.186718e-02-6.126051e-02i, +4.051451e-02+1.226904e-02i },
{ -1.171280e-02-3.249940e-03i, -7.674420e-03+1.832249e-02i, -2.798024e-02-1.539501e-03i, +5.403628e-03-1.414107e-02i, +6.620541e-04+5.607333e-03i },
}
},
{// coil60
{
{ -2.290957e+01+3.352738e+00i, -7.038784e+00+1.434099e+01i, +8.381367e-02+9.715040e-01i, -4.254484e-02+2.012284e+00i, +5.823992e-01-8.932870e-01i },
{ -1.250333e+01-3.197509e+01i, -2.875144e+01-1.526184e+01i, -5.617773e+00-1.173886e+00i, -9.046369e-01-2.003689e-01i, +6.691957e-01+2.996504e-01i },
{ +1.331489e+01-1.073053e+01i, -2.426003e+00-1.988479e+01i, -3.956949e+00-2.503747e+00i, -2.290380e-01-2.874198e-01i, -1.422983e-01+4.605836e-01i },
{ +1.964363e-01+2.926010e+00i, +2.233677e+00+9.359590e-01i, -4.420531e-01+4.365575e-01i, +3.910410e-02-1.618853e-01i, -6.474122e-03+7.374297e-02i },
{ +5.966529e-01-8.561822e-01i, +7.367451e-02-8.844049e-01i, -2.330244e-01-1.463860e-03i, +1.263343e-02-6.021965e-02i, -1.314943e-02+3.082210e-02i },
},
{
{ -2.089506e+00-2.969641e+01i, +1.456721e+00-1.424213e+01i, +1.653570e+00-4.243709e+00i, -1.307905e+00+4.180455e-01i, +8.362190e-01-3.461890e-01i },
{ +3.391959e+01-2.532816e+01i, +2.161680e+01-2.560515e+01i, +8.318918e+00-7.604617e+00i, -5.115395e-01-3.170599e+00i, +8.257073e-02+7.180369e-01i },
{ +8.419874e+00+6.271303e+00i, +9.341436e+00-7.119413e+00i, +2.985908e+00-1.127993e+00i, +7.490871e-01-4.758751e-01i, -3.219164e-01+3.909928e-01i },
{ -3.507758e+00-2.000440e-01i, +6.437957e-01+8.405170e-01i, +4.247069e-02+3.719226e-01i, -9.703475e-02-3.119030e-01i, +6.141461e-02+9.600022e-02i },
{ +1.249894e-01+4.340855e-01i, +3.288949e-02+2.077186e-01i, -2.537245e-02+2.296942e-01i, +3.833148e-02-2.640143e-02i, -1.873266e-02+2.172198e-02i },
},
{
{ +1.360139e+01+2.679063e+00i, +2.485069e+01+5.119654e+00i, +7.285535e+00-5.463849e+00i, -1.661750e+00-2.437669e-01i, +6.119480e-01-2.572021e-01i },
{ +2.110990e+00+1.777415e+01i, +1.023567e+01+2.940535e+01i, +9.914564e+00+8.189730e+00i, +1.889977e-02-1.643272e+00i, +1.995244e-01+2.370403e-01i },
{ -1.044608e+01-1.156797e+00i, -9.774311e+00+2.724094e+00i, -1.179135e+00+5.715047e+00i, +1.062934e+00+3.050708e-01i, -1.565815e-01+2.472205e-01i },
{ +1.128202e+00-2.122442e+00i, +1.557811e+00-1.389395e+00i, +1.912094e-01-9.018496e-01i, +2.552592e-01-3.333928e-01i, -4.408830e-02+2.453224e-02i },
{ -8.242201e-01+2.979428e-01i, -1.209295e+00+3.898986e-01i, -3.060378e-01+3.747875e-01i, +5.659811e-02+6.737325e-02i, -1.971386e-02+7.397646e-03i },
},
{
{ -5.173074e+00+4.850000e+00i, -7.075819e-01+7.700171e+00i, +1.570950e+00+1.881003e-02i, -2.673782e-01+1.644872e-01i, +2.263928e-01-1.396948e-01i },
{ -9.524307e+00-5.216526e+00i, -1.206434e+01-4.936538e-01i, -2.048135e+00+1.549545e+00i, +1.427333e-01+1.246203e-01i, +1.765278e-01-2.836713e-02i },
{ +2.872736e+00-6.342454e+00i, -1.798535e-01-7.937666e+00i, -2.568071e+00-7.504320e-01i, +9.952587e-02+3.046273e-01i, -4.887841e-02+1.769980e-02i },
{ +1.562842e+00+1.085023e+00i, +1.753135e+00+7.502143e-01i, +4.161137e-02-1.609861e-01i, +1.068509e-01+4.239157e-03i, -3.226487e-02-1.277857e-02i },
{ -1.041374e-01-3.111842e-01i, -3.514528e-01-3.644324e-01i, -1.783572e-01-1.440066e-02i, +8.582735e-03+2.676116e-02i, -9.566031e-03+2.257461e-03i },
},
{
{ +1.127952e+00-6.840045e-01i, +1.110251e+00-1.109495e+00i, +2.340001e-01-3.968334e-01i, -1.115669e-02+6.219182e-03i, +7.845734e-03-1.234556e-02i },
{ +2.122336e+00+9.204839e-01i, +3.244173e+00+2.504499e-01i, +1.060150e+00-1.849096e-01i, +1.097095e-02+3.129476e-02i, +1.626666e-02-2.095103e-02i },
{ +2.236530e-01+1.389647e+00i, +1.267691e+00+1.421191e+00i, +4.960740e-01+2.130353e-01i, -1.470837e-02+4.489893e-02i, +1.480737e-02-9.673463e-03i },
{ -2.996685e-01+8.494238e-02i, -1.878533e-01+2.064036e-01i, +8.842275e-03+9.329803e-03i, -1.030378e-04-3.347021e-03i, +1.319484e-03+3.358905e-04i },
{ -5.993187e-03-3.314116e-03i, -1.419739e-03-6.047516e-04i, +1.188401e-02+3.033063e-03i, +2.670894e-03+6.580909e-04i, -7.942764e-04-2.719603e-04i },
}
},
{// coil61
{
{ +1.727449e+00-6.347363e+00i, -1.436445e+00-4.158377e+00i, +4.375986e-01+3.633552e-01i, -5.115199e-02-1.993177e-01i, +1.071389e-01+1.432052e-01i },
{ +9.894806e+00+5.236961e-01i, +1.056602e+01-4.313705e+00i, +2.703578e+00-6.555672e-01i, +2.400836e-01-6.147087e-02i, -1.130653e-01+3.711486e-02i },
{ +2.853549e-01+4.125892e+00i, +4.372049e+00+2.697782e+00i, +9.609705e-01-5.449518e-01i, +1.279149e-01-2.351115e-01i, -7.315908e-02-4.635085e-03i },
{ -2.702407e-01-1.141939e+00i, -7.776024e-01+1.620533e-02i, -5.358831e-01-2.951538e-01i, +2.284963e-01-2.652384e-02i, -8.437212e-02+2.774815e-02i },
{ +2.812137e-01+4.883190e-01i, +3.919663e-01+4.357884e-01i, +2.022871e-02-4.904939e-02i, +1.865420e-03-8.237656e-03i, -9.505984e-03+3.601138e-03i },
},
{
{ +6.854795e+00+1.889083e-01i, -7.043411e-02-1.792758e+00i, -1.272182e+00+1.561282e+00i, +6.389822e-01+2.090720e-01i, -1.044829e-01+1.783643e-01i },
{ +9.870371e+00+1.023674e+01i, +1.234988e+01+1.770059e+00i, +9.522877e-01+6.493092e-02i, +1.691975e-01+9.443905e-01i, -1.982503e-01-2.021716e-01i },
{ -1.079656e+00+4.557076e+00i, +5.137163e+00+4.107821e+00i, +1.256678e+00-1.268506e-02i, -5.513744e-01+3.546634e-01i, +3.361139e-02-1.637094e-01i },
{ +1.163531e-02-1.501096e+00i, -7.682457e-01-8.015329e-01i, -2.342807e-01-1.997517e-01i, +2.843552e-01+1.451133e-01i, -7.963725e-02-3.198020e-03i },
{ +2.021001e-01+3.916242e-01i, +4.044149e-01+4.877546e-01i, -1.917176e-03-1.084737e-01i, -9.643275e-03-3.404889e-02i, -1.528785e-02+5.246714e-03i },
},
{
{ -1.127580e+00+9.040675e-02i, -4.690504e+00-1.537384e+00i, -1.306578e+00-2.150961e-01i, +1.257905e-01-8.000100e-02i, -5.631892e-02+2.155250e-01i },
{ -1.094291e-01-9.036310e-01i, +1.076372e+00-5.075041e+00i, -9.656835e-01-3.625139e+00i, -2.334419e-01-2.392257e-01i, -2.423590e-02+6.592093e-02i },
{ +1.278363e+00-7.894394e-01i, +3.157936e+00+1.690291e-01i, +5.168082e-01-4.957066e-01i, -5.850319e-01-2.873659e-03i, +4.377517e-02-8.332147e-02i },
{ +2.570376e-01+2.769689e-02i, -2.480930e-01-2.438623e-01i, +2.912419e-01+3.765823e-01i, +1.150305e-01+3.078567e-01i, -2.147758e-02-4.608040e-02i },
{ +5.222808e-02+4.933267e-02i, +1.688220e-01+7.397891e-02i, -9.415168e-04-1.226221e-01i, +6.655231e-04-3.204747e-02i, -7.952125e-03-1.650455e-03i },
},
{
{ +7.877852e-02-1.647426e+00i, -9.450944e-02-1.031627e+00i, +4.749652e-01+1.737015e-01i, -4.973665e-02-1.353386e-01i, +8.889910e-03+9.794655e-02i },
{ +2.086970e+00-1.186105e+00i, +2.194929e+00-6.269226e-01i, +1.001797e+00-1.383539e-01i, +1.166099e-01-2.553858e-01i, -1.605436e-02+1.236687e-01i },
{ +8.032659e-01+7.826604e-01i, +2.142655e-01+1.365329e+00i, +1.400691e-01-5.175072e-02i, +1.642137e-02-1.751688e-01i, -2.203340e-02+1.235006e-02i },
{ -1.025586e-01+1.125273e-01i, -3.442873e-01-7.167055e-02i, -3.711203e-02-1.925845e-02i, -8.217379e-03+6.225111e-02i, -6.470404e-03-1.631914e-02i },
{ +3.493841e-02+4.965494e-02i, +7.240918e-02+3.572150e-02i, +1.810906e-02-2.637439e-02i, +5.438608e-03-7.819745e-03i, -9.368980e-04-1.767026e-03i },
},
{
{ -5.084758e-02+2.945449e-01i, -1.544402e-01+3.059046e-01i, -1.437169e-01+1.070378e-01i, -1.638155e-02+5.098637e-03i, -1.000744e-03+5.412620e-03i },
{ -4.381024e-01+3.130212e-01i, -6.687990e-01+4.576972e-01i, -3.106278e-01+2.210631e-01i, -1.627190e-02+1.327628e-02i, -6.750456e-03+7.521909e-03i },
{ -2.921044e-01-8.017844e-02i, -4.452738e-01+3.802236e-03i, -8.437966e-02+4.641047e-02i, +4.486728e-03+3.503863e-03i, -4.463419e-03+2.013279e-03i },
{ +1.601448e-02-4.648384e-02i, +9.655784e-03-5.891131e-02i, +3.035576e-02-1.454985e-03i, +2.690376e-03+7.293141e-03i, -4.739571e-04-9.363092e-04i },
{ -2.548586e-03-1.473982e-03i, +6.149181e-04+1.444429e-03i, +1.879110e-04+1.253774e-03i, +3.540913e-04-9.595740e-05i, +5.809963e-05-8.505836e-05i },
}
},
{// coil62
{
{ -1.060743e+01-2.824609e+00i, -1.149297e+01-2.914059e-01i, -2.911962e+00+9.491309e-01i, -8.095932e-02-2.158795e-01i, -1.299441e-01+9.507178e-02i },
{ +6.382097e+00-2.089393e+01i, +4.531592e+00-3.019062e+01i, +1.484490e+00-9.051723e+00i, +6.788203e-01-1.592273e-01i, -2.788470e-01-1.257143e-01i },
{ +1.284837e+01-9.591055e-02i, +2.006005e+01-9.684749e+00i, +5.592589e+00-4.763936e+00i, -7.145953e-02-3.416167e-01i, -7.241833e-02-1.318569e-01i },
{ -2.051654e+00+2.135631e+00i, -7.467263e-01+3.947928e+00i, -6.237625e-01+8.491375e-01i, +1.243784e-01-3.384513e-02i, -4.349723e-02+6.144582e-02i },
{ +1.104346e+00-5.859542e-01i, +6.764632e-01-8.579248e-01i, +5.855674e-02-5.254044e-01i, +8.553647e-02-4.981364e-02i, -2.815146e-02+1.447820e-02i },
},
{
{ +1.255062e+01-1.725199e+01i, +1.081829e+01-8.485022e+00i, +2.434431e+00+1.659516e+00i, +8.526428e-01-7.244909e-01i, -2.956544e-01+3.725176e-01i },
{ +5.228807e+01+1.520635e+00i, +5.215902e+01+4.385690e-01i, +1.148305e+01+1.728308e+00i, +1.942895e+00+6.156353e-01i, -6.203038e-01-2.973150e-01i },
{ +1.327250e+01+1.659051e+01i, +2.504763e+01+1.328316e+01i, +5.795956e+00+3.250681e+00i, -3.505691e-01+4.413166e-01i, -7.002309e-02-1.377601e-01i },
{ -4.204432e+00-2.541237e+00i, -3.007136e+00+8.401275e-01i, -1.624461e+00+7.611008e-01i, +1.969105e-01-2.051175e-01i, -1.891306e-02+1.824429e-01i },
{ +1.307695e+00+3.809747e-01i, +1.160758e+00-3.761577e-02i, +1.632863e-01-3.201876e-01i, +5.026381e-02-6.096169e-02i, -3.416605e-02+1.369855e-02i },
},
{
{ +1.343761e+01+5.400881e+00i, +8.661543e+00+1.131698e+01i, +9.086552e-01+3.970039e+00i, +6.331360e-01+2.150138e-01i, -1.129600e-01+1.269060e-01i },
{ +5.084717e+00+2.192510e+01i, -2.837720e-01+1.911289e+01i, -4.276988e+00+2.251699e+00i, -1.736740e-01+3.866379e-01i, -6.651519e-02-2.674415e-01i },
{ -7.459583e+00+7.610637e-02i, -1.951410e+00+7.796861e-02i, -2.478442e+00-2.152304e-01i, -8.986933e-01+1.585463e-02i, +8.306341e-02+6.858940e-02i },
{ +1.043202e+00-3.070204e+00i, +1.269419e+00-1.179461e+00i, +2.386105e-01+2.942195e-01i, +3.063756e-01-2.477437e-02i, -4.784219e-03+9.734797e-02i },
{ -4.165982e-01+3.194166e-01i, -2.660778e-01-2.266272e-01i, -2.937722e-02-1.905590e-01i, -2.926587e-02-3.656819e-03i, -1.125013e-02-6.728879e-03i },
},
{
{ -2.762255e+00+2.070972e+00i, -4.599521e+00+1.281386e+00i, -1.166607e+00-6.010664e-02i, -1.812733e-01+1.000276e-01i, +4.682870e-02-1.707697e-02i },
{ -6.025186e+00-4.645415e+00i, -3.870554e+00-9.126425e+00i, +2.193332e-01-3.489781e+00i, -2.958874e-01-9.753066e-02i, +1.746612e-01+1.405711e-02i },
{ +2.105225e+00-4.711892e+00i, +5.116318e+00-4.068147e+00i, +1.502290e+00-1.114760e+00i, -6.761896e-02-1.947469e-01i, +5.351102e-02+9.284723e-02i },
{ +1.111036e+00+1.016631e+00i, +3.758440e-01+1.636147e+00i, -2.007740e-01+3.448697e-01i, +5.862772e-02+2.475414e-02i, -1.811488e-02+3.191056e-03i },
{ -1.620418e-01-1.749331e-01i, -1.202849e-02-3.868160e-01i, +8.452365e-02-1.379366e-01i, +9.347405e-04+5.441087e-03i, -9.973273e-04-4.852619e-03i },
},
{
{ +1.013445e+00-1.063251e-01i, +1.247812e+00+2.401228e-02i, +3.707019e-01+1.525274e-01i, +1.967118e-02+1.357525e-02i, +6.585532e-03+4.277659e-03i },
{ +1.399832e+00+1.339781e+00i, +1.735017e+00+2.411140e+00i, +3.666158e-01+1.275986e+00i, -1.142973e-02+8.835179e-02i, +8.921831e-03+1.914739e-02i },
{ -1.104126e-01+1.047218e+00i, -3.929414e-01+1.931285e+00i, -3.604337e-01+8.031192e-01i, -4.116628e-02+1.935967e-02i, -2.633401e-03+1.645819e-02i },
{ -1.841999e-01-3.328527e-02i, -3.245294e-01-6.101989e-02i, -1.145666e-01-6.952108e-02i, -9.887982e-04-9.927314e-03i, -2.102401e-03+4.457427e-04i },
{ -4.590710e-03-3.806082e-03i, +2.377057e-02-1.335762e-03i, +1.960436e-02+1.223791e-02i, -4.750020e-04+3.752750e-03i, -8.284698e-05-3.970855e-04i },
}
},
{// coil63
{
{ -2.613137e+00-8.263630e-01i, -3.063343e+00+7.651775e-01i, +1.844883e-01+5.781502e-01i, +2.374188e-01-1.459192e-01i, +4.874788e-03+6.361563e-03i },
{ -1.737462e+00-4.610014e+00i, -6.053475e+00-8.304590e+00i, -1.712929e+00-3.091125e+00i, +1.042792e-01+2.189139e-02i, -9.171147e-02-2.670014e-02i },
{ +6.812806e-01-9.321626e-01i, +1.135751e-01-5.099561e+00i, -7.550826e-01-1.563598e+00i, -5.143026e-01+4.035795e-02i, +9.867070e-02+1.060455e-02i },
{ -6.161816e-01+1.562685e-02i, +5.361404e-01+5.126487e-01i, -1.486672e-01+7.118773e-01i, -9.148020e-02-2.511984e-01i, +5.999814e-02+9.444232e-02i },
{ +1.401049e-01-2.676568e-01i, +1.985188e-01-3.195268e-01i, -5.421675e-02-5.609921e-02i, -2.885371e-02-1.190993e-02i, +1.175997e-02+1.327834e-02i },
},
{
{ +1.471853e+00-5.998541e+00i, -1.197058e+00-3.903092e+00i, -1.809073e-01+5.515537e-01i, +4.120863e-01-3.969935e-01i, -1.300830e-02+1.485705e-01i },
{ +8.233227e+00-1.161885e+01i, +3.898533e+00-1.988969e+01i, -3.829312e-01-5.531027e+00i, +3.719059e-01+2.992375e-01i, -2.429811e-01-6.382093e-03i },
{ +4.054244e+00-1.540162e+00i, +5.918256e+00-9.099102e+00i, +1.560302e+00-2.973736e+00i, -1.736661e-01+4.610692e-01i, +7.917029e-02-4.428598e-02i },
{ -1.300476e+00+3.604420e-01i, -3.202634e-01+6.775239e-01i, -1.603580e-01+5.511822e-01i, +9.628822e-02-3.802868e-01i, +5.486493e-02+1.152359e-01i },
{ +1.585144e-01-3.805422e-01i, +3.875404e-01-4.628629e-01i, -6.958726e-02-6.070405e-02i, -6.359703e-02-8.839157e-03i, +1.410384e-02+2.512657e-02i },
},
{
{ +1.851446e+00-2.612068e-01i, -2.879952e-01+1.461997e+00i, -4.122491e-01+3.617458e-02i, +2.403560e-02-3.415041e-01i, +9.239091e-02+1.211823e-01i },
{ +2.566582e+00-9.825617e-02i, +1.167757e+00-3.952672e+00i, -1.526326e+00-1.130385e+00i, -5.739913e-01+8.768618e-02i, +3.550722e-02-9.138487e-03i },
{ -2.240976e-01-3.774162e-01i, +2.558298e+00-2.467019e+00i, +1.048667e+00+1.250381e-01i, -1.908860e-01+3.495965e-01i, +4.542418e-02-1.883663e-03i },
{ -2.860072e-01-1.238758e-01i, -4.615380e-01+1.944348e-01i, +2.008706e-02-9.527481e-02i, +2.982492e-01-2.257063e-01i, -2.259454e-02+5.746273e-02i },
{ +8.884400e-03-9.050891e-02i, +1.376226e-01-1.198464e-01i, -6.846672e-02+9.686444e-03i, -3.595177e-02-4.190597e-03i, +2.894162e-04+1.499628e-02i },
},
{
{ -7.771124e-01+1.982034e-01i, -9.851571e-01+3.714716e-01i, +2.270167e-01-2.264079e-01i, -1.577690e-02-4.317552e-02i, +5.288335e-02+2.189367e-02i },
{ -1.815526e+00-3.760673e-01i, -1.688880e+00-1.040191e+00i, -1.301185e-01-5.272225e-01i, -1.989685e-01-1.405317e-01i, +7.927042e-02+7.996896e-03i },
{ -4.865791e-01-9.003914e-01i, +2.136385e-02-3.126559e-01i, -2.317939e-01+2.847059e-01i, -1.771963e-01-5.547007e-02i, +1.685331e-02+2.661331e-02i },
{ +2.237141e-01-1.227918e-01i, +3.440191e-02+1.336794e-01i, -9.266736e-02+5.187481e-02i, +6.684749e-02-2.688426e-02i, -1.538830e-02+1.515244e-02i },
{ -1.148761e-02-1.124711e-02i, +4.023273e-03-3.191147e-02i, -2.125849e-02-1.091050e-02i, -5.184376e-03-4.972217e-03i, -1.555039e-03+2.140855e-03i },
},
{
{ +2.726248e-01-1.070661e-01i, +2.587526e-01-1.025394e-01i, +3.442191e-02+4.883781e-02i, -5.515536e-03+1.672555e-02i, +1.150395e-03+1.445713e-03i },
{ +5.255126e-01+8.286010e-03i, +7.179340e-01+5.836429e-03i, +2.898039e-01+1.159598e-01i, +2.008512e-02+1.711971e-02i, +4.214366e-03+1.890753e-03i },
{ +1.914996e-01+1.278742e-01i, +3.270747e-01+1.832873e-01i, +1.594723e-01+4.491036e-02i, +1.793444e-02-7.196864e-03i, +2.475446e-03+2.432117e-03i },
{ -8.040698e-03+1.733642e-02i, -1.944072e-02+1.588351e-02i, -3.238840e-03-1.867767e-02i, +7.728004e-03-3.988201e-03i, -8.581800e-04+8.767415e-04i },
{ -4.666804e-03+5.870581e-04i, +1.525258e-03-3.771367e-03i, +2.986883e-03-1.858273e-03i, +2.716668e-06-2.041779e-04i, -4.125415e-05+4.846214e-05i },
}
}
};
