"""

        Pybind11 CamiTK example plugin
        -----------------------

        .. currentmodule:: camitk

        .. autosummary::
           :toctree: _generate

           
           startApplication           
           refresh
    
"""
from __future__ import annotations
import numpy
import typing
__all__ = ['Action', 'Application', 'Component', 'Core', 'HotPlugAction', 'ImageComponent', 'InterfaceBitMap', 'InterfaceFrame', 'InterfaceGeometry', 'InterfaceNode', 'InterfacePersistence', 'InterfaceProperty', 'MeshComponent', 'Property', 'PythonHotPlugAction', 'error', 'hook_stdout', 'info', 'my_stdout', 'newImageComponentFromNumpy', 'newMeshComponentFromNumpy', 'pythonEnvironmentDebugInfo', 'refresh', 'startApplication', 'trace', 'warning']
class Action:
    def apply(self) -> ...:
        ...
    def getName(self) -> QString:
        ...
    def getParameterValue(self, arg0: QString) -> QVariant:
        ...
    def getProperty(self, arg0: QString) -> ...:
        ...
    def getTargets(self) -> list:
        ...
    def refreshApplication(self) -> None:
        ...
    def setParameterValue(self, arg0: QString, arg1: QVariant) -> bool:
        ...
class Application:
    @staticmethod
    def exec() -> None:
        ...
    @staticmethod
    def getTopLevelComponents() -> list:
        ...
    def getAction(self: QString) -> Action:
        ...
    def open(self: str) -> None:
        ...
class Component(InterfaceProperty, InterfaceNode, InterfaceGeometry, InterfaceBitMap, InterfaceFrame, InterfacePersistence):
    def getName(self) -> QString:
        ...
    def setFrameFrom(self, arg0: InterfaceFrame) -> None:
        ...
class Core:
    @staticmethod
    def getTestDataDir() -> QString:
        ...
class HotPlugAction(Action):
    pass
class ImageComponent(Component):
    def __init__(self, arg0: QString, arg1: QString) -> None:
        ...
    def getImageDataAsNumpy(self) -> numpy.ndarray:
        ...
    def getSpacing(self) -> numpy.ndarray:
        ...
    def replaceImageData(self, arg0: numpy.ndarray) -> None:
        ...
class InterfaceBitMap:
    pass
class InterfaceFrame:
    pass
class InterfaceGeometry:
    pass
class InterfaceNode:
    pass
class InterfacePersistence:
    pass
class InterfaceProperty:
    pass
class MeshComponent(Component):
    def getPointSetAsNumpy(self) -> numpy.ndarray:
        ...
class Property:
    def __init__(self, name: QString, value: QVariant, description: QString, unit: QString) -> None:
        ...
    def getAttribute(self, arg0: QString) -> QVariant:
        ...
    def getDescription(self) -> QString:
        ...
    def getName(self) -> QString:
        ...
    def getReadOnly(self) -> bool:
        ...
    def getUnit(self) -> QString:
        ...
    def setAttribute(self, attribute: QString, value: QVariant) -> None:
        ...
    def setReadOnly(self, arg0: bool) -> None:
        ...
class PythonHotPlugAction(HotPlugAction):
    pass
class my_stdout:
    @staticmethod
    def flush() -> None:
        ...
    @staticmethod
    def write(arg0: typing.Any) -> None:
        ...
def error(arg0: QString) -> None:
    ...
def hook_stdout() -> None:
    ...
def info(arg0: QString) -> None:
    ...
def newImageComponentFromNumpy(array: numpy.ndarray, name: str = 'image', spacing: typing.Any = None) -> ImageComponent:
    ...
def newMeshComponentFromNumpy(name: str = 'mesh', points_array: numpy.ndarray[numpy.float64], polys_array: numpy.ndarray[numpy.int64] = ...) -> MeshComponent:
    """
    Create vtkPointSet (vtkPolyData if only points, vtkUnstructuredGrid if general cells)
    """
def pythonEnvironmentDebugInfo() -> QString:
    ...
def refresh() -> None:
    ...
def startApplication() -> None:
    ...
def trace(arg0: QString) -> None:
    ...
def warning(arg0: QString) -> None:
    ...
__version__: str = 'CamiTK 6.0.dev.166-python-bindings-python-cep-and-scripting-mvp.b2b998c6d'
