# -*- coding: utf-8 -*-
#
# Configuration file for the Sphinx documentation builder.
#
# This file does only contain a selection of the most common options. For a
# full list see the documentation:
# http://www.sphinx-doc.org/en/master/config

# -- distro-info
import distro_info
_deb = distro_info.DebianDistroInfo()
_all_codenames = _deb.get_all()
_testing_codename = _deb.testing()
_testing_version = int(_deb.version(_deb.testing()))
_stable_codename = _deb.stable()
_stable_version = int(_deb.version(_deb.stable()))
_old_codename = _deb.old()
_old_version = int(_deb.version(_deb.old()))
_oldold_codename = _all_codenames[_all_codenames.index(_old_codename)-1]
_nexttesting_codename = _all_codenames[_all_codenames.index(_testing_codename)+1]

# -- Environment variable setup ----------------------------------------------
import os
_package = os.getenv("PACKAGE", default="package-name")
_timestamp = os.getenv("TIMESTAMP", default="0")
_date = os.getenv("DATE", default="1970-01-01")
_version = os.getenv("VERSION", default="0.0-0")

today = _date

# -- Path setup --------------------------------------------------------------

# If extensions (or modules to document with autodoc) are in another directory,
# add these directories to sys.path here. If the directory is relative to the
# documentation root, use os.path.abspath to make it absolute, like shown here.
#
# import os
# import sys
# sys.path.insert(0, os.path.abspath('.'))


# -- Project information -----------------------------------------------------

project = _package
copyright = "2019, Developer's Reference Team"
author = "Developer's Reference Team"

# The short X.Y version
version = _version
# The full version, including alpha/beta/rc tags
release = _version


# -- General configuration ---------------------------------------------------

# If your documentation needs a minimal Sphinx version, state it here.
#
# needs_sphinx = '1.0'

# Add any Sphinx extension module names here, as strings. They can be
# extensions coming with Sphinx (named 'sphinx.ext.*') or your custom
# ones.
extensions = [
]

# Add any paths that contain templates here, relative to this directory.
templates_path = ['_templates']

# The suffix(es) of source filenames.
# You can specify multiple suffix as a list of string:
#
# source_suffix = ['.rst', '.md']
source_suffix = '.rst'

# The master toctree document.
master_doc = 'index'

# Substitution (only for text contents (not for URL refs)
rst_epilog = f"""
.. |version| replace:: ``{_version}``
.. |pubdate| replace:: ``{_date}``
.. |number-of-pkgs| replace:: ``30000``
.. |number-of-maintainers| replace:: 1000
.. |number-of-arches| replace:: 10
.. |codename-security| replace:: *codename*\ ``-security``
.. |codename-oldoldstable| replace:: ``{_oldold_codename}``
.. |codename-oldstable| replace:: ``{_old_codename}``
.. |codename-stable| replace:: ``{_stable_codename}``
.. |codename-stable-security| replace:: ``{_stable_codename}-security``
.. |codename-testing| replace:: ``{_testing_codename}``
.. |codename-nexttesting| replace:: ``{_nexttesting_codename}``
.. |version-oldoldstable| replace:: {_old_version-1}
.. |version-oldstable| replace:: {_old_version}
.. |version-stable| replace:: {_stable_version}
.. |version1-revision-deb-version-stable-u1| replace:: ``1:2.4.3-4+deb{_stable_version}u1``
.. |version2-revision-deb-version-stable-u1| replace:: ``1.5-3+deb{_stable_version}u1``
.. |version-testing| replace:: {_testing_version}
.. |version2-revision-deb-version-testing-u1| replace:: ``1.5-3+deb{_testing_version}u1``
.. |version-nexttesting| replace:: {_testing_version+1}
"""
# The language for content autogenerated by Sphinx. Refer to documentation
# for a list of supported languages.
#
# This is also used if you do content translation via gettext catalogs.
# Usually you set "language" from the command line for these cases.
language = None

locale_dir = ["locales"]

# List of patterns, relative to source directory, that match files and
# directories to ignore when looking for source files.
# This pattern also affects html_static_path and html_extra_path.
exclude_patterns = []

# The name of the Pygments (syntax highlighting) style to use.
pygments_style = None


# -- Options for HTML output -------------------------------------------------

# The theme to use for HTML and HTML Help pages.  See the documentation for
# a list of builtin themes.
#
html_theme = 'sphinx_rtd_theme'

# Theme options are theme-specific and customize the look and feel of a theme
# further.  For a list of options available for each theme, see the
# documentation.
#
html_theme_options = {'prev_next_buttons_location': 'both'}

# Overwrite theme to fit Debian colors
html_css_files = ['debian.css']

# Add any paths that contain custom static files (such as style sheets) here,
# relative to this directory. They are copied after the builtin static files,
# so a file named "default.css" will overwrite the builtin "default.css".
html_static_path = ['_static']

html_js_files = ['switchers.js']

# Custom sidebar templates, must be a dictionary that maps document names
# to template names.
#
# The default sidebars (for documents that don't match any pattern) are
# defined by theme itself.  Builtin themes are using these templates by
# default: ``['localtoc.html', 'relations.html', 'sourcelink.html',
# 'searchbox.html']``.
#
# html_sidebars = {}


# -- Options for HTMLHelp output ---------------------------------------------

# Output file base name for HTML help builder.
htmlhelp_basename = _package


# -- Options for LaTeX output ------------------------------------------------

latex_elements = {
    # The paper size ('letterpaper' or 'a4paper').
    #
    # 'papersize': 'letterpaper',

    # The font size ('10pt', '11pt' or '12pt').
    #
    # 'pointsize': '10pt',

    # Additional stuff for the LaTeX preamble.
    #
    # 'preamble': '',

    # Latex figure (float) alignment
    #
    # 'figure_align': 'htbp',
}

# Grouping the document tree into LaTeX files. List of tuples
# (source start file, target name, title,
#  author, documentclass [howto, manual, or own class]).
latex_documents = [
    (master_doc, _package + '.tex', "Debian Developer's Reference",
     author, 'manual'),
]


# -- Options for manual page output ------------------------------------------

# One entry per manual page. List of tuples
# (source start file, name, description, authors, manual section).
man_pages = [
    (master_doc, _package, _package,
     [author], 1)
]


# -- Options for Texinfo output ----------------------------------------------

# Grouping the document tree into Texinfo files. List of tuples
# (source start file, target name, title, author,
#  dir menu entry, description, category)
texinfo_documents = [
    (master_doc, _package, _package,
     author, _package, 'Guidelines and information for Debian developers.',
     'Miscellaneous'),
]


# -- Options for Epub output -------------------------------------------------

# Bibliographic Dublin Core info.
epub_title = _package

# The unique identifier of the text. This can be a ISBN number
# or the project homepage.
#
# epub_identifier = ''

# A unique identification for the text.
#
# epub_uid = ''

# A list of files that should not be packed into the epub file.
epub_exclude_files = ['search.html']
