﻿// <auto-generated />

using System;
using System.Reflection;
using System.Resources;

#nullable enable

namespace Microsoft.EntityFrameworkCore.Diagnostics
{
    /// <summary>
    ///     <para>
    ///         String resources used in EF exceptions, etc.
    ///     </para>
    ///     <para>
    ///         These strings are exposed publicly for use by database providers and extensions.
    ///         It is unusual for application code to need these strings.
    ///     </para>
    /// </summary>
    public static class AbstractionsStrings
    {
        private static readonly ResourceManager _resourceManager
            = new ResourceManager("Microsoft.EntityFrameworkCore.Properties.AbstractionsStrings", typeof(AbstractionsStrings).Assembly);

        /// <summary>
        ///     The string argument cannot be empty.
        /// </summary>
        public static string ArgumentIsEmpty
            => GetString("ArgumentIsEmpty");

        /// <summary>
        ///     The number argument cannot be negative number.
        /// </summary>
        public static string ArgumentIsNegativeNumber
            => GetString("ArgumentIsNegativeNumber");

        /// <summary>
        ///     IsDescending and AllDescending cannot both be specified on the [Index] attribute.
        /// </summary>
        public static string CannotSpecifyBothIsDescendingAndAllDescending
            => GetString("CannotSpecifyBothIsDescendingAndAllDescending");

        /// <summary>
        ///     The collection argument must not contain any empty elements.
        /// </summary>
        public static string CollectionArgumentHasEmptyElements
            => GetString("CollectionArgumentHasEmptyElements");

        /// <summary>
        ///     The collection argument must contain at least one element.
        /// </summary>
        public static string CollectionArgumentIsEmpty
            => GetString("CollectionArgumentIsEmpty");

        /// <summary>
        ///     Invalid number of index sort order values: {numValues} values were provided, but the index has {numProperties} properties.
        /// </summary>
        public static string InvalidNumberOfIndexSortOrderValues(object? numValues, object? numProperties)
            => string.Format(
                GetString("InvalidNumberOfIndexSortOrderValues", nameof(numValues), nameof(numProperties)),
                numValues, numProperties);

        private static string GetString(string name, params string[] formatterNames)
        {
            var value = _resourceManager.GetString(name)!;
            for (var i = 0; i < formatterNames.Length; i++)
            {
                value = value.Replace("{" + formatterNames[i] + "}", "{" + i + "}");
            }

            return value;
        }
    }
}

