DPUT.CF(5)
=========
:doctype: manpage


NAME
----
dput.cf - Debian package upload tool configuration file


DESCRIPTION
-----------

This manpage gives a brief overview of dput's configuration file and the
available options in it.  dput is a tool to upload Debian packages to the
archive.

FILES AND FORMAT
----------------

*dput* reads, in order, these files:

 1. '/etc/dput.cf'
 2. '$XDG_CONFIG_HOME/dput/dput.cf', or if that does not exist '~/.dput.cf'
 3. The file supplied via command line argument

By default *all* configuration file locations are parsed, and overlaid in a
additive manner. This way both, entire profiles and actual settings within a
profile is inherited from any parent location defining a key within the current
scope.

dput.cf consists of different groups of configuration options, one for each
host where you want to be able to upload packages. Hosts are defined using an
identifier header with a short name for the host, enclosed in square brackets.
Note that only if multiple such headers are encountered in the configuration,
only the group following the last header is considered. This is done to avoid
confusion when overriding a  global configuration  file  with a user-specific
one.  There's a special identifier, [DEFAULT], which holds default parameters
for all the hosts. The defaults can be overridden by redefining them again in
each host section. 

SUPPORTED KEYS
~~~~~~~~~~~~~~

These keys are supported in dput.cf files. For their meaning refer to
*dput(5)*.

*allow_dcut*, *allow_unsigned_uploads*, *allowed_distributions*,
*default_host_main*, *default_keyid*, *fqdn*, *distributions*, *hash*,
*incoming*, *method*, *login*, *passive_ftp*, *post_upload_command*,
*pre_upload_command*, *run_lintian*. 


UNSUPPORTED LEGACY KEYS
~~~~~~~~~~~~~~~~~~~~~~~~

These keys known and understood to the original dput implementation are not
understood by dput-ng:

*delayed*::

This key is not supported. Use the '*--delayed*' switch from the command line,
or set *incoming* to the actual delayed directory if you really rely on this
key.

 
*run_dinstall*::

Not supported. Please submit a post-upload hook if you'd like to run
*dinstall*.

*check_version*::

Not supported.

*progress_indicator*::

Not supported yet.

*scp_compress*::

SCP compression is enabled by default. This is, however not configurable
currently.

*ssh_config_options*::

Not supported. Please switch to the 'sftp' method which supports your options
from *ssh_config(5)* natively.

UNSUPPORTED KEYS
~~~~~~~~~~~~~~~~

These keys are not supported in old-style configuration files. However, their
values are inherited from their new-style defaults. See *dput(5)* for details:

*default_keyid*, *hooks*, *interface*, *meta*, *full_upload_log*.


BUGS
-----

Please send bug reports to the author.


FILES
-----

'/etc/dput.cf'::
global dput configuration file

'$XDG_CONFIG_HOME/dput/dput.cf' or '~/.dput.cf'::
peruser dput configuration file


AUTHOR
------

dput was originally written by Christian Kurz. Updated by Thomas Viehmann
<tv@beamnet.de>. dput-ng does not re-use notable portions of code, but was
heavily inspired by its behavior. Much appreciated.

dput-ng was originally written by `Arno Töll <arno(a)debian.org>` and `Paul
Richard I by the Grace of God of the United Kingdom of Debian and Ubuntu and
of his other realms and territories King Head of the Fluxbox Window Manager
Defender of the Faith Tagliamonte <paultag(a)debian.org>`.


SEE ALSO
--------

*dput(1)*, *dput(5)*

COPYING
-------
Copyright (C) 2012 dput-ng authors. Free use of this software is
granted under the terms of the GNU General Public License (GPL) Version 2 or
later.
