#------------------------------------------------------------------------------
# Include file for GNU make or original make (for both AMD and UMFPACK)
#------------------------------------------------------------------------------

# You can edit these definitions, or select and and edit a specfic
# Make.(architecture) file, below.  This same file is used for configuring
# both AMD and UMFPACK.  AMD is a stand-alone package.  UMFPACK requires AMD,
# and for simplicity of configuring both packages, UMFPACK and AMD share this
# configuration file (and all files in the AMD/Make directory).  To configure
# AMD, or both AMD and UMFPACK, you only need to edit this one file (and
# optionaly, one of the ../Make/Make.<arch> files below).

# NOTE: -DNBLAS and other BLAS configurations are ignored by AMD, since AMD
# does not use the BLAS. This flag is here because this file, and the
# ../Make/Make.* files, are shared by UMFPACK (which requires AMD).  If you
# use AMD but not UMFPACK, then you can ignore any BLAS-related configuration
# settings.
CC = FF_CC
CFLAGS = FF_CFLAGS
F77 = FF_F77
F77FLAGS =FF_F77FLAGS 


RANLIB = ranlib
LIB = -lm
RM = rm -f
MV = mv -f
F77LIB =
AR = ar

#------------------------------------------------------------------------------
# for the AMD and UMFPACK mexFunctions (-DNBLAS and -DNUTIL for UMFPACK only)
#------------------------------------------------------------------------------

# MATLAB 6.0 or later (default)
MEX = mex -inline -O

# MATLAB 6.0 or later (no divide-by-zero)
# MEX = mex -inline -O -DNO_DIVIDE_BY_ZERO

# MATLAB 5 (no BLAS, do not try to use utMalloc, utFree, and utRealloc)
# MEX = mex -inline -O -DNBLAS -DNUTIL

#------------------------------------------------------------------------------
# for UMFPACK only (BLAS configuration):
#------------------------------------------------------------------------------
CONFIG = FF_CONFIG
LIB = FF_LIB

# The default is to NOT use the BLAS.  UMFPACK will be slow, but this is more
# portable.  Try this option first, then use your architecture-specific
# configuration, below, to add the BLAS library.  AMD ignores the -DNBLAS flag.


# 2: with the ATLAS C-BLAS (http://www.netlib.org/atlas).
# CONFIG = -DCBLAS -I../ATLAS/include
# LIB = -lcblas -latlas -lm
#------------------------------------------------------------------------------
# Archicture-specific configuration (for both AMD and UMFPACK)
#------------------------------------------------------------------------------

# Select your architecture by un-commenting the appropriate line. The include
# file can redefine any of the above definitions, or other definitions.  Use
# CC = ... to redefine the name of your C compiler, for example.  Without
# any specific changes, this Makefile should work on nearly all systems.

# include ../Make/Make.linux
# include ../Make/Make.sgi
# include ../Make/Make.solaris
# include ../Make/Make.alpha
# include ../Make/Make.rs6000

#------------------------------------------------------------------------------
# remove object files and profile output
#------------------------------------------------------------------------------

clean:
	- $(RM) *.o *.obj *.ln *.bb *.bbg *.da *.c.tcov *.c.gcov gmon.out *.bak
