FUNCTION(ff_install_package LIBRARY_NAME)
    
IF(ENABLE_DOWNLOAD)
    INCLUDE(ExternalProject)


    IF(NOT FF_DOWNLOAD_DIR)
        SET(FF_DOWNLOAD_DIR ${CMAKE_SOURCE_DIR}/download)
    ENDIF(NOT FF_DOWNLOAD_DIR)

    FILE(MAKE_DIRECTORY ${FF_DOWNLOAD_DIR}/include)
    FILE(MAKE_DIRECTORY ${FF_DOWNLOAD_DIR}/include/coin)
    
    INCLUDE(Install${LIBRARY_NAME})

    STRING(TOLOWER ${LIBRARY_NAME} LIBRARY_LOWERNAME)
    STRING(TOUPPER ${LIBRARY_NAME} LIBRARY_UPPERNAME)

    SET(${LIBRARY_UPPERNAME}_PREFIX ${FF_DOWNLOAD_DIR}/${LIBRARY_LOWERNAME} )
    SET(${LIBRARY_UPPERNAME}_DOWNLOAD_DIR ${FF_DOWNLOAD_DIR}/pkg)
    SET(${LIBRARY_UPPERNAME}_SOURCE_DIR ${${LIBRARY_UPPERNAME}_PREFIX}/src)
    SET(${LIBRARY_UPPERNAME}_BINARY_DIR ${${LIBRARY_UPPERNAME}_PREFIX}/build)
    SET(${LIBRARY_UPPERNAME}_TMP_DIR ${${LIBRARY_UPPERNAME}_PREFIX}/tmp)
    SET(${LIBRARY_UPPERNAME}_STAMP_DIR ${${LIBRARY_UPPERNAME}_PREFIX}/stamp)
    SET(${LIBRARY_UPPERNAME}_INSTALL_DIR ${FF_DOWNLOAD_DIR})

    EXTERNALPROJECT_ADD(freefem_${LIBRARY_LOWERNAME}
                    PREFIX ${${LIBRARY_UPPERNAME}_PREFIX}
                    DOWNLOAD_DIR ${${LIBRARY_UPPERNAME}_DOWNLOAD_DIR}
                    SOURCE_DIR ${${LIBRARY_UPPERNAME}_SOURCE_DIR}
                    BINARY_DIR ${${LIBRARY_UPPERNAME}_BINARY_DIR}
                    TMP_DIR ${${LIBRARY_UPPERNAME}_TMP_DIR}
                    STAMP_DIR ${${LIBRARY_UPPERNAME}_STAMP_DIR}
                    INSTALL_DIR ${${LIBRARY_UPPERNAME}_INSTALL_DIR}
                    URL ${URL}
                    URL_MD5 ${URL_MD5}
                    CMAKE_ARGS ${CMAKE_ARGS}
                    CMAKE_COMMAND ${CMAKE_COMMAND}
                    PATCH_COMMAND ${PATCH_COMMAND}
                    CONFIGURE_COMMAND ${CONFIGURE_COMMAND}
                    BUILD_COMMAND ${BUILD_COMMAND}
                    INSTALL_COMMAND ${INSTALL_COMMAND}
                    LOG_UPDATE 1
                    LOG_TEST 1
                   )

  SET(${LIBRARY_UPPERNAME}_INSTALL_DIR ${${LIBRARY_UPPERNAME}_PREFIX}/install PARENT_SCOPE)
    

  # set default value to INCLUDE_PATHS if not defined

  IF (NOT INCLUDE_PATHS)
    SET(INCLUDE_PATHS ${FF_DOWNLOAD_DIR}/include)
  ENDIF(NOT INCLUDE_PATHS)

  # set default value to LIBRARY_PATHS if not defined

  IF (NOT LIBRARY_PATHS)
    SET(LIBRARY_PATHS ${FF_DOWNLOAD_DIR}/lib)
  ENDIF(NOT LIBRARY_PATHS)

  # return useful variables to compile and link against the library 

  SET(FREEFEM_${LIBRARY_UPPERNAME}_INSTALLED TRUE PARENT_SCOPE) 
  SET(FREEFEM_${LIBRARY_UPPERNAME}_INCLUDE_PATHS ${INCLUDE_PATHS} PARENT_SCOPE)
  SET(FREEFEM_${LIBRARY_UPPERNAME}_LIBRARY_PATHS ${LIBRARY_PATHS} PARENT_SCOPE)

  # create an imported target

  ADD_LIBRARY(FREEFEM::${LIBRARY_UPPERNAME} UNKNOWN IMPORTED)
  STRING(CONCAT LIBRARY_PATHS ${LIBRARY_PATHS} "/" ${LIBRARIES})
  SET_TARGET_PROPERTIES(FREEFEM::${LIBRARY_UPPERNAME} PROPERTIES IMPORTED_LOCATION ${LIBRARY_PATHS})
  SET_TARGET_PROPERTIES(FREEFEM::${LIBRARY_UPPERNAME} PROPERTIES INTERFACE_INCLUDE_DIRECTORIES "${INCLUDE_PATHS}")
  ADD_DEPENDENCIES(FREEFEM::${LIBRARY_UPPERNAME} freefem_${LIBRARY_LOWERNAME})

  IF(FREEFEM_VERBOSE)
    MESSAGE(STATUS "FREEFEM_INSTALL_PACKAGE: INCLUDE_PATHS=${INCLUDE_PATHS}")
    MESSAGE(STATUS "FREEFEM_INSTALL_PACKAGE: LIBRARY_PATHS=${LIBRARY_PATHS}")
  ENDIF(FREEFEM_VERBOSE)

ENDIF(ENABLE_DOWNLOAD)


ENDFUNCTION(ff_install_package)
