// -*- C++ -*-

// Copyright (C) 2005-2023 Free Software Foundation, Inc.
//
// This file is part of the GNU ISO C++ Library.  This library is free
// software; you can redistribute it and/or modify it under the terms
// of the GNU General Public License as published by the Free Software
// Foundation; either version 3, or (at your option) any later
// version.

// This library is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this library; see the file COPYING3.  If not see
// <http://www.gnu.org/licenses/>.


// Copyright (C) 2004 Ami Tavory and Vladimir Dreizin, IBM-HRL.

// Permission to use, copy, modify, sell, and distribute this software
// is hereby granted without fee, provided that the above copyright
// notice appears in all copies, and that both that copyright notice
// and this permission notice appear in supporting documentation. None
// of the above authors, nor IBM Haifa Research Laboratories, make any
// representation about the suitability of this software for any
// purpose. It is provided "as is" without express or implied
// warranty.

/**
 * @file trie_supports_prefix_search.hpp
 * Checks whether a trie supports prefix search.
 */

#ifndef PB_DS_TRIE_SUPPORTS_PREFIX_SEARCH_HPP
#define PB_DS_TRIE_SUPPORTS_PREFIX_SEARCH_HPP

#include <ext/pb_ds/trie_policy.hpp>

namespace __gnu_pbds
{

  namespace test
  {

    namespace detail
    {

      template<typename Tree_Cntnr>
      struct trie_supports_prefix_search
      {
	enum
	  {
	    value = __gnu_pbds::detail::is_same<
            typename Tree_Cntnr::node_update,
            __gnu_pbds::trie_prefix_search_node_update<
            typename Tree_Cntnr::node_const_iterator,
            typename Tree_Cntnr::node_iterator,
            typename Tree_Cntnr::access_traits,
            typename Tree_Cntnr::allocator_type> >::value
	  };
      };

    } // namespace detail

  } // namespace test

} // namespace __gnu_pbds

#endif // #ifndef PB_DS_TRIE_SUPPORTS_PREFIX_SEARCH_HPP

