
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2025 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQMediaPlayer.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include <QMediaPlayer>
#include <QVideoWidget>
#include <QGraphicsVideoItem>
#include <QMediaPlaylist>
#include <QAbstractVideoSurface>
#include <QMediaService>
#include "gsiQt.h"
#include "gsiQtMultimediaCommon.h"
#include <memory>

// -----------------------------------------------------------------------
// class QMediaPlayer

//  get static meta object

static void _init_smo (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<const QMetaObject &> ();
}

static void _call_smo (const qt_gsi::GenericStaticMethod *, gsi::SerialArgs &, gsi::SerialArgs &ret) 
{
  ret.write<const QMetaObject &> (QMediaPlayer::staticMetaObject);
}


// QAudio::Role QMediaPlayer::audioRole()


static void _init_f_audioRole_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QAudio::Role>::target_type > ();
}

static void _call_f_audioRole_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QAudio::Role>::target_type > ((qt_gsi::Converter<QAudio::Role>::target_type)qt_gsi::CppToQtAdaptor<QAudio::Role>(((QMediaPlayer *)cls)->audioRole ()));
}


// QMultimedia::AvailabilityStatus QMediaPlayer::availability()


static void _init_f_availability_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QMultimedia::AvailabilityStatus>::target_type > ();
}

static void _call_f_availability_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QMultimedia::AvailabilityStatus>::target_type > ((qt_gsi::Converter<QMultimedia::AvailabilityStatus>::target_type)qt_gsi::CppToQtAdaptor<QMultimedia::AvailabilityStatus>(((QMediaPlayer *)cls)->availability ()));
}


// bool QMediaPlayer::bind(QObject *)


static void _init_f_bind_1302 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_bind_1302 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = gsi::arg_reader<QObject * >() (args, heap);
  ret.write<bool > ((bool)((QMediaPlayer *)cls)->bind (arg1));
}


// int QMediaPlayer::bufferStatus()


static void _init_f_bufferStatus_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_bufferStatus_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QMediaPlayer *)cls)->bufferStatus ());
}


// QMediaContent QMediaPlayer::currentMedia()


static void _init_f_currentMedia_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QMediaContent > ();
}

static void _call_f_currentMedia_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QMediaContent > ((QMediaContent)((QMediaPlayer *)cls)->currentMedia ());
}


// QNetworkConfiguration QMediaPlayer::currentNetworkConfiguration()


static void _init_f_currentNetworkConfiguration_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QNetworkConfiguration > ();
}

static void _call_f_currentNetworkConfiguration_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QNetworkConfiguration > ((QNetworkConfiguration)((QMediaPlayer *)cls)->currentNetworkConfiguration ());
}


// QString QMediaPlayer::customAudioRole()


static void _init_f_customAudioRole_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_customAudioRole_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)((QMediaPlayer *)cls)->customAudioRole ());
}


// qint64 QMediaPlayer::duration()


static void _init_f_duration_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qint64 > ();
}

static void _call_f_duration_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qint64 > ((qint64)((QMediaPlayer *)cls)->duration ());
}


// QMediaPlayer::Error QMediaPlayer::error()


static void _init_f_error_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QMediaPlayer::Error>::target_type > ();
}

static void _call_f_error_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QMediaPlayer::Error>::target_type > ((qt_gsi::Converter<QMediaPlayer::Error>::target_type)qt_gsi::CppToQtAdaptor<QMediaPlayer::Error>(((QMediaPlayer *)cls)->error ()));
}


// QString QMediaPlayer::errorString()


static void _init_f_errorString_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_errorString_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)((QMediaPlayer *)cls)->errorString ());
}


// bool QMediaPlayer::isAudioAvailable()


static void _init_f_isAudioAvailable_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isAudioAvailable_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QMediaPlayer *)cls)->isAudioAvailable ());
}


// bool QMediaPlayer::isMuted()


static void _init_f_isMuted_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isMuted_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QMediaPlayer *)cls)->isMuted ());
}


// bool QMediaPlayer::isSeekable()


static void _init_f_isSeekable_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isSeekable_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QMediaPlayer *)cls)->isSeekable ());
}


// bool QMediaPlayer::isVideoAvailable()


static void _init_f_isVideoAvailable_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isVideoAvailable_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QMediaPlayer *)cls)->isVideoAvailable ());
}


// QMediaContent QMediaPlayer::media()


static void _init_f_media_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QMediaContent > ();
}

static void _call_f_media_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QMediaContent > ((QMediaContent)((QMediaPlayer *)cls)->media ());
}


// QMediaPlayer::MediaStatus QMediaPlayer::mediaStatus()


static void _init_f_mediaStatus_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QMediaPlayer::MediaStatus>::target_type > ();
}

static void _call_f_mediaStatus_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QMediaPlayer::MediaStatus>::target_type > ((qt_gsi::Converter<QMediaPlayer::MediaStatus>::target_type)qt_gsi::CppToQtAdaptor<QMediaPlayer::MediaStatus>(((QMediaPlayer *)cls)->mediaStatus ()));
}


// const QIODevice *QMediaPlayer::mediaStream()


static void _init_f_mediaStream_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<const QIODevice * > ();
}

static void _call_f_mediaStream_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<const QIODevice * > ((const QIODevice *)((QMediaPlayer *)cls)->mediaStream ());
}


// void QMediaPlayer::pause()


static void _init_f_pause_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_pause_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMediaPlayer *)cls)->pause ();
}


// void QMediaPlayer::play()


static void _init_f_play_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_play_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMediaPlayer *)cls)->play ();
}


// double QMediaPlayer::playbackRate()


static void _init_f_playbackRate_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<double > ();
}

static void _call_f_playbackRate_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<double > ((double)((QMediaPlayer *)cls)->playbackRate ());
}


// QMediaPlaylist *QMediaPlayer::playlist()


static void _init_f_playlist_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QMediaPlaylist * > ();
}

static void _call_f_playlist_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QMediaPlaylist * > ((QMediaPlaylist *)((QMediaPlayer *)cls)->playlist ());
}


// qint64 QMediaPlayer::position()


static void _init_f_position_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qint64 > ();
}

static void _call_f_position_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qint64 > ((qint64)((QMediaPlayer *)cls)->position ());
}


// void QMediaPlayer::setAudioRole(QAudio::Role audioRole)


static void _init_f_setAudioRole_1533 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("audioRole");
  decl->add_arg<const qt_gsi::Converter<QAudio::Role>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setAudioRole_1533 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QAudio::Role>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QAudio::Role>::target_type & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMediaPlayer *)cls)->setAudioRole (qt_gsi::QtToCppAdaptor<QAudio::Role>(arg1).cref());
}


// void QMediaPlayer::setCustomAudioRole(const QString &audioRole)


static void _init_f_setCustomAudioRole_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("audioRole");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setCustomAudioRole_2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMediaPlayer *)cls)->setCustomAudioRole (arg1);
}


// void QMediaPlayer::setMedia(const QMediaContent &media, QIODevice *stream)


static void _init_f_setMedia_3944 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("media");
  decl->add_arg<const QMediaContent & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("stream", true, "nullptr");
  decl->add_arg<QIODevice * > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setMedia_3944 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMediaContent &arg1 = gsi::arg_reader<const QMediaContent & >() (args, heap);
  QIODevice *arg2 = args ? gsi::arg_reader<QIODevice * >() (args, heap) : gsi::arg_maker<QIODevice * >() (nullptr, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMediaPlayer *)cls)->setMedia (arg1, arg2);
}


// void QMediaPlayer::setMuted(bool muted)


static void _init_f_setMuted_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("muted");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setMuted_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMediaPlayer *)cls)->setMuted (arg1);
}


// void QMediaPlayer::setNetworkConfigurations(const QList<QNetworkConfiguration> &configurations)


static void _init_f_setNetworkConfigurations_4123 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("configurations");
  decl->add_arg<const QList<QNetworkConfiguration> & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setNetworkConfigurations_4123 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QList<QNetworkConfiguration> &arg1 = gsi::arg_reader<const QList<QNetworkConfiguration> & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMediaPlayer *)cls)->setNetworkConfigurations (arg1);
}


// void QMediaPlayer::setPlaybackRate(double rate)


static void _init_f_setPlaybackRate_1071 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("rate");
  decl->add_arg<double > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setPlaybackRate_1071 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  double arg1 = gsi::arg_reader<double >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMediaPlayer *)cls)->setPlaybackRate (arg1);
}


// void QMediaPlayer::setPlaylist(QMediaPlaylist *playlist)


static void _init_f_setPlaylist_2033 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("playlist");
  decl->add_arg<QMediaPlaylist * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setPlaylist_2033 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QMediaPlaylist *arg1 = gsi::arg_reader<QMediaPlaylist * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMediaPlayer *)cls)->setPlaylist (arg1);
}


// void QMediaPlayer::setPosition(qint64 position)


static void _init_f_setPosition_986 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("position");
  decl->add_arg<qint64 > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setPosition_986 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  qint64 arg1 = gsi::arg_reader<qint64 >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMediaPlayer *)cls)->setPosition (arg1);
}


// void QMediaPlayer::setVideoOutput(QVideoWidget *)


static void _init_f_setVideoOutput_1818 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QVideoWidget * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setVideoOutput_1818 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QVideoWidget *arg1 = gsi::arg_reader<QVideoWidget * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMediaPlayer *)cls)->setVideoOutput (arg1);
}


// void QMediaPlayer::setVideoOutput(QGraphicsVideoItem *)


static void _init_f_setVideoOutput_2422 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QGraphicsVideoItem * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setVideoOutput_2422 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QGraphicsVideoItem *arg1 = gsi::arg_reader<QGraphicsVideoItem * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMediaPlayer *)cls)->setVideoOutput (arg1);
}


// void QMediaPlayer::setVideoOutput(QAbstractVideoSurface *surface)


static void _init_f_setVideoOutput_2739 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("surface");
  decl->add_arg<QAbstractVideoSurface * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setVideoOutput_2739 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QAbstractVideoSurface *arg1 = gsi::arg_reader<QAbstractVideoSurface * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMediaPlayer *)cls)->setVideoOutput (arg1);
}


// void QMediaPlayer::setVolume(int volume)


static void _init_f_setVolume_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("volume");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setVolume_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMediaPlayer *)cls)->setVolume (arg1);
}


// QMediaPlayer::State QMediaPlayer::state()


static void _init_f_state_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QMediaPlayer::State>::target_type > ();
}

static void _call_f_state_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QMediaPlayer::State>::target_type > ((qt_gsi::Converter<QMediaPlayer::State>::target_type)qt_gsi::CppToQtAdaptor<QMediaPlayer::State>(((QMediaPlayer *)cls)->state ()));
}


// void QMediaPlayer::stop()


static void _init_f_stop_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_stop_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMediaPlayer *)cls)->stop ();
}


// QList<QAudio::Role> QMediaPlayer::supportedAudioRoles()


static void _init_f_supportedAudioRoles_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QList<QAudio::Role> > ();
}

static void _call_f_supportedAudioRoles_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QList<QAudio::Role> > ((QList<QAudio::Role>)((QMediaPlayer *)cls)->supportedAudioRoles ());
}


// QStringList QMediaPlayer::supportedCustomAudioRoles()


static void _init_f_supportedCustomAudioRoles_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QStringList > ();
}

static void _call_f_supportedCustomAudioRoles_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QStringList > ((QStringList)((QMediaPlayer *)cls)->supportedCustomAudioRoles ());
}


// void QMediaPlayer::unbind(QObject *)


static void _init_f_unbind_1302 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_unbind_1302 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = gsi::arg_reader<QObject * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMediaPlayer *)cls)->unbind (arg1);
}


// int QMediaPlayer::volume()


static void _init_f_volume_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_volume_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QMediaPlayer *)cls)->volume ());
}


// static QMultimedia::SupportEstimate QMediaPlayer::hasSupport(const QString &mimeType, const QStringList &codecs, QFlags<QMediaPlayer::Flag> flags)


static void _init_f_hasSupport_7054 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("mimeType");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("codecs", true, "QStringList()");
  decl->add_arg<const QStringList & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("flags", true, "QMediaPlayer::Flags()");
  decl->add_arg<QFlags<QMediaPlayer::Flag> > (argspec_2);
  decl->set_return<qt_gsi::Converter<QMultimedia::SupportEstimate>::target_type > ();
}

static void _call_f_hasSupport_7054 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  const QStringList &arg2 = args ? gsi::arg_reader<const QStringList & >() (args, heap) : gsi::arg_maker<const QStringList & >() (QStringList(), heap);
  QFlags<QMediaPlayer::Flag> arg3 = args ? gsi::arg_reader<QFlags<QMediaPlayer::Flag> >() (args, heap) : gsi::arg_maker<QFlags<QMediaPlayer::Flag> >() (QMediaPlayer::Flags(), heap);
  ret.write<qt_gsi::Converter<QMultimedia::SupportEstimate>::target_type > ((qt_gsi::Converter<QMultimedia::SupportEstimate>::target_type)qt_gsi::CppToQtAdaptor<QMultimedia::SupportEstimate>(QMediaPlayer::hasSupport (arg1, arg2, arg3)));
}


// static QStringList QMediaPlayer::supportedMimeTypes(QFlags<QMediaPlayer::Flag> flags)


static void _init_f_supportedMimeTypes_2808 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("flags", true, "QMediaPlayer::Flags()");
  decl->add_arg<QFlags<QMediaPlayer::Flag> > (argspec_0);
  decl->set_return<QStringList > ();
}

static void _call_f_supportedMimeTypes_2808 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QFlags<QMediaPlayer::Flag> arg1 = args ? gsi::arg_reader<QFlags<QMediaPlayer::Flag> >() (args, heap) : gsi::arg_maker<QFlags<QMediaPlayer::Flag> >() (QMediaPlayer::Flags(), heap);
  ret.write<QStringList > ((QStringList)QMediaPlayer::supportedMimeTypes (arg1));
}


// static QString QMediaPlayer::tr(const char *s, const char *c, int n)


static void _init_f_tr_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "nullptr");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n", true, "-1");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_tr_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (nullptr, heap);
  int arg3 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (-1, heap);
  ret.write<QString > ((QString)QMediaPlayer::tr (arg1, arg2, arg3));
}


// static QString QMediaPlayer::trUtf8(const char *s, const char *c, int n)


static void _init_f_trUtf8_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "nullptr");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n", true, "-1");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (nullptr, heap);
  int arg3 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (-1, heap);
  ret.write<QString > ((QString)QMediaPlayer::trUtf8 (arg1, arg2, arg3));
}


namespace gsi
{

static gsi::Methods methods_QMediaPlayer () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("staticMetaObject", "@brief Obtains the static MetaObject for this class.", &_init_smo, &_call_smo);
  methods += new qt_gsi::GenericMethod (":audioRole", "@brief Method QAudio::Role QMediaPlayer::audioRole()\n", true, &_init_f_audioRole_c0, &_call_f_audioRole_c0);
  methods += new qt_gsi::GenericMethod ("availability", "@brief Method QMultimedia::AvailabilityStatus QMediaPlayer::availability()\nThis is a reimplementation of QMediaObject::availability", true, &_init_f_availability_c0, &_call_f_availability_c0);
  methods += new qt_gsi::GenericMethod ("bind", "@brief Method bool QMediaPlayer::bind(QObject *)\nThis is a reimplementation of QMediaObject::bind", false, &_init_f_bind_1302, &_call_f_bind_1302);
  methods += new qt_gsi::GenericMethod (":bufferStatus", "@brief Method int QMediaPlayer::bufferStatus()\n", true, &_init_f_bufferStatus_c0, &_call_f_bufferStatus_c0);
  methods += new qt_gsi::GenericMethod (":currentMedia", "@brief Method QMediaContent QMediaPlayer::currentMedia()\n", true, &_init_f_currentMedia_c0, &_call_f_currentMedia_c0);
  methods += new qt_gsi::GenericMethod ("currentNetworkConfiguration", "@brief Method QNetworkConfiguration QMediaPlayer::currentNetworkConfiguration()\n", true, &_init_f_currentNetworkConfiguration_c0, &_call_f_currentNetworkConfiguration_c0);
  methods += new qt_gsi::GenericMethod (":customAudioRole", "@brief Method QString QMediaPlayer::customAudioRole()\n", true, &_init_f_customAudioRole_c0, &_call_f_customAudioRole_c0);
  methods += new qt_gsi::GenericMethod (":duration", "@brief Method qint64 QMediaPlayer::duration()\n", true, &_init_f_duration_c0, &_call_f_duration_c0);
  methods += new qt_gsi::GenericMethod ("error", "@brief Method QMediaPlayer::Error QMediaPlayer::error()\n", true, &_init_f_error_c0, &_call_f_error_c0);
  methods += new qt_gsi::GenericMethod ("errorString", "@brief Method QString QMediaPlayer::errorString()\n", true, &_init_f_errorString_c0, &_call_f_errorString_c0);
  methods += new qt_gsi::GenericMethod ("isAudioAvailable?|:audioAvailable", "@brief Method bool QMediaPlayer::isAudioAvailable()\n", true, &_init_f_isAudioAvailable_c0, &_call_f_isAudioAvailable_c0);
  methods += new qt_gsi::GenericMethod ("isMuted?|:muted", "@brief Method bool QMediaPlayer::isMuted()\n", true, &_init_f_isMuted_c0, &_call_f_isMuted_c0);
  methods += new qt_gsi::GenericMethod ("isSeekable?|:seekable", "@brief Method bool QMediaPlayer::isSeekable()\n", true, &_init_f_isSeekable_c0, &_call_f_isSeekable_c0);
  methods += new qt_gsi::GenericMethod ("isVideoAvailable?|:videoAvailable", "@brief Method bool QMediaPlayer::isVideoAvailable()\n", true, &_init_f_isVideoAvailable_c0, &_call_f_isVideoAvailable_c0);
  methods += new qt_gsi::GenericMethod (":media", "@brief Method QMediaContent QMediaPlayer::media()\n", true, &_init_f_media_c0, &_call_f_media_c0);
  methods += new qt_gsi::GenericMethod (":mediaStatus", "@brief Method QMediaPlayer::MediaStatus QMediaPlayer::mediaStatus()\n", true, &_init_f_mediaStatus_c0, &_call_f_mediaStatus_c0);
  methods += new qt_gsi::GenericMethod ("mediaStream", "@brief Method const QIODevice *QMediaPlayer::mediaStream()\n", true, &_init_f_mediaStream_c0, &_call_f_mediaStream_c0);
  methods += new qt_gsi::GenericMethod ("pause", "@brief Method void QMediaPlayer::pause()\n", false, &_init_f_pause_0, &_call_f_pause_0);
  methods += new qt_gsi::GenericMethod ("play", "@brief Method void QMediaPlayer::play()\n", false, &_init_f_play_0, &_call_f_play_0);
  methods += new qt_gsi::GenericMethod (":playbackRate", "@brief Method double QMediaPlayer::playbackRate()\n", true, &_init_f_playbackRate_c0, &_call_f_playbackRate_c0);
  methods += new qt_gsi::GenericMethod (":playlist", "@brief Method QMediaPlaylist *QMediaPlayer::playlist()\n", true, &_init_f_playlist_c0, &_call_f_playlist_c0);
  methods += new qt_gsi::GenericMethod (":position", "@brief Method qint64 QMediaPlayer::position()\n", true, &_init_f_position_c0, &_call_f_position_c0);
  methods += new qt_gsi::GenericMethod ("setAudioRole|audioRole=", "@brief Method void QMediaPlayer::setAudioRole(QAudio::Role audioRole)\n", false, &_init_f_setAudioRole_1533, &_call_f_setAudioRole_1533);
  methods += new qt_gsi::GenericMethod ("setCustomAudioRole|customAudioRole=", "@brief Method void QMediaPlayer::setCustomAudioRole(const QString &audioRole)\n", false, &_init_f_setCustomAudioRole_2025, &_call_f_setCustomAudioRole_2025);
  methods += new qt_gsi::GenericMethod ("setMedia", "@brief Method void QMediaPlayer::setMedia(const QMediaContent &media, QIODevice *stream)\n", false, &_init_f_setMedia_3944, &_call_f_setMedia_3944);
  methods += new qt_gsi::GenericMethod ("setMuted|muted=", "@brief Method void QMediaPlayer::setMuted(bool muted)\n", false, &_init_f_setMuted_864, &_call_f_setMuted_864);
  methods += new qt_gsi::GenericMethod ("setNetworkConfigurations", "@brief Method void QMediaPlayer::setNetworkConfigurations(const QList<QNetworkConfiguration> &configurations)\n", false, &_init_f_setNetworkConfigurations_4123, &_call_f_setNetworkConfigurations_4123);
  methods += new qt_gsi::GenericMethod ("setPlaybackRate|playbackRate=", "@brief Method void QMediaPlayer::setPlaybackRate(double rate)\n", false, &_init_f_setPlaybackRate_1071, &_call_f_setPlaybackRate_1071);
  methods += new qt_gsi::GenericMethod ("setPlaylist|playlist=", "@brief Method void QMediaPlayer::setPlaylist(QMediaPlaylist *playlist)\n", false, &_init_f_setPlaylist_2033, &_call_f_setPlaylist_2033);
  methods += new qt_gsi::GenericMethod ("setPosition|position=", "@brief Method void QMediaPlayer::setPosition(qint64 position)\n", false, &_init_f_setPosition_986, &_call_f_setPosition_986);
  methods += new qt_gsi::GenericMethod ("setVideoOutput", "@brief Method void QMediaPlayer::setVideoOutput(QVideoWidget *)\n", false, &_init_f_setVideoOutput_1818, &_call_f_setVideoOutput_1818);
  methods += new qt_gsi::GenericMethod ("setVideoOutput", "@brief Method void QMediaPlayer::setVideoOutput(QGraphicsVideoItem *)\n", false, &_init_f_setVideoOutput_2422, &_call_f_setVideoOutput_2422);
  methods += new qt_gsi::GenericMethod ("setVideoOutput", "@brief Method void QMediaPlayer::setVideoOutput(QAbstractVideoSurface *surface)\n", false, &_init_f_setVideoOutput_2739, &_call_f_setVideoOutput_2739);
  methods += new qt_gsi::GenericMethod ("setVolume|volume=", "@brief Method void QMediaPlayer::setVolume(int volume)\n", false, &_init_f_setVolume_767, &_call_f_setVolume_767);
  methods += new qt_gsi::GenericMethod (":state", "@brief Method QMediaPlayer::State QMediaPlayer::state()\n", true, &_init_f_state_c0, &_call_f_state_c0);
  methods += new qt_gsi::GenericMethod ("stop", "@brief Method void QMediaPlayer::stop()\n", false, &_init_f_stop_0, &_call_f_stop_0);
  methods += new qt_gsi::GenericMethod ("supportedAudioRoles", "@brief Method QList<QAudio::Role> QMediaPlayer::supportedAudioRoles()\n", true, &_init_f_supportedAudioRoles_c0, &_call_f_supportedAudioRoles_c0);
  methods += new qt_gsi::GenericMethod ("supportedCustomAudioRoles", "@brief Method QStringList QMediaPlayer::supportedCustomAudioRoles()\n", true, &_init_f_supportedCustomAudioRoles_c0, &_call_f_supportedCustomAudioRoles_c0);
  methods += new qt_gsi::GenericMethod ("unbind", "@brief Method void QMediaPlayer::unbind(QObject *)\nThis is a reimplementation of QMediaObject::unbind", false, &_init_f_unbind_1302, &_call_f_unbind_1302);
  methods += new qt_gsi::GenericMethod (":volume", "@brief Method int QMediaPlayer::volume()\n", true, &_init_f_volume_c0, &_call_f_volume_c0);
  methods += gsi::qt_signal<bool > ("audioAvailableChanged(bool)", "audioAvailableChanged", gsi::arg("available"), "@brief Signal declaration for QMediaPlayer::audioAvailableChanged(bool available)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const qt_gsi::Converter<QAudio::Role>::target_type & > ("audioRoleChanged(QAudio::Role)", "audioRoleChanged", gsi::arg("role"), "@brief Signal declaration for QMediaPlayer::audioRoleChanged(QAudio::Role role)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<bool > ("availabilityChanged(bool)", "availabilityChanged_bool", gsi::arg("available"), "@brief Signal declaration for QMediaPlayer::availabilityChanged(bool available)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const qt_gsi::Converter<QMultimedia::AvailabilityStatus>::target_type & > ("availabilityChanged(QMultimedia::AvailabilityStatus)", "availabilityChanged_status", gsi::arg("availability"), "@brief Signal declaration for QMediaPlayer::availabilityChanged(QMultimedia::AvailabilityStatus availability)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<int > ("bufferStatusChanged(int)", "bufferStatusChanged", gsi::arg("percentFilled"), "@brief Signal declaration for QMediaPlayer::bufferStatusChanged(int percentFilled)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QMediaContent & > ("currentMediaChanged(const QMediaContent &)", "currentMediaChanged", gsi::arg("media"), "@brief Signal declaration for QMediaPlayer::currentMediaChanged(const QMediaContent &media)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QString & > ("customAudioRoleChanged(const QString &)", "customAudioRoleChanged", gsi::arg("role"), "@brief Signal declaration for QMediaPlayer::customAudioRoleChanged(const QString &role)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<QObject * > ("destroyed(QObject *)", "destroyed", gsi::arg("arg1"), "@brief Signal declaration for QMediaPlayer::destroyed(QObject *)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<qint64 > ("durationChanged(qint64)", "durationChanged", gsi::arg("duration"), "@brief Signal declaration for QMediaPlayer::durationChanged(qint64 duration)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const qt_gsi::Converter<QMediaPlayer::Error>::target_type & > ("error(QMediaPlayer::Error)", "error_sig", gsi::arg("error"), "@brief Signal declaration for QMediaPlayer::error(QMediaPlayer::Error error)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QMediaContent & > ("mediaChanged(const QMediaContent &)", "mediaChanged", gsi::arg("media"), "@brief Signal declaration for QMediaPlayer::mediaChanged(const QMediaContent &media)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const qt_gsi::Converter<QMediaPlayer::MediaStatus>::target_type & > ("mediaStatusChanged(QMediaPlayer::MediaStatus)", "mediaStatusChanged", gsi::arg("status"), "@brief Signal declaration for QMediaPlayer::mediaStatusChanged(QMediaPlayer::MediaStatus status)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<bool > ("metaDataAvailableChanged(bool)", "metaDataAvailableChanged", gsi::arg("available"), "@brief Signal declaration for QMediaPlayer::metaDataAvailableChanged(bool available)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal ("metaDataChanged()", "metaDataChanged", "@brief Signal declaration for QMediaPlayer::metaDataChanged()\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QString &, const QVariant & > ("metaDataChanged(const QString &, const QVariant &)", "metaDataChanged_kv", gsi::arg("key"), gsi::arg("value"), "@brief Signal declaration for QMediaPlayer::metaDataChanged(const QString &key, const QVariant &value)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<bool > ("mutedChanged(bool)", "mutedChanged", gsi::arg("muted"), "@brief Signal declaration for QMediaPlayer::mutedChanged(bool muted)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QNetworkConfiguration & > ("networkConfigurationChanged(const QNetworkConfiguration &)", "networkConfigurationChanged", gsi::arg("configuration"), "@brief Signal declaration for QMediaPlayer::networkConfigurationChanged(const QNetworkConfiguration &configuration)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<int > ("notifyIntervalChanged(int)", "notifyIntervalChanged", gsi::arg("milliSeconds"), "@brief Signal declaration for QMediaPlayer::notifyIntervalChanged(int milliSeconds)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QString & > ("objectNameChanged(const QString &)", "objectNameChanged", gsi::arg("objectName"), "@brief Signal declaration for QMediaPlayer::objectNameChanged(const QString &objectName)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<double > ("playbackRateChanged(double)", "playbackRateChanged", gsi::arg("rate"), "@brief Signal declaration for QMediaPlayer::playbackRateChanged(double rate)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<qint64 > ("positionChanged(qint64)", "positionChanged", gsi::arg("position"), "@brief Signal declaration for QMediaPlayer::positionChanged(qint64 position)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<bool > ("seekableChanged(bool)", "seekableChanged", gsi::arg("seekable"), "@brief Signal declaration for QMediaPlayer::seekableChanged(bool seekable)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const qt_gsi::Converter<QMediaPlayer::State>::target_type & > ("stateChanged(QMediaPlayer::State)", "stateChanged", gsi::arg("newState"), "@brief Signal declaration for QMediaPlayer::stateChanged(QMediaPlayer::State newState)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<bool > ("videoAvailableChanged(bool)", "videoAvailableChanged", gsi::arg("videoAvailable"), "@brief Signal declaration for QMediaPlayer::videoAvailableChanged(bool videoAvailable)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<int > ("volumeChanged(int)", "volumeChanged", gsi::arg("volume"), "@brief Signal declaration for QMediaPlayer::volumeChanged(int volume)\nYou can bind a procedure to this signal.");
  methods += new qt_gsi::GenericStaticMethod ("hasSupport", "@brief Static method QMultimedia::SupportEstimate QMediaPlayer::hasSupport(const QString &mimeType, const QStringList &codecs, QFlags<QMediaPlayer::Flag> flags)\nThis method is static and can be called without an instance.", &_init_f_hasSupport_7054, &_call_f_hasSupport_7054);
  methods += new qt_gsi::GenericStaticMethod ("supportedMimeTypes", "@brief Static method QStringList QMediaPlayer::supportedMimeTypes(QFlags<QMediaPlayer::Flag> flags)\nThis method is static and can be called without an instance.", &_init_f_supportedMimeTypes_2808, &_call_f_supportedMimeTypes_2808);
  methods += new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QMediaPlayer::tr(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_tr_4013, &_call_f_tr_4013);
  methods += new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QMediaPlayer::trUtf8(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_4013, &_call_f_trUtf8_4013);
  return methods;
}

gsi::Class<QMediaObject> &qtdecl_QMediaObject ();

qt_gsi::QtNativeClass<QMediaPlayer> decl_QMediaPlayer (qtdecl_QMediaObject (), "QtMultimedia", "QMediaPlayer_Native",
  methods_QMediaPlayer (),
  "@hide\n@alias QMediaPlayer");

GSI_QTMULTIMEDIA_PUBLIC gsi::Class<QMediaPlayer> &qtdecl_QMediaPlayer () { return decl_QMediaPlayer; }

}


class QMediaPlayer_Adaptor : public QMediaPlayer, public qt_gsi::QtObjectBase
{
public:

  virtual ~QMediaPlayer_Adaptor();

  //  [adaptor ctor] QMediaPlayer::QMediaPlayer(QObject *parent, QFlags<QMediaPlayer::Flag> flags)
  QMediaPlayer_Adaptor() : QMediaPlayer()
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QMediaPlayer::QMediaPlayer(QObject *parent, QFlags<QMediaPlayer::Flag> flags)
  QMediaPlayer_Adaptor(QObject *parent) : QMediaPlayer(parent)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QMediaPlayer::QMediaPlayer(QObject *parent, QFlags<QMediaPlayer::Flag> flags)
  QMediaPlayer_Adaptor(QObject *parent, QFlags<QMediaPlayer::Flag> flags) : QMediaPlayer(parent, flags)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [expose] void QMediaPlayer::addPropertyWatch(const QByteArray &name)
  void fp_QMediaPlayer_addPropertyWatch_2309 (const QByteArray &name) {
    QMediaPlayer::addPropertyWatch(name);
  }

  //  [expose] bool QMediaPlayer::isSignalConnected(const QMetaMethod &signal)
  bool fp_QMediaPlayer_isSignalConnected_c2394 (const QMetaMethod &signal) const {
    return QMediaPlayer::isSignalConnected(signal);
  }

  //  [expose] int QMediaPlayer::receivers(const char *signal)
  int fp_QMediaPlayer_receivers_c1731 (const char *signal) const {
    return QMediaPlayer::receivers(signal);
  }

  //  [expose] void QMediaPlayer::removePropertyWatch(const QByteArray &name)
  void fp_QMediaPlayer_removePropertyWatch_2309 (const QByteArray &name) {
    QMediaPlayer::removePropertyWatch(name);
  }

  //  [expose] QObject *QMediaPlayer::sender()
  QObject * fp_QMediaPlayer_sender_c0 () const {
    return QMediaPlayer::sender();
  }

  //  [expose] int QMediaPlayer::senderSignalIndex()
  int fp_QMediaPlayer_senderSignalIndex_c0 () const {
    return QMediaPlayer::senderSignalIndex();
  }

  //  [emitter impl] void QMediaPlayer::audioAvailableChanged(bool available)
  void emitter_QMediaPlayer_audioAvailableChanged_864(bool available)
  {
    emit QMediaPlayer::audioAvailableChanged(available);
  }

  //  [emitter impl] void QMediaPlayer::audioRoleChanged(QAudio::Role role)
  void emitter_QMediaPlayer_audioRoleChanged_1533(QAudio::Role role)
  {
    emit QMediaPlayer::audioRoleChanged(role);
  }

  //  [adaptor impl] QMultimedia::AvailabilityStatus QMediaPlayer::availability()
  qt_gsi::Converter<QMultimedia::AvailabilityStatus>::target_type cbs_availability_c0_0() const
  {
    return qt_gsi::CppToQtAdaptor<QMultimedia::AvailabilityStatus>(QMediaPlayer::availability());
  }

  virtual QMultimedia::AvailabilityStatus availability() const
  {
    if (cb_availability_c0_0.can_issue()) {
      return qt_gsi::QtToCppAdaptor<QMultimedia::AvailabilityStatus>(cb_availability_c0_0.issue<QMediaPlayer_Adaptor, qt_gsi::Converter<QMultimedia::AvailabilityStatus>::target_type>(&QMediaPlayer_Adaptor::cbs_availability_c0_0)).cref();
    } else {
      return QMediaPlayer::availability();
    }
  }

  //  [emitter impl] void QMediaPlayer::availabilityChanged(bool available)
  void emitter_QMediaPlayer_availabilityChanged_864(bool available)
  {
    emit QMediaPlayer::availabilityChanged(available);
  }

  //  [emitter impl] void QMediaPlayer::availabilityChanged(QMultimedia::AvailabilityStatus availability)
  void emitter_QMediaPlayer_availabilityChanged_3555(QMultimedia::AvailabilityStatus availability)
  {
    emit QMediaPlayer::availabilityChanged(availability);
  }

  //  [adaptor impl] bool QMediaPlayer::bind(QObject *)
  bool cbs_bind_1302_0(QObject *arg1)
  {
    return QMediaPlayer::bind(arg1);
  }

  virtual bool bind(QObject *arg1)
  {
    if (cb_bind_1302_0.can_issue()) {
      return cb_bind_1302_0.issue<QMediaPlayer_Adaptor, bool, QObject *>(&QMediaPlayer_Adaptor::cbs_bind_1302_0, arg1);
    } else {
      return QMediaPlayer::bind(arg1);
    }
  }

  //  [emitter impl] void QMediaPlayer::bufferStatusChanged(int percentFilled)
  void emitter_QMediaPlayer_bufferStatusChanged_767(int percentFilled)
  {
    emit QMediaPlayer::bufferStatusChanged(percentFilled);
  }

  //  [emitter impl] void QMediaPlayer::currentMediaChanged(const QMediaContent &media)
  void emitter_QMediaPlayer_currentMediaChanged_2605(const QMediaContent &media)
  {
    emit QMediaPlayer::currentMediaChanged(media);
  }

  //  [emitter impl] void QMediaPlayer::customAudioRoleChanged(const QString &role)
  void emitter_QMediaPlayer_customAudioRoleChanged_2025(const QString &role)
  {
    emit QMediaPlayer::customAudioRoleChanged(role);
  }

  //  [emitter impl] void QMediaPlayer::destroyed(QObject *)
  void emitter_QMediaPlayer_destroyed_1302(QObject *arg1)
  {
    emit QMediaPlayer::destroyed(arg1);
  }

  //  [emitter impl] void QMediaPlayer::durationChanged(qint64 duration)
  void emitter_QMediaPlayer_durationChanged_986(qint64 duration)
  {
    emit QMediaPlayer::durationChanged(duration);
  }

  //  [emitter impl] void QMediaPlayer::error(QMediaPlayer::Error error)
  void emitter_QMediaPlayer_error_2256(QMediaPlayer::Error _error)
  {
    emit QMediaPlayer::error(_error);
  }

  //  [adaptor impl] bool QMediaPlayer::event(QEvent *event)
  bool cbs_event_1217_0(QEvent *_event)
  {
    return QMediaPlayer::event(_event);
  }

  virtual bool event(QEvent *_event)
  {
    if (cb_event_1217_0.can_issue()) {
      return cb_event_1217_0.issue<QMediaPlayer_Adaptor, bool, QEvent *>(&QMediaPlayer_Adaptor::cbs_event_1217_0, _event);
    } else {
      return QMediaPlayer::event(_event);
    }
  }

  //  [adaptor impl] bool QMediaPlayer::eventFilter(QObject *watched, QEvent *event)
  bool cbs_eventFilter_2411_0(QObject *watched, QEvent *event)
  {
    return QMediaPlayer::eventFilter(watched, event);
  }

  virtual bool eventFilter(QObject *watched, QEvent *event)
  {
    if (cb_eventFilter_2411_0.can_issue()) {
      return cb_eventFilter_2411_0.issue<QMediaPlayer_Adaptor, bool, QObject *, QEvent *>(&QMediaPlayer_Adaptor::cbs_eventFilter_2411_0, watched, event);
    } else {
      return QMediaPlayer::eventFilter(watched, event);
    }
  }

  //  [adaptor impl] bool QMediaPlayer::isAvailable()
  bool cbs_isAvailable_c0_0() const
  {
    return QMediaPlayer::isAvailable();
  }

  virtual bool isAvailable() const
  {
    if (cb_isAvailable_c0_0.can_issue()) {
      return cb_isAvailable_c0_0.issue<QMediaPlayer_Adaptor, bool>(&QMediaPlayer_Adaptor::cbs_isAvailable_c0_0);
    } else {
      return QMediaPlayer::isAvailable();
    }
  }

  //  [emitter impl] void QMediaPlayer::mediaChanged(const QMediaContent &media)
  void emitter_QMediaPlayer_mediaChanged_2605(const QMediaContent &media)
  {
    emit QMediaPlayer::mediaChanged(media);
  }

  //  [emitter impl] void QMediaPlayer::mediaStatusChanged(QMediaPlayer::MediaStatus status)
  void emitter_QMediaPlayer_mediaStatusChanged_2858(QMediaPlayer::MediaStatus status)
  {
    emit QMediaPlayer::mediaStatusChanged(status);
  }

  //  [emitter impl] void QMediaPlayer::metaDataAvailableChanged(bool available)
  void emitter_QMediaPlayer_metaDataAvailableChanged_864(bool available)
  {
    emit QMediaPlayer::metaDataAvailableChanged(available);
  }

  //  [emitter impl] void QMediaPlayer::metaDataChanged()
  void emitter_QMediaPlayer_metaDataChanged_0()
  {
    emit QMediaPlayer::metaDataChanged();
  }

  //  [emitter impl] void QMediaPlayer::metaDataChanged(const QString &key, const QVariant &value)
  void emitter_QMediaPlayer_metaDataChanged_4036(const QString &key, const QVariant &value)
  {
    emit QMediaPlayer::metaDataChanged(key, value);
  }

  //  [emitter impl] void QMediaPlayer::mutedChanged(bool muted)
  void emitter_QMediaPlayer_mutedChanged_864(bool muted)
  {
    emit QMediaPlayer::mutedChanged(muted);
  }

  //  [emitter impl] void QMediaPlayer::networkConfigurationChanged(const QNetworkConfiguration &configuration)
  void emitter_QMediaPlayer_networkConfigurationChanged_3508(const QNetworkConfiguration &configuration)
  {
    emit QMediaPlayer::networkConfigurationChanged(configuration);
  }

  //  [emitter impl] void QMediaPlayer::notifyIntervalChanged(int milliSeconds)
  void emitter_QMediaPlayer_notifyIntervalChanged_767(int milliSeconds)
  {
    emit QMediaPlayer::notifyIntervalChanged(milliSeconds);
  }

  //  [emitter impl] void QMediaPlayer::objectNameChanged(const QString &objectName)
  void emitter_QMediaPlayer_objectNameChanged_4567(const QString &objectName)
  {
    __SUPPRESS_UNUSED_WARNING (objectName);
    throw tl::Exception ("Can't emit private signal 'void QMediaPlayer::objectNameChanged(const QString &objectName)'");
  }

  //  [emitter impl] void QMediaPlayer::playbackRateChanged(double rate)
  void emitter_QMediaPlayer_playbackRateChanged_1071(double rate)
  {
    emit QMediaPlayer::playbackRateChanged(rate);
  }

  //  [emitter impl] void QMediaPlayer::positionChanged(qint64 position)
  void emitter_QMediaPlayer_positionChanged_986(qint64 position)
  {
    emit QMediaPlayer::positionChanged(position);
  }

  //  [emitter impl] void QMediaPlayer::seekableChanged(bool seekable)
  void emitter_QMediaPlayer_seekableChanged_864(bool seekable)
  {
    emit QMediaPlayer::seekableChanged(seekable);
  }

  //  [adaptor impl] QMediaService *QMediaPlayer::service()
  QMediaService * cbs_service_c0_0() const
  {
    return QMediaPlayer::service();
  }

  virtual QMediaService * service() const
  {
    if (cb_service_c0_0.can_issue()) {
      return cb_service_c0_0.issue<QMediaPlayer_Adaptor, QMediaService *>(&QMediaPlayer_Adaptor::cbs_service_c0_0);
    } else {
      return QMediaPlayer::service();
    }
  }

  //  [emitter impl] void QMediaPlayer::stateChanged(QMediaPlayer::State newState)
  void emitter_QMediaPlayer_stateChanged_2247(QMediaPlayer::State newState)
  {
    emit QMediaPlayer::stateChanged(newState);
  }

  //  [adaptor impl] void QMediaPlayer::unbind(QObject *)
  void cbs_unbind_1302_0(QObject *arg1)
  {
    QMediaPlayer::unbind(arg1);
  }

  virtual void unbind(QObject *arg1)
  {
    if (cb_unbind_1302_0.can_issue()) {
      cb_unbind_1302_0.issue<QMediaPlayer_Adaptor, QObject *>(&QMediaPlayer_Adaptor::cbs_unbind_1302_0, arg1);
    } else {
      QMediaPlayer::unbind(arg1);
    }
  }

  //  [emitter impl] void QMediaPlayer::videoAvailableChanged(bool videoAvailable)
  void emitter_QMediaPlayer_videoAvailableChanged_864(bool videoAvailable)
  {
    emit QMediaPlayer::videoAvailableChanged(videoAvailable);
  }

  //  [emitter impl] void QMediaPlayer::volumeChanged(int volume)
  void emitter_QMediaPlayer_volumeChanged_767(int volume)
  {
    emit QMediaPlayer::volumeChanged(volume);
  }

  //  [adaptor impl] void QMediaPlayer::childEvent(QChildEvent *event)
  void cbs_childEvent_1701_0(QChildEvent *event)
  {
    QMediaPlayer::childEvent(event);
  }

  virtual void childEvent(QChildEvent *event)
  {
    if (cb_childEvent_1701_0.can_issue()) {
      cb_childEvent_1701_0.issue<QMediaPlayer_Adaptor, QChildEvent *>(&QMediaPlayer_Adaptor::cbs_childEvent_1701_0, event);
    } else {
      QMediaPlayer::childEvent(event);
    }
  }

  //  [adaptor impl] void QMediaPlayer::customEvent(QEvent *event)
  void cbs_customEvent_1217_0(QEvent *event)
  {
    QMediaPlayer::customEvent(event);
  }

  virtual void customEvent(QEvent *event)
  {
    if (cb_customEvent_1217_0.can_issue()) {
      cb_customEvent_1217_0.issue<QMediaPlayer_Adaptor, QEvent *>(&QMediaPlayer_Adaptor::cbs_customEvent_1217_0, event);
    } else {
      QMediaPlayer::customEvent(event);
    }
  }

  //  [adaptor impl] void QMediaPlayer::disconnectNotify(const QMetaMethod &signal)
  void cbs_disconnectNotify_2394_0(const QMetaMethod &signal)
  {
    QMediaPlayer::disconnectNotify(signal);
  }

  virtual void disconnectNotify(const QMetaMethod &signal)
  {
    if (cb_disconnectNotify_2394_0.can_issue()) {
      cb_disconnectNotify_2394_0.issue<QMediaPlayer_Adaptor, const QMetaMethod &>(&QMediaPlayer_Adaptor::cbs_disconnectNotify_2394_0, signal);
    } else {
      QMediaPlayer::disconnectNotify(signal);
    }
  }

  //  [adaptor impl] void QMediaPlayer::timerEvent(QTimerEvent *event)
  void cbs_timerEvent_1730_0(QTimerEvent *event)
  {
    QMediaPlayer::timerEvent(event);
  }

  virtual void timerEvent(QTimerEvent *event)
  {
    if (cb_timerEvent_1730_0.can_issue()) {
      cb_timerEvent_1730_0.issue<QMediaPlayer_Adaptor, QTimerEvent *>(&QMediaPlayer_Adaptor::cbs_timerEvent_1730_0, event);
    } else {
      QMediaPlayer::timerEvent(event);
    }
  }

  gsi::Callback cb_availability_c0_0;
  gsi::Callback cb_bind_1302_0;
  gsi::Callback cb_event_1217_0;
  gsi::Callback cb_eventFilter_2411_0;
  gsi::Callback cb_isAvailable_c0_0;
  gsi::Callback cb_service_c0_0;
  gsi::Callback cb_unbind_1302_0;
  gsi::Callback cb_childEvent_1701_0;
  gsi::Callback cb_customEvent_1217_0;
  gsi::Callback cb_disconnectNotify_2394_0;
  gsi::Callback cb_timerEvent_1730_0;
};

QMediaPlayer_Adaptor::~QMediaPlayer_Adaptor() { }

//  Constructor QMediaPlayer::QMediaPlayer(QObject *parent, QFlags<QMediaPlayer::Flag> flags) (adaptor class)

static void _init_ctor_QMediaPlayer_Adaptor_4002 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent", true, "nullptr");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("flags", true, "QMediaPlayer::Flags()");
  decl->add_arg<QFlags<QMediaPlayer::Flag> > (argspec_1);
  decl->set_return_new<QMediaPlayer_Adaptor> ();
}

static void _call_ctor_QMediaPlayer_Adaptor_4002 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args ? gsi::arg_reader<QObject * >() (args, heap) : gsi::arg_maker<QObject * >() (nullptr, heap);
  QFlags<QMediaPlayer::Flag> arg2 = args ? gsi::arg_reader<QFlags<QMediaPlayer::Flag> >() (args, heap) : gsi::arg_maker<QFlags<QMediaPlayer::Flag> >() (QMediaPlayer::Flags(), heap);
  ret.write<QMediaPlayer_Adaptor *> (new QMediaPlayer_Adaptor (arg1, arg2));
}


// exposed void QMediaPlayer::addPropertyWatch(const QByteArray &name)

static void _init_fp_addPropertyWatch_2309 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("name");
  decl->add_arg<const QByteArray & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_fp_addPropertyWatch_2309 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QByteArray &arg1 = gsi::arg_reader<const QByteArray & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMediaPlayer_Adaptor *)cls)->fp_QMediaPlayer_addPropertyWatch_2309 (arg1);
}


// emitter void QMediaPlayer::audioAvailableChanged(bool available)

static void _init_emitter_audioAvailableChanged_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("available");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_audioAvailableChanged_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  ((QMediaPlayer_Adaptor *)cls)->emitter_QMediaPlayer_audioAvailableChanged_864 (arg1);
}


// emitter void QMediaPlayer::audioRoleChanged(QAudio::Role role)

static void _init_emitter_audioRoleChanged_1533 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("role");
  decl->add_arg<const qt_gsi::Converter<QAudio::Role>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_audioRoleChanged_1533 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QAudio::Role>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QAudio::Role>::target_type & >() (args, heap);
  ((QMediaPlayer_Adaptor *)cls)->emitter_QMediaPlayer_audioRoleChanged_1533 (arg1);
}


// QMultimedia::AvailabilityStatus QMediaPlayer::availability()

static void _init_cbs_availability_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QMultimedia::AvailabilityStatus>::target_type > ();
}

static void _call_cbs_availability_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QMultimedia::AvailabilityStatus>::target_type > ((qt_gsi::Converter<QMultimedia::AvailabilityStatus>::target_type)((QMediaPlayer_Adaptor *)cls)->cbs_availability_c0_0 ());
}

static void _set_callback_cbs_availability_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QMediaPlayer_Adaptor *)cls)->cb_availability_c0_0 = cb;
}


// emitter void QMediaPlayer::availabilityChanged(bool available)

static void _init_emitter_availabilityChanged_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("available");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_availabilityChanged_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  ((QMediaPlayer_Adaptor *)cls)->emitter_QMediaPlayer_availabilityChanged_864 (arg1);
}


// emitter void QMediaPlayer::availabilityChanged(QMultimedia::AvailabilityStatus availability)

static void _init_emitter_availabilityChanged_3555 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("availability");
  decl->add_arg<const qt_gsi::Converter<QMultimedia::AvailabilityStatus>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_availabilityChanged_3555 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QMultimedia::AvailabilityStatus>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QMultimedia::AvailabilityStatus>::target_type & >() (args, heap);
  ((QMediaPlayer_Adaptor *)cls)->emitter_QMediaPlayer_availabilityChanged_3555 (arg1);
}


// bool QMediaPlayer::bind(QObject *)

static void _init_cbs_bind_1302_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_bind_1302_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args.read<QObject * > (heap);
  ret.write<bool > ((bool)((QMediaPlayer_Adaptor *)cls)->cbs_bind_1302_0 (arg1));
}

static void _set_callback_cbs_bind_1302_0 (void *cls, const gsi::Callback &cb)
{
  ((QMediaPlayer_Adaptor *)cls)->cb_bind_1302_0 = cb;
}


// emitter void QMediaPlayer::bufferStatusChanged(int percentFilled)

static void _init_emitter_bufferStatusChanged_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("percentFilled");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_bufferStatusChanged_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  ((QMediaPlayer_Adaptor *)cls)->emitter_QMediaPlayer_bufferStatusChanged_767 (arg1);
}


// void QMediaPlayer::childEvent(QChildEvent *event)

static void _init_cbs_childEvent_1701_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QChildEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_childEvent_1701_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QChildEvent *arg1 = args.read<QChildEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMediaPlayer_Adaptor *)cls)->cbs_childEvent_1701_0 (arg1);
}

static void _set_callback_cbs_childEvent_1701_0 (void *cls, const gsi::Callback &cb)
{
  ((QMediaPlayer_Adaptor *)cls)->cb_childEvent_1701_0 = cb;
}


// emitter void QMediaPlayer::currentMediaChanged(const QMediaContent &media)

static void _init_emitter_currentMediaChanged_2605 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("media");
  decl->add_arg<const QMediaContent & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_currentMediaChanged_2605 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMediaContent &arg1 = gsi::arg_reader<const QMediaContent & >() (args, heap);
  ((QMediaPlayer_Adaptor *)cls)->emitter_QMediaPlayer_currentMediaChanged_2605 (arg1);
}


// emitter void QMediaPlayer::customAudioRoleChanged(const QString &role)

static void _init_emitter_customAudioRoleChanged_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("role");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_customAudioRoleChanged_2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  ((QMediaPlayer_Adaptor *)cls)->emitter_QMediaPlayer_customAudioRoleChanged_2025 (arg1);
}


// void QMediaPlayer::customEvent(QEvent *event)

static void _init_cbs_customEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_customEvent_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMediaPlayer_Adaptor *)cls)->cbs_customEvent_1217_0 (arg1);
}

static void _set_callback_cbs_customEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QMediaPlayer_Adaptor *)cls)->cb_customEvent_1217_0 = cb;
}


// emitter void QMediaPlayer::destroyed(QObject *)

static void _init_emitter_destroyed_1302 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1", true, "nullptr");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_destroyed_1302 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args ? gsi::arg_reader<QObject * >() (args, heap) : gsi::arg_maker<QObject * >() (nullptr, heap);
  ((QMediaPlayer_Adaptor *)cls)->emitter_QMediaPlayer_destroyed_1302 (arg1);
}


// void QMediaPlayer::disconnectNotify(const QMetaMethod &signal)

static void _init_cbs_disconnectNotify_2394_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const QMetaMethod & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_disconnectNotify_2394_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMetaMethod &arg1 = args.read<const QMetaMethod & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMediaPlayer_Adaptor *)cls)->cbs_disconnectNotify_2394_0 (arg1);
}

static void _set_callback_cbs_disconnectNotify_2394_0 (void *cls, const gsi::Callback &cb)
{
  ((QMediaPlayer_Adaptor *)cls)->cb_disconnectNotify_2394_0 = cb;
}


// emitter void QMediaPlayer::durationChanged(qint64 duration)

static void _init_emitter_durationChanged_986 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("duration");
  decl->add_arg<qint64 > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_durationChanged_986 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  qint64 arg1 = gsi::arg_reader<qint64 >() (args, heap);
  ((QMediaPlayer_Adaptor *)cls)->emitter_QMediaPlayer_durationChanged_986 (arg1);
}


// emitter void QMediaPlayer::error(QMediaPlayer::Error error)

static void _init_emitter_error_2256 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("error");
  decl->add_arg<const qt_gsi::Converter<QMediaPlayer::Error>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_error_2256 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QMediaPlayer::Error>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QMediaPlayer::Error>::target_type & >() (args, heap);
  ((QMediaPlayer_Adaptor *)cls)->emitter_QMediaPlayer_error_2256 (arg1);
}


// bool QMediaPlayer::event(QEvent *event)

static void _init_cbs_event_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_event_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QMediaPlayer_Adaptor *)cls)->cbs_event_1217_0 (arg1));
}

static void _set_callback_cbs_event_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QMediaPlayer_Adaptor *)cls)->cb_event_1217_0 = cb;
}


// bool QMediaPlayer::eventFilter(QObject *watched, QEvent *event)

static void _init_cbs_eventFilter_2411_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("watched");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("event");
  decl->add_arg<QEvent * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_eventFilter_2411_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args.read<QObject * > (heap);
  QEvent *arg2 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QMediaPlayer_Adaptor *)cls)->cbs_eventFilter_2411_0 (arg1, arg2));
}

static void _set_callback_cbs_eventFilter_2411_0 (void *cls, const gsi::Callback &cb)
{
  ((QMediaPlayer_Adaptor *)cls)->cb_eventFilter_2411_0 = cb;
}


// bool QMediaPlayer::isAvailable()

static void _init_cbs_isAvailable_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_cbs_isAvailable_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QMediaPlayer_Adaptor *)cls)->cbs_isAvailable_c0_0 ());
}

static void _set_callback_cbs_isAvailable_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QMediaPlayer_Adaptor *)cls)->cb_isAvailable_c0_0 = cb;
}


// exposed bool QMediaPlayer::isSignalConnected(const QMetaMethod &signal)

static void _init_fp_isSignalConnected_c2394 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const QMetaMethod & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_fp_isSignalConnected_c2394 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMetaMethod &arg1 = gsi::arg_reader<const QMetaMethod & >() (args, heap);
  ret.write<bool > ((bool)((QMediaPlayer_Adaptor *)cls)->fp_QMediaPlayer_isSignalConnected_c2394 (arg1));
}


// emitter void QMediaPlayer::mediaChanged(const QMediaContent &media)

static void _init_emitter_mediaChanged_2605 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("media");
  decl->add_arg<const QMediaContent & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_mediaChanged_2605 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMediaContent &arg1 = gsi::arg_reader<const QMediaContent & >() (args, heap);
  ((QMediaPlayer_Adaptor *)cls)->emitter_QMediaPlayer_mediaChanged_2605 (arg1);
}


// emitter void QMediaPlayer::mediaStatusChanged(QMediaPlayer::MediaStatus status)

static void _init_emitter_mediaStatusChanged_2858 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("status");
  decl->add_arg<const qt_gsi::Converter<QMediaPlayer::MediaStatus>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_mediaStatusChanged_2858 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QMediaPlayer::MediaStatus>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QMediaPlayer::MediaStatus>::target_type & >() (args, heap);
  ((QMediaPlayer_Adaptor *)cls)->emitter_QMediaPlayer_mediaStatusChanged_2858 (arg1);
}


// emitter void QMediaPlayer::metaDataAvailableChanged(bool available)

static void _init_emitter_metaDataAvailableChanged_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("available");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_metaDataAvailableChanged_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  ((QMediaPlayer_Adaptor *)cls)->emitter_QMediaPlayer_metaDataAvailableChanged_864 (arg1);
}


// emitter void QMediaPlayer::metaDataChanged()

static void _init_emitter_metaDataChanged_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_emitter_metaDataChanged_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ((QMediaPlayer_Adaptor *)cls)->emitter_QMediaPlayer_metaDataChanged_0 ();
}


// emitter void QMediaPlayer::metaDataChanged(const QString &key, const QVariant &value)

static void _init_emitter_metaDataChanged_4036 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("key");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("value");
  decl->add_arg<const QVariant & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_emitter_metaDataChanged_4036 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  const QVariant &arg2 = gsi::arg_reader<const QVariant & >() (args, heap);
  ((QMediaPlayer_Adaptor *)cls)->emitter_QMediaPlayer_metaDataChanged_4036 (arg1, arg2);
}


// emitter void QMediaPlayer::mutedChanged(bool muted)

static void _init_emitter_mutedChanged_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("muted");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_mutedChanged_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  ((QMediaPlayer_Adaptor *)cls)->emitter_QMediaPlayer_mutedChanged_864 (arg1);
}


// emitter void QMediaPlayer::networkConfigurationChanged(const QNetworkConfiguration &configuration)

static void _init_emitter_networkConfigurationChanged_3508 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("configuration");
  decl->add_arg<const QNetworkConfiguration & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_networkConfigurationChanged_3508 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QNetworkConfiguration &arg1 = gsi::arg_reader<const QNetworkConfiguration & >() (args, heap);
  ((QMediaPlayer_Adaptor *)cls)->emitter_QMediaPlayer_networkConfigurationChanged_3508 (arg1);
}


// emitter void QMediaPlayer::notifyIntervalChanged(int milliSeconds)

static void _init_emitter_notifyIntervalChanged_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("milliSeconds");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_notifyIntervalChanged_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  ((QMediaPlayer_Adaptor *)cls)->emitter_QMediaPlayer_notifyIntervalChanged_767 (arg1);
}


// emitter void QMediaPlayer::objectNameChanged(const QString &objectName)

static void _init_emitter_objectNameChanged_4567 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("objectName");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_objectNameChanged_4567 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  ((QMediaPlayer_Adaptor *)cls)->emitter_QMediaPlayer_objectNameChanged_4567 (arg1);
}


// emitter void QMediaPlayer::playbackRateChanged(double rate)

static void _init_emitter_playbackRateChanged_1071 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("rate");
  decl->add_arg<double > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_playbackRateChanged_1071 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  double arg1 = gsi::arg_reader<double >() (args, heap);
  ((QMediaPlayer_Adaptor *)cls)->emitter_QMediaPlayer_playbackRateChanged_1071 (arg1);
}


// emitter void QMediaPlayer::positionChanged(qint64 position)

static void _init_emitter_positionChanged_986 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("position");
  decl->add_arg<qint64 > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_positionChanged_986 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  qint64 arg1 = gsi::arg_reader<qint64 >() (args, heap);
  ((QMediaPlayer_Adaptor *)cls)->emitter_QMediaPlayer_positionChanged_986 (arg1);
}


// exposed int QMediaPlayer::receivers(const char *signal)

static void _init_fp_receivers_c1731 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<int > ();
}

static void _call_fp_receivers_c1731 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  ret.write<int > ((int)((QMediaPlayer_Adaptor *)cls)->fp_QMediaPlayer_receivers_c1731 (arg1));
}


// exposed void QMediaPlayer::removePropertyWatch(const QByteArray &name)

static void _init_fp_removePropertyWatch_2309 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("name");
  decl->add_arg<const QByteArray & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_fp_removePropertyWatch_2309 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QByteArray &arg1 = gsi::arg_reader<const QByteArray & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMediaPlayer_Adaptor *)cls)->fp_QMediaPlayer_removePropertyWatch_2309 (arg1);
}


// emitter void QMediaPlayer::seekableChanged(bool seekable)

static void _init_emitter_seekableChanged_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("seekable");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_seekableChanged_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  ((QMediaPlayer_Adaptor *)cls)->emitter_QMediaPlayer_seekableChanged_864 (arg1);
}


// exposed QObject *QMediaPlayer::sender()

static void _init_fp_sender_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QObject * > ();
}

static void _call_fp_sender_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QObject * > ((QObject *)((QMediaPlayer_Adaptor *)cls)->fp_QMediaPlayer_sender_c0 ());
}


// exposed int QMediaPlayer::senderSignalIndex()

static void _init_fp_senderSignalIndex_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_fp_senderSignalIndex_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QMediaPlayer_Adaptor *)cls)->fp_QMediaPlayer_senderSignalIndex_c0 ());
}


// QMediaService *QMediaPlayer::service()

static void _init_cbs_service_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QMediaService * > ();
}

static void _call_cbs_service_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QMediaService * > ((QMediaService *)((QMediaPlayer_Adaptor *)cls)->cbs_service_c0_0 ());
}

static void _set_callback_cbs_service_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QMediaPlayer_Adaptor *)cls)->cb_service_c0_0 = cb;
}


// emitter void QMediaPlayer::stateChanged(QMediaPlayer::State newState)

static void _init_emitter_stateChanged_2247 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("newState");
  decl->add_arg<const qt_gsi::Converter<QMediaPlayer::State>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_stateChanged_2247 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QMediaPlayer::State>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QMediaPlayer::State>::target_type & >() (args, heap);
  ((QMediaPlayer_Adaptor *)cls)->emitter_QMediaPlayer_stateChanged_2247 (arg1);
}


// void QMediaPlayer::timerEvent(QTimerEvent *event)

static void _init_cbs_timerEvent_1730_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QTimerEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_timerEvent_1730_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QTimerEvent *arg1 = args.read<QTimerEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMediaPlayer_Adaptor *)cls)->cbs_timerEvent_1730_0 (arg1);
}

static void _set_callback_cbs_timerEvent_1730_0 (void *cls, const gsi::Callback &cb)
{
  ((QMediaPlayer_Adaptor *)cls)->cb_timerEvent_1730_0 = cb;
}


// void QMediaPlayer::unbind(QObject *)

static void _init_cbs_unbind_1302_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_unbind_1302_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args.read<QObject * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMediaPlayer_Adaptor *)cls)->cbs_unbind_1302_0 (arg1);
}

static void _set_callback_cbs_unbind_1302_0 (void *cls, const gsi::Callback &cb)
{
  ((QMediaPlayer_Adaptor *)cls)->cb_unbind_1302_0 = cb;
}


// emitter void QMediaPlayer::videoAvailableChanged(bool videoAvailable)

static void _init_emitter_videoAvailableChanged_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("videoAvailable");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_videoAvailableChanged_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  ((QMediaPlayer_Adaptor *)cls)->emitter_QMediaPlayer_videoAvailableChanged_864 (arg1);
}


// emitter void QMediaPlayer::volumeChanged(int volume)

static void _init_emitter_volumeChanged_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("volume");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_volumeChanged_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  ((QMediaPlayer_Adaptor *)cls)->emitter_QMediaPlayer_volumeChanged_767 (arg1);
}


namespace gsi
{

gsi::Class<QMediaPlayer> &qtdecl_QMediaPlayer ();

static gsi::Methods methods_QMediaPlayer_Adaptor () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QMediaPlayer::QMediaPlayer(QObject *parent, QFlags<QMediaPlayer::Flag> flags)\nThis method creates an object of class QMediaPlayer.", &_init_ctor_QMediaPlayer_Adaptor_4002, &_call_ctor_QMediaPlayer_Adaptor_4002);
  methods += new qt_gsi::GenericMethod ("*addPropertyWatch", "@brief Method void QMediaPlayer::addPropertyWatch(const QByteArray &name)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_addPropertyWatch_2309, &_call_fp_addPropertyWatch_2309);
  methods += new qt_gsi::GenericMethod ("emit_audioAvailableChanged", "@brief Emitter for signal void QMediaPlayer::audioAvailableChanged(bool available)\nCall this method to emit this signal.", false, &_init_emitter_audioAvailableChanged_864, &_call_emitter_audioAvailableChanged_864);
  methods += new qt_gsi::GenericMethod ("emit_audioRoleChanged", "@brief Emitter for signal void QMediaPlayer::audioRoleChanged(QAudio::Role role)\nCall this method to emit this signal.", false, &_init_emitter_audioRoleChanged_1533, &_call_emitter_audioRoleChanged_1533);
  methods += new qt_gsi::GenericMethod ("availability", "@brief Virtual method QMultimedia::AvailabilityStatus QMediaPlayer::availability()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_availability_c0_0, &_call_cbs_availability_c0_0);
  methods += new qt_gsi::GenericMethod ("availability", "@hide", true, &_init_cbs_availability_c0_0, &_call_cbs_availability_c0_0, &_set_callback_cbs_availability_c0_0);
  methods += new qt_gsi::GenericMethod ("emit_availabilityChanged_bool", "@brief Emitter for signal void QMediaPlayer::availabilityChanged(bool available)\nCall this method to emit this signal.", false, &_init_emitter_availabilityChanged_864, &_call_emitter_availabilityChanged_864);
  methods += new qt_gsi::GenericMethod ("emit_availabilityChanged_status", "@brief Emitter for signal void QMediaPlayer::availabilityChanged(QMultimedia::AvailabilityStatus availability)\nCall this method to emit this signal.", false, &_init_emitter_availabilityChanged_3555, &_call_emitter_availabilityChanged_3555);
  methods += new qt_gsi::GenericMethod ("bind", "@brief Virtual method bool QMediaPlayer::bind(QObject *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_bind_1302_0, &_call_cbs_bind_1302_0);
  methods += new qt_gsi::GenericMethod ("bind", "@hide", false, &_init_cbs_bind_1302_0, &_call_cbs_bind_1302_0, &_set_callback_cbs_bind_1302_0);
  methods += new qt_gsi::GenericMethod ("emit_bufferStatusChanged", "@brief Emitter for signal void QMediaPlayer::bufferStatusChanged(int percentFilled)\nCall this method to emit this signal.", false, &_init_emitter_bufferStatusChanged_767, &_call_emitter_bufferStatusChanged_767);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@brief Virtual method void QMediaPlayer::childEvent(QChildEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@hide", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0, &_set_callback_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("emit_currentMediaChanged", "@brief Emitter for signal void QMediaPlayer::currentMediaChanged(const QMediaContent &media)\nCall this method to emit this signal.", false, &_init_emitter_currentMediaChanged_2605, &_call_emitter_currentMediaChanged_2605);
  methods += new qt_gsi::GenericMethod ("emit_customAudioRoleChanged", "@brief Emitter for signal void QMediaPlayer::customAudioRoleChanged(const QString &role)\nCall this method to emit this signal.", false, &_init_emitter_customAudioRoleChanged_2025, &_call_emitter_customAudioRoleChanged_2025);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@brief Virtual method void QMediaPlayer::customEvent(QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@hide", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0, &_set_callback_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("emit_destroyed", "@brief Emitter for signal void QMediaPlayer::destroyed(QObject *)\nCall this method to emit this signal.", false, &_init_emitter_destroyed_1302, &_call_emitter_destroyed_1302);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@brief Virtual method void QMediaPlayer::disconnectNotify(const QMetaMethod &signal)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_disconnectNotify_2394_0, &_call_cbs_disconnectNotify_2394_0);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@hide", false, &_init_cbs_disconnectNotify_2394_0, &_call_cbs_disconnectNotify_2394_0, &_set_callback_cbs_disconnectNotify_2394_0);
  methods += new qt_gsi::GenericMethod ("emit_durationChanged", "@brief Emitter for signal void QMediaPlayer::durationChanged(qint64 duration)\nCall this method to emit this signal.", false, &_init_emitter_durationChanged_986, &_call_emitter_durationChanged_986);
  methods += new qt_gsi::GenericMethod ("emit_error_sig", "@brief Emitter for signal void QMediaPlayer::error(QMediaPlayer::Error error)\nCall this method to emit this signal.", false, &_init_emitter_error_2256, &_call_emitter_error_2256);
  methods += new qt_gsi::GenericMethod ("event", "@brief Virtual method bool QMediaPlayer::event(QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("event", "@hide", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0, &_set_callback_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("eventFilter", "@brief Virtual method bool QMediaPlayer::eventFilter(QObject *watched, QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("eventFilter", "@hide", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0, &_set_callback_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("isAvailable", "@brief Virtual method bool QMediaPlayer::isAvailable()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_isAvailable_c0_0, &_call_cbs_isAvailable_c0_0);
  methods += new qt_gsi::GenericMethod ("isAvailable", "@hide", true, &_init_cbs_isAvailable_c0_0, &_call_cbs_isAvailable_c0_0, &_set_callback_cbs_isAvailable_c0_0);
  methods += new qt_gsi::GenericMethod ("*isSignalConnected", "@brief Method bool QMediaPlayer::isSignalConnected(const QMetaMethod &signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_isSignalConnected_c2394, &_call_fp_isSignalConnected_c2394);
  methods += new qt_gsi::GenericMethod ("emit_mediaChanged", "@brief Emitter for signal void QMediaPlayer::mediaChanged(const QMediaContent &media)\nCall this method to emit this signal.", false, &_init_emitter_mediaChanged_2605, &_call_emitter_mediaChanged_2605);
  methods += new qt_gsi::GenericMethod ("emit_mediaStatusChanged", "@brief Emitter for signal void QMediaPlayer::mediaStatusChanged(QMediaPlayer::MediaStatus status)\nCall this method to emit this signal.", false, &_init_emitter_mediaStatusChanged_2858, &_call_emitter_mediaStatusChanged_2858);
  methods += new qt_gsi::GenericMethod ("emit_metaDataAvailableChanged", "@brief Emitter for signal void QMediaPlayer::metaDataAvailableChanged(bool available)\nCall this method to emit this signal.", false, &_init_emitter_metaDataAvailableChanged_864, &_call_emitter_metaDataAvailableChanged_864);
  methods += new qt_gsi::GenericMethod ("emit_metaDataChanged", "@brief Emitter for signal void QMediaPlayer::metaDataChanged()\nCall this method to emit this signal.", false, &_init_emitter_metaDataChanged_0, &_call_emitter_metaDataChanged_0);
  methods += new qt_gsi::GenericMethod ("emit_metaDataChanged_kv", "@brief Emitter for signal void QMediaPlayer::metaDataChanged(const QString &key, const QVariant &value)\nCall this method to emit this signal.", false, &_init_emitter_metaDataChanged_4036, &_call_emitter_metaDataChanged_4036);
  methods += new qt_gsi::GenericMethod ("emit_mutedChanged", "@brief Emitter for signal void QMediaPlayer::mutedChanged(bool muted)\nCall this method to emit this signal.", false, &_init_emitter_mutedChanged_864, &_call_emitter_mutedChanged_864);
  methods += new qt_gsi::GenericMethod ("emit_networkConfigurationChanged", "@brief Emitter for signal void QMediaPlayer::networkConfigurationChanged(const QNetworkConfiguration &configuration)\nCall this method to emit this signal.", false, &_init_emitter_networkConfigurationChanged_3508, &_call_emitter_networkConfigurationChanged_3508);
  methods += new qt_gsi::GenericMethod ("emit_notifyIntervalChanged", "@brief Emitter for signal void QMediaPlayer::notifyIntervalChanged(int milliSeconds)\nCall this method to emit this signal.", false, &_init_emitter_notifyIntervalChanged_767, &_call_emitter_notifyIntervalChanged_767);
  methods += new qt_gsi::GenericMethod ("emit_objectNameChanged", "@brief Emitter for signal void QMediaPlayer::objectNameChanged(const QString &objectName)\nCall this method to emit this signal.", false, &_init_emitter_objectNameChanged_4567, &_call_emitter_objectNameChanged_4567);
  methods += new qt_gsi::GenericMethod ("emit_playbackRateChanged", "@brief Emitter for signal void QMediaPlayer::playbackRateChanged(double rate)\nCall this method to emit this signal.", false, &_init_emitter_playbackRateChanged_1071, &_call_emitter_playbackRateChanged_1071);
  methods += new qt_gsi::GenericMethod ("emit_positionChanged", "@brief Emitter for signal void QMediaPlayer::positionChanged(qint64 position)\nCall this method to emit this signal.", false, &_init_emitter_positionChanged_986, &_call_emitter_positionChanged_986);
  methods += new qt_gsi::GenericMethod ("*receivers", "@brief Method int QMediaPlayer::receivers(const char *signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_receivers_c1731, &_call_fp_receivers_c1731);
  methods += new qt_gsi::GenericMethod ("*removePropertyWatch", "@brief Method void QMediaPlayer::removePropertyWatch(const QByteArray &name)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_removePropertyWatch_2309, &_call_fp_removePropertyWatch_2309);
  methods += new qt_gsi::GenericMethod ("emit_seekableChanged", "@brief Emitter for signal void QMediaPlayer::seekableChanged(bool seekable)\nCall this method to emit this signal.", false, &_init_emitter_seekableChanged_864, &_call_emitter_seekableChanged_864);
  methods += new qt_gsi::GenericMethod ("*sender", "@brief Method QObject *QMediaPlayer::sender()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_sender_c0, &_call_fp_sender_c0);
  methods += new qt_gsi::GenericMethod ("*senderSignalIndex", "@brief Method int QMediaPlayer::senderSignalIndex()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_senderSignalIndex_c0, &_call_fp_senderSignalIndex_c0);
  methods += new qt_gsi::GenericMethod ("service", "@brief Virtual method QMediaService *QMediaPlayer::service()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_service_c0_0, &_call_cbs_service_c0_0);
  methods += new qt_gsi::GenericMethod ("service", "@hide", true, &_init_cbs_service_c0_0, &_call_cbs_service_c0_0, &_set_callback_cbs_service_c0_0);
  methods += new qt_gsi::GenericMethod ("emit_stateChanged", "@brief Emitter for signal void QMediaPlayer::stateChanged(QMediaPlayer::State newState)\nCall this method to emit this signal.", false, &_init_emitter_stateChanged_2247, &_call_emitter_stateChanged_2247);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@brief Virtual method void QMediaPlayer::timerEvent(QTimerEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@hide", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0, &_set_callback_cbs_timerEvent_1730_0);
  methods += new qt_gsi::GenericMethod ("unbind", "@brief Virtual method void QMediaPlayer::unbind(QObject *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_unbind_1302_0, &_call_cbs_unbind_1302_0);
  methods += new qt_gsi::GenericMethod ("unbind", "@hide", false, &_init_cbs_unbind_1302_0, &_call_cbs_unbind_1302_0, &_set_callback_cbs_unbind_1302_0);
  methods += new qt_gsi::GenericMethod ("emit_videoAvailableChanged", "@brief Emitter for signal void QMediaPlayer::videoAvailableChanged(bool videoAvailable)\nCall this method to emit this signal.", false, &_init_emitter_videoAvailableChanged_864, &_call_emitter_videoAvailableChanged_864);
  methods += new qt_gsi::GenericMethod ("emit_volumeChanged", "@brief Emitter for signal void QMediaPlayer::volumeChanged(int volume)\nCall this method to emit this signal.", false, &_init_emitter_volumeChanged_767, &_call_emitter_volumeChanged_767);
  return methods;
}

gsi::Class<QMediaPlayer_Adaptor> decl_QMediaPlayer_Adaptor (qtdecl_QMediaPlayer (), "QtMultimedia", "QMediaPlayer",
  methods_QMediaPlayer_Adaptor (),
  "@qt\n@brief Binding of QMediaPlayer");

}


//  Implementation of the enum wrapper class for QMediaPlayer::Error
namespace qt_gsi
{

static gsi::Enum<QMediaPlayer::Error> decl_QMediaPlayer_Error_Enum ("QtMultimedia", "QMediaPlayer_Error",
    gsi::enum_const ("NoError", QMediaPlayer::NoError, "@brief Enum constant QMediaPlayer::NoError") +
    gsi::enum_const ("ResourceError", QMediaPlayer::ResourceError, "@brief Enum constant QMediaPlayer::ResourceError") +
    gsi::enum_const ("FormatError", QMediaPlayer::FormatError, "@brief Enum constant QMediaPlayer::FormatError") +
    gsi::enum_const ("NetworkError", QMediaPlayer::NetworkError, "@brief Enum constant QMediaPlayer::NetworkError") +
    gsi::enum_const ("AccessDeniedError", QMediaPlayer::AccessDeniedError, "@brief Enum constant QMediaPlayer::AccessDeniedError") +
    gsi::enum_const ("ServiceMissingError", QMediaPlayer::ServiceMissingError, "@brief Enum constant QMediaPlayer::ServiceMissingError") +
    gsi::enum_const ("MediaIsPlaylist", QMediaPlayer::MediaIsPlaylist, "@brief Enum constant QMediaPlayer::MediaIsPlaylist"),
  "@qt\n@brief This class represents the QMediaPlayer::Error enum");

static gsi::QFlagsClass<QMediaPlayer::Error > decl_QMediaPlayer_Error_Enums ("QtMultimedia", "QMediaPlayer_QFlags_Error",
  "@qt\n@brief This class represents the QFlags<QMediaPlayer::Error> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QMediaPlayer> inject_QMediaPlayer_Error_Enum_in_parent (decl_QMediaPlayer_Error_Enum.defs ());
static gsi::ClassExt<QMediaPlayer> decl_QMediaPlayer_Error_Enum_as_child (decl_QMediaPlayer_Error_Enum, "Error");
static gsi::ClassExt<QMediaPlayer> decl_QMediaPlayer_Error_Enums_as_child (decl_QMediaPlayer_Error_Enums, "QFlags_Error");

}


//  Implementation of the enum wrapper class for QMediaPlayer::Flag
namespace qt_gsi
{

static gsi::Enum<QMediaPlayer::Flag> decl_QMediaPlayer_Flag_Enum ("QtMultimedia", "QMediaPlayer_Flag",
    gsi::enum_const ("LowLatency", QMediaPlayer::LowLatency, "@brief Enum constant QMediaPlayer::LowLatency") +
    gsi::enum_const ("StreamPlayback", QMediaPlayer::StreamPlayback, "@brief Enum constant QMediaPlayer::StreamPlayback") +
    gsi::enum_const ("VideoSurface", QMediaPlayer::VideoSurface, "@brief Enum constant QMediaPlayer::VideoSurface"),
  "@qt\n@brief This class represents the QMediaPlayer::Flag enum");

static gsi::QFlagsClass<QMediaPlayer::Flag > decl_QMediaPlayer_Flag_Enums ("QtMultimedia", "QMediaPlayer_QFlags_Flag",
  "@qt\n@brief This class represents the QFlags<QMediaPlayer::Flag> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QMediaPlayer> inject_QMediaPlayer_Flag_Enum_in_parent (decl_QMediaPlayer_Flag_Enum.defs ());
static gsi::ClassExt<QMediaPlayer> decl_QMediaPlayer_Flag_Enum_as_child (decl_QMediaPlayer_Flag_Enum, "Flag");
static gsi::ClassExt<QMediaPlayer> decl_QMediaPlayer_Flag_Enums_as_child (decl_QMediaPlayer_Flag_Enums, "QFlags_Flag");

}


//  Implementation of the enum wrapper class for QMediaPlayer::MediaStatus
namespace qt_gsi
{

static gsi::Enum<QMediaPlayer::MediaStatus> decl_QMediaPlayer_MediaStatus_Enum ("QtMultimedia", "QMediaPlayer_MediaStatus",
    gsi::enum_const ("UnknownMediaStatus", QMediaPlayer::UnknownMediaStatus, "@brief Enum constant QMediaPlayer::UnknownMediaStatus") +
    gsi::enum_const ("NoMedia", QMediaPlayer::NoMedia, "@brief Enum constant QMediaPlayer::NoMedia") +
    gsi::enum_const ("LoadingMedia", QMediaPlayer::LoadingMedia, "@brief Enum constant QMediaPlayer::LoadingMedia") +
    gsi::enum_const ("LoadedMedia", QMediaPlayer::LoadedMedia, "@brief Enum constant QMediaPlayer::LoadedMedia") +
    gsi::enum_const ("StalledMedia", QMediaPlayer::StalledMedia, "@brief Enum constant QMediaPlayer::StalledMedia") +
    gsi::enum_const ("BufferingMedia", QMediaPlayer::BufferingMedia, "@brief Enum constant QMediaPlayer::BufferingMedia") +
    gsi::enum_const ("BufferedMedia", QMediaPlayer::BufferedMedia, "@brief Enum constant QMediaPlayer::BufferedMedia") +
    gsi::enum_const ("EndOfMedia", QMediaPlayer::EndOfMedia, "@brief Enum constant QMediaPlayer::EndOfMedia") +
    gsi::enum_const ("InvalidMedia", QMediaPlayer::InvalidMedia, "@brief Enum constant QMediaPlayer::InvalidMedia"),
  "@qt\n@brief This class represents the QMediaPlayer::MediaStatus enum");

static gsi::QFlagsClass<QMediaPlayer::MediaStatus > decl_QMediaPlayer_MediaStatus_Enums ("QtMultimedia", "QMediaPlayer_QFlags_MediaStatus",
  "@qt\n@brief This class represents the QFlags<QMediaPlayer::MediaStatus> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QMediaPlayer> inject_QMediaPlayer_MediaStatus_Enum_in_parent (decl_QMediaPlayer_MediaStatus_Enum.defs ());
static gsi::ClassExt<QMediaPlayer> decl_QMediaPlayer_MediaStatus_Enum_as_child (decl_QMediaPlayer_MediaStatus_Enum, "MediaStatus");
static gsi::ClassExt<QMediaPlayer> decl_QMediaPlayer_MediaStatus_Enums_as_child (decl_QMediaPlayer_MediaStatus_Enums, "QFlags_MediaStatus");

}


//  Implementation of the enum wrapper class for QMediaPlayer::State
namespace qt_gsi
{

static gsi::Enum<QMediaPlayer::State> decl_QMediaPlayer_State_Enum ("QtMultimedia", "QMediaPlayer_State",
    gsi::enum_const ("StoppedState", QMediaPlayer::StoppedState, "@brief Enum constant QMediaPlayer::StoppedState") +
    gsi::enum_const ("PlayingState", QMediaPlayer::PlayingState, "@brief Enum constant QMediaPlayer::PlayingState") +
    gsi::enum_const ("PausedState", QMediaPlayer::PausedState, "@brief Enum constant QMediaPlayer::PausedState"),
  "@qt\n@brief This class represents the QMediaPlayer::State enum");

static gsi::QFlagsClass<QMediaPlayer::State > decl_QMediaPlayer_State_Enums ("QtMultimedia", "QMediaPlayer_QFlags_State",
  "@qt\n@brief This class represents the QFlags<QMediaPlayer::State> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QMediaPlayer> inject_QMediaPlayer_State_Enum_in_parent (decl_QMediaPlayer_State_Enum.defs ());
static gsi::ClassExt<QMediaPlayer> decl_QMediaPlayer_State_Enum_as_child (decl_QMediaPlayer_State_Enum, "State");
static gsi::ClassExt<QMediaPlayer> decl_QMediaPlayer_State_Enums_as_child (decl_QMediaPlayer_State_Enums, "QFlags_State");

}

