#pragma once

/////////////////////// stdlib includes


/////////////////////// Qt includes
#include <QObject>
#include <QtQml>
#include <QVariant>


/////////////////////// Local includes
#include "jsclassregistrar.h"
#include "pappsomspp/export-import-config.h"
#include "../trace/trace.h"
#include "datapointjs.h"

namespace pappso
{

  /*  BEGIN CLASS JS REFERENCE
   *  namespace: pappso
   *  class name: Trace
   */

class PMSPP_LIB_DECL TraceJs : public QObject
{
  Q_OBJECT
  Q_PROPERTY(int count READ count NOTIFY countChangedSignal)
  QML_NAMED_ELEMENT(Trace)

  public:
  Q_INVOKABLE explicit TraceJs(QObject *parent = nullptr);
  Q_INVOKABLE explicit TraceJs(const Trace &trace, QObject *parent = nullptr);

  // Delete assignment operator (QObjects shouldn't be assigned)
  TraceJs &operator=(const TraceJs &) = delete;

  Q_INVOKABLE int count() const;
  Q_INVOKABLE int getCount() const;

  Q_INVOKABLE void append(double x, double y);
  Q_INVOKABLE void append(const DataPointJs *data_point_js_p);

  Q_INVOKABLE DataPointJs *getPointAt(int index) const;
  Q_INVOKABLE QVariantList getTrace() const;

  Q_INVOKABLE void initialize(const QVariantList &js_points);
  Q_INVOKABLE void initialize(const QVariantMap &map);
  Q_INVOKABLE std::size_t initialize(const QVariantList &x_values, const QVariantList &y_values);

  Q_INVOKABLE std::size_t initialize(const QString &x_text, const QString &y_text);
  Q_INVOKABLE std::size_t initialize(const QString &space_sep_text);

  Q_INVOKABLE std::size_t initialize(const TraceJs &other);

  Q_INVOKABLE QVariantList xValues() const;
  Q_INVOKABLE QVariantList yValues() const;
  Q_INVOKABLE QVariantMap toMap() const;

  Q_INVOKABLE void clear();

  // Static registration method
  static void registerJsConstructor(QJSEngine *engine);

  signals:
  void countChangedSignal();

  private:
  Trace m_trace;
};

  /*  END CLASS JS REFERENCE
   *  namespace: pappso
   *  class name: Trace
   */


PAPPSO_REGISTER_JS_CLASS(pappso, TraceJs)

} // namespace pappso
