/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbcp2;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import org.apache.commons.dbcp2.DelegatingConnection;
import org.apache.commons.dbcp2.DelegatingResultSet;
import org.apache.commons.dbcp2.DelegatingStatement;

public class DelegatingPreparedStatement
extends DelegatingStatement
implements PreparedStatement {
    public DelegatingPreparedStatement(DelegatingConnection<?> c2, PreparedStatement s2) {
        super(c2, s2);
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        this.checkOpen();
        if (this.getConnectionInternal() != null) {
            this.getConnectionInternal().setLastUsed();
        }
        try {
            return DelegatingResultSet.wrapResultSet(this, ((PreparedStatement)this.getDelegate()).executeQuery());
        }
        catch (SQLException e2) {
            this.handleException(e2);
            throw new AssertionError();
        }
    }

    @Override
    public int executeUpdate() throws SQLException {
        this.checkOpen();
        if (this.getConnectionInternal() != null) {
            this.getConnectionInternal().setLastUsed();
        }
        try {
            return ((PreparedStatement)this.getDelegate()).executeUpdate();
        }
        catch (SQLException e2) {
            this.handleException(e2);
            return 0;
        }
    }

    @Override
    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        this.checkOpen();
        try {
            ((PreparedStatement)this.getDelegate()).setNull(parameterIndex, sqlType);
        }
        catch (SQLException e2) {
            this.handleException(e2);
        }
    }

    @Override
    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        this.checkOpen();
        try {
            ((PreparedStatement)this.getDelegate()).setBoolean(parameterIndex, x);
        }
        catch (SQLException e2) {
            this.handleException(e2);
        }
    }

    @Override
    public void setByte(int parameterIndex, byte x) throws SQLException {
        this.checkOpen();
        try {
            ((PreparedStatement)this.getDelegate()).setByte(parameterIndex, x);
        }
        catch (SQLException e2) {
            this.handleException(e2);
        }
    }

    @Override
    public void setShort(int parameterIndex, short x) throws SQLException {
        this.checkOpen();
        try {
            ((PreparedStatement)this.getDelegate()).setShort(parameterIndex, x);
        }
        catch (SQLException e2) {
            this.handleException(e2);
        }
    }

    @Override
    public void setInt(int parameterIndex, int x) throws SQLException {
        this.checkOpen();
        try {
            ((PreparedStatement)this.getDelegate()).setInt(parameterIndex, x);
        }
        catch (SQLException e2) {
            this.handleException(e2);
        }
    }

    @Override
    public void setLong(int parameterIndex, long x) throws SQLException {
        this.checkOpen();
        try {
            ((PreparedStatement)this.getDelegate()).setLong(parameterIndex, x);
        }
        catch (SQLException e2) {
            this.handleException(e2);
        }
    }

    @Override
    public void setFloat(int parameterIndex, float x) throws SQLException {
        this.checkOpen();
        try {
            ((PreparedStatement)this.getDelegate()).setFloat(parameterIndex, x);
        }
        catch (SQLException e2) {
            this.handleException(e2);
        }
    }

    @Override
    public void setDouble(int parameterIndex, double x) throws SQLException {
        this.checkOpen();
        try {
            ((PreparedStatement)this.getDelegate()).setDouble(parameterIndex, x);
        }
        catch (SQLException e2) {
            this.handleException(e2);
        }
    }

    @Override
    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        this.checkOpen();
        try {
            ((PreparedStatement)this.getDelegate()).setBigDecimal(parameterIndex, x);
        }
        catch (SQLException e2) {
            this.handleException(e2);
        }
    }

    @Override
    public void setString(int parameterIndex, String x) throws SQLException {
        this.checkOpen();
        try {
            ((PreparedStatement)this.getDelegate()).setString(parameterIndex, x);
        }
        catch (SQLException e2) {
            this.handleException(e2);
        }
    }

    @Override
    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        this.checkOpen();
        try {
            ((PreparedStatement)this.getDelegate()).setBytes(parameterIndex, x);
        }
        catch (SQLException e2) {
            this.handleException(e2);
        }
    }

    @Override
    public void setDate(int parameterIndex, Date x) throws SQLException {
        this.checkOpen();
        try {
            ((PreparedStatement)this.getDelegate()).setDate(parameterIndex, x);
        }
        catch (SQLException e2) {
            this.handleException(e2);
        }
    }

    @Override
    public void setTime(int parameterIndex, Time x) throws SQLException {
        this.checkOpen();
        try {
            ((PreparedStatement)this.getDelegate()).setTime(parameterIndex, x);
        }
        catch (SQLException e2) {
            this.handleException(e2);
        }
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        this.checkOpen();
        try {
            ((PreparedStatement)this.getDelegate()).setTimestamp(parameterIndex, x);
        }
        catch (SQLException e2) {
            this.handleException(e2);
        }
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.checkOpen();
        try {
            ((PreparedStatement)this.getDelegate()).setAsciiStream(parameterIndex, x, length);
        }
        catch (SQLException e2) {
            this.handleException(e2);
        }
    }

    @Override
    @Deprecated
    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.checkOpen();
        try {
            ((PreparedStatement)this.getDelegate()).setUnicodeStream(parameterIndex, x, length);
        }
        catch (SQLException e2) {
            this.handleException(e2);
        }
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.checkOpen();
        try {
            ((PreparedStatement)this.getDelegate()).setBinaryStream(parameterIndex, x, length);
        }
        catch (SQLException e2) {
            this.handleException(e2);
        }
    }

    @Override
    public void clearParameters() throws SQLException {
        this.checkOpen();
        try {
            ((PreparedStatement)this.getDelegate()).clearParameters();
        }
        catch (SQLException e2) {
            this.handleException(e2);
        }
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType, int scale) throws SQLException {
        this.checkOpen();
        try {
            ((PreparedStatement)this.getDelegate()).setObject(parameterIndex, x, targetSqlType, scale);
        }
        catch (SQLException e2) {
            this.handleException(e2);
        }
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        this.checkOpen();
        try {
            ((PreparedStatement)this.getDelegate()).setObject(parameterIndex, x, targetSqlType);
        }
        catch (SQLException e2) {
            this.handleException(e2);
        }
    }

    @Override
    public void setObject(int parameterIndex, Object x) throws SQLException {
        this.checkOpen();
        try {
            ((PreparedStatement)this.getDelegate()).setObject(parameterIndex, x);
        }
        catch (SQLException e2) {
            this.handleException(e2);
        }
    }

    @Override
    public boolean execute() throws SQLException {
        this.checkOpen();
        if (this.getConnectionInternal() != null) {
            this.getConnectionInternal().setLastUsed();
        }
        try {
            return ((PreparedStatement)this.getDelegate()).execute();
        }
        catch (SQLException e2) {
            this.handleException(e2);
            return false;
        }
    }

    @Override
    public void addBatch() throws SQLException {
        this.checkOpen();
        try {
            ((PreparedStatement)this.getDelegate()).addBatch();
        }
        catch (SQLException e2) {
            this.handleException(e2);
        }
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        this.checkOpen();
        try {
            ((PreparedStatement)this.getDelegate()).setCharacterStream(parameterIndex, reader, length);
        }
        catch (SQLException e2) {
            this.handleException(e2);
        }
    }

    @Override
    public void setRef(int i2, Ref x) throws SQLException {
        this.checkOpen();
        try {
            ((PreparedStatement)this.getDelegate()).setRef(i2, x);
        }
        catch (SQLException e2) {
            this.handleException(e2);
        }
    }

    @Override
    public void setBlob(int i2, Blob x) throws SQLException {
        this.checkOpen();
        try {
            ((PreparedStatement)this.getDelegate()).setBlob(i2, x);
        }
        catch (SQLException e2) {
            this.handleException(e2);
        }
    }

    @Override
    public void setClob(int i2, Clob x) throws SQLException {
        this.checkOpen();
        try {
            ((PreparedStatement)this.getDelegate()).setClob(i2, x);
        }
        catch (SQLException e2) {
            this.handleException(e2);
        }
    }

    @Override
    public void setArray(int i2, Array x) throws SQLException {
        this.checkOpen();
        try {
            ((PreparedStatement)this.getDelegate()).setArray(i2, x);
        }
        catch (SQLException e2) {
            this.handleException(e2);
        }
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        this.checkOpen();
        try {
            return ((PreparedStatement)this.getDelegate()).getMetaData();
        }
        catch (SQLException e2) {
            this.handleException(e2);
            throw new AssertionError();
        }
    }

    @Override
    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        this.checkOpen();
        try {
            ((PreparedStatement)this.getDelegate()).setDate(parameterIndex, x, cal);
        }
        catch (SQLException e2) {
            this.handleException(e2);
        }
    }

    @Override
    public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        this.checkOpen();
        try {
            ((PreparedStatement)this.getDelegate()).setTime(parameterIndex, x, cal);
        }
        catch (SQLException e2) {
            this.handleException(e2);
        }
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        this.checkOpen();
        try {
            ((PreparedStatement)this.getDelegate()).setTimestamp(parameterIndex, x, cal);
        }
        catch (SQLException e2) {
            this.handleException(e2);
        }
    }

    @Override
    public void setNull(int paramIndex, int sqlType, String typeName) throws SQLException {
        this.checkOpen();
        try {
            ((PreparedStatement)this.getDelegate()).setNull(paramIndex, sqlType, typeName);
        }
        catch (SQLException e2) {
            this.handleException(e2);
        }
    }

    @Override
    public String toString() {
        Statement statement = this.getDelegate();
        return statement == null ? "NULL" : statement.toString();
    }

    @Override
    public void setURL(int parameterIndex, URL x) throws SQLException {
        this.checkOpen();
        try {
            ((PreparedStatement)this.getDelegate()).setURL(parameterIndex, x);
        }
        catch (SQLException e2) {
            this.handleException(e2);
        }
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        this.checkOpen();
        try {
            return ((PreparedStatement)this.getDelegate()).getParameterMetaData();
        }
        catch (SQLException e2) {
            this.handleException(e2);
            throw new AssertionError();
        }
    }

    @Override
    public void setRowId(int parameterIndex, RowId value) throws SQLException {
        this.checkOpen();
        try {
            ((PreparedStatement)this.getDelegate()).setRowId(parameterIndex, value);
        }
        catch (SQLException e2) {
            this.handleException(e2);
        }
    }

    @Override
    public void setNString(int parameterIndex, String value) throws SQLException {
        this.checkOpen();
        try {
            ((PreparedStatement)this.getDelegate()).setNString(parameterIndex, value);
        }
        catch (SQLException e2) {
            this.handleException(e2);
        }
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value, long length) throws SQLException {
        this.checkOpen();
        try {
            ((PreparedStatement)this.getDelegate()).setNCharacterStream(parameterIndex, value, length);
        }
        catch (SQLException e2) {
            this.handleException(e2);
        }
    }

    @Override
    public void setNClob(int parameterIndex, NClob value) throws SQLException {
        this.checkOpen();
        try {
            ((PreparedStatement)this.getDelegate()).setNClob(parameterIndex, value);
        }
        catch (SQLException e2) {
            this.handleException(e2);
        }
    }

    @Override
    public void setClob(int parameterIndex, Reader reader, long length) throws SQLException {
        this.checkOpen();
        try {
            ((PreparedStatement)this.getDelegate()).setClob(parameterIndex, reader, length);
        }
        catch (SQLException e2) {
            this.handleException(e2);
        }
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream, long length) throws SQLException {
        this.checkOpen();
        try {
            ((PreparedStatement)this.getDelegate()).setBlob(parameterIndex, inputStream, length);
        }
        catch (SQLException e2) {
            this.handleException(e2);
        }
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader, long length) throws SQLException {
        this.checkOpen();
        try {
            ((PreparedStatement)this.getDelegate()).setNClob(parameterIndex, reader, length);
        }
        catch (SQLException e2) {
            this.handleException(e2);
        }
    }

    @Override
    public void setSQLXML(int parameterIndex, SQLXML value) throws SQLException {
        this.checkOpen();
        try {
            ((PreparedStatement)this.getDelegate()).setSQLXML(parameterIndex, value);
        }
        catch (SQLException e2) {
            this.handleException(e2);
        }
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream inputStream, long length) throws SQLException {
        this.checkOpen();
        try {
            ((PreparedStatement)this.getDelegate()).setAsciiStream(parameterIndex, inputStream, length);
        }
        catch (SQLException e2) {
            this.handleException(e2);
        }
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream inputStream, long length) throws SQLException {
        this.checkOpen();
        try {
            ((PreparedStatement)this.getDelegate()).setBinaryStream(parameterIndex, inputStream, length);
        }
        catch (SQLException e2) {
            this.handleException(e2);
        }
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, long length) throws SQLException {
        this.checkOpen();
        try {
            ((PreparedStatement)this.getDelegate()).setCharacterStream(parameterIndex, reader, length);
        }
        catch (SQLException e2) {
            this.handleException(e2);
        }
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream inputStream) throws SQLException {
        this.checkOpen();
        try {
            ((PreparedStatement)this.getDelegate()).setAsciiStream(parameterIndex, inputStream);
        }
        catch (SQLException e2) {
            this.handleException(e2);
        }
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream inputStream) throws SQLException {
        this.checkOpen();
        try {
            ((PreparedStatement)this.getDelegate()).setBinaryStream(parameterIndex, inputStream);
        }
        catch (SQLException e2) {
            this.handleException(e2);
        }
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader) throws SQLException {
        this.checkOpen();
        try {
            ((PreparedStatement)this.getDelegate()).setCharacterStream(parameterIndex, reader);
        }
        catch (SQLException e2) {
            this.handleException(e2);
        }
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader reader) throws SQLException {
        this.checkOpen();
        try {
            ((PreparedStatement)this.getDelegate()).setNCharacterStream(parameterIndex, reader);
        }
        catch (SQLException e2) {
            this.handleException(e2);
        }
    }

    @Override
    public void setClob(int parameterIndex, Reader reader) throws SQLException {
        this.checkOpen();
        try {
            ((PreparedStatement)this.getDelegate()).setClob(parameterIndex, reader);
        }
        catch (SQLException e2) {
            this.handleException(e2);
        }
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream) throws SQLException {
        this.checkOpen();
        try {
            ((PreparedStatement)this.getDelegate()).setBlob(parameterIndex, inputStream);
        }
        catch (SQLException e2) {
            this.handleException(e2);
        }
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader) throws SQLException {
        this.checkOpen();
        try {
            ((PreparedStatement)this.getDelegate()).setNClob(parameterIndex, reader);
        }
        catch (SQLException e2) {
            this.handleException(e2);
        }
    }
}

