How to build openvpn3-linux locally
-----------------------------------

The primary Linux distributions targeted and regularly tested are:

  - Debian 11 and newer
  - Fedora 38 and newer
  - Red Hat Enterprise Linux (RHEL) 8 and newer
  - Ubuntu 20.04 and newer

This list is not an exclusive list, and it will most likely work
on all other distributions with recent enough dependencies.

The following dependencies are needed:

* A C++ compiler capable of at least ``-std=c++17``

* Meson Build System 0.58 or newer

  https://mesonbuild.com/

* OpenSSL 1.1.1 or newer

  https://www.openssl.org/

* GDBus++ v3 or newer

  https://codeberg.org/OpenVPN/gdbuspp/

* GLib2 2.56 or newer

  http://www.gtk.org

* jsoncpp 0.10.5 or newer

  https://github.com/open-source-parsers/jsoncpp

* libcap-ng 0.7.5 or newer

  http://people.redhat.com/sgrubb/libcap-ng

* liblz4 1.8.4 or newer

  https://lz4.github.io/lz4

* libuuid 2.23.2 or newer

  https://en.wikipedia.org/wiki/Util-linux

* polkit 0.112 or newer

  http://www.freedesktop.org/wiki/Software/polkit

  Only needed when using the systemd-resolved integration.  On Ubuntu this
  package is called policykit-1.

* tinyxml2 2.1.0 or newer

  https://github.com/leethomason/tinyxml2

* (optional) libnl3 3.2.29 or newer

  http://www.infradead.org/~tgr/libnl/

  Only needed when building with DCO support

* (optional) protobuf 2.4.0 or newer

  http://code.google.com/p/protobuf/

  Only needed when building with DCO support

* (optional) Python 3.6 or newer

  If Python 3.6 or newer is found, the openvpn2, openvpn3-autoload utilities
  and the openvpn3 Python module will be built and installed.

* (optional) Python docutils

  http://docutils.sourceforge.net/
  This is needed for the `rst2man` utility, used to generate the man pages.

* (optional) Python Jinja2 template engine

   https://palletsprojects.com/p/jinja/
   Required when enabling the bash-completion support; used to generate the
   bash-completion script for openvpn2.

* (optional) selinux-policy-devel

  For Linux distributions running with SELinux in enforced mode (like Red Hat
  Enterprise Linux and Fedora), this is required.

**NOTE**:  This project has recently switched to use Meson.  The documentation
           migth not be 100% up-to-date on all details.

           In addition, the GDBus++ library is also very new.  This is
           currently not available in upstream repositories.  Install the
           OpenVPN provided package repositories first to get the needed
           packages - or build it from source


First install the package dependencies needed to run the build.

#### Debian/Ubuntu:

- Building with OpenSSL:

  For newer Debian and Ubuntu releases shipping with OpenSSL 1.1 or newer:

      # apt-get install 

- Generic build requirements:

      # apt-get install build-essential git pkg-config meson libglib2.0-dev \
                        libjsoncpp-dev uuid-dev liblz4-dev libcap-ng-dev    \
                        libxml2-utils python3-minimal python3-dbus          \
                        python3-docutils python3-jinja2 libxml2-utils       \
                        libtinyxml2-dev policykit-1 libsystemd-dev          \
                        python3-systemd libssl-dev libssl1.1 libgdbuspp-dev \
                        libdbus-1-dev

- Dependencies to build with DCO support:

      # apt-get install libnl-3-dev libnl-genl-3-dev protobuf-compiler libprotobuf-dev


#### Fedora and Red Hat Enterprise Linux:

- Generic build requirements:

      # yum install gcc-c++ git meson pkgconfig glib2-devel jsoncpp-devel    \
                    libuuid-devel libcap-ng-devel selinux-policy-devel       \
                    lz4-devel zlib-devel libxml2 tinyxml2-devel python3-dbus \
                    python3-gobject python3-pyOpenSSL python3-jinja2         \
                    python3-docutils bzip2 polkit systemd-devel              \
                    python3-systemd openssl-devel gdbuspp-devel dbus-devel

- Dependencies to build with DCO support:

      # yum install libnl3-devel protobuf-compiler protobuf protobuf-devel


### Preparations building from git
- Clone this git repository: ``git clone git://github.com/OpenVPN/openvpn3-linux``
- Enter the ``openvpn3-linux`` directory: ``cd openvpn3-linux``
- Run: ``./bootstrap.sh``


### Adding the `openvpn` user and group accounts
The default configuration for the services assumes a service account
`openvpn` to be present.  If it does not exist you should add one, e.g. by:

    # groupadd -r openvpn
    # useradd -r -s /sbin/nologin -g openvpn openvpn


### Building OpenVPN 3 Linux client
If you already have a `./configure` script or have retrieved an
`openvpn3-linux-*.tar.xz` tarball generated by `make dist`, the following steps
will build the client.

- Run: ``meson setup --prefix=/usr _builddir``
- Run: ``meson compile -C _builddir``
- Run (as `root`): ``meson install -C _builddir``
- Run (as `root`): ``openvpn3-admin init-config --write-configs``

You might need to also reload D-Bus configuration to make D-Bus aware of
the newly installed service.  On most system this happens automatically
but occasionally a manual operation is needed:

    # systemctl reload dbus

With everything built and installed, it should be possible to run both the
``openvpn2`` and ``openvpn3`` command line tools - even as an unprivileged
user.


#### AWS-VPC integration

The OpenVPN 3 Linux AWS-VPC add-on is currently unavailable. This will be
reintroduced in a later release.


#### Auto-completion helper for bash/zsh

If you want to also install the bash-completion scripts for the
``openvpn2`` and ``openvpn3`` commands, add ``-Dbash-completion=enabled``
to the ``meson setup`` command, or run:

     $ meson configure -Dbash-completion=enabled _builddir

from the root of the project directory.
