/*****************************************************************************
*
* Copyright (c) 2000 - 2018, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-442911
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include <avtCurveMetaData.h>
#include <DataNode.h>

// ****************************************************************************
// Method: avtCurveMetaData::avtCurveMetaData
//
// Purpose: 
//   Init utility for the avtCurveMetaData class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void avtCurveMetaData::Init()
{
    xLabel = "X-Axis";
    yLabel = "Y-Axis";
    hasSpatialExtents = false;
    minSpatialExtents = 0;
    maxSpatialExtents = 0;

    avtCurveMetaData::SelectAll();
}

// ****************************************************************************
// Method: avtCurveMetaData::avtCurveMetaData
//
// Purpose: 
//   Copy utility for the avtCurveMetaData class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void avtCurveMetaData::Copy(const avtCurveMetaData &obj)
{
    xUnits = obj.xUnits;
    xLabel = obj.xLabel;
    yUnits = obj.yUnits;
    yLabel = obj.yLabel;
    hasSpatialExtents = obj.hasSpatialExtents;
    minSpatialExtents = obj.minSpatialExtents;
    maxSpatialExtents = obj.maxSpatialExtents;
    from1DScalarName = obj.from1DScalarName;

    avtCurveMetaData::SelectAll();
}

// Type map format string
const char *avtCurveMetaData::TypeMapFormatString = AVTCURVEMETADATA_TMFS;
const AttributeGroup::private_tmfs_t avtCurveMetaData::TmfsStruct = {AVTCURVEMETADATA_TMFS};


// ****************************************************************************
// Method: avtCurveMetaData::avtCurveMetaData
//
// Purpose: 
//   Default constructor for the avtCurveMetaData class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

avtCurveMetaData::avtCurveMetaData() : 
    avtVarMetaData(avtCurveMetaData::TmfsStruct)
{
    avtCurveMetaData::Init();
}

// ****************************************************************************
// Method: avtCurveMetaData::avtCurveMetaData
//
// Purpose: 
//   Constructor for the derived classes of avtCurveMetaData class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

avtCurveMetaData::avtCurveMetaData(private_tmfs_t tmfs) : 
    avtVarMetaData(tmfs)
{
    avtCurveMetaData::Init();
}

// ****************************************************************************
// Method: avtCurveMetaData::avtCurveMetaData
//
// Purpose: 
//   Copy constructor for the avtCurveMetaData class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

avtCurveMetaData::avtCurveMetaData(const avtCurveMetaData &obj) : 
    avtVarMetaData(obj,avtCurveMetaData::TmfsStruct)
{
    avtCurveMetaData::Copy(obj);
}

// ****************************************************************************
// Method: avtCurveMetaData::avtCurveMetaData
//
// Purpose: 
//   Copy constructor for derived classes of the avtCurveMetaData class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

avtCurveMetaData::avtCurveMetaData(const avtCurveMetaData &obj, private_tmfs_t tmfs) : 
    avtVarMetaData(obj,tmfs)
{
    avtCurveMetaData::Copy(obj);
}

// ****************************************************************************
// Method: avtCurveMetaData::~avtCurveMetaData
//
// Purpose: 
//   Destructor for the avtCurveMetaData class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

avtCurveMetaData::~avtCurveMetaData()
{
    // nothing here
}

// ****************************************************************************
// Method: avtCurveMetaData::operator = 
//
// Purpose: 
//   Assignment operator for the avtCurveMetaData class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

avtCurveMetaData& 
avtCurveMetaData::operator = (const avtCurveMetaData &obj)
{
    if (this == &obj) return *this;

    // call the base class' assignment operator first
    avtVarMetaData::operator=(obj);

    avtCurveMetaData::Copy(obj);

    return *this;
}

// ****************************************************************************
// Method: avtCurveMetaData::operator == 
//
// Purpose: 
//   Comparison operator == for the avtCurveMetaData class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
avtCurveMetaData::operator == (const avtCurveMetaData &obj) const
{
    // Create the return value
    return ((xUnits == obj.xUnits) &&
            (xLabel == obj.xLabel) &&
            (yUnits == obj.yUnits) &&
            (yLabel == obj.yLabel) &&
            (hasSpatialExtents == obj.hasSpatialExtents) &&
            (minSpatialExtents == obj.minSpatialExtents) &&
            (maxSpatialExtents == obj.maxSpatialExtents) &&
            (from1DScalarName == obj.from1DScalarName) &&
            avtVarMetaData::operator==(obj));
}

// ****************************************************************************
// Method: avtCurveMetaData::operator != 
//
// Purpose: 
//   Comparison operator != for the avtCurveMetaData class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
avtCurveMetaData::operator != (const avtCurveMetaData &obj) const
{
    return !(this->operator == (obj));
}

// ****************************************************************************
// Method: avtCurveMetaData::TypeName
//
// Purpose: 
//   Type name method for the avtCurveMetaData class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

const std::string
avtCurveMetaData::TypeName() const
{
    return "avtCurveMetaData";
}

// ****************************************************************************
// Method: avtCurveMetaData::CopyAttributes
//
// Purpose: 
//   CopyAttributes method for the avtCurveMetaData class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
avtCurveMetaData::CopyAttributes(const AttributeGroup *atts)
{
    if(TypeName() != atts->TypeName())
        return false;

    // Call assignment operator.
    const avtCurveMetaData *tmp = (const avtCurveMetaData *)atts;
    *this = *tmp;

    return true;
}

// ****************************************************************************
// Method: avtCurveMetaData::CreateCompatible
//
// Purpose: 
//   CreateCompatible method for the avtCurveMetaData class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
avtCurveMetaData::CreateCompatible(const std::string &tname) const
{
    AttributeSubject *retval = 0;
    if(TypeName() == tname)
        retval = new avtCurveMetaData(*this);
    // Other cases could go here too. 

    return retval;
}

// ****************************************************************************
// Method: avtCurveMetaData::NewInstance
//
// Purpose: 
//   NewInstance method for the avtCurveMetaData class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
avtCurveMetaData::NewInstance(bool copy) const
{
    AttributeSubject *retval = 0;
    if(copy)
        retval = new avtCurveMetaData(*this);
    else
        retval = new avtCurveMetaData;

    return retval;
}

// ****************************************************************************
// Method: avtCurveMetaData::SelectAll
//
// Purpose: 
//   Selects all attributes.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
avtCurveMetaData::SelectAll()
{
    // call the base class' SelectAll() first
    avtVarMetaData::SelectAll();
    Select(ID_xUnits,            (void *)&xUnits);
    Select(ID_xLabel,            (void *)&xLabel);
    Select(ID_yUnits,            (void *)&yUnits);
    Select(ID_yLabel,            (void *)&yLabel);
    Select(ID_hasSpatialExtents, (void *)&hasSpatialExtents);
    Select(ID_minSpatialExtents, (void *)&minSpatialExtents);
    Select(ID_maxSpatialExtents, (void *)&maxSpatialExtents);
    Select(ID_from1DScalarName,  (void *)&from1DScalarName);
}

///////////////////////////////////////////////////////////////////////////////
// Set property methods
///////////////////////////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////////////////////////
// Get property methods
///////////////////////////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////////////////////////
// Keyframing methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: avtCurveMetaData::GetFieldName
//
// Purpose: 
//   This method returns the name of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

std::string
avtCurveMetaData::GetFieldName(int index) const
{
    switch (index)
    {
    case ID_xUnits:            return "xUnits";
    case ID_xLabel:            return "xLabel";
    case ID_yUnits:            return "yUnits";
    case ID_yLabel:            return "yLabel";
    case ID_hasSpatialExtents: return "hasSpatialExtents";
    case ID_minSpatialExtents: return "minSpatialExtents";
    case ID_maxSpatialExtents: return "maxSpatialExtents";
    case ID_from1DScalarName:  return "from1DScalarName";
    default:  return avtVarMetaData::GetFieldName(index);
    }
}

// ****************************************************************************
// Method: avtCurveMetaData::GetFieldType
//
// Purpose: 
//   This method returns the type of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeGroup::FieldType
avtCurveMetaData::GetFieldType(int index) const
{
    switch (index)
    {
    case ID_xUnits:            return FieldType_string;
    case ID_xLabel:            return FieldType_string;
    case ID_yUnits:            return FieldType_string;
    case ID_yLabel:            return FieldType_string;
    case ID_hasSpatialExtents: return FieldType_bool;
    case ID_minSpatialExtents: return FieldType_double;
    case ID_maxSpatialExtents: return FieldType_double;
    case ID_from1DScalarName:  return FieldType_string;
    default:  return avtVarMetaData::GetFieldType(index);
    }
}

// ****************************************************************************
// Method: avtCurveMetaData::GetFieldTypeName
//
// Purpose: 
//   This method returns the name of a field type given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

std::string
avtCurveMetaData::GetFieldTypeName(int index) const
{
    switch (index)
    {
    case ID_xUnits:            return "string";
    case ID_xLabel:            return "string";
    case ID_yUnits:            return "string";
    case ID_yLabel:            return "string";
    case ID_hasSpatialExtents: return "bool";
    case ID_minSpatialExtents: return "double";
    case ID_maxSpatialExtents: return "double";
    case ID_from1DScalarName:  return "string";
    default:  return avtVarMetaData::GetFieldTypeName(index);
    }
}

// ****************************************************************************
// Method: avtCurveMetaData::FieldsEqual
//
// Purpose: 
//   This method compares two fields and return true if they are equal.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
avtCurveMetaData::FieldsEqual(int index_, const AttributeGroup *rhs) const
{
    const avtCurveMetaData &obj = *((const avtCurveMetaData*)rhs);
    bool retval = false;
    switch (index_)
    {
    case ID_xUnits:
        {  // new scope
        retval = (xUnits == obj.xUnits);
        }
        break;
    case ID_xLabel:
        {  // new scope
        retval = (xLabel == obj.xLabel);
        }
        break;
    case ID_yUnits:
        {  // new scope
        retval = (yUnits == obj.yUnits);
        }
        break;
    case ID_yLabel:
        {  // new scope
        retval = (yLabel == obj.yLabel);
        }
        break;
    case ID_hasSpatialExtents:
        {  // new scope
        retval = (hasSpatialExtents == obj.hasSpatialExtents);
        }
        break;
    case ID_minSpatialExtents:
        {  // new scope
        retval = (minSpatialExtents == obj.minSpatialExtents);
        }
        break;
    case ID_maxSpatialExtents:
        {  // new scope
        retval = (maxSpatialExtents == obj.maxSpatialExtents);
        }
        break;
    case ID_from1DScalarName:
        {  // new scope
        retval = (from1DScalarName == obj.from1DScalarName);
        }
        break;
    default: retval = avtVarMetaData::FieldsEqual(index_, rhs);
    }

    return retval;
}

///////////////////////////////////////////////////////////////////////////////
// User-defined methods.
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
//  Method: avtCurveMetaData constructor
//
//  Arguments:
//      n            The name of the curve
//
//  Programmer: Hank Childs
//  Creation:   August 1, 2003
//
//  Modifications:
//    Brad Whitlock, Fri Jul 23 12:50:27 PDT 2004
//    Added labels and units.
//
//    Hank Childs, Mon Feb 14 14:16:49 PST 2005
//    Added original name.
//
//    Kathleen Bonnell, Thu Aug  3 08:42:33 PDT 2006 
//    Added centering and DataExtents. 
//
// ****************************************************************************

avtCurveMetaData::avtCurveMetaData(const std::string &n)
    : avtVarMetaData(avtCurveMetaData::TmfsStruct)
{
    // Initialize all members
    *this = avtCurveMetaData();

    // Override some values.
    name          = n;
    originalName  = name;
}

// ****************************************************************************
//  Method: avtCurveMetaData constructor
//
//  Arguments:
//      n       The name of the curve
//      minS    The minimum spatial extents
//      maxS    The maximum spatial extents
//      minE    The minimum data extents
//      maxE    The maximum data extents
//
//  Programmer: Kathleen Bonnell 
//  Creation:   August 1, 2006
//
//  Modifications:
//
// ****************************************************************************

avtCurveMetaData::avtCurveMetaData(const std::string &n, double minS, double maxS, double minE, double maxE)
    : avtVarMetaData(avtCurveMetaData::TmfsStruct)
{
    // Initialize all members
    *this = avtCurveMetaData();

    // Override some values.
    name          = n;
    originalName  = name;
    hasSpatialExtents = true;
    minSpatialExtents = minS;
    maxSpatialExtents = maxS;
    hasDataExtents = true;
    minDataExtents = minE;
    maxDataExtents = maxE;
}

// ****************************************************************************
//  Method: avtCurveMetaData::SetSpatialExtents
//
//  Purpose:
//      Sets the spatial extents of the curve variable.
//
//  Arguments:
//      extents     Extents as <min value, max value>.
//
//  Programmer: Kathleen Bonnell 
//  Creation:   August 1, 2006
//
//  Modifications:
//
// ****************************************************************************

void
avtCurveMetaData::SetSpatialExtents(const double *extents)
{
    if (extents == NULL)
    {
        hasSpatialExtents = false;
    }
    else
    {
        hasSpatialExtents = true;
        minSpatialExtents = extents[0];
        maxSpatialExtents = extents[1];
    }
}

void
avtCurveMetaData::UnsetSpatialExtents()
{
    hasSpatialExtents = false;
}

// ****************************************************************************
//  Method: avtCurveMetaData::SetDataExtents
//
//  Purpose:
//      Sets the data extents of the curve variable.
//
//  Arguments:
//      extents     Extents as <min value, max value>.
//
//  Programmer: Kathleen Bonnell 
//  Creation:   August 1, 2006
//
//  Modifications:
//
// ****************************************************************************

void
avtCurveMetaData::SetDataExtents(const double *extents)
{
    if (extents == NULL)
    {
        hasDataExtents = false;
    }
    else
    {
        hasDataExtents = true;
        minDataExtents = extents[0];
        maxDataExtents = extents[1];
    }
}

void
avtCurveMetaData::UnsetDataExtents()
{
    hasDataExtents = false;
}

// ****************************************************************************
//  Method: avtCurveMetaData::Print
//
//  Purpose:
//      Print statement for debugging.
//
//  Arguments:
//      out      The stream to output to.
//      indent   The number of tabs to indent each line with.
//
//  Programmer: Hank Childs
//  Creation:   August 1, 2003
//
//  Modifications:
//    Brad Whitlock, Fri Jul 23 12:54:53 PDT 2004
//    Added labels and units.
//
//    Hank Childs, Mon Feb 14 14:16:49 PST 2005
//    Added original name.
//
//    Kathleen Bonnell, Thu Aug  3 08:42:33 PDT 2006 
//    Added centering and DataExtents. 
//
//    Mark C. Miller, Mon Feb  9 14:20:43 PST 2009
//    Added from1DScalarName
//
//    Mark C. Miller, Wed Feb 11 17:17:13 PST 2009
//    Removed centering
// ****************************************************************************
inline void
Indent(ostream &out, int indent)
{
    for (int i = 0 ; i < indent ; i++)
    {
        out << "\t";
    }
}
void
avtCurveMetaData::Print(ostream &out, int indent) const
{
    avtVarMetaData::Print(out, indent);

    Indent(out, indent);
    out << "Units = x:" << xUnits.c_str() << ", y:" << yUnits.c_str() << endl;

    Indent(out, indent);
    out << "Labels = x:" << xLabel.c_str() << ", y:" << yLabel.c_str() << endl;

    if (from1DScalarName != "")
    {
        Indent(out, indent);
        out << "Re-interpreted from 1D scalar named \"" << from1DScalarName << "\"" << endl;
    }
}

