CREATE TABLE IF NOT EXISTS us_rules (
    id serial, rule text, is_custom boolean NOT NULL DEFAULT true, CONSTRAINT pk_us_rules PRIMARY KEY(id)
);

-- this will be needed for upgrading to prevent purging of custom entries
DELETE FROM us_rules WHERE is_custom = false;

-- needed so entries we add will default to not custom
ALTER TABLE us_rules ALTER COLUMN is_custom SET DEFAULT false;

INSERT INTO us_rules (rule) VALUES ('1 -1 5 -1 2 7');
INSERT INTO us_rules (rule) VALUES ('1 3 -1 5 3 -1 2 7');
INSERT INTO us_rules (rule) VALUES ('1 22 -1 5 7 -1 2 7');
INSERT INTO us_rules (rule) VALUES ('1 22 3 -1 5 7 3 -1 2 7');
INSERT INTO us_rules (rule) VALUES ('1 2 -1 5 6 -1 2 13');
INSERT INTO us_rules (rule) VALUES ('1 2 3 -1 5 6 3 -1 2 13');
INSERT INTO us_rules (rule) VALUES ('1 2 22 -1 5 6 7 -1 2 13');
INSERT INTO us_rules (rule) VALUES ('1 2 22 3 -1 5 6 7 3 -1 2 13');
INSERT INTO us_rules (rule) VALUES ('18 -1 5 -1 2 2');
INSERT INTO us_rules (rule) VALUES ('18 3 -1 5 3 -1 2 2');
INSERT INTO us_rules (rule) VALUES ('18 22 -1 5 7 -1 2 2');
INSERT INTO us_rules (rule) VALUES ('18 22 3 -1 5 7 3 -1 2 2');
INSERT INTO us_rules (rule) VALUES ('18 2 -1 5 6 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('18 2 3 -1 5 6 3 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('18 2 22 -1 5 6 7 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('18 2 22 3 -1 5 6 7 3 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('2 -1 5 -1 2 2');
INSERT INTO us_rules (rule) VALUES ('2 3 -1 5 3 -1 2 2');
INSERT INTO us_rules (rule) VALUES ('2 22 -1 5 7 -1 2 2');
INSERT INTO us_rules (rule) VALUES ('2 22 3 -1 5 7 3 -1 2 2');
INSERT INTO us_rules (rule) VALUES ('2 2 -1 5 6 -1 2 10');
INSERT INTO us_rules (rule) VALUES ('2 2 3 -1 5 6 3 -1 2 10');
INSERT INTO us_rules (rule) VALUES ('2 2 22 -1 5 6 7 -1 2 10');
INSERT INTO us_rules (rule) VALUES ('2 2 22 3 -1 5 6 7 3 -1 2 10');
INSERT INTO us_rules (rule) VALUES ('22 -1 5 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('22 3 -1 5 3 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('22 22 -1 5 7 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('22 22 3 -1 5 7 3 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('22 2 -1 5 6 -1 2 8');
INSERT INTO us_rules (rule) VALUES ('22 2 3 -1 5 6 3 -1 2 8');
INSERT INTO us_rules (rule) VALUES ('22 2 22 -1 5 6 7 -1 2 8');
INSERT INTO us_rules (rule) VALUES ('22 2 22 3 -1 5 6 7 3 -1 2 8');
INSERT INTO us_rules (rule) VALUES ('22 1 -1 5 5 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('22 1 3 -1 5 5 3 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('22 1 22 -1 5 5 7 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('22 1 22 3 -1 5 5 7 3 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('22 1 2 -1 5 5 6 -1 2 5');
INSERT INTO us_rules (rule) VALUES ('22 1 2 3 -1 5 5 6 3 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 1 2 22 -1 5 5 6 7 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 1 2 22 3 -1 5 5 6 7 3 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('1 22 -1 5 5 -1 2 5');
INSERT INTO us_rules (rule) VALUES ('1 22 3 -1 5 5 3 -1 2 4');
INSERT INTO us_rules (rule) VALUES ('1 22 22 -1 5 5 7 -1 2 5');
INSERT INTO us_rules (rule) VALUES ('1 22 22 3 -1 5 5 7 3 -1 2 4');
INSERT INTO us_rules (rule) VALUES ('1 22 2 -1 5 5 6 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('1 22 2 3 -1 5 5 6 3 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('1 22 2 22 -1 5 5 6 7 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('1 22 2 22 3 -1 5 5 6 7 3 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('1 2 -1 5 5 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('1 2 3 -1 5 5 3 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('1 2 22 -1 5 5 7 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('1 2 22 3 -1 5 5 7 3 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('1 2 2 -1 5 5 6 -1 2 5');
INSERT INTO us_rules (rule) VALUES ('1 2 2 3 -1 5 5 6 3 -1 2 5');
INSERT INTO us_rules (rule) VALUES ('1 2 2 22 -1 5 5 6 7 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('1 2 2 22 3 -1 5 5 6 7 3 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('2 1 -1 5 5 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('2 1 3 -1 5 5 3 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('2 1 22 -1 5 5 7 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('2 1 22 3 -1 5 5 7 3 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('2 1 2 -1 5 5 6 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('2 1 2 3 -1 5 5 6 3 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('2 1 2 22 -1 5 5 6 7 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('2 1 2 22 3 -1 5 5 6 7 3 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('15 2 -1 5 6 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('15 2 3 -1 5 6 3 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('15 2 22 -1 5 6 7 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('15 2 22 3 -1 5 6 7 3 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('16 0 2 -1 5 5 6 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('16 0 2 3 -1 5 5 6 3 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('24 2 -1 5 5 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('24 2 3 -1 5 5 3 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('24 2 22 -1 5 5 7 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('24 2 22 3 -1 5 5 7 3 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('24 2 2 -1 5 5 6 -1 2 5');
INSERT INTO us_rules (rule) VALUES ('24 2 2 3 -1 5 5 6 3 -1 2 5');
INSERT INTO us_rules (rule) VALUES ('24 2 2 22 -1 5 5 6 7 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('24 2 2 22 3 -1 5 5 6 7 3 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('0 22 -1 5 5 -1 2 5');
INSERT INTO us_rules (rule) VALUES ('0 22 3 -1 5 5 3 -1 2 4');
INSERT INTO us_rules (rule) VALUES ('0 22 22 -1 5 5 7 -1 2 5');
INSERT INTO us_rules (rule) VALUES ('0 22 22 3 -1 5 5 7 3 -1 2 4');
INSERT INTO us_rules (rule) VALUES ('0 22 2 -1 5 5 6 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('0 22 2 3 -1 5 5 6 3 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('0 22 2 22 -1 5 5 6 7 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('0 22 2 22 3 -1 5 5 6 7 3 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('2 24 -1 5 5 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('2 24 3 -1 5 5 3 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('2 24 22 -1 5 5 7 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('2 24 22 3 -1 5 5 7 3 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('2 24 2 -1 5 5 6 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('2 24 2 3 -1 5 5 6 3 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('2 24 2 22 -1 5 5 6 7 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('2 24 2 22 3 -1 5 5 6 7 3 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('2 22 -1 5 5 -1 2 5');
INSERT INTO us_rules (rule) VALUES ('2 22 3 -1 5 5 3 -1 2 4');
INSERT INTO us_rules (rule) VALUES ('2 22 22 -1 5 5 7 -1 2 5');
INSERT INTO us_rules (rule) VALUES ('2 22 22 3 -1 5 5 7 3 -1 2 4');
INSERT INTO us_rules (rule) VALUES ('2 22 2 -1 5 5 6 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('2 22 2 3 -1 5 5 6 3 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('2 22 2 22 -1 5 5 6 7 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('2 22 2 22 3 -1 5 5 6 7 3 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('2 0 -1 5 5 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('2 0 3 -1 5 5 3 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('2 0 22 -1 5 5 7 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('2 0 22 3 -1 5 5 7 3 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('2 0 2 -1 5 5 6 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('2 0 2 3 -1 5 5 6 3 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('2 0 2 22 -1 5 5 6 7 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('2 0 2 22 3 -1 5 5 6 7 3 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('2 18 -1 5 5 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('2 18 3 -1 5 5 3 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('2 18 22 -1 5 5 7 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('2 18 22 3 -1 5 5 7 3 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('2 18 2 -1 5 5 6 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('2 18 2 3 -1 5 5 6 3 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('2 18 2 22 -1 5 5 6 7 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('2 18 2 22 3 -1 5 5 6 7 3 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('2 2 -1 5 5 -1 2 3');
INSERT INTO us_rules (rule) VALUES ('2 2 3 -1 5 5 3 -1 2 3');
INSERT INTO us_rules (rule) VALUES ('2 2 22 -1 5 5 7 -1 2 3');
INSERT INTO us_rules (rule) VALUES ('2 2 22 3 -1 5 5 7 3 -1 2 3');
INSERT INTO us_rules (rule) VALUES ('2 2 2 -1 5 5 6 -1 2 5');
INSERT INTO us_rules (rule) VALUES ('2 2 2 3 -1 5 5 6 3 -1 2 5');
INSERT INTO us_rules (rule) VALUES ('2 2 2 22 -1 5 5 6 7 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('2 2 2 22 3 -1 5 5 6 7 3 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('18 2 -1 5 5 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('18 2 3 -1 5 5 3 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('18 2 22 -1 5 5 7 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('18 2 22 3 -1 5 5 7 3 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('18 2 2 -1 5 5 6 -1 2 5');
INSERT INTO us_rules (rule) VALUES ('18 2 2 3 -1 5 5 6 3 -1 2 5');
INSERT INTO us_rules (rule) VALUES ('18 2 2 22 -1 5 5 6 7 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('18 2 2 22 3 -1 5 5 6 7 3 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('1 18 2 -1 5 5 5 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('1 18 2 3 -1 5 5 5 3 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('1 18 2 22 -1 5 5 5 7 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('1 18 2 22 3 -1 5 5 5 7 3 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('1 18 2 2 -1 5 5 5 6 -1 2 5');
INSERT INTO us_rules (rule) VALUES ('1 18 2 2 3 -1 5 5 5 6 3 -1 2 5');
INSERT INTO us_rules (rule) VALUES ('1 18 2 2 22 -1 5 5 5 6 7 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('1 18 2 2 22 3 -1 5 5 5 6 7 3 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('0 -1 5 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('0 3 -1 5 3 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('0 22 -1 5 7 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('0 22 3 -1 5 7 3 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('0 2 -1 5 6 -1 2 10');
INSERT INTO us_rules (rule) VALUES ('0 2 3 -1 5 6 3 -1 2 10');
INSERT INTO us_rules (rule) VALUES ('0 2 22 -1 5 6 7 -1 2 10');
INSERT INTO us_rules (rule) VALUES ('0 2 22 3 -1 5 6 7 3 -1 2 10');
INSERT INTO us_rules (rule) VALUES ('0 18 -1 5 5 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('0 18 3 -1 5 5 3 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('0 18 22 -1 5 5 7 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('0 18 22 3 -1 5 5 7 3 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('0 18 2 -1 5 5 6 -1 2 10');
INSERT INTO us_rules (rule) VALUES ('0 18 2 3 -1 5 5 6 3 -1 2 10');
INSERT INTO us_rules (rule) VALUES ('0 18 2 22 -1 5 5 6 7 -1 2 10');
INSERT INTO us_rules (rule) VALUES ('0 18 2 22 3 -1 5 5 6 7 3 -1 2 10');
INSERT INTO us_rules (rule) VALUES ('0 1 -1 5 5 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('0 1 3 -1 5 5 3 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('0 1 22 -1 5 5 7 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('0 1 22 3 -1 5 5 7 3 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('0 1 2 -1 5 5 6 -1 2 10');
INSERT INTO us_rules (rule) VALUES ('0 1 2 3 -1 5 5 6 3 -1 2 10');
INSERT INTO us_rules (rule) VALUES ('0 1 2 22 -1 5 5 6 7 -1 2 10');
INSERT INTO us_rules (rule) VALUES ('0 1 2 22 3 -1 5 5 6 7 3 -1 2 10');
INSERT INTO us_rules (rule) VALUES ('1 2 2 -1 5 5 5 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('1 2 2 3 -1 5 5 5 3 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('1 2 2 22 -1 5 5 5 7 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('1 2 2 22 3 -1 5 5 5 7 3 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('1 2 2 2 -1 5 5 5 6 -1 2 5');
INSERT INTO us_rules (rule) VALUES ('1 2 2 2 3 -1 5 5 5 6 3 -1 2 5');
INSERT INTO us_rules (rule) VALUES ('1 2 2 2 22 -1 5 5 5 6 7 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('1 2 2 2 22 3 -1 5 5 5 6 7 3 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 2 -1 5 5 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('22 2 3 -1 5 5 3 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('22 2 22 -1 5 5 7 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('22 2 22 3 -1 5 5 7 3 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('22 2 2 -1 5 5 6 -1 2 5');
INSERT INTO us_rules (rule) VALUES ('22 2 2 3 -1 5 5 6 3 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 2 2 22 -1 5 5 6 7 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 2 2 22 3 -1 5 5 6 7 3 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('14 -1 5 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('14 3 -1 5 3 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('14 22 -1 5 7 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('14 22 3 -1 5 7 3 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('14 2 -1 5 6 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('14 2 3 -1 5 6 3 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('14 2 22 -1 5 6 7 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('14 2 22 3 -1 5 6 7 3 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('15 1 -1 5 5 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('15 1 3 -1 5 5 3 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('15 1 22 -1 5 5 7 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('15 1 22 3 -1 5 5 7 3 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('15 1 2 -1 5 5 6 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('15 1 2 3 -1 5 5 6 3 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('15 1 2 22 -1 5 5 6 7 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('15 1 2 22 3 -1 5 5 6 7 3 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('24 -1 5 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('24 3 -1 5 3 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('24 22 -1 5 7 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('24 22 3 -1 5 7 3 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('24 2 -1 5 6 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('24 2 3 -1 5 6 3 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('24 2 22 -1 5 6 7 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('24 2 22 3 -1 5 6 7 3 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('24 24 -1 5 5 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('24 24 3 -1 5 5 3 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('24 24 22 -1 5 5 7 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('24 24 22 3 -1 5 5 7 3 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('24 24 2 -1 5 5 6 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('24 24 2 3 -1 5 5 6 3 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('24 24 2 22 -1 5 5 6 7 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('24 24 2 22 3 -1 5 5 6 7 3 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('24 1 -1 5 5 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('24 1 3 -1 5 5 3 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('24 1 22 -1 5 5 7 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('24 1 22 3 -1 5 5 7 3 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('24 1 2 -1 5 5 6 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('24 1 2 3 -1 5 5 6 3 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('24 1 2 22 -1 5 5 6 7 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('24 1 2 22 3 -1 5 5 6 7 3 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('25 -1 5 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('25 3 -1 5 3 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('25 22 -1 5 7 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('25 22 3 -1 5 7 3 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('25 2 -1 5 6 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('25 2 3 -1 5 6 3 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('25 2 22 -1 5 6 7 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('25 2 22 3 -1 5 6 7 3 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('23 -1 5 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('23 3 -1 5 3 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('23 22 -1 5 7 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('23 22 3 -1 5 7 3 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('23 2 -1 5 6 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('23 2 3 -1 5 6 3 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('23 2 22 -1 5 6 7 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('23 2 22 3 -1 5 6 7 3 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('0 13 0 -1 5 5 5 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('0 13 0 3 -1 5 5 5 3 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('0 13 0 22 -1 5 5 5 7 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('0 13 0 22 3 -1 5 5 5 7 3 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('0 13 0 2 -1 5 5 5 6 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('0 13 0 2 3 -1 5 5 5 6 3 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('0 13 0 2 22 -1 5 5 5 6 7 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('0 13 0 2 22 3 -1 5 5 5 6 7 3 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('0 25 -1 5 5 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('0 25 3 -1 5 5 3 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('0 25 22 -1 5 5 7 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('0 25 22 3 -1 5 5 7 3 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('0 25 2 -1 5 5 6 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('0 25 2 3 -1 5 5 6 3 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('0 25 2 22 -1 5 5 6 7 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('0 25 2 22 3 -1 5 5 6 7 3 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('11 -1 5 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('11 3 -1 5 3 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('11 22 -1 5 7 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('11 22 3 -1 5 7 3 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('11 2 -1 5 6 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('11 2 3 -1 5 6 3 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('11 2 22 -1 5 6 7 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('11 2 22 3 -1 5 6 7 3 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('3 0 -1 3 5 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('3 0 3 -1 3 5 3 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('3 0 22 -1 3 5 7 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('3 0 22 3 -1 3 5 7 3 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('3 0 2 -1 3 5 6 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('3 0 2 3 -1 3 5 6 3 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('3 0 2 22 -1 3 5 6 7 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('3 0 2 22 3 -1 3 5 6 7 3 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('3 1 -1 3 5 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('3 1 3 -1 3 5 3 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('3 1 22 -1 3 5 7 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('3 1 22 3 -1 3 5 7 3 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('3 1 2 -1 3 5 6 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('3 1 2 3 -1 3 5 6 3 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('3 1 2 22 -1 3 5 6 7 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('3 1 2 22 3 -1 3 5 6 7 3 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('18 13 18 -1 5 5 3 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('18 13 18 3 -1 5 5 3 3 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('18 13 18 22 -1 5 5 3 7 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('18 13 18 22 3 -1 5 5 3 7 3 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('18 13 18 2 -1 5 5 3 6 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('18 13 18 2 3 -1 5 5 3 6 3 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('18 13 18 2 22 -1 5 5 3 6 7 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('18 13 18 2 22 3 -1 5 5 3 6 7 3 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('18 0 -1 5 5 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('18 0 3 -1 5 5 3 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('18 0 22 -1 5 5 7 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('18 0 22 3 -1 5 5 7 3 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('18 0 2 -1 5 5 6 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('18 0 2 3 -1 5 5 6 3 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('18 0 2 22 -1 5 5 6 7 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('18 0 2 22 3 -1 5 5 6 7 3 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('18 18 -1 5 5 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('18 18 3 -1 5 5 3 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('18 18 22 -1 5 5 7 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('18 18 22 3 -1 5 5 7 3 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('18 18 2 -1 5 5 6 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('18 18 2 3 -1 5 5 6 3 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('18 18 2 22 -1 5 5 6 7 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('18 18 2 22 3 -1 5 5 6 7 3 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('18 18 18 -1 5 5 5 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('18 18 18 3 -1 5 5 5 3 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('18 18 18 22 -1 5 5 5 7 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('18 18 18 22 3 -1 5 5 5 7 3 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('18 18 18 2 -1 5 5 5 6 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('18 18 18 2 3 -1 5 5 5 6 3 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('18 18 18 2 22 -1 5 5 5 6 7 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('18 18 18 2 22 3 -1 5 5 5 6 7 3 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('18 18 1 -1 5 5 5 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('18 18 1 3 -1 5 5 5 3 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('18 18 1 22 -1 5 5 5 7 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('18 18 1 22 3 -1 5 5 5 7 3 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('18 18 1 2 -1 5 5 5 6 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('18 18 1 2 3 -1 5 5 5 6 3 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('18 18 1 2 22 -1 5 5 5 6 7 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('18 18 1 2 22 3 -1 5 5 5 6 7 3 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('18 1 -1 5 5 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('18 1 3 -1 5 5 3 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('18 1 22 -1 5 5 7 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('18 1 22 3 -1 5 5 7 3 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('18 1 2 -1 5 5 6 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('18 1 2 3 -1 5 5 6 3 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('18 1 2 22 -1 5 5 6 7 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('18 1 2 22 3 -1 5 5 6 7 3 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('5 -1 5 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('5 3 -1 5 3 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('5 22 -1 5 7 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('5 22 3 -1 5 7 3 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('5 2 -1 5 6 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('5 2 3 -1 5 6 3 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('5 2 22 -1 5 6 7 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('5 2 22 3 -1 5 6 7 3 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('21 -1 5 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('21 3 -1 5 3 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('21 22 -1 5 7 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('21 22 3 -1 5 7 3 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('21 2 -1 5 6 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('21 2 3 -1 5 6 3 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('21 2 22 -1 5 6 7 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('21 2 22 3 -1 5 6 7 3 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('1 13 1 -1 5 5 5 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('1 13 1 3 -1 5 5 5 3 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('1 13 1 22 -1 5 5 5 7 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('1 13 1 22 3 -1 5 5 5 7 3 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('1 13 1 2 -1 5 5 5 6 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('1 13 1 2 3 -1 5 5 5 6 3 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('1 13 1 2 22 -1 5 5 5 6 7 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('1 13 1 2 22 3 -1 5 5 5 6 7 3 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('1 24 -1 5 5 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('1 24 3 -1 5 5 3 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('1 24 22 -1 5 5 7 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('1 24 22 3 -1 5 5 7 3 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('1 24 2 -1 5 5 6 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('1 24 2 3 -1 5 5 6 3 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('1 24 2 22 -1 5 5 6 7 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('1 24 2 22 3 -1 5 5 6 7 3 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('1 24 24 -1 5 5 5 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('1 24 24 3 -1 5 5 5 3 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('1 24 24 22 -1 5 5 5 7 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('1 24 24 22 3 -1 5 5 5 7 3 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('1 24 24 2 -1 5 5 5 6 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('1 24 24 2 3 -1 5 5 5 6 3 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('1 24 24 2 22 -1 5 5 5 6 7 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('1 24 24 2 22 3 -1 5 5 5 6 7 3 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('1 24 1 -1 5 5 5 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('1 24 1 3 -1 5 5 5 3 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('1 24 1 22 -1 5 5 5 7 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('1 24 1 22 3 -1 5 5 5 7 3 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('1 24 1 2 -1 5 5 5 6 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('1 24 1 2 3 -1 5 5 5 6 3 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('1 24 1 2 22 -1 5 5 5 6 7 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('1 24 1 2 22 3 -1 5 5 5 6 7 3 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('1 15 -1 5 5 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('1 15 3 -1 5 5 3 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('1 15 22 -1 5 5 7 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('1 15 22 3 -1 5 5 7 3 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('1 15 2 -1 5 5 6 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('1 15 2 3 -1 5 5 6 3 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('1 15 2 22 -1 5 5 6 7 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('1 15 2 22 3 -1 5 5 6 7 3 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('1 22 1 -1 5 5 5 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('1 22 1 3 -1 5 5 5 3 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('1 22 1 22 -1 5 5 5 7 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('1 22 1 22 3 -1 5 5 5 7 3 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('1 22 1 2 -1 5 5 5 6 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('1 22 1 2 3 -1 5 5 5 6 3 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('1 22 1 2 22 -1 5 5 5 6 7 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('1 22 1 2 22 3 -1 5 5 5 6 7 3 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('1 25 -1 5 5 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('1 25 3 -1 5 5 3 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('1 25 22 -1 5 5 7 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('1 25 22 3 -1 5 5 7 3 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('1 25 2 -1 5 5 6 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('1 25 2 3 -1 5 5 6 3 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('1 25 2 22 -1 5 5 6 7 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('1 25 2 22 3 -1 5 5 6 7 3 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('1 0 -1 5 5 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('1 0 3 -1 5 5 3 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('1 0 22 -1 5 5 7 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('1 0 22 3 -1 5 5 7 3 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('1 0 2 -1 5 5 6 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('1 0 2 3 -1 5 5 6 3 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('1 0 2 22 -1 5 5 6 7 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('1 0 2 22 3 -1 5 5 6 7 3 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('1 3 -1 5 5 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('1 3 3 -1 5 5 3 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('1 3 22 -1 5 5 7 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('1 3 22 3 -1 5 5 7 3 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('1 3 2 -1 5 5 6 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('1 3 2 3 -1 5 5 6 3 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('1 3 2 22 -1 5 5 6 7 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('1 3 2 22 3 -1 5 5 6 7 3 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('1 18 -1 5 5 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('1 18 3 -1 5 5 3 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('1 18 22 -1 5 5 7 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('1 18 22 3 -1 5 5 7 3 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('1 18 2 -1 5 5 6 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('1 18 2 3 -1 5 5 6 3 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('1 18 2 22 -1 5 5 6 7 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('1 18 2 22 3 -1 5 5 6 7 3 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('1 18 18 1 -1 5 5 5 5 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('1 18 18 1 3 -1 5 5 5 5 3 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('1 18 18 1 22 -1 5 5 5 5 7 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('1 18 18 1 22 3 -1 5 5 5 5 7 3 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('1 18 18 1 2 -1 5 5 5 5 6 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('1 18 18 1 2 3 -1 5 5 5 5 6 3 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('1 18 18 1 2 22 -1 5 5 5 5 6 7 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('1 18 18 1 2 22 3 -1 5 5 5 5 6 7 3 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('1 18 1 -1 5 5 5 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('1 18 1 3 -1 5 5 5 3 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('1 18 1 22 -1 5 5 5 7 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('1 18 1 22 3 -1 5 5 5 7 3 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('1 18 1 2 -1 5 5 5 6 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('1 18 1 2 3 -1 5 5 5 6 3 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('1 18 1 2 22 -1 5 5 5 6 7 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('1 18 1 2 22 3 -1 5 5 5 6 7 3 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('1 2 0 -1 5 5 5 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('1 2 0 3 -1 5 5 5 3 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('1 2 0 22 -1 5 5 5 7 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('1 2 0 22 3 -1 5 5 5 7 3 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('1 2 0 2 -1 5 5 5 6 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('1 2 0 2 3 -1 5 5 5 6 3 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('1 2 0 2 22 -1 5 5 5 6 7 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('1 2 0 2 22 3 -1 5 5 5 6 7 3 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('1 2 1 -1 5 5 5 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('1 2 1 3 -1 5 5 5 3 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('1 2 1 22 -1 5 5 5 7 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('1 2 1 22 3 -1 5 5 5 7 3 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('1 2 1 2 -1 5 5 5 6 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('1 2 1 2 3 -1 5 5 5 6 3 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('1 2 1 2 22 -1 5 5 5 6 7 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('1 2 1 2 22 3 -1 5 5 5 6 7 3 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('16 -1 5 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('16 3 -1 5 3 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('16 22 -1 5 7 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('16 22 3 -1 5 7 3 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('16 2 -1 5 6 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('16 2 3 -1 5 6 3 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('16 2 22 -1 5 6 7 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('16 2 22 3 -1 5 6 7 3 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('2 1 -1 4 5 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('2 1 3 -1 4 5 3 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('2 1 22 -1 4 5 7 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('2 1 22 3 -1 4 5 7 3 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('2 18 -1 4 5 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('2 18 3 -1 4 5 3 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('2 18 22 -1 4 5 7 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('2 18 22 3 -1 4 5 7 3 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('2 2 -1 4 5 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('2 2 3 -1 4 5 3 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('2 2 22 -1 4 5 7 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('2 2 22 3 -1 4 5 7 3 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('2 22 -1 4 5 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('2 22 3 -1 4 5 3 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('2 22 22 -1 4 5 7 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('2 22 22 3 -1 4 5 7 3 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('2 22 1 -1 4 5 5 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('2 22 1 3 -1 4 5 5 3 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('2 22 1 22 -1 4 5 5 7 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('2 22 1 22 3 -1 4 5 5 7 3 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('2 1 22 -1 4 5 5 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('2 1 22 3 -1 4 5 5 3 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('2 1 22 22 -1 4 5 5 7 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('2 1 22 22 3 -1 4 5 5 7 3 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('2 1 2 -1 4 5 5 -1 2 4');
INSERT INTO us_rules (rule) VALUES ('2 1 2 3 -1 4 5 5 3 -1 2 4');
INSERT INTO us_rules (rule) VALUES ('2 1 2 22 -1 4 5 5 7 -1 2 4');
INSERT INTO us_rules (rule) VALUES ('2 1 2 22 3 -1 4 5 5 7 3 -1 2 4');
INSERT INTO us_rules (rule) VALUES ('2 2 1 -1 4 5 5 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('2 2 1 3 -1 4 5 5 3 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('2 2 1 22 -1 4 5 5 7 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('2 2 1 22 3 -1 4 5 5 7 3 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('2 24 2 -1 4 5 5 -1 2 4');
INSERT INTO us_rules (rule) VALUES ('2 24 2 3 -1 4 5 5 3 -1 2 4');
INSERT INTO us_rules (rule) VALUES ('2 24 2 22 -1 4 5 5 7 -1 2 4');
INSERT INTO us_rules (rule) VALUES ('2 24 2 22 3 -1 4 5 5 7 3 -1 2 4');
INSERT INTO us_rules (rule) VALUES ('2 0 22 -1 4 5 5 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('2 0 22 3 -1 4 5 5 3 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('2 0 22 22 -1 4 5 5 7 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('2 0 22 22 3 -1 4 5 5 7 3 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('2 2 24 -1 4 5 5 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('2 2 24 3 -1 4 5 5 3 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('2 2 24 22 -1 4 5 5 7 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('2 2 24 22 3 -1 4 5 5 7 3 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('2 2 22 -1 4 5 5 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('2 2 22 3 -1 4 5 5 3 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('2 2 22 22 -1 4 5 5 7 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('2 2 22 22 3 -1 4 5 5 7 3 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('2 2 0 -1 4 5 5 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('2 2 0 3 -1 4 5 5 3 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('2 2 0 22 -1 4 5 5 7 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('2 2 0 22 3 -1 4 5 5 7 3 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('2 2 18 -1 4 5 5 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('2 2 18 3 -1 4 5 5 3 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('2 2 18 22 -1 4 5 5 7 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('2 2 18 22 3 -1 4 5 5 7 3 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('2 2 2 -1 4 5 5 -1 2 4');
INSERT INTO us_rules (rule) VALUES ('2 2 2 3 -1 4 5 5 3 -1 2 4');
INSERT INTO us_rules (rule) VALUES ('2 2 2 22 -1 4 5 5 7 -1 2 4');
INSERT INTO us_rules (rule) VALUES ('2 2 2 22 3 -1 4 5 5 7 3 -1 2 4');
INSERT INTO us_rules (rule) VALUES ('2 18 2 -1 4 5 5 -1 2 4');
INSERT INTO us_rules (rule) VALUES ('2 18 2 3 -1 4 5 5 3 -1 2 4');
INSERT INTO us_rules (rule) VALUES ('2 18 2 22 -1 4 5 5 7 -1 2 4');
INSERT INTO us_rules (rule) VALUES ('2 18 2 22 3 -1 4 5 5 7 3 -1 2 4');
INSERT INTO us_rules (rule) VALUES ('2 1 18 2 -1 4 5 5 5 -1 2 4');
INSERT INTO us_rules (rule) VALUES ('2 1 18 2 3 -1 4 5 5 5 3 -1 2 4');
INSERT INTO us_rules (rule) VALUES ('2 1 18 2 22 -1 4 5 5 5 7 -1 2 4');
INSERT INTO us_rules (rule) VALUES ('2 1 18 2 22 3 -1 4 5 5 5 7 3 -1 2 4');
INSERT INTO us_rules (rule) VALUES ('2 0 -1 4 5 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('2 0 3 -1 4 5 3 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('2 0 22 -1 4 5 7 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('2 0 22 3 -1 4 5 7 3 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('2 0 18 -1 4 5 5 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('2 0 18 3 -1 4 5 5 3 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('2 0 18 22 -1 4 5 5 7 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('2 0 18 22 3 -1 4 5 5 7 3 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('2 0 1 -1 4 5 5 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('2 0 1 3 -1 4 5 5 3 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('2 0 1 22 -1 4 5 5 7 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('2 0 1 22 3 -1 4 5 5 7 3 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('2 1 2 2 -1 4 5 5 5 -1 2 4');
INSERT INTO us_rules (rule) VALUES ('2 1 2 2 3 -1 4 5 5 5 3 -1 2 4');
INSERT INTO us_rules (rule) VALUES ('2 1 2 2 22 -1 4 5 5 5 7 -1 2 4');
INSERT INTO us_rules (rule) VALUES ('2 1 2 2 22 3 -1 4 5 5 5 7 3 -1 2 4');
INSERT INTO us_rules (rule) VALUES ('2 22 2 -1 4 5 5 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('2 22 2 3 -1 4 5 5 3 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('2 22 2 22 -1 4 5 5 7 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('2 22 2 22 3 -1 4 5 5 7 3 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('2 14 -1 4 5 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('2 14 3 -1 4 5 3 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('2 14 22 -1 4 5 7 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('2 14 22 3 -1 4 5 7 3 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('2 15 1 -1 4 5 5 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('2 15 1 3 -1 4 5 5 3 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('2 15 1 22 -1 4 5 5 7 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('2 15 1 22 3 -1 4 5 5 7 3 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('2 24 -1 4 5 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('2 24 3 -1 4 5 3 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('2 24 22 -1 4 5 7 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('2 24 22 3 -1 4 5 7 3 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('2 24 24 -1 4 5 5 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('2 24 24 3 -1 4 5 5 3 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('2 24 24 22 -1 4 5 5 7 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('2 24 24 22 3 -1 4 5 5 7 3 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('2 24 1 -1 4 5 5 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('2 24 1 3 -1 4 5 5 3 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('2 24 1 22 -1 4 5 5 7 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('2 24 1 22 3 -1 4 5 5 7 3 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('2 25 -1 4 5 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('2 25 3 -1 4 5 3 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('2 25 22 -1 4 5 7 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('2 25 22 3 -1 4 5 7 3 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('2 23 -1 4 5 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('2 23 3 -1 4 5 3 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('2 23 22 -1 4 5 7 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('2 23 22 3 -1 4 5 7 3 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('2 0 13 0 -1 4 5 5 5 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('2 0 13 0 3 -1 4 5 5 5 3 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('2 0 13 0 22 -1 4 5 5 5 7 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('2 0 13 0 22 3 -1 4 5 5 5 7 3 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('2 0 25 -1 4 5 5 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('2 0 25 3 -1 4 5 5 3 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('2 0 25 22 -1 4 5 5 7 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('2 0 25 22 3 -1 4 5 5 7 3 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('2 11 -1 4 5 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('2 11 3 -1 4 5 3 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('2 11 22 -1 4 5 7 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('2 11 22 3 -1 4 5 7 3 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('2 3 0 -1 4 3 5 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('2 3 0 3 -1 4 3 5 3 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('2 3 0 22 -1 4 3 5 7 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('2 3 0 22 3 -1 4 3 5 7 3 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('2 3 1 -1 4 3 5 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('2 3 1 3 -1 4 3 5 3 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('2 3 1 22 -1 4 3 5 7 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('2 3 1 22 3 -1 4 3 5 7 3 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('2 18 13 18 -1 4 5 5 3 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('2 18 13 18 3 -1 4 5 5 3 3 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('2 18 13 18 22 -1 4 5 5 3 7 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('2 18 13 18 22 3 -1 4 5 5 3 7 3 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('2 18 0 -1 4 5 5 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('2 18 0 3 -1 4 5 5 3 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('2 18 0 22 -1 4 5 5 7 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('2 18 0 22 3 -1 4 5 5 7 3 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('2 18 18 -1 4 5 5 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('2 18 18 3 -1 4 5 5 3 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('2 18 18 22 -1 4 5 5 7 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('2 18 18 22 3 -1 4 5 5 7 3 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('2 18 18 18 -1 4 5 5 5 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('2 18 18 18 3 -1 4 5 5 5 3 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('2 18 18 18 22 -1 4 5 5 5 7 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('2 18 18 18 22 3 -1 4 5 5 5 7 3 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('2 18 18 1 -1 4 5 5 5 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('2 18 18 1 3 -1 4 5 5 5 3 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('2 18 18 1 22 -1 4 5 5 5 7 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('2 18 18 1 22 3 -1 4 5 5 5 7 3 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('2 18 1 -1 4 5 5 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('2 18 1 3 -1 4 5 5 3 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('2 18 1 22 -1 4 5 5 7 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('2 18 1 22 3 -1 4 5 5 7 3 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('2 5 -1 4 5 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('2 5 3 -1 4 5 3 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('2 5 22 -1 4 5 7 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('2 5 22 3 -1 4 5 7 3 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('2 21 -1 4 5 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('2 21 3 -1 4 5 3 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('2 21 22 -1 4 5 7 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('2 21 22 3 -1 4 5 7 3 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('2 1 13 1 -1 4 5 5 5 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('2 1 13 1 3 -1 4 5 5 5 3 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('2 1 13 1 22 -1 4 5 5 5 7 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('2 1 13 1 22 3 -1 4 5 5 5 7 3 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('2 1 24 -1 4 5 5 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('2 1 24 3 -1 4 5 5 3 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('2 1 24 22 -1 4 5 5 7 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('2 1 24 22 3 -1 4 5 5 7 3 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('2 1 24 24 -1 4 5 5 5 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('2 1 24 24 3 -1 4 5 5 5 3 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('2 1 24 24 22 -1 4 5 5 5 7 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('2 1 24 24 22 3 -1 4 5 5 5 7 3 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('2 1 24 1 -1 4 5 5 5 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('2 1 24 1 3 -1 4 5 5 5 3 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('2 1 24 1 22 -1 4 5 5 5 7 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('2 1 24 1 22 3 -1 4 5 5 5 7 3 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('2 1 15 -1 4 5 5 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('2 1 15 3 -1 4 5 5 3 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('2 1 15 22 -1 4 5 5 7 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('2 1 15 22 3 -1 4 5 5 7 3 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('2 1 22 1 -1 4 5 5 5 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('2 1 22 1 3 -1 4 5 5 5 3 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('2 1 22 1 22 -1 4 5 5 5 7 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('2 1 22 1 22 3 -1 4 5 5 5 7 3 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('2 1 25 -1 4 5 5 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('2 1 25 3 -1 4 5 5 3 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('2 1 25 22 -1 4 5 5 7 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('2 1 25 22 3 -1 4 5 5 7 3 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('2 1 0 -1 4 5 5 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('2 1 0 3 -1 4 5 5 3 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('2 1 0 22 -1 4 5 5 7 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('2 1 0 22 3 -1 4 5 5 7 3 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('2 1 3 -1 4 5 5 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('2 1 3 3 -1 4 5 5 3 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('2 1 3 22 -1 4 5 5 7 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('2 1 3 22 3 -1 4 5 5 7 3 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('2 1 18 -1 4 5 5 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('2 1 18 3 -1 4 5 5 3 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('2 1 18 22 -1 4 5 5 7 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('2 1 18 22 3 -1 4 5 5 7 3 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('2 1 18 18 1 -1 4 5 5 5 5 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('2 1 18 18 1 3 -1 4 5 5 5 5 3 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('2 1 18 18 1 22 -1 4 5 5 5 5 7 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('2 1 18 18 1 22 3 -1 4 5 5 5 5 7 3 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('2 1 18 1 -1 4 5 5 5 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('2 1 18 1 3 -1 4 5 5 5 3 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('2 1 18 1 22 -1 4 5 5 5 7 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('2 1 18 1 22 3 -1 4 5 5 5 7 3 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('2 1 2 0 -1 4 5 5 5 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('2 1 2 0 3 -1 4 5 5 5 3 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('2 1 2 0 22 -1 4 5 5 5 7 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('2 1 2 0 22 3 -1 4 5 5 5 7 3 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('2 1 2 1 -1 4 5 5 5 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('2 1 2 1 3 -1 4 5 5 5 3 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('2 1 2 1 22 -1 4 5 5 5 7 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('2 1 2 1 22 3 -1 4 5 5 5 7 3 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('2 16 -1 4 5 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('2 16 3 -1 4 5 3 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('2 16 22 -1 4 5 7 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('2 16 22 3 -1 4 5 7 3 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('22 1 -1 2 5 -1 2 7');
INSERT INTO us_rules (rule) VALUES ('22 1 3 -1 2 5 3 -1 2 7');
INSERT INTO us_rules (rule) VALUES ('22 1 22 -1 2 5 7 -1 2 7');
INSERT INTO us_rules (rule) VALUES ('22 1 22 3 -1 2 5 7 3 -1 2 7');
INSERT INTO us_rules (rule) VALUES ('22 1 2 -1 2 5 6 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 1 2 3 -1 2 5 6 3 -1 2 13');
INSERT INTO us_rules (rule) VALUES ('22 1 2 22 -1 2 5 6 7 -1 2 13');
INSERT INTO us_rules (rule) VALUES ('22 1 2 22 3 -1 2 5 6 7 3 -1 2 13');
INSERT INTO us_rules (rule) VALUES ('22 18 -1 2 5 -1 2 2');
INSERT INTO us_rules (rule) VALUES ('22 18 3 -1 2 5 3 -1 2 2');
INSERT INTO us_rules (rule) VALUES ('22 18 22 -1 2 5 7 -1 2 2');
INSERT INTO us_rules (rule) VALUES ('22 18 22 3 -1 2 5 7 3 -1 2 2');
INSERT INTO us_rules (rule) VALUES ('22 18 2 -1 2 5 6 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('22 18 2 3 -1 2 5 6 3 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('22 18 2 22 -1 2 5 6 7 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('22 18 2 22 3 -1 2 5 6 7 3 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('22 2 -1 2 5 -1 2 2');
INSERT INTO us_rules (rule) VALUES ('22 2 3 -1 2 5 3 -1 2 2');
INSERT INTO us_rules (rule) VALUES ('22 2 22 -1 2 5 7 -1 2 2');
INSERT INTO us_rules (rule) VALUES ('22 2 22 3 -1 2 5 7 3 -1 2 2');
INSERT INTO us_rules (rule) VALUES ('22 2 2 -1 2 5 6 -1 2 10');
INSERT INTO us_rules (rule) VALUES ('22 2 2 3 -1 2 5 6 3 -1 2 10');
INSERT INTO us_rules (rule) VALUES ('22 2 2 22 -1 2 5 6 7 -1 2 10');
INSERT INTO us_rules (rule) VALUES ('22 2 2 22 3 -1 2 5 6 7 3 -1 2 10');
INSERT INTO us_rules (rule) VALUES ('22 22 -1 2 5 -1 2 7');
INSERT INTO us_rules (rule) VALUES ('22 22 3 -1 2 5 3 -1 2 7');
INSERT INTO us_rules (rule) VALUES ('22 22 22 -1 2 5 7 -1 2 7');
INSERT INTO us_rules (rule) VALUES ('22 22 22 3 -1 2 5 7 3 -1 2 7');
INSERT INTO us_rules (rule) VALUES ('22 22 2 -1 2 5 6 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('22 22 2 3 -1 2 5 6 3 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('22 22 2 22 -1 2 5 6 7 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('22 22 2 22 3 -1 2 5 6 7 3 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('22 22 1 -1 2 5 5 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('22 22 1 3 -1 2 5 5 3 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('22 22 1 22 -1 2 5 5 7 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('22 22 1 22 3 -1 2 5 5 7 3 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('22 22 1 2 -1 2 5 5 6 -1 2 8');
INSERT INTO us_rules (rule) VALUES ('22 22 1 2 3 -1 2 5 5 6 3 -1 2 8');
INSERT INTO us_rules (rule) VALUES ('22 22 1 2 22 -1 2 5 5 6 7 -1 2 8');
INSERT INTO us_rules (rule) VALUES ('22 22 1 2 22 3 -1 2 5 5 6 7 3 -1 2 8');
INSERT INTO us_rules (rule) VALUES ('22 1 22 -1 2 5 5 -1 2 5');
INSERT INTO us_rules (rule) VALUES ('22 1 22 3 -1 2 5 5 3 -1 2 4');
INSERT INTO us_rules (rule) VALUES ('22 1 22 22 -1 2 5 5 7 -1 2 5');
INSERT INTO us_rules (rule) VALUES ('22 1 22 22 3 -1 2 5 5 7 3 -1 2 4');
INSERT INTO us_rules (rule) VALUES ('22 1 22 2 -1 2 5 5 6 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 1 22 2 3 -1 2 5 5 6 3 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 1 22 2 22 -1 2 5 5 6 7 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 1 22 2 22 3 -1 2 5 5 6 7 3 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 1 2 -1 2 5 5 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('22 1 2 3 -1 2 5 5 3 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('22 1 2 22 -1 2 5 5 7 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('22 1 2 22 3 -1 2 5 5 7 3 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('22 1 2 2 -1 2 5 5 6 -1 2 5');
INSERT INTO us_rules (rule) VALUES ('22 1 2 2 3 -1 2 5 5 6 3 -1 2 5');
INSERT INTO us_rules (rule) VALUES ('22 1 2 2 22 -1 2 5 5 6 7 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 1 2 2 22 3 -1 2 5 5 6 7 3 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 2 1 -1 2 5 5 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('22 2 1 3 -1 2 5 5 3 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('22 2 1 22 -1 2 5 5 7 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('22 2 1 22 3 -1 2 5 5 7 3 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('22 2 1 2 -1 2 5 5 6 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('22 2 1 2 3 -1 2 5 5 6 3 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('22 2 1 2 22 -1 2 5 5 6 7 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('22 2 1 2 22 3 -1 2 5 5 6 7 3 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('22 15 2 -1 2 5 6 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 15 2 3 -1 2 5 6 3 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 15 2 22 -1 2 5 6 7 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 15 2 22 3 -1 2 5 6 7 3 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 16 0 2 -1 2 5 5 6 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 16 0 2 3 -1 2 5 5 6 3 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 24 2 -1 2 5 5 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('22 24 2 3 -1 2 5 5 3 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('22 24 2 22 -1 2 5 5 7 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('22 24 2 22 3 -1 2 5 5 7 3 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('22 24 2 2 -1 2 5 5 6 -1 2 5');
INSERT INTO us_rules (rule) VALUES ('22 24 2 2 3 -1 2 5 5 6 3 -1 2 5');
INSERT INTO us_rules (rule) VALUES ('22 24 2 2 22 -1 2 5 5 6 7 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 24 2 2 22 3 -1 2 5 5 6 7 3 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 0 22 -1 2 5 5 -1 2 5');
INSERT INTO us_rules (rule) VALUES ('22 0 22 3 -1 2 5 5 3 -1 2 4');
INSERT INTO us_rules (rule) VALUES ('22 0 22 22 -1 2 5 5 7 -1 2 5');
INSERT INTO us_rules (rule) VALUES ('22 0 22 22 3 -1 2 5 5 7 3 -1 2 4');
INSERT INTO us_rules (rule) VALUES ('22 0 22 2 -1 2 5 5 6 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 0 22 2 3 -1 2 5 5 6 3 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 0 22 2 22 -1 2 5 5 6 7 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 0 22 2 22 3 -1 2 5 5 6 7 3 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 2 24 -1 2 5 5 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('22 2 24 3 -1 2 5 5 3 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('22 2 24 22 -1 2 5 5 7 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('22 2 24 22 3 -1 2 5 5 7 3 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('22 2 24 2 -1 2 5 5 6 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('22 2 24 2 3 -1 2 5 5 6 3 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('22 2 24 2 22 -1 2 5 5 6 7 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('22 2 24 2 22 3 -1 2 5 5 6 7 3 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('22 2 22 -1 2 5 5 -1 2 5');
INSERT INTO us_rules (rule) VALUES ('22 2 22 3 -1 2 5 5 3 -1 2 4');
INSERT INTO us_rules (rule) VALUES ('22 2 22 22 -1 2 5 5 7 -1 2 5');
INSERT INTO us_rules (rule) VALUES ('22 2 22 22 3 -1 2 5 5 7 3 -1 2 4');
INSERT INTO us_rules (rule) VALUES ('22 2 22 2 -1 2 5 5 6 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('22 2 22 2 3 -1 2 5 5 6 3 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('22 2 22 2 22 -1 2 5 5 6 7 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('22 2 22 2 22 3 -1 2 5 5 6 7 3 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('22 2 0 -1 2 5 5 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('22 2 0 3 -1 2 5 5 3 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('22 2 0 22 -1 2 5 5 7 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('22 2 0 22 3 -1 2 5 5 7 3 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('22 2 0 2 -1 2 5 5 6 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('22 2 0 2 3 -1 2 5 5 6 3 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('22 2 0 2 22 -1 2 5 5 6 7 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('22 2 0 2 22 3 -1 2 5 5 6 7 3 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('22 2 18 -1 2 5 5 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('22 2 18 3 -1 2 5 5 3 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('22 2 18 22 -1 2 5 5 7 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('22 2 18 22 3 -1 2 5 5 7 3 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('22 2 18 2 -1 2 5 5 6 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('22 2 18 2 3 -1 2 5 5 6 3 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('22 2 18 2 22 -1 2 5 5 6 7 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('22 2 18 2 22 3 -1 2 5 5 6 7 3 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('22 2 2 -1 2 5 5 -1 2 3');
INSERT INTO us_rules (rule) VALUES ('22 2 2 3 -1 2 5 5 3 -1 2 3');
INSERT INTO us_rules (rule) VALUES ('22 2 2 22 -1 2 5 5 7 -1 2 3');
INSERT INTO us_rules (rule) VALUES ('22 2 2 22 3 -1 2 5 5 7 3 -1 2 3');
INSERT INTO us_rules (rule) VALUES ('22 2 2 2 -1 2 5 5 6 -1 2 5');
INSERT INTO us_rules (rule) VALUES ('22 2 2 2 3 -1 2 5 5 6 3 -1 2 5');
INSERT INTO us_rules (rule) VALUES ('22 2 2 2 22 -1 2 5 5 6 7 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 2 2 2 22 3 -1 2 5 5 6 7 3 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 18 2 -1 2 5 5 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('22 18 2 3 -1 2 5 5 3 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('22 18 2 22 -1 2 5 5 7 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('22 18 2 22 3 -1 2 5 5 7 3 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('22 18 2 2 -1 2 5 5 6 -1 2 5');
INSERT INTO us_rules (rule) VALUES ('22 18 2 2 3 -1 2 5 5 6 3 -1 2 5');
INSERT INTO us_rules (rule) VALUES ('22 18 2 2 22 -1 2 5 5 6 7 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 18 2 2 22 3 -1 2 5 5 6 7 3 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 1 18 2 -1 2 5 5 5 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('22 1 18 2 3 -1 2 5 5 5 3 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('22 1 18 2 22 -1 2 5 5 5 7 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('22 1 18 2 22 3 -1 2 5 5 5 7 3 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('22 1 18 2 2 -1 2 5 5 5 6 -1 2 5');
INSERT INTO us_rules (rule) VALUES ('22 1 18 2 2 3 -1 2 5 5 5 6 3 -1 2 5');
INSERT INTO us_rules (rule) VALUES ('22 1 18 2 2 22 -1 2 5 5 5 6 7 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 1 18 2 2 22 3 -1 2 5 5 5 6 7 3 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 0 -1 2 5 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('22 0 3 -1 2 5 3 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('22 0 22 -1 2 5 7 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('22 0 22 3 -1 2 5 7 3 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('22 0 2 -1 2 5 6 -1 2 10');
INSERT INTO us_rules (rule) VALUES ('22 0 2 3 -1 2 5 6 3 -1 2 10');
INSERT INTO us_rules (rule) VALUES ('22 0 2 22 -1 2 5 6 7 -1 2 10');
INSERT INTO us_rules (rule) VALUES ('22 0 2 22 3 -1 2 5 6 7 3 -1 2 10');
INSERT INTO us_rules (rule) VALUES ('22 0 18 -1 2 5 5 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('22 0 18 3 -1 2 5 5 3 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('22 0 18 22 -1 2 5 5 7 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('22 0 18 22 3 -1 2 5 5 7 3 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('22 0 18 2 -1 2 5 5 6 -1 2 10');
INSERT INTO us_rules (rule) VALUES ('22 0 18 2 3 -1 2 5 5 6 3 -1 2 10');
INSERT INTO us_rules (rule) VALUES ('22 0 18 2 22 -1 2 5 5 6 7 -1 2 10');
INSERT INTO us_rules (rule) VALUES ('22 0 18 2 22 3 -1 2 5 5 6 7 3 -1 2 10');
INSERT INTO us_rules (rule) VALUES ('22 0 1 -1 2 5 5 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('22 0 1 3 -1 2 5 5 3 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('22 0 1 22 -1 2 5 5 7 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('22 0 1 22 3 -1 2 5 5 7 3 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('22 0 1 2 -1 2 5 5 6 -1 2 10');
INSERT INTO us_rules (rule) VALUES ('22 0 1 2 3 -1 2 5 5 6 3 -1 2 10');
INSERT INTO us_rules (rule) VALUES ('22 0 1 2 22 -1 2 5 5 6 7 -1 2 10');
INSERT INTO us_rules (rule) VALUES ('22 0 1 2 22 3 -1 2 5 5 6 7 3 -1 2 10');
INSERT INTO us_rules (rule) VALUES ('22 1 2 2 -1 2 5 5 5 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('22 1 2 2 3 -1 2 5 5 5 3 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('22 1 2 2 22 -1 2 5 5 5 7 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('22 1 2 2 22 3 -1 2 5 5 5 7 3 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('22 1 2 2 2 -1 2 5 5 5 6 -1 2 5');
INSERT INTO us_rules (rule) VALUES ('22 1 2 2 2 3 -1 2 5 5 5 6 3 -1 2 5');
INSERT INTO us_rules (rule) VALUES ('22 1 2 2 2 22 -1 2 5 5 5 6 7 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 1 2 2 2 22 3 -1 2 5 5 5 6 7 3 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 22 2 -1 2 5 5 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('22 22 2 3 -1 2 5 5 3 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('22 22 2 22 -1 2 5 5 7 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('22 22 2 22 3 -1 2 5 5 7 3 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('22 22 2 2 -1 2 5 5 6 -1 2 5');
INSERT INTO us_rules (rule) VALUES ('22 22 2 2 3 -1 2 5 5 6 3 -1 2 5');
INSERT INTO us_rules (rule) VALUES ('22 22 2 2 22 -1 2 5 5 6 7 -1 2 5');
INSERT INTO us_rules (rule) VALUES ('22 22 2 2 22 3 -1 2 5 5 6 7 3 -1 2 5');
INSERT INTO us_rules (rule) VALUES ('22 14 -1 2 5 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('22 14 3 -1 2 5 3 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('22 14 22 -1 2 5 7 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('22 14 22 3 -1 2 5 7 3 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('22 14 2 -1 2 5 6 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 14 2 3 -1 2 5 6 3 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 14 2 22 -1 2 5 6 7 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 14 2 22 3 -1 2 5 6 7 3 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 15 1 -1 2 5 5 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('22 15 1 3 -1 2 5 5 3 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('22 15 1 22 -1 2 5 5 7 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('22 15 1 22 3 -1 2 5 5 7 3 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('22 15 1 2 -1 2 5 5 6 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 15 1 2 3 -1 2 5 5 6 3 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 15 1 2 22 -1 2 5 5 6 7 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 15 1 2 22 3 -1 2 5 5 6 7 3 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 24 -1 2 5 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('22 24 3 -1 2 5 3 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('22 24 22 -1 2 5 7 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('22 24 22 3 -1 2 5 7 3 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('22 24 2 -1 2 5 6 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 24 2 3 -1 2 5 6 3 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 24 2 22 -1 2 5 6 7 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 24 2 22 3 -1 2 5 6 7 3 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 24 24 -1 2 5 5 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('22 24 24 3 -1 2 5 5 3 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('22 24 24 22 -1 2 5 5 7 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('22 24 24 22 3 -1 2 5 5 7 3 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('22 24 24 2 -1 2 5 5 6 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 24 24 2 3 -1 2 5 5 6 3 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 24 24 2 22 -1 2 5 5 6 7 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 24 24 2 22 3 -1 2 5 5 6 7 3 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 24 1 -1 2 5 5 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('22 24 1 3 -1 2 5 5 3 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('22 24 1 22 -1 2 5 5 7 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('22 24 1 22 3 -1 2 5 5 7 3 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('22 24 1 2 -1 2 5 5 6 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 24 1 2 3 -1 2 5 5 6 3 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 24 1 2 22 -1 2 5 5 6 7 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 24 1 2 22 3 -1 2 5 5 6 7 3 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 25 -1 2 5 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('22 25 3 -1 2 5 3 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('22 25 22 -1 2 5 7 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('22 25 22 3 -1 2 5 7 3 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('22 25 2 -1 2 5 6 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 25 2 3 -1 2 5 6 3 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 25 2 22 -1 2 5 6 7 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 25 2 22 3 -1 2 5 6 7 3 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 23 -1 2 5 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('22 23 3 -1 2 5 3 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('22 23 22 -1 2 5 7 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('22 23 22 3 -1 2 5 7 3 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('22 23 2 -1 2 5 6 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 23 2 3 -1 2 5 6 3 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 23 2 22 -1 2 5 6 7 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 23 2 22 3 -1 2 5 6 7 3 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 0 13 0 -1 2 5 5 5 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('22 0 13 0 3 -1 2 5 5 5 3 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('22 0 13 0 22 -1 2 5 5 5 7 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('22 0 13 0 22 3 -1 2 5 5 5 7 3 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('22 0 13 0 2 -1 2 5 5 5 6 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 0 13 0 2 3 -1 2 5 5 5 6 3 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 0 13 0 2 22 -1 2 5 5 5 6 7 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 0 13 0 2 22 3 -1 2 5 5 5 6 7 3 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 0 25 -1 2 5 5 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('22 0 25 3 -1 2 5 5 3 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('22 0 25 22 -1 2 5 5 7 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('22 0 25 22 3 -1 2 5 5 7 3 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('22 0 25 2 -1 2 5 5 6 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 0 25 2 3 -1 2 5 5 6 3 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 0 25 2 22 -1 2 5 5 6 7 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 0 25 2 22 3 -1 2 5 5 6 7 3 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 11 -1 2 5 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('22 11 3 -1 2 5 3 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('22 11 22 -1 2 5 7 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('22 11 22 3 -1 2 5 7 3 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('22 11 2 -1 2 5 6 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 11 2 3 -1 2 5 6 3 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 11 2 22 -1 2 5 6 7 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 11 2 22 3 -1 2 5 6 7 3 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 3 0 -1 2 3 5 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('22 3 0 3 -1 2 3 5 3 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('22 3 0 22 -1 2 3 5 7 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('22 3 0 22 3 -1 2 3 5 7 3 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('22 3 0 2 -1 2 3 5 6 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 3 0 2 3 -1 2 3 5 6 3 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 3 0 2 22 -1 2 3 5 6 7 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 3 0 2 22 3 -1 2 3 5 6 7 3 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 3 1 -1 2 3 5 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('22 3 1 3 -1 2 3 5 3 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('22 3 1 22 -1 2 3 5 7 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('22 3 1 22 3 -1 2 3 5 7 3 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('22 3 1 2 -1 2 3 5 6 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 3 1 2 3 -1 2 3 5 6 3 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 3 1 2 22 -1 2 3 5 6 7 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 3 1 2 22 3 -1 2 3 5 6 7 3 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 18 13 18 -1 2 5 5 3 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('22 18 13 18 3 -1 2 5 5 3 3 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('22 18 13 18 22 -1 2 5 5 3 7 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('22 18 13 18 22 3 -1 2 5 5 3 7 3 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('22 18 13 18 2 -1 2 5 5 3 6 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 18 13 18 2 3 -1 2 5 5 3 6 3 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 18 13 18 2 22 -1 2 5 5 3 6 7 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 18 13 18 2 22 3 -1 2 5 5 3 6 7 3 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 18 0 -1 2 5 5 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('22 18 0 3 -1 2 5 5 3 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('22 18 0 22 -1 2 5 5 7 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('22 18 0 22 3 -1 2 5 5 7 3 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('22 18 0 2 -1 2 5 5 6 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 18 0 2 3 -1 2 5 5 6 3 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 18 0 2 22 -1 2 5 5 6 7 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 18 0 2 22 3 -1 2 5 5 6 7 3 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 18 18 -1 2 5 5 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('22 18 18 3 -1 2 5 5 3 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('22 18 18 22 -1 2 5 5 7 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('22 18 18 22 3 -1 2 5 5 7 3 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('22 18 18 2 -1 2 5 5 6 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 18 18 2 3 -1 2 5 5 6 3 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 18 18 2 22 -1 2 5 5 6 7 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 18 18 2 22 3 -1 2 5 5 6 7 3 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 18 18 18 -1 2 5 5 5 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('22 18 18 18 3 -1 2 5 5 5 3 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('22 18 18 18 22 -1 2 5 5 5 7 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('22 18 18 18 22 3 -1 2 5 5 5 7 3 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('22 18 18 18 2 -1 2 5 5 5 6 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 18 18 18 2 3 -1 2 5 5 5 6 3 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 18 18 18 2 22 -1 2 5 5 5 6 7 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 18 18 18 2 22 3 -1 2 5 5 5 6 7 3 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 18 18 1 -1 2 5 5 5 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('22 18 18 1 3 -1 2 5 5 5 3 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('22 18 18 1 22 -1 2 5 5 5 7 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('22 18 18 1 22 3 -1 2 5 5 5 7 3 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('22 18 18 1 2 -1 2 5 5 5 6 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 18 18 1 2 3 -1 2 5 5 5 6 3 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 18 18 1 2 22 -1 2 5 5 5 6 7 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 18 18 1 2 22 3 -1 2 5 5 5 6 7 3 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 18 1 -1 2 5 5 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('22 18 1 3 -1 2 5 5 3 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('22 18 1 22 -1 2 5 5 7 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('22 18 1 22 3 -1 2 5 5 7 3 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('22 18 1 2 -1 2 5 5 6 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 18 1 2 3 -1 2 5 5 6 3 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 18 1 2 22 -1 2 5 5 6 7 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 18 1 2 22 3 -1 2 5 5 6 7 3 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 5 -1 2 5 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('22 5 3 -1 2 5 3 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('22 5 22 -1 2 5 7 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('22 5 22 3 -1 2 5 7 3 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('22 5 2 -1 2 5 6 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 5 2 3 -1 2 5 6 3 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 5 2 22 -1 2 5 6 7 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 5 2 22 3 -1 2 5 6 7 3 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 21 -1 2 5 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('22 21 3 -1 2 5 3 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('22 21 22 -1 2 5 7 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('22 21 22 3 -1 2 5 7 3 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('22 21 2 -1 2 5 6 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 21 2 3 -1 2 5 6 3 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 21 2 22 -1 2 5 6 7 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 21 2 22 3 -1 2 5 6 7 3 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 1 13 1 -1 2 5 5 5 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('22 1 13 1 3 -1 2 5 5 5 3 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('22 1 13 1 22 -1 2 5 5 5 7 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('22 1 13 1 22 3 -1 2 5 5 5 7 3 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('22 1 13 1 2 -1 2 5 5 5 6 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 1 13 1 2 3 -1 2 5 5 5 6 3 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 1 13 1 2 22 -1 2 5 5 5 6 7 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 1 13 1 2 22 3 -1 2 5 5 5 6 7 3 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 1 24 -1 2 5 5 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('22 1 24 3 -1 2 5 5 3 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('22 1 24 22 -1 2 5 5 7 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('22 1 24 22 3 -1 2 5 5 7 3 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('22 1 24 2 -1 2 5 5 6 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 1 24 2 3 -1 2 5 5 6 3 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 1 24 2 22 -1 2 5 5 6 7 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 1 24 2 22 3 -1 2 5 5 6 7 3 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 1 24 24 -1 2 5 5 5 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('22 1 24 24 3 -1 2 5 5 5 3 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('22 1 24 24 22 -1 2 5 5 5 7 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('22 1 24 24 22 3 -1 2 5 5 5 7 3 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('22 1 24 24 2 -1 2 5 5 5 6 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 1 24 24 2 3 -1 2 5 5 5 6 3 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 1 24 24 2 22 -1 2 5 5 5 6 7 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 1 24 24 2 22 3 -1 2 5 5 5 6 7 3 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 1 24 1 -1 2 5 5 5 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('22 1 24 1 3 -1 2 5 5 5 3 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('22 1 24 1 22 -1 2 5 5 5 7 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('22 1 24 1 22 3 -1 2 5 5 5 7 3 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('22 1 24 1 2 -1 2 5 5 5 6 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 1 24 1 2 3 -1 2 5 5 5 6 3 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 1 24 1 2 22 -1 2 5 5 5 6 7 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 1 24 1 2 22 3 -1 2 5 5 5 6 7 3 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 1 15 -1 2 5 5 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('22 1 15 3 -1 2 5 5 3 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('22 1 15 22 -1 2 5 5 7 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('22 1 15 22 3 -1 2 5 5 7 3 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('22 1 15 2 -1 2 5 5 6 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 1 15 2 3 -1 2 5 5 6 3 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 1 15 2 22 -1 2 5 5 6 7 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 1 15 2 22 3 -1 2 5 5 6 7 3 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 1 22 1 -1 2 5 5 5 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('22 1 22 1 3 -1 2 5 5 5 3 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('22 1 22 1 22 -1 2 5 5 5 7 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('22 1 22 1 22 3 -1 2 5 5 5 7 3 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('22 1 22 1 2 -1 2 5 5 5 6 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 1 22 1 2 3 -1 2 5 5 5 6 3 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 1 22 1 2 22 -1 2 5 5 5 6 7 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 1 22 1 2 22 3 -1 2 5 5 5 6 7 3 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 1 25 -1 2 5 5 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('22 1 25 3 -1 2 5 5 3 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('22 1 25 22 -1 2 5 5 7 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('22 1 25 22 3 -1 2 5 5 7 3 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('22 1 25 2 -1 2 5 5 6 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 1 25 2 3 -1 2 5 5 6 3 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 1 25 2 22 -1 2 5 5 6 7 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 1 25 2 22 3 -1 2 5 5 6 7 3 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 1 0 -1 2 5 5 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('22 1 0 3 -1 2 5 5 3 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('22 1 0 22 -1 2 5 5 7 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('22 1 0 22 3 -1 2 5 5 7 3 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('22 1 0 2 -1 2 5 5 6 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 1 0 2 3 -1 2 5 5 6 3 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 1 0 2 22 -1 2 5 5 6 7 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 1 0 2 22 3 -1 2 5 5 6 7 3 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 1 3 -1 2 5 5 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('22 1 3 3 -1 2 5 5 3 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('22 1 3 22 -1 2 5 5 7 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('22 1 3 22 3 -1 2 5 5 7 3 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('22 1 3 2 -1 2 5 5 6 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 1 3 2 3 -1 2 5 5 6 3 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 1 3 2 22 -1 2 5 5 6 7 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 1 3 2 22 3 -1 2 5 5 6 7 3 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 1 18 -1 2 5 5 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('22 1 18 3 -1 2 5 5 3 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('22 1 18 22 -1 2 5 5 7 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('22 1 18 22 3 -1 2 5 5 7 3 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('22 1 18 2 -1 2 5 5 6 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 1 18 2 3 -1 2 5 5 6 3 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 1 18 2 22 -1 2 5 5 6 7 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 1 18 2 22 3 -1 2 5 5 6 7 3 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 1 18 18 1 -1 2 5 5 5 5 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('22 1 18 18 1 3 -1 2 5 5 5 5 3 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('22 1 18 18 1 22 -1 2 5 5 5 5 7 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('22 1 18 18 1 22 3 -1 2 5 5 5 5 7 3 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('22 1 18 18 1 2 -1 2 5 5 5 5 6 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 1 18 18 1 2 3 -1 2 5 5 5 5 6 3 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 1 18 18 1 2 22 -1 2 5 5 5 5 6 7 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 1 18 18 1 2 22 3 -1 2 5 5 5 5 6 7 3 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 1 18 1 -1 2 5 5 5 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('22 1 18 1 3 -1 2 5 5 5 3 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('22 1 18 1 22 -1 2 5 5 5 7 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('22 1 18 1 22 3 -1 2 5 5 5 7 3 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('22 1 18 1 2 -1 2 5 5 5 6 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 1 18 1 2 3 -1 2 5 5 5 6 3 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 1 18 1 2 22 -1 2 5 5 5 6 7 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 1 18 1 2 22 3 -1 2 5 5 5 6 7 3 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 1 2 0 -1 2 5 5 5 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('22 1 2 0 3 -1 2 5 5 5 3 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('22 1 2 0 22 -1 2 5 5 5 7 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('22 1 2 0 22 3 -1 2 5 5 5 7 3 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('22 1 2 0 2 -1 2 5 5 5 6 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 1 2 0 2 3 -1 2 5 5 5 6 3 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 1 2 0 2 22 -1 2 5 5 5 6 7 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 1 2 0 2 22 3 -1 2 5 5 5 6 7 3 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 1 2 1 -1 2 5 5 5 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('22 1 2 1 3 -1 2 5 5 5 3 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('22 1 2 1 22 -1 2 5 5 5 7 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('22 1 2 1 22 3 -1 2 5 5 5 7 3 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('22 1 2 1 2 -1 2 5 5 5 6 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 1 2 1 2 3 -1 2 5 5 5 6 3 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 1 2 1 2 22 -1 2 5 5 5 6 7 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 1 2 1 2 22 3 -1 2 5 5 5 6 7 3 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 16 -1 2 5 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('22 16 3 -1 2 5 3 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('22 16 22 -1 2 5 7 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('22 16 22 3 -1 2 5 7 3 -1 2 6');
INSERT INTO us_rules (rule) VALUES ('22 16 2 -1 2 5 6 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 16 2 3 -1 2 5 6 3 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 16 2 22 -1 2 5 6 7 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 16 2 22 3 -1 2 5 6 7 3 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 2 1 -1 2 4 5 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('22 2 1 3 -1 2 4 5 3 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('22 2 1 22 -1 2 4 5 7 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('22 2 1 22 3 -1 2 4 5 7 3 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('22 2 18 -1 2 4 5 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('22 2 18 3 -1 2 4 5 3 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('22 2 18 22 -1 2 4 5 7 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('22 2 18 22 3 -1 2 4 5 7 3 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('22 2 2 -1 2 4 5 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('22 2 2 3 -1 2 4 5 3 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('22 2 2 22 -1 2 4 5 7 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('22 2 2 22 3 -1 2 4 5 7 3 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('22 2 22 -1 2 4 5 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('22 2 22 3 -1 2 4 5 3 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('22 2 22 22 -1 2 4 5 7 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('22 2 22 22 3 -1 2 4 5 7 3 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('22 2 22 1 -1 2 4 5 5 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('22 2 22 1 3 -1 2 4 5 5 3 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('22 2 22 1 22 -1 2 4 5 5 7 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('22 2 22 1 22 3 -1 2 4 5 5 7 3 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('22 2 1 22 -1 2 4 5 5 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('22 2 1 22 3 -1 2 4 5 5 3 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('22 2 1 22 22 -1 2 4 5 5 7 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('22 2 1 22 22 3 -1 2 4 5 5 7 3 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('22 2 1 2 -1 2 4 5 5 -1 2 4');
INSERT INTO us_rules (rule) VALUES ('22 2 1 2 3 -1 2 4 5 5 3 -1 2 4');
INSERT INTO us_rules (rule) VALUES ('22 2 1 2 22 -1 2 4 5 5 7 -1 2 4');
INSERT INTO us_rules (rule) VALUES ('22 2 1 2 22 3 -1 2 4 5 5 7 3 -1 2 4');
INSERT INTO us_rules (rule) VALUES ('22 2 2 1 -1 2 4 5 5 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('22 2 2 1 3 -1 2 4 5 5 3 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('22 2 2 1 22 -1 2 4 5 5 7 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('22 2 2 1 22 3 -1 2 4 5 5 7 3 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('22 2 24 2 -1 2 4 5 5 -1 2 4');
INSERT INTO us_rules (rule) VALUES ('22 2 24 2 3 -1 2 4 5 5 3 -1 2 4');
INSERT INTO us_rules (rule) VALUES ('22 2 24 2 22 -1 2 4 5 5 7 -1 2 4');
INSERT INTO us_rules (rule) VALUES ('22 2 24 2 22 3 -1 2 4 5 5 7 3 -1 2 4');
INSERT INTO us_rules (rule) VALUES ('22 2 0 22 -1 2 4 5 5 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('22 2 0 22 3 -1 2 4 5 5 3 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('22 2 0 22 22 -1 2 4 5 5 7 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('22 2 0 22 22 3 -1 2 4 5 5 7 3 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('22 2 2 24 -1 2 4 5 5 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('22 2 2 24 3 -1 2 4 5 5 3 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('22 2 2 24 22 -1 2 4 5 5 7 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('22 2 2 24 22 3 -1 2 4 5 5 7 3 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('22 2 2 22 -1 2 4 5 5 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('22 2 2 22 3 -1 2 4 5 5 3 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('22 2 2 22 22 -1 2 4 5 5 7 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('22 2 2 22 22 3 -1 2 4 5 5 7 3 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('22 2 2 0 -1 2 4 5 5 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('22 2 2 0 3 -1 2 4 5 5 3 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('22 2 2 0 22 -1 2 4 5 5 7 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('22 2 2 0 22 3 -1 2 4 5 5 7 3 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('22 2 2 18 -1 2 4 5 5 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('22 2 2 18 3 -1 2 4 5 5 3 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('22 2 2 18 22 -1 2 4 5 5 7 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('22 2 2 18 22 3 -1 2 4 5 5 7 3 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('22 2 2 2 -1 2 4 5 5 -1 2 4');
INSERT INTO us_rules (rule) VALUES ('22 2 2 2 3 -1 2 4 5 5 3 -1 2 4');
INSERT INTO us_rules (rule) VALUES ('22 2 2 2 22 -1 2 4 5 5 7 -1 2 4');
INSERT INTO us_rules (rule) VALUES ('22 2 2 2 22 3 -1 2 4 5 5 7 3 -1 2 4');
INSERT INTO us_rules (rule) VALUES ('22 2 18 2 -1 2 4 5 5 -1 2 4');
INSERT INTO us_rules (rule) VALUES ('22 2 18 2 3 -1 2 4 5 5 3 -1 2 4');
INSERT INTO us_rules (rule) VALUES ('22 2 18 2 22 -1 2 4 5 5 7 -1 2 4');
INSERT INTO us_rules (rule) VALUES ('22 2 18 2 22 3 -1 2 4 5 5 7 3 -1 2 4');
INSERT INTO us_rules (rule) VALUES ('22 2 1 18 2 -1 2 4 5 5 5 -1 2 4');
INSERT INTO us_rules (rule) VALUES ('22 2 1 18 2 3 -1 2 4 5 5 5 3 -1 2 4');
INSERT INTO us_rules (rule) VALUES ('22 2 1 18 2 22 -1 2 4 5 5 5 7 -1 2 4');
INSERT INTO us_rules (rule) VALUES ('22 2 1 18 2 22 3 -1 2 4 5 5 5 7 3 -1 2 4');
INSERT INTO us_rules (rule) VALUES ('22 2 0 -1 2 4 5 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('22 2 0 3 -1 2 4 5 3 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('22 2 0 22 -1 2 4 5 7 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('22 2 0 22 3 -1 2 4 5 7 3 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('22 2 0 18 -1 2 4 5 5 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('22 2 0 18 3 -1 2 4 5 5 3 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('22 2 0 18 22 -1 2 4 5 5 7 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('22 2 0 18 22 3 -1 2 4 5 5 7 3 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('22 2 0 1 -1 2 4 5 5 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('22 2 0 1 3 -1 2 4 5 5 3 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('22 2 0 1 22 -1 2 4 5 5 7 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('22 2 0 1 22 3 -1 2 4 5 5 7 3 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('22 2 1 2 2 -1 2 4 5 5 5 -1 2 4');
INSERT INTO us_rules (rule) VALUES ('22 2 1 2 2 3 -1 2 4 5 5 5 3 -1 2 4');
INSERT INTO us_rules (rule) VALUES ('22 2 1 2 2 22 -1 2 4 5 5 5 7 -1 2 4');
INSERT INTO us_rules (rule) VALUES ('22 2 1 2 2 22 3 -1 2 4 5 5 5 7 3 -1 2 4');
INSERT INTO us_rules (rule) VALUES ('22 2 22 2 -1 2 4 5 5 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('22 2 22 2 3 -1 2 4 5 5 3 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('22 2 22 2 22 -1 2 4 5 5 7 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('22 2 22 2 22 3 -1 2 4 5 5 7 3 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('22 2 14 -1 2 4 5 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('22 2 14 3 -1 2 4 5 3 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('22 2 14 22 -1 2 4 5 7 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('22 2 14 22 3 -1 2 4 5 7 3 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('22 2 15 1 -1 2 4 5 5 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('22 2 15 1 3 -1 2 4 5 5 3 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('22 2 15 1 22 -1 2 4 5 5 7 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('22 2 15 1 22 3 -1 2 4 5 5 7 3 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('22 2 24 -1 2 4 5 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('22 2 24 3 -1 2 4 5 3 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('22 2 24 22 -1 2 4 5 7 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('22 2 24 22 3 -1 2 4 5 7 3 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('22 2 24 24 -1 2 4 5 5 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('22 2 24 24 3 -1 2 4 5 5 3 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('22 2 24 24 22 -1 2 4 5 5 7 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('22 2 24 24 22 3 -1 2 4 5 5 7 3 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('22 2 24 1 -1 2 4 5 5 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('22 2 24 1 3 -1 2 4 5 5 3 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('22 2 24 1 22 -1 2 4 5 5 7 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('22 2 24 1 22 3 -1 2 4 5 5 7 3 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('22 2 25 -1 2 4 5 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('22 2 25 3 -1 2 4 5 3 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('22 2 25 22 -1 2 4 5 7 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('22 2 25 22 3 -1 2 4 5 7 3 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('22 2 23 -1 2 4 5 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('22 2 23 3 -1 2 4 5 3 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('22 2 23 22 -1 2 4 5 7 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('22 2 23 22 3 -1 2 4 5 7 3 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('22 2 0 13 0 -1 2 4 5 5 5 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('22 2 0 13 0 3 -1 2 4 5 5 5 3 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('22 2 0 13 0 22 -1 2 4 5 5 5 7 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('22 2 0 13 0 22 3 -1 2 4 5 5 5 7 3 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('22 2 0 25 -1 2 4 5 5 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('22 2 0 25 3 -1 2 4 5 5 3 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('22 2 0 25 22 -1 2 4 5 5 7 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('22 2 0 25 22 3 -1 2 4 5 5 7 3 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('22 2 11 -1 2 4 5 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('22 2 11 3 -1 2 4 5 3 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('22 2 11 22 -1 2 4 5 7 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('22 2 11 22 3 -1 2 4 5 7 3 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('22 2 3 0 -1 2 4 3 5 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('22 2 3 0 3 -1 2 4 3 5 3 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('22 2 3 0 22 -1 2 4 3 5 7 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('22 2 3 0 22 3 -1 2 4 3 5 7 3 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('22 2 3 1 -1 2 4 3 5 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('22 2 3 1 3 -1 2 4 3 5 3 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('22 2 3 1 22 -1 2 4 3 5 7 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('22 2 3 1 22 3 -1 2 4 3 5 7 3 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('22 2 18 13 18 -1 2 4 5 5 3 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('22 2 18 13 18 3 -1 2 4 5 5 3 3 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('22 2 18 13 18 22 -1 2 4 5 5 3 7 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('22 2 18 13 18 22 3 -1 2 4 5 5 3 7 3 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('22 2 18 0 -1 2 4 5 5 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('22 2 18 0 3 -1 2 4 5 5 3 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('22 2 18 0 22 -1 2 4 5 5 7 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('22 2 18 0 22 3 -1 2 4 5 5 7 3 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('22 2 18 18 -1 2 4 5 5 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('22 2 18 18 3 -1 2 4 5 5 3 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('22 2 18 18 22 -1 2 4 5 5 7 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('22 2 18 18 22 3 -1 2 4 5 5 7 3 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('22 2 18 18 18 -1 2 4 5 5 5 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('22 2 18 18 18 3 -1 2 4 5 5 5 3 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('22 2 18 18 18 22 -1 2 4 5 5 5 7 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('22 2 18 18 18 22 3 -1 2 4 5 5 5 7 3 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('22 2 18 18 1 -1 2 4 5 5 5 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('22 2 18 18 1 3 -1 2 4 5 5 5 3 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('22 2 18 18 1 22 -1 2 4 5 5 5 7 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('22 2 18 18 1 22 3 -1 2 4 5 5 5 7 3 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('22 2 18 1 -1 2 4 5 5 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('22 2 18 1 3 -1 2 4 5 5 3 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('22 2 18 1 22 -1 2 4 5 5 7 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('22 2 18 1 22 3 -1 2 4 5 5 7 3 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('22 2 5 -1 2 4 5 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('22 2 5 3 -1 2 4 5 3 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('22 2 5 22 -1 2 4 5 7 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('22 2 5 22 3 -1 2 4 5 7 3 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('22 2 21 -1 2 4 5 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('22 2 21 3 -1 2 4 5 3 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('22 2 21 22 -1 2 4 5 7 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('22 2 21 22 3 -1 2 4 5 7 3 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('22 2 1 13 1 -1 2 4 5 5 5 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('22 2 1 13 1 3 -1 2 4 5 5 5 3 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('22 2 1 13 1 22 -1 2 4 5 5 5 7 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('22 2 1 13 1 22 3 -1 2 4 5 5 5 7 3 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('22 2 1 24 -1 2 4 5 5 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('22 2 1 24 3 -1 2 4 5 5 3 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('22 2 1 24 22 -1 2 4 5 5 7 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('22 2 1 24 22 3 -1 2 4 5 5 7 3 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('22 2 1 24 24 -1 2 4 5 5 5 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('22 2 1 24 24 3 -1 2 4 5 5 5 3 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('22 2 1 24 24 22 -1 2 4 5 5 5 7 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('22 2 1 24 24 22 3 -1 2 4 5 5 5 7 3 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('22 2 1 24 1 -1 2 4 5 5 5 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('22 2 1 24 1 3 -1 2 4 5 5 5 3 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('22 2 1 24 1 22 -1 2 4 5 5 5 7 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('22 2 1 24 1 22 3 -1 2 4 5 5 5 7 3 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('22 2 1 15 -1 2 4 5 5 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('22 2 1 15 3 -1 2 4 5 5 3 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('22 2 1 15 22 -1 2 4 5 5 7 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('22 2 1 15 22 3 -1 2 4 5 5 7 3 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('22 2 1 22 1 -1 2 4 5 5 5 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('22 2 1 22 1 3 -1 2 4 5 5 5 3 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('22 2 1 22 1 22 -1 2 4 5 5 5 7 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('22 2 1 22 1 22 3 -1 2 4 5 5 5 7 3 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('22 2 1 25 -1 2 4 5 5 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('22 2 1 25 3 -1 2 4 5 5 3 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('22 2 1 25 22 -1 2 4 5 5 7 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('22 2 1 25 22 3 -1 2 4 5 5 7 3 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('22 2 1 0 -1 2 4 5 5 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('22 2 1 0 3 -1 2 4 5 5 3 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('22 2 1 0 22 -1 2 4 5 5 7 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('22 2 1 0 22 3 -1 2 4 5 5 7 3 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('22 2 1 3 -1 2 4 5 5 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('22 2 1 3 3 -1 2 4 5 5 3 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('22 2 1 3 22 -1 2 4 5 5 7 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('22 2 1 3 22 3 -1 2 4 5 5 7 3 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('22 2 1 18 -1 2 4 5 5 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('22 2 1 18 3 -1 2 4 5 5 3 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('22 2 1 18 22 -1 2 4 5 5 7 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('22 2 1 18 22 3 -1 2 4 5 5 7 3 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('22 2 1 18 18 1 -1 2 4 5 5 5 5 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('22 2 1 18 18 1 3 -1 2 4 5 5 5 5 3 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('22 2 1 18 18 1 22 -1 2 4 5 5 5 5 7 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('22 2 1 18 18 1 22 3 -1 2 4 5 5 5 5 7 3 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('22 2 1 18 1 -1 2 4 5 5 5 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('22 2 1 18 1 3 -1 2 4 5 5 5 3 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('22 2 1 18 1 22 -1 2 4 5 5 5 7 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('22 2 1 18 1 22 3 -1 2 4 5 5 5 7 3 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('22 2 1 2 0 -1 2 4 5 5 5 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('22 2 1 2 0 3 -1 2 4 5 5 5 3 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('22 2 1 2 0 22 -1 2 4 5 5 5 7 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('22 2 1 2 0 22 3 -1 2 4 5 5 5 7 3 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('22 2 1 2 1 -1 2 4 5 5 5 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('22 2 1 2 1 3 -1 2 4 5 5 5 3 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('22 2 1 2 1 22 -1 2 4 5 5 5 7 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('22 2 1 2 1 22 3 -1 2 4 5 5 5 7 3 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('22 2 16 -1 2 4 5 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('22 2 16 3 -1 2 4 5 3 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('22 2 16 22 -1 2 4 5 7 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('22 2 16 22 3 -1 2 4 5 7 3 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('6 0 -1 4 5 -1 2 16');
INSERT INTO us_rules (rule) VALUES ('6 0 22 -1 4 5 7 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('6 21 -1 4 5 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('6 21 22 -1 4 5 7 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('6 21 0 -1 4 5 5 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('6 21 0 22 -1 4 5 5 7 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('6 23 -1 4 5 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('6 23 22 -1 4 5 7 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('6 0 18 -1 4 5 5 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('6 0 18 22 -1 4 5 5 7 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('6 0 0 -1 4 5 5 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('6 0 0 22 -1 4 5 5 7 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('6 18 -1 4 5 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('6 18 22 -1 4 5 7 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('6 18 0 -1 4 5 5 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('6 18 0 22 -1 4 5 5 7 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('6 18 18 -1 4 5 5 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('6 18 18 22 -1 4 5 5 7 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('6 6 0 -1 3 4 5 -1 2 16');
INSERT INTO us_rules (rule) VALUES ('6 6 0 22 -1 3 4 5 7 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('6 6 21 -1 3 4 5 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('6 6 21 22 -1 3 4 5 7 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('6 6 21 0 -1 3 4 5 5 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('6 6 21 0 22 -1 3 4 5 5 7 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('6 6 23 -1 3 4 5 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('6 6 23 22 -1 3 4 5 7 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('6 6 0 18 -1 3 4 5 5 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('6 6 0 18 22 -1 3 4 5 5 7 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('6 6 0 0 -1 3 4 5 5 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('6 6 0 0 22 -1 3 4 5 5 7 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('6 6 18 -1 3 4 5 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('6 6 18 22 -1 3 4 5 7 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('6 6 18 0 -1 3 4 5 5 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('6 6 18 0 22 -1 3 4 5 5 7 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('6 6 18 18 -1 3 4 5 5 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('6 6 18 18 22 -1 3 4 5 5 7 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('3 6 0 -1 3 4 5 -1 2 16');
INSERT INTO us_rules (rule) VALUES ('3 6 0 22 -1 3 4 5 7 -1 2 16');
INSERT INTO us_rules (rule) VALUES ('3 6 21 -1 3 4 5 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('3 6 21 22 -1 3 4 5 7 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('3 6 21 0 -1 3 4 5 5 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('3 6 21 0 22 -1 3 4 5 5 7 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('3 6 23 -1 3 4 5 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('3 6 23 22 -1 3 4 5 7 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('3 6 0 18 -1 3 4 5 5 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('3 6 0 18 22 -1 3 4 5 5 7 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('3 6 0 0 -1 3 4 5 5 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('3 6 0 0 22 -1 3 4 5 5 7 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('3 6 18 -1 3 4 5 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('3 6 18 22 -1 3 4 5 7 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('3 6 18 0 -1 3 4 5 5 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('3 6 18 0 22 -1 3 4 5 5 7 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('3 6 18 18 -1 3 4 5 5 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('3 6 18 18 22 -1 3 4 5 5 7 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('3 6 6 0 -1 3 3 4 5 -1 2 16');
INSERT INTO us_rules (rule) VALUES ('3 6 6 0 22 -1 3 3 4 5 7 -1 2 16');
INSERT INTO us_rules (rule) VALUES ('3 6 6 21 -1 3 3 4 5 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('3 6 6 21 22 -1 3 3 4 5 7 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('3 6 6 21 0 -1 3 3 4 5 5 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('3 6 6 21 0 22 -1 3 3 4 5 5 7 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('3 6 6 23 -1 3 3 4 5 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('3 6 6 23 22 -1 3 3 4 5 7 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('3 6 6 0 18 -1 3 3 4 5 5 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('3 6 6 0 18 22 -1 3 3 4 5 5 7 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('3 6 6 0 0 -1 3 3 4 5 5 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('3 6 6 0 0 22 -1 3 3 4 5 5 7 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('3 6 6 18 -1 3 3 4 5 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('3 6 6 18 22 -1 3 3 4 5 7 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('3 6 6 18 0 -1 3 3 4 5 5 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('3 6 6 18 0 22 -1 3 3 4 5 5 7 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('3 6 6 18 18 -1 3 3 4 5 5 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('3 6 6 18 18 22 -1 3 3 4 5 5 7 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('11 6 0 -1 3 4 5 -1 2 16');
INSERT INTO us_rules (rule) VALUES ('11 6 0 22 -1 3 4 5 7 -1 2 16');
INSERT INTO us_rules (rule) VALUES ('11 6 21 -1 3 4 5 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('11 6 21 22 -1 3 4 5 7 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('11 6 21 0 -1 3 4 5 5 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('11 6 21 0 22 -1 3 4 5 5 7 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('11 6 23 -1 3 4 5 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('11 6 23 22 -1 3 4 5 7 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('11 6 0 18 -1 3 4 5 5 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('11 6 0 18 22 -1 3 4 5 5 7 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('11 6 0 0 -1 3 4 5 5 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('11 6 0 0 22 -1 3 4 5 5 7 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('11 6 18 -1 3 4 5 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('11 6 18 22 -1 3 4 5 7 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('11 6 18 0 -1 3 4 5 5 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('11 6 18 0 22 -1 3 4 5 5 7 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('11 6 18 18 -1 3 4 5 5 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('11 6 18 18 22 -1 3 4 5 5 7 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('11 6 6 0 -1 3 3 4 5 -1 2 16');
INSERT INTO us_rules (rule) VALUES ('11 6 6 0 22 -1 3 3 4 5 7 -1 2 16');
INSERT INTO us_rules (rule) VALUES ('11 6 6 21 -1 3 3 4 5 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('11 6 6 21 22 -1 3 3 4 5 7 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('11 6 6 21 0 -1 3 3 4 5 5 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('11 6 6 21 0 22 -1 3 3 4 5 5 7 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('11 6 6 23 -1 3 3 4 5 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('11 6 6 23 22 -1 3 3 4 5 7 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('11 6 6 0 18 -1 3 3 4 5 5 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('11 6 6 0 18 22 -1 3 3 4 5 5 7 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('11 6 6 0 0 -1 3 3 4 5 5 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('11 6 6 0 0 22 -1 3 3 4 5 5 7 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('11 6 6 18 -1 3 3 4 5 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('11 6 6 18 22 -1 3 3 4 5 7 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('11 6 6 18 0 -1 3 3 4 5 5 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('11 6 6 18 0 22 -1 3 3 4 5 5 7 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('11 6 6 18 18 -1 3 3 4 5 5 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('11 6 6 18 18 22 -1 3 3 4 5 5 7 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('3 11 6 0 -1 3 3 4 5 -1 2 16');
INSERT INTO us_rules (rule) VALUES ('3 11 6 0 22 -1 3 3 4 5 7 -1 2 16');
INSERT INTO us_rules (rule) VALUES ('3 11 6 21 -1 3 3 4 5 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('3 11 6 21 22 -1 3 3 4 5 7 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('3 11 6 21 0 -1 3 3 4 5 5 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('3 11 6 21 0 22 -1 3 3 4 5 5 7 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('3 11 6 23 -1 3 3 4 5 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('3 11 6 23 22 -1 3 3 4 5 7 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('3 11 6 0 18 -1 3 3 4 5 5 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('3 11 6 0 18 22 -1 3 3 4 5 5 7 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('3 11 6 0 0 -1 3 3 4 5 5 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('3 11 6 0 0 22 -1 3 3 4 5 5 7 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('3 11 6 18 -1 3 3 4 5 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('3 11 6 18 22 -1 3 3 4 5 7 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('3 11 6 18 0 -1 3 3 4 5 5 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('3 11 6 18 0 22 -1 3 3 4 5 5 7 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('3 11 6 18 18 -1 3 3 4 5 5 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('3 11 6 18 18 22 -1 3 3 4 5 5 7 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('3 11 6 6 0 -1 3 3 3 4 5 -1 2 16');
INSERT INTO us_rules (rule) VALUES ('3 11 6 6 0 22 -1 3 3 3 4 5 7 -1 2 16');
INSERT INTO us_rules (rule) VALUES ('3 11 6 6 21 -1 3 3 3 4 5 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('3 11 6 6 21 22 -1 3 3 3 4 5 7 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('3 11 6 6 21 0 -1 3 3 3 4 5 5 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('3 11 6 6 21 0 22 -1 3 3 3 4 5 5 7 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('3 11 6 6 23 -1 3 3 3 4 5 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('3 11 6 6 23 22 -1 3 3 3 4 5 7 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('3 11 6 6 0 18 -1 3 3 3 4 5 5 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('3 11 6 6 0 18 22 -1 3 3 3 4 5 5 7 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('3 11 6 6 0 0 -1 3 3 3 4 5 5 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('3 11 6 6 0 0 22 -1 3 3 3 4 5 5 7 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('3 11 6 6 18 -1 3 3 3 4 5 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('3 11 6 6 18 22 -1 3 3 3 4 5 7 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('3 11 6 6 18 0 -1 3 3 3 4 5 5 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('3 11 6 6 18 0 22 -1 3 3 3 4 5 5 7 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('3 11 6 6 18 18 -1 3 3 3 4 5 5 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('3 11 6 6 18 18 22 -1 3 3 3 4 5 5 7 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 6 0 -1 2 4 5 -1 2 16');
INSERT INTO us_rules (rule) VALUES ('22 6 0 22 -1 2 4 5 7 -1 2 16');
INSERT INTO us_rules (rule) VALUES ('22 6 21 -1 2 4 5 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 6 21 22 -1 2 4 5 7 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 6 21 0 -1 2 4 5 5 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 6 21 0 22 -1 2 4 5 5 7 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 6 23 -1 2 4 5 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 6 23 22 -1 2 4 5 7 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 6 0 18 -1 2 4 5 5 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 6 0 18 22 -1 2 4 5 5 7 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 6 0 0 -1 2 4 5 5 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 6 0 0 22 -1 2 4 5 5 7 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 6 18 -1 2 4 5 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 6 18 22 -1 2 4 5 7 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 6 18 0 -1 2 4 5 5 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 6 18 0 22 -1 2 4 5 5 7 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 6 18 18 -1 2 4 5 5 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 6 18 18 22 -1 2 4 5 5 7 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 6 6 0 -1 2 3 4 5 -1 2 16');
INSERT INTO us_rules (rule) VALUES ('22 6 6 0 22 -1 2 3 4 5 7 -1 2 16');
INSERT INTO us_rules (rule) VALUES ('22 6 6 21 -1 2 3 4 5 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 6 6 21 22 -1 2 3 4 5 7 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 6 6 21 0 -1 2 3 4 5 5 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 6 6 21 0 22 -1 2 3 4 5 5 7 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 6 6 23 -1 2 3 4 5 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 6 6 23 22 -1 2 3 4 5 7 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 6 6 0 18 -1 2 3 4 5 5 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 6 6 0 18 22 -1 2 3 4 5 5 7 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 6 6 0 0 -1 2 3 4 5 5 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 6 6 0 0 22 -1 2 3 4 5 5 7 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 6 6 18 -1 2 3 4 5 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 6 6 18 22 -1 2 3 4 5 7 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 6 6 18 0 -1 2 3 4 5 5 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 6 6 18 0 22 -1 2 3 4 5 5 7 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 6 6 18 18 -1 2 3 4 5 5 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 6 6 18 18 22 -1 2 3 4 5 5 7 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 3 6 0 -1 2 3 4 5 -1 2 16');
INSERT INTO us_rules (rule) VALUES ('22 3 6 0 22 -1 2 3 4 5 7 -1 2 16');
INSERT INTO us_rules (rule) VALUES ('22 3 6 21 -1 2 3 4 5 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 3 6 21 22 -1 2 3 4 5 7 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 3 6 21 0 -1 2 3 4 5 5 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 3 6 21 0 22 -1 2 3 4 5 5 7 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 3 6 23 -1 2 3 4 5 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 3 6 23 22 -1 2 3 4 5 7 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 3 6 0 18 -1 2 3 4 5 5 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 3 6 0 18 22 -1 2 3 4 5 5 7 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 3 6 0 0 -1 2 3 4 5 5 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 3 6 0 0 22 -1 2 3 4 5 5 7 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 3 6 18 -1 2 3 4 5 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 3 6 18 22 -1 2 3 4 5 7 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 3 6 18 0 -1 2 3 4 5 5 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 3 6 18 0 22 -1 2 3 4 5 5 7 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 3 6 18 18 -1 2 3 4 5 5 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 3 6 18 18 22 -1 2 3 4 5 5 7 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 3 6 6 0 -1 2 3 3 4 5 -1 2 16');
INSERT INTO us_rules (rule) VALUES ('22 3 6 6 0 22 -1 2 3 3 4 5 7 -1 2 16');
INSERT INTO us_rules (rule) VALUES ('22 3 6 6 21 -1 2 3 3 4 5 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 3 6 6 21 22 -1 2 3 3 4 5 7 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 3 6 6 21 0 -1 2 3 3 4 5 5 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 3 6 6 21 0 22 -1 2 3 3 4 5 5 7 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 3 6 6 23 -1 2 3 3 4 5 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 3 6 6 23 22 -1 2 3 3 4 5 7 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 3 6 6 0 18 -1 2 3 3 4 5 5 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 3 6 6 0 18 22 -1 2 3 3 4 5 5 7 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 3 6 6 0 0 -1 2 3 3 4 5 5 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 3 6 6 0 0 22 -1 2 3 3 4 5 5 7 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 3 6 6 18 -1 2 3 3 4 5 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 3 6 6 18 22 -1 2 3 3 4 5 7 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 3 6 6 18 0 -1 2 3 3 4 5 5 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 3 6 6 18 0 22 -1 2 3 3 4 5 5 7 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 3 6 6 18 18 -1 2 3 3 4 5 5 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 3 6 6 18 18 22 -1 2 3 3 4 5 5 7 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 11 6 0 -1 2 3 4 5 -1 2 16');
INSERT INTO us_rules (rule) VALUES ('22 11 6 0 22 -1 2 3 4 5 7 -1 2 16');
INSERT INTO us_rules (rule) VALUES ('22 11 6 21 -1 2 3 4 5 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 11 6 21 22 -1 2 3 4 5 7 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 11 6 21 0 -1 2 3 4 5 5 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 11 6 21 0 22 -1 2 3 4 5 5 7 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 11 6 23 -1 2 3 4 5 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 11 6 23 22 -1 2 3 4 5 7 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 11 6 0 18 -1 2 3 4 5 5 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 11 6 0 18 22 -1 2 3 4 5 5 7 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 11 6 0 0 -1 2 3 4 5 5 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 11 6 0 0 22 -1 2 3 4 5 5 7 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 11 6 18 -1 2 3 4 5 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 11 6 18 22 -1 2 3 4 5 7 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 11 6 18 0 -1 2 3 4 5 5 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 11 6 18 0 22 -1 2 3 4 5 5 7 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 11 6 18 18 -1 2 3 4 5 5 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 11 6 18 18 22 -1 2 3 4 5 5 7 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 11 6 6 0 -1 2 3 3 4 5 -1 2 16');
INSERT INTO us_rules (rule) VALUES ('22 11 6 6 0 22 -1 2 3 3 4 5 7 -1 2 16');
INSERT INTO us_rules (rule) VALUES ('22 11 6 6 21 -1 2 3 3 4 5 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 11 6 6 21 22 -1 2 3 3 4 5 7 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 11 6 6 21 0 -1 2 3 3 4 5 5 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 11 6 6 21 0 22 -1 2 3 3 4 5 5 7 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 11 6 6 23 -1 2 3 3 4 5 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 11 6 6 23 22 -1 2 3 3 4 5 7 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 11 6 6 0 18 -1 2 3 3 4 5 5 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 11 6 6 0 18 22 -1 2 3 3 4 5 5 7 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 11 6 6 0 0 -1 2 3 3 4 5 5 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 11 6 6 0 0 22 -1 2 3 3 4 5 5 7 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 11 6 6 18 -1 2 3 3 4 5 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 11 6 6 18 22 -1 2 3 3 4 5 7 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 11 6 6 18 0 -1 2 3 3 4 5 5 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 11 6 6 18 0 22 -1 2 3 3 4 5 5 7 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 11 6 6 18 18 -1 2 3 3 4 5 5 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 11 6 6 18 18 22 -1 2 3 3 4 5 5 7 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 3 11 6 0 -1 2 3 3 4 5 -1 2 16');
INSERT INTO us_rules (rule) VALUES ('22 3 11 6 0 22 -1 2 3 3 4 5 7 -1 2 16');
INSERT INTO us_rules (rule) VALUES ('22 3 11 6 21 -1 2 3 3 4 5 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 3 11 6 21 22 -1 2 3 3 4 5 7 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 3 11 6 21 0 -1 2 3 3 4 5 5 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 3 11 6 21 0 22 -1 2 3 3 4 5 5 7 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 3 11 6 23 -1 2 3 3 4 5 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 3 11 6 23 22 -1 2 3 3 4 5 7 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 3 11 6 0 18 -1 2 3 3 4 5 5 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 3 11 6 0 18 22 -1 2 3 3 4 5 5 7 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 3 11 6 0 0 -1 2 3 3 4 5 5 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 3 11 6 0 0 22 -1 2 3 3 4 5 5 7 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 3 11 6 18 -1 2 3 3 4 5 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 3 11 6 18 22 -1 2 3 3 4 5 7 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 3 11 6 18 0 -1 2 3 3 4 5 5 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 3 11 6 18 0 22 -1 2 3 3 4 5 5 7 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 3 11 6 18 18 -1 2 3 3 4 5 5 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 3 11 6 18 18 22 -1 2 3 3 4 5 5 7 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 3 11 6 6 0 -1 2 3 3 3 4 5 -1 2 16');
INSERT INTO us_rules (rule) VALUES ('22 3 11 6 6 0 22 -1 2 3 3 3 4 5 7 -1 2 16');
INSERT INTO us_rules (rule) VALUES ('22 3 11 6 6 21 -1 2 3 3 3 4 5 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 3 11 6 6 21 22 -1 2 3 3 3 4 5 7 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 3 11 6 6 21 0 -1 2 3 3 3 4 5 5 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 3 11 6 6 21 0 22 -1 2 3 3 3 4 5 5 7 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 3 11 6 6 23 -1 2 3 3 3 4 5 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 3 11 6 6 23 22 -1 2 3 3 3 4 5 7 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 3 11 6 6 0 18 -1 2 3 3 3 4 5 5 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 3 11 6 6 0 18 22 -1 2 3 3 3 4 5 5 7 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 3 11 6 6 0 0 -1 2 3 3 3 4 5 5 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 3 11 6 6 0 0 22 -1 2 3 3 3 4 5 5 7 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 3 11 6 6 18 -1 2 3 3 3 4 5 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 3 11 6 6 18 22 -1 2 3 3 3 4 5 7 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 3 11 6 6 18 0 -1 2 3 3 3 4 5 5 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 3 11 6 6 18 0 22 -1 2 3 3 3 4 5 5 7 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 3 11 6 6 18 18 -1 2 3 3 3 4 5 5 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('22 3 11 6 6 18 18 22 -1 2 3 3 3 4 5 5 7 -1 2 12');
INSERT INTO us_rules (rule) VALUES ('0 1 -1 1 5 -1 1 7');
INSERT INTO us_rules (rule) VALUES ('0 1 22 -1 1 5 7 -1 1 7');
INSERT INTO us_rules (rule) VALUES ('0 1 2 -1 1 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 1 2 22 -1 1 5 6 7 -1 1 17');
INSERT INTO us_rules (rule) VALUES ('0 5 -1 1 5 -1 1 7');
INSERT INTO us_rules (rule) VALUES ('0 5 22 -1 1 5 7 -1 1 7');
INSERT INTO us_rules (rule) VALUES ('0 5 2 -1 1 5 6 -1 1 17');
INSERT INTO us_rules (rule) VALUES ('0 5 2 22 -1 1 5 6 7 -1 1 17');
INSERT INTO us_rules (rule) VALUES ('0 2 1 -1 1 4 5 -1 1 11');
INSERT INTO us_rules (rule) VALUES ('0 2 1 22 -1 1 4 5 7 -1 1 11');
INSERT INTO us_rules (rule) VALUES ('0 2 5 -1 1 4 5 -1 1 11');
INSERT INTO us_rules (rule) VALUES ('0 2 5 22 -1 1 4 5 7 -1 1 11');
INSERT INTO us_rules (rule) VALUES ('0 22 1 -1 1 2 5 -1 1 7');
INSERT INTO us_rules (rule) VALUES ('0 22 1 2 -1 1 2 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 22 5 -1 1 2 5 -1 1 7');
INSERT INTO us_rules (rule) VALUES ('0 22 5 2 -1 1 2 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 22 2 1 -1 1 2 4 5 -1 1 11');
INSERT INTO us_rules (rule) VALUES ('0 22 2 5 -1 1 2 4 5 -1 1 11');
INSERT INTO us_rules (rule) VALUES ('0 18 1 -1 1 1 5 -1 1 7');
INSERT INTO us_rules (rule) VALUES ('0 18 1 22 -1 1 1 5 7 -1 1 7');
INSERT INTO us_rules (rule) VALUES ('0 18 1 2 -1 1 1 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 1 2 22 -1 1 1 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 5 -1 1 1 5 -1 1 7');
INSERT INTO us_rules (rule) VALUES ('0 18 5 22 -1 1 1 5 7 -1 1 7');
INSERT INTO us_rules (rule) VALUES ('0 18 5 2 -1 1 1 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 5 2 22 -1 1 1 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 2 1 -1 1 1 4 5 -1 1 8');
INSERT INTO us_rules (rule) VALUES ('0 18 2 1 22 -1 1 1 4 5 7 -1 1 8');
INSERT INTO us_rules (rule) VALUES ('0 18 2 5 -1 1 1 4 5 -1 1 8');
INSERT INTO us_rules (rule) VALUES ('0 18 2 5 22 -1 1 1 4 5 7 -1 1 8');
INSERT INTO us_rules (rule) VALUES ('0 18 22 1 -1 1 1 2 5 -1 1 7');
INSERT INTO us_rules (rule) VALUES ('0 18 22 1 2 -1 1 1 2 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 22 5 -1 1 1 2 5 -1 1 7');
INSERT INTO us_rules (rule) VALUES ('0 18 22 5 2 -1 1 1 2 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 22 2 1 -1 1 1 2 4 5 -1 1 8');
INSERT INTO us_rules (rule) VALUES ('0 18 22 2 5 -1 1 1 2 4 5 -1 1 8');
INSERT INTO us_rules (rule) VALUES ('0 25 1 -1 1 1 5 -1 1 7');
INSERT INTO us_rules (rule) VALUES ('0 25 1 22 -1 1 1 5 7 -1 1 7');
INSERT INTO us_rules (rule) VALUES ('0 25 1 2 -1 1 1 5 6 -1 1 14');
INSERT INTO us_rules (rule) VALUES ('0 25 1 2 22 -1 1 1 5 6 7 -1 1 14');
INSERT INTO us_rules (rule) VALUES ('0 25 5 -1 1 1 5 -1 1 7');
INSERT INTO us_rules (rule) VALUES ('0 25 5 22 -1 1 1 5 7 -1 1 7');
INSERT INTO us_rules (rule) VALUES ('0 25 5 2 -1 1 1 5 6 -1 1 14');
INSERT INTO us_rules (rule) VALUES ('0 25 5 2 22 -1 1 1 5 6 7 -1 1 14');
INSERT INTO us_rules (rule) VALUES ('0 25 2 1 -1 1 1 4 5 -1 1 11');
INSERT INTO us_rules (rule) VALUES ('0 25 2 1 22 -1 1 1 4 5 7 -1 1 11');
INSERT INTO us_rules (rule) VALUES ('0 25 2 5 -1 1 1 4 5 -1 1 11');
INSERT INTO us_rules (rule) VALUES ('0 25 2 5 22 -1 1 1 4 5 7 -1 1 11');
INSERT INTO us_rules (rule) VALUES ('0 25 22 1 -1 1 1 2 5 -1 1 7');
INSERT INTO us_rules (rule) VALUES ('0 25 22 1 2 -1 1 1 2 5 6 -1 1 14');
INSERT INTO us_rules (rule) VALUES ('0 25 22 5 -1 1 1 2 5 -1 1 7');
INSERT INTO us_rules (rule) VALUES ('0 25 22 5 2 -1 1 1 2 5 6 -1 1 14');
INSERT INTO us_rules (rule) VALUES ('0 25 22 2 1 -1 1 1 2 4 5 -1 1 11');
INSERT INTO us_rules (rule) VALUES ('0 25 22 2 5 -1 1 1 2 4 5 -1 1 11');
INSERT INTO us_rules (rule) VALUES ('25 1 -1 1 5 -1 1 7');
INSERT INTO us_rules (rule) VALUES ('25 1 22 -1 1 5 7 -1 1 7');
INSERT INTO us_rules (rule) VALUES ('25 1 2 -1 1 5 6 -1 1 14');
INSERT INTO us_rules (rule) VALUES ('25 1 2 22 -1 1 5 6 7 -1 1 14');
INSERT INTO us_rules (rule) VALUES ('25 5 -1 1 5 -1 1 7');
INSERT INTO us_rules (rule) VALUES ('25 5 22 -1 1 5 7 -1 1 7');
INSERT INTO us_rules (rule) VALUES ('25 5 2 -1 1 5 6 -1 1 14');
INSERT INTO us_rules (rule) VALUES ('25 5 2 22 -1 1 5 6 7 -1 1 14');
INSERT INTO us_rules (rule) VALUES ('25 2 1 -1 1 4 5 -1 1 8');
INSERT INTO us_rules (rule) VALUES ('25 2 1 22 -1 1 4 5 7 -1 1 8');
INSERT INTO us_rules (rule) VALUES ('25 2 5 -1 1 4 5 -1 1 8');
INSERT INTO us_rules (rule) VALUES ('25 2 5 22 -1 1 4 5 7 -1 1 8');
INSERT INTO us_rules (rule) VALUES ('25 22 1 -1 1 2 5 -1 1 7');
INSERT INTO us_rules (rule) VALUES ('25 22 1 2 -1 1 2 5 6 -1 1 14');
INSERT INTO us_rules (rule) VALUES ('25 22 5 -1 1 2 5 -1 1 7');
INSERT INTO us_rules (rule) VALUES ('25 22 5 2 -1 1 2 5 6 -1 1 14');
INSERT INTO us_rules (rule) VALUES ('25 22 2 1 -1 1 2 4 5 -1 1 8');
INSERT INTO us_rules (rule) VALUES ('25 22 2 5 -1 1 2 4 5 -1 1 8');
INSERT INTO us_rules (rule) VALUES ('0 0 -1 1 5 -1 1 4');
INSERT INTO us_rules (rule) VALUES ('0 0 22 -1 1 5 7 -1 1 4');
INSERT INTO us_rules (rule) VALUES ('0 0 2 -1 1 5 6 -1 1 15');
INSERT INTO us_rules (rule) VALUES ('0 0 2 22 -1 1 5 6 7 -1 1 15');
INSERT INTO us_rules (rule) VALUES ('0 18 -1 1 5 -1 1 6');
INSERT INTO us_rules (rule) VALUES ('0 18 22 -1 1 5 7 -1 1 6');
INSERT INTO us_rules (rule) VALUES ('0 18 2 -1 1 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 2 22 -1 1 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 2 0 -1 1 4 5 -1 1 14');
INSERT INTO us_rules (rule) VALUES ('0 2 0 22 -1 1 4 5 7 -1 1 14');
INSERT INTO us_rules (rule) VALUES ('0 2 18 -1 1 4 5 -1 1 14');
INSERT INTO us_rules (rule) VALUES ('0 2 18 22 -1 1 4 5 7 -1 1 14');
INSERT INTO us_rules (rule) VALUES ('0 22 0 -1 1 2 5 -1 1 6');
INSERT INTO us_rules (rule) VALUES ('0 22 0 22 -1 1 2 5 7 -1 1 11');
INSERT INTO us_rules (rule) VALUES ('0 22 0 2 -1 1 2 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 22 0 2 22 -1 1 2 5 6 7 -1 1 11');
INSERT INTO us_rules (rule) VALUES ('0 22 18 -1 1 2 5 -1 1 6');
INSERT INTO us_rules (rule) VALUES ('0 22 18 22 -1 1 2 5 7 -1 1 11');
INSERT INTO us_rules (rule) VALUES ('0 22 18 2 -1 1 2 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 22 18 2 22 -1 1 2 5 6 7 -1 1 11');
INSERT INTO us_rules (rule) VALUES ('0 22 2 0 -1 1 2 4 5 -1 1 14');
INSERT INTO us_rules (rule) VALUES ('0 22 2 0 22 -1 1 2 4 5 7 -1 1 11');
INSERT INTO us_rules (rule) VALUES ('0 22 2 18 -1 1 2 4 5 -1 1 14');
INSERT INTO us_rules (rule) VALUES ('0 22 2 18 22 -1 1 2 4 5 7 -1 1 11');
INSERT INTO us_rules (rule) VALUES ('0 18 0 -1 1 1 5 -1 1 3');
INSERT INTO us_rules (rule) VALUES ('0 18 0 22 -1 1 1 5 7 -1 1 3');
INSERT INTO us_rules (rule) VALUES ('0 18 0 2 -1 1 1 5 6 -1 1 15');
INSERT INTO us_rules (rule) VALUES ('0 18 0 2 22 -1 1 1 5 6 7 -1 1 15');
INSERT INTO us_rules (rule) VALUES ('0 18 18 -1 1 1 5 -1 1 5');
INSERT INTO us_rules (rule) VALUES ('0 18 18 22 -1 1 1 5 7 -1 1 5');
INSERT INTO us_rules (rule) VALUES ('0 18 18 2 -1 1 1 5 6 -1 1 15');
INSERT INTO us_rules (rule) VALUES ('0 18 18 2 22 -1 1 1 5 6 7 -1 1 15');
INSERT INTO us_rules (rule) VALUES ('0 18 2 0 -1 1 1 4 5 -1 1 11');
INSERT INTO us_rules (rule) VALUES ('0 18 2 0 22 -1 1 1 4 5 7 -1 1 11');
INSERT INTO us_rules (rule) VALUES ('0 18 2 18 -1 1 1 4 5 -1 1 8');
INSERT INTO us_rules (rule) VALUES ('0 18 2 18 22 -1 1 1 4 5 7 -1 1 8');
INSERT INTO us_rules (rule) VALUES ('0 18 22 0 -1 1 1 2 5 -1 1 5');
INSERT INTO us_rules (rule) VALUES ('0 18 22 0 2 -1 1 1 2 5 6 -1 1 15');
INSERT INTO us_rules (rule) VALUES ('0 18 22 18 -1 1 1 2 5 -1 1 5');
INSERT INTO us_rules (rule) VALUES ('0 18 22 18 2 -1 1 1 2 5 6 -1 1 15');
INSERT INTO us_rules (rule) VALUES ('0 18 22 2 0 -1 1 1 2 4 5 -1 1 14');
INSERT INTO us_rules (rule) VALUES ('0 18 22 2 18 -1 1 1 2 4 5 -1 1 14');
INSERT INTO us_rules (rule) VALUES ('0 25 0 -1 1 1 5 -1 1 3');
INSERT INTO us_rules (rule) VALUES ('0 25 0 22 -1 1 1 5 7 -1 1 3');
INSERT INTO us_rules (rule) VALUES ('0 25 0 2 -1 1 1 5 6 -1 1 15');
INSERT INTO us_rules (rule) VALUES ('0 25 0 2 22 -1 1 1 5 6 7 -1 1 15');
INSERT INTO us_rules (rule) VALUES ('0 25 18 -1 1 1 5 -1 1 5');
INSERT INTO us_rules (rule) VALUES ('0 25 18 22 -1 1 1 5 7 -1 1 5');
INSERT INTO us_rules (rule) VALUES ('0 25 18 2 -1 1 1 5 6 -1 1 15');
INSERT INTO us_rules (rule) VALUES ('0 25 18 2 22 -1 1 1 5 6 7 -1 1 15');
INSERT INTO us_rules (rule) VALUES ('0 25 2 0 -1 1 1 4 5 -1 1 14');
INSERT INTO us_rules (rule) VALUES ('0 25 2 0 22 -1 1 1 4 5 7 -1 1 14');
INSERT INTO us_rules (rule) VALUES ('0 25 2 18 -1 1 1 4 5 -1 1 14');
INSERT INTO us_rules (rule) VALUES ('0 25 2 18 22 -1 1 1 4 5 7 -1 1 14');
INSERT INTO us_rules (rule) VALUES ('0 25 22 0 -1 1 1 2 5 -1 1 5');
INSERT INTO us_rules (rule) VALUES ('0 25 22 0 2 -1 1 1 2 5 6 -1 1 15');
INSERT INTO us_rules (rule) VALUES ('0 25 22 18 -1 1 1 2 5 -1 1 5');
INSERT INTO us_rules (rule) VALUES ('0 25 22 18 2 -1 1 1 2 5 6 -1 1 15');
INSERT INTO us_rules (rule) VALUES ('0 25 22 2 0 -1 1 1 2 4 5 -1 1 14');
INSERT INTO us_rules (rule) VALUES ('0 25 22 2 18 -1 1 1 2 4 5 -1 1 14');
INSERT INTO us_rules (rule) VALUES ('25 0 -1 1 5 -1 1 3');
INSERT INTO us_rules (rule) VALUES ('25 0 22 -1 1 5 7 -1 1 3');
INSERT INTO us_rules (rule) VALUES ('25 0 2 -1 1 5 6 -1 1 15');
INSERT INTO us_rules (rule) VALUES ('25 0 2 22 -1 1 5 6 7 -1 1 15');
INSERT INTO us_rules (rule) VALUES ('25 18 -1 1 5 -1 1 5');
INSERT INTO us_rules (rule) VALUES ('25 18 22 -1 1 5 7 -1 1 5');
INSERT INTO us_rules (rule) VALUES ('25 18 2 -1 1 5 6 -1 1 15');
INSERT INTO us_rules (rule) VALUES ('25 18 2 22 -1 1 5 6 7 -1 1 15');
INSERT INTO us_rules (rule) VALUES ('25 2 0 -1 1 4 5 -1 1 14');
INSERT INTO us_rules (rule) VALUES ('25 2 0 22 -1 1 4 5 7 -1 1 14');
INSERT INTO us_rules (rule) VALUES ('25 2 18 -1 1 4 5 -1 1 14');
INSERT INTO us_rules (rule) VALUES ('25 2 18 22 -1 1 4 5 7 -1 1 14');
INSERT INTO us_rules (rule) VALUES ('25 22 0 -1 1 2 5 -1 1 5');
INSERT INTO us_rules (rule) VALUES ('25 22 0 2 -1 1 2 5 6 -1 1 15');
INSERT INTO us_rules (rule) VALUES ('25 22 18 -1 1 2 5 -1 1 5');
INSERT INTO us_rules (rule) VALUES ('25 22 18 2 -1 1 2 5 6 -1 1 15');
INSERT INTO us_rules (rule) VALUES ('25 22 2 0 -1 1 2 4 5 -1 1 14');
INSERT INTO us_rules (rule) VALUES ('25 22 2 18 -1 1 2 4 5 -1 1 14');
INSERT INTO us_rules (rule) VALUES ('0 6 0 -1 1 4 5 -1 1 17');
INSERT INTO us_rules (rule) VALUES ('0 6 0 22 -1 1 4 5 7 -1 1 12');
INSERT INTO us_rules (rule) VALUES ('0 6 21 -1 1 4 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 6 21 22 -1 1 4 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 6 21 0 -1 1 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 6 21 0 22 -1 1 4 5 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 6 23 -1 1 4 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 6 23 22 -1 1 4 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 6 0 18 -1 1 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 6 0 18 22 -1 1 4 5 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 6 0 0 -1 1 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 6 0 0 22 -1 1 4 5 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 6 18 -1 1 4 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 6 18 22 -1 1 4 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 6 18 0 -1 1 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 6 18 0 22 -1 1 4 5 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 6 18 18 -1 1 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 6 18 18 22 -1 1 4 5 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 6 6 0 -1 1 3 4 5 -1 1 17');
INSERT INTO us_rules (rule) VALUES ('0 6 6 0 22 -1 1 3 4 5 7 -1 1 12');
INSERT INTO us_rules (rule) VALUES ('0 6 6 21 -1 1 3 4 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 6 6 21 22 -1 1 3 4 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 6 6 21 0 -1 1 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 6 6 21 0 22 -1 1 3 4 5 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 6 6 23 -1 1 3 4 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 6 6 23 22 -1 1 3 4 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 6 6 0 18 -1 1 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 6 6 0 18 22 -1 1 3 4 5 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 6 6 0 0 -1 1 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 6 6 0 0 22 -1 1 3 4 5 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 6 6 18 -1 1 3 4 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 6 6 18 22 -1 1 3 4 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 6 6 18 0 -1 1 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 6 6 18 0 22 -1 1 3 4 5 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 6 6 18 18 -1 1 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 6 6 18 18 22 -1 1 3 4 5 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 3 6 0 -1 1 3 4 5 -1 1 17');
INSERT INTO us_rules (rule) VALUES ('0 3 6 0 22 -1 1 3 4 5 7 -1 1 12');
INSERT INTO us_rules (rule) VALUES ('0 3 6 21 -1 1 3 4 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 3 6 21 22 -1 1 3 4 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 3 6 21 0 -1 1 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 3 6 21 0 22 -1 1 3 4 5 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 3 6 23 -1 1 3 4 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 3 6 23 22 -1 1 3 4 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 3 6 0 18 -1 1 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 3 6 0 18 22 -1 1 3 4 5 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 3 6 0 0 -1 1 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 3 6 0 0 22 -1 1 3 4 5 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 3 6 18 -1 1 3 4 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 3 6 18 22 -1 1 3 4 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 3 6 18 0 -1 1 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 3 6 18 0 22 -1 1 3 4 5 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 3 6 18 18 -1 1 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 3 6 18 18 22 -1 1 3 4 5 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 3 6 6 0 -1 1 3 3 4 5 -1 1 17');
INSERT INTO us_rules (rule) VALUES ('0 3 6 6 0 22 -1 1 3 3 4 5 7 -1 1 12');
INSERT INTO us_rules (rule) VALUES ('0 3 6 6 21 -1 1 3 3 4 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 3 6 6 21 22 -1 1 3 3 4 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 3 6 6 21 0 -1 1 3 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 3 6 6 21 0 22 -1 1 3 3 4 5 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 3 6 6 23 -1 1 3 3 4 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 3 6 6 23 22 -1 1 3 3 4 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 3 6 6 0 18 -1 1 3 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 3 6 6 0 18 22 -1 1 3 3 4 5 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 3 6 6 0 0 -1 1 3 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 3 6 6 0 0 22 -1 1 3 3 4 5 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 3 6 6 18 -1 1 3 3 4 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 3 6 6 18 22 -1 1 3 3 4 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 3 6 6 18 0 -1 1 3 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 3 6 6 18 0 22 -1 1 3 3 4 5 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 3 6 6 18 18 -1 1 3 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 3 6 6 18 18 22 -1 1 3 3 4 5 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 11 6 0 -1 1 3 4 5 -1 1 17');
INSERT INTO us_rules (rule) VALUES ('0 11 6 0 22 -1 1 3 4 5 7 -1 1 12');
INSERT INTO us_rules (rule) VALUES ('0 11 6 21 -1 1 3 4 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 11 6 21 22 -1 1 3 4 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 11 6 21 0 -1 1 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 11 6 21 0 22 -1 1 3 4 5 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 11 6 23 -1 1 3 4 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 11 6 23 22 -1 1 3 4 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 11 6 0 18 -1 1 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 11 6 0 18 22 -1 1 3 4 5 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 11 6 0 0 -1 1 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 11 6 0 0 22 -1 1 3 4 5 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 11 6 18 -1 1 3 4 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 11 6 18 22 -1 1 3 4 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 11 6 18 0 -1 1 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 11 6 18 0 22 -1 1 3 4 5 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 11 6 18 18 -1 1 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 11 6 18 18 22 -1 1 3 4 5 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 11 6 6 0 -1 1 3 3 4 5 -1 1 17');
INSERT INTO us_rules (rule) VALUES ('0 11 6 6 0 22 -1 1 3 3 4 5 7 -1 1 12');
INSERT INTO us_rules (rule) VALUES ('0 11 6 6 21 -1 1 3 3 4 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 11 6 6 21 22 -1 1 3 3 4 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 11 6 6 21 0 -1 1 3 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 11 6 6 21 0 22 -1 1 3 3 4 5 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 11 6 6 23 -1 1 3 3 4 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 11 6 6 23 22 -1 1 3 3 4 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 11 6 6 0 18 -1 1 3 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 11 6 6 0 18 22 -1 1 3 3 4 5 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 11 6 6 0 0 -1 1 3 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 11 6 6 0 0 22 -1 1 3 3 4 5 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 11 6 6 18 -1 1 3 3 4 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 11 6 6 18 22 -1 1 3 3 4 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 11 6 6 18 0 -1 1 3 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 11 6 6 18 0 22 -1 1 3 3 4 5 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 11 6 6 18 18 -1 1 3 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 11 6 6 18 18 22 -1 1 3 3 4 5 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 3 11 6 0 -1 1 3 3 4 5 -1 1 17');
INSERT INTO us_rules (rule) VALUES ('0 3 11 6 0 22 -1 1 3 3 4 5 7 -1 1 12');
INSERT INTO us_rules (rule) VALUES ('0 3 11 6 21 -1 1 3 3 4 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 3 11 6 21 22 -1 1 3 3 4 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 3 11 6 21 0 -1 1 3 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 3 11 6 21 0 22 -1 1 3 3 4 5 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 3 11 6 23 -1 1 3 3 4 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 3 11 6 23 22 -1 1 3 3 4 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 3 11 6 0 18 -1 1 3 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 3 11 6 0 18 22 -1 1 3 3 4 5 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 3 11 6 0 0 -1 1 3 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 3 11 6 0 0 22 -1 1 3 3 4 5 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 3 11 6 18 -1 1 3 3 4 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 3 11 6 18 22 -1 1 3 3 4 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 3 11 6 18 0 -1 1 3 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 3 11 6 18 0 22 -1 1 3 3 4 5 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 3 11 6 18 18 -1 1 3 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 3 11 6 18 18 22 -1 1 3 3 4 5 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 3 11 6 6 0 -1 1 3 3 3 4 5 -1 1 17');
INSERT INTO us_rules (rule) VALUES ('0 3 11 6 6 0 22 -1 1 3 3 3 4 5 7 -1 1 12');
INSERT INTO us_rules (rule) VALUES ('0 3 11 6 6 21 -1 1 3 3 3 4 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 3 11 6 6 21 22 -1 1 3 3 3 4 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 3 11 6 6 21 0 -1 1 3 3 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 3 11 6 6 21 0 22 -1 1 3 3 3 4 5 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 3 11 6 6 23 -1 1 3 3 3 4 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 3 11 6 6 23 22 -1 1 3 3 3 4 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 3 11 6 6 0 18 -1 1 3 3 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 3 11 6 6 0 18 22 -1 1 3 3 3 4 5 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 3 11 6 6 0 0 -1 1 3 3 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 3 11 6 6 0 0 22 -1 1 3 3 3 4 5 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 3 11 6 6 18 -1 1 3 3 3 4 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 3 11 6 6 18 22 -1 1 3 3 3 4 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 3 11 6 6 18 0 -1 1 3 3 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 3 11 6 6 18 0 22 -1 1 3 3 3 4 5 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 3 11 6 6 18 18 -1 1 3 3 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 3 11 6 6 18 18 22 -1 1 3 3 3 4 5 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 22 6 0 -1 1 2 4 5 -1 1 17');
INSERT INTO us_rules (rule) VALUES ('0 22 6 21 -1 1 2 4 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 22 6 21 0 -1 1 2 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 22 6 23 -1 1 2 4 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 22 6 0 18 -1 1 2 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 22 6 0 0 -1 1 2 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 22 6 18 -1 1 2 4 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 22 6 18 0 -1 1 2 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 22 6 18 18 -1 1 2 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 22 6 6 0 -1 1 2 3 4 5 -1 1 17');
INSERT INTO us_rules (rule) VALUES ('0 22 6 6 21 -1 1 2 3 4 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 22 6 6 21 0 -1 1 2 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 22 6 6 23 -1 1 2 3 4 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 22 6 6 0 18 -1 1 2 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 22 6 6 0 0 -1 1 2 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 22 6 6 18 -1 1 2 3 4 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 22 6 6 18 0 -1 1 2 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 22 6 6 18 18 -1 1 2 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 22 3 6 0 -1 1 2 3 4 5 -1 1 17');
INSERT INTO us_rules (rule) VALUES ('0 22 3 6 21 -1 1 2 3 4 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 22 3 6 21 0 -1 1 2 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 22 3 6 23 -1 1 2 3 4 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 22 3 6 0 18 -1 1 2 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 22 3 6 0 0 -1 1 2 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 22 3 6 18 -1 1 2 3 4 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 22 3 6 18 0 -1 1 2 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 22 3 6 18 18 -1 1 2 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 22 3 6 6 0 -1 1 2 3 3 4 5 -1 1 17');
INSERT INTO us_rules (rule) VALUES ('0 22 3 6 6 21 -1 1 2 3 3 4 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 22 3 6 6 21 0 -1 1 2 3 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 22 3 6 6 23 -1 1 2 3 3 4 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 22 3 6 6 0 18 -1 1 2 3 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 22 3 6 6 0 0 -1 1 2 3 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 22 3 6 6 18 -1 1 2 3 3 4 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 22 3 6 6 18 0 -1 1 2 3 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 22 3 6 6 18 18 -1 1 2 3 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 22 11 6 0 -1 1 2 3 4 5 -1 1 17');
INSERT INTO us_rules (rule) VALUES ('0 22 11 6 21 -1 1 2 3 4 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 22 11 6 21 0 -1 1 2 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 22 11 6 23 -1 1 2 3 4 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 22 11 6 0 18 -1 1 2 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 22 11 6 0 0 -1 1 2 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 22 11 6 18 -1 1 2 3 4 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 22 11 6 18 0 -1 1 2 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 22 11 6 18 18 -1 1 2 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 22 11 6 6 0 -1 1 2 3 3 4 5 -1 1 17');
INSERT INTO us_rules (rule) VALUES ('0 22 11 6 6 21 -1 1 2 3 3 4 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 22 11 6 6 21 0 -1 1 2 3 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 22 11 6 6 23 -1 1 2 3 3 4 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 22 11 6 6 0 18 -1 1 2 3 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 22 11 6 6 0 0 -1 1 2 3 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 22 11 6 6 18 -1 1 2 3 3 4 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 22 11 6 6 18 0 -1 1 2 3 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 22 11 6 6 18 18 -1 1 2 3 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 22 3 11 6 0 -1 1 2 3 3 4 5 -1 1 17');
INSERT INTO us_rules (rule) VALUES ('0 22 3 11 6 21 -1 1 2 3 3 4 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 22 3 11 6 21 0 -1 1 2 3 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 22 3 11 6 23 -1 1 2 3 3 4 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 22 3 11 6 0 18 -1 1 2 3 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 22 3 11 6 0 0 -1 1 2 3 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 22 3 11 6 18 -1 1 2 3 3 4 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 22 3 11 6 18 0 -1 1 2 3 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 22 3 11 6 18 18 -1 1 2 3 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 22 3 11 6 6 0 -1 1 2 3 3 3 4 5 -1 1 17');
INSERT INTO us_rules (rule) VALUES ('0 22 3 11 6 6 21 -1 1 2 3 3 3 4 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 22 3 11 6 6 21 0 -1 1 2 3 3 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 22 3 11 6 6 23 -1 1 2 3 3 3 4 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 22 3 11 6 6 0 18 -1 1 2 3 3 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 22 3 11 6 6 0 0 -1 1 2 3 3 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 22 3 11 6 6 18 -1 1 2 3 3 3 4 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 22 3 11 6 6 18 0 -1 1 2 3 3 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 22 3 11 6 6 18 18 -1 1 2 3 3 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 6 0 -1 1 1 4 5 -1 1 17');
INSERT INTO us_rules (rule) VALUES ('0 18 6 0 22 -1 1 1 4 5 7 -1 1 12');
INSERT INTO us_rules (rule) VALUES ('0 18 6 21 -1 1 1 4 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 6 21 22 -1 1 1 4 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 6 21 0 -1 1 1 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 6 21 0 22 -1 1 1 4 5 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 6 23 -1 1 1 4 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 6 23 22 -1 1 1 4 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 6 0 18 -1 1 1 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 6 0 18 22 -1 1 1 4 5 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 6 0 0 -1 1 1 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 6 0 0 22 -1 1 1 4 5 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 6 18 -1 1 1 4 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 6 18 22 -1 1 1 4 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 6 18 0 -1 1 1 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 6 18 0 22 -1 1 1 4 5 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 6 18 18 -1 1 1 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 6 18 18 22 -1 1 1 4 5 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 6 6 0 -1 1 1 3 4 5 -1 1 17');
INSERT INTO us_rules (rule) VALUES ('0 18 6 6 0 22 -1 1 1 3 4 5 7 -1 1 12');
INSERT INTO us_rules (rule) VALUES ('0 18 6 6 21 -1 1 1 3 4 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 6 6 21 22 -1 1 1 3 4 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 6 6 21 0 -1 1 1 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 6 6 21 0 22 -1 1 1 3 4 5 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 6 6 23 -1 1 1 3 4 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 6 6 23 22 -1 1 1 3 4 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 6 6 0 18 -1 1 1 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 6 6 0 18 22 -1 1 1 3 4 5 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 6 6 0 0 -1 1 1 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 6 6 0 0 22 -1 1 1 3 4 5 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 6 6 18 -1 1 1 3 4 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 6 6 18 22 -1 1 1 3 4 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 6 6 18 0 -1 1 1 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 6 6 18 0 22 -1 1 1 3 4 5 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 6 6 18 18 -1 1 1 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 6 6 18 18 22 -1 1 1 3 4 5 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 3 6 0 -1 1 1 3 4 5 -1 1 17');
INSERT INTO us_rules (rule) VALUES ('0 18 3 6 0 22 -1 1 1 3 4 5 7 -1 1 12');
INSERT INTO us_rules (rule) VALUES ('0 18 3 6 21 -1 1 1 3 4 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 3 6 21 22 -1 1 1 3 4 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 3 6 21 0 -1 1 1 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 3 6 21 0 22 -1 1 1 3 4 5 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 3 6 23 -1 1 1 3 4 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 3 6 23 22 -1 1 1 3 4 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 3 6 0 18 -1 1 1 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 3 6 0 18 22 -1 1 1 3 4 5 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 3 6 0 0 -1 1 1 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 3 6 0 0 22 -1 1 1 3 4 5 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 3 6 18 -1 1 1 3 4 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 3 6 18 22 -1 1 1 3 4 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 3 6 18 0 -1 1 1 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 3 6 18 0 22 -1 1 1 3 4 5 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 3 6 18 18 -1 1 1 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 3 6 18 18 22 -1 1 1 3 4 5 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 3 6 6 0 -1 1 1 3 3 4 5 -1 1 17');
INSERT INTO us_rules (rule) VALUES ('0 18 3 6 6 0 22 -1 1 1 3 3 4 5 7 -1 1 12');
INSERT INTO us_rules (rule) VALUES ('0 18 3 6 6 21 -1 1 1 3 3 4 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 3 6 6 21 22 -1 1 1 3 3 4 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 3 6 6 21 0 -1 1 1 3 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 3 6 6 21 0 22 -1 1 1 3 3 4 5 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 3 6 6 23 -1 1 1 3 3 4 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 3 6 6 23 22 -1 1 1 3 3 4 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 3 6 6 0 18 -1 1 1 3 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 3 6 6 0 18 22 -1 1 1 3 3 4 5 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 3 6 6 0 0 -1 1 1 3 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 3 6 6 0 0 22 -1 1 1 3 3 4 5 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 3 6 6 18 -1 1 1 3 3 4 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 3 6 6 18 22 -1 1 1 3 3 4 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 3 6 6 18 0 -1 1 1 3 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 3 6 6 18 0 22 -1 1 1 3 3 4 5 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 3 6 6 18 18 -1 1 1 3 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 3 6 6 18 18 22 -1 1 1 3 3 4 5 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 11 6 0 -1 1 1 3 4 5 -1 1 17');
INSERT INTO us_rules (rule) VALUES ('0 18 11 6 0 22 -1 1 1 3 4 5 7 -1 1 12');
INSERT INTO us_rules (rule) VALUES ('0 18 11 6 21 -1 1 1 3 4 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 11 6 21 22 -1 1 1 3 4 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 11 6 21 0 -1 1 1 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 11 6 21 0 22 -1 1 1 3 4 5 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 11 6 23 -1 1 1 3 4 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 11 6 23 22 -1 1 1 3 4 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 11 6 0 18 -1 1 1 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 11 6 0 18 22 -1 1 1 3 4 5 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 11 6 0 0 -1 1 1 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 11 6 0 0 22 -1 1 1 3 4 5 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 11 6 18 -1 1 1 3 4 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 11 6 18 22 -1 1 1 3 4 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 11 6 18 0 -1 1 1 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 11 6 18 0 22 -1 1 1 3 4 5 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 11 6 18 18 -1 1 1 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 11 6 18 18 22 -1 1 1 3 4 5 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 11 6 6 0 -1 1 1 3 3 4 5 -1 1 17');
INSERT INTO us_rules (rule) VALUES ('0 18 11 6 6 0 22 -1 1 1 3 3 4 5 7 -1 1 12');
INSERT INTO us_rules (rule) VALUES ('0 18 11 6 6 21 -1 1 1 3 3 4 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 11 6 6 21 22 -1 1 1 3 3 4 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 11 6 6 21 0 -1 1 1 3 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 11 6 6 21 0 22 -1 1 1 3 3 4 5 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 11 6 6 23 -1 1 1 3 3 4 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 11 6 6 23 22 -1 1 1 3 3 4 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 11 6 6 0 18 -1 1 1 3 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 11 6 6 0 18 22 -1 1 1 3 3 4 5 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 11 6 6 0 0 -1 1 1 3 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 11 6 6 0 0 22 -1 1 1 3 3 4 5 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 11 6 6 18 -1 1 1 3 3 4 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 11 6 6 18 22 -1 1 1 3 3 4 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 11 6 6 18 0 -1 1 1 3 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 11 6 6 18 0 22 -1 1 1 3 3 4 5 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 11 6 6 18 18 -1 1 1 3 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 11 6 6 18 18 22 -1 1 1 3 3 4 5 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 3 11 6 0 -1 1 1 3 3 4 5 -1 1 17');
INSERT INTO us_rules (rule) VALUES ('0 18 3 11 6 0 22 -1 1 1 3 3 4 5 7 -1 1 12');
INSERT INTO us_rules (rule) VALUES ('0 18 3 11 6 21 -1 1 1 3 3 4 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 3 11 6 21 22 -1 1 1 3 3 4 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 3 11 6 21 0 -1 1 1 3 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 3 11 6 21 0 22 -1 1 1 3 3 4 5 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 3 11 6 23 -1 1 1 3 3 4 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 3 11 6 23 22 -1 1 1 3 3 4 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 3 11 6 0 18 -1 1 1 3 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 3 11 6 0 18 22 -1 1 1 3 3 4 5 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 3 11 6 0 0 -1 1 1 3 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 3 11 6 0 0 22 -1 1 1 3 3 4 5 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 3 11 6 18 -1 1 1 3 3 4 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 3 11 6 18 22 -1 1 1 3 3 4 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 3 11 6 18 0 -1 1 1 3 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 3 11 6 18 0 22 -1 1 1 3 3 4 5 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 3 11 6 18 18 -1 1 1 3 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 3 11 6 18 18 22 -1 1 1 3 3 4 5 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 3 11 6 6 0 -1 1 1 3 3 3 4 5 -1 1 17');
INSERT INTO us_rules (rule) VALUES ('0 18 3 11 6 6 0 22 -1 1 1 3 3 3 4 5 7 -1 1 12');
INSERT INTO us_rules (rule) VALUES ('0 18 3 11 6 6 21 -1 1 1 3 3 3 4 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 3 11 6 6 21 22 -1 1 1 3 3 3 4 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 3 11 6 6 21 0 -1 1 1 3 3 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 3 11 6 6 21 0 22 -1 1 1 3 3 3 4 5 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 3 11 6 6 23 -1 1 1 3 3 3 4 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 3 11 6 6 23 22 -1 1 1 3 3 3 4 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 3 11 6 6 0 18 -1 1 1 3 3 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 3 11 6 6 0 18 22 -1 1 1 3 3 3 4 5 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 3 11 6 6 0 0 -1 1 1 3 3 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 3 11 6 6 0 0 22 -1 1 1 3 3 3 4 5 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 3 11 6 6 18 -1 1 1 3 3 3 4 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 3 11 6 6 18 22 -1 1 1 3 3 3 4 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 3 11 6 6 18 0 -1 1 1 3 3 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 3 11 6 6 18 0 22 -1 1 1 3 3 3 4 5 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 3 11 6 6 18 18 -1 1 1 3 3 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 3 11 6 6 18 18 22 -1 1 1 3 3 3 4 5 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 22 6 0 -1 1 1 2 4 5 -1 1 17');
INSERT INTO us_rules (rule) VALUES ('0 18 22 6 21 -1 1 1 2 4 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 22 6 21 0 -1 1 1 2 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 22 6 23 -1 1 1 2 4 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 22 6 0 18 -1 1 1 2 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 22 6 0 0 -1 1 1 2 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 22 6 18 -1 1 1 2 4 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 22 6 18 0 -1 1 1 2 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 22 6 18 18 -1 1 1 2 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 22 6 6 0 -1 1 1 2 3 4 5 -1 1 17');
INSERT INTO us_rules (rule) VALUES ('0 18 22 6 6 21 -1 1 1 2 3 4 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 22 6 6 21 0 -1 1 1 2 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 22 6 6 23 -1 1 1 2 3 4 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 22 6 6 0 18 -1 1 1 2 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 22 6 6 0 0 -1 1 1 2 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 22 6 6 18 -1 1 1 2 3 4 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 22 6 6 18 0 -1 1 1 2 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 22 6 6 18 18 -1 1 1 2 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 22 3 6 0 -1 1 1 2 3 4 5 -1 1 17');
INSERT INTO us_rules (rule) VALUES ('0 18 22 3 6 21 -1 1 1 2 3 4 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 22 3 6 21 0 -1 1 1 2 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 22 3 6 23 -1 1 1 2 3 4 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 22 3 6 0 18 -1 1 1 2 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 22 3 6 0 0 -1 1 1 2 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 22 3 6 18 -1 1 1 2 3 4 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 22 3 6 18 0 -1 1 1 2 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 22 3 6 18 18 -1 1 1 2 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 22 3 6 6 0 -1 1 1 2 3 3 4 5 -1 1 17');
INSERT INTO us_rules (rule) VALUES ('0 18 22 3 6 6 21 -1 1 1 2 3 3 4 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 22 3 6 6 21 0 -1 1 1 2 3 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 22 3 6 6 23 -1 1 1 2 3 3 4 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 22 3 6 6 0 18 -1 1 1 2 3 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 22 3 6 6 0 0 -1 1 1 2 3 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 22 3 6 6 18 -1 1 1 2 3 3 4 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 22 3 6 6 18 0 -1 1 1 2 3 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 22 3 6 6 18 18 -1 1 1 2 3 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 22 11 6 0 -1 1 1 2 3 4 5 -1 1 17');
INSERT INTO us_rules (rule) VALUES ('0 18 22 11 6 21 -1 1 1 2 3 4 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 22 11 6 21 0 -1 1 1 2 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 22 11 6 23 -1 1 1 2 3 4 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 22 11 6 0 18 -1 1 1 2 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 22 11 6 0 0 -1 1 1 2 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 22 11 6 18 -1 1 1 2 3 4 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 22 11 6 18 0 -1 1 1 2 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 22 11 6 18 18 -1 1 1 2 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 22 11 6 6 0 -1 1 1 2 3 3 4 5 -1 1 17');
INSERT INTO us_rules (rule) VALUES ('0 18 22 11 6 6 21 -1 1 1 2 3 3 4 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 22 11 6 6 21 0 -1 1 1 2 3 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 22 11 6 6 23 -1 1 1 2 3 3 4 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 22 11 6 6 0 18 -1 1 1 2 3 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 22 11 6 6 0 0 -1 1 1 2 3 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 22 11 6 6 18 -1 1 1 2 3 3 4 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 22 11 6 6 18 0 -1 1 1 2 3 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 22 11 6 6 18 18 -1 1 1 2 3 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 22 3 11 6 0 -1 1 1 2 3 3 4 5 -1 1 17');
INSERT INTO us_rules (rule) VALUES ('0 18 22 3 11 6 21 -1 1 1 2 3 3 4 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 22 3 11 6 21 0 -1 1 1 2 3 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 22 3 11 6 23 -1 1 1 2 3 3 4 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 22 3 11 6 0 18 -1 1 1 2 3 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 22 3 11 6 0 0 -1 1 1 2 3 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 22 3 11 6 18 -1 1 1 2 3 3 4 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 22 3 11 6 18 0 -1 1 1 2 3 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 22 3 11 6 18 18 -1 1 1 2 3 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 22 3 11 6 6 0 -1 1 1 2 3 3 3 4 5 -1 1 17');
INSERT INTO us_rules (rule) VALUES ('0 18 22 3 11 6 6 21 -1 1 1 2 3 3 3 4 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 22 3 11 6 6 21 0 -1 1 1 2 3 3 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 22 3 11 6 6 23 -1 1 1 2 3 3 3 4 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 22 3 11 6 6 0 18 -1 1 1 2 3 3 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 22 3 11 6 6 0 0 -1 1 1 2 3 3 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 22 3 11 6 6 18 -1 1 1 2 3 3 3 4 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 22 3 11 6 6 18 0 -1 1 1 2 3 3 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 22 3 11 6 6 18 18 -1 1 1 2 3 3 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 6 0 -1 1 1 4 5 -1 1 17');
INSERT INTO us_rules (rule) VALUES ('0 25 6 0 22 -1 1 1 4 5 7 -1 1 12');
INSERT INTO us_rules (rule) VALUES ('0 25 6 21 -1 1 1 4 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 6 21 22 -1 1 1 4 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 6 21 0 -1 1 1 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 6 21 0 22 -1 1 1 4 5 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 6 23 -1 1 1 4 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 6 23 22 -1 1 1 4 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 6 0 18 -1 1 1 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 6 0 18 22 -1 1 1 4 5 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 6 0 0 -1 1 1 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 6 0 0 22 -1 1 1 4 5 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 6 18 -1 1 1 4 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 6 18 22 -1 1 1 4 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 6 18 0 -1 1 1 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 6 18 0 22 -1 1 1 4 5 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 6 18 18 -1 1 1 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 6 18 18 22 -1 1 1 4 5 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 6 6 0 -1 1 1 3 4 5 -1 1 17');
INSERT INTO us_rules (rule) VALUES ('0 25 6 6 0 22 -1 1 1 3 4 5 7 -1 1 12');
INSERT INTO us_rules (rule) VALUES ('0 25 6 6 21 -1 1 1 3 4 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 6 6 21 22 -1 1 1 3 4 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 6 6 21 0 -1 1 1 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 6 6 21 0 22 -1 1 1 3 4 5 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 6 6 23 -1 1 1 3 4 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 6 6 23 22 -1 1 1 3 4 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 6 6 0 18 -1 1 1 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 6 6 0 18 22 -1 1 1 3 4 5 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 6 6 0 0 -1 1 1 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 6 6 0 0 22 -1 1 1 3 4 5 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 6 6 18 -1 1 1 3 4 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 6 6 18 22 -1 1 1 3 4 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 6 6 18 0 -1 1 1 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 6 6 18 0 22 -1 1 1 3 4 5 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 6 6 18 18 -1 1 1 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 6 6 18 18 22 -1 1 1 3 4 5 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 3 6 0 -1 1 1 3 4 5 -1 1 17');
INSERT INTO us_rules (rule) VALUES ('0 25 3 6 0 22 -1 1 1 3 4 5 7 -1 1 12');
INSERT INTO us_rules (rule) VALUES ('0 25 3 6 21 -1 1 1 3 4 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 3 6 21 22 -1 1 1 3 4 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 3 6 21 0 -1 1 1 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 3 6 21 0 22 -1 1 1 3 4 5 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 3 6 23 -1 1 1 3 4 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 3 6 23 22 -1 1 1 3 4 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 3 6 0 18 -1 1 1 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 3 6 0 18 22 -1 1 1 3 4 5 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 3 6 0 0 -1 1 1 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 3 6 0 0 22 -1 1 1 3 4 5 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 3 6 18 -1 1 1 3 4 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 3 6 18 22 -1 1 1 3 4 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 3 6 18 0 -1 1 1 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 3 6 18 0 22 -1 1 1 3 4 5 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 3 6 18 18 -1 1 1 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 3 6 18 18 22 -1 1 1 3 4 5 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 3 6 6 0 -1 1 1 3 3 4 5 -1 1 17');
INSERT INTO us_rules (rule) VALUES ('0 25 3 6 6 0 22 -1 1 1 3 3 4 5 7 -1 1 12');
INSERT INTO us_rules (rule) VALUES ('0 25 3 6 6 21 -1 1 1 3 3 4 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 3 6 6 21 22 -1 1 1 3 3 4 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 3 6 6 21 0 -1 1 1 3 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 3 6 6 21 0 22 -1 1 1 3 3 4 5 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 3 6 6 23 -1 1 1 3 3 4 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 3 6 6 23 22 -1 1 1 3 3 4 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 3 6 6 0 18 -1 1 1 3 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 3 6 6 0 18 22 -1 1 1 3 3 4 5 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 3 6 6 0 0 -1 1 1 3 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 3 6 6 0 0 22 -1 1 1 3 3 4 5 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 3 6 6 18 -1 1 1 3 3 4 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 3 6 6 18 22 -1 1 1 3 3 4 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 3 6 6 18 0 -1 1 1 3 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 3 6 6 18 0 22 -1 1 1 3 3 4 5 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 3 6 6 18 18 -1 1 1 3 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 3 6 6 18 18 22 -1 1 1 3 3 4 5 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 11 6 0 -1 1 1 3 4 5 -1 1 17');
INSERT INTO us_rules (rule) VALUES ('0 25 11 6 0 22 -1 1 1 3 4 5 7 -1 1 12');
INSERT INTO us_rules (rule) VALUES ('0 25 11 6 21 -1 1 1 3 4 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 11 6 21 22 -1 1 1 3 4 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 11 6 21 0 -1 1 1 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 11 6 21 0 22 -1 1 1 3 4 5 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 11 6 23 -1 1 1 3 4 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 11 6 23 22 -1 1 1 3 4 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 11 6 0 18 -1 1 1 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 11 6 0 18 22 -1 1 1 3 4 5 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 11 6 0 0 -1 1 1 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 11 6 0 0 22 -1 1 1 3 4 5 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 11 6 18 -1 1 1 3 4 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 11 6 18 22 -1 1 1 3 4 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 11 6 18 0 -1 1 1 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 11 6 18 0 22 -1 1 1 3 4 5 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 11 6 18 18 -1 1 1 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 11 6 18 18 22 -1 1 1 3 4 5 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 11 6 6 0 -1 1 1 3 3 4 5 -1 1 17');
INSERT INTO us_rules (rule) VALUES ('0 25 11 6 6 0 22 -1 1 1 3 3 4 5 7 -1 1 12');
INSERT INTO us_rules (rule) VALUES ('0 25 11 6 6 21 -1 1 1 3 3 4 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 11 6 6 21 22 -1 1 1 3 3 4 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 11 6 6 21 0 -1 1 1 3 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 11 6 6 21 0 22 -1 1 1 3 3 4 5 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 11 6 6 23 -1 1 1 3 3 4 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 11 6 6 23 22 -1 1 1 3 3 4 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 11 6 6 0 18 -1 1 1 3 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 11 6 6 0 18 22 -1 1 1 3 3 4 5 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 11 6 6 0 0 -1 1 1 3 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 11 6 6 0 0 22 -1 1 1 3 3 4 5 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 11 6 6 18 -1 1 1 3 3 4 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 11 6 6 18 22 -1 1 1 3 3 4 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 11 6 6 18 0 -1 1 1 3 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 11 6 6 18 0 22 -1 1 1 3 3 4 5 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 11 6 6 18 18 -1 1 1 3 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 11 6 6 18 18 22 -1 1 1 3 3 4 5 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 3 11 6 0 -1 1 1 3 3 4 5 -1 1 17');
INSERT INTO us_rules (rule) VALUES ('0 25 3 11 6 0 22 -1 1 1 3 3 4 5 7 -1 1 12');
INSERT INTO us_rules (rule) VALUES ('0 25 3 11 6 21 -1 1 1 3 3 4 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 3 11 6 21 22 -1 1 1 3 3 4 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 3 11 6 21 0 -1 1 1 3 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 3 11 6 21 0 22 -1 1 1 3 3 4 5 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 3 11 6 23 -1 1 1 3 3 4 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 3 11 6 23 22 -1 1 1 3 3 4 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 3 11 6 0 18 -1 1 1 3 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 3 11 6 0 18 22 -1 1 1 3 3 4 5 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 3 11 6 0 0 -1 1 1 3 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 3 11 6 0 0 22 -1 1 1 3 3 4 5 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 3 11 6 18 -1 1 1 3 3 4 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 3 11 6 18 22 -1 1 1 3 3 4 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 3 11 6 18 0 -1 1 1 3 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 3 11 6 18 0 22 -1 1 1 3 3 4 5 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 3 11 6 18 18 -1 1 1 3 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 3 11 6 18 18 22 -1 1 1 3 3 4 5 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 3 11 6 6 0 -1 1 1 3 3 3 4 5 -1 1 17');
INSERT INTO us_rules (rule) VALUES ('0 25 3 11 6 6 0 22 -1 1 1 3 3 3 4 5 7 -1 1 12');
INSERT INTO us_rules (rule) VALUES ('0 25 3 11 6 6 21 -1 1 1 3 3 3 4 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 3 11 6 6 21 22 -1 1 1 3 3 3 4 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 3 11 6 6 21 0 -1 1 1 3 3 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 3 11 6 6 21 0 22 -1 1 1 3 3 3 4 5 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 3 11 6 6 23 -1 1 1 3 3 3 4 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 3 11 6 6 23 22 -1 1 1 3 3 3 4 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 3 11 6 6 0 18 -1 1 1 3 3 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 3 11 6 6 0 18 22 -1 1 1 3 3 3 4 5 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 3 11 6 6 0 0 -1 1 1 3 3 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 3 11 6 6 0 0 22 -1 1 1 3 3 3 4 5 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 3 11 6 6 18 -1 1 1 3 3 3 4 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 3 11 6 6 18 22 -1 1 1 3 3 3 4 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 3 11 6 6 18 0 -1 1 1 3 3 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 3 11 6 6 18 0 22 -1 1 1 3 3 3 4 5 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 3 11 6 6 18 18 -1 1 1 3 3 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 3 11 6 6 18 18 22 -1 1 1 3 3 3 4 5 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 22 6 0 -1 1 1 2 4 5 -1 1 17');
INSERT INTO us_rules (rule) VALUES ('0 25 22 6 21 -1 1 1 2 4 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 22 6 21 0 -1 1 1 2 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 22 6 23 -1 1 1 2 4 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 22 6 0 18 -1 1 1 2 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 22 6 0 0 -1 1 1 2 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 22 6 18 -1 1 1 2 4 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 22 6 18 0 -1 1 1 2 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 22 6 18 18 -1 1 1 2 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 22 6 6 0 -1 1 1 2 3 4 5 -1 1 17');
INSERT INTO us_rules (rule) VALUES ('0 25 22 6 6 21 -1 1 1 2 3 4 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 22 6 6 21 0 -1 1 1 2 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 22 6 6 23 -1 1 1 2 3 4 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 22 6 6 0 18 -1 1 1 2 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 22 6 6 0 0 -1 1 1 2 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 22 6 6 18 -1 1 1 2 3 4 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 22 6 6 18 0 -1 1 1 2 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 22 6 6 18 18 -1 1 1 2 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 22 3 6 0 -1 1 1 2 3 4 5 -1 1 17');
INSERT INTO us_rules (rule) VALUES ('0 25 22 3 6 21 -1 1 1 2 3 4 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 22 3 6 21 0 -1 1 1 2 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 22 3 6 23 -1 1 1 2 3 4 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 22 3 6 0 18 -1 1 1 2 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 22 3 6 0 0 -1 1 1 2 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 22 3 6 18 -1 1 1 2 3 4 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 22 3 6 18 0 -1 1 1 2 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 22 3 6 18 18 -1 1 1 2 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 22 3 6 6 0 -1 1 1 2 3 3 4 5 -1 1 17');
INSERT INTO us_rules (rule) VALUES ('0 25 22 3 6 6 21 -1 1 1 2 3 3 4 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 22 3 6 6 21 0 -1 1 1 2 3 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 22 3 6 6 23 -1 1 1 2 3 3 4 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 22 3 6 6 0 18 -1 1 1 2 3 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 22 3 6 6 0 0 -1 1 1 2 3 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 22 3 6 6 18 -1 1 1 2 3 3 4 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 22 3 6 6 18 0 -1 1 1 2 3 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 22 3 6 6 18 18 -1 1 1 2 3 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 22 11 6 0 -1 1 1 2 3 4 5 -1 1 17');
INSERT INTO us_rules (rule) VALUES ('0 25 22 11 6 21 -1 1 1 2 3 4 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 22 11 6 21 0 -1 1 1 2 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 22 11 6 23 -1 1 1 2 3 4 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 22 11 6 0 18 -1 1 1 2 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 22 11 6 0 0 -1 1 1 2 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 22 11 6 18 -1 1 1 2 3 4 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 22 11 6 18 0 -1 1 1 2 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 22 11 6 18 18 -1 1 1 2 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 22 11 6 6 0 -1 1 1 2 3 3 4 5 -1 1 17');
INSERT INTO us_rules (rule) VALUES ('0 25 22 11 6 6 21 -1 1 1 2 3 3 4 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 22 11 6 6 21 0 -1 1 1 2 3 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 22 11 6 6 23 -1 1 1 2 3 3 4 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 22 11 6 6 0 18 -1 1 1 2 3 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 22 11 6 6 0 0 -1 1 1 2 3 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 22 11 6 6 18 -1 1 1 2 3 3 4 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 22 11 6 6 18 0 -1 1 1 2 3 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 22 11 6 6 18 18 -1 1 1 2 3 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 22 3 11 6 0 -1 1 1 2 3 3 4 5 -1 1 17');
INSERT INTO us_rules (rule) VALUES ('0 25 22 3 11 6 21 -1 1 1 2 3 3 4 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 22 3 11 6 21 0 -1 1 1 2 3 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 22 3 11 6 23 -1 1 1 2 3 3 4 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 22 3 11 6 0 18 -1 1 1 2 3 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 22 3 11 6 0 0 -1 1 1 2 3 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 22 3 11 6 18 -1 1 1 2 3 3 4 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 22 3 11 6 18 0 -1 1 1 2 3 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 22 3 11 6 18 18 -1 1 1 2 3 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 22 3 11 6 6 0 -1 1 1 2 3 3 3 4 5 -1 1 17');
INSERT INTO us_rules (rule) VALUES ('0 25 22 3 11 6 6 21 -1 1 1 2 3 3 3 4 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 22 3 11 6 6 21 0 -1 1 1 2 3 3 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 22 3 11 6 6 23 -1 1 1 2 3 3 3 4 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 22 3 11 6 6 0 18 -1 1 1 2 3 3 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 22 3 11 6 6 0 0 -1 1 1 2 3 3 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 22 3 11 6 6 18 -1 1 1 2 3 3 3 4 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 22 3 11 6 6 18 0 -1 1 1 2 3 3 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 22 3 11 6 6 18 18 -1 1 1 2 3 3 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 6 0 -1 1 4 5 -1 1 17');
INSERT INTO us_rules (rule) VALUES ('25 6 0 22 -1 1 4 5 7 -1 1 12');
INSERT INTO us_rules (rule) VALUES ('25 6 21 -1 1 4 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 6 21 22 -1 1 4 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 6 21 0 -1 1 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 6 21 0 22 -1 1 4 5 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 6 23 -1 1 4 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 6 23 22 -1 1 4 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 6 0 18 -1 1 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 6 0 18 22 -1 1 4 5 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 6 0 0 -1 1 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 6 0 0 22 -1 1 4 5 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 6 18 -1 1 4 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 6 18 22 -1 1 4 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 6 18 0 -1 1 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 6 18 0 22 -1 1 4 5 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 6 18 18 -1 1 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 6 18 18 22 -1 1 4 5 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 6 6 0 -1 1 3 4 5 -1 1 17');
INSERT INTO us_rules (rule) VALUES ('25 6 6 0 22 -1 1 3 4 5 7 -1 1 12');
INSERT INTO us_rules (rule) VALUES ('25 6 6 21 -1 1 3 4 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 6 6 21 22 -1 1 3 4 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 6 6 21 0 -1 1 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 6 6 21 0 22 -1 1 3 4 5 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 6 6 23 -1 1 3 4 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 6 6 23 22 -1 1 3 4 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 6 6 0 18 -1 1 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 6 6 0 18 22 -1 1 3 4 5 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 6 6 0 0 -1 1 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 6 6 0 0 22 -1 1 3 4 5 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 6 6 18 -1 1 3 4 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 6 6 18 22 -1 1 3 4 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 6 6 18 0 -1 1 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 6 6 18 0 22 -1 1 3 4 5 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 6 6 18 18 -1 1 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 6 6 18 18 22 -1 1 3 4 5 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 3 6 0 -1 1 3 4 5 -1 1 17');
INSERT INTO us_rules (rule) VALUES ('25 3 6 0 22 -1 1 3 4 5 7 -1 1 12');
INSERT INTO us_rules (rule) VALUES ('25 3 6 21 -1 1 3 4 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 3 6 21 22 -1 1 3 4 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 3 6 21 0 -1 1 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 3 6 21 0 22 -1 1 3 4 5 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 3 6 23 -1 1 3 4 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 3 6 23 22 -1 1 3 4 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 3 6 0 18 -1 1 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 3 6 0 18 22 -1 1 3 4 5 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 3 6 0 0 -1 1 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 3 6 0 0 22 -1 1 3 4 5 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 3 6 18 -1 1 3 4 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 3 6 18 22 -1 1 3 4 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 3 6 18 0 -1 1 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 3 6 18 0 22 -1 1 3 4 5 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 3 6 18 18 -1 1 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 3 6 18 18 22 -1 1 3 4 5 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 3 6 6 0 -1 1 3 3 4 5 -1 1 17');
INSERT INTO us_rules (rule) VALUES ('25 3 6 6 0 22 -1 1 3 3 4 5 7 -1 1 12');
INSERT INTO us_rules (rule) VALUES ('25 3 6 6 21 -1 1 3 3 4 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 3 6 6 21 22 -1 1 3 3 4 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 3 6 6 21 0 -1 1 3 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 3 6 6 21 0 22 -1 1 3 3 4 5 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 3 6 6 23 -1 1 3 3 4 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 3 6 6 23 22 -1 1 3 3 4 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 3 6 6 0 18 -1 1 3 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 3 6 6 0 18 22 -1 1 3 3 4 5 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 3 6 6 0 0 -1 1 3 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 3 6 6 0 0 22 -1 1 3 3 4 5 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 3 6 6 18 -1 1 3 3 4 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 3 6 6 18 22 -1 1 3 3 4 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 3 6 6 18 0 -1 1 3 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 3 6 6 18 0 22 -1 1 3 3 4 5 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 3 6 6 18 18 -1 1 3 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 3 6 6 18 18 22 -1 1 3 3 4 5 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 11 6 0 -1 1 3 4 5 -1 1 17');
INSERT INTO us_rules (rule) VALUES ('25 11 6 0 22 -1 1 3 4 5 7 -1 1 12');
INSERT INTO us_rules (rule) VALUES ('25 11 6 21 -1 1 3 4 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 11 6 21 22 -1 1 3 4 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 11 6 21 0 -1 1 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 11 6 21 0 22 -1 1 3 4 5 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 11 6 23 -1 1 3 4 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 11 6 23 22 -1 1 3 4 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 11 6 0 18 -1 1 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 11 6 0 18 22 -1 1 3 4 5 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 11 6 0 0 -1 1 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 11 6 0 0 22 -1 1 3 4 5 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 11 6 18 -1 1 3 4 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 11 6 18 22 -1 1 3 4 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 11 6 18 0 -1 1 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 11 6 18 0 22 -1 1 3 4 5 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 11 6 18 18 -1 1 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 11 6 18 18 22 -1 1 3 4 5 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 11 6 6 0 -1 1 3 3 4 5 -1 1 17');
INSERT INTO us_rules (rule) VALUES ('25 11 6 6 0 22 -1 1 3 3 4 5 7 -1 1 12');
INSERT INTO us_rules (rule) VALUES ('25 11 6 6 21 -1 1 3 3 4 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 11 6 6 21 22 -1 1 3 3 4 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 11 6 6 21 0 -1 1 3 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 11 6 6 21 0 22 -1 1 3 3 4 5 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 11 6 6 23 -1 1 3 3 4 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 11 6 6 23 22 -1 1 3 3 4 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 11 6 6 0 18 -1 1 3 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 11 6 6 0 18 22 -1 1 3 3 4 5 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 11 6 6 0 0 -1 1 3 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 11 6 6 0 0 22 -1 1 3 3 4 5 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 11 6 6 18 -1 1 3 3 4 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 11 6 6 18 22 -1 1 3 3 4 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 11 6 6 18 0 -1 1 3 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 11 6 6 18 0 22 -1 1 3 3 4 5 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 11 6 6 18 18 -1 1 3 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 11 6 6 18 18 22 -1 1 3 3 4 5 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 3 11 6 0 -1 1 3 3 4 5 -1 1 17');
INSERT INTO us_rules (rule) VALUES ('25 3 11 6 0 22 -1 1 3 3 4 5 7 -1 1 12');
INSERT INTO us_rules (rule) VALUES ('25 3 11 6 21 -1 1 3 3 4 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 3 11 6 21 22 -1 1 3 3 4 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 3 11 6 21 0 -1 1 3 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 3 11 6 21 0 22 -1 1 3 3 4 5 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 3 11 6 23 -1 1 3 3 4 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 3 11 6 23 22 -1 1 3 3 4 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 3 11 6 0 18 -1 1 3 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 3 11 6 0 18 22 -1 1 3 3 4 5 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 3 11 6 0 0 -1 1 3 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 3 11 6 0 0 22 -1 1 3 3 4 5 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 3 11 6 18 -1 1 3 3 4 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 3 11 6 18 22 -1 1 3 3 4 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 3 11 6 18 0 -1 1 3 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 3 11 6 18 0 22 -1 1 3 3 4 5 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 3 11 6 18 18 -1 1 3 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 3 11 6 18 18 22 -1 1 3 3 4 5 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 3 11 6 6 0 -1 1 3 3 3 4 5 -1 1 17');
INSERT INTO us_rules (rule) VALUES ('25 3 11 6 6 0 22 -1 1 3 3 3 4 5 7 -1 1 12');
INSERT INTO us_rules (rule) VALUES ('25 3 11 6 6 21 -1 1 3 3 3 4 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 3 11 6 6 21 22 -1 1 3 3 3 4 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 3 11 6 6 21 0 -1 1 3 3 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 3 11 6 6 21 0 22 -1 1 3 3 3 4 5 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 3 11 6 6 23 -1 1 3 3 3 4 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 3 11 6 6 23 22 -1 1 3 3 3 4 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 3 11 6 6 0 18 -1 1 3 3 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 3 11 6 6 0 18 22 -1 1 3 3 3 4 5 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 3 11 6 6 0 0 -1 1 3 3 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 3 11 6 6 0 0 22 -1 1 3 3 3 4 5 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 3 11 6 6 18 -1 1 3 3 3 4 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 3 11 6 6 18 22 -1 1 3 3 3 4 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 3 11 6 6 18 0 -1 1 3 3 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 3 11 6 6 18 0 22 -1 1 3 3 3 4 5 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 3 11 6 6 18 18 -1 1 3 3 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 3 11 6 6 18 18 22 -1 1 3 3 3 4 5 5 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 22 6 0 -1 1 2 4 5 -1 1 17');
INSERT INTO us_rules (rule) VALUES ('25 22 6 21 -1 1 2 4 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 22 6 21 0 -1 1 2 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 22 6 23 -1 1 2 4 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 22 6 0 18 -1 1 2 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 22 6 0 0 -1 1 2 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 22 6 18 -1 1 2 4 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 22 6 18 0 -1 1 2 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 22 6 18 18 -1 1 2 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 22 6 6 0 -1 1 2 3 4 5 -1 1 17');
INSERT INTO us_rules (rule) VALUES ('25 22 6 6 21 -1 1 2 3 4 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 22 6 6 21 0 -1 1 2 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 22 6 6 23 -1 1 2 3 4 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 22 6 6 0 18 -1 1 2 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 22 6 6 0 0 -1 1 2 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 22 6 6 18 -1 1 2 3 4 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 22 6 6 18 0 -1 1 2 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 22 6 6 18 18 -1 1 2 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 22 3 6 0 -1 1 2 3 4 5 -1 1 17');
INSERT INTO us_rules (rule) VALUES ('25 22 3 6 21 -1 1 2 3 4 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 22 3 6 21 0 -1 1 2 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 22 3 6 23 -1 1 2 3 4 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 22 3 6 0 18 -1 1 2 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 22 3 6 0 0 -1 1 2 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 22 3 6 18 -1 1 2 3 4 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 22 3 6 18 0 -1 1 2 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 22 3 6 18 18 -1 1 2 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 22 3 6 6 0 -1 1 2 3 3 4 5 -1 1 17');
INSERT INTO us_rules (rule) VALUES ('25 22 3 6 6 21 -1 1 2 3 3 4 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 22 3 6 6 21 0 -1 1 2 3 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 22 3 6 6 23 -1 1 2 3 3 4 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 22 3 6 6 0 18 -1 1 2 3 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 22 3 6 6 0 0 -1 1 2 3 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 22 3 6 6 18 -1 1 2 3 3 4 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 22 3 6 6 18 0 -1 1 2 3 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 22 3 6 6 18 18 -1 1 2 3 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 22 11 6 0 -1 1 2 3 4 5 -1 1 17');
INSERT INTO us_rules (rule) VALUES ('25 22 11 6 21 -1 1 2 3 4 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 22 11 6 21 0 -1 1 2 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 22 11 6 23 -1 1 2 3 4 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 22 11 6 0 18 -1 1 2 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 22 11 6 0 0 -1 1 2 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 22 11 6 18 -1 1 2 3 4 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 22 11 6 18 0 -1 1 2 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 22 11 6 18 18 -1 1 2 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 22 11 6 6 0 -1 1 2 3 3 4 5 -1 1 17');
INSERT INTO us_rules (rule) VALUES ('25 22 11 6 6 21 -1 1 2 3 3 4 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 22 11 6 6 21 0 -1 1 2 3 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 22 11 6 6 23 -1 1 2 3 3 4 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 22 11 6 6 0 18 -1 1 2 3 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 22 11 6 6 0 0 -1 1 2 3 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 22 11 6 6 18 -1 1 2 3 3 4 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 22 11 6 6 18 0 -1 1 2 3 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 22 11 6 6 18 18 -1 1 2 3 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 22 3 11 6 0 -1 1 2 3 3 4 5 -1 1 17');
INSERT INTO us_rules (rule) VALUES ('25 22 3 11 6 21 -1 1 2 3 3 4 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 22 3 11 6 21 0 -1 1 2 3 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 22 3 11 6 23 -1 1 2 3 3 4 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 22 3 11 6 0 18 -1 1 2 3 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 22 3 11 6 0 0 -1 1 2 3 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 22 3 11 6 18 -1 1 2 3 3 4 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 22 3 11 6 18 0 -1 1 2 3 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 22 3 11 6 18 18 -1 1 2 3 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 22 3 11 6 6 0 -1 1 2 3 3 3 4 5 -1 1 17');
INSERT INTO us_rules (rule) VALUES ('25 22 3 11 6 6 21 -1 1 2 3 3 3 4 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 22 3 11 6 6 21 0 -1 1 2 3 3 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 22 3 11 6 6 23 -1 1 2 3 3 3 4 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 22 3 11 6 6 0 18 -1 1 2 3 3 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 22 3 11 6 6 0 0 -1 1 2 3 3 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 22 3 11 6 6 18 -1 1 2 3 3 3 4 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 22 3 11 6 6 18 0 -1 1 2 3 3 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 22 3 11 6 6 18 18 -1 1 2 3 3 3 4 5 5 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 22 -1 1 5 -1 1 5');
INSERT INTO us_rules (rule) VALUES ('0 22 22 -1 1 5 7 -1 1 5');
INSERT INTO us_rules (rule) VALUES ('0 22 1 -1 1 5 5 -1 1 5');
INSERT INTO us_rules (rule) VALUES ('0 22 1 22 -1 1 5 5 7 -1 1 5');
INSERT INTO us_rules (rule) VALUES ('0 15 -1 1 5 -1 1 5');
INSERT INTO us_rules (rule) VALUES ('0 15 22 -1 1 5 7 -1 1 5');
INSERT INTO us_rules (rule) VALUES ('0 18 18 1 -1 1 5 5 5 -1 1 5');
INSERT INTO us_rules (rule) VALUES ('0 18 18 1 22 -1 1 5 5 5 7 -1 1 5');
INSERT INTO us_rules (rule) VALUES ('0 18 1 -1 1 5 5 -1 1 5');
INSERT INTO us_rules (rule) VALUES ('0 18 1 22 -1 1 5 5 7 -1 1 5');
INSERT INTO us_rules (rule) VALUES ('0 2 -1 1 5 -1 1 5');
INSERT INTO us_rules (rule) VALUES ('0 2 22 -1 1 5 7 -1 1 5');
INSERT INTO us_rules (rule) VALUES ('0 1 13 1 -1 1 5 5 5 -1 1 5');
INSERT INTO us_rules (rule) VALUES ('0 1 13 1 22 -1 1 5 5 5 7 -1 1 5');
INSERT INTO us_rules (rule) VALUES ('0 1 18 -1 1 5 5 -1 1 5');
INSERT INTO us_rules (rule) VALUES ('0 1 18 22 -1 1 5 5 7 -1 1 5');
INSERT INTO us_rules (rule) VALUES ('0 1 18 1 -1 1 5 5 5 -1 1 5');
INSERT INTO us_rules (rule) VALUES ('0 1 18 1 22 -1 1 5 5 5 7 -1 1 5');
INSERT INTO us_rules (rule) VALUES ('0 22 22 -1 1 2 5 -1 1 5');
INSERT INTO us_rules (rule) VALUES ('0 22 22 22 -1 1 2 5 7 -1 1 5');
INSERT INTO us_rules (rule) VALUES ('0 22 22 1 -1 1 2 5 5 -1 1 5');
INSERT INTO us_rules (rule) VALUES ('0 22 22 1 22 -1 1 2 5 5 7 -1 1 5');
INSERT INTO us_rules (rule) VALUES ('0 22 15 -1 1 2 5 -1 1 5');
INSERT INTO us_rules (rule) VALUES ('0 22 15 22 -1 1 2 5 7 -1 1 5');
INSERT INTO us_rules (rule) VALUES ('0 22 18 18 1 -1 1 2 5 5 5 -1 1 5');
INSERT INTO us_rules (rule) VALUES ('0 22 18 18 1 22 -1 1 2 5 5 5 7 -1 1 5');
INSERT INTO us_rules (rule) VALUES ('0 22 18 1 -1 1 2 5 5 -1 1 5');
INSERT INTO us_rules (rule) VALUES ('0 22 18 1 22 -1 1 2 5 5 7 -1 1 5');
INSERT INTO us_rules (rule) VALUES ('0 22 2 -1 1 2 5 -1 1 5');
INSERT INTO us_rules (rule) VALUES ('0 22 2 22 -1 1 2 5 7 -1 1 5');
INSERT INTO us_rules (rule) VALUES ('0 22 1 13 1 -1 1 2 5 5 5 -1 1 5');
INSERT INTO us_rules (rule) VALUES ('0 22 1 13 1 22 -1 1 2 5 5 5 7 -1 1 5');
INSERT INTO us_rules (rule) VALUES ('0 22 1 18 -1 1 2 5 5 -1 1 5');
INSERT INTO us_rules (rule) VALUES ('0 22 1 18 22 -1 1 2 5 5 7 -1 1 5');
INSERT INTO us_rules (rule) VALUES ('0 22 1 18 1 -1 1 2 5 5 5 -1 1 5');
INSERT INTO us_rules (rule) VALUES ('0 22 1 18 1 22 -1 1 2 5 5 5 7 -1 1 5');
INSERT INTO us_rules (rule) VALUES ('0 18 22 -1 1 1 5 -1 1 5');
INSERT INTO us_rules (rule) VALUES ('0 18 22 22 -1 1 1 5 7 -1 1 5');
INSERT INTO us_rules (rule) VALUES ('0 18 22 1 -1 1 1 5 5 -1 1 5');
INSERT INTO us_rules (rule) VALUES ('0 18 22 1 22 -1 1 1 5 5 7 -1 1 5');
INSERT INTO us_rules (rule) VALUES ('0 18 15 -1 1 1 5 -1 1 5');
INSERT INTO us_rules (rule) VALUES ('0 18 15 22 -1 1 1 5 7 -1 1 5');
INSERT INTO us_rules (rule) VALUES ('0 18 18 18 1 -1 1 1 5 5 5 -1 1 5');
INSERT INTO us_rules (rule) VALUES ('0 18 18 18 1 22 -1 1 1 5 5 5 7 -1 1 5');
INSERT INTO us_rules (rule) VALUES ('0 18 18 1 -1 1 1 5 5 -1 1 5');
INSERT INTO us_rules (rule) VALUES ('0 18 18 1 22 -1 1 1 5 5 7 -1 1 5');
INSERT INTO us_rules (rule) VALUES ('0 18 2 -1 1 1 5 -1 1 5');
INSERT INTO us_rules (rule) VALUES ('0 18 2 22 -1 1 1 5 7 -1 1 5');
INSERT INTO us_rules (rule) VALUES ('0 18 1 13 1 -1 1 1 5 5 5 -1 1 5');
INSERT INTO us_rules (rule) VALUES ('0 18 1 13 1 22 -1 1 1 5 5 5 7 -1 1 5');
INSERT INTO us_rules (rule) VALUES ('0 18 1 18 -1 1 1 5 5 -1 1 5');
INSERT INTO us_rules (rule) VALUES ('0 18 1 18 22 -1 1 1 5 5 7 -1 1 5');
INSERT INTO us_rules (rule) VALUES ('0 18 1 18 1 -1 1 1 5 5 5 -1 1 5');
INSERT INTO us_rules (rule) VALUES ('0 18 1 18 1 22 -1 1 1 5 5 5 7 -1 1 5');
INSERT INTO us_rules (rule) VALUES ('0 18 22 22 -1 1 1 2 5 -1 1 5');
INSERT INTO us_rules (rule) VALUES ('0 18 22 22 22 -1 1 1 2 5 7 -1 1 5');
INSERT INTO us_rules (rule) VALUES ('0 18 22 22 1 -1 1 1 2 5 5 -1 1 5');
INSERT INTO us_rules (rule) VALUES ('0 18 22 22 1 22 -1 1 1 2 5 5 7 -1 1 5');
INSERT INTO us_rules (rule) VALUES ('0 18 22 15 -1 1 1 2 5 -1 1 5');
INSERT INTO us_rules (rule) VALUES ('0 18 22 15 22 -1 1 1 2 5 7 -1 1 5');
INSERT INTO us_rules (rule) VALUES ('0 18 22 18 18 1 -1 1 1 2 5 5 5 -1 1 5');
INSERT INTO us_rules (rule) VALUES ('0 18 22 18 18 1 22 -1 1 1 2 5 5 5 7 -1 1 5');
INSERT INTO us_rules (rule) VALUES ('0 18 22 18 1 -1 1 1 2 5 5 -1 1 5');
INSERT INTO us_rules (rule) VALUES ('0 18 22 18 1 22 -1 1 1 2 5 5 7 -1 1 5');
INSERT INTO us_rules (rule) VALUES ('0 18 22 2 -1 1 1 2 5 -1 1 5');
INSERT INTO us_rules (rule) VALUES ('0 18 22 2 22 -1 1 1 2 5 7 -1 1 5');
INSERT INTO us_rules (rule) VALUES ('0 18 22 1 13 1 -1 1 1 2 5 5 5 -1 1 5');
INSERT INTO us_rules (rule) VALUES ('0 18 22 1 13 1 22 -1 1 1 2 5 5 5 7 -1 1 5');
INSERT INTO us_rules (rule) VALUES ('0 18 22 1 18 -1 1 1 2 5 5 -1 1 5');
INSERT INTO us_rules (rule) VALUES ('0 18 22 1 18 22 -1 1 1 2 5 5 7 -1 1 5');
INSERT INTO us_rules (rule) VALUES ('0 18 22 1 18 1 -1 1 1 2 5 5 5 -1 1 5');
INSERT INTO us_rules (rule) VALUES ('0 18 22 1 18 1 22 -1 1 1 2 5 5 5 7 -1 1 5');
INSERT INTO us_rules (rule) VALUES ('0 25 22 -1 1 1 5 -1 1 5');
INSERT INTO us_rules (rule) VALUES ('0 25 22 22 -1 1 1 5 7 -1 1 5');
INSERT INTO us_rules (rule) VALUES ('0 25 22 1 -1 1 1 5 5 -1 1 5');
INSERT INTO us_rules (rule) VALUES ('0 25 22 1 22 -1 1 1 5 5 7 -1 1 5');
INSERT INTO us_rules (rule) VALUES ('0 25 15 -1 1 1 5 -1 1 5');
INSERT INTO us_rules (rule) VALUES ('0 25 15 22 -1 1 1 5 7 -1 1 5');
INSERT INTO us_rules (rule) VALUES ('0 25 18 18 1 -1 1 1 5 5 5 -1 1 5');
INSERT INTO us_rules (rule) VALUES ('0 25 18 18 1 22 -1 1 1 5 5 5 7 -1 1 5');
INSERT INTO us_rules (rule) VALUES ('0 25 18 1 -1 1 1 5 5 -1 1 5');
INSERT INTO us_rules (rule) VALUES ('0 25 18 1 22 -1 1 1 5 5 7 -1 1 5');
INSERT INTO us_rules (rule) VALUES ('0 25 2 -1 1 1 5 -1 1 5');
INSERT INTO us_rules (rule) VALUES ('0 25 2 22 -1 1 1 5 7 -1 1 5');
INSERT INTO us_rules (rule) VALUES ('0 25 1 13 1 -1 1 1 5 5 5 -1 1 5');
INSERT INTO us_rules (rule) VALUES ('0 25 1 13 1 22 -1 1 1 5 5 5 7 -1 1 5');
INSERT INTO us_rules (rule) VALUES ('0 25 1 18 -1 1 1 5 5 -1 1 5');
INSERT INTO us_rules (rule) VALUES ('0 25 1 18 22 -1 1 1 5 5 7 -1 1 5');
INSERT INTO us_rules (rule) VALUES ('0 25 1 18 1 -1 1 1 5 5 5 -1 1 5');
INSERT INTO us_rules (rule) VALUES ('0 25 1 18 1 22 -1 1 1 5 5 5 7 -1 1 5');
INSERT INTO us_rules (rule) VALUES ('0 25 22 22 -1 1 1 2 5 -1 1 5');
INSERT INTO us_rules (rule) VALUES ('0 25 22 22 22 -1 1 1 2 5 7 -1 1 5');
INSERT INTO us_rules (rule) VALUES ('0 25 22 22 1 -1 1 1 2 5 5 -1 1 5');
INSERT INTO us_rules (rule) VALUES ('0 25 22 22 1 22 -1 1 1 2 5 5 7 -1 1 5');
INSERT INTO us_rules (rule) VALUES ('0 25 22 15 -1 1 1 2 5 -1 1 5');
INSERT INTO us_rules (rule) VALUES ('0 25 22 15 22 -1 1 1 2 5 7 -1 1 5');
INSERT INTO us_rules (rule) VALUES ('0 25 22 18 18 1 -1 1 1 2 5 5 5 -1 1 5');
INSERT INTO us_rules (rule) VALUES ('0 25 22 18 18 1 22 -1 1 1 2 5 5 5 7 -1 1 5');
INSERT INTO us_rules (rule) VALUES ('0 25 22 18 1 -1 1 1 2 5 5 -1 1 5');
INSERT INTO us_rules (rule) VALUES ('0 25 22 18 1 22 -1 1 1 2 5 5 7 -1 1 5');
INSERT INTO us_rules (rule) VALUES ('0 25 22 2 -1 1 1 2 5 -1 1 5');
INSERT INTO us_rules (rule) VALUES ('0 25 22 2 22 -1 1 1 2 5 7 -1 1 5');
INSERT INTO us_rules (rule) VALUES ('0 25 22 1 13 1 -1 1 1 2 5 5 5 -1 1 5');
INSERT INTO us_rules (rule) VALUES ('0 25 22 1 13 1 22 -1 1 1 2 5 5 5 7 -1 1 5');
INSERT INTO us_rules (rule) VALUES ('0 25 22 1 18 -1 1 1 2 5 5 -1 1 5');
INSERT INTO us_rules (rule) VALUES ('0 25 22 1 18 22 -1 1 1 2 5 5 7 -1 1 5');
INSERT INTO us_rules (rule) VALUES ('0 25 22 1 18 1 -1 1 1 2 5 5 5 -1 1 5');
INSERT INTO us_rules (rule) VALUES ('0 25 22 1 18 1 22 -1 1 1 2 5 5 5 7 -1 1 5');
INSERT INTO us_rules (rule) VALUES ('25 22 -1 1 5 -1 1 5');
INSERT INTO us_rules (rule) VALUES ('25 22 22 -1 1 5 7 -1 1 5');
INSERT INTO us_rules (rule) VALUES ('25 22 1 -1 1 5 5 -1 1 5');
INSERT INTO us_rules (rule) VALUES ('25 22 1 22 -1 1 5 5 7 -1 1 5');
INSERT INTO us_rules (rule) VALUES ('25 15 -1 1 5 -1 1 5');
INSERT INTO us_rules (rule) VALUES ('25 15 22 -1 1 5 7 -1 1 5');
INSERT INTO us_rules (rule) VALUES ('25 18 18 1 -1 1 5 5 5 -1 1 5');
INSERT INTO us_rules (rule) VALUES ('25 18 18 1 22 -1 1 5 5 5 7 -1 1 5');
INSERT INTO us_rules (rule) VALUES ('25 18 1 -1 1 5 5 -1 1 5');
INSERT INTO us_rules (rule) VALUES ('25 18 1 22 -1 1 5 5 7 -1 1 5');
INSERT INTO us_rules (rule) VALUES ('25 2 -1 1 5 -1 1 5');
INSERT INTO us_rules (rule) VALUES ('25 2 22 -1 1 5 7 -1 1 5');
INSERT INTO us_rules (rule) VALUES ('25 1 13 1 -1 1 5 5 5 -1 1 5');
INSERT INTO us_rules (rule) VALUES ('25 1 13 1 22 -1 1 5 5 5 7 -1 1 5');
INSERT INTO us_rules (rule) VALUES ('25 1 18 -1 1 5 5 -1 1 5');
INSERT INTO us_rules (rule) VALUES ('25 1 18 22 -1 1 5 5 7 -1 1 5');
INSERT INTO us_rules (rule) VALUES ('25 1 18 1 -1 1 5 5 5 -1 1 5');
INSERT INTO us_rules (rule) VALUES ('25 1 18 1 22 -1 1 5 5 5 7 -1 1 5');
INSERT INTO us_rules (rule) VALUES ('25 22 22 -1 1 2 5 -1 1 5');
INSERT INTO us_rules (rule) VALUES ('25 22 22 22 -1 1 2 5 7 -1 1 5');
INSERT INTO us_rules (rule) VALUES ('25 22 22 1 -1 1 2 5 5 -1 1 5');
INSERT INTO us_rules (rule) VALUES ('25 22 22 1 22 -1 1 2 5 5 7 -1 1 5');
INSERT INTO us_rules (rule) VALUES ('25 22 15 -1 1 2 5 -1 1 5');
INSERT INTO us_rules (rule) VALUES ('25 22 15 22 -1 1 2 5 7 -1 1 5');
INSERT INTO us_rules (rule) VALUES ('25 22 18 18 1 -1 1 2 5 5 5 -1 1 5');
INSERT INTO us_rules (rule) VALUES ('25 22 18 18 1 22 -1 1 2 5 5 5 7 -1 1 5');
INSERT INTO us_rules (rule) VALUES ('25 22 18 1 -1 1 2 5 5 -1 1 5');
INSERT INTO us_rules (rule) VALUES ('25 22 18 1 22 -1 1 2 5 5 7 -1 1 5');
INSERT INTO us_rules (rule) VALUES ('25 22 2 -1 1 2 5 -1 1 5');
INSERT INTO us_rules (rule) VALUES ('25 22 2 22 -1 1 2 5 7 -1 1 5');
INSERT INTO us_rules (rule) VALUES ('25 22 1 13 1 -1 1 2 5 5 5 -1 1 5');
INSERT INTO us_rules (rule) VALUES ('25 22 1 13 1 22 -1 1 2 5 5 5 7 -1 1 5');
INSERT INTO us_rules (rule) VALUES ('25 22 1 18 -1 1 2 5 5 -1 1 5');
INSERT INTO us_rules (rule) VALUES ('25 22 1 18 22 -1 1 2 5 5 7 -1 1 5');
INSERT INTO us_rules (rule) VALUES ('25 22 1 18 1 -1 1 2 5 5 5 -1 1 5');
INSERT INTO us_rules (rule) VALUES ('25 22 1 18 1 22 -1 1 2 5 5 5 7 -1 1 5');
INSERT INTO us_rules (rule) VALUES ('0 2 1 18 -1 1 4 5 5 -1 1 11');
INSERT INTO us_rules (rule) VALUES ('0 2 1 18 22 -1 1 4 5 5 7 -1 1 11');
INSERT INTO us_rules (rule) VALUES ('0 2 1 18 1 -1 1 4 5 5 5 -1 1 11');
INSERT INTO us_rules (rule) VALUES ('0 2 1 18 1 22 -1 1 4 5 5 5 7 -1 1 11');
INSERT INTO us_rules (rule) VALUES ('0 2 0 18 -1 1 4 5 5 -1 1 8');
INSERT INTO us_rules (rule) VALUES ('0 2 0 18 22 -1 1 4 5 5 7 -1 1 8');
INSERT INTO us_rules (rule) VALUES ('0 2 0 1 -1 1 4 5 5 -1 1 8');
INSERT INTO us_rules (rule) VALUES ('0 2 0 1 22 -1 1 4 5 5 7 -1 1 8');
INSERT INTO us_rules (rule) VALUES ('0 2 18 1 -1 1 4 5 5 -1 1 8');
INSERT INTO us_rules (rule) VALUES ('0 2 18 1 22 -1 1 4 5 5 7 -1 1 8');
INSERT INTO us_rules (rule) VALUES ('0 2 18 18 1 -1 1 4 5 5 5 -1 1 8');
INSERT INTO us_rules (rule) VALUES ('0 2 18 18 1 22 -1 1 4 5 5 5 7 -1 1 8');
INSERT INTO us_rules (rule) VALUES ('0 18 2 1 18 -1 1 1 4 5 5 -1 1 11');
INSERT INTO us_rules (rule) VALUES ('0 18 2 1 18 22 -1 1 1 4 5 5 7 -1 1 11');
INSERT INTO us_rules (rule) VALUES ('0 18 2 1 18 1 -1 1 1 4 5 5 5 -1 1 11');
INSERT INTO us_rules (rule) VALUES ('0 18 2 1 18 1 22 -1 1 1 4 5 5 5 7 -1 1 11');
INSERT INTO us_rules (rule) VALUES ('0 18 2 0 18 -1 1 1 4 5 5 -1 1 11');
INSERT INTO us_rules (rule) VALUES ('0 18 2 0 18 22 -1 1 1 4 5 5 7 -1 1 11');
INSERT INTO us_rules (rule) VALUES ('0 18 2 0 1 -1 1 1 4 5 5 -1 1 8');
INSERT INTO us_rules (rule) VALUES ('0 18 2 0 1 22 -1 1 1 4 5 5 7 -1 1 8');
INSERT INTO us_rules (rule) VALUES ('0 18 2 18 1 -1 1 1 4 5 5 -1 1 8');
INSERT INTO us_rules (rule) VALUES ('0 18 2 18 1 22 -1 1 1 4 5 5 7 -1 1 8');
INSERT INTO us_rules (rule) VALUES ('0 18 2 18 18 1 -1 1 1 4 5 5 5 -1 1 8');
INSERT INTO us_rules (rule) VALUES ('0 18 2 18 18 1 22 -1 1 1 4 5 5 5 7 -1 1 8');
INSERT INTO us_rules (rule) VALUES ('0 25 2 1 18 -1 1 1 4 5 5 -1 1 11');
INSERT INTO us_rules (rule) VALUES ('0 25 2 1 18 22 -1 1 1 4 5 5 7 -1 1 11');
INSERT INTO us_rules (rule) VALUES ('0 25 2 1 18 1 -1 1 1 4 5 5 5 -1 1 11');
INSERT INTO us_rules (rule) VALUES ('0 25 2 1 18 1 22 -1 1 1 4 5 5 5 7 -1 1 11');
INSERT INTO us_rules (rule) VALUES ('0 25 2 0 18 -1 1 1 4 5 5 -1 1 8');
INSERT INTO us_rules (rule) VALUES ('0 25 2 0 18 22 -1 1 1 4 5 5 7 -1 1 8');
INSERT INTO us_rules (rule) VALUES ('0 25 2 0 1 -1 1 1 4 5 5 -1 1 8');
INSERT INTO us_rules (rule) VALUES ('0 25 2 0 1 22 -1 1 1 4 5 5 7 -1 1 8');
INSERT INTO us_rules (rule) VALUES ('0 25 2 18 1 -1 1 1 4 5 5 -1 1 8');
INSERT INTO us_rules (rule) VALUES ('0 25 2 18 1 22 -1 1 1 4 5 5 7 -1 1 8');
INSERT INTO us_rules (rule) VALUES ('0 25 2 18 18 1 -1 1 1 4 5 5 5 -1 1 8');
INSERT INTO us_rules (rule) VALUES ('0 25 2 18 18 1 22 -1 1 1 4 5 5 5 7 -1 1 8');
INSERT INTO us_rules (rule) VALUES ('25 2 1 18 -1 1 4 5 5 -1 1 11');
INSERT INTO us_rules (rule) VALUES ('25 2 1 18 22 -1 1 4 5 5 7 -1 1 11');
INSERT INTO us_rules (rule) VALUES ('25 2 1 18 1 -1 1 4 5 5 5 -1 1 11');
INSERT INTO us_rules (rule) VALUES ('25 2 1 18 1 22 -1 1 4 5 5 5 7 -1 1 11');
INSERT INTO us_rules (rule) VALUES ('25 2 0 18 -1 1 4 5 5 -1 1 8');
INSERT INTO us_rules (rule) VALUES ('25 2 0 18 22 -1 1 4 5 5 7 -1 1 8');
INSERT INTO us_rules (rule) VALUES ('25 2 0 1 -1 1 4 5 5 -1 1 8');
INSERT INTO us_rules (rule) VALUES ('25 2 0 1 22 -1 1 4 5 5 7 -1 1 8');
INSERT INTO us_rules (rule) VALUES ('25 2 18 1 -1 1 4 5 5 -1 1 8');
INSERT INTO us_rules (rule) VALUES ('25 2 18 1 22 -1 1 4 5 5 7 -1 1 8');
INSERT INTO us_rules (rule) VALUES ('25 2 18 18 1 -1 1 4 5 5 5 -1 1 8');
INSERT INTO us_rules (rule) VALUES ('25 2 18 18 1 22 -1 1 4 5 5 5 7 -1 1 8');
INSERT INTO us_rules (rule) VALUES ('0 14 2 -1 1 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 14 2 22 -1 1 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 15 1 2 -1 1 5 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 15 1 2 22 -1 1 5 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 24 2 -1 1 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 24 2 22 -1 1 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 24 24 2 -1 1 5 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 24 24 2 22 -1 1 5 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 24 2 2 -1 1 5 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 24 2 2 22 -1 1 5 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 24 1 2 -1 1 5 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 24 1 2 22 -1 1 5 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 22 2 -1 1 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 22 2 22 -1 1 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 22 1 2 -1 1 5 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 22 1 2 22 -1 1 2 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 2 -1 1 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 2 22 -1 1 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 0 25 2 -1 1 5 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 0 25 2 22 -1 1 5 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 15 2 -1 1 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 15 2 22 -1 1 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 18 18 2 -1 1 5 5 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 18 18 2 22 -1 1 5 5 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 18 1 2 -1 1 5 5 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 18 1 2 22 -1 1 5 5 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 2 2 -1 1 5 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 2 2 22 -1 1 5 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 1 2 -1 1 5 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 1 2 22 -1 1 5 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 2 2 -1 1 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 2 2 22 -1 1 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 2 0 2 -1 1 5 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 2 0 2 22 -1 1 5 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 2 1 2 -1 1 5 5 6 -1 1 15');
INSERT INTO us_rules (rule) VALUES ('0 2 1 2 22 -1 1 5 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 16 0 2 -1 1 5 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 16 0 2 22 -1 1 5 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 1 13 1 2 -1 1 5 5 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 1 13 1 2 22 -1 1 5 5 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 1 15 2 -1 1 5 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 1 15 2 22 -1 1 5 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 1 24 2 -1 1 5 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 1 24 2 22 -1 1 5 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 1 24 24 2 -1 1 5 5 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 1 24 24 2 22 -1 1 5 5 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 1 24 1 2 -1 1 5 5 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 1 24 1 2 22 -1 1 5 5 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 1 22 2 -1 1 5 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 1 22 2 22 -1 1 5 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 1 22 1 2 -1 1 5 5 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 1 22 1 2 22 -1 1 5 5 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 1 25 2 -1 1 5 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 1 25 2 22 -1 1 5 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 1 0 2 -1 1 5 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 1 0 2 22 -1 1 5 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 1 18 2 -1 1 5 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 1 18 2 22 -1 1 5 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 1 18 2 2 -1 1 5 5 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 1 18 2 2 22 -1 1 5 5 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 1 18 1 2 -1 1 5 5 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 1 18 1 2 22 -1 1 5 5 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 1 2 2 -1 1 5 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 1 2 2 22 -1 1 5 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 1 2 2 2 -1 1 5 5 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 1 2 2 2 22 -1 1 5 5 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 21 2 -1 1 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 21 2 22 -1 1 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 22 14 2 -1 1 2 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 22 14 2 22 -1 1 2 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 22 15 1 2 -1 1 2 5 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 22 15 1 2 22 -1 1 2 5 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 22 24 2 -1 1 2 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 22 24 2 22 -1 1 2 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 22 24 24 2 -1 1 2 5 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 22 24 24 2 22 -1 1 2 5 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 22 24 2 2 -1 1 2 5 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 22 24 2 2 22 -1 1 2 5 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 22 24 1 2 -1 1 2 5 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 22 24 1 2 22 -1 1 2 5 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 22 22 2 -1 1 2 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 22 22 2 22 -1 1 2 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 22 22 1 2 -1 1 2 5 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 22 22 1 2 22 -1 1 2 5 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 22 25 2 -1 1 2 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 22 25 2 22 -1 1 2 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 22 0 25 2 -1 1 2 5 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 22 0 25 2 22 -1 1 2 5 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 22 15 2 -1 1 2 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 22 15 2 22 -1 1 2 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 22 18 18 18 2 -1 1 2 5 5 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 22 18 18 18 2 22 -1 1 2 5 5 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 22 18 18 1 2 -1 1 2 5 5 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 22 18 18 1 2 22 -1 1 2 5 5 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 22 18 2 2 -1 1 2 5 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 22 18 2 2 22 -1 1 2 5 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 22 18 1 2 -1 1 2 5 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 22 18 1 2 22 -1 1 2 5 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 22 2 2 -1 1 2 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 22 2 2 22 -1 1 2 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 22 2 0 2 -1 1 2 5 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 22 2 0 2 22 -1 1 2 5 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 22 2 1 2 -1 1 2 5 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 22 2 1 2 22 -1 1 2 5 5 6 7 -1 1 15');
INSERT INTO us_rules (rule) VALUES ('0 22 16 0 2 -1 1 2 5 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 22 16 0 2 22 -1 1 2 5 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 22 1 13 1 2 -1 1 2 5 5 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 22 1 13 1 2 22 -1 1 2 5 5 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 22 1 15 2 -1 1 2 5 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 22 1 15 2 22 -1 1 2 5 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 22 1 24 2 -1 1 2 5 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 22 1 24 2 22 -1 1 2 5 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 22 1 24 24 2 -1 1 2 5 5 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 22 1 24 24 2 22 -1 1 2 5 5 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 22 1 24 1 2 -1 1 2 5 5 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 22 1 24 1 2 22 -1 1 2 5 5 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 22 1 22 2 -1 1 2 5 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 22 1 22 2 22 -1 1 2 5 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 22 1 22 1 2 -1 1 2 5 5 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 22 1 22 1 2 22 -1 1 2 5 5 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 22 1 25 2 -1 1 2 5 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 22 1 25 2 22 -1 1 2 5 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 22 1 0 2 -1 1 2 5 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 22 1 0 2 22 -1 1 2 5 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 22 1 18 2 -1 1 2 5 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 22 1 18 2 22 -1 1 2 5 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 22 1 18 2 2 -1 1 2 5 5 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 22 1 18 2 2 22 -1 1 2 5 5 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 22 1 18 1 2 -1 1 2 5 5 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 22 1 18 1 2 22 -1 1 2 5 5 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 22 1 2 2 -1 1 2 5 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 22 1 2 2 22 -1 1 2 5 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 22 1 2 2 2 -1 1 2 5 5 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 22 1 2 2 2 22 -1 1 2 5 5 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 22 21 2 -1 1 2 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 22 21 2 22 -1 1 2 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 14 2 -1 1 1 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 14 2 22 -1 1 1 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 15 1 2 -1 1 1 5 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 15 1 2 22 -1 1 1 5 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 24 2 -1 1 1 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 24 2 22 -1 1 1 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 24 24 2 -1 1 1 5 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 24 24 2 22 -1 1 1 5 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 24 2 2 -1 1 1 5 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 24 2 2 22 -1 1 1 5 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 24 1 2 -1 1 1 5 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 24 1 2 22 -1 1 1 5 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 22 2 -1 1 1 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 22 2 22 -1 1 1 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 22 1 2 -1 1 1 5 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 22 1 2 22 -1 1 1 5 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 25 2 -1 1 1 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 25 2 22 -1 1 1 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 0 25 2 -1 1 1 5 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 0 25 2 22 -1 1 1 5 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 15 2 -1 1 1 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 15 2 22 -1 1 1 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 18 18 18 2 -1 1 1 5 5 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 18 18 18 2 22 -1 1 1 5 5 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 18 18 1 2 -1 1 1 5 5 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 18 18 1 2 22 -1 1 1 5 5 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 18 2 2 -1 1 1 5 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 18 2 2 22 -1 1 1 5 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 18 1 2 -1 1 1 5 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 18 1 2 22 -1 1 1 5 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 2 2 -1 1 1 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 2 2 22 -1 1 1 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 2 0 2 -1 1 1 5 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 2 0 2 22 -1 1 1 5 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 2 1 2 -1 1 1 5 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 2 1 2 22 -1 1 1 5 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 16 0 2 -1 1 1 5 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 16 0 2 22 -1 1 1 5 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 1 13 1 2 -1 1 1 5 5 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 1 13 1 2 22 -1 1 1 5 5 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 1 15 2 -1 1 1 5 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 1 15 2 22 -1 1 1 5 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 1 24 2 -1 1 1 5 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 1 24 2 22 -1 1 1 5 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 1 24 24 2 -1 1 1 5 5 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 1 24 24 2 22 -1 1 1 5 5 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 1 24 1 2 -1 1 1 5 5 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 1 24 1 2 22 -1 1 1 5 5 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 1 22 2 -1 1 1 5 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 1 22 2 22 -1 1 1 5 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 1 22 1 2 -1 1 1 5 5 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 1 22 1 2 22 -1 1 1 5 5 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 1 25 2 -1 1 1 5 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 1 25 2 22 -1 1 1 5 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 1 0 2 -1 1 1 5 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 1 0 2 22 -1 1 1 5 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 1 18 2 -1 1 1 5 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 1 18 2 22 -1 1 1 5 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 1 18 2 2 -1 1 1 5 5 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 1 18 2 2 22 -1 1 1 5 5 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 1 18 1 2 -1 1 1 5 5 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 1 18 1 2 22 -1 1 1 5 5 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 1 2 2 -1 1 1 5 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 1 2 2 22 -1 1 1 5 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 1 2 2 2 -1 1 1 5 5 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 1 2 2 2 22 -1 1 1 5 5 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 21 2 -1 1 1 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 21 2 22 -1 1 1 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 22 14 2 -1 1 1 2 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 22 14 2 22 -1 1 1 2 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 22 15 1 2 -1 1 1 2 5 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 22 15 1 2 22 -1 1 1 2 5 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 22 24 2 -1 1 1 2 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 22 24 2 22 -1 1 1 2 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 22 24 24 2 -1 1 1 2 5 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 22 24 24 2 22 -1 1 1 2 5 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 22 24 2 2 -1 1 1 2 5 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 22 24 2 2 22 -1 1 1 2 5 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 22 24 1 2 -1 1 1 2 5 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 22 24 1 2 22 -1 1 1 2 5 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 22 22 2 -1 1 1 2 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 22 22 2 22 -1 1 1 2 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 22 22 1 2 -1 1 1 2 5 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 22 22 1 2 22 -1 1 1 2 5 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 22 25 2 -1 1 1 2 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 22 25 2 22 -1 1 1 2 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 22 0 25 2 -1 1 1 2 5 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 22 0 25 2 22 -1 1 1 2 5 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 22 15 2 -1 1 1 2 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 22 15 2 22 -1 1 1 2 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 22 18 18 18 2 -1 1 1 2 5 5 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 22 18 18 18 2 22 -1 1 1 2 5 5 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 22 18 18 1 2 -1 1 1 2 5 5 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 22 18 18 1 2 22 -1 1 1 2 5 5 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 22 18 2 2 -1 1 1 2 5 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 22 18 2 2 22 -1 1 1 2 5 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 22 18 1 2 -1 1 1 2 5 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 22 18 1 2 22 -1 1 1 2 5 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 22 2 2 -1 1 1 2 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 22 2 2 22 -1 1 1 2 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 22 2 0 2 -1 1 1 2 5 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 22 2 0 2 22 -1 1 1 2 5 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 22 2 1 2 -1 1 1 2 5 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 22 2 1 2 22 -1 1 1 2 5 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 22 16 0 2 -1 1 1 2 5 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 22 16 0 2 22 -1 1 1 2 5 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 22 1 13 1 2 -1 1 1 2 5 5 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 22 1 13 1 2 22 -1 1 1 2 5 5 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 22 1 15 2 -1 1 1 2 5 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 22 1 15 2 22 -1 1 1 2 5 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 22 1 24 2 -1 1 1 2 5 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 22 1 24 2 22 -1 1 1 2 5 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 22 1 24 24 2 -1 1 1 2 5 5 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 22 1 24 24 2 22 -1 1 1 2 5 5 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 22 1 24 1 2 -1 1 1 2 5 5 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 22 1 24 1 2 22 -1 1 1 2 5 5 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 22 1 22 2 -1 1 1 2 5 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 22 1 22 2 22 -1 1 1 2 5 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 22 1 22 1 2 -1 1 1 2 5 5 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 22 1 22 1 2 22 -1 1 1 2 5 5 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 22 1 25 2 -1 1 1 2 5 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 22 1 25 2 22 -1 1 1 2 5 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 22 1 0 2 -1 1 1 2 5 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 22 1 0 2 22 -1 1 1 2 5 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 22 1 18 2 -1 1 1 2 5 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 22 1 18 2 22 -1 1 1 2 5 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 22 1 18 2 2 -1 1 1 2 5 5 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 22 1 18 2 2 22 -1 1 1 2 5 5 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 22 1 18 1 2 -1 1 1 2 5 5 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 22 1 18 1 2 22 -1 1 1 2 5 5 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 22 1 2 2 -1 1 1 2 5 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 22 1 2 2 22 -1 1 1 2 5 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 22 1 2 2 2 -1 1 1 2 5 5 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 22 1 2 2 2 22 -1 1 1 2 5 5 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 22 21 2 -1 1 1 2 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 18 22 21 2 22 -1 1 1 2 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 14 2 -1 1 1 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 14 2 22 -1 1 1 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 15 1 2 -1 1 1 5 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 15 1 2 22 -1 1 1 5 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 24 2 -1 1 1 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 24 2 22 -1 1 1 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 24 24 2 -1 1 1 5 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 24 24 2 22 -1 1 1 5 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 24 2 2 -1 1 1 5 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 24 2 2 22 -1 1 1 5 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 24 1 2 -1 1 1 5 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 24 1 2 22 -1 1 1 5 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 22 2 -1 1 1 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 22 2 22 -1 1 1 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 22 1 2 -1 1 1 5 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 22 1 2 22 -1 1 1 5 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 25 2 -1 1 1 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 25 2 22 -1 1 1 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 0 25 2 -1 1 1 5 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 0 25 2 22 -1 1 1 5 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 15 2 -1 1 1 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 15 2 22 -1 1 1 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 18 18 18 2 -1 1 1 5 5 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 18 18 18 2 22 -1 1 1 5 5 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 18 18 1 2 -1 1 1 5 5 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 18 18 1 2 22 -1 1 1 5 5 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 18 2 2 -1 1 1 5 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 18 2 2 22 -1 1 1 5 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 18 1 2 -1 1 1 5 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 18 1 2 22 -1 1 1 5 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 2 2 -1 1 1 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 2 2 22 -1 1 1 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 2 0 2 -1 1 1 5 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 2 0 2 22 -1 1 1 5 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 2 1 2 -1 1 1 5 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 2 1 2 22 -1 1 1 5 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 16 0 2 -1 1 1 5 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 16 0 2 22 -1 1 1 5 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 1 13 1 2 -1 1 1 5 5 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 1 13 1 2 22 -1 1 1 5 5 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 1 15 2 -1 1 1 5 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 1 15 2 22 -1 1 1 5 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 1 24 2 -1 1 1 5 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 1 24 2 22 -1 1 1 5 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 1 24 24 2 -1 1 1 5 5 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 1 24 24 2 22 -1 1 1 5 5 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 1 24 1 2 -1 1 1 5 5 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 1 24 1 2 22 -1 1 1 5 5 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 1 22 2 -1 1 1 5 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 1 22 2 22 -1 1 1 5 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 1 22 1 2 -1 1 1 5 5 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 1 22 1 2 22 -1 1 1 5 5 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 1 25 2 -1 1 1 5 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 1 25 2 22 -1 1 1 5 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 1 0 2 -1 1 1 5 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 1 0 2 22 -1 1 1 5 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 1 18 2 -1 1 1 5 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 1 18 2 22 -1 1 1 5 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 1 18 2 2 -1 1 1 5 5 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 1 18 2 2 22 -1 1 1 5 5 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 1 18 1 2 -1 1 1 5 5 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 1 18 1 2 22 -1 1 1 5 5 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 1 2 2 -1 1 1 5 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 1 2 2 22 -1 1 1 5 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 1 2 2 2 -1 1 1 5 5 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 1 2 2 2 22 -1 1 1 5 5 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 21 2 -1 1 1 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 21 2 22 -1 1 1 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 22 14 2 -1 1 1 2 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 22 14 2 22 -1 1 1 2 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 22 15 1 2 -1 1 1 2 5 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 22 15 1 2 22 -1 1 1 2 5 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 22 24 2 -1 1 1 2 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 22 24 2 22 -1 1 1 2 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 22 24 24 2 -1 1 1 2 5 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 22 24 24 2 22 -1 1 1 2 5 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 22 24 2 2 -1 1 1 2 5 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 22 24 2 2 22 -1 1 1 2 5 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 22 24 1 2 -1 1 1 2 5 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 22 24 1 2 22 -1 1 1 2 5 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 22 22 2 -1 1 1 2 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 22 22 2 22 -1 1 1 2 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 22 22 1 2 -1 1 1 2 5 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 22 22 1 2 22 -1 1 1 2 5 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 22 25 2 -1 1 1 2 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 22 25 2 22 -1 1 1 2 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 22 0 25 2 -1 1 1 2 5 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 22 0 25 2 22 -1 1 1 2 5 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 22 15 2 -1 1 1 2 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 22 15 2 22 -1 1 1 2 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 22 18 18 18 2 -1 1 1 2 5 5 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 22 18 18 18 2 22 -1 1 1 2 5 5 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 22 18 18 1 2 -1 1 1 2 5 5 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 22 18 18 1 2 22 -1 1 1 2 5 5 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 22 18 2 2 -1 1 1 2 5 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 22 18 2 2 22 -1 1 1 2 5 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 22 18 1 2 -1 1 1 2 5 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 22 18 1 2 22 -1 1 1 2 5 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 22 2 2 -1 1 1 2 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 22 2 2 22 -1 1 1 2 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 22 2 0 2 -1 1 1 2 5 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 22 2 0 2 22 -1 1 1 2 5 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 22 2 1 2 -1 1 1 2 5 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 22 2 1 2 22 -1 1 1 2 5 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 22 16 0 2 -1 1 1 2 5 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 22 16 0 2 22 -1 1 1 2 5 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 22 1 13 1 2 -1 1 1 2 5 5 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 22 1 13 1 2 22 -1 1 1 2 5 5 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 22 1 15 2 -1 1 1 2 5 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 22 1 15 2 22 -1 1 1 2 5 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 22 1 24 2 -1 1 1 2 5 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 22 1 24 2 22 -1 1 1 2 5 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 22 1 24 24 2 -1 1 1 2 5 5 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 22 1 24 24 2 22 -1 1 1 2 5 5 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 22 1 24 1 2 -1 1 1 2 5 5 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 22 1 24 1 2 22 -1 1 1 2 5 5 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 22 1 22 2 -1 1 1 2 5 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 22 1 22 2 22 -1 1 1 2 5 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 22 1 22 1 2 -1 1 1 2 5 5 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 22 1 22 1 2 22 -1 1 1 2 5 5 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 22 1 25 2 -1 1 1 2 5 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 22 1 25 2 22 -1 1 1 2 5 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 22 1 0 2 -1 1 1 2 5 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 22 1 0 2 22 -1 1 1 2 5 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 22 1 18 2 -1 1 1 2 5 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 22 1 18 2 22 -1 1 1 2 5 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 22 1 18 2 2 -1 1 1 2 5 5 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 22 1 18 2 2 22 -1 1 1 2 5 5 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 22 1 18 1 2 -1 1 1 2 5 5 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 22 1 18 1 2 22 -1 1 1 2 5 5 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 22 1 2 2 -1 1 1 2 5 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 22 1 2 2 22 -1 1 1 2 5 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 22 1 2 2 2 -1 1 1 2 5 5 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 22 1 2 2 2 22 -1 1 1 2 5 5 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 22 21 2 -1 1 1 2 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 25 22 21 2 22 -1 1 1 2 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 14 2 -1 1 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 14 2 22 -1 1 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 15 1 2 -1 1 5 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 15 1 2 22 -1 1 5 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 24 2 -1 1 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 24 2 22 -1 1 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 24 24 2 -1 1 5 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 24 24 2 22 -1 1 5 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 24 2 2 -1 1 5 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 24 2 2 22 -1 1 5 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 24 1 2 -1 1 5 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 24 1 2 22 -1 1 5 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 22 2 -1 1 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 22 2 22 -1 1 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 22 1 2 -1 1 5 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 22 1 2 22 -1 1 5 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 25 2 -1 1 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 25 2 22 -1 1 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 0 25 2 -1 1 5 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 0 25 2 22 -1 1 5 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 15 2 -1 1 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 15 2 22 -1 1 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 18 18 18 2 -1 1 5 5 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 18 18 18 2 22 -1 1 5 5 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 18 18 1 2 -1 1 5 5 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 18 18 1 2 22 -1 1 5 5 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 18 2 2 -1 1 5 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 18 2 2 22 -1 1 5 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 18 1 2 -1 1 5 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 18 1 2 22 -1 1 5 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 2 2 -1 1 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 2 2 22 -1 1 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 2 0 2 -1 1 5 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 2 0 2 22 -1 1 5 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 2 1 2 -1 1 5 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 2 1 2 22 -1 1 5 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 16 0 2 -1 1 5 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 16 0 2 22 -1 1 5 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 1 13 1 2 -1 1 5 5 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 1 13 1 2 22 -1 1 5 5 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 1 15 2 -1 1 5 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 1 15 2 22 -1 1 5 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 1 24 2 -1 1 5 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 1 24 2 22 -1 1 5 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 1 24 24 2 -1 1 5 5 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 1 24 24 2 22 -1 1 5 5 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 1 24 1 2 -1 1 5 5 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 1 24 1 2 22 -1 1 5 5 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 1 22 2 -1 1 5 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 1 22 2 22 -1 1 5 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 1 22 1 2 -1 1 5 5 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 1 22 1 2 22 -1 1 5 5 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 1 25 2 -1 1 5 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 1 25 2 22 -1 1 5 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 1 0 2 -1 1 5 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 1 0 2 22 -1 1 5 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 1 18 2 -1 1 5 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 1 18 2 22 -1 1 5 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 1 18 2 2 -1 1 5 5 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 1 18 2 2 22 -1 1 5 5 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 1 18 1 2 -1 1 5 5 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 1 18 1 2 22 -1 1 5 5 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 1 2 2 -1 1 5 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 1 2 2 22 -1 1 5 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 1 2 2 2 -1 1 5 5 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 1 2 2 2 22 -1 1 5 5 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 21 2 -1 1 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 21 2 22 -1 1 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 22 14 2 -1 1 2 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 22 14 2 22 -1 1 2 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 22 15 1 2 -1 1 2 5 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 22 15 1 2 22 -1 1 2 5 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 22 24 2 -1 1 2 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 22 24 2 22 -1 1 2 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 22 24 24 2 -1 1 2 5 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 22 24 24 2 22 -1 1 2 5 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 22 24 2 2 -1 1 2 5 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 22 24 2 2 22 -1 1 2 5 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 22 24 1 2 -1 1 2 5 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 22 24 1 2 22 -1 1 2 5 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 22 22 2 -1 1 2 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 22 22 2 22 -1 1 2 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 22 22 1 2 -1 1 2 5 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 22 22 1 2 22 -1 1 2 5 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 22 25 2 -1 1 2 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 22 25 2 22 -1 1 2 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 22 0 25 2 -1 1 2 5 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 22 0 25 2 22 -1 1 2 5 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 22 15 2 -1 1 2 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 22 15 2 22 -1 1 2 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 22 18 18 18 2 -1 1 2 5 5 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 22 18 18 18 2 22 -1 1 2 5 5 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 22 18 18 1 2 -1 1 2 5 5 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 22 18 18 1 2 22 -1 1 2 5 5 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 22 18 2 2 -1 1 2 5 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 22 18 2 2 22 -1 1 2 5 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 22 18 1 2 -1 1 2 5 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 22 18 1 2 22 -1 1 2 5 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 22 2 2 -1 1 2 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 22 2 2 22 -1 1 2 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 22 2 0 2 -1 1 2 5 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 22 2 0 2 22 -1 1 2 5 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 22 2 1 2 -1 1 2 5 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 22 2 1 2 22 -1 1 2 5 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 22 16 0 2 -1 1 2 5 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 22 16 0 2 22 -1 1 2 5 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 22 1 13 1 2 -1 1 2 5 5 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 22 1 13 1 2 22 -1 1 2 5 5 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 22 1 15 2 -1 1 2 5 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 22 1 15 2 22 -1 1 2 5 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 22 1 24 2 -1 1 2 5 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 22 1 24 2 22 -1 1 2 5 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 22 1 24 24 2 -1 1 2 5 5 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 22 1 24 24 2 22 -1 1 2 5 5 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 22 1 24 1 2 -1 1 2 5 5 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 22 1 24 1 2 22 -1 1 2 5 5 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 22 1 22 2 -1 1 2 5 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 22 1 22 2 22 -1 1 2 5 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 22 1 22 1 2 -1 1 2 5 5 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 22 1 22 1 2 22 -1 1 2 5 5 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 22 1 25 2 -1 1 2 5 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 22 1 25 2 22 -1 1 2 5 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 22 1 0 2 -1 1 2 5 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 22 1 0 2 22 -1 1 2 5 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 22 1 18 2 -1 1 2 5 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 22 1 18 2 22 -1 1 2 5 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 22 1 18 2 2 -1 1 2 5 5 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 22 1 18 2 2 22 -1 1 2 5 5 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 22 1 18 1 2 -1 1 2 5 5 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 22 1 18 1 2 22 -1 1 2 5 5 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 22 1 2 2 -1 1 2 5 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 22 1 2 2 22 -1 1 2 5 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 22 1 2 2 2 -1 1 2 5 5 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 22 1 2 2 2 22 -1 1 2 5 5 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 22 21 2 -1 1 2 5 6 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('25 22 21 2 22 -1 1 2 5 6 7 -1 1 16');
INSERT INTO us_rules (rule) VALUES ('0 -1 1 -1 3 17');
INSERT INTO us_rules (rule) VALUES ('0 18 -1 1 1 -1 3 16');
INSERT INTO us_rules (rule) VALUES ('0 25 -1 1 1 -1 3 16');
INSERT INTO us_rules (rule) VALUES ('0 22 -1 1 1 -1 3 9');
INSERT INTO us_rules (rule) VALUES ('22 0 -1 1 1 -1 3 9');
INSERT INTO us_rules (rule) VALUES ('1 0 -1 1 1 -1 3 6');
INSERT INTO us_rules (rule) VALUES ('18 0 -1 1 1 -1 3 12');
INSERT INTO us_rules (rule) VALUES ('25 -1 1 -1 3 12');
INSERT INTO us_rules (rule) VALUES ('21 0 -1 1 1 -1 3 12');
INSERT INTO us_rules (rule) VALUES ('0 21 -1 1 1 -1 3 9');
INSERT INTO us_rules (rule) VALUES ('0 0 -1 1 1 -1 3 15');
INSERT INTO us_rules (rule) VALUES ('21 0 0 -1 1 1 1 -1 3 9');
INSERT INTO us_rules (rule) VALUES ('0 0 21 -1 1 1 1 -1 3 9');
INSERT INTO us_rules (rule) VALUES ('0 0 18 -1 1 1 1 -1 3 9');
INSERT INTO us_rules (rule) VALUES ('18 0 -1 1 1 -1 3 9');
INSERT INTO us_rules (rule) VALUES ('18 0 0 -1 1 1 1 -1 3 9');
INSERT INTO us_rules (rule) VALUES ('0 0 18 -1 1 1 1 -1 3 9');
INSERT INTO us_rules (rule) VALUES ('8 -1 8 -1 4 7');
INSERT INTO us_rules (rule) VALUES ('8 23 -1 8 8 -1 4 16');
INSERT INTO us_rules (rule) VALUES ('8 0 -1 8 8 -1 4 17');
INSERT INTO us_rules (rule) VALUES ('8 0 18 -1 8 8 8 -1 4 16');
INSERT INTO us_rules (rule) VALUES ('8 18 -1 8 8 -1 4 16');
INSERT INTO us_rules (rule) VALUES ('8 18 0 -1 8 8 8 -1 4 16');
INSERT INTO us_rules (rule) VALUES ('8 1 -1 8 8 -1 4 2');
INSERT INTO us_rules (rule) VALUES ('14 -1 14 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('14 21 -1 14 15 -1 4 16');
INSERT INTO us_rules (rule) VALUES ('14 23 -1 14 15 -1 4 17');
INSERT INTO us_rules (rule) VALUES ('14 0 -1 14 15 -1 4 17');
INSERT INTO us_rules (rule) VALUES ('14 0 18 -1 14 15 15 -1 4 16');
INSERT INTO us_rules (rule) VALUES ('14 0 18 0 -1 14 15 15 15 -1 4 16');
INSERT INTO us_rules (rule) VALUES ('14 18 -1 14 15 -1 4 16');
INSERT INTO us_rules (rule) VALUES ('14 18 0 -1 14 15 15 -1 4 16');
INSERT INTO us_rules (rule) VALUES ('14 1 -1 14 15 -1 4 2');
INSERT INTO us_rules (rule) VALUES ('1 24 -1 0 0 -1 4 15');
INSERT INTO us_rules (rule) VALUES ('14 24 -1 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('24 24 -1 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('24 24 24 -1 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('24 22 24 -1 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('24 18 24 -1 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('24 2 24 -1 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('24 1 24 -1 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('22 24 -1 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('22 24 24 -1 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('22 24 24 24 -1 0 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('22 24 1 24 -1 0 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('22 22 24 -1 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('22 2 24 -1 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('22 1 24 -1 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('18 24 -1 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('18 13 18 24 -1 0 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('18 24 24 -1 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('18 18 24 -1 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('18 18 18 24 -1 0 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('18 18 2 24 -1 0 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('18 18 1 24 -1 0 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('18 2 24 -1 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('18 1 24 -1 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('18 1 24 24 -1 0 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('2 24 -1 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('2 22 24 -1 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('2 0 24 -1 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('2 18 24 -1 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('2 2 24 -1 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('2 1 24 -1 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('1 13 1 24 -1 0 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('1 24 24 24 -1 0 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('1 24 22 24 -1 0 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('1 24 2 24 -1 0 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('1 24 1 24 -1 0 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('1 22 24 -1 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('1 22 24 24 -1 0 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('1 0 24 -1 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('1 0 24 24 -1 0 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('1 0 1 24 -1 0 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('1 18 24 -1 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('1 18 1 24 -1 0 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('1 2 24 -1 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('1 2 1 24 -1 0 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('0 1 24 -1 0 0 0 -1 4 15');
INSERT INTO us_rules (rule) VALUES ('0 14 24 -1 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('0 24 24 -1 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('0 24 24 24 -1 0 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('0 24 22 24 -1 0 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('0 24 18 24 -1 0 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('0 24 2 24 -1 0 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('0 24 1 24 -1 0 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('0 22 24 -1 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('0 22 24 24 -1 0 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('0 22 24 24 24 -1 0 0 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('0 22 24 1 24 -1 0 0 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('0 22 22 24 -1 0 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('0 22 2 24 -1 0 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('0 22 1 24 -1 0 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('0 18 24 -1 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('0 18 13 18 24 -1 0 0 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('0 18 24 24 -1 0 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('0 18 18 24 -1 0 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('0 18 18 18 24 -1 0 0 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('0 18 18 2 24 -1 0 0 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('0 18 18 1 24 -1 0 0 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('0 18 2 24 -1 0 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('0 18 1 24 -1 0 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('0 18 1 24 24 -1 0 0 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('0 2 24 -1 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('0 2 22 24 -1 0 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('0 2 0 24 -1 0 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('0 2 18 24 -1 0 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('0 2 2 24 -1 0 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('0 2 1 24 -1 0 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('0 1 13 1 24 -1 0 0 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('0 1 24 24 24 -1 0 0 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('0 1 24 22 24 -1 0 0 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('0 1 24 2 24 -1 0 0 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('0 1 24 1 24 -1 0 0 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('0 1 22 24 -1 0 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('0 1 22 24 24 -1 0 0 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('0 1 0 24 -1 0 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('0 1 0 24 24 -1 0 0 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('0 1 0 1 24 -1 0 0 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('0 1 18 24 -1 0 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('0 1 18 1 24 -1 0 0 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('0 1 2 24 -1 0 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('0 1 2 1 24 -1 0 0 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('0 18 1 24 -1 0 0 0 0 -1 4 15');
INSERT INTO us_rules (rule) VALUES ('0 18 14 24 -1 0 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('0 18 24 24 -1 0 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('0 18 24 24 24 -1 0 0 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('0 18 24 22 24 -1 0 0 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('0 18 24 18 24 -1 0 0 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('0 18 24 2 24 -1 0 0 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('0 18 24 1 24 -1 0 0 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('0 18 22 24 -1 0 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('0 18 22 24 24 -1 0 0 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('0 18 22 24 24 24 -1 0 0 0 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('0 18 22 24 1 24 -1 0 0 0 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('0 18 22 22 24 -1 0 0 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('0 18 22 2 24 -1 0 0 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('0 18 22 1 24 -1 0 0 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('0 18 18 24 -1 0 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('0 18 18 13 18 24 -1 0 0 0 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('0 18 18 24 24 -1 0 0 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('0 18 18 18 24 -1 0 0 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('0 18 18 18 18 24 -1 0 0 0 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('0 18 18 18 2 24 -1 0 0 0 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('0 18 18 18 1 24 -1 0 0 0 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('0 18 18 2 24 -1 0 0 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('0 18 18 1 24 -1 0 0 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('0 18 18 1 24 24 -1 0 0 0 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('0 18 2 24 -1 0 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('0 18 2 22 24 -1 0 0 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('0 18 2 0 24 -1 0 0 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('0 18 2 18 24 -1 0 0 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('0 18 2 2 24 -1 0 0 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('0 18 2 1 24 -1 0 0 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('0 18 1 13 1 24 -1 0 0 0 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('0 18 1 24 24 24 -1 0 0 0 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('0 18 1 24 22 24 -1 0 0 0 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('0 18 1 24 2 24 -1 0 0 0 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('0 18 1 24 1 24 -1 0 0 0 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('0 18 1 22 24 -1 0 0 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('0 18 1 22 24 24 -1 0 0 0 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('0 18 1 0 24 -1 0 0 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('0 18 1 0 24 24 -1 0 0 0 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('0 18 1 0 1 24 -1 0 0 0 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('0 18 1 18 24 -1 0 0 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('0 18 1 18 1 24 -1 0 0 0 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('0 18 1 2 24 -1 0 0 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('0 18 1 2 1 24 -1 0 0 0 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('0 25 1 24 -1 0 0 0 0 -1 4 15');
INSERT INTO us_rules (rule) VALUES ('0 25 14 24 -1 0 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('0 25 24 24 -1 0 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('0 25 24 24 24 -1 0 0 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('0 25 24 22 24 -1 0 0 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('0 25 24 18 24 -1 0 0 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('0 25 24 2 24 -1 0 0 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('0 25 24 1 24 -1 0 0 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('0 25 22 24 -1 0 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('0 25 22 24 24 -1 0 0 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('0 25 22 24 24 24 -1 0 0 0 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('0 25 22 24 1 24 -1 0 0 0 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('0 25 22 22 24 -1 0 0 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('0 25 22 2 24 -1 0 0 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('0 25 22 1 24 -1 0 0 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('0 25 18 24 -1 0 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('0 25 18 13 18 24 -1 0 0 0 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('0 25 18 24 24 -1 0 0 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('0 25 18 18 24 -1 0 0 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('0 25 18 18 18 24 -1 0 0 0 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('0 25 18 18 2 24 -1 0 0 0 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('0 25 18 18 1 24 -1 0 0 0 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('0 25 18 2 24 -1 0 0 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('0 25 18 1 24 -1 0 0 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('0 25 18 1 24 24 -1 0 0 0 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('0 25 2 24 -1 0 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('0 25 2 22 24 -1 0 0 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('0 25 2 0 24 -1 0 0 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('0 25 2 18 24 -1 0 0 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('0 25 2 2 24 -1 0 0 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('0 25 2 1 24 -1 0 0 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('0 25 1 13 1 24 -1 0 0 0 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('0 25 1 24 24 24 -1 0 0 0 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('0 25 1 24 22 24 -1 0 0 0 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('0 25 1 24 2 24 -1 0 0 0 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('0 25 1 24 1 24 -1 0 0 0 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('0 25 1 22 24 -1 0 0 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('0 25 1 22 24 24 -1 0 0 0 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('0 25 1 0 24 -1 0 0 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('0 25 1 0 24 24 -1 0 0 0 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('0 25 1 0 1 24 -1 0 0 0 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('0 25 1 18 24 -1 0 0 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('0 25 1 18 1 24 -1 0 0 0 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('0 25 1 2 24 -1 0 0 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('0 25 1 2 1 24 -1 0 0 0 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('18 0 1 24 -1 0 0 0 0 -1 4 15');
INSERT INTO us_rules (rule) VALUES ('18 0 14 24 -1 0 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('18 0 24 24 -1 0 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('18 0 24 24 24 -1 0 0 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('18 0 24 22 24 -1 0 0 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('18 0 24 18 24 -1 0 0 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('18 0 24 2 24 -1 0 0 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('18 0 24 1 24 -1 0 0 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('18 0 22 24 -1 0 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('18 0 22 24 24 -1 0 0 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('18 0 22 24 24 24 -1 0 0 0 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('18 0 22 24 1 24 -1 0 0 0 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('18 0 22 22 24 -1 0 0 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('18 0 22 2 24 -1 0 0 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('18 0 22 1 24 -1 0 0 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('18 0 18 24 -1 0 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('18 0 18 13 18 24 -1 0 0 0 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('18 0 18 24 24 -1 0 0 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('18 0 18 18 24 -1 0 0 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('18 0 18 18 18 24 -1 0 0 0 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('18 0 18 18 2 24 -1 0 0 0 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('18 0 18 18 1 24 -1 0 0 0 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('18 0 18 2 24 -1 0 0 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('18 0 18 1 24 -1 0 0 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('18 0 18 1 24 24 -1 0 0 0 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('18 0 2 24 -1 0 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('18 0 2 22 24 -1 0 0 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('18 0 2 0 24 -1 0 0 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('18 0 2 18 24 -1 0 0 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('18 0 2 2 24 -1 0 0 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('18 0 2 1 24 -1 0 0 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('18 0 1 13 1 24 -1 0 0 0 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('18 0 1 24 24 24 -1 0 0 0 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('18 0 1 24 22 24 -1 0 0 0 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('18 0 1 24 2 24 -1 0 0 0 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('18 0 1 24 1 24 -1 0 0 0 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('18 0 1 22 24 -1 0 0 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('18 0 1 22 24 24 -1 0 0 0 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('18 0 1 0 24 -1 0 0 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('18 0 1 0 24 24 -1 0 0 0 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('18 0 1 0 1 24 -1 0 0 0 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('18 0 1 18 24 -1 0 0 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('18 0 1 18 1 24 -1 0 0 0 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('18 0 1 2 24 -1 0 0 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('18 0 1 2 1 24 -1 0 0 0 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('19 -1 0 -1 4 2');
INSERT INTO us_rules (rule) VALUES ('19 1 -1 0 0 -1 4 6');
INSERT INTO us_rules (rule) VALUES ('19 24 1 -1 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('19 24 1 0 -1 0 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('19 23 -1 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('19 0 -1 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('19 0 24 -1 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('19 0 1 -1 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('19 18 -1 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('19 2 0 -1 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('19 1 0 -1 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('0 19 -1 0 0 -1 4 2');
INSERT INTO us_rules (rule) VALUES ('0 19 1 -1 0 0 0 -1 4 6');
INSERT INTO us_rules (rule) VALUES ('0 19 24 1 -1 0 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('0 19 24 1 0 -1 0 0 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('0 19 23 -1 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('0 19 0 -1 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('0 19 0 24 -1 0 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('0 19 0 1 -1 0 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('0 19 18 -1 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('0 19 2 0 -1 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('0 19 1 0 -1 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('0 18 19 -1 0 0 0 -1 4 2');
INSERT INTO us_rules (rule) VALUES ('0 18 19 1 -1 0 0 0 0 -1 4 6');
INSERT INTO us_rules (rule) VALUES ('0 18 19 24 1 -1 0 0 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('0 18 19 24 1 0 -1 0 0 0 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('0 18 19 23 -1 0 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('0 18 19 0 -1 0 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('0 18 19 0 24 -1 0 0 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('0 18 19 0 1 -1 0 0 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('0 18 19 18 -1 0 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('0 18 19 2 0 -1 0 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('0 18 19 1 0 -1 0 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('0 25 19 -1 0 0 0 -1 4 2');
INSERT INTO us_rules (rule) VALUES ('0 25 19 1 -1 0 0 0 0 -1 4 6');
INSERT INTO us_rules (rule) VALUES ('0 25 19 24 1 -1 0 0 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('0 25 19 24 1 0 -1 0 0 0 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('0 25 19 23 -1 0 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('0 25 19 0 -1 0 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('0 25 19 0 24 -1 0 0 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('0 25 19 0 1 -1 0 0 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('0 25 19 18 -1 0 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('0 25 19 2 0 -1 0 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('0 25 19 1 0 -1 0 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('18 0 19 -1 0 0 0 -1 4 2');
INSERT INTO us_rules (rule) VALUES ('18 0 19 1 -1 0 0 0 0 -1 4 6');
INSERT INTO us_rules (rule) VALUES ('18 0 19 24 1 -1 0 0 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('18 0 19 24 1 0 -1 0 0 0 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('18 0 19 23 -1 0 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('18 0 19 0 -1 0 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('18 0 19 0 24 -1 0 0 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('18 0 19 0 1 -1 0 0 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('18 0 19 18 -1 0 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('18 0 19 2 0 -1 0 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('18 0 19 1 0 -1 0 0 0 0 -1 4 10');
INSERT INTO us_rules (rule) VALUES ('23 -1 17 -1 4 7');
INSERT INTO us_rules (rule) VALUES ('0 -1 17 -1 4 7');
INSERT INTO us_rules (rule) VALUES ('18 -1 17 -1 4 7');
INSERT INTO us_rules (rule) VALUES ('18 0 -1 17 17 -1 4 7');
INSERT INTO us_rules (rule) VALUES ('18 18 -1 17 17 -1 4 7');
INSERT INTO us_rules (rule) VALUES ('18 0 18 -1 17 17 17 -1 4 7');
INSERT INTO us_rules (rule) VALUES ('21 -1 17 -1 4 7');
INSERT INTO us_rules (rule) VALUES ('21 0 -1 17 17 -1 4 7');
INSERT INTO us_rules (rule) VALUES ('25 -1 17 -1 4 7');
INSERT INTO us_rules (rule) VALUES ('0 21 -1 17 17 -1 4 7');
INSERT INTO us_rules (rule) VALUES ('0 0 -1 17 17 -1 4 7');
INSERT INTO us_rules (rule) VALUES ('0 18 -1 17 17 -1 4 7');
INSERT INTO us_rules (rule) VALUES ('0 1 -1 17 17 -1 4 7');
INSERT INTO us_rules (rule) VALUES ('1 -1 17 -1 4 7');
INSERT INTO us_rules (rule) VALUES ('16 -1 16 -1 4 7');
INSERT INTO us_rules (rule) VALUES ('16 23 -1 16 17 -1 4 17');
INSERT INTO us_rules (rule) VALUES ('16 0 -1 16 17 -1 4 17');
INSERT INTO us_rules (rule) VALUES ('16 18 -1 16 17 -1 4 11');
INSERT INTO us_rules (rule) VALUES ('16 18 0 -1 16 17 17 -1 4 7');
INSERT INTO us_rules (rule) VALUES ('16 18 18 -1 16 17 17 -1 4 7');
INSERT INTO us_rules (rule) VALUES ('16 18 0 18 -1 16 17 17 17 -1 4 7');
INSERT INTO us_rules (rule) VALUES ('16 21 -1 16 17 -1 4 7');
INSERT INTO us_rules (rule) VALUES ('16 21 0 -1 16 17 17 -1 4 7');
INSERT INTO us_rules (rule) VALUES ('16 25 -1 16 17 -1 4 7');
INSERT INTO us_rules (rule) VALUES ('16 0 21 -1 16 17 17 -1 4 7');
INSERT INTO us_rules (rule) VALUES ('16 0 0 -1 16 17 17 -1 4 7');
INSERT INTO us_rules (rule) VALUES ('16 0 18 -1 16 17 17 -1 4 7');
INSERT INTO us_rules (rule) VALUES ('16 0 1 -1 16 17 17 -1 4 7');
INSERT INTO us_rules (rule) VALUES ('16 1 -1 16 17 -1 4 7');
INSERT INTO us_rules (rule) VALUES ('16 16 -1 16 16 -1 4 7');
INSERT INTO us_rules (rule) VALUES ('16 16 23 -1 16 16 17 -1 4 17');
INSERT INTO us_rules (rule) VALUES ('16 16 0 -1 16 16 17 -1 4 17');
INSERT INTO us_rules (rule) VALUES ('16 16 18 -1 16 16 17 -1 4 11');
INSERT INTO us_rules (rule) VALUES ('16 16 18 0 -1 16 16 17 17 -1 4 7');
INSERT INTO us_rules (rule) VALUES ('16 16 18 18 -1 16 16 17 17 -1 4 7');
INSERT INTO us_rules (rule) VALUES ('16 16 18 0 18 -1 16 16 17 17 17 -1 4 7');
INSERT INTO us_rules (rule) VALUES ('16 16 21 -1 16 16 17 -1 4 7');
INSERT INTO us_rules (rule) VALUES ('16 16 21 0 -1 16 16 17 17 -1 4 7');
INSERT INTO us_rules (rule) VALUES ('16 16 25 -1 16 16 17 -1 4 7');
INSERT INTO us_rules (rule) VALUES ('16 16 0 21 -1 16 16 17 17 -1 4 7');
INSERT INTO us_rules (rule) VALUES ('16 16 0 0 -1 16 16 17 17 -1 4 7');
INSERT INTO us_rules (rule) VALUES ('16 16 0 18 -1 16 16 17 17 -1 4 7');
INSERT INTO us_rules (rule) VALUES ('16 16 0 1 -1 16 16 17 17 -1 4 7');
INSERT INTO us_rules (rule) VALUES ('16 16 1 -1 16 16 17 -1 4 7');
INSERT INTO us_rules (rule) VALUES ('17 -1 17 -1 4 17');
INSERT INTO us_rules (rule) VALUES ('17 23 -1 17 17 -1 4 17');
INSERT INTO us_rules (rule) VALUES ('17 0 -1 17 17 -1 4 17');
INSERT INTO us_rules (rule) VALUES ('17 18 -1 17 17 -1 4 17');
INSERT INTO us_rules (rule) VALUES ('17 18 0 -1 17 17 17 -1 4 17');
INSERT INTO us_rules (rule) VALUES ('17 18 18 -1 17 17 17 -1 4 17');
INSERT INTO us_rules (rule) VALUES ('17 18 0 18 -1 17 17 17 17 -1 4 17');
INSERT INTO us_rules (rule) VALUES ('17 21 -1 17 17 -1 4 17');
INSERT INTO us_rules (rule) VALUES ('17 21 0 -1 17 17 17 -1 4 17');
INSERT INTO us_rules (rule) VALUES ('17 25 -1 17 17 -1 4 17');
INSERT INTO us_rules (rule) VALUES ('17 0 21 -1 17 17 17 -1 4 17');
INSERT INTO us_rules (rule) VALUES ('17 0 0 -1 17 17 17 -1 4 17');
INSERT INTO us_rules (rule) VALUES ('17 0 18 -1 17 17 17 -1 4 17');
INSERT INTO us_rules (rule) VALUES ('17 0 1 -1 17 17 17 -1 4 17');
INSERT INTO us_rules (rule) VALUES ('17 1 -1 17 17 -1 4 17');
INSERT INTO us_rules (rule) VALUES ('17 16 -1 17 16 -1 4 17');
INSERT INTO us_rules (rule) VALUES ('17 16 23 -1 17 16 17 -1 4 17');
INSERT INTO us_rules (rule) VALUES ('17 16 0 -1 17 16 17 -1 4 17');
INSERT INTO us_rules (rule) VALUES ('17 16 18 -1 17 16 17 -1 4 17');
INSERT INTO us_rules (rule) VALUES ('17 16 18 0 -1 17 16 17 17 -1 4 17');
INSERT INTO us_rules (rule) VALUES ('17 16 18 18 -1 17 16 17 17 -1 4 17');
INSERT INTO us_rules (rule) VALUES ('17 16 18 0 18 -1 17 16 17 17 17 -1 4 17');
INSERT INTO us_rules (rule) VALUES ('17 16 21 -1 17 16 17 -1 4 17');
INSERT INTO us_rules (rule) VALUES ('17 16 21 0 -1 17 16 17 17 -1 4 17');
INSERT INTO us_rules (rule) VALUES ('17 16 25 -1 17 16 17 -1 4 17');
INSERT INTO us_rules (rule) VALUES ('17 16 0 21 -1 17 16 17 17 -1 4 17');
INSERT INTO us_rules (rule) VALUES ('17 16 0 0 -1 17 16 17 17 -1 4 17');
INSERT INTO us_rules (rule) VALUES ('17 16 0 18 -1 17 16 17 17 -1 4 17');
INSERT INTO us_rules (rule) VALUES ('17 16 0 1 -1 17 16 17 17 -1 4 17');
INSERT INTO us_rules (rule) VALUES ('17 16 1 -1 17 16 17 -1 4 17');
INSERT INTO us_rules (rule) VALUES ('17 16 16 -1 17 16 16 -1 4 17');
INSERT INTO us_rules (rule) VALUES ('17 16 16 23 -1 17 16 16 17 -1 4 17');
INSERT INTO us_rules (rule) VALUES ('17 16 16 0 -1 17 16 16 17 -1 4 17');
INSERT INTO us_rules (rule) VALUES ('17 16 16 18 -1 17 16 16 17 -1 4 17');
INSERT INTO us_rules (rule) VALUES ('17 16 16 18 0 -1 17 16 16 17 17 -1 4 17');
INSERT INTO us_rules (rule) VALUES ('17 16 16 18 18 -1 17 16 16 17 17 -1 4 17');
INSERT INTO us_rules (rule) VALUES ('17 16 16 18 0 18 -1 17 16 16 17 17 17 -1 4 17');
INSERT INTO us_rules (rule) VALUES ('17 16 16 21 -1 17 16 16 17 -1 4 17');
INSERT INTO us_rules (rule) VALUES ('17 16 16 21 0 -1 17 16 16 17 17 -1 4 17');
INSERT INTO us_rules (rule) VALUES ('17 16 16 25 -1 17 16 16 17 -1 4 17');
INSERT INTO us_rules (rule) VALUES ('17 16 16 0 21 -1 17 16 16 17 17 -1 4 17');
INSERT INTO us_rules (rule) VALUES ('17 16 16 0 0 -1 17 16 16 17 17 -1 4 17');
INSERT INTO us_rules (rule) VALUES ('17 16 16 0 18 -1 17 16 16 17 17 -1 4 17');
INSERT INTO us_rules (rule) VALUES ('17 16 16 0 1 -1 17 16 16 17 17 -1 4 17');
INSERT INTO us_rules (rule) VALUES ('17 16 16 1 -1 17 16 16 17 -1 4 17');
INSERT INTO us_rules (rule) VALUES ('15 17 -1 17 17 -1 4 8');
INSERT INTO us_rules (rule) VALUES ('15 17 23 -1 17 17 17 -1 4 8');
INSERT INTO us_rules (rule) VALUES ('15 17 0 -1 17 17 17 -1 4 8');
INSERT INTO us_rules (rule) VALUES ('15 17 18 -1 17 17 17 -1 4 8');
INSERT INTO us_rules (rule) VALUES ('15 17 18 0 -1 17 17 17 17 -1 4 8');
INSERT INTO us_rules (rule) VALUES ('15 17 18 18 -1 17 17 17 17 -1 4 8');
INSERT INTO us_rules (rule) VALUES ('15 17 18 0 18 -1 17 17 17 17 17 -1 4 8');
INSERT INTO us_rules (rule) VALUES ('15 17 21 -1 17 17 17 -1 4 8');
INSERT INTO us_rules (rule) VALUES ('15 17 21 0 -1 17 17 17 17 -1 4 8');
INSERT INTO us_rules (rule) VALUES ('15 17 25 -1 17 17 17 -1 4 8');
INSERT INTO us_rules (rule) VALUES ('15 17 0 21 -1 17 17 17 17 -1 4 8');
INSERT INTO us_rules (rule) VALUES ('15 17 0 0 -1 17 17 17 17 -1 4 8');
INSERT INTO us_rules (rule) VALUES ('15 17 0 18 -1 17 17 17 17 -1 4 8');
INSERT INTO us_rules (rule) VALUES ('15 17 0 1 -1 17 17 17 17 -1 4 8');
INSERT INTO us_rules (rule) VALUES ('15 17 1 -1 17 17 17 -1 4 8');
INSERT INTO us_rules (rule) VALUES ('15 17 16 -1 17 17 16 -1 4 8');
INSERT INTO us_rules (rule) VALUES ('15 17 16 23 -1 17 17 16 17 -1 4 8');
INSERT INTO us_rules (rule) VALUES ('15 17 16 0 -1 17 17 16 17 -1 4 8');
INSERT INTO us_rules (rule) VALUES ('15 17 16 18 -1 17 17 16 17 -1 4 8');
INSERT INTO us_rules (rule) VALUES ('15 17 16 18 0 -1 17 17 16 17 17 -1 4 8');
INSERT INTO us_rules (rule) VALUES ('15 17 16 18 18 -1 17 17 16 17 17 -1 4 8');
INSERT INTO us_rules (rule) VALUES ('15 17 16 18 0 18 -1 17 17 16 17 17 17 -1 4 8');
INSERT INTO us_rules (rule) VALUES ('15 17 16 21 -1 17 17 16 17 -1 4 8');
INSERT INTO us_rules (rule) VALUES ('15 17 16 21 0 -1 17 17 16 17 17 -1 4 8');
INSERT INTO us_rules (rule) VALUES ('15 17 16 25 -1 17 17 16 17 -1 4 8');
INSERT INTO us_rules (rule) VALUES ('15 17 16 0 21 -1 17 17 16 17 17 -1 4 8');
INSERT INTO us_rules (rule) VALUES ('15 17 16 0 0 -1 17 17 16 17 17 -1 4 8');
INSERT INTO us_rules (rule) VALUES ('15 17 16 0 18 -1 17 17 16 17 17 -1 4 8');
INSERT INTO us_rules (rule) VALUES ('15 17 16 0 1 -1 17 17 16 17 17 -1 4 8');
INSERT INTO us_rules (rule) VALUES ('15 17 16 1 -1 17 17 16 17 -1 4 8');
INSERT INTO us_rules (rule) VALUES ('15 17 16 16 -1 17 17 16 16 -1 4 8');
INSERT INTO us_rules (rule) VALUES ('15 17 16 16 23 -1 17 17 16 16 17 -1 4 8');
INSERT INTO us_rules (rule) VALUES ('15 17 16 16 0 -1 17 17 16 16 17 -1 4 8');
INSERT INTO us_rules (rule) VALUES ('15 17 16 16 18 -1 17 17 16 16 17 -1 4 8');
INSERT INTO us_rules (rule) VALUES ('15 17 16 16 18 0 -1 17 17 16 16 17 17 -1 4 8');
INSERT INTO us_rules (rule) VALUES ('15 17 16 16 18 18 -1 17 17 16 16 17 17 -1 4 8');
INSERT INTO us_rules (rule) VALUES ('15 17 16 16 18 0 18 -1 17 17 16 16 17 17 17 -1 4 8');
INSERT INTO us_rules (rule) VALUES ('15 17 16 16 21 -1 17 17 16 16 17 -1 4 8');
INSERT INTO us_rules (rule) VALUES ('15 17 16 16 21 0 -1 17 17 16 16 17 17 -1 4 8');
INSERT INTO us_rules (rule) VALUES ('15 17 16 16 25 -1 17 17 16 16 17 -1 4 8');
INSERT INTO us_rules (rule) VALUES ('15 17 16 16 0 21 -1 17 17 16 16 17 17 -1 4 8');
INSERT INTO us_rules (rule) VALUES ('15 17 16 16 0 0 -1 17 17 16 16 17 17 -1 4 8');
INSERT INTO us_rules (rule) VALUES ('15 17 16 16 0 18 -1 17 17 16 16 17 17 -1 4 8');
INSERT INTO us_rules (rule) VALUES ('15 17 16 16 0 1 -1 17 17 16 16 17 17 -1 4 8');
INSERT INTO us_rules (rule) VALUES ('15 17 16 16 1 -1 17 17 16 16 17 -1 4 8');
INSERT INTO us_rules (rule) VALUES ('17 17 -1 17 17 -1 4 16');
INSERT INTO us_rules (rule) VALUES ('17 17 23 -1 17 17 17 -1 4 16');
INSERT INTO us_rules (rule) VALUES ('17 17 0 -1 17 17 17 -1 4 16');
INSERT INTO us_rules (rule) VALUES ('17 17 18 -1 17 17 17 -1 4 16');
INSERT INTO us_rules (rule) VALUES ('17 17 18 0 -1 17 17 17 17 -1 4 16');
INSERT INTO us_rules (rule) VALUES ('17 17 18 18 -1 17 17 17 17 -1 4 16');
INSERT INTO us_rules (rule) VALUES ('17 17 18 0 18 -1 17 17 17 17 17 -1 4 16');
INSERT INTO us_rules (rule) VALUES ('17 17 21 -1 17 17 17 -1 4 16');
INSERT INTO us_rules (rule) VALUES ('17 17 21 0 -1 17 17 17 17 -1 4 16');
INSERT INTO us_rules (rule) VALUES ('17 17 25 -1 17 17 17 -1 4 16');
INSERT INTO us_rules (rule) VALUES ('17 17 0 21 -1 17 17 17 17 -1 4 16');
INSERT INTO us_rules (rule) VALUES ('17 17 0 0 -1 17 17 17 17 -1 4 16');
INSERT INTO us_rules (rule) VALUES ('17 17 0 18 -1 17 17 17 17 -1 4 16');
INSERT INTO us_rules (rule) VALUES ('17 17 0 1 -1 17 17 17 17 -1 4 16');
INSERT INTO us_rules (rule) VALUES ('17 17 1 -1 17 17 17 -1 4 16');
INSERT INTO us_rules (rule) VALUES ('17 17 16 -1 17 17 16 -1 4 16');
INSERT INTO us_rules (rule) VALUES ('17 17 16 23 -1 17 17 16 17 -1 4 16');
INSERT INTO us_rules (rule) VALUES ('17 17 16 0 -1 17 17 16 17 -1 4 16');
INSERT INTO us_rules (rule) VALUES ('17 17 16 18 -1 17 17 16 17 -1 4 16');
INSERT INTO us_rules (rule) VALUES ('17 17 16 18 0 -1 17 17 16 17 17 -1 4 16');
INSERT INTO us_rules (rule) VALUES ('17 17 16 18 18 -1 17 17 16 17 17 -1 4 16');
INSERT INTO us_rules (rule) VALUES ('17 17 16 18 0 18 -1 17 17 16 17 17 17 -1 4 16');
INSERT INTO us_rules (rule) VALUES ('17 17 16 21 -1 17 17 16 17 -1 4 16');
INSERT INTO us_rules (rule) VALUES ('17 17 16 21 0 -1 17 17 16 17 17 -1 4 16');
INSERT INTO us_rules (rule) VALUES ('17 17 16 25 -1 17 17 16 17 -1 4 16');
INSERT INTO us_rules (rule) VALUES ('17 17 16 0 21 -1 17 17 16 17 17 -1 4 16');
INSERT INTO us_rules (rule) VALUES ('17 17 16 0 0 -1 17 17 16 17 17 -1 4 16');
INSERT INTO us_rules (rule) VALUES ('17 17 16 0 18 -1 17 17 16 17 17 -1 4 16');
INSERT INTO us_rules (rule) VALUES ('17 17 16 0 1 -1 17 17 16 17 17 -1 4 16');
INSERT INTO us_rules (rule) VALUES ('17 17 16 1 -1 17 17 16 17 -1 4 16');
INSERT INTO us_rules (rule) VALUES ('17 17 16 16 -1 17 17 16 16 -1 4 16');
INSERT INTO us_rules (rule) VALUES ('17 17 16 16 23 -1 17 17 16 16 17 -1 4 16');
INSERT INTO us_rules (rule) VALUES ('17 17 16 16 0 -1 17 17 16 16 17 -1 4 16');
INSERT INTO us_rules (rule) VALUES ('17 17 16 16 18 -1 17 17 16 16 17 -1 4 16');
INSERT INTO us_rules (rule) VALUES ('17 17 16 16 18 0 -1 17 17 16 16 17 17 -1 4 16');
INSERT INTO us_rules (rule) VALUES ('17 17 16 16 18 18 -1 17 17 16 16 17 17 -1 4 16');
INSERT INTO us_rules (rule) VALUES ('17 17 16 16 18 0 18 -1 17 17 16 16 17 17 17 -1 4 16');
INSERT INTO us_rules (rule) VALUES ('17 17 16 16 21 -1 17 17 16 16 17 -1 4 16');
INSERT INTO us_rules (rule) VALUES ('17 17 16 16 21 0 -1 17 17 16 16 17 17 -1 4 16');
INSERT INTO us_rules (rule) VALUES ('17 17 16 16 25 -1 17 17 16 16 17 -1 4 16');
INSERT INTO us_rules (rule) VALUES ('17 17 16 16 0 21 -1 17 17 16 16 17 17 -1 4 16');
INSERT INTO us_rules (rule) VALUES ('17 17 16 16 0 0 -1 17 17 16 16 17 17 -1 4 16');
INSERT INTO us_rules (rule) VALUES ('17 17 16 16 0 18 -1 17 17 16 16 17 17 -1 4 16');
INSERT INTO us_rules (rule) VALUES ('17 17 16 16 0 1 -1 17 17 16 16 17 17 -1 4 16');
INSERT INTO us_rules (rule) VALUES ('17 17 16 16 1 -1 17 17 16 16 17 -1 4 16');
INSERT INTO us_rules (rule) VALUES ('17 -1 17 -1 4 8');
INSERT INTO us_rules (rule) VALUES ('15 17 -1 17 17 -1 4 8');
INSERT INTO us_rules (rule) VALUES ('17 17 -1 17 17 -1 4 8');
INSERT INTO us_rules (rule) VALUES ('23 17 -1 17 17 -1 4 8');
INSERT INTO us_rules (rule) VALUES ('23 15 17 -1 17 17 17 -1 4 8');
INSERT INTO us_rules (rule) VALUES ('23 17 17 -1 17 17 17 -1 4 8');
INSERT INTO us_rules (rule) VALUES ('0 17 -1 17 17 -1 4 8');
INSERT INTO us_rules (rule) VALUES ('0 15 17 -1 17 17 17 -1 4 8');
INSERT INTO us_rules (rule) VALUES ('0 17 17 -1 17 17 17 -1 4 8');
INSERT INTO us_rules (rule) VALUES ('18 17 -1 17 17 -1 4 8');
INSERT INTO us_rules (rule) VALUES ('18 15 17 -1 17 17 17 -1 4 8');
INSERT INTO us_rules (rule) VALUES ('18 17 17 -1 17 17 17 -1 4 8');
INSERT INTO us_rules (rule) VALUES ('18 0 17 -1 17 17 17 -1 4 8');
INSERT INTO us_rules (rule) VALUES ('18 0 15 17 -1 17 17 17 17 -1 4 8');
INSERT INTO us_rules (rule) VALUES ('18 0 17 17 -1 17 17 17 17 -1 4 8');
INSERT INTO us_rules (rule) VALUES ('18 18 17 -1 17 17 17 -1 4 8');
INSERT INTO us_rules (rule) VALUES ('18 18 15 17 -1 17 17 17 17 -1 4 8');
INSERT INTO us_rules (rule) VALUES ('18 18 17 17 -1 17 17 17 17 -1 4 8');
INSERT INTO us_rules (rule) VALUES ('18 0 18 17 -1 17 17 17 17 -1 4 8');
INSERT INTO us_rules (rule) VALUES ('18 0 18 15 17 -1 17 17 17 17 17 -1 4 8');
INSERT INTO us_rules (rule) VALUES ('18 0 18 17 17 -1 17 17 17 17 17 -1 4 8');
INSERT INTO us_rules (rule) VALUES ('21 17 -1 17 17 -1 4 8');
INSERT INTO us_rules (rule) VALUES ('21 15 17 -1 17 17 17 -1 4 8');
INSERT INTO us_rules (rule) VALUES ('21 17 17 -1 17 17 17 -1 4 8');
INSERT INTO us_rules (rule) VALUES ('21 0 17 -1 17 17 17 -1 4 8');
INSERT INTO us_rules (rule) VALUES ('21 0 15 17 -1 17 17 17 17 -1 4 8');
INSERT INTO us_rules (rule) VALUES ('21 0 17 17 -1 17 17 17 17 -1 4 8');
INSERT INTO us_rules (rule) VALUES ('25 17 -1 17 17 -1 4 8');
INSERT INTO us_rules (rule) VALUES ('25 15 17 -1 17 17 17 -1 4 8');
INSERT INTO us_rules (rule) VALUES ('25 17 17 -1 17 17 17 -1 4 8');
INSERT INTO us_rules (rule) VALUES ('0 21 17 -1 17 17 17 -1 4 8');
INSERT INTO us_rules (rule) VALUES ('0 21 15 17 -1 17 17 17 17 -1 4 8');
INSERT INTO us_rules (rule) VALUES ('0 21 17 17 -1 17 17 17 17 -1 4 8');
INSERT INTO us_rules (rule) VALUES ('0 0 17 -1 17 17 17 -1 4 8');
INSERT INTO us_rules (rule) VALUES ('0 0 15 17 -1 17 17 17 17 -1 4 8');
INSERT INTO us_rules (rule) VALUES ('0 0 17 17 -1 17 17 17 17 -1 4 8');
INSERT INTO us_rules (rule) VALUES ('0 18 17 -1 17 17 17 -1 4 8');
INSERT INTO us_rules (rule) VALUES ('0 18 15 17 -1 17 17 17 17 -1 4 8');
INSERT INTO us_rules (rule) VALUES ('0 18 17 17 -1 17 17 17 17 -1 4 8');
INSERT INTO us_rules (rule) VALUES ('0 1 17 -1 17 17 17 -1 4 8');
INSERT INTO us_rules (rule) VALUES ('0 1 15 17 -1 17 17 17 17 -1 4 8');
INSERT INTO us_rules (rule) VALUES ('0 1 17 17 -1 17 17 17 17 -1 4 8');
INSERT INTO us_rules (rule) VALUES ('1 17 -1 17 17 -1 4 8');
INSERT INTO us_rules (rule) VALUES ('1 15 17 -1 17 17 17 -1 4 8');
INSERT INTO us_rules (rule) VALUES ('1 17 17 -1 17 17 17 -1 4 8');
INSERT INTO us_rules (rule) VALUES ('16 17 -1 16 17 -1 4 8');
INSERT INTO us_rules (rule) VALUES ('16 15 17 -1 16 17 17 -1 4 8');
INSERT INTO us_rules (rule) VALUES ('16 17 17 -1 16 17 17 -1 4 8');
INSERT INTO us_rules (rule) VALUES ('16 23 17 -1 16 17 17 -1 4 8');
INSERT INTO us_rules (rule) VALUES ('16 23 15 17 -1 16 17 17 17 -1 4 8');
INSERT INTO us_rules (rule) VALUES ('16 23 17 17 -1 16 17 17 17 -1 4 8');
INSERT INTO us_rules (rule) VALUES ('16 0 17 -1 16 17 17 -1 4 8');
INSERT INTO us_rules (rule) VALUES ('16 0 15 17 -1 16 17 17 17 -1 4 8');
INSERT INTO us_rules (rule) VALUES ('16 0 17 17 -1 16 17 17 17 -1 4 8');
INSERT INTO us_rules (rule) VALUES ('16 18 17 -1 16 17 17 -1 4 8');
INSERT INTO us_rules (rule) VALUES ('16 18 15 17 -1 16 17 17 17 -1 4 8');
INSERT INTO us_rules (rule) VALUES ('16 18 17 17 -1 16 17 17 17 -1 4 8');
INSERT INTO us_rules (rule) VALUES ('16 18 0 17 -1 16 17 17 17 -1 4 8');
INSERT INTO us_rules (rule) VALUES ('16 18 0 15 17 -1 16 17 17 17 17 -1 4 8');
INSERT INTO us_rules (rule) VALUES ('16 18 0 17 17 -1 16 17 17 17 17 -1 4 8');
INSERT INTO us_rules (rule) VALUES ('16 18 18 17 -1 16 17 17 17 -1 4 8');
INSERT INTO us_rules (rule) VALUES ('16 18 18 15 17 -1 16 17 17 17 17 -1 4 8');
INSERT INTO us_rules (rule) VALUES ('16 18 18 17 17 -1 16 17 17 17 17 -1 4 8');
INSERT INTO us_rules (rule) VALUES ('16 18 0 18 17 -1 16 17 17 17 17 -1 4 8');
INSERT INTO us_rules (rule) VALUES ('16 18 0 18 15 17 -1 16 17 17 17 17 17 -1 4 8');
INSERT INTO us_rules (rule) VALUES ('16 18 0 18 17 17 -1 16 17 17 17 17 17 -1 4 8');
INSERT INTO us_rules (rule) VALUES ('16 21 17 -1 16 17 17 -1 4 8');
INSERT INTO us_rules (rule) VALUES ('16 21 15 17 -1 16 17 17 17 -1 4 8');
INSERT INTO us_rules (rule) VALUES ('16 21 17 17 -1 16 17 17 17 -1 4 8');
INSERT INTO us_rules (rule) VALUES ('16 21 0 17 -1 16 17 17 17 -1 4 8');
INSERT INTO us_rules (rule) VALUES ('16 21 0 15 17 -1 16 17 17 17 17 -1 4 8');
INSERT INTO us_rules (rule) VALUES ('16 21 0 17 17 -1 16 17 17 17 17 -1 4 8');
INSERT INTO us_rules (rule) VALUES ('16 25 17 -1 16 17 17 -1 4 8');
INSERT INTO us_rules (rule) VALUES ('16 25 15 17 -1 16 17 17 17 -1 4 8');
INSERT INTO us_rules (rule) VALUES ('16 25 17 17 -1 16 17 17 17 -1 4 8');
INSERT INTO us_rules (rule) VALUES ('16 0 21 17 -1 16 17 17 17 -1 4 8');
INSERT INTO us_rules (rule) VALUES ('16 0 21 15 17 -1 16 17 17 17 17 -1 4 8');
INSERT INTO us_rules (rule) VALUES ('16 0 21 17 17 -1 16 17 17 17 17 -1 4 8');
INSERT INTO us_rules (rule) VALUES ('16 0 0 17 -1 16 17 17 17 -1 4 8');
INSERT INTO us_rules (rule) VALUES ('16 0 0 15 17 -1 16 17 17 17 17 -1 4 8');
INSERT INTO us_rules (rule) VALUES ('16 0 0 17 17 -1 16 17 17 17 17 -1 4 8');
INSERT INTO us_rules (rule) VALUES ('16 0 18 17 -1 16 17 17 17 -1 4 8');
INSERT INTO us_rules (rule) VALUES ('16 0 18 15 17 -1 16 17 17 17 17 -1 4 8');
INSERT INTO us_rules (rule) VALUES ('16 0 18 17 17 -1 16 17 17 17 17 -1 4 8');
INSERT INTO us_rules (rule) VALUES ('16 0 1 17 -1 16 17 17 17 -1 4 8');
INSERT INTO us_rules (rule) VALUES ('16 0 1 15 17 -1 16 17 17 17 17 -1 4 8');
INSERT INTO us_rules (rule) VALUES ('16 0 1 17 17 -1 16 17 17 17 17 -1 4 8');
INSERT INTO us_rules (rule) VALUES ('16 1 17 -1 16 17 17 -1 4 8');
INSERT INTO us_rules (rule) VALUES ('16 1 15 17 -1 16 17 17 17 -1 4 8');
INSERT INTO us_rules (rule) VALUES ('16 1 17 17 -1 16 17 17 17 -1 4 8');
INSERT INTO us_rules (rule) VALUES ('16 16 17 -1 16 16 17 -1 4 8');
INSERT INTO us_rules (rule) VALUES ('16 16 15 17 -1 16 16 17 17 -1 4 8');
INSERT INTO us_rules (rule) VALUES ('16 16 17 17 -1 16 16 17 17 -1 4 8');
INSERT INTO us_rules (rule) VALUES ('16 16 23 17 -1 16 16 17 17 -1 4 8');
INSERT INTO us_rules (rule) VALUES ('16 16 23 15 17 -1 16 16 17 17 17 -1 4 8');
INSERT INTO us_rules (rule) VALUES ('16 16 23 17 17 -1 16 16 17 17 17 -1 4 8');
INSERT INTO us_rules (rule) VALUES ('16 16 0 17 -1 16 16 17 17 -1 4 8');
INSERT INTO us_rules (rule) VALUES ('16 16 0 15 17 -1 16 16 17 17 17 -1 4 8');
INSERT INTO us_rules (rule) VALUES ('16 16 0 17 17 -1 16 16 17 17 17 -1 4 8');
INSERT INTO us_rules (rule) VALUES ('16 16 18 17 -1 16 16 17 17 -1 4 8');
INSERT INTO us_rules (rule) VALUES ('16 16 18 15 17 -1 16 16 17 17 17 -1 4 8');
INSERT INTO us_rules (rule) VALUES ('16 16 18 17 17 -1 16 16 17 17 17 -1 4 8');
INSERT INTO us_rules (rule) VALUES ('16 16 18 0 17 -1 16 16 17 17 17 -1 4 8');
INSERT INTO us_rules (rule) VALUES ('16 16 18 0 15 17 -1 16 16 17 17 17 17 -1 4 8');
INSERT INTO us_rules (rule) VALUES ('16 16 18 0 17 17 -1 16 16 17 17 17 17 -1 4 8');
INSERT INTO us_rules (rule) VALUES ('16 16 18 18 17 -1 16 16 17 17 17 -1 4 8');
INSERT INTO us_rules (rule) VALUES ('16 16 18 18 15 17 -1 16 16 17 17 17 17 -1 4 8');
INSERT INTO us_rules (rule) VALUES ('16 16 18 18 17 17 -1 16 16 17 17 17 17 -1 4 8');
INSERT INTO us_rules (rule) VALUES ('16 16 18 0 18 17 -1 16 16 17 17 17 17 -1 4 8');
INSERT INTO us_rules (rule) VALUES ('16 16 18 0 18 15 17 -1 16 16 17 17 17 17 17 -1 4 8');
INSERT INTO us_rules (rule) VALUES ('16 16 18 0 18 17 17 -1 16 16 17 17 17 17 17 -1 4 8');
INSERT INTO us_rules (rule) VALUES ('16 16 21 17 -1 16 16 17 17 -1 4 8');
INSERT INTO us_rules (rule) VALUES ('16 16 21 15 17 -1 16 16 17 17 17 -1 4 8');
INSERT INTO us_rules (rule) VALUES ('16 16 21 17 17 -1 16 16 17 17 17 -1 4 8');
INSERT INTO us_rules (rule) VALUES ('16 16 21 0 17 -1 16 16 17 17 17 -1 4 8');
INSERT INTO us_rules (rule) VALUES ('16 16 21 0 15 17 -1 16 16 17 17 17 17 -1 4 8');
INSERT INTO us_rules (rule) VALUES ('16 16 21 0 17 17 -1 16 16 17 17 17 17 -1 4 8');
INSERT INTO us_rules (rule) VALUES ('16 16 25 17 -1 16 16 17 17 -1 4 8');
INSERT INTO us_rules (rule) VALUES ('16 16 25 15 17 -1 16 16 17 17 17 -1 4 8');
INSERT INTO us_rules (rule) VALUES ('16 16 25 17 17 -1 16 16 17 17 17 -1 4 8');
INSERT INTO us_rules (rule) VALUES ('16 16 0 21 17 -1 16 16 17 17 17 -1 4 8');
INSERT INTO us_rules (rule) VALUES ('16 16 0 21 15 17 -1 16 16 17 17 17 17 -1 4 8');
INSERT INTO us_rules (rule) VALUES ('16 16 0 21 17 17 -1 16 16 17 17 17 17 -1 4 8');
INSERT INTO us_rules (rule) VALUES ('16 16 0 0 17 -1 16 16 17 17 17 -1 4 8');
INSERT INTO us_rules (rule) VALUES ('16 16 0 0 15 17 -1 16 16 17 17 17 17 -1 4 8');
INSERT INTO us_rules (rule) VALUES ('16 16 0 0 17 17 -1 16 16 17 17 17 17 -1 4 8');
INSERT INTO us_rules (rule) VALUES ('16 16 0 18 17 -1 16 16 17 17 17 -1 4 8');
INSERT INTO us_rules (rule) VALUES ('16 16 0 18 15 17 -1 16 16 17 17 17 17 -1 4 8');
INSERT INTO us_rules (rule) VALUES ('16 16 0 18 17 17 -1 16 16 17 17 17 17 -1 4 8');
INSERT INTO us_rules (rule) VALUES ('16 16 0 1 17 -1 16 16 17 17 17 -1 4 8');
INSERT INTO us_rules (rule) VALUES ('16 16 0 1 15 17 -1 16 16 17 17 17 17 -1 4 8');
INSERT INTO us_rules (rule) VALUES ('16 16 0 1 17 17 -1 16 16 17 17 17 17 -1 4 8');
INSERT INTO us_rules (rule) VALUES ('16 16 1 17 -1 16 16 17 17 -1 4 8');
INSERT INTO us_rules (rule) VALUES ('16 16 1 15 17 -1 16 16 17 17 17 -1 4 8');
INSERT INTO us_rules (rule) VALUES ('16 16 1 17 17 -1 16 16 17 17 17 -1 4 8');
INSERT INTO us_rules (rule) VALUES ('12 -1 12 -1 0 3');
INSERT INTO us_rules (rule) VALUES ('12 23 23 13 13 -1 12 -1 0 3');
INSERT INTO us_rules (rule) VALUES ('12 0 -1 12 13 -1 0 3');
INSERT INTO us_rules (rule) VALUES ('12 0 0 -1 12 13 13 -1 0 3');
INSERT INTO us_rules (rule) VALUES ('12 27 -1 12 13 -1 0 3');
INSERT INTO us_rules (rule) VALUES ('12 27 26 -1 12 13 13 -1 0 3');
INSERT INTO us_rules (rule) VALUES ('12 28 -1 12 13 -1 0 3');
INSERT INTO us_rules (rule) VALUES ('12 28 29 -1 12 13 13 -1 0 3');
INSERT INTO us_rules (rule) VALUES ('23 23 13 13 -1 -1 0 14');
INSERT INTO us_rules (rule) VALUES ('23 23 13 13 12 -1 12 -1 0 3');
INSERT INTO us_rules (rule) VALUES ('0 -1 13 -1 0 14');
INSERT INTO us_rules (rule) VALUES ('0 12 -1 13 12 -1 0 3');
INSERT INTO us_rules (rule) VALUES ('0 0 -1 13 13 -1 0 14');
INSERT INTO us_rules (rule) VALUES ('0 0 12 -1 13 13 12 -1 0 3');
INSERT INTO us_rules (rule) VALUES ('27 -1 13 -1 0 14');
INSERT INTO us_rules (rule) VALUES ('27 12 -1 13 12 -1 0 3');
INSERT INTO us_rules (rule) VALUES ('27 26 -1 13 13 -1 0 14');
INSERT INTO us_rules (rule) VALUES ('27 26 12 -1 13 13 12 -1 0 3');
INSERT INTO us_rules (rule) VALUES ('28 -1 13 -1 0 14');
INSERT INTO us_rules (rule) VALUES ('28 12 -1 13 12 -1 0 3');
INSERT INTO us_rules (rule) VALUES ('28 29 -1 13 13 -1 0 14');
INSERT INTO us_rules (rule) VALUES ('28 29 12 -1 13 13 12 -1 0 3');
INSERT INTO us_rules (rule) VALUES ('11 -1 11 -1 0 3');
INSERT INTO us_rules (rule) VALUES ('11 23 23 13 13 -1 11 -1 0 7');
INSERT INTO us_rules (rule) VALUES ('11 0 -1 11 13 -1 0 7');
INSERT INTO us_rules (rule) VALUES ('11 0 0 -1 11 13 13 -1 0 7');
INSERT INTO us_rules (rule) VALUES ('11 27 -1 11 13 -1 0 7');
INSERT INTO us_rules (rule) VALUES ('11 27 26 -1 11 13 13 -1 0 7');
INSERT INTO us_rules (rule) VALUES ('11 28 -1 11 13 -1 0 7');
INSERT INTO us_rules (rule) VALUES ('11 28 29 -1 11 13 13 -1 0 7');
INSERT INTO us_rules (rule) VALUES ('10 -1 10 -1 0 5');
INSERT INTO us_rules (rule) VALUES ('10 12 -1 10 12 -1 0 3');
INSERT INTO us_rules (rule) VALUES ('10 12 23 23 13 13 -1 10 12 -1 0 3');
INSERT INTO us_rules (rule) VALUES ('10 12 0 -1 10 12 13 -1 0 3');
INSERT INTO us_rules (rule) VALUES ('10 12 0 0 -1 10 12 13 13 -1 0 3');
INSERT INTO us_rules (rule) VALUES ('10 12 27 -1 10 12 13 -1 0 3');
INSERT INTO us_rules (rule) VALUES ('10 12 27 26 -1 10 12 13 13 -1 0 3');
INSERT INTO us_rules (rule) VALUES ('10 12 28 -1 10 12 13 -1 0 3');
INSERT INTO us_rules (rule) VALUES ('10 12 28 29 -1 10 12 13 13 -1 0 3');
INSERT INTO us_rules (rule) VALUES ('10 23 23 13 13 -1 10 -1 0 9');
INSERT INTO us_rules (rule) VALUES ('10 23 23 13 13 12 -1 10 12 -1 0 3');
INSERT INTO us_rules (rule) VALUES ('10 0 -1 10 13 -1 0 9');
INSERT INTO us_rules (rule) VALUES ('10 0 12 -1 10 13 12 -1 0 3');
INSERT INTO us_rules (rule) VALUES ('10 0 0 -1 10 13 13 -1 0 9');
INSERT INTO us_rules (rule) VALUES ('10 0 0 12 -1 10 13 13 12 -1 0 3');
INSERT INTO us_rules (rule) VALUES ('10 27 -1 10 13 -1 0 9');
INSERT INTO us_rules (rule) VALUES ('10 27 12 -1 10 13 12 -1 0 3');
INSERT INTO us_rules (rule) VALUES ('10 27 26 -1 10 13 13 -1 0 9');
INSERT INTO us_rules (rule) VALUES ('10 27 26 12 -1 10 13 13 12 -1 0 3');
INSERT INTO us_rules (rule) VALUES ('10 28 -1 10 13 -1 0 9');
INSERT INTO us_rules (rule) VALUES ('10 28 12 -1 10 13 12 -1 0 3');
INSERT INTO us_rules (rule) VALUES ('10 28 29 -1 10 13 13 -1 0 9');
INSERT INTO us_rules (rule) VALUES ('10 28 29 12 -1 10 13 13 12 -1 0 3');
INSERT INTO us_rules (rule) VALUES ('10 11 -1 10 11 -1 0 13');
INSERT INTO us_rules (rule) VALUES ('10 11 12 -1 10 11 12 -1 0 15');
INSERT INTO us_rules (rule) VALUES ('10 11 12 23 23 13 13 -1 10 11 12 -1 0 17');
INSERT INTO us_rules (rule) VALUES ('10 11 12 0 -1 10 11 12 13 -1 0 17');
INSERT INTO us_rules (rule) VALUES ('10 11 12 0 0 -1 10 11 12 13 13 -1 0 17');
INSERT INTO us_rules (rule) VALUES ('10 11 12 27 -1 10 11 12 13 -1 0 17');
INSERT INTO us_rules (rule) VALUES ('10 11 12 27 26 -1 10 11 12 13 13 -1 0 17');
INSERT INTO us_rules (rule) VALUES ('10 11 12 28 -1 10 11 12 13 -1 0 17');
INSERT INTO us_rules (rule) VALUES ('10 11 12 28 29 -1 10 11 12 13 13 -1 0 17');
INSERT INTO us_rules (rule) VALUES ('10 11 23 23 13 13 -1 10 11 -1 0 16');
INSERT INTO us_rules (rule) VALUES ('10 11 23 23 13 13 12 -1 10 11 12 -1 0 17');
INSERT INTO us_rules (rule) VALUES ('10 11 0 -1 10 11 13 -1 0 16');
INSERT INTO us_rules (rule) VALUES ('10 11 0 12 -1 10 11 13 12 -1 0 17');
INSERT INTO us_rules (rule) VALUES ('10 11 0 0 -1 10 11 13 13 -1 0 16');
INSERT INTO us_rules (rule) VALUES ('10 11 0 0 12 -1 10 11 13 13 12 -1 0 17');
INSERT INTO us_rules (rule) VALUES ('10 11 27 -1 10 11 13 -1 0 16');
INSERT INTO us_rules (rule) VALUES ('10 11 27 12 -1 10 11 13 12 -1 0 17');
INSERT INTO us_rules (rule) VALUES ('10 11 27 26 -1 10 11 13 13 -1 0 16');
INSERT INTO us_rules (rule) VALUES ('10 11 27 26 12 -1 10 11 13 13 12 -1 0 17');
INSERT INTO us_rules (rule) VALUES ('10 11 28 -1 10 11 13 -1 0 16');
INSERT INTO us_rules (rule) VALUES ('10 11 28 12 -1 10 11 13 12 -1 0 17');
INSERT INTO us_rules (rule) VALUES ('10 11 28 29 -1 10 11 13 13 -1 0 16');
INSERT INTO us_rules (rule) VALUES ('10 11 28 29 12 -1 10 11 13 13 12 -1 0 17');
INSERT INTO us_rules (rule) VALUES ('1 -1 10 -1 0 5');
INSERT INTO us_rules (rule) VALUES ('1 12 -1 10 12 -1 0 3');
INSERT INTO us_rules (rule) VALUES ('1 12 23 23 13 13 -1 10 12 -1 0 3');
INSERT INTO us_rules (rule) VALUES ('1 12 0 -1 10 12 13 -1 0 3');
INSERT INTO us_rules (rule) VALUES ('1 12 0 0 -1 10 12 13 13 -1 0 3');
INSERT INTO us_rules (rule) VALUES ('1 12 27 -1 10 12 13 -1 0 3');
INSERT INTO us_rules (rule) VALUES ('1 12 27 26 -1 10 12 13 13 -1 0 3');
INSERT INTO us_rules (rule) VALUES ('1 12 28 -1 10 12 13 -1 0 3');
INSERT INTO us_rules (rule) VALUES ('1 12 28 29 -1 10 12 13 13 -1 0 3');
INSERT INTO us_rules (rule) VALUES ('1 23 23 13 13 -1 10 -1 0 9');
INSERT INTO us_rules (rule) VALUES ('1 23 23 13 13 12 -1 10 12 -1 0 3');
INSERT INTO us_rules (rule) VALUES ('1 0 -1 10 13 -1 0 9');
INSERT INTO us_rules (rule) VALUES ('1 0 12 -1 10 13 12 -1 0 3');
INSERT INTO us_rules (rule) VALUES ('1 0 0 -1 10 13 13 -1 0 9');
INSERT INTO us_rules (rule) VALUES ('1 0 0 12 -1 10 13 13 12 -1 0 3');
INSERT INTO us_rules (rule) VALUES ('1 27 -1 10 13 -1 0 9');
INSERT INTO us_rules (rule) VALUES ('1 27 12 -1 10 13 12 -1 0 3');
INSERT INTO us_rules (rule) VALUES ('1 27 26 -1 10 13 13 -1 0 9');
INSERT INTO us_rules (rule) VALUES ('1 27 26 12 -1 10 13 13 12 -1 0 3');
INSERT INTO us_rules (rule) VALUES ('1 28 -1 10 13 -1 0 9');
INSERT INTO us_rules (rule) VALUES ('1 28 12 -1 10 13 12 -1 0 3');
INSERT INTO us_rules (rule) VALUES ('1 28 29 -1 10 13 13 -1 0 9');
INSERT INTO us_rules (rule) VALUES ('1 28 29 12 -1 10 13 13 12 -1 0 3');
INSERT INTO us_rules (rule) VALUES ('1 11 -1 10 11 -1 0 13');
INSERT INTO us_rules (rule) VALUES ('1 11 12 -1 10 11 12 -1 0 15');
INSERT INTO us_rules (rule) VALUES ('1 11 12 23 23 13 13 -1 10 11 12 -1 0 17');
INSERT INTO us_rules (rule) VALUES ('1 11 12 0 -1 10 11 12 13 -1 0 17');
INSERT INTO us_rules (rule) VALUES ('1 11 12 0 0 -1 10 11 12 13 13 -1 0 17');
INSERT INTO us_rules (rule) VALUES ('1 11 12 27 -1 10 11 12 13 -1 0 17');
INSERT INTO us_rules (rule) VALUES ('1 11 12 27 26 -1 10 11 12 13 13 -1 0 17');
INSERT INTO us_rules (rule) VALUES ('1 11 12 28 -1 10 11 12 13 -1 0 17');
INSERT INTO us_rules (rule) VALUES ('1 11 12 28 29 -1 10 11 12 13 13 -1 0 17');
INSERT INTO us_rules (rule) VALUES ('1 11 23 23 13 13 -1 10 11 -1 0 16');
INSERT INTO us_rules (rule) VALUES ('1 11 23 23 13 13 12 -1 10 11 12 -1 0 17');
INSERT INTO us_rules (rule) VALUES ('1 11 0 -1 10 11 13 -1 0 16');
INSERT INTO us_rules (rule) VALUES ('1 11 0 12 -1 10 11 13 12 -1 0 17');
INSERT INTO us_rules (rule) VALUES ('1 11 0 0 -1 10 11 13 13 -1 0 16');
INSERT INTO us_rules (rule) VALUES ('1 11 0 0 12 -1 10 11 13 13 12 -1 0 17');
INSERT INTO us_rules (rule) VALUES ('1 11 27 -1 10 11 13 -1 0 16');
INSERT INTO us_rules (rule) VALUES ('1 11 27 12 -1 10 11 13 12 -1 0 17');
INSERT INTO us_rules (rule) VALUES ('1 11 27 26 -1 10 11 13 13 -1 0 16');
INSERT INTO us_rules (rule) VALUES ('1 11 27 26 12 -1 10 11 13 13 12 -1 0 17');
INSERT INTO us_rules (rule) VALUES ('1 11 28 -1 10 11 13 -1 0 16');
INSERT INTO us_rules (rule) VALUES ('1 11 28 12 -1 10 11 13 12 -1 0 17');
INSERT INTO us_rules (rule) VALUES ('1 11 28 29 -1 10 11 13 13 -1 0 16');
INSERT INTO us_rules (rule) VALUES ('1 11 28 29 12 -1 10 11 13 13 12 -1 0 17');
INSERT INTO us_rules (rule) VALUES ('22 1 -1 10 10 -1 0 5');
INSERT INTO us_rules (rule) VALUES ('22 1 12 -1 10 10 12 -1 0 3');
INSERT INTO us_rules (rule) VALUES ('22 1 12 23 23 13 13 -1 10 10 12 -1 0 3');
INSERT INTO us_rules (rule) VALUES ('22 1 12 0 -1 10 10 12 13 -1 0 3');
INSERT INTO us_rules (rule) VALUES ('22 1 12 0 0 -1 10 10 12 13 13 -1 0 3');
INSERT INTO us_rules (rule) VALUES ('22 1 12 27 -1 10 10 12 13 -1 0 3');
INSERT INTO us_rules (rule) VALUES ('22 1 12 27 26 -1 10 10 12 13 13 -1 0 3');
INSERT INTO us_rules (rule) VALUES ('22 1 12 28 -1 10 10 12 13 -1 0 3');
INSERT INTO us_rules (rule) VALUES ('22 1 12 28 29 -1 10 10 12 13 13 -1 0 3');
INSERT INTO us_rules (rule) VALUES ('22 1 23 23 13 13 -1 10 10 -1 0 9');
INSERT INTO us_rules (rule) VALUES ('22 1 23 23 13 13 12 -1 10 10 12 -1 0 3');
INSERT INTO us_rules (rule) VALUES ('22 1 0 -1 10 10 13 -1 0 9');
INSERT INTO us_rules (rule) VALUES ('22 1 0 12 -1 10 10 13 12 -1 0 3');
INSERT INTO us_rules (rule) VALUES ('22 1 0 0 -1 10 10 13 13 -1 0 9');
INSERT INTO us_rules (rule) VALUES ('22 1 0 0 12 -1 10 10 13 13 12 -1 0 3');
INSERT INTO us_rules (rule) VALUES ('22 1 27 -1 10 10 13 -1 0 9');
INSERT INTO us_rules (rule) VALUES ('22 1 27 12 -1 10 10 13 12 -1 0 3');
INSERT INTO us_rules (rule) VALUES ('22 1 27 26 -1 10 10 13 13 -1 0 9');
INSERT INTO us_rules (rule) VALUES ('22 1 27 26 12 -1 10 10 13 13 12 -1 0 3');
INSERT INTO us_rules (rule) VALUES ('22 1 28 -1 10 10 13 -1 0 9');
INSERT INTO us_rules (rule) VALUES ('22 1 28 12 -1 10 10 13 12 -1 0 3');
INSERT INTO us_rules (rule) VALUES ('22 1 28 29 -1 10 10 13 13 -1 0 9');
INSERT INTO us_rules (rule) VALUES ('22 1 28 29 12 -1 10 10 13 13 12 -1 0 3');
INSERT INTO us_rules (rule) VALUES ('22 1 11 -1 10 10 11 -1 0 13');
INSERT INTO us_rules (rule) VALUES ('22 1 11 12 -1 10 10 11 12 -1 0 15');
INSERT INTO us_rules (rule) VALUES ('22 1 11 12 23 23 13 13 -1 10 10 11 12 -1 0 17');
INSERT INTO us_rules (rule) VALUES ('22 1 11 12 0 -1 10 10 11 12 13 -1 0 17');
INSERT INTO us_rules (rule) VALUES ('22 1 11 12 0 0 -1 10 10 11 12 13 13 -1 0 17');
INSERT INTO us_rules (rule) VALUES ('22 1 11 12 27 -1 10 10 11 12 13 -1 0 17');
INSERT INTO us_rules (rule) VALUES ('22 1 11 12 27 26 -1 10 10 11 12 13 13 -1 0 17');
INSERT INTO us_rules (rule) VALUES ('22 1 11 12 28 -1 10 10 11 12 13 -1 0 17');
INSERT INTO us_rules (rule) VALUES ('22 1 11 12 28 29 -1 10 10 11 12 13 13 -1 0 17');
INSERT INTO us_rules (rule) VALUES ('22 1 11 23 23 13 13 -1 10 10 11 -1 0 16');
INSERT INTO us_rules (rule) VALUES ('22 1 11 23 23 13 13 12 -1 10 10 11 12 -1 0 17');
INSERT INTO us_rules (rule) VALUES ('22 1 11 0 -1 10 10 11 13 -1 0 16');
INSERT INTO us_rules (rule) VALUES ('22 1 11 0 12 -1 10 10 11 13 12 -1 0 17');
INSERT INTO us_rules (rule) VALUES ('22 1 11 0 0 -1 10 10 11 13 13 -1 0 16');
INSERT INTO us_rules (rule) VALUES ('22 1 11 0 0 12 -1 10 10 11 13 13 12 -1 0 17');
INSERT INTO us_rules (rule) VALUES ('22 1 11 27 -1 10 10 11 13 -1 0 16');
INSERT INTO us_rules (rule) VALUES ('22 1 11 27 12 -1 10 10 11 13 12 -1 0 17');
INSERT INTO us_rules (rule) VALUES ('22 1 11 27 26 -1 10 10 11 13 13 -1 0 16');
INSERT INTO us_rules (rule) VALUES ('22 1 11 27 26 12 -1 10 10 11 13 13 12 -1 0 17');
INSERT INTO us_rules (rule) VALUES ('22 1 11 28 -1 10 10 11 13 -1 0 16');
INSERT INTO us_rules (rule) VALUES ('22 1 11 28 12 -1 10 10 11 13 12 -1 0 17');
INSERT INTO us_rules (rule) VALUES ('22 1 11 28 29 -1 10 10 11 13 13 -1 0 16');
INSERT INTO us_rules (rule) VALUES ('22 1 11 28 29 12 -1 10 10 11 13 13 12 -1 0 17');
INSERT INTO us_rules (rule) VALUES ('1 22 -1 10 10 -1 0 5');
INSERT INTO us_rules (rule) VALUES ('1 22 12 -1 10 10 12 -1 0 3');
INSERT INTO us_rules (rule) VALUES ('1 22 12 23 23 13 13 -1 10 10 12 -1 0 3');
INSERT INTO us_rules (rule) VALUES ('1 22 12 0 -1 10 10 12 13 -1 0 3');
INSERT INTO us_rules (rule) VALUES ('1 22 12 0 0 -1 10 10 12 13 13 -1 0 3');
INSERT INTO us_rules (rule) VALUES ('1 22 12 27 -1 10 10 12 13 -1 0 3');
INSERT INTO us_rules (rule) VALUES ('1 22 12 27 26 -1 10 10 12 13 13 -1 0 3');
INSERT INTO us_rules (rule) VALUES ('1 22 12 28 -1 10 10 12 13 -1 0 3');
INSERT INTO us_rules (rule) VALUES ('1 22 12 28 29 -1 10 10 12 13 13 -1 0 3');
INSERT INTO us_rules (rule) VALUES ('1 22 23 23 13 13 -1 10 10 -1 0 9');
INSERT INTO us_rules (rule) VALUES ('1 22 23 23 13 13 12 -1 10 10 12 -1 0 3');
INSERT INTO us_rules (rule) VALUES ('1 22 0 -1 10 10 13 -1 0 9');
INSERT INTO us_rules (rule) VALUES ('1 22 0 12 -1 10 10 13 12 -1 0 3');
INSERT INTO us_rules (rule) VALUES ('1 22 0 0 -1 10 10 13 13 -1 0 9');
INSERT INTO us_rules (rule) VALUES ('1 22 0 0 12 -1 10 10 13 13 12 -1 0 3');
INSERT INTO us_rules (rule) VALUES ('1 22 27 -1 10 10 13 -1 0 9');
INSERT INTO us_rules (rule) VALUES ('1 22 27 12 -1 10 10 13 12 -1 0 3');
INSERT INTO us_rules (rule) VALUES ('1 22 27 26 -1 10 10 13 13 -1 0 9');
INSERT INTO us_rules (rule) VALUES ('1 22 27 26 12 -1 10 10 13 13 12 -1 0 3');
INSERT INTO us_rules (rule) VALUES ('1 22 28 -1 10 10 13 -1 0 9');
INSERT INTO us_rules (rule) VALUES ('1 22 28 12 -1 10 10 13 12 -1 0 3');
INSERT INTO us_rules (rule) VALUES ('1 22 28 29 -1 10 10 13 13 -1 0 9');
INSERT INTO us_rules (rule) VALUES ('1 22 28 29 12 -1 10 10 13 13 12 -1 0 3');
INSERT INTO us_rules (rule) VALUES ('1 22 11 -1 10 10 11 -1 0 13');
INSERT INTO us_rules (rule) VALUES ('1 22 11 12 -1 10 10 11 12 -1 0 15');
INSERT INTO us_rules (rule) VALUES ('1 22 11 12 23 23 13 13 -1 10 10 11 12 -1 0 17');
INSERT INTO us_rules (rule) VALUES ('1 22 11 12 0 -1 10 10 11 12 13 -1 0 17');
INSERT INTO us_rules (rule) VALUES ('1 22 11 12 0 0 -1 10 10 11 12 13 13 -1 0 17');
INSERT INTO us_rules (rule) VALUES ('1 22 11 12 27 -1 10 10 11 12 13 -1 0 17');
INSERT INTO us_rules (rule) VALUES ('1 22 11 12 27 26 -1 10 10 11 12 13 13 -1 0 17');
INSERT INTO us_rules (rule) VALUES ('1 22 11 12 28 -1 10 10 11 12 13 -1 0 17');
INSERT INTO us_rules (rule) VALUES ('1 22 11 12 28 29 -1 10 10 11 12 13 13 -1 0 17');
INSERT INTO us_rules (rule) VALUES ('1 22 11 23 23 13 13 -1 10 10 11 -1 0 16');
INSERT INTO us_rules (rule) VALUES ('1 22 11 23 23 13 13 12 -1 10 10 11 12 -1 0 17');
INSERT INTO us_rules (rule) VALUES ('1 22 11 0 -1 10 10 11 13 -1 0 16');
INSERT INTO us_rules (rule) VALUES ('1 22 11 0 12 -1 10 10 11 13 12 -1 0 17');
INSERT INTO us_rules (rule) VALUES ('1 22 11 0 0 -1 10 10 11 13 13 -1 0 16');
INSERT INTO us_rules (rule) VALUES ('1 22 11 0 0 12 -1 10 10 11 13 13 12 -1 0 17');
INSERT INTO us_rules (rule) VALUES ('1 22 11 27 -1 10 10 11 13 -1 0 16');
INSERT INTO us_rules (rule) VALUES ('1 22 11 27 12 -1 10 10 11 13 12 -1 0 17');
INSERT INTO us_rules (rule) VALUES ('1 22 11 27 26 -1 10 10 11 13 13 -1 0 16');
INSERT INTO us_rules (rule) VALUES ('1 22 11 27 26 12 -1 10 10 11 13 13 12 -1 0 17');
INSERT INTO us_rules (rule) VALUES ('1 22 11 28 -1 10 10 11 13 -1 0 16');
INSERT INTO us_rules (rule) VALUES ('1 22 11 28 12 -1 10 10 11 13 12 -1 0 17');
INSERT INTO us_rules (rule) VALUES ('1 22 11 28 29 -1 10 10 11 13 13 -1 0 16');
INSERT INTO us_rules (rule) VALUES ('1 22 11 28 29 12 -1 10 10 11 13 13 12 -1 0 17');
INSERT INTO us_rules (rule) VALUES ('2 1 -1 10 10 -1 0 5');
INSERT INTO us_rules (rule) VALUES ('2 1 12 -1 10 10 12 -1 0 3');
INSERT INTO us_rules (rule) VALUES ('2 1 12 23 23 13 13 -1 10 10 12 -1 0 3');
INSERT INTO us_rules (rule) VALUES ('2 1 12 0 -1 10 10 12 13 -1 0 3');
INSERT INTO us_rules (rule) VALUES ('2 1 12 0 0 -1 10 10 12 13 13 -1 0 3');
INSERT INTO us_rules (rule) VALUES ('2 1 12 27 -1 10 10 12 13 -1 0 3');
INSERT INTO us_rules (rule) VALUES ('2 1 12 27 26 -1 10 10 12 13 13 -1 0 3');
INSERT INTO us_rules (rule) VALUES ('2 1 12 28 -1 10 10 12 13 -1 0 3');
INSERT INTO us_rules (rule) VALUES ('2 1 12 28 29 -1 10 10 12 13 13 -1 0 3');
INSERT INTO us_rules (rule) VALUES ('2 1 23 23 13 13 -1 10 10 -1 0 9');
INSERT INTO us_rules (rule) VALUES ('2 1 23 23 13 13 12 -1 10 10 12 -1 0 3');
INSERT INTO us_rules (rule) VALUES ('2 1 0 -1 10 10 13 -1 0 9');
INSERT INTO us_rules (rule) VALUES ('2 1 0 12 -1 10 10 13 12 -1 0 3');
INSERT INTO us_rules (rule) VALUES ('2 1 0 0 -1 10 10 13 13 -1 0 9');
INSERT INTO us_rules (rule) VALUES ('2 1 0 0 12 -1 10 10 13 13 12 -1 0 3');
INSERT INTO us_rules (rule) VALUES ('2 1 27 -1 10 10 13 -1 0 9');
INSERT INTO us_rules (rule) VALUES ('2 1 27 12 -1 10 10 13 12 -1 0 3');
INSERT INTO us_rules (rule) VALUES ('2 1 27 26 -1 10 10 13 13 -1 0 9');
INSERT INTO us_rules (rule) VALUES ('2 1 27 26 12 -1 10 10 13 13 12 -1 0 3');
INSERT INTO us_rules (rule) VALUES ('2 1 28 -1 10 10 13 -1 0 9');
INSERT INTO us_rules (rule) VALUES ('2 1 28 12 -1 10 10 13 12 -1 0 3');
INSERT INTO us_rules (rule) VALUES ('2 1 28 29 -1 10 10 13 13 -1 0 9');
INSERT INTO us_rules (rule) VALUES ('2 1 28 29 12 -1 10 10 13 13 12 -1 0 3');
INSERT INTO us_rules (rule) VALUES ('2 1 11 -1 10 10 11 -1 0 13');
INSERT INTO us_rules (rule) VALUES ('2 1 11 12 -1 10 10 11 12 -1 0 15');
INSERT INTO us_rules (rule) VALUES ('2 1 11 12 23 23 13 13 -1 10 10 11 12 -1 0 17');
INSERT INTO us_rules (rule) VALUES ('2 1 11 12 0 -1 10 10 11 12 13 -1 0 17');
INSERT INTO us_rules (rule) VALUES ('2 1 11 12 0 0 -1 10 10 11 12 13 13 -1 0 17');
INSERT INTO us_rules (rule) VALUES ('2 1 11 12 27 -1 10 10 11 12 13 -1 0 17');
INSERT INTO us_rules (rule) VALUES ('2 1 11 12 27 26 -1 10 10 11 12 13 13 -1 0 17');
INSERT INTO us_rules (rule) VALUES ('2 1 11 12 28 -1 10 10 11 12 13 -1 0 17');
INSERT INTO us_rules (rule) VALUES ('2 1 11 12 28 29 -1 10 10 11 12 13 13 -1 0 17');
INSERT INTO us_rules (rule) VALUES ('2 1 11 23 23 13 13 -1 10 10 11 -1 0 16');
INSERT INTO us_rules (rule) VALUES ('2 1 11 23 23 13 13 12 -1 10 10 11 12 -1 0 17');
INSERT INTO us_rules (rule) VALUES ('2 1 11 0 -1 10 10 11 13 -1 0 16');
INSERT INTO us_rules (rule) VALUES ('2 1 11 0 12 -1 10 10 11 13 12 -1 0 17');
INSERT INTO us_rules (rule) VALUES ('2 1 11 0 0 -1 10 10 11 13 13 -1 0 16');
INSERT INTO us_rules (rule) VALUES ('2 1 11 0 0 12 -1 10 10 11 13 13 12 -1 0 17');
INSERT INTO us_rules (rule) VALUES ('2 1 11 27 -1 10 10 11 13 -1 0 16');
INSERT INTO us_rules (rule) VALUES ('2 1 11 27 12 -1 10 10 11 13 12 -1 0 17');
INSERT INTO us_rules (rule) VALUES ('2 1 11 27 26 -1 10 10 11 13 13 -1 0 16');
INSERT INTO us_rules (rule) VALUES ('2 1 11 27 26 12 -1 10 10 11 13 13 12 -1 0 17');
INSERT INTO us_rules (rule) VALUES ('2 1 11 28 -1 10 10 11 13 -1 0 16');
INSERT INTO us_rules (rule) VALUES ('2 1 11 28 12 -1 10 10 11 13 12 -1 0 17');
INSERT INTO us_rules (rule) VALUES ('2 1 11 28 29 -1 10 10 11 13 13 -1 0 16');
INSERT INTO us_rules (rule) VALUES ('2 1 11 28 29 12 -1 10 10 11 13 13 12 -1 0 17');
INSERT INTO us_rules (rule) VALUES ('1 2 -1 10 10 -1 0 5');
INSERT INTO us_rules (rule) VALUES ('1 2 12 -1 10 10 12 -1 0 3');
INSERT INTO us_rules (rule) VALUES ('1 2 12 23 23 13 13 -1 10 10 12 -1 0 3');
INSERT INTO us_rules (rule) VALUES ('1 2 12 0 -1 10 10 12 13 -1 0 3');
INSERT INTO us_rules (rule) VALUES ('1 2 12 0 0 -1 10 10 12 13 13 -1 0 3');
INSERT INTO us_rules (rule) VALUES ('1 2 12 27 -1 10 10 12 13 -1 0 3');
INSERT INTO us_rules (rule) VALUES ('1 2 12 27 26 -1 10 10 12 13 13 -1 0 3');
INSERT INTO us_rules (rule) VALUES ('1 2 12 28 -1 10 10 12 13 -1 0 3');
INSERT INTO us_rules (rule) VALUES ('1 2 12 28 29 -1 10 10 12 13 13 -1 0 3');
INSERT INTO us_rules (rule) VALUES ('1 2 23 23 13 13 -1 10 10 -1 0 9');
INSERT INTO us_rules (rule) VALUES ('1 2 23 23 13 13 12 -1 10 10 12 -1 0 3');
INSERT INTO us_rules (rule) VALUES ('1 2 0 -1 10 10 13 -1 0 9');
INSERT INTO us_rules (rule) VALUES ('1 2 0 12 -1 10 10 13 12 -1 0 3');
INSERT INTO us_rules (rule) VALUES ('1 2 0 0 -1 10 10 13 13 -1 0 9');
INSERT INTO us_rules (rule) VALUES ('1 2 0 0 12 -1 10 10 13 13 12 -1 0 3');
INSERT INTO us_rules (rule) VALUES ('1 2 27 -1 10 10 13 -1 0 9');
INSERT INTO us_rules (rule) VALUES ('1 2 27 12 -1 10 10 13 12 -1 0 3');
INSERT INTO us_rules (rule) VALUES ('1 2 27 26 -1 10 10 13 13 -1 0 9');
INSERT INTO us_rules (rule) VALUES ('1 2 27 26 12 -1 10 10 13 13 12 -1 0 3');
INSERT INTO us_rules (rule) VALUES ('1 2 28 -1 10 10 13 -1 0 9');
INSERT INTO us_rules (rule) VALUES ('1 2 28 12 -1 10 10 13 12 -1 0 3');
INSERT INTO us_rules (rule) VALUES ('1 2 28 29 -1 10 10 13 13 -1 0 9');
INSERT INTO us_rules (rule) VALUES ('1 2 28 29 12 -1 10 10 13 13 12 -1 0 3');
INSERT INTO us_rules (rule) VALUES ('1 2 11 -1 10 10 11 -1 0 13');
INSERT INTO us_rules (rule) VALUES ('1 2 11 12 -1 10 10 11 12 -1 0 15');
INSERT INTO us_rules (rule) VALUES ('1 2 11 12 23 23 13 13 -1 10 10 11 12 -1 0 17');
INSERT INTO us_rules (rule) VALUES ('1 2 11 12 0 -1 10 10 11 12 13 -1 0 17');
INSERT INTO us_rules (rule) VALUES ('1 2 11 12 0 0 -1 10 10 11 12 13 13 -1 0 17');
INSERT INTO us_rules (rule) VALUES ('1 2 11 12 27 -1 10 10 11 12 13 -1 0 17');
INSERT INTO us_rules (rule) VALUES ('1 2 11 12 27 26 -1 10 10 11 12 13 13 -1 0 17');
INSERT INTO us_rules (rule) VALUES ('1 2 11 12 28 -1 10 10 11 12 13 -1 0 17');
INSERT INTO us_rules (rule) VALUES ('1 2 11 12 28 29 -1 10 10 11 12 13 13 -1 0 17');
INSERT INTO us_rules (rule) VALUES ('1 2 11 23 23 13 13 -1 10 10 11 -1 0 16');
INSERT INTO us_rules (rule) VALUES ('1 2 11 23 23 13 13 12 -1 10 10 11 12 -1 0 17');
INSERT INTO us_rules (rule) VALUES ('1 2 11 0 -1 10 10 11 13 -1 0 16');
INSERT INTO us_rules (rule) VALUES ('1 2 11 0 12 -1 10 10 11 13 12 -1 0 17');
INSERT INTO us_rules (rule) VALUES ('1 2 11 0 0 -1 10 10 11 13 13 -1 0 16');
INSERT INTO us_rules (rule) VALUES ('1 2 11 0 0 12 -1 10 10 11 13 13 12 -1 0 17');
INSERT INTO us_rules (rule) VALUES ('1 2 11 27 -1 10 10 11 13 -1 0 16');
INSERT INTO us_rules (rule) VALUES ('1 2 11 27 12 -1 10 10 11 13 12 -1 0 17');
INSERT INTO us_rules (rule) VALUES ('1 2 11 27 26 -1 10 10 11 13 13 -1 0 16');
INSERT INTO us_rules (rule) VALUES ('1 2 11 27 26 12 -1 10 10 11 13 13 12 -1 0 17');
INSERT INTO us_rules (rule) VALUES ('1 2 11 28 -1 10 10 11 13 -1 0 16');
INSERT INTO us_rules (rule) VALUES ('1 2 11 28 12 -1 10 10 11 13 12 -1 0 17');
INSERT INTO us_rules (rule) VALUES ('1 2 11 28 29 -1 10 10 11 13 13 -1 0 16');
INSERT INTO us_rules (rule) VALUES ('1 2 11 28 29 12 -1 10 10 11 13 13 12 -1 0 17');
INSERT INTO us_rules (rule) VALUES ('6 0 -1 4 5 -1 2 17');
INSERT INTO us_rules (rule) VALUES ('6 0 3 -1 4 5 3 -1 2 17');
INSERT INTO us_rules (rule) VALUES ('0 6 0 -1 1 4 5 -1 1 17');
INSERT INTO us_rules (rule) VALUES ('0 6 0 3 -1 1 4 5 3 -1 1 17');
INSERT INTO us_rules (rule) VALUES ('6 -1 5 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('6 3 -1 5 3 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('22 6 -1 2 5 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('22 6 3 -1 2 5 3 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('3 6 -1 3 5 -1 2 9');
INSERT INTO us_rules (rule) VALUES ('0 6 -1 4 5 -1 1 9');
INSERT INTO us_rules (rule) VALUES ('0 6 3 -1 4 5 3 -1 1 9');
INSERT INTO us_rules (rule) VALUES ('0 22 6 -1 4 2 5 -1 1 9');
INSERT INTO us_rules (rule) VALUES ('0 22 6 3 -1 4 2 5 3 -1 1 9');
INSERT INTO us_rules (rule) VALUES ('0 3 6 -1 4 3 5 -1 1 9');
INSERT INTO us_rules (rule) VALUES ('0 3 1 2 -1 1 3 5 6 -1 1 17');
INSERT INTO us_rules (rule) VALUES ('0 3 1 2 22 -1 1 3 5 6 7 -1 1 17');
INSERT INTO us_rules (rule) VALUES ('0 1 6 -1 1 5 5 -1 1 9');
INSERT INTO us_rules (rule) VALUES ('-1');

-- needed so entries added by users will default to custom
ALTER TABLE us_rules ALTER COLUMN is_custom SET DEFAULT true;
