% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_functions.r
\name{interaction-plot}
\alias{interaction-plot}
\alias{interaction_plot}
\title{Two-way interaction plot}
\usage{
interaction_plot(.data, .formula, interval = "conf.int")
}
\arguments{
\item{.data}{A data frame}

\item{.formula}{A formula of the form \code{y ~ x1 + x2}}

\item{interval}{Either \code{conf.int}, \code{boxplot} or \code{none}}
}
\description{
Plots the mean of the response for
two-way combinations of factors, thereby illustrating possible
interactions.
}
\note{
This is a recent addition to the package and is subject to change.
}
\examples{

income$educf <- cut(income$educ, breaks=3)
income |> interaction_plot(inc ~ race + educf)
income |> interaction_plot(inc ~ race + educf, interval="conf.int")
income |> interaction_plot(inc ~ race + educf, interval="boxplot")
income |> interaction_plot(inc ~ race + educf, interval="none")

}
