% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linest_matrix.R
\name{linest-matrix}
\alias{linest-matrix}
\alias{LE_matrix}
\alias{LE_matrix.default}
\alias{aggregate_linest_list}
\alias{get_linest_list}
\title{Linear estimates matrix}
\usage{
LE_matrix(object, effect = NULL, at = NULL)

\method{LE_matrix}{default}(object, effect = NULL, at = NULL)

aggregate_linest_list(linest_list)

get_linest_list(object, effect = NULL, at = NULL)
}
\arguments{
\item{object}{Model object}

\item{effect}{A vector of variables. For each configuration of
these the estimate will be calculated.}

\item{at}{Either NULL, a list or a dataframe. 1) If a list, then the list
must consist of covariates (including levels of some factors)
to be used in the calculations. 2) If a dataframe, the
dataframe is split rowwise and the function is invoked on each
row.}

\item{linest_list}{Linear estimate list (as generated by \code{get_linest_list}).}
}
\description{
Generate matrix specifying linear estimate.
}
\details{
Check this
}
\examples{

## Two way anova:

data(warpbreaks)

## An additive model
m0 <- lm(breaks ~ wool + tension, data=warpbreaks)

## Estimate mean for each wool type, for tension="M":
K <- LE_matrix(m0, at=list(wool=c("A", "B"), tension="M"))
K

## Vanilla computation:
K \%*\% coef(m0)

## Alternative; also providing standard errors etc:
linest(m0, K)
esticon(m0, K)

## Estimate mean for each wool type when averaging over tension;
# two ways of doing this
K <- LE_matrix(m0, at=list(wool=c("A", "B")))
K
K <- LE_matrix(m0, effect="wool")
K
linest(m0, K)

## The linear estimate is sometimes called to "least squares mean"
# (LSmeans) or popupulation means.
# Same as
LSmeans(m0, effect="wool")

## Without mentioning 'effect' or 'at' an average across all
#predictors are calculated:
K <- LE_matrix(m0)
K
linest(m0, K)

## Because the design is balanced (9 observations per combination
#of wool and tension) this is the same as computing the average. If
#the design is not balanced, the two quantities are in general not
#the same.
mean(warpbreaks$breaks)

## Same as 
LSmeans(m0)

## An interaction model 
m1 <- lm(breaks ~ wool * tension, data=warpbreaks)

K <- LE_matrix(m1, at=list(wool=c("A", "B"), tension="M"))
K
linest(m1, K)
K <- LE_matrix(m1, at=list(wool=c("A", "B")))
K
linest(m1, K)
K <- LE_matrix(m1, effect="wool")
K
linest(m1, K)
LSmeans(m1, effect="wool")

K <- LE_matrix(m1)
K
linest(m1, K)
LSmeans(m1)
}
\seealso{
\code{\link{LSmeans}}, \code{\link{linest}}
}
\keyword{utilities}
