% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sequence_utilities.R
\name{time_since_event}
\alias{time_since_event}
\alias{timeSinceEvent}
\title{Calculate "time since event" in a vector}
\usage{
time_since_event(yvar, tvar = seq_along(yvar))

timeSinceEvent(...)
}
\arguments{
\item{yvar}{A numeric or logical vector indicating events.}

\item{tvar}{An optional numeric vector specifying time values. Defaults to the index.}

\item{...}{Arguments pased on to time_since_event}
}
\value{
A data frame with columns 'yvar', 'tvar', 'abs.tse' (absolute time since event),
'sign.tse' (signed time since event), and other helper columns.
}
\description{
Calculates the time since the nearest event in a sequence,
optionally using a custom time scale.
}
\details{
Events are coded as 1 (or TRUE). Non-events are anything else. The
result includes absolute and signed distances to events.
}
\examples{

## Example 1: Basic usage with default time index
y <- c(0, 0, 1, 0, 0, 1, 0)
tse <- time_since_event(y)
print(tse)

## Example 2: Custom (non-integer) time variable
y <- c(0, 0, 1, 0, 0, 0, 1, 0)
t <- seq(0.5, 3.5, length.out = length(y))
tse <- time_since_event(y, t)
print(tse)

## Example 3: Plotting the signed time since event
plot(sign.tse ~ tvar, data = tse, type = "b",
     main = "Signed time since event",
     xlab = "Time", ylab = "Signed time since event")
grid()
abline(h = 0, col = "red", lty = 2)

}
\seealso{
\code{\link{subSeq}}, \code{\link{rle}}
}
\author{
Søren Højsgaard, \email{sorenh@math.aau.dk}
}
