# Generators are not automatically loaded by Rails
require 'generators/rspec/helper/helper_generator'
require 'support/generators'

RSpec.describe Rspec::Generators::HelperGenerator, type: :generator do
  setup_default_destination

  subject(:helper_spec) { file('spec/helpers/posts_helper_spec.rb') }

  describe 'generated by default' do
    before do
      run_generator %w[posts]
    end

    it 'includes the standard boilerplate' do
      expect(helper_spec).to contain(/require 'rails_helper'/).and(contain(/^RSpec.describe PostsHelper, #{type_metatag(:helper)}/))
    end
  end

  describe 'skipped with a flag' do
    before do
      run_generator %w[posts --no-helper_specs]
    end

    it 'does not create the helper spec' do
      expect(File.exist?(helper_spec)).to be false
    end
  end
end
