A `#[simd]` attribute was applied to an empty or multi-field struct.

Erroneous code examples:

```compile_fail,E0075
#![feature(repr_simd)]

#[repr(simd)]
struct Bad; // error!
```

```compile_fail,E0075
#![feature(repr_simd)]

#[repr(simd)]
struct Bad([u32; 1], [u32; 1]); // error!
```

The `#[simd]` attribute can only be applied to a single-field struct, because
the one field must be the array of values in the vector.

Fixed example:

```
#![feature(repr_simd)]

#[repr(simd)]
struct Good([u32; 2]); // ok!
```
