#!/bin/bash

# This script intents to generate c++ code needed to init
# structures dealing with Font Awesome icons.
# Its first parameter is the font awesome dir path
# after extracting files from a fontawesome downladable zip archive,
# the second is the generated cpp file which must be copied as
# library/tulip-ogl/src/TulipInitFontAwesome.cpp.
# The files fa-[brands-400|regular-400|solid-900].[ttf|woff2] from
# the webfonts sub directory must be copied in library/tulip-ogl/bitmaps.

FA_DIR=$1
CPP_FILE=$(realpath $2)

cd $FA_DIR
FA_VERSION=$(grep 'Font Awesome Free' css/all.css | awk -F ' ' '{print $5}')
(echo "// Warning: do not update this file !!!";
 echo "// It was automatically generated by utils/scripts/generate_fa_cpp_init_code.sh";
 echo "// from Font Awesome icons version ${FA_VERSION}";
 echo;
 echo "std::string TulipFontAwesome::getVersion() {"
 echo "  return \"${FA_VERSION}\";";
 echo "}";
 echo;
 echo "static void initIconCodePoints() {";
 for FONT in solid regular brands
 do
   grep '"],' js/$FONT.js | awk -F ']' '{sub(/\[/, "");sub(/\[.*/, "", $1); print}'| awk -F '"' "{printf \"  addIconCodePoint(\\\"fa${FONT:0:1}-%s\\\", 0x%s);\n\", \$2, \$4}"
 done
 echo;
 echo "  iconsNames.reserve(iconCodePoint.size());";
 echo;
 echo "  for (const auto &it : iconCodePoint) {";
 echo "    iconsNames.emplace_back(it.first);";
 echo "  }";
 echo "}") > ${CPP_FILE}

