/*
 * Copyright (C) 2019 Tianjin KYLIN Information Technology Co., Ltd.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU  Lesser General Public License as published by
 * the Free Software Foundation; either version 2.1, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/&gt;.
 *
 */

#ifndef CALENDARWIDGET_H
#define CALENDARWIDGET_H
#include <QFrame>
#include <QGSettings/QGSettings>
#include <QTimer>
#include <QEvent>
#include <QTranslator>
#include "../panel/common/ukuigridlayout.h"
#include "../panel/iukuipanelplugin.h"
#include "../panel/common/ukuisettings.h"
#include "../panel/pluginsettings.h"
#include "../panel/ukuipanel.h"
#include "../panel/common_fun/listengsettings.h"
#include "lunarcalendarwidget/frmlunarcalendarwidget.h"
#include "calendarbutton.h"
#include "ukuiwebviewdialog.h"
#include "lunarcalendarwidget/lunarcalendarwidget.h"

extern UkuiWebviewDialogStatus status;
class UKUICalendarWidget:public QWidget
{
    Q_OBJECT
public:
    UKUICalendarWidget(IUKUIPanelPlugin *plugin, QWidget* parent = 0);
    ~UKUICalendarWidget();
    void realign();
    void changeWidowpos(bool restore = false);
private:
    void translator();
protected:
private:
    IUKUIPanelPlugin *m_plugin;
    QWidget *m_parent;
    QHBoxLayout *m_layout;
    frmLunarCalendarWidget *m_frmLunarWidget;
    CalendarButton *m_calendarButton;
    LunarCalendarWidget *m_widget;
};

#endif // CALENDARWIDGET_H
