
package ONVIF::Device::Elements::SetNetworkDefaultGateway;
use strict;
use warnings;

{ # BLOCK to scope variables

sub get_xmlns { 'http://www.onvif.org/ver10/device/wsdl' }

__PACKAGE__->__set_name('SetNetworkDefaultGateway');
__PACKAGE__->__set_nillable();
__PACKAGE__->__set_minOccurs();
__PACKAGE__->__set_maxOccurs();
__PACKAGE__->__set_ref();

use base qw(
    SOAP::WSDL::XSD::Typelib::Element
    SOAP::WSDL::XSD::Typelib::ComplexType
);

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %IPv4Address_of :ATTR(:get<IPv4Address>);
my %IPv6Address_of :ATTR(:get<IPv6Address>);

__PACKAGE__->_factory(
    [ qw(        IPv4Address
        IPv6Address

    ) ],
    {
        'IPv4Address' => \%IPv4Address_of,
        'IPv6Address' => \%IPv6Address_of,
    },
    {
        'IPv4Address' => 'ONVIF::Device::Types::IPv4Address',
        'IPv6Address' => 'ONVIF::Device::Types::IPv6Address',
    },
    {

        'IPv4Address' => 'IPv4Address',
        'IPv6Address' => 'IPv6Address',
    }
);

} # end BLOCK







} # end of BLOCK



1;


=pod

=head1 NAME

ONVIF::Device::Elements::SetNetworkDefaultGateway

=head1 DESCRIPTION

Perl data type class for the XML Schema defined element
SetNetworkDefaultGateway from the namespace http://www.onvif.org/ver10/device/wsdl.







=head1 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * IPv4Address

 $element->set_IPv4Address($data);
 $element->get_IPv4Address();




=item * IPv6Address

 $element->set_IPv6Address($data);
 $element->get_IPv6Address();





=back


=head1 METHODS

=head2 new

 my $element = ONVIF::Device::Elements::SetNetworkDefaultGateway->new($data);

Constructor. The following data structure may be passed to new():

 {
   IPv4Address => $some_value, # IPv4Address
   IPv6Address => $some_value, # IPv6Address
 },

=head1 AUTHOR

Generated by SOAP::WSDL

=cut

